! GConsole :   Diagnostic Console for GWindows
!
! Include GConsole between gwindefs and gwindows to install the diagnostic
! console. Almost every operation GWindows performs will generate a message
! explaining what's going on. These messages can be used to trace faults in
! GWindows programs.  Messages generated by GWindows will be tagged
! with a label such as [GWindows] to indicate the originating module
! (Typically, [GWindows] for messages generated by the GWindows engine, or
! [WidgetName] for messages generated by a widget.)
!
! To produce your own diagnostic messages, the GConsole provides the
! following functions:
!
! GConsole.write(x);    Write any printable to the GConsole
!
! GConsole.penon();     Switches Glk output into GConsole-mode. Any print
! GConsole.penoff();    or PrintAnything statements between a penon and penoff
!                       will be directed to the console; useful for loops or
!                       using printing operators such as (name) x, etc.
!                       (note: an intervening glk_set_window will
!                       take control away from the GConsole.)
!
!
! If GCONSOLE_PAUSE is defined before inclusion and has a non-zero value,
! the console will wait for a keypress between each message.
! This may be helpful in detecting the exact location of a fault, but
! may also interfere with some character-handling operations.

default USE_GCONSOLE 0;
Include "gcore";
GWin_Module "GConsole" with number "1.0";

object GConsole
 with winid 0,
      number 0,
      write [s;
                self.penon();
                printanything(s);
                self.penoff();
            ],
     penon [;
        if (self.winid==0)
        {
         @setiosys 0 0;
         self.number=-1;
         return;
        }
        if (self.number~=0)
         "[GConsole]: Attempt to activate console while console is already active.";
        self.number=glk_stream_get_current();
        if (self.number==0) give self on;
        else give self ~on;
        glk_set_window(self.winid);
        ],
      penoff [;
        if (self.number==-1)
        {
         @setiosys 2 0;
         self.number=0;
         return;
        }
        if (self.number==0)
          { if (self hasnt on)
           self.write("[GConsole]: Attempt to deactivate console while console is not active.");
           }
        else
        {
         glk_stream_set_current(self.number);
         self.number=0;
        }
#ifdef GCONSOLE_PAUSE;
if (GCONSOLE_PAUSE >0) {
        glk_request_char_event(self.winid);
        glk_select(GG_ARGUMENTS);
!        if (self.winid~=GG_ARGUMENTS-->1) handleGlkEvent(gg_arguments,0,0);
}
#endif;
],
wait [;
        glk_request_char_event(self.winid);
        glk_select(GG_ARGUMENTS);
        ];



