!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.10.19 ORLibraryMessages [Z,GLULX]
! Created by Jim Fisher
! This module allows for library messages to be defined in multiple places or files.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep:	ORRoutinesList
!			ORObjectInitialise
!--------------------------------------------------------------------------------------
! ORLibDev: Note, that this module offers only a little usefulness as a library 
!     extension alone.  By itself it provides no new functionality for the IF developer. 
!     Instead it provides a basis for other module to be built upon and will primarily 
!     be useful to those who are developing ORLibrary entrys of their own.
!--------------------------------------------------------------------------------------
! This module is an interface for ORLibrary developers.  Although it is certainly 
! usable as an alternate method for redefining Library Messages (as opposed to
! defining a LibraryMessages object), that is not really its intent.  One of the 
! difficulties faced when defining a library of pluggable modules (such as ORLib) is
! involved in redefining Library Messages.  The OREnglish file was used to make massive
! code changes, but in the absence of NPCs that act or a Person/Tense change in the 
! narative, the changes to OREnglish are, by design, invisible.  The language definition
! file simply isn't the appropriate location for library module message changes. The 
! standard library supports the LibraryMessages object for this.
!
! Still, when a module adds functionality, it is often necessary to change the default 
! messages, but defining the LibraryMessages object in a module is wrought with 
! issues.  Further, it would prevent the developer from being able to define his/her 
! own.  The ORLibraryMessages module circumvents this issue.  Modules can redefine any 
! number of messages and these will replace those define in the Language Definition 
! File, yet the developer will still be able to override this with a LibraryMessages 
! object.
! 
! To create message overrides which, are themselves overridable, simply declare one or
! more ORLibMessage objects and provide a property routine for each named 'body' which 
! print the desired message based on action and the lm_n, lm_o values. The following is
! an example:
!
!	ORLibMessage with body[;
!				ThrowAt: "No, you decide instead to keep ",
!					(the)lm_n,".";
!				Jump: "You legs are too short to jump.";
!		];
!
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORLibraryMessages";					!Constant USE_ORLibraryMessages; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORLibraryMessages; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.01.01	Initial Creation
! 2002.02.11	Verified GLULX support
! 2002.02.26	Fit to new template
! 2002.10.13	Moved ORLibMessage class definition to the REPLACE section so that it 
!				can be used in early sections of other modules.
! 2002.10.19	mild code rearranging to resolve compatibility issues.
!--------------------------------------------------------------------------------------
#ifdef USE_ORLibraryMessages;message "          Processing library extension ORLibraryMessages...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORLibraryMessages_DONEREPLACE; constant ORLibraryMessages_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORLibraryMessages_DONEMESSAGE; constant ORLibraryMessages_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORLibraryMessages requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	class ORLibMessage
		with	object_initialise[;
					__ORLibraryMessages.add_routine(self.body);
				]
		,		body 0;

	#ifndef LibraryMessages; object LibraryMessages with before[;rfalse;]; #endif;

	ORRoutinesList __ORLibraryMessages
		with object_initialise[;
					self.routine_holder=LibraryMessages.&before-->0;
					LibraryMessages.&before-->0=__CallORLibraryMessages;
				]
		,	routines 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
		,	routine_holder 0
	;
	[__CallORLibraryMessages;
		if(__ORLibraryMessages.routine_holder()~=true) return __ORLibraryMessages.run_until(true);
		rtrue;
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORLibraryMessages_DONECODE;constant ORLibraryMessages_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORLibraryMessages_DONEGRAMMAR; constant ORLibraryMessages_DONEGRAMMAR; #ifdef ORLibraryMessages_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;