!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.08.03 ORExits
! Implements the "Exits" verb functionality.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! Implements the "Exits" verb as well as a standalone routine for which does the 
! same thing DescribeExits().
!--------------------------------------------------------------------------------------
! AutoDep:	None.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORExits; #include "ORExits"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORExits; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2003.02.01	Initial Creation
! 2003.02.16	Added new property "exits_text" to override the calculated response.
! 2003.02.19	Added better ifdef for self docs
! 2003.03.14	Modifications allowing containers (parent objects) to define the 
!				exits_text property.
! 2003.08.03	Added a line feed following the exits text.
!--------------------------------------------------------------------------------------
#ifdef USE_ORExits;message "          Processing library extension ORExits...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORExits_DONEREPLACE; constant ORExits_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORExits_DONEMESSAGE; constant ORExits_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORExits requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORExits_DONECODE;constant ORExits_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	[DescribeExits qualifier ignoreexits_text count d save plurality;
		if(parent(actor) provides exits_text && parent(actor).exits_text~=0 && ignoreexits_text==false){
			printorrun(parent(actor),exits_text,true); !--true, suppress new_line
			return;
		}
		count=0;
		objectloop(d in compass) if(metaclass(location.(d.door_dir))==object) count++;
		if(count==0) {
			print "There",(string)ARE__TX," no obvious exits from ",(ig)ppf("t","",""),"here.";
			return;
		}
		if(count>1) plurality=-1; else plurality=0; !--zero==singular
		print "The only exit";
		if(plurality~=0) print"s";
		print " ";
		if(qualifier~=0) print (string)qualifier;
		print(ig)vrb(plurality,"lay","lie");
		save=count;
		objectloop(d in compass) if(metaclass(location.(d.door_dir))==object) {
			if(count<save && save>2) print ",";
			if(count==1 && plurality~=0) print " and";
			print" ",(LanguageDirection)(d.door_dir);
			count--;					
		}
		print ".^";
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORExits_DONEGRAMMAR; constant ORExits_DONEGRAMMAR; #ifdef ORExits_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------
	Verb 'exits' * -> Exits;
	[ExitsSub;
		if(RunRoutines(actors_location,before)~=0) rtrue;
		DescribeExits();
		print "^";
	];
#ifdef ORMenuCatch;
	!--Commands, document thyselves.
	ORMenu ORHelpExits "Exits" with text "The EXITS command will usually list all obvious exits for the current location."
	,	object_initialise[;	if(ORMenuCatch~=0) move self to ORMenuCatch; ]
	;
#endif;
	object with exits_text;
!--------------------------------------------------------------------------------------
#endif; #endif; #endif;