!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.01.31 OREntryPoints
! Definition of common entry points so that multiple definitions can work together.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! A more detailed description of this file, what it does, and how to use it goes here.
!
!--------------------------------------------------------------------------------------
! AutoDep:	ORObjectInitialise
!			ORRoutineList
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_OREntryPoints; #include "OREntryPoints"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_OREntryPoints; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.08.31	Initial Creation
! 2002.09.08	Fixed issue with beforeparsing calling parsenoun object.
! 2002.10.13	1) Created a reference to the chooseobject property to avoid errors when
!					it is not used by the developer. 
!				2) Fixed reference to ParseNoun from within UnknownVerb code. 
!				3) Fixed issue with ParseNoun return when no ParseNoun routines have been
!					registered.
! 2003.01.25	Modified the structure of the call to ChooseObjects to better suite its
!				definition in the DM4.
! 2003.01.31	Added AfterPrompt.
! 2003.03.01	Fixed problem with nested if's in chooseobjects functionality.
!--------------------------------------------------------------------------------------
#ifdef USE_OREntryPoints;message "          Processing library extension OREntryPoints...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
	#ifndef USE_ORRoutinesList; Constant USE_ORRoutinesList; message "          ****Forcing inclusion of ORRoutinesList****"; #include "ORRoutinesList"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef OREntryPoints_DONEREPLACE; constant OREntryPoints_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef OREntryPoints_DONEMESSAGE; constant OREntryPoints_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! OREntryPoints requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef OREntryPoints_DONECODE;constant OREntryPoints_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------

!-- - - - - - - - - - - - - - - - - - - - - - - - - - -
#ifndef BeforeParsing; message "               --BeforeParsing...Implemented";
	ORRoutinesList ORBeforeParsing
		with routines 0 0 0 0 0  
		,	save_wn 0 !--save the wn variable
		,	between_calls[; wn=self.save_wn;]
	;
	[BeforeParsing obj rv;
		ORBeforeParsing.save_wn=wn;
		rv=ORBeforeParsing.run_until(true,obj);
		wn=ORBeforeParsing.save_wn;
		return rv;
	];
#ifnot; message "               --BeforeParsing...Already defined. NOT IMPLEMENTING."; #endif;
!-- - - - - - - - - - - - - - - - - - - - - - - - - - -
#ifndef ChooseObjects; message "               --ChooseObjects...Implemented";
	ORRoutinesList ORChooseObjects with routines 0 0 0 0 0,	chooseobject;
	[ChooseObjects obj code retval;
		retval=0; if(code==2) retval=1; !--default to 0 if testing against "All" or 1 if asking for assistance
		if(obj provides chooseobject) retval=obj.chooseobject(code); !--check object for routine first...
		if(code<2){
			if(retval==0) retval=ORChooseObjects.run_until_not(0,obj,code); !--check "all" routines until something actually returns a real value...
		}else{
			if(retval==1) retval=ORChooseObjects.run_until_not(1,obj,code); !--check "assistance" routines until something actually returns a real value...
		}
		return retval;
];
#ifnot; message "               --ChooseObjects...Already defined. NOT IMPLEMENTING."; #endif;
!-- - - - - - - - - - - - - - - - - - - - - - - - - - -
#ifndef ParseNoun; message "               --ParseNoun...Implemented";
	ORRoutinesList ORParseNoun
		with routines 0 0 0 0 0  
		,	save_wn 0 !--save the wn variable
		,	between_calls[; wn=self.save_wn;]
	;
	[ParseNoun obj;
		if(ORParseNoun.count_routines()==0) return -1;
		ORParseNoun.save_wn=wn;
		return ORParseNoun.run_until_not(-1,obj);
	];
#ifnot; message "               --ParseNoun...Already defined. NOT IMPLEMENTING."; #endif;
!-- - - - - - - - - - - - - - - - - - - - - - - - - - -
#ifndef UnknownVerb; message "               --UnknownVerb...Implemented";
	ORRoutinesList ORUnknownVerb with routines 0 0 0 0 0;
	[UnknownVerb obj; return ORUnknownVerb.run_until_not(false,obj); ];
#ifnot; message "               --UnknownVerb...Already defined. NOT IMPLEMENTING."; #endif;
!-- - - - - - - - - - - - - - - - - - - - - - - - - - -
#ifndef AfterPrompt; message "               --AfterPrompt...Implemented";
	ORRoutinesList ORAfterPrompt with routines 0 0 0 0 0;
	[AfterPrompt; return ORAfterPrompt.run_until(true); ];
#ifnot; message "               --AfterPrompt...Already defined. NOT IMPLEMENTING."; #endif;
!-- - - - - - - - - - - - - - - - - - - - - - - - - - -
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef OREntryPoints_DONEGRAMMAR; constant OREntryPoints_DONEGRAMMAR; #ifdef OREntryPoints_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;

!-- AfterLife       0;
!-- AfterPrompt     0;
!-- Amusing         0;
!-------- BeforeParsing
!-------- ChooseObjects 
!-- DarkToDark      0;
!-- DeathMessage    0;
!-- GamePostRoutine 0;
!-- GamePreRoutine  0;
!-- InScope         1;
!-- LookRoutine     0;
!-- NewRoom         0;
!-------- ParseNoun
!-- ParseNumber     2;
!-- ParserError     1;
!-- PrintRank
!-- PrintTaskName   1;
!-- PrintVerb       1;
!-- TimePasses      0;
!-------- UnknownVerb

!-- #ifdef TARGET_GLULX;
	!-- HandleGlkEvent  2;
	!-- IdentifyGlkObject 4;
	!-- InitGlkWindow   1;
!-- #endif; ! TARGET_GLULX
