/* ------------------------------------------------------------------------- */
/*   Header file for Inform:  Infocom game ("Z-code") compiler               */
/*   (should be #included in the others)                                     */
/*                                                                           */
/*   Release 5                                                               */
/*                                                                           */
/*   (c) Graham Nelson, 1993/4                                               */
/*   A manual for this language is available from the if-archive at          */
/*   ftp.gmd.de.                                                             */
/*   Please read the legal note below.                                       */
/* ------------------------------------------------------------------------- */

#define RELEASE_STRING "Release 5 (June 11th 1994)"
#define RELEASE_NUMBER 1259

/* ------------------------------------------------------------------------- */
/*   Our machine for today is...                                             */
/*                                                                           */
/*   [ Inform should compile (possibly with warnings) and work safely        */
/*     if you just:                                                          */
/*                                                                           */
/*     #define AMIGA       -  for the Commodore Amiga under SAS/C            */
/*     #define ARCHIMEDES  -  for the Acorn Archimedes under Norcroft C      */
/*     #define ATARIST     -  for the Atari ST                               */
/*     #define LINUX       -  for Linux under gcc (essentially as Unix)      */
/*     #define MACINTOSH   -  for the Apple Macintosh under Think C          */
/*     #define OS2         -  for OS/2 32-bit mode under IBM's C Set++       */
/*     #define PC          -  for 386+ IBM PCs, eg. Microsoft Visual C/C++   */
/*     #define PC_QUICKC   -  for small IBM PCs under QuickC                 */
/*     #define UNIX        -  for Unix under gcc (or big IBM PC under djgpp) */
/*     #define VAX         -  for VAX mainframes under Digital's VAX C       */
/*                                                                           */
/*     See the notes below.  Executables may already be available by ftp.]   */
/*                                                                           */
/*   (If no machine is defined, then cautious #defines will be made.)        */
/* ------------------------------------------------------------------------- */

#define UNIX

/* ------------------------------------------------------------------------- */
/*   The other #definable options (some of them set by the above) are:       */
/*                                                                           */
/*   USE_TEMPORARY_FILES - use scratch files for workspace, not memory       */
/*                         (PCs do not seem to like this code)               */
/*   PROMPT_INPUT        - prompt input (don't use Unix-style command line)  */
/*   TIME_UNAVAILABLE    - don't use ANSI time routines to work out today's  */
/*                         date                                              */
/*   US_POINTERS         - make some of the checksum routine pointers        */
/*                         unsigned char *'s, not char *'s: this should be   */
/*                         used if your compiler does un-ANSI things with    */
/*                         casts between these types                         */
/* ------------------------------------------------------------------------- */
/*                                                                           */
/*   Any use of this program may be made, provided that no profit is         */
/*   involved and that this message is preserved in all modified versions;   */
/*   see the documentation for fuller legal details.  Note that it is not    */
/*   public domain.                                                          */
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*   Hello, Porter!                                                          */
/*                                                                           */
/*   The code is in ANSI C.  At present it assumes that at least long        */
/*   integers are 32 bit, though ordinary integers can be either 16 or 32    */
/*   bit, and stored in either order (high to low or vice versa).  It no     */
/*   longer uses strtoul, and can manage without strftime.  (See below.)     */
/*                                                                           */
/*   To use Inform (once it's compiled) you need about 700K maximum of       */
/*   filespace (much less for small games) and at most 200K of spare memory  */
/*   (i.e., memory not physically occupied by Inform).                       */
/*                                                                           */
/*   If you succeed in porting Inform to a new compiler, please email the    */
/*   author to say how, so that whatever you did can be incorporated in the  */
/*   next release.                                                           */
/* ------------------------------------------------------------------------- */
/*   ARCHIMEDES "port" (the original)                                        */
/*     ...incorporates three Archimedes-only #define'able options:           */
/*                                                                           */
/*   ARC_PROFILING       - do clumsy profiling                               */
/*   ARC_THROWBACK       - compile to be useful under the DDE as well as the */
/*                         command line, including throwback of errors into  */
/*                         !SrcEdit (code donated by Robin Watts)            */
/*   GRAHAM              - for Graham's machine only                         */
/*                                                                           */
/*   (link with ansilib only, not RISC_OSlib)                                */
/* ------------------------------------------------------------------------- */
/*   UNIX port (by Dilip Sequeira):  A "vanilla" makefile for gcc is:        */
/*                                                                           */
/*     OBJECTS = files.o asm.o inputs.o symbols.o zcode.o tables.o inform.o  */
/*               express.o                                                   */
/*     CC = gcc                                                              */
/*     CFLAGS = -O2 -finline-functions -fomit-frame-pointer                  */
/*                                                                           */
/*     inform: $(OBJECTS)                                                    */
/*      $(CC) -o inform $(OBJECTS)                                           */
/*                                                                           */
/*     $(OBJECTS): header.h Makefile                                         */
/*                                                                           */
/*   (making an executable of size about 100K on a SparcStation II).         */
/*   The temporary files option is not on by default, but if it is used,     */
/*     file names are used which contain the process ID.                     */
/* ------------------------------------------------------------------------- */
/*   AMIGA port (by Christopher A. Wichura)                                  */
/*                                                                           */
/*     (Because of the way this compiler handles unsigned char *'s the       */
/*        #define AMIGA option forces #define US_POINTERS.)                  */
/*                                                                           */
/*     "I am compiling with SAS/C v6.51.  To support building a GST file     */
/*     (essentially a pre-compiled header file), I had to add the file       */
/*     amiheadermaker.c, which I have also included.  Finally, I am also     */
/*     including a copy of the SCOPTIONS file."                              */
/*                                                                           */
/*      --- BEGIN smakefile ---                                              */
/*      # smake file for Inform, the Infocom compiler                        */
/*      # created 1/24/94 by Christopher A. Wichura (caw@miroc.chi.il.us)    */
/*                                                                           */
/*      PROGNAME = Inform                                                    */
/*                                                                           */
/*      CFLAGS = nostkchk strmerge parms=reg utillib optimize                */
/*      LFLAGS = smallcode smalldata stripdebug                              */
/*                                                                           */
/*      HDR = $(PROGNAME).gst                                                */
/*                                                                           */
/*      OBJS = asm.o files.o inform.o inputs.o symbols.o tables.o zcode.o    */
/*             express.o                                                     */
/*      LIBS = LIB:sc.lib LIB:debug.lib LIB:amiga.lib                        */
/*                                                                           */
/*      .c.o                                                                 */
/*       sc $(CFLAGS) gst=$(HDR) $*                                          */
/*                                                                           */
/*      $(PROGNAME): $(OBJS)                                                 */
/*       slink with lib:utillib.with <WITH < (withfile.lnk)                  */
/*      FROM LIB:cres.o $(OBJS)                                              */
/*      TO $(PROGNAME)                                                       */
/*      LIB $(LIBS)                                                          */
/*      $(LFLAGS)                                                            */
/*      MAP $(PROGNAME).map fhlsx plain                                      */
/*      <                                                                    */
/*                                                                           */
/*      # clean target                                                       */
/*      clean:                                                               */
/*       delete \#?.o $(PROGNAME).gst $(PROGNAME).map                        */
/*                                                                           */
/*      # dependancies of various modules                                    */
/*      $(HDR): header.h                                                     */
/*       sc $(CFLAGS) noobjname makegst=$(HDR) amiheadermaker.c              */
/*                                                                           */
/*      asm.o: asm.c $(HDR)                                                  */
/*                                                                           */
/*      files.o: files.c $(HDR)                                              */
/*                                                                           */
/*      inform.o: inform.c $(HDR)                                            */
/*                                                                           */
/*      express.o: express.c $(HDR)                                          */
/*                                                                           */
/*      inputs.o: inputs.c $(HDR)                                            */
/*                                                                           */
/*      symbols.o: symbols.c $(HDR)                                          */
/*                                                                           */
/*      tables.o: tables.c $(HDR)                                            */
/*                                                                           */
/*      zcode.o: zcode.c $(HDR)                                              */
/*                                                                           */
/*      --- END smakefile ---                                                */
/*                                                                           */
/*      --- BEGIN amiheadermaker.c ---                                       */
/*      // file used to build the Amiga GST file.                            */
/*      #include "header.h"                                                  */
/*                                                                           */
/*      --- END amiheadermaker.c ---                                         */
/*                                                                           */
/*      --- BEGIN SCOPTIONS                                                  */
/*      MemorySize=HUGE                                                      */
/*      IncludeDir=SINCLUDE:                                                 */
/*      OptimizerComplexity=15                                               */
/*      OptimizerDepth=5                                                     */
/*      OptimizerRecurDepth=15                                               */
/*      OptimizerSchedule                                                    */
/*      OptimizerInLocal                                                     */
/*      Verbose                                                              */
/*      --- END SCOPTIONS                                                    */
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*   Microsoft Visual C/C++ port (for the PC) (by Toby Nelson)               */
/*                                                                           */
/*  "The following makefile is for the "Microsoft Visual C++ V1.00"          */
/*  development environment, of which the important bit is the "Microsoft    */
/*  C/C++ Optimizing Compiler Version 8.00". It may well work for previous   */
/*  versions of the compiler too.                                            */
/*                                                                           */
/*        CFLAGS = /nologo /Ox /W0 /AL                                       */
/*        goal: inform.exe                                                   */
/*                                                                           */
/*        .obj: .c                                                           */
/*        cl *.c                                                             */
/*                                                                           */
/*        inform.exe: asm.obj files.obj inform.obj inputs.obj symbols.obj \  */
/*            tables.obj zcode.obj express.obj                               */
/*        link /STACK:16384 asm files inform inputs symbols tables \         */
/*            zcode express, inform.exe,,llibce.lib,,                        */
/*                                                                           */
/*  (NB: The compiler options used here are:                                 */
/*                                                                           */
/*        /nologo = no copyright message,                                    */
/*        /Ox = optimize for speed,                                          */
/*        /W0 = turn off all compiler warnings, and                          */
/*        /AL = compile for the large memory model.)"                        */
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*   Quick C port (for the PC) (by Bob Newell): Makefile...                  */
/*                                                                           */
/*        CFLAGS =   /DPC /AL  /DLAMER                                       */
/*        CC = qcl                                                           */
/*                                                                           */
/*        inform.exe:  asm.obj files.obj inform.obj inputs.obj symbols.obj \ */
/*            tables.obj zcode.obj express.obj                               */
/*            qlink /STACK:16384 asm.obj files.obj inform.obj inputs.obj \   */
/*             symbols.obj tables.obj zcode.obj express.obj, inform.exe,, \  */
/*             llibce.lib,inform.map,                                        */
/* ------------------------------------------------------------------------- */
/*   Atari ST port (by Charles Briscoe-Smith): Makefile...                   */
/*                                                                           */
/*        OBJS = files.o asm.o inputs.o symbols.o zcode.o tables.o inform.o  */
/*               express.o                                                   */
/*                                                                           */
/*        CC = gcc                                                           */
/*                                                                           */
/*        # I didn't use the optimisation flags, because of memory shortage. */
/*        # If you have enough memory, try uncommenting the "CFLAGS=" line.  */
/*                                                                           */
/*        #CFLAGS = -O2 -finline-functions -fomit-frame-pointer              */
/*                                                                           */
/*        inform.ttp : $(OBJS)                                               */
/*              $(CC) $(CFLAGS) -o inform.ttp $(OBJS)                        */
/*                                                                           */
/*        $(OBJS): header.h                                                  */
/*                                                                           */
/*   This port contains a TOSFS option: if defined, then temporary files are */
/*   named in DOS style, and if not then in Unix style (in any case, this    */
/*   only matters if USE_TEMPORARY_FILES is set).                            */
/* ------------------------------------------------------------------------- */
/*   OS/2 port (by John W. Kennedy):                                         */
/*                                                                           */
/*   "The program compiles and runs correctly as-is... I found it convenient */
/*   to create a dummy h.version file, to prevent problems with makemake.    */
/*   Since the file is not actually used, the contents don't matter...       */
/*   ...it can be assumed that later this year it [Inform] will port         */
/*   successfully to WorkPlace OS on the PowerPC, as well."                  */
/* ------------------------------------------------------------------------- */
/*   Makefile for Linux (by Spedge, aka Dark Mage)                           */
/*                                                                           */
/*    CC      = gcc                                                          */
/*    CFLAGS  = -Dlinux                                                      */
/*    LDFLAGS =                                                              */
/*    LIBS    =                                                              */
/*                                                                           */
/*    PROG    = inform                                                       */
/*    SUBDIRS = data                                                         */
/*    BINDIR  = /usr/local/games/infocom                                     */
/*    DATADIR = /usr/local/games/infocom/data                                */
/*    MANDIR  = /usr/local/man/man1                                          */
/*    INSTALL = install                                                      */
/*    RM      = rm                                                           */
/*    CD      = cd                                                           */
/*    CP      = cp                                                           */
/*                                                                           */
/*    INC     = header.h                                                     */
/*    OBJS    = inform.o asm.o inputs.o files.o symbols.o tables.o zcode.o   */
/*              express.o                                                    */
/*                                                                           */
/*    all: $(PROG)                                                           */
/*                                                                           */
/*    inform : $(OBJS)                                                       */
/*            $(CC) -o $(PROG) $(LDFLAGS) $(OBJS) $(LIBS)                    */
/*                                                                           */
/*    $(OBJS) : $(INC)                                                       */
/*                                                                           */
/*    install: $(PROG)                                                       */
/*            $(INSTALL) $(PROG) $(BINDIR)                                   */
/*      @for d in $(SUBDIRS); do (cd $$d && $(MAKE) install) || exit; done   */
/*                                                                           */
/*    install.man:                                                           */
/*            $(CP) $(PROG).1 $(MANDIR)                                      */
/*                                                                           */
/*    clean :                                                                */
/*            $(RM) -f *.o $(PROG)                                           */
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*   Apple Macintosh port (by Robert Pelak):                                 */
/*                                                                           */
/*     "As for my compiler, I used THINK C 5.0.  Actually, this is an old    */
/*      compiler, as they are up to version 7.0 now.  I've tested the        */
/*      program primarily in a System 6.0.8 environment, but I've also done  */
/*      some testing on a friend's computer who has upgraded to System 7.1.  */
/*      I did not use any special options, just the console routines that    */
/*      THINK C will automatically invoke when it encounters a reference to  */
/*      stdout, and no windows have been set up."                            */
/* ------------------------------------------------------------------------- */
/*                                                                           */
/*   Geography and History                                                   */
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*   A rough tourist's map of the Inform archipelago:                        */
/*                                                                           */
/*        Main                              inform.c                         */
/*          Initialisation                                                   */
/*          Command line switches                                            */
/*          Top level line parser                                            */
/*            Compiler                                                       */
/*                                                                           */
/*              Assignments, conditions,    express.c                        */
/*              Expression evaluator                                         */
/*                                                                           */
/*            Assembler directives          asm.c                            */
/*            Line assembler                                                 */
/*              Constant evaluator                                           */
/*              Make attributes/properties                                   */
/*                                                                           */
/*              Make objects                tables.c                         */
/*              Make globals                                                 */
/*              Make verbs                                                   */
/*              Make dictionary                                              */
/*              Make actions                                                 */
/*              Print diagnostics                                            */
/*          Construct output file                                            */
/*                                                                           */
/*              Text translation            zcode.c                          */
/*              Z-code database                                              */
/*          Abbreviations optimiser                                          */
/*                                                                           */
/*              Symbols table maker         symbols.c                        */
/*                                                                           */
/*              Preprocessor stack          inputs.c                         */
/*              Character-level parsing                                      */
/*              Error reporting                                              */
/*                                                                           */
/*              File handling               files.c                          */
/*              Fatal errors                                                 */
/*              Memory management                                            */
/*                                                                           */
/*                Comments                  (this header file)               */
/*                #defines                                                   */
/*                Integer types                                              */
/*                Structures                                                 */
/*                Extern declarations                                        */
/*                                                                           */
/* ------------------------------------------------------------------------- */
/*****                                                                       */
/*   * The first archive release (0.5) was on April 30th 1993.               */
/* 1 *                                                                       */
/*   *                                                                       */
/*****                                                                       */
/*                                                                           */
/***** The second archive release (0.6) had the following improvements:      */
/*   *                                                                       */
/* 2 * One #ifdef ARCHIMEDES altered to correct a bug in non-Archimedes      */
/*   * version                                                               */
/***** Checking on the MAX_ACTIONS limit put in ("Curses" exceeded 100!)     */
/*     Checking on MAX_STATIC_STRINGS put in; -m information extended        */
/*     -x (hash printing) option introduced                                  */
/*     -a (list assembly lines only) option, and ATRACE/NOATRACE introduced  */
/*     Void prototypes explicitly declared (void)                            */
/*     Defunct Inform directives "STRING" and "SET" removed                  */
/*     Opcode data now made static, and faster opcode-parsing routine put in */
/*     Preprocessor stack rewritten, and now checking for overflow           */
/*     Showdict produces more useful output                                  */
/*     Filename extension #defines added                                     */
/*     Command line parsing improved                                         */
/*     Some ASCII assumptions removed                                        */
/*     Typedefs added to force integers to be 32-bits long                   */
/*     Memory management heavily reformed, at the expense of a certain charm */
/*                                                                           */
/*     USE_TEMPORARY_FILES version: if this is #defined, scratch files       */
/*       amounting to at most about 100K and 50K respectively are used to    */
/*       hold the code and static strings areas; this saves about another    */
/*       150K.                                                               */
/*       (At worst three files are simultaneously open under this regime.)   */
/*       The temporary file names are #define'd below.  They are             */
/*         automatically deleted.                                            */
/*                                                                           */
/*****   The third release (1.0) is generally tidied and reorganised: most   */
/*   *   of the sillier variable and routine names have been made more       */
/* 3 *   comprehensible.                                                     */
/*   *   It is also 3 to 6 times faster; thanks due to Dilip Sequeira for    */
/*****   profiling output, and also David Moore for his... comments.         */
/*       (November 1993)                                                     */
/*                                                                           */
/*   Program improvements in the third release:                              */
/*                                                                           */
/*     @xx string indirection via the synonyms table added                   */
/*     Objects allowed to have multiple internal names                       */
/*     New constant form #n$word... added                                    */
/*     And #r$routine...                                                     */
/*     New high-level commands "write" and "give" for easier object amending */
/*     Fatal errors fractionally more informative                            */
/*     Non-fatal errors quite a lot more informative, and better worded      */
/*     Grievous bug in stack long slot routines fixed                        */
/*     The checksum and length words are now properly set (though few        */
/*       interpreters need them)                                             */
/*     Error checking on exceeding MAX_VERBS                                 */
/*     -e (economy mode) added: causes abbreviations to be worked out,       */
/*       slowly (this is why it is only an option)                           */
/*     #SWITCHES directive added                                             */
/*     -i (ignore switches) and -o (print offsets) added                     */
/*     Checking added on whether routines have too many local variables (the */
/*       Z-machine crashes in a very strange way if so!)                     */
/*     Minor bug in printing object tree fixed                               */
/*     Two unused bytes spare at end of property defaults table are now      */
/*       zeroed                                                              */
/*     Temporary files now deleted after use                                 */
/*     Checking on excessively long variable names added                     */
/*     STATUSLINE directive added (for games with hours/minutes on the       */
/*       status line)                                                        */
/*     The former SMALL_MEMORY compilation option is now mandatory.          */
/*       (Previously, Inform could be compiled so that it read source files  */
/*       into an enormous buffer, rather than reading them twice through a   */
/*       bit at a time.  This could only be useful on machines with huge     */
/*       memory and very slow filing systems, of which there are few, and it */
/*       complicated the code.)                                              */
/*     The way input file names are processed has been reformed: they are    */
/*       now not altered if they contain a '.' or a '/'                      */
/*     INCLUDE directive added, so that Inform #includes files like C        */
/*     Old -p (both passes) directive renamed -b, and new -p (percentage     */
/*       breakdown)                                                          */
/*     Warnings added: variables not used; checking that Main behaves        */
/*       properly; small bug in line counting fixed; checking on number of   */
/*       function arguments                                                  */
/*     Meta-verbs added                                                      */
/*     -f (frequencies) and -t (assembly trace) switches added               */
/*     Small bug to do with stubbed routines removed                         */
/*     Possibly unused bytes (due to word alignment) in data, now zeroed     */
/*       (so that different machines will not produce different game files)  */
/*     -f now calculates bytes yielded by abbreviations                      */
/*     New SERIAL directive for machines without access to today's date      */
/*     Now handles more complicated multiple expressions within the same     */
/*       command                                                             */
/*     New STRING command added for writing to the synonyms table            */
/*     New FONT command for proportional fonts control                       */
/*     New DEFAULT and STUB directives, for stubbing undeclared CONSTANTs    */
/*       and code                                                            */
/*     Checking on no. of attributes and properties added, and               */
/*       property-counting                                                   */
/*                                                                           */
/*   Speed improvements in the third release:                                */
/*                                                                           */
/*     The following have been rewritten in the interests of speed and       */
/*       not being O(n^2) for the sake of it: the line reader and tokeniser, */
/*       management of local variables, the dictionary builder, the text     */
/*       translator, the line parser and the symbols table (courtesy of hash */
/*       coding by Dilip).                                                   */
/*                         Curses    Dejavu       (compiling times (seconds) */
/*                                                 on my machine)            */
/*        Release 2...        300        45       (including 1-2 seconds for */
/*        Tokeniser & locals  205        26        printing statistics)      */
/*        Dictionary           89        19                                  */
/*        Symbols hashing      74        17                                  */
/*        Tokeniser II         69        16                                  */
/*        Abbreviations        55        16                                  */
/*        Hashing reserveds    49        14                                  */
/*                                                                           */
/*   Compatibility improvements in the third release:                        */
/*                                                                           */
/*     The sort_number routine has been rewritten at the suggestion of Jon   */
/*       Drukman in order to defend against compilers determined to sign     */
/*       chars; and so have some structure definitions and variable types    */
/*     Subtraction of pointers is now done by an easily altered macro (the   */
/*       point being that you can't always subtract by casting to int, if    */
/*       int is 16 bit or if you have a dire MSDOS-like memory map)          */
/*     File naming improved slightly                                         */
/*     The two points where ASCII is used now go through translate_to_ascii  */
/*     Some stupid alterations made for VAX C compatibility                  */
/*       (in the idiot world of VAX C, # commands must start on column 1,    */
/*       x=-1 is read as x-=1, typedef isn't ANSI, the word "signed" is      */
/*       rejected, values like MAX_INT are wrongly set and string consts     */
/*       don't concatenate)                                                  */
/*     A general rewrite has been made to sort out 16-bit from 32-bit        */
/*       integers: Inform now properly works when int is 16 bit by default.  */
/*     VAX version now working (so presumably Inform does not rely on the    */
/*       order of bytes in a word)                                           */
/*     Long constants explicitly declared so (to keep Borland C++ happy)     */
/*     Because some C compilers (especially PC ones) don't like large static */
/*       arrays there's now an ALLOCATE_BIG_ARRAYS option (#define PC forces */
/*       it) which uses calloc to allocate memory from the heap for them.    */
/*     Altogether Inform is going to need about 200K of workspace, and       */
/*       that's that: in a big flat memory machine, this will split about    */
/*       equally between static arrays and dynamic allocation.  With         */
/*       ALLOCATE_BIG_ARRAYS set it will be almost entirely dynamically      */
/*       allocated.                                                          */
/*     If PROMPT_INPUTS is defined (and the VAX and PC versions force this), */
/*       Inform gets file names and options by prompting for keyboard input, */
/*       rather than using a Unix-style command line.                        */
/*     If TIME_UNAVAILABLE is defined, Inform doesn't try to use strftime    */
/*       and doesn't enter today's date for the serial number: the           */
/*       programmer will have to use a SERIAL directive in Inform, instead.  */
/*                                                                           */
/*---+  Improvements made for Release 3a:  (Dec 7th 1993)                    */
/*   |                                                                       */
/* 3a|  The AMIGA port option added (following Christopher Wichura)          */
/*   |  #define US_POINTERS option added                                     */
/*---+  A few constants (eg. MAX_BANK_SIZE) slightly increased, as "Curses"  */
/*        needed it when very close indeed to maximum possible size          */
/*     A few void routines which weren't explicitly called (void) now are    */
/*     The use of local text buffers by routines has been reformed, so that  */
/*       although there's now about 6K more of array allocation, the stack   */
/*       needed during runs of Inform is very much smaller (previously       */
/*       machines with less than 32K stack couldn't manage).                 */
/*     The tokeniser now recognises tab characters (outside string literals) */
/*       as spaces (Inform previously gave errors when it found these).      */
/*     The begin_pass routines are now more legible                          */
/*                                                                           */
/*****   Miscellaneous improvements made for Release 4:  (January 20th 1994) */
/*   *                                                                       */
/* 4 *  Checking on file I/O errors (previously Inform only checked errors   */
/*   *    which occurred on opening files, so never noticed disc space       */
/*****    running out)                                                       */
/*     Lamentable wrong-verify-code bug in R3a (caused by misplaced #endif)  */
/*       fixed, and checksum calculation rewritten in a truly paranoid way   */
/*       for better portability to machines signing char's                   */
/*     "p[syns]=0x80" made to work when char's are signed (-128 to 127); a   */
/*       few redundant initialisations of variables removed                  */
/*     Minor tracing bug in R3a (only) fixed                                 */
/*     Source code reformatted to 79 columns wide for troglodyte monitors    */
/*     New typedef of "zip" (for char / unsigned char) to simplify the       */
/*       the US_POINTERS option                                              */
/*     Heavy reorganisation and division into seven separately-compiled      */
/*       files; variables sorted into extern and static throughout           */
/*     Optimisation on void-context function calls (saving about 300 bytes   */
/*       on a v-3 file of size 128K!)                                        */
/*     Conditional compilation added: #IFDEF, #IFNDEF, #IFNOT, #ENDIF        */
/*     Slow and memory-intensive abbreviations optimiser added: -u switch    */
/*     Text transcription (-r) added                                         */
/*     Property and attribute "alias" introduced (using code suggested by    */
/*       Art Dyer)                                                           */
/*     Properties and attributes formally separated as types, and a warning  */
/*       introduced for the common accident of missing out a comma in a      */
/*       property list                                                       */
/*     Warning put in for over-long property data (in Version 3 files)       */
/*     Property operators ".", ".&", ".#" added                              */
/*     Direct array and property assignments (eg., a->2=3;) added            */
/*     Expression evaluator tracing improved (and "etrace full" added)       */
/*     Expressions generally reformed, and complicated conditions added      */
/*     Braces made optional for simple if clauses                            */
/*     Negative constants now tokenised correctly and allowed                */
/*     Unary minus, ++ and -- added; x+-1 optimised to x-1                   */
/*     "Children" and other in-lined object functions added                  */
/*     Recondite bug in expressions with nested function calls fixed         */
/*     Preprocessor stack fully rewritten in a cleverer way (and it worked   */
/*       first time!)                                                        */
/*     New-style "for", "objectloop" added (they didn't, though); bug in the */
/*       old "do...until" code fixed                                         */
/*     Assignments can now take the form of a comma-separated-list           */
/*     Braces made optional for arbitrary (nested) new-style constructs      */
/*     Fixed miscellaneous bugs and finally rewrote the expression evaluator */
/*       in a tokenised way, losing about 50 calls to strcmp per operator -  */
/*       which made no noticeable difference to run time but I feel better   */
/*     my_malloc and my_calloc given the correct int type - size_t           */
/*     Rare bug with large constant initial values for global variables when */
/*       int is 2-byte, fixed                                                */
/*     Microsoft Visual C/C++ port added (following Toby Nelson)             */
/*     Line tracing format made more legible (at long last)                  */
/*     strcmp no longer used with possibly null strings (which is allowed    */
/*       by ANSI to crash the machine, and does under Unix)                  */
/*                                                                           */
/*   New Version-5 features in Release 4:                                    */
/*                                                                           */
/*     -v3 and -v5 switches, and VERSION directive, added to switch between  */
/*       producing version 3 (Standard) and version 5 (Advanced) games       */
/*     Rewritten statistics routines; changes to some array limits           */
/*     New Advanced opcodes added                                            */
/*     Optimisation of calls in v-5 code to make use of variant opcodes      */
/*     STYLE command for bold-face, underlining, reverse video               */
/*     READ command replaces the old v-3 opcode of the same name, and        */
/*       emulates it (with an optional status-line-routine) in version 5     */
/*     Dictionary routines rewritten for either 6- or 9-character accuracy   */
/*     New constants #dict_par1, -2, -3 and #version_number                  */
/*     SAVE, RESTORE commands replace the old v-3 opcodes, so as to emulate  */
/*       them in v-5                                                         */
/*     #IFV3 and #IFV5 directives added                                      */
/*     Different file extensions/prefixes for version 5 files                */
/*     BOX command added                                                     */
/*                                                                           */
/*****  Many minor improvements and bug fixes; object classes; inheritance;  */
/*   *  embedded routines in object definitions; cosmetic improvements       */
/* 5 *                                                                       */
/*   *  June 12th 1994                                                       */
/*****                                                                       */
/*     A few corrections by Christopher Wichura for the AMIGA option,        */
/*       and Amiga makefile commented above - 25/1                           */
/*     Variable name in grow_branch() changed on advice of David Ingram      */
/*       (it was called opcode, which was also a typedef'd name) - 14/2      */
/*     Check on exceeding MAX_ROUTINES put in (finally!) - 26/2              */
/*     Minor bug to do with property data exceeding 10 bytes fixed - 13/3    */
/*     Assembler slightly rewritten, and the new opcode naming system        */
/*       introduced: a few minor changes, numerous (unuseful) additions - "  */
/*     Versions 4 and 6 (-v4, -v6) added for completeness - 16/3             */
/*     Some minor tidying up of code suggested by Bob Newell, and the        */
/*       USE_TEMPORARY_FILES option finally made to work on PCs - 17/3       */
/*     Bob's Quick C port added - 17/3                                       */
/*     Nasty (but extremely unlikely) bug to do with data area fixed, and    */
/*       memory allocation for this made more flexible - 30/3                */
/*     Really miserable, vile bug in the expression evaluator to do with     */
/*       exactly the case  function(a-1,b)  fixed - 14/4                     */
/*     Errors added for duplicated and misplaced "else"s - rather important  */
/*       since Inform handles hanging elses slightly naively - 15/4          */
/*     Charles Briscoe-Smith's Atari ST port added - 20/4                    */
/*     John Kennedy's OS/2 port added                                        */
/*     Robin Watts' Archimedes throwback code added                          */
/*     Bob Newell's fix for the } brace underflow bug added (about time too) */
/*     Robert Pelak's Macintosh port added - 26/4                            */
/*     Testing on size of quoted strings added (previously Inform could      */
/*       crash if they were more than 2K long) - 27/4                        */
/*     -j (list objects as made) switch added - 27/4                         */
/*     Better reporting of output file opening errors - 27/4                 */
/*     Code generator fixed to produce only safe calls to get_prop_len       */
/*       (calls with non-existent properties crash some interpreters) - 1/5  */
/*     Code for drawing quotation boxes made smaller and better - 1/5        */
/*     Updated the gcc makefile on Dilip's advice - 2/5                      */
/*     Put error check in for misplaced "switches" directive, after such a   */
/*       mistake confused me for ages - 17/5                                 */
/*     Embedded routines in object declarations added - 18/5                 */
/*     ##Action form added - 18/5                                            */
/*     Forward references to constants now understood (a thorny problem      */
/*       because of the long/short storage dilemma) - 18/5                   */
/*     Classes and inheritance, embedded routines, fake actions added        */
/*     Dictionary routines fixed to allow e.g. "y2" and "pipe-dream" - 19/5  */
/*     -n (print property/attribute numbers as allocated) added              */
/*     <Action ...> added; dictionary address constants reformed - 20/5      */
/*     "Nearby" declarations, and object locations defaulted to "nothing"    */
/*     Bare strings understood as print_ret                                  */
/*     <<Action...>> added - 21/5                                            */
/*     Additive properties; "name" made additive; more logical punctuation   */
/*       of object definitions - 26/5                                        */
/*                                                                           */
/*     (At this point the code sat in the incoming directory at ftp.gmd.de   */
/*       for a while and was discovered and looted, after which the          */
/*       following improvements were made:)                                  */
/*     Old "inform.c" file divided about equally into two, making new file   */
/*       "express.c" for the expression evaluator - a long overdue change    */
/*     Minor bug (to do with 32 properties being exceeded in V5) fixed       */
/*     Memory allocation tracing (-m) and freeing improved                   */
/*     The old ALLOCATE_BIG_ARRAYS option is now mandatory                   */
/*     Memory $ commands (on the command line) added: memory consumption     */
/*       reduced: symbols table memory allocation reformed                   */
/*     Two minor, convoluted bugs in line counting for error reports fixed   */
/*     Temporary files not left lying around after errors have occurred      */
/*     Grammar table extensions added                                        */
/*                                                                           */
/* ------------------------------------------------------------------------- */

#define ALLOCATE_BIG_ARRAYS

#define LARGE_SIZE   1
#define SMALL_SIZE   2

/* ------------------------------------------------------------------------- */
/*   By setting up the prefixes and extensions in the definitions below, you */
/*   should be able to get something sensible for your filing system.        */
/*   In the last resort, the clumsy "z3" or "z5" prefixes below are chosen   */
/*   to cause least offense to different filing systems.                     */
/*   Note that if both Code_Prefix and Code_Extension are empty, then Inform */
/*   may overwrite its source code with the object code... so don't allow    */
/*   this.                                                                   */
/*   (For Unix and PCs the extension is ".z3" or ".z5" rather than ".zip"    */
/*   to avoid looking like the file compression trailer...)                  */
/*                                                                           */
/* ------------------------------------------------------------------------- */

#ifdef GRAHAM
#include "h.version"
#define ARCHIMEDES
#define DEFAULT_MEMORY_SIZE LARGE_SIZE
#define ARC_THROWBACK
#else
#define VNUMBER RELEASE_NUMBER
#endif

#ifdef ARCHIMEDES
#define MACHINE_STRING   "Archimedes"
#define Source_Prefix    "Zcode."
#define Source_Extension ""
#define Include_Prefix   "Zcode.h."
#define Code_Prefix      "Zgames."
#define Code_Extension   ""
#define Transcript_Name  "Game_Text"
#define USE_TEMPORARY_FILES
#define Temp1_Name "ram:InfTemp1"
#define Temp2_Name "ram:InfTemp2"
#ifdef ARC_PROFILING
     extern int _fmapstore(char *);
#endif
#endif

#ifdef UNIX
#define MACHINE_STRING   "Unix"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".z3"
#define V5Code_Extension ".z5"
#define Transcript_Name "game.txt"
extern char Temp1_Name[], Temp2_Name[];
#define Temp1_Hdr "/tmp/InformTemp1"
#define Temp2_Hdr "/tmp/InformTemp2"
#define DEFAULT_MEMORY_SIZE LARGE_SIZE
#endif

#ifdef LINUX
#define MACHINE_STRING   "Linux"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".z3"
#define V5Code_Extension ".z5"
#define Transcript_Name "game.txt"
extern char *Temp1_Name, *Temp2_Name;
#define Temp1_Hdr "/tmp/InformTemp1"
#define Temp2_Hdr "/tmp/InformTemp2"
#define DEFAULT_MEMORY_SIZE LARGE_SIZE
#endif

#ifdef PC_QUICKC
#define PC
#endif

#ifdef PC
#define PROMPT_INPUT
#define MACHINE_STRING   "PC"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".z3"
#define V5Code_Extension ".z5"
#define Temp1_Name "Inftmp1.tmp"
#define Temp2_Name "Inftmp2.tmp"
#define Transcript_Name "game.txt"
#define USE_TEMPORARY_FILES
#define ALLOCATE_BIG_ARRAYS
#endif

#ifdef VAX
#define PROMPT_INPUT
#define TIME_UNAVAILABLE
#define MACHINE_STRING   "VAX"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".zip"
#define Transcript_Name "game.txt"
#define Temp1_Name "Inftmp1.tmp"
#define Temp2_Name "Inftmp2.tmp"
#endif

#ifdef AMIGA
#define MACHINE_STRING   "Amiga"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".z3"
#define V5Code_Extension ".z5"
#define Transcript_Name "game.txt"
extern char *Temp1_Name, *Temp2_Name;
#define Temp1_Hdr "T:InformTemp1"
#define Temp2_Hdr "T:InformTemp2"
#define __USE_SYSBASE
#include <proto/exec.h>
#define ALLOCATE_BIG_ARRAYS
#define US_POINTERS
#endif

#ifdef ATARIST
#define MACHINE_STRING   "Atari ST"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".z3"
#define V5Code_Extension ".z5"
#define Transcript_Name "game.txt"
#ifdef TOSFS
#define Temp1_Name "Inftmp1.tmp"
#define Temp2_Name "Inftmp2.tmp"
#else
char Temp1_Name[50], Temp2_Name[50];
#define Temp1_Hdr "/tmp/InformTemp1"
#define Temp2_Hdr "/tmp/InformTemp2"
#endif
#endif /* ATARIST */

#ifdef OS2
#define MACHINE_STRING   "OS/2"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".z3"
#define V5Code_Extension ".z5"
#define Temp1_Name "Inftemp1"
#define Temp2_Name "Inftemp2"
#define Transcript_Name "game.txt"
#endif

#ifdef MACINTOSH
#define MACHINE_STRING   "Macintosh"
#define Source_Prefix    ""
#define Source_Extension ".inf"
#define Include_Extension ".h"
#define Code_Prefix      ""
#define Code_Extension   ".z3"
#define V5Code_Extension ".z5"
#define Temp1_Name "Inftemp1"
#define Temp2_Name "Inftemp2"
#define Transcript_Name "game.text"
#define PROMPT_INPUT
#endif

/* Default settings: */

#ifndef Source_Prefix
#define Source_Prefix    ""
#define Source_Extension ""
#define Code_Prefix      "z3"
#define V5Code_Prefix    "z5"
#define Code_Extension   ""
#define Temp1_Name "Inftemp1"
#define Temp2_Name "Inftemp2"
#endif

#ifndef Include_Prefix
#define Include_Prefix Source_Prefix
#endif
#ifndef Include_Extension
#define Include_Extension Source_Extension
#endif

#ifndef V5Code_Prefix
#define V5Code_Prefix Code_Prefix
#endif
#ifndef V5Code_Extension
#define V5Code_Extension Code_Extension
#endif

#ifndef Transcript_Name
#define Transcript_Name "thetext"
#endif

#ifndef DEFAULT_MEMORY_SIZE
#define DEFAULT_MEMORY_SIZE SMALL_SIZE
#endif

/* ------------------------------------------------------------------------- */
/*   Inclusions and some macro definitions...                                */
/*   (At this point in earlier releases, there were many #define's for       */
/*    memory limits and sizes of arrays: see "files" for the new code.)      */
/* ------------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include <limits.h>

#define  MAX_ERRORS 100
#define  MAX_BLOCK_NESTING 32
#define  MAX_EXPRESSION_BRACKETS 32
#define  MAX_ARITY 5
#define  MAX_IFDEF_DEPTH 32
#define  MAX_IDENTIFIER_LENGTH 32
#define  MAX_ABBREV_LENGTH 64
#define  MAX_INCLUSION_DEPTH 4


extern int BUFFER_LENGTH;
extern int MAX_QTEXT_SIZE;
extern int MAX_SYMBOLS;
extern int MAX_BANK_SIZE;
extern int SYMBOLS_CHUNK_SIZE;
extern int BANK_CHUNK_SIZE;
extern int HASH_TAB_SIZE;

extern int MAX_OBJECTS;

extern int MAX_ACTIONS;
extern int MAX_ADJECTIVES;
extern int MAX_DICT_ENTRIES;
extern int MAX_STATIC_DATA;

extern int MAX_TOKENS;
extern int MAX_OLDEPTH;
extern int MAX_ROUTINES;
extern int MAX_GCONSTANTS;

extern int MAX_PROP_TABLE_SIZE;

extern int MAX_FORWARD_REFS;

extern int STACK_SIZE;
extern int STACK_LONG_SLOTS;
extern int STACK_SHORT_LENGTH;

extern int MAX_ABBREVS;

extern int MAX_EXPRESSION_NODES;
extern int MAX_VERBS;

extern int MAX_STATIC_STRINGS;
extern int MAX_ZCODE_SIZE;

extern int MAX_LOW_STRINGS;

extern int MAX_TRANSCRIPT_SIZE;

extern int MAX_CLASSES;
extern int MAX_CLASS_TABLE_SIZE;

/* ------------------------------------------------------------------------- */
/*   Twisting the C compiler's arm to get a convenient 32-bit integer type   */
/*   Warning: chars are presumed unsigned in this code, which I think is     */
/*   ANSI std; but they were presumed signed by K&R, so confusion reigns.    */
/*   Anyway a compiler ought to be able to cast either way as needed.        */
/*   Subtracting pointers is in a macro here for convenience: if even 32 bit */
/*   ints won't reliably hold pointers on your machine, rewrite properly     */
/*   using ptrdiff_t                                                         */
/* ------------------------------------------------------------------------- */

#ifndef VAX
#if   SCHAR_MAX >= 0x7FFFFFFFL && SCHAR_MIN <= -0x7FFFFFFFL
      typedef signed char       int32; 
      typedef unsigned char     uint32; 
#elif SHRT_MAX >= 0x7FFFFFFFL  && SHRT_MIN <= -0x7FFFFFFFL
      typedef signed short int  int32;
      typedef unsigned short int uint32;
#elif INT_MAX >= 0x7FFFFFFFL   && INT_MIN <= -0x7FFFFFFFL
      typedef signed int        int32;
      typedef unsigned int      uint32;
#elif LONG_MAX >= 0x7FFFFFFFL  && LONG_MIN <= -0x7FFFFFFFL
      typedef signed long int   int32;
      typedef unsigned long int uint32;
#else
      #error No type large enough to support 32-bit integers.
#endif
#else
      typedef int int32;
      typedef unsigned int uint32;
#endif

#define subtract_pointers(p1,p2) (((int32) p1)-((int32) p2))

#ifdef US_POINTERS
    typedef unsigned char zip;
#else
    typedef char zip;
#endif

/* ------------------------------------------------------------------------- */
/*   If your compiler doesn't recognise \t, and you use ASCII, you could     */
/*   define T_C as (char) 9; failing that, it _must_ be defined as a space   */
/*   and is _not_ allowed to be 0 or any recognisable character.             */
/* ------------------------------------------------------------------------- */

#define TAB_CHARACTER '\t'

/* ------------------------------------------------------------------------- */
/*  This hideous line is here only for checking on my machine that Inform    */
/*  runs properly when int is 16-bit                                         */
/* ------------------------------------------------------------------------- */

/* #define int short int */

/* ------------------------------------------------------------------------- */
/*   Structure definitions (there are a few others local to files)           */
/* ------------------------------------------------------------------------- */

typedef struct sourcefile
{   FILE *handle;
    char filename[64];
    int  source_line;
    int  sys_flag;
} Sourcefile;

typedef struct opcode
{   char *name;
    int code, offset, type1, type2, no;
} opcode;

typedef struct operand_t
{   int32 value; int type;
} operand_t;

typedef struct verbl {
    unsigned char e[8];
} verbl;

#define MAX_LINES_PER_VERB 16

typedef struct verbt {
    int lines;
    verbl l[MAX_LINES_PER_VERB];
} verbt;

typedef struct prop {
    unsigned char l, num, p[64];
} prop;

typedef struct propt {
    char l;
    prop pp[32];
} propt;

typedef struct fpropt {
    unsigned char atts[6];
    char l;
    prop pp[32];
} fpropt;

typedef struct objectt {
    unsigned char atts[6];
    int parent, next, child;
    int propsize;
} objectt;

typedef struct dict_word {
    unsigned char b[6];
} dict_word;

/* ------------------------------------------------------------------------- */
/*   Opcode type definitions                                                 */
/* ------------------------------------------------------------------------- */

#define NONE    0
#define STORE   1
#define BRANCH  2
#define CALL    3
#define JUMP    4
#define RETURN  5
#define NCALL   6
#define PCHAR   7
#define VATTR   8
#define ILLEGAL 9
#define INDIR  10

#define VAR     1
#define TEXT    2
#define OBJECT  3

#define VARI   -1
#define ZERO    0
#define ONE     1
#define TWO     2
#define EXTD    3

#define INVALID 100

/* ------------------------------------------------------------------------- */
/*   Inform code definitions                                                 */
/* ------------------------------------------------------------------------- */

#define ABBREVIATE_CODE  0
#define ATTRIBUTE_CODE   1
#define CONSTANT_CODE    2
#define DICTIONARY_CODE  3
#define END_CODE         4
#define INCLUDE_CODE     5
#define GLOBAL_CODE      6
#define OBJECT_CODE      7
#define PROPERTY_CODE    8
#define RELEASE_CODE     9
#define SWITCHES_CODE    10
#define STATUSLINE_CODE  11
#define VERB_CODE        12
#define TRACE_CODE       13
#define NOTRACE_CODE     14
#define ETRACE_CODE      15
#define NOETRACE_CODE    16
#define BTRACE_CODE      17
#define NOBTRACE_CODE    18
#define LTRACE_CODE      19
#define NOLTRACE_CODE    20
#define ATRACE_CODE      21
#define NOATRACE_CODE    22
#define LISTSYMBOLS_CODE 23
#define LISTOBJECTS_CODE 24
#define LISTVERBS_CODE   25
#define LISTDICT_CODE    26
#define OPENBLOCK_CODE   27
#define CLOSEBLOCK_CODE  28
#define SERIAL_CODE      29
#define DEFAULT_CODE     30
#define STUB_CODE        31
#define VERSION_CODE     32
#define IFV3_CODE        33
#define IFV5_CODE        34
#define IFDEF_CODE       35
#define IFNDEF_CODE      36
#define ENDIF_CODE       37
#define IFNOT_CODE       38
#define LOWSTRING_CODE   39
#define CLASS_CODE       40
#define FAKE_ACTION_CODE 41
#define NEARBY_CODE      42
#define SYSTEM_CODE      43
#define REPLACE_CODE     44
#define EXTEND_CODE      45

#define PRINT_ADDR_CODE  0
#define PRINT_CHAR_CODE  1
#define PRINT_PADDR_CODE 2
#define PRINT_OBJ_CODE   3 
#define PRINT_NUM_CODE   4
#define REMOVE_CODE      5
#define RETURN_CODE      6
#define DO_CODE          7
#define FOR_CODE         8
#define IF_CODE          9
#define OBJECTLOOP_CODE  10
#define UNTIL_CODE       11
#define WHILE_CODE       12
#define BREAK_CODE       13
#define ELSE_CODE        14
#define GIVE_CODE        15
#define INVERSION_CODE   16
#define MOVE_CODE        17
#define PUT_CODE         18
#define WRITE_CODE       19
#define STRING_CODE      20
#define FONT_CODE        21
#define READ_CODE        22
#define STYLE_CODE       23
#define RESTORE_CODE     24
#define SAVE_CODE        25
#define PRINT_CODE       26
#define SPACES_CODE      27
#define PRINT_RET_CODE   28
#define BOX_CODE         29

#define ASSIGNMENT_CODE  100
#define FUNCTION_CODE    101

#define ARROW_SEP        0
#define DARROW_SEP       1
#define DEC_SEP          2
#define MINUS_SEP        3
#define INC_SEP          4
#define PLUS_SEP         5
#define TIMES_SEP        6
#define DIVIDE_SEP       7
#define REMAINDER_SEP    8
#define LOGOR_SEP        9
#define ARTOR_SEP       10
#define LOGAND_SEP      11
#define ARTAND_SEP      12
#define CONDEQUALS_SEP  13
#define SETEQUALS_SEP   14
#define NOTEQUAL_SEP    15
#define GE_SEP          16
#define GREATER_SEP     17
#define LE_SEP          18
#define LESS_SEP        19
#define OPENB_SEP       20
#define CLOSEB_SEP      21
#define COMMA_SEP       22
#define PROPADD_SEP     23
#define PROPNUM_SEP     24
#define PROPERTY_SEP    25
#define COLON_SEP       26

/* ------------------------------------------------------------------------- */
/*   Useful macros                                                           */
/* ------------------------------------------------------------------------- */

#define On_(x)   if (strcmp(b,x)==0)
#define OnS_(x)  if (strcmp(sub_buffer,x)==0)
#define IfPass2  if (pass_number==2)

#define InV3     if (version_number==3)
#define InV5     if (version_number==5)

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "inform"                                         */
/* ------------------------------------------------------------------------- */

#ifdef ALLOCATE_BIG_ARRAYS
    extern int  *abbrev_values;
    extern int  *abbrev_quality;
    extern int  *abbrev_freqs;
#else
    extern int  abbrev_values[];
    extern int  abbrev_quality[];
    extern int  abbrev_freqs[];
#endif

extern int
    version_number,      override_version, scale_factor,
    no_abbrevs,          no_routines,      no_symbols,
    no_errors,           no_warnings,      endofpass_flag,
    no_dummy_labels,
    pass_number,         brace_sp,         no_locals,
    process_filename_flag,                 actual_version;
extern int
    statistics_mode,     offsets_mode,     tracing_mode,
    ignoreswitches_mode, bothpasses_mode,  hash_mode,
    percentages_mode,    trace_mode,       ltrace_mode,
    etrace_mode,         listing_mode,     concise_mode,
    nowarnings_mode,     frequencies_mode, ignoring_mode,
    double_spaced,       economy_mode,     memout_mode,
    transcript_mode,     optimise_mode,    store_the_text,
    abbrev_mode,         memory_map_mode,  withdebug_mode,
    listobjects_mode,    printprops_mode;
extern zip
    *zcode,      *zcode_p,     *utf_zcode_p,
    *symbols_p,  *symbols_top,
    *strings,    *strings_p,
    *low_strings, *low_strings_p,
    *dictionary, *dict_p,
    *output_p,   *abbreviations_at;

#ifdef PC_QUICKC
    extern char _huge *all_text, *all_text_p;
#else
    extern char *all_text, *all_text_p;
#endif

#ifdef ALLOCATE_BIG_ARRAYS
    extern char *buffer, *sub_buffer, *parse_buffer, *rewrite;
#else
    extern char buffer[], sub_buffer[], parse_buffer[], rewrite[];
#endif

extern int32 Write_Code_At, Write_Strings_At;

extern int
    code_offset,
    actions_offset,
    preactions_offset,
    dictionary_offset,
    adjectives_offset,
    variables_offset,
    strings_offset;

extern int32 Out_Size;

extern void make_lower_case(char *str);
extern void switches(char *, int);

extern int call_for_br_flag;
extern void compile_box_routine(void);

/* ------------------------------------------------------------------------- */
/*   Extern definitions for Archimedes DDE throwback (see above)             */
/* ------------------------------------------------------------------------- */

#ifdef ARC_THROWBACK
extern void throwback(int severity, char * error);
extern void throwback_start(void);
extern void throwback_end(void);
extern int throwbackflag;
#endif

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "express"                                        */
/* ------------------------------------------------------------------------- */

extern int  next_token, void_context, condition_context,
            assign_context, lines_compiled;
extern char condition_label[];

extern void express_allocate_arrays(void);
extern void express_free_arrays(void);
extern int expression(int fromword);
extern void assignment(int from, int flag);

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "zcode"                                          */
/* ------------------------------------------------------------------------- */

extern int  almade_flag;
extern int  total_chars_trans, total_bytes_trans, trans_length;
extern const char *alphabet[];
extern int  chars_lookup[];

extern int  translate_to_ascii(char c);
extern void make_lookup(void);
extern void make_abbrevs_lookup(void);
extern char *translate_text(char *p, char *s_text);
extern opcode opcs(int32 i);
extern void stockup_symbols(void);
extern void optimise_abbreviations(void);

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "files"                                          */
/* ------------------------------------------------------------------------- */

extern int  override_error_line, total_files_read, input_file;
extern int32 malloced_bytes;
extern char Code_Name[];
extern FILE *Temp1_fp, *Temp2_fp;

extern char *my_malloc(int32 size, char *whatfor);
extern void *my_calloc(int32 size, int32 howmany, char *whatfor);
extern void my_free(void *pointer, char *whatitwas);
extern void fatalerror(char *s);
extern void memoryerror(char *s, int size);
extern void open_temporary_files(void);
extern void check_temp_files(void);
extern void remove_temp_files(void);
extern void print_error_line(void);
extern int  file_end(int32 marker);
extern int  file_char(int32 marker);
extern void add_to_checksum(void *address);
extern int  current_source_line(void);
extern void load_sourcefile(char *story_name);
extern void advance_line(void);
extern void output_file(void);
extern void declare_systemfile(void);
extern int  is_systemfile(void);

extern void set_memory_sizes(int size_flag);
extern void memory_command(char *command);

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "symbols"                                        */
/* ------------------------------------------------------------------------- */

extern int routine_starts_line, used_local_variable[];
extern char *local_varname[];

#ifndef ALLOCATE_BIG_ARRAYS
  extern int32 svals[];
#ifdef VAX
    extern char stypes[];
#else
    extern signed char stypes[];
#endif
#else
  extern int32 *svals;
#ifdef VAX
    extern char *stypes;
#else
    extern signed char *stypes;
#endif
#endif

extern void symbols_allocate_arrays(void);
extern void symbols_free_arrays(void);
extern void init_symbol_banks(void);
extern void prim_new_symbol(char *p, int32 value, int type, int bank);
extern void new_symbol(char *p, int32 value, int type);
extern int prim_find_symbol(char *q, int bank);
extern int find_symbol(char *q);
extern int local_find_symbol(char *q);
extern void new_symbol(char *p, int32 value, int type);
extern void list_symbols(void);

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "inputs"                                         */
/* ------------------------------------------------------------------------- */

extern char *tokens;
extern char *forerrors_buff;
extern int  forerrors_line;
extern int  total_source_line, internal_line;
extern int32 marker_in_file;

extern void inputs_allocate_arrays(void);
extern void inputs_free_arrays(void);
extern void input_begin_pass(void);
extern void dequote_text(char *b1);
extern void word(char *b1, int32 w);
extern int word_token(int w);
extern void textword(char *b1, int w);
extern void no_such_label(char *lname);
extern void warning(char *s);
extern void warning_named(char *s1, char *s2);
extern void error(char *s);
extern void error_named(char *s1, char *s2);
extern void stack_create(void);
extern void stack_line(char *p);
extern int  get_next_line(void);
extern void tokenise_line(void);
extern void make_s_grid(void);

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "tables"                                         */
/* ------------------------------------------------------------------------- */

extern int no_attributes, no_properties, no_globals, max_no_objects,
           no_fake_actions;
extern int dict_entries;
extern int release_number, statusline_flag;
extern int time_set;
extern int resobj_flag;
extern char time_given[];
extern int globals_size, properties_size;
extern int32 prop_defaults[];
extern int prop_longflag[];
extern int prop_additive[];
extern char *properties_table;

extern void tables_allocate_arrays(void);
extern void tables_free_arrays(void);
extern void tables_begin_pass(void);
extern int  dictionary_find(char *dword, int scope);
extern int  dictionary_add(char *dword, int x, int y, int z);
extern int  find_action(int32 addr);
extern void make_global(char *b);
extern void fix_gconstants(char *globs);
extern void make_object(char *b, int flag);
extern void make_class(char *b);
extern void resume_object(char *b, int j);
extern void finish_object(void);
extern void make_verb(char *b);
extern void extend_verb(char *b);
extern void list_object_tree(void);
extern void list_verb_table(void);
extern void show_dictionary(void);
extern void construct_storyfile(void);

/* ------------------------------------------------------------------------- */
/*   Extern definitions for "asm"                                            */
/* ------------------------------------------------------------------------- */

extern int  no_stubbed;
extern int  in_routine_flag;
extern int  ignoring_routine;
extern int  a_from_one;

extern void asm_allocate_arrays(void);
extern void asm_free_arrays(void);
extern int32 constant_value(char *b);
extern void args_begin_pass(void);
extern int  assemble_opcode(char *b, int32 offset, opcode opco);
extern void assemble_label(int32 offset, char *b);
extern void assemble_directive(char *b, int32 offset, int32 code);
