/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import java.awt.Dimension;
import org.zmpp.base.MemoryAccess;
import org.zmpp.instructions.AbstractInstruction;
import org.zmpp.instructions.ExtendedStaticInfo;
import org.zmpp.instructions.InstructionStaticInfo;
import org.zmpp.vm.Machine;
import org.zmpp.vm.PortableGameState;
import org.zmpp.vm.Window6;

public class ExtendedInstruction
extends AbstractInstruction {
    public ExtendedInstruction(Machine machine, int n) {
        super(machine, n);
    }

    public AbstractInstruction.InstructionForm getInstructionForm() {
        return AbstractInstruction.InstructionForm.VARIABLE;
    }

    public AbstractInstruction.OperandCount getOperandCount() {
        return AbstractInstruction.OperandCount.EXT;
    }

    protected InstructionStaticInfo getStaticInfo() {
        return ExtendedStaticInfo.getInstance();
    }

    public AbstractInstruction.InstructionResult doInstruction() {
        switch (this.getOpcode()) {
            case 0: {
                this.save();
                break;
            }
            case 1: {
                this.restore();
                break;
            }
            case 2: {
                this.log_shift();
                break;
            }
            case 3: {
                this.art_shift();
                break;
            }
            case 4: {
                this.set_font();
                break;
            }
            case 9: {
                this.save_undo();
                break;
            }
            case 10: {
                this.restore_undo();
                break;
            }
            case 11: {
                this.print_unicode();
                break;
            }
            case 12: {
                this.check_unicode();
                break;
            }
            case 23: {
                this.mouse_window();
                break;
            }
            case 6: {
                this.picture_data();
                break;
            }
            case 5: {
                this.draw_picture();
                break;
            }
            case 16: {
                this.move_window();
                break;
            }
            case 17: {
                this.window_size();
                break;
            }
            case 18: {
                this.window_style();
                break;
            }
            case 8: {
                this.set_margins();
                break;
            }
            case 19: {
                this.get_wind_prop();
                break;
            }
            default: {
                this.throwInvalidOpcode();
            }
        }
        return new AbstractInstruction.InstructionResult(1, false);
    }

    private void save_undo() {
        int n = this.getMachine().getCpu().getProgramCounter() + 3;
        boolean bl = this.getMachine().save_undo(n);
        this.storeResult(bl ? (short)1 : 0);
        this.nextInstruction();
    }

    private void restore_undo() {
        PortableGameState portableGameState = this.getMachine().restore_undo();
        if (portableGameState == null) {
            this.storeResult((short)0);
        } else {
            int n = portableGameState.getStoreVariable(this.getMachine());
            this.getCpu().setVariable(n, (short)2);
        }
    }

    private void art_shift() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        s = (short)(s2 >= 0 ? s << s2 : s >> -s2);
        this.storeResult(s);
        this.nextInstruction();
    }

    private void log_shift() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        s = (short)(s2 >= 0 ? s << s2 : s >>> -s2);
        this.storeResult(s);
        this.nextInstruction();
    }

    private void set_font() {
        int n = this.getMachine().getScreen().setFont(this.getValue(0));
        this.storeResult((short)n);
        this.nextInstruction();
    }

    private void save() {
        this.saveToStorage(this.getMachine().getCpu().getProgramCounter() + 3);
    }

    private void restore() {
        this.restoreFromStorage();
    }

    private void print_unicode() {
        short s = this.getValue(0);
        this.getMachine().getOutput().printZsciiChar(s, false);
        this.nextInstruction();
    }

    private void check_unicode() {
        this.storeResult((short)3);
        this.nextInstruction();
    }

    private void mouse_window() {
        this.getMachine().getScreen6().setMouseWindow(this.getValue(0));
        this.nextInstruction();
    }

    private void picture_data() {
        int n = this.getUnsignedValue(0);
        int n2 = this.getUnsignedValue(1);
        boolean bl = false;
        if (n == 0) {
            this.writePictureFileInfo(n2);
        } else {
            Dimension dimension = this.getMachine().getPictureManager().getPictureSize(n);
            if (dimension != null) {
                MemoryAccess memoryAccess = this.getMachine().getGameData().getMemoryAccess();
                memoryAccess.writeUnsignedShort(n2, dimension.height);
                memoryAccess.writeUnsignedShort(n2 + 2, dimension.width);
                bl = true;
            }
        }
        this.branchOnTest(bl);
    }

    private void writePictureFileInfo(int n) {
        MemoryAccess memoryAccess = this.getMachine().getGameData().getMemoryAccess();
        memoryAccess.writeUnsignedShort(n, this.getMachine().getPictureManager().getNumPictures());
        memoryAccess.writeUnsignedShort(n + 2, this.getMachine().getPictureManager().getRelease());
    }

    private void draw_picture() {
        int n = this.getUnsignedValue(0);
        int n2 = 0;
        int n3 = 0;
        if (this.getNumOperands() > 1) {
            n3 = this.getUnsignedValue(1);
        }
        if (this.getNumOperands() > 2) {
            n2 = this.getUnsignedValue(2);
        }
        this.getMachine().getScreen6().getSelectedWindow().drawPicture(this.getMachine().getPictureManager().getPicture(n), n3, n2);
        this.nextInstruction();
    }

    private void move_window() {
        this.getMachine().getScreen6().getWindow(this.getUnsignedValue(0)).move(this.getUnsignedValue(1), this.getUnsignedValue(2));
        this.nextInstruction();
    }

    private void window_size() {
        short s = this.getValue(0);
        short s2 = this.getValue(1);
        short s3 = this.getValue(2);
        System.out.printf("@window_size %d %d %d\n", s, (int)s2, (int)s3);
        this.getMachine().getScreen6().getWindow(s).setSize(s2, s3);
        this.nextInstruction();
    }

    private void window_style() {
        int n = 0;
        if (this.getNumOperands() > 2) {
            n = this.getUnsignedValue(2);
        }
        this.getMachine().getScreen6().getWindow(this.getUnsignedValue(0)).setStyle(this.getUnsignedValue(1), n);
        this.nextInstruction();
    }

    private void set_margins() {
        this.getMachine().getScreen6().getWindow(this.getUnsignedValue(2)).setMargins(this.getUnsignedValue(0), this.getUnsignedValue(1));
        this.nextInstruction();
    }

    private void get_wind_prop() {
        short s = (short)this.getWindow(this.getValue(0)).getProperty(this.getUnsignedValue(1));
        this.storeResult(s);
        this.nextInstruction();
    }

    private Window6 getWindow(int n) {
        return n == -3 ? this.getMachine().getScreen6().getSelectedWindow() : this.getMachine().getScreen6().getWindow(n);
    }
}

