/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import java.util.HashMap;
import java.util.Map;
import org.zmpp.base.MemoryReadAccess;
import org.zmpp.instructions.AbstractInstruction;
import org.zmpp.instructions.ExtendedInstruction;
import org.zmpp.instructions.LongInstruction;
import org.zmpp.instructions.Operand;
import org.zmpp.instructions.PrintLiteralInstruction;
import org.zmpp.instructions.Short0Instruction;
import org.zmpp.instructions.Short1Instruction;
import org.zmpp.instructions.VariableInstruction;
import org.zmpp.vm.Instruction;
import org.zmpp.vm.InstructionDecoder;
import org.zmpp.vm.Machine;

public class DefaultInstructionDecoder
implements InstructionDecoder {
    private Map<Integer, Instruction> instructionCache = new HashMap<Integer, Instruction>();
    private MemoryReadAccess memaccess;
    private Machine machine;

    public void initialize(Machine machine, MemoryReadAccess memoryReadAccess) {
        this.memaccess = memoryReadAccess;
        this.machine = machine;
    }

    public Instruction decodeInstruction(int n) {
        Integer n2 = n;
        if (!this.instructionCache.containsKey(n2)) {
            AbstractInstruction abstractInstruction = this.createBasicInstructionInfo(n);
            int n3 = this.extractOperands(abstractInstruction, n);
            if (abstractInstruction.getInstructionForm() == AbstractInstruction.InstructionForm.VARIABLE && abstractInstruction.getOperandCount() == AbstractInstruction.OperandCount.C2OP) {
                LongInstruction longInstruction = new LongInstruction(this.machine, AbstractInstruction.OperandCount.VAR, abstractInstruction.getOpcode());
                for (int i = 0; i < abstractInstruction.getNumOperands(); ++i) {
                    longInstruction.addOperand(abstractInstruction.getOperand(i));
                }
                abstractInstruction = longInstruction;
            }
            n3 = this.extractStoreVariable(abstractInstruction, n3);
            n3 = this.extractBranchOffset(abstractInstruction, n3);
            abstractInstruction.setLength(n3 - n);
            this.instructionCache.put(n2, abstractInstruction);
        }
        return this.instructionCache.get(n2);
    }

    private AbstractInstruction createBasicInstructionInfo(int n) {
        short s = this.memaccess.readUnsignedByte(n);
        if (s == 190) {
            short s2 = this.memaccess.readUnsignedByte(n + 1);
            return new ExtendedInstruction(this.machine, s2);
        }
        if (0 <= s && s <= 127) {
            int n2 = s & 0x1F;
            AbstractInstruction.OperandCount operandCount = AbstractInstruction.OperandCount.C2OP;
            return new LongInstruction(this.machine, n2);
        }
        if (128 <= s && s <= 191) {
            AbstractInstruction.OperandCount operandCount;
            int n3 = s & 0xF;
            AbstractInstruction.OperandCount operandCount2 = operandCount = s >= 176 ? AbstractInstruction.OperandCount.C0OP : AbstractInstruction.OperandCount.C1OP;
            if (operandCount == AbstractInstruction.OperandCount.C0OP) {
                if (n3 == 2 || n3 == 3) {
                    return new PrintLiteralInstruction(this.machine, n3, this.memaccess, n);
                }
                return new Short0Instruction(this.machine, n3);
            }
            return new Short1Instruction(this.machine, n3);
        }
        int n4 = s & 0x1F;
        AbstractInstruction.OperandCount operandCount = s >= 224 ? AbstractInstruction.OperandCount.VAR : AbstractInstruction.OperandCount.C2OP;
        return new VariableInstruction(this.machine, operandCount, n4);
    }

    private int extractOperands(AbstractInstruction abstractInstruction, int n) {
        int n2 = n;
        if (abstractInstruction.getInstructionForm() == AbstractInstruction.InstructionForm.SHORT) {
            if (abstractInstruction.getOperandCount() == AbstractInstruction.OperandCount.C1OP) {
                short s = this.memaccess.readUnsignedByte(n2);
                byte by = (byte)((s & 0x30) >> 4);
                n2 = this.extractOperand(abstractInstruction, by, n2 + 1);
            } else {
                ++n2;
            }
        } else if (abstractInstruction.getInstructionForm() == AbstractInstruction.InstructionForm.LONG) {
            short s = this.memaccess.readUnsignedByte(n);
            byte by = (s & 0x40) > 0 ? (byte)2 : 1;
            byte by2 = (s & 0x20) > 0 ? (byte)2 : 1;
            n2 = this.extractOperand(abstractInstruction, by, n2 + 1);
            n2 = this.extractOperand(abstractInstruction, by2, n2);
        } else if (abstractInstruction.getInstructionForm() == AbstractInstruction.InstructionForm.VARIABLE) {
            n2 += abstractInstruction.getOperandCount() == AbstractInstruction.OperandCount.EXT ? 2 : 1;
            short s = this.memaccess.readUnsignedByte(n2++);
            short s2 = 0;
            boolean bl = false;
            if (abstractInstruction.getOperandCount() == AbstractInstruction.OperandCount.VAR && (abstractInstruction.getOpcode() == 12 || abstractInstruction.getOpcode() == 26)) {
                bl = true;
                s2 = this.memaccess.readUnsignedByte(n2++);
            }
            n2 = this.extractOperandsWithTypeByte(abstractInstruction, s, n2);
            if (bl && abstractInstruction.getNumOperands() == 4) {
                n2 = this.extractOperandsWithTypeByte(abstractInstruction, s2, n2);
            }
        }
        return n2;
    }

    private int extractOperandsWithTypeByte(AbstractInstruction abstractInstruction, int n, int n2) {
        int n3 = n2;
        byte by = (byte)(n >> 6 & 3);
        for (int i = 0; i < 4; ++i) {
            by = (byte)(n >> (3 - i) * 2 & 3);
            int n4 = abstractInstruction.getNumOperands();
            n3 = this.extractOperand(abstractInstruction, by, n3);
            if (abstractInstruction.getNumOperands() == n4) break;
        }
        return n3;
    }

    private int extractOperand(AbstractInstruction abstractInstruction, byte by, int n) {
        int n2 = n;
        if (by == 0) {
            abstractInstruction.addOperand(new Operand(by, this.memaccess.readShort(n2)));
            n2 += 2;
        } else if (by == 2 || by == 1) {
            abstractInstruction.addOperand(new Operand(by, this.memaccess.readUnsignedByte(n2)));
            ++n2;
        }
        return n2;
    }

    private int extractStoreVariable(AbstractInstruction abstractInstruction, int n) {
        if (abstractInstruction.storesResult()) {
            abstractInstruction.setStoreVariable(this.memaccess.readUnsignedByte(n));
            return n + 1;
        }
        return n;
    }

    private int extractBranchOffset(AbstractInstruction abstractInstruction, int n) {
        if (abstractInstruction.isBranch()) {
            short s = this.memaccess.readUnsignedByte(n);
            abstractInstruction.setBranchIfTrue((s & 0x80) > 0);
            if ((s & 0x40) > 0) {
                abstractInstruction.setBranchOffset((short)(s & 0x3F));
                return n + 1;
            }
            short s2 = this.memaccess.readUnsignedByte(n + 1);
            short s3 = (s & 0x20) == 32 ? (short)(0xC000 | (s << 8 | s2 & 0xFF)) : (short)((s & 0x3F) << 8 | s2 & 0xFF);
            abstractInstruction.setBranchOffset(s3);
            return n + 2;
        }
        return n;
    }
}

