/*
 *
 * The Xylophoniad
 *
 * Places
 *
 */

DAEMONS = [];

var Place = new Object;
NUM_PLCS = 0;
function pl(name,fullname,indoors,description,append,sights,special,exits,hExits,daemonBefore,daemonAfter)
{
	Place[++NUM_PLCS] = new Object;
	Place[NUM_PLCS].id = NUM_PLCS;
	Place[NUM_PLCS].name = name;
	Place[NUM_PLCS].fullname = fullname;
	Place[NUM_PLCS].isOutdoors = !indoors;
	Place[NUM_PLCS].description = description;
	Place[NUM_PLCS].append = append;
	Place[NUM_PLCS].sights = sights;
	Place[NUM_PLCS].special = special;
	Place[NUM_PLCS].exits = exits;
	Place[NUM_PLCS].hExits = hExits ? hExits : '';
	Place[NUM_PLCS].daemonBefore = daemonBefore;
	Place[NUM_PLCS].daemonAfter = daemonAfter;
	eval(name + ' = Place[' + NUM_PLCS + '];');
	
	Place[NUM_PLCS].isHorse = false;
	Place[NUM_PLCS].isTroy = false;
}


function set_conditional_exits() {

}

function floor(place) {
	if(!place.isOutdoors) {
		return 'floor';
	} else {
		return 'ground';
	}
}


pl('nowhere',
'nowhere',
'You\'re nowhere! You shouldn\'t be here!',
'',
'',
'');

pl('courtroom',
  'Courtroom',
  true,
  "You're in the grandiose People's Court of Anachronopolis, in which any accused citizen is entitled to \
   a fair trial depending on evidence, reason and what mood the king is in. At the far end is a \
   throne on a high dais; closer to the door, at the west end of the room, are the public benches. \
   The room is lined with white pillars.",
   "",
   {
	   pillar:	"Marble pillars with vertical grooves, stretching from the floor to the ceiling.",
	   bench:   "Long wooden benches for the public attendees to sit on.",
	   chair: "A jewel-encrusted golden throne, designed to make the person sitting on it look \
	           very important and the person looking at it feel very small.",
	   dais: "A high stone platform for the throne to, well, be on.",
	},
	{
		'sit.chair' : sit_on_throne,
		'sit.on.chair' : sit_on_throne,
		
		west: check_ending,
		out: check_ending,
	},
	{ out: 'plaza' },
	{	 west: 'out' },
	null, null
);
function sit_on_throne() {
	if(personloc(eurystheus)==courtroom) {
		say('King Eurysthenes is already sitting on the throne.');
		return true;
	}
	return false;
}
function check_ending() {
	if(gs(CONFRONTED_KING)) {
		winner = true;
		die("So that's it. Three of the most epic achievements in mythology, and not even a thank-you. The king allows " +
		     "himself the rare treat of a laugh as you leave the courtroom.\n\n" +
		     "But mercenary adventuressing isn't a bad life, and you've heard the Duke of Pithikopalis is offering good " +
		     "money for centaur hides. In years to come, the bards will be singing of your adventures, and you'd better " +
		     "give them a few more verses.", "Ending 1 of 2");
		
		return true;
	}
	
	return false;
}

pl('plaza',
	'Plaza',
	false,
	"You're in an open plaza at the centre of Anachronopolis, paved with white flagstones. The main road \
	through the city runs north-south. To the east is the public courtroom, and to the west is the city\'s \
	main temple.",
	'',
	{
		flagstones: "Smooth white flagstones assure you that this is the nice bit of town.",
		courtroom: "A grandiose marble building where the local king spends his day tormenting people.",
		temple: "To see it properly, you'll need to get a bit closer.",
	},
	{
		south: "That would take you away from the interesting part of the city."
	},
	{
		north: 'theatre',
		east: 'courtroom',
		west: 'outside_temple_eris',
	},
	{
	},
null, null
);

pl('outside_temple_eris',
"Outside Temple of Eris",
false,
"You stand outside the main temple in Anachronopolis, built to its matron goddess Eris. \
It is a rectangular building of pinkish granite.\n" +
"On a wall opposite the temple is a mural depicting Narcissus and Echo.",
'',
{
	temple: "A light grey temple with steps leading up to its open doors.",
	painting: "The mural depicts Narcissus carrying his love, the water nymph Echo, into a shallow pool in the forest. Both " +
	 "are happily naked and well toned.",
	narcissus: "The mural depicts Narcissus carrying his love, the water nymph Echo, into a shallow pool in the forest. Both " +
	 "are happily naked and well toned.",},
{},
{ east: 'plaza',
  in: 'temple_eris'
},
{},
null, null);

//function pl(name,fullname,indoors,description,append,sights,special,exits,hExits,daemonBefore,daemonAfter)
pl('temple_eris',
'Temple of Eris',
true,
"You are in a temple. On the wall opposite the door is a painting of this temple\'s goddess, \
Eris. Below the painting is a shallow pool.",
'',
{
	painting: "The painting is a flattering depiction of Eris, goddess of discord, confusion, controversy and \
	          things you know not of. She is depicted in a green robe, hurling a golden apple at some other gods.",
	eris: "[[ temple_eris.sights.painting ]]",
	pool: "A shallow ceremonial pool of clear water, about ankle deep.",
	temple: "[[ temple_eris.description ]]"
},
{
	'in.pool': get_in_pool,
	'jump.in.pool': get_in_pool,
	'stair.in.pool': get_in_pool,
	'take.in.pool' : get_in_pool,
	'stand.in.pool' : get_in_pool,
	swim : get_in_pool,
	pray: "[[ pray('Eris') ]]"
},
{ out: 'outside_temple_eris' },
{},
null, null);
function get_in_pool() {
	// works in all the temples. This is how to travel between areas of the game (except Hades)

	// don't let NPCs follow you through the pools!
	if(gs(ACHILLES_FOLLOWING)) {
		sgs(ACHILLES_FOLLOWING, 0);
		set_personloc(achilles, west_of_troy);
	}
	if(gs(HELEN_FOLLOWING)) {
		sgs(HELEN_FOLLOWING, 0);
		set_personloc(helen, helens_chamber);
	}
	if(gs(BARBER_FOLLOWING)) {
		sgs(BARBER_FOLLOWING, 0);
		set_personloc(barber, barbershop);
	}
		
	say("You stand in the pool. The water comes up to your ankles.");
	sgs(FEET_WET, 1);
	
	if(!in_inv(figurine)) {
		say(" But nothing else happens. You get out, feeling slightly embarrassed.");
		return true;
	}
	
	say("\nYour ivory figurine begins to glow, the water bubbles, everything spins, and suddenly you're elsewhere...\n\n");
	var hloc = heroloc();
	if(hloc==temple_eris) {
		get_point_for(USED_TEMPLE_ERIS);
		set_heroloc(gs(ACHILLES_ENTERED) ? west_of_troy : horse_afthold);
	} else if(hloc==temple_artemis) {
		get_point_for(USED_TEMPLE_ARTEMIS);
		if(!gs(CURED_MINOTAUR)) {
			set_heroloc(maze1);
		} else {
			set_heroloc(labyrinth_end);
		}
	} else if(hloc==temple_poseidon) {
		get_point_for(USED_TEMPLE_POSEIDON);
		set_heroloc(props_cupboard);
	}
	look();
	return true;
	
}
function pray(god) {
	say("You utter a brief prayer to " + god + ".");
	if(in_inv(figurine)) {
		say("\nThe water in the pool glows invitingly for a moment.");
	} else {
		say("\nYou figure you are missing something.");
	}
}

pl('theatre',
	'Theatre',
	false,
	"You are in Anachronopolis' open-air theatre, a circular space with a well of stone benches around the edge, focused \
	on a flat stage area. Behind the stage is a small shack.",
	'',
	{
		bench: "Semicircular stone benches. On performance days they're usually crowded, but there's nobody here at the moment.",
		stage: "An unraised performance area at the focal point of the benches.",
		shack: "A small shack used by the dramatists to store their props and costumes.",
		theatre: "[[ theatre.description ]]",

	},
	{
		north: "That would take you away from the interesting part of the city.",
	},
	{	
		south: 'plaza',
		in: 'props_cupboard'
	},
	{},
null, null
);

pl('props_cupboard',
'Props cupboard',
true,
"You're in a small shack lined with shelves.",
'',
{},
{},
{
	out: 'theatre'
},
{},
null, null);


/*
 *  Crete, home of Daedalus, Sappho, the Minotaur, and the Bicyclops
 */

 
// The Labyrinth
// This is a sort of pseudo-puzzle; you bumble around and the plot will just happen.
 
pl('maze1',
"Labyrinth",
true,
"You are in a labyrinth of twisty little passageways.",
"",
{},
{},
{ north: 'maze1', east: 'maze2', south: 'maze3', west: 'maze4' },
{},
null, do_labyrinth); // only one maze location needs do_labyrinth, it gets called every turn!

pl('maze2',
"Labyrinth",
true,
"You are in a labyrinth of little twisty passageways.",
"",
{},
{},
{ north: 'maze2', east: 'maze3', south: 'maze4', west: 'maze1' },
{},
null, null);

pl('maze3',
"Labyrinth",
true,
"You are in a twisty labyrinth of little passageways.",
"",
{},
{},
{ north: 'maze3', east: 'maze4', south: 'maze1', west: 'maze2' },
{},
null, null);

pl('maze4',
"Labyrinth",
true,
"You are in a little labyrinth of twisty passageways.",
"",
{},
{},
{ north: 'maze4', east: 'maze1', south: 'maze2', west: 'maze3' },
{},
null, null);

// fake maze room, which you are put in when the Minotaur stuff happens, so that you'll always find the exit next turn
pl('maze5',
"Labyrinth",
true,
"You are in a labyrinth of little twisty passageways.",
"",
{},
{},
{ north: 'labyrinth_end', east: 'maze5', south: 'maze5', west: 'maze5' },
{},
null, null);

pl('labyrinth_end',
"Labyrinth exit",
true,
"You are at the end of a passageway in the labyrinth. A ladder leads up to an open hatchway, through which you can see daylight.",
"",
{
	stair: "A very welcome exit from the labyrinth, leading up into bright sunlight.",
},
{	south: "Having found the way out of the labyrinth, you'd rather not go back in.",
	up: function() {
		say('As you emerge into daylight, the hatchway closes behind you, leaving no trace.\n\n');
		return false;
	}
},
{ up: 'outside_daedalus_hut',
  south: 'maze5',
},
{
},
null, null);

maze1.isLabyrinth = true;
maze2.isLabyrinth = true;
maze3.isLabyrinth = true;
maze4.isLabyrinth = true;
maze5.isLabyrinth = true;


function do_labyrinth() {
	
	if(heroloc().isLabyrinth && !gs(CURED_MINOTAUR) && gs(JUST_MOVED)) {
		
		if(!gs(MINOTAUR_CHASING) && heroloc()!=maze1) {
			if(!pick(3)) {
				set_personloc(minotaur, heroloc());
				say("\nSuddenly, a large humanoid figure with the head of a bull emerges from the shadows. The Minotaur!");
				sgs(MINOTAUR_CHASING, 1);
			}
		} else if(gs(MINOTAUR_CHASING)) {
			
			say("\nThe Minotaur thunders after you.");
			
			if(!pick(2)) {
				say("\nThe Minotaur " + pickOne(["punches", "butts", "bites"]) + " you. " + pickOne(["Oof", "Ow", "Ouch"]) + "!");
			} else if(pick(3)) {
				set_heroloc(maze5);
				get_point_for(CURED_MINOTAUR);
				sgs(MINOTAUR_CHASING, 0);
				
				say("\n\nA bizarre creature comes around a corner: a bull, with the greying-bearded head of a middle-aged man.\n" +
				    '"Oh, hallo there," says the face amiably. "Daedalus is the name. Excuse my appearance, but I\'m afraid I had a small ' +
				    'accident with my teleportation experiment. You see, I didn\'t notice that there happened to be a cow in the ' +
				    'room with me and - oh, <i>there</i> you are!" he adds, swishing his tail excitedly as the Minotaur catches ' +
				    'up with the pair of you. "One moment &ndash; I do hope this works..."\n' +
				    "Daedalus lowers his head and charges at the Minotaur. There is a flash of light, and standing before you " +
				    "are two complete creatures: a relieved-looking philosopher and a confused-looking bull.\n" +
				    'Daedalus says, "Come on, it\'s this way," and walks north. ' + 
				    'The bull moos uncertainly and wanders off into the maze.');
				set_personloc(daedalus, daedalus_workshop);
				
			}
		}
		
		
	}
}

traildesc = "The trail is made of a very smooth, grey stone speckled with pinkish grains. It spirals down around the island in a gently curving slope.";

pl('outside_daedalus_hut',
"Hilltop",
false,
"You stand in a small, overgrown garden at the top of a hill. From here, you can see the sea in all directions &ndash; " +
 "you're at the centre of a small island. Cliffs fall away on all sides except the southeast, where a trail of " +
 "some smooth grey surface leads down a gentle slope. To the west, a rough stairway has been hewn out of the cliff, leading " +
 "steeply downwards.\n" +
 "There is a wide, low-ceilinged wooden hut nearby. Above the door is the name \"DAEDALUS\".",
"",
{
	shack: "A wooden hut with a low ceiling and a wide, doorless entryway from the garden. It's nailed together rather roughly, " +
	        "with patches here and there as though it's been blown up and put back together.",
	sea: "The sea stretches majestically in all directions. It's the colour of wine. Well, bluish-green wine.",
	cliff: "Sheer cliffs tumble down on almost every side of you.",
	stair: "A steep, narrow stairway, leading down over the cliff.",
	trail: traildesc,
	bicicicle: look_bike,
},
{
	north: "That would take you over a cliff.",
	northeast: "That would take you over a cliff.",
	east: "That would take you over a cliff.",
	south: "That would take you over a cliff.",
	southwest: "That would take you over a cliff.",
	northwest: "That would take you over a cliff.",
	'jump.off.cliff': jump_off_cliff,
	'jump.cliff': jump_off_cliff,
	
	'take.on.bicicicle' : bike_ride,
	'take.bicicicle' : bike_ride,
	'ride.bicicicle' : bike_ride,
	'up.on.bicicicle' : bike_ride, // "climb on bicicicle"
	'up.bicicicle' : bike_ride,
	bicicicle: bike_ride,
},
{
	in: 'daedalus_workshop',
	southeast: 'outside_temple_poseidon',
	west: 'dock',
},
{
	down: 'west',
},
null, null);
outside_daedalus_hut.isCrete = true;
function look_bike() {
	if(personloc(daedalus)!=outside_daedalus_hut) {
		say("You can't see that here.");
	} else {
		say("Two spoked wheels, one in front of the other, connected by a triangular frame, with a saddle on top. " +
		    "The thing can't possibly be stable, can it? And yet it does seem weirdly inviting. " +
		    "Maybe these things could catch on after all.")
	}
	
	return true;
}

function bike_ride() {
	if(!(gs(BUILT_BICYCLE) && personloc(daedalus)==outside_daedalus_hut)) {
		say("You can't see that here.");
		return true;
	}
	
	say("You cautiously climb on top of the bicicicle. Daedalus gives it a push down the trail, and lets go. " +
	     "The contraption wobbles for a moment, and you think you\'re going to come off...\n\n" +
	     '<span class="locationName">Outside Temple of Poseidon</span>\n' +
	     '...but then it gains stability and picks up speed...\n\n' +
	     '<span class="locationName">Outside clay house</span>\n' +
	     '...as you tear past, the cat screeches and leaps back into the house...[[ set_personloc(cat, sapphos_house) ]]\n\n' +
	     '<span class="locationName">Old dock</span>\n' +
	     '...the path levels off, but you\'re going very fast by now...\n\n' +
	     '<span class="locationName">Bicyclops\' lair</span>\n' +
	     '...the front wheel of the bicicicle hits a carelessly discarded thighbone and the whole thing takes off. ' +
	     'You fly towards the surprised Bicyclops, instinctively raising your sword...');
	 
	if(!in_inv(sword)) {
		say('\n\n... which you don\'t have with you. Why aren\'t you carrying your sword?\n');
		die("The Bicyclops opens its mouth, and you sail neatly inside.");
		return true;
	}
	
	say('\n\nThe Bicyclops turns toward you, a startled expression in its monstrous face. Your sword goes straight into its upper eye, ' +
	     'and emerges from the back of its head. It howls with rage, then slumps to the ground, and disappears in a cloud of ' +
	     'greasy yellow smoke.\n' +
	    'You tumble to the ground and fall off the bicicicle.\n' +
	    'Daedalus swoops down from above, a pair of prosthetic wings strapped to his back. "Excellent!" he says. "My invention ' +
	    'is a total success! Although perhaps I should think about adding some brakes..."\n' +
	    'He scoops up the rather battered bicicicle and flies back up over the cliff to the south.');

	set_personloc(daedalus, daedalus_workshop);
	set_personloc(bicyclops, nowhere);
	set_heroloc(bicyclops_lair);
	get_point_for(FINISHED_BICYCLOPS);
	
	return true;
}

pl('daedalus_workshop',
"Daedalus' workshop",
true,
"You're in a wide, square, low-ceilinged wooden hut. There are shelves all around the room, on which are various " +
 "trinkets and mechanisms, and the floor is bare dirt.",
"",
{
	shelves: "On the shelves are various contraptions of bronze and wood. They all look intricate and rather odd, but none of them look particularly useful.",
	trinkets: "[[ daedalus_workshop.sights.shelves ]]",
},
{
	'take.trinkets': "They don't look like they'd be much use to you.",
	'take.saddle' : "[[ take_from_daedalus(saddle) ]]",
	'take.kithara' : "[[ take_from_daedalus(kithara) ]]",
	'take.cartwheels' : "[[ take_from_daedalus(cartwheels) ]]",
	'open.coldbox': "It has an open top with no lid.",
	'close.coldbox': "It has an open top with no lid.",
},
{ out: outside_daedalus_hut },
{},
null, null);
daedalus_workshop.isCrete = true;
function take_from_daedalus(th) {
	if(personloc(daedalus)==daedalus_workshop && thingloc(th)==daedalus_workshop) {
		say('"Leave that alone, please," says Daedalus. "I ' + (th==saddle ? 'might ' : '') + 'need it for my invention."');
	} else {
		say("You can't see that here.");
	}
}

pl('outside_temple_poseidon',
"Outside Temple of Poseidon",
false,
"The smooth grey trail curves from the northeast to the southwest at the top of an east-facing cliff. " +
 "A symbol is engraved on the trail here.\n" +
 "At the clifftop, facing out to sea, is a driftwood temple to Poseidon.",
'',
{
	temple: "A humble building of driftwood, with an open door.",
	symbol: 'The symbol consists of two circles and an inverted triangle:\n<img style="width: 235px; height: 139px;" class="npc" src="res/trail-symbol.png" />',
	sea: "The sea stretches majestically out to the east. It's the colour of wine. Well, bluish-green wine.",
	trail: traildesc + " There is a symbol engraved on it here, consisting of two circles with an inverted triangle between them.",
	cliff: "A cliff falls away to the east, straight down into the sea.",
},
{
	east: "That would take you over a cliff.",
	'jump.off.cliff': jump_off_cliff,
	'jump.cliff': jump_off_cliff
},
{ southwest: 'outside_sapphos_hut',
  northwest: 'outside_daedalus_hut',
  in: 'temple_poseidon'
},
{
	up: 'northwest',
	down: 'southwest',
},
null, null);
outside_temple_poseidon.isCrete = true;

pl('temple_poseidon',
'Temple of Poseidon',
true,
"You are in a temple. On the wall opposite the door is a painting of this temple\'s god, \
Poseidon. Below the painting, dug into the sandy floor, is a shallow pool.",
'',
{
	painting: "The painting depicts Poseidon, god of the sea. He is shown emerging from a stormy ocean " +
	           "in the form of a giant muscleman, brandishing an angry trident at some unfortunate ship.",
	poseidon: "[[ temple_poseidon.sights.painting ]]",
	pool: "A shallow ceremonial pool of muddy salt water, about ankle deep.",
	temple: "[[ temple_poseidon.description ]]",
},
{
	'in.pool': get_in_pool,
	'jump.in.pool': get_in_pool,
	'stair.in.pool': get_in_pool,
	'take.in.pool' : get_in_pool,
	'stand.in.pool' : get_in_pool,
	swim : get_in_pool,
	pray: "[[ pray('Poseidon') ]]"
},
{ out: 'outside_temple_poseidon' },
{},
null, null);
temple_poseidon.isCrete = true;

pl('outside_sapphos_hut',
"Outside clay house",
false,
"Here the smooth trail curves around a rocky coastline from the northeast to the northwest, passing a small clay house " +
 "with a sea view to the south.",
"",
{
	trail: traildesc,
	coast: "A rocky coastline, against which gentle waves are washing picturesquely.",
	house: "A modest clay house of one storey, decorated on the outside with colourful paints and beads.",
	beads: "Shiny beads hang in little strings from the walls of the house. They're just decoration.",
	sea: "The sea stretches majestically out to the south. It's the colour of wine. Well, bluish-green wine."
},
{
	south: "That would take you into the sea.",
	swim: "Not likely!",
},
{
	northeast: 'outside_temple_poseidon',
	northwest: 'dock',
	in: 'sapphos_house',
},
{
	up: 'northeast',
	down: 'northwest',
},
null, null);
outside_sapphos_hut.isCrete = true;

pl("sapphos_house",
"Sappho's house",
true,
"This is a small clay house, fairly obviously occupied by an artist of some sort. The walls are painted in chaotic colours, " +
 "and beads and chimes hang here and there.",
"",
{
	wall: "The walls have hectic, abstract paint on them, made with various dyes.",
	beads: "Shiny beads hang in little strings from the walls and ceiling. They're just decoration.",
},
{
	out: leave_sapphos_house,
},
{
	out: 'outside_sapphos_hut',
},
{},
null, null);
sapphos_house.isCrete = true;
function leave_sapphos_house() {
	
	if(!gs(GAVE_CAT_FISH) && (in_inv(kithara) || in_inv(aulos))) {
		say("As you're about to leave, the cat yowls and leaps at you.\n" +
		    '"Sorry," says Sappho. "I only let people borrow the instruments if Hecate says it\'s okay."');
		return true;
	}
	
	return false;
}

pl('dock',
"Old dock",
false,
"The smooth trail reaches sea level here, spiralling down from the southeast and continuing northeast around the coast. A " +
"sheer cliff rises to the east, into which a stairway has been cut.\n" +
"There is an old wooden dock here, protruding into the ocean. A short, oddly paved path lined with primroses leads from the smooth trail to the dock.",
"",
{
	dock: "A rickety wooden jetty supported by stilts, proceeding about ten yards into the sea.",
	coast: "The coast here is smooth and sandless, with gentle waves lapping at it.",
	sea: "The sea stretches majestically out to the horizon. It's the colour of wine. Well, bluish-green wine.",
	trail: "The smooth grey trail is connected to the dock by a short path lined with primroses. While it was apparently " +
	        "paved with good intentions, the effect is rather hellish.",
	flowers: "Pale yellow primroses grow along the verges of the short path.",
	sea: "The sea stretches majestically out to the west. It's the colour of wine. Well, bluish-green wine. From here, the water looks somehow high.",
	cliff: "A sheer cliff rises to the east. A stairway has been hewn into it.",
	stair: "A steep, narrow stairway cut into the cliff, leading up as far as you can see.",
},
{
	'take.on.dock': "The jetty doesn\'t look safe to walk on.", 
	'in.dock': "The jetty doesn\'t look safe to walk on.",
	west: "The jetty doesn\'t look safe to walk on.",
	swim: "Not likely!",
	'push.handcart': "[[ push_handcart() ]]",
	'take.in.handcart' : ride_handcart,
	'hades.in.handcart' : ride_handcart, // "go to hell in a handcart"
	'take.on.handcart' : ride_handcart,
	'ride.handcart' : ride_handcart,
	'ride.in.handcart' : ride_handcart,
	'ride.on.handcart' : ride_handcart,
	'in.handcart' : ride_handcart,
	'stand.in.handcart' : ride_handcart,
	'stand.on.handcart' : ride_handcart,
	'take.cartwheels' : take_cartwheels_from_dock,

},
{	northeast: 'bicyclops_lair',
	southeast: 'outside_sapphos_hut',
	up: 'outside_daedalus_hut',
},
{
	east: 'up',
},
null, null);
dock.isCrete = true;

function take_cartwheels_from_dock() {
	if(gs(WHEELS_OFF_HANDCART)) {
		return false;
	} else {
		push_handcart();
		return true;
	}
}

function ride_handcart() {
	if(heroloc()==dock) {
		say("You stand in the handcart. It starts to vibrate, then descends, with you in it, down through layers of solid rock...\n");
		set_heroloc(hades_entrance);
		get_point_for(GONE_TO_HELL);
		say("The handcart comes to a stop in a rocky chamber. You tumble out.\n\n");
		set_thingloc(handcart, hades_entrance);
	} else {
		say("You stand in the handcart. It starts to vibrate, then ascends, with you in it, up through layers of solid rock...\n");
		set_heroloc(dock);
		say("The handcart comes to a stop by the old dock. You tumble out.\n\n");
		set_thingloc(handcart, dock);
	}
	look();
	return true;
}

pl('bicyclops_lair',
"Bicyclops' lair",
false,
"The trail ends here, on a flat grassy area on the north coast of the island. Cliffs rise sharply to the south. " +
 "There are some disturbingly large footprints here, and the ground is littered with bones.",
"",
{
	bones: "Bones of various age and eaten-ness, discarded around the place with no thought to keeping the countryside tidy. " +
	        "Most are human, but there's one almost complete horse skeleton[[ !gs(FOUND_SADDLE) ? (set_thingloc(saddle, bicyclops_lair), ', a half-rotten saddle still attached to its back') : '' ]]." +
	        "[[ get_point_for(FOUND_SADDLE) ]]",
	coast: "The north coast of the island is flat and wild-looking, with some bits of driftwood lying about.",
	stains: "Yep, human blood, all right.",
	footprints: "Very large footprints, apparently made by some sort of giant humanoid." +
	             "[[ personloc(bicyclops)==bicyclops_lair ? ' Possibly the Bicyclops that\\\'s right in front of you.' : '' ]]",
	saddle: "[[ saddle.description ]]",
	trail: "The trail is made of a very smooth, grey stone speckled with pinkish grains. It spirals away to the southwest, " +
	        "around the coast of the island.",
},
{
	'open.bones' : "[[ bicyclops_lair.sights.bones ]]", // "look in bones"
},
{
	southwest: 'dock',
},
{
},
null, null);


/*
 *  Hades
 */

pl('hades_entrance',
"Poorly Gates",
true,
"You are in a rocky chamber, some miles beneath the surface of the earth. It is very hot here, and you smell smoke.\n" +
 "To the north is a pair of twisted, rusty iron gates, above which a sign hangs.",
"",
{
	door: "A pair of gnarled, rusting gates, wedged permanently open. No one gets turned away here.",
	sign: "The sign reads, in spindly metal letters: <i>\"Abandon all hope, ye who enter here.</i>\"",
},
{
	'take.in.handcart' : ride_handcart,
	'take.on.handcart' : ride_handcart,
	'ride.handcart' : ride_handcart,
	'ride.on.handcart' : ride_handcart,
	'in.handcart' : ride_handcart,
	'stand.in.handcart' : ride_handcart,
	'stand.on.handcart' : ride_handcart
},
{ north: 'hades_south' },
{ in: 'north' },
null, doHades);
hades_entrance.isHades = true;
function doHades() {
	var loc = heroloc();
	if(loc.isHades) {
		if((loc==hades_south || loc == hades_north) && !pick(3)) {
			say("\nA " +
			 pickOne(["small", "large", "scrawny", "skinny", "fat"]) + ", " +
			 pickOne(["blob-shaped", "insectoid", "octopoid", "squirming", "wriggling"]) + " demon with " +
			 pickOne(["a fiery whip", "bulls' horns", "cloven hooves", "a pointy tail", "red eyes"]) + " " +
			 pickOne(["scuttles", "scurries", "glides", "runs", "walks", "strides"]) + " past you to the " +
			 pickOne(["south", "north"]) + ".");
		} else if(!pick(3)) {
		say("\n" + pickOne([
					"In the distance, you hear the scream of a tortured soul.",
					"The moans and groans of the damned echo around you.",
					"You hear the scrape of a poker being sharpened.",
					"A smell of brimstone wafts through the air.",
			]));
		}
	}
}

hellwalldesc = "The walls are a fiery orange, with a glow that comes and goes at a slow, irregular beat.";

pl('hades_south',
'Hades',
true,
"You are in a long, wide underground hallway with a rocky floor and iridescent orange walls. To the south are a pair of gnarled iron gates. " +
 "An obsidian door numbered \"5,984,201\" leads west.",
"",
{
	door: "A pair of gnarled, rusting gates, wedged permanently open. No one gets turned away here.",
	sign: "The sign reads, in spindly metal letters: <i>\"Abandon all hope, ye who enter here.\"",
	wall: hellwalldesc,
},
{},
{	north: 'hades_central',
	south: 'hades_entrance',
	west: 'tantalus_cell',
},
{	in: 'west'
},
null, null);
hades_south.isHades = true;

pl('hades_central',
'Hades',
true,
"You are in a long, wide underground hallway with a rocky floor and iridescent orange walls. The corridor continues north and south. " +
 "An obsidian door numbered \"5,984,202\" leads east.",
"",
{
	wall: hellwalldesc,
},
{},
{	north: 'hades_north',
	east: 'sisyphus_cell',
	south: 'hades_south',
},
{	in: 'west'
},
null, null);
hades_central.isHades = true;

pl('hades_north',
'Hades',
true,
"You are in a long, wide underground hallway with a rocky floor and iridescent orange walls. The corridor continues south but " +
 "gets a lot narrower and more unpleasant-looking to the north. An obsidian door numbered \"5,984,203\" leads west.",
"",
{
	wall: hellwalldesc,
},
{
	north: "You think better of going any further into Hades. You're already starting to feel a bit incorporeal.",
},
{	
	west: 'empty_cell',
	south: 'hades_central',
},
{	in: 'west'
},
null, null);
hades_central.isHades = true;

pl('empty_cell',
"Empty cell",
true,
"This is a squalid round cell about twelve cubits across. There is a blue plaque fixed to the wall.",
"",
{
	sign: "This plaque is slightly transparent, and shimmering in and out of sight as though " + 
	       "it's not quite sure whether it's really there or not. In its visible moments, it reads:" +
	       "<div class=\"bluePlaque\"><u><b>XYLOPHONE</b></u>\n<i>Regicide\nUsurpation\nTyranny</i></div>",
},
{},
{ out: 'hades_north' },
{ east: 'out' },
null, null);

// pl(name,fullname,indoors,description,append,sights,special,exits,hExits,daemonBefore,daemonAfter)
pl('tantalus_cell',
"Tantalus' cell",
true,
"This is a small, stinking cell, ten cubits square. There is a blue plaque fixed to the wall. Set into the floor is a pool filled with wine.",
"",
{
	pool: "A circular pool filled with sweet-smelling wine. It looks rather deep.",
	wine: "[[ tantalus_cell.sights.pool ]]",
	sign: "The plaque reads:<div class=\"bluePlaque\"><u><b>TANTALUS</b></u>\n<i>Infanticide\nCannibalism\nDognapping</i></div>",
},
{
	'in.pool': get_in_wine_pool,
	'jump.in.pool': get_in_wine_pool,
	'jump.in.wine': get_in_wine_pool,
	'take.in.pool' : get_in_wine_pool,
	'stand.in.pool' : get_in_wine_pool,
	'in.wine': get_in_wine_pool,
	'take.in.wine' : get_in_wine_pool,
	'stand.in.wine' : get_in_wine_pool,
	'drink.pool.aulos' : drink_wine_with_aulos,
	'drink.wine.aulos' : drink_wine_with_aulos,
	'use.aulos.drink.wine' : drink_wine_with_aulos,
	'use.aulos.drink.pool' : drink_wine_with_aulos,
	'drink.pool' : drink_wine_pool,
	'drink.wine' : drink_wine_pool,
	'take.wine' : drink_wine_pool
},
{ out: 'hades_south' },
{ east: 'out' },
null, function() {
	if(heroloc() == tantalus_cell && !gs(RESCUED_TANTALUS)) {
		
		if(!gs(TANTALUS_PHASE)) {
			// do this every two turns, to stop the player being driven mad
			
			say('\nTantalus glances downwards and spots the wine. ' +
			 '"' + pickOne(["Aha", "Oo", "Wow"]) + ', wine," he says. "' + pickOne(["My favourite!", "Delicious!", "Yum!"]) + '"\n' +
			 'He bends his head to take a drink, but the wine drains away, always staying just below his chin.\n' +
			 '"' + pickOne(["Awww", "No fair", "Bummer", "What a swiz"]) + '," he says sulkily.\n' +
			 'He stands up straight again, and the pool instantly refills up to his neck.');
			
			sgs(TANTALUS_PHASE, 1);
		} else {
			sgs(TANTALUS_PHASE, 0);
		}
		
	}
}
);
function get_in_wine_pool() {
	say("You hop off the edge into the pool.\n" +
	 "That wasn't a smart move. You inhale wine, splutter, and only escape drowning because the torments of Hades " +
	 "are specifically designed not to kill the damned souls. You manage to haul yourself out and shake off the worst of your soaking.");
	return true;
}
function drink_wine_pool() {
	say('As you stoop to drink from the pool, it drains away.');
	if(!gs(RESCUED_TANTALUS)) {
		say('\n"It always does that," says Tantalus.');
	}
	say('\nYou stand up again, and the pool refills[[ gs(RESCUED_TANTALUS) ? "" : " as far as Tantalus\' neck" ]].');
	return true;
}
function drink_wine_with_aulos() {
	if(!in_inv(aulos)) {
		say("You're not carrying that.");
		return true;
	}
	
	say("You stoop down, put the end of the aulos in the pool, and suck some of the wine through it. You succeeded in drinking " +
	    "some of the wine! But you can only drink a few inches before the wine is below the reach of the pipe.");
	return true;
}


// pl(name,fullname,indoors,description,append,sights,special,exits,hExits,daemonBefore,daemonAfter)
pl('sisyphus_cell',
"Sisyphus' cell",
true,
"This is a large cell, about forty cubits square. There is a blue plaque fixed to the wall. " +
 "At the far end of the cell is a short slope, with a boulder [[ gs(RESCUED_SISYPHUS) ? 'at the top of' : 'on' ]] it.",
"",
{
	boulder: "A large, rougly spherical dark grey rock.",
	slope: "An inclined platform, sloping up from one side of the cell to the other. " +
	 "A groove has been worn up the centre of it by the boulder.",
	hill: "[[ sisyphus_cell.sights.slope ]]",
	sign: "The plaque reads:<div class=\"bluePlaque\"><u><b>SISYPHUS</b></u>\n<i>Avarice\nDeceitfulness\nLeaking divine secrets</i></div>",

},
{
	'take.boulder' : "It's far too heavy.",
	'push.boulder' : push_boulder,

	'cheese.boulder' : wedge_boulder, // "cheese" and "wedge" are the same word...
	'drop.cheese.boulder' : wedge_boulder,
	'drop.cheese.slope' : wedge_boulder,
	
},
{
	out: 'hades_central',
},
{
	west: 'out',
},
null, function() {
	if(gs(RESCUED_SISYPHUS) && gs(RESCUED_TANTALUS)) {
		sgs(FINISHED_HADES, 1);
	}
});

function push_boulder() {
	if(gs(RESCUED_SISYPHUS)) {
		say("The boulder is securely wedged at the top of the slope. Best leave it.");
		return true;
	}
	
	say("You try to help Sisyphus push the boulder, but even with the efforts of both of you, it's no use.");
	return true;
}

function wedge_boulder() {
	
	if(gs(RESCUED_SISYPHUS)) {
		say("The boulder is already wedged in place.");
		return true;
	}
	
	if(!in_inv(cheese)) {
		say("You aren't carrying anything suitable to wedge the boulder with.");
		return true;
	}
	
	say("You wait until Sisyphus has got the boulder to the top of the slope, and wedge the cheese under it. " +
	     "The boulder wobbles... and stays put.\n" +
	     '"Yes!" yells Sisyphus triumphantly. "I did it! Suck on that, Zeus!" He punches the air and runs out of the cell.');
	get_point_for(RESCUED_SISYPHUS);
	if(gs(RESCUED_TANTALUS)) {
		sgs(FINISHED_HADES, 1);
	}
	set_personloc(sisyphus, nowhere);
	take_away(cheese);
	return true;
}


/*
 * Troy and environs; the Trojan War, Achilles, Hector, Helen of Troy, and the Medusa
 */
 
// the horse (discovering you're in the horse is a puzzle in itself)

pl('horse_afthold',
'Aft hold',
true,
"You are at the back end of a dark cabin. The floor, walls and ceiling are all made of planks nailed together, and gently curved. \
 You can hear the creaking of wood and the crying of gulls. Two narrow, downward-sloping passageways lead off to the sides.",
"",
{
	wall: "The walls are made of dark wooden planks, nailed together in horizontal rows. They are gently curved, \
	      so that the cabin is slightly wider at the top.",
	ground: "The floor is made of dark wooden planks nailed together. It is gently curved, with a slight sag in the middle.",
	roof: "The roof is made of dark wooden planks nailed together. It is gently arched, slightly higher in the middle.",
	up: "[[ horse_afthold.sights.ceiling ]]",
	passage: "Circular holes lead port and starboard, into thin passageways that curve sharply downwards."
},
{
	down: "Which passageway do you want to use, port or starboard?",
	listen: "You can hear a regular wooden creaking, and the cawing of seabirds."
},
{
	fore: 'horse_forehold',
	port: 'horse_backleftfoot',
	starboard: 'horse_backrightfoot'
},
{
},
null, null); 
horse_afthold.isHorse = true;

pl('horse_forehold',
'Fore hold',
true,
"You are at the front end of a dark cabin. The floor, walls and ceiling are all made of planks nailed together, and gently curved. \
 You can hear the creaking of wood and the crying of gulls. Two narrow, downward-sloping passageways lead off to the sides, \
 and a ladder leads up.",
"",
{
	wall: "The walls are made of dark wooden planks, nailed together in horizontal rows. They are gently curved, \
	      so that the cabin is slightly wider at the top.",
	ground: "The floor is made of dark wooden planks nailed together. It is gently curved, with a slight sag in the middle.",
	roof: "The roof is made of dark wooden planks nailed together. It is gently arched, slightly higher in the middle. \
	          At the fore end, a fixed ladder leads up through an open hatchway.",
	up: "[[ horse_afthold.sights.ceiling ]]",
	passage: "Circular holes lead port and starboard, into thin passageways that curve sharply downwards.",
	stair: "A vertical wooden ladder set flush against the wall."
},
{
	down: "Which passageway do you want to use, port or starboard?",
	listen: "You can hear a regular wooden creaking, and the cawing of seabirds."
},
{
	aft: 'horse_afthold',
	port: 'horse_frontleftfoot',
	starboard: 'horse_frontrightfoot',
	up: 'horse_head',
},
{
},
null, null);
horse_forehold.isHorse = true;

///(name,fullname,indoors,description,append,sights,special,exits,hExits,daemon)
pl('horse_head',
'Bridge',
true,
'You are in a long cabin with a high wall at the aft end, and a wooden ceiling that slopes down to meet the \
floor at the fore end. Set into alcoves in the sloping ceiling are two forward-facing portholes, through which \
you can see a grassy plain stretching eastward away from you, and a walled city in the distance. \
Below the portholes is a free-standing control panel with a lever and a dial. \
A loop of rope hangs from the ceiling.',
'',
{
	wall: "[[ horse_forehold.sights.wall ]]",
	ground: "[[ horse_forehold.sights.floor ]]",
	roof: "The roof is made of dark wooden planks nailed together. It is fairly high at the back, \
	          then comes down in a gently curving slope to meet the floor at the fore end. \
	          There are two forward-facing portholes set into it at about head height.",
	rope: "A loop of thin rope hanging from the ceiling, coming down to \
	       about shoulder height.",
	dial: read_horse_dial,
	lever: "A bronze lever, about a cubit long, [[ gs(HORSE_MOVING) ? 'stuck in a downward position' : \
	        'currently in an upright position' ]]. At the end is a knob carved into the shape of a \
	        horse's head.",
	control: "A control panel on a waist-high pedestal. There is a bronze lever, and a numeric dial \
	          with a moving arrow.",
	window: "Two round windows at about head height, set into recesses in the ceiling so that they \
	         face forwards. \
	         Through them you can see a walled city[[ gs(HORSE_MOVING) ? ', getting closer' : '' ]].",
	city: describe_troy,
	troy: describe_troy,
	tower: "Very tall towers, almost topless."
},
{
	'up.rope': neigh,
	'pull.rope': neigh,
	'take.rope' : neigh,
	'pull.lever': pull_horse_lever,
	'push.lever': pull_horse_lever
},
{ down: 'horse_forehold' },
{},
null,
function() {
	
	if(heroloc().isHorse) {
	
		if(gs(HORSE_PRESSURE)) {
			sgs(HORSE_PRESSURE, gsn(HORSE_PRESSURE) - 1);
			if(heroloc()==horse_head && gs(HORSE_PRESSURE) <= 2) {
				say("\nThe arrow on the dial moves [[ gs(HORSE_PRESSURE) ? 'a little' : 'all the way' ]] to the right.");
			}
		}
		
		if(gs(HORSE_MOVING)==1) {
			sgs(HORSE_MOVING, 2)
		} else if((!(gs(DESTROYED_WALL || gs(CRASHED_INTO_WALL)))) && (gs(HORSE_MOVING) > 1)) {
			// assuming player must be in the horse while it's moving
			
			var n = gsn(HORSE_MOVING);
			
			var clip = (n%2) ? 'CLIP' : 'CLOP';
			
			
			var loud = pickOne([ 'loud', 'thunderous', 'tremendous', 'deafening',
			                     'resounding' ]);
			
			say('\n');
			
			if((
			        !(n%2) && (heroloc()==horse_frontleftfoot || heroloc()==horse_backrightfoot)
			  ) || (
			         (n%2) && (heroloc()==horse_backleftfoot || heroloc()==horse_frontrightfoot)
			  )) {
				say("You are tossed violently as the pillar you are in rises and falls. ");
			}
			                     
			say("With a " + loud + " " + clip + ", the structure lurches forward.");
			if(heroloc()==horse_head) {
				if(n>=9) {
					// say nothing - we're crashing this turn.
				} else if(n==8) {
					say("\nThe city wall rises before you. You're about to hit it!\nMaybe you should grab something...");
				} else if(n==7) {
					say("\nThe city wall is almost upon you.");
				} else if(n==6) {
					say(" Through the portholes, you see the city get very close.");
				} else if(n>=3) {
					say(" Through the portholes, you see the city get closer.");
				} else{
					say(" Through the portholes, you see the city get a little closer.");
				}
			}
			
			if(n==3) { say("\nYou feel the speed of the structure increase to a trot."); }
			if(n==5) { say("\nYou feel the speed of the structure increase to a canter."); }
			if(n==7) { say("\nYou feel the speed of the structure increase to a gallop."); }
			
			if(n==9) {
				// crash into Troy
				say("\nThere is an almighty crash as the structure hits \
				     [[ heroloc()==horse_head ? 'the city wall' : 'something' ]] \
				     and splinters.");
				if(heroloc()==horse_head) {
					die(" As you're at the very front, you're catapulted through one of the portholes and crushed against \
					     the wall. Before everything goes black, you've just enough time to see the \
					     collapsing structure from the outside &ndash; a giant wooden horse.");
				} else {
					say(" As it topples to the ground, you tumble out, and find yourself at the foot of a city wall.\n\
					    \n");
					sgs(CRASHED_INTO_WALL, 1);
					set_heroloc(west_of_troy);
					get_things_out_of_horse();
					look();
				}
				
				
				
			} else {		
				sgs(HORSE_MOVING, n + 1);
			}
			
		}
	}
}
);
horse_head.isHorse = true;
function describe_troy() {
	say("A city of grey stone, surrounded by a high, smooth, circular wall. You see a few very tall towers \
	     poking out the top.");
}
function neigh() {
	if(Token[1]=='up') { // tried to climb the rope
		say("You can't climb the rope, but as you put your weight on it, the");
	} else {
		say("You pull the loop of rope. The");
	}
	
	if(!gs(HORSE_PRESSURE)) {
		say(" cabin trembles and an ear-splitting \"NEIGH!\" sounds all around you.\n\
		     Through the portholes, you see a jet of flame shoot out of the front of the structure.");
		get_point_for(EVER_NEIGHED);
		
		var n = gsn(HORSE_MOVING);
		if(n>=7) {
			say(" The flame hits the city wall, a section of which crumbles and collapses into a pile of rubble. \
			     The structure you are in hits the rubble, topples over, and splinters. You tumble out.\n\
			     \n");
			get_things_out_of_horse();
			get_point_for(DESTROYED_WALL);
			sgs(FIGHTING_HAPPENING, 1);
			
			set_heroloc(west_of_troy);
			look();
			return true;
		}
		
		say("\nThe arrow on the dial moves all the way to the left.");
	} else {
		say("re is a low whickering noise, and the arrow on the dial moves all the way back to the left.");
	}
	sgs(HORSE_PRESSURE, 4);
	return true;
}
function pull_horse_lever() {
	if(!gs(HORSE_MOVING)) {
		say('The lever comes down, and sticks.\n\
		     For a second, nothing happens. Then there is an ominous rumble.\n\
		     The whole structure you are standing in shakes, and you see through the \
		     portholes that it has started moving &ndash; walking, you realise, on the four pillars that lead \
		     down from the hold. With a tremendous CLIP, \
		     the structure lurches forwards.');
		get_point_for(HORSE_MOVING);
	} else {
		say("The lever is stuck in the down position, and won't budge.");
	}	
	return true;
}
function read_horse_dial() {
	say("The dial looks something like a ship's sextant, with a little bronze arrow that swivels along a \
	     semi-circular gauge inscribed with numerals. ");
	if(!gs(HORSE_PRESSURE)) {
		say(" The arrow is currently all the way to the right.");
	} else if(gs(HORSE_PRESSURE)==1 || gs(HORSE_PRESSURE)==2) {
		say(" The arrow is currently pointing somewhere in the middle.");
	} else if(gsn(HORSE_PRESSURE)>2) {
		say(" The arrow is currently all the way to the left.");
	}
}
function get_things_out_of_horse() {
	for(var i=1; i<=NUM_THNG; ++i) {
		if(thingloc(Thing[i]).isHorse) {
			set_thingloc(Thing[i], west_of_troy);
		}
	}
}


pl('horse_backleftfoot',
'Aft port pillar',
true,
'You are at the bottom of a narrow wooden vertical passageway. A fixed ladder leads up, bending round to starboard.',
'',
{
	wall: "The walls are made of dark wooden planks, nailed together in horizontal rows.",
	ground: "The floor is made of dark wooden planks nailed together.",
	roof: "Above you, the passage curves round to starboard.",
	stair: "A vertical wooden ladder set flush against the wall."
},
{
},
{
	up: 'horse_afthold'
},
{},
null, null);
horse_backleftfoot.isHorse = true;

pl('horse_backrightfoot',
'Aft starboard pillar',
true,
'You are at the bottom of a narrow wooden vertical passageway. A fixed ladder leads up, bending round to port.',
'',
{
	wall: "The walls are made of dark wooden planks, nailed together in horizontal rows.",
	ground: "The floor is made of dark wooden planks nailed together.",
	roof: "Above you, the passage curves round to port.",
	stair: "A vertical wooden ladder set flush against the wall."
},
{
},
{
	up: 'horse_afthold'
},
{},
null, null);
horse_backrightfoot.isHorse = true;

pl('horse_frontleftfoot',
'Fore port pillar',
true,
'You are at the bottom of a narrow wooden vertical passageway. A fixed ladder leads up, bending round to starboard.',
'',
{
	wall: "The walls are made of dark wooden planks, nailed together in horizontal rows.",
	ground: "The floor is made of dark wooden planks nailed together.",
	roof: "Above you, the passage curves round to starboard.",
	stair: "A vertical wooden ladder set flush against the wall."
},
{
},
{
	up: 'horse_forehold'
},
{},
null, null);
horse_frontleftfoot.isHorse = true;

pl('horse_frontrightfoot',
'Fore starboard pillar',
true,
'You are at the bottom of a narrow wooden vertical passageway. A fixed ladder leads up, bending round to port.',
'',
{
	wall: "The walls are made of dark wooden planks, nailed together in horizontal rows.",
	ground: "The floor is made of dark wooden planks nailed together.",
	roof: "Above you, the passage curves round to starboard.",
	stair: "A vertical wooden ladder set flush against the wall."
},
{
},
{
	up: 'horse_forehold'
},
{},
null, null);
horse_frontrightfoot.isHorse = true;

for(var i=1; i<NUM_PLCS; ++i) {
	if(Place[i].isHorse) {
		['north', 'northeast', 'east', 'southeast', 'south', 'southwest', 'west', 'northwest'].forEach(function(dir) {
			Place[i].special[dir] = "Compass directions don't mean much in here. Try fore, aft, port, or starboard.";
		});
	}
}


troy_wall_description = "A high wall of flush stone blocks, built to keep invaders out of the city.";
pl('west_of_troy',
'West of Troy',
false,
'You stand outside the western wall of \
[[ gs(ACHILLES_ENTERED) ? "Troy" : "a great city, which you recognise as Troy" ]].\
 The wall \
[[gs(DESTROYED_WALL) ? "has been partially destroyed, providing a convenient entrance to the city." : \
"is high and smooth. A trail runs northeast and southeast around the outside of the wall." ]]\n\
You see here the splintered remains of a giant wooden horse.',
'',
{
	horse: "An enormous wooden horse, now sprawled on the ground with its neck and legs shattered. \
	        As you watch, a bit of [[ horse_part() ]] \
	        falls off.",
	wall: "[[ troy_wall_description ]][[ gs(DESTROYED_WALL) ? \" Unfortunately for the Trojans, a large section of it has been \
	       destroyed.\" : \"\" ]]"
},
{
	'in.horse' : "The horse doesn't look safe to enter.",
	'fix.horse' : "You're neither a vet nor a carpenter."
},
{
},
{
},
function() {
	// make 'trojan horse' refer to horse
	for(var i=2; i<=MAX_TOKENS; ++i) {
		if(Token[i]=='horse' && Token[i-1]=='trojan') {
			Token[i-1] = 'horse';
			for(var j=i; j<MAX_TOKENS; ++j) {
				Token[j]=Token[j+1];
			}
			Token[MAX_TOKENS] = '';
			break;
		}
	}

	// set exits that appear if the wall is destroyed
	if(gs(DESTROYED_WALL)) {
		west_of_troy.exits = {
			northeast: 'north_of_troy',
			east: 'outside_fort',
			southeast: 'south_of_troy',
			west: 'siege_camp'
		}
		outside_fort.exits = {
			east: 'palladium_garden',
			west: 'west_of_troy',
			up: 'fort'
		}
	} else {
		west_of_troy.exits = {
			northeast: 'north_of_troy',
			southeast: 'south_of_troy',
			west: 'siege_camp'
		}
		outside_fort.exits = {
			east: 'palladium_garden',
			up: 'fort',
		}
	}
},
function() {
	if(heroloc()==west_of_troy) {
		if(!gs(ACHILLES_ENTERED)) {
			
			sgs(ACHILLES_ENTERED, 1);
			sgs(ACHILLES_CRYING, 1);
			//set_personloc(achilles, west_of_troy);
			
			// You've wrecked the horse
			say('\n\nAchilles, a Greek general in golden armour, rushes up to you. "Do you have any idea \
			     what you\'ve <i>done?"</i> he cries. "That machine took my corps of \
			     engineers months to build. I had to make dodgy bargains with half a dozen different \
			     gods to get the magic working. Look at it, it\'s matchwood!"');
			
			if(gs(DESTROYED_WALL)) {
			    // You've wrecked the horse, destroyed the wall, and started the fighting
				say('\nSomewhere a horn blows. A garrison of hundreds of Greek troops runs in from the west, and bolts \
				    through the hole in the wall. An alarm bell rings somewhere in \
				    the city, and soon the familiar sound of clashing swords is filling the air.\n\
				    "No, no!" Achilles waves, trying to stop them, to no effect. "That wasn\'t the signal. We\'re not ready!"');
			}
			
			say('\nHe falls to his knees in despair.');
			set_personloc(achilles, west_of_troy);
		}
		
		else if(!pick(3)) {
			say('\nA bit of ' + horse_part() + ' falls off the horse.');
		}
	}	
}
	
);
function horse_part() {
	return pickOne(['mane', 'wither', 'fetlock', 'shank', 'hoof', 'pastern' ]);
}

function describe_war() {
	if(gs(FIGHTING_HAPPENING)) {
		return ("\nHordes of Greek and Trojan soldiers are fighting in the [[ heroloc()==palladium_garden ? \
		         'open' : 'streets' ]].");
	} else return "";
}
function war_action() {
	if(heroloc().isTroy && heroloc().isOutdoors && gs(FIGHTING_HAPPENING)) {
		var GorT = pickOne(["Greek", "Trojan"]);
		var TorG = GorT=="Greek" ? "Trojan" : "Greek";
		
		say('\n' + pickOne([
			"An injured " + GorT + " soldier [[ pickOne(['runs', 'crawls', 'limps', 'goes flying']) ]] past you.",
			"One of the " + GorT + " soldiers [[ pickOne(['swings', 'thrusts']) ]] his \
			 [[ pickOne(['sword', 'spear']) ]] and [[ pickOne(['mows', 'cuts']) ]] down \
			 [[ pickOne(['some', 'a couple of', 'a few']) ]] " + TorG + "s.",
			"A " + GorT + " soldier breaks from the battle and runs away, screaming.",
			"Some " + GorT + " soldiers run [[ pickOne(['past you', 'round a corner']) ]], pursued by \
			 a unit of " + TorG + "s.",
			"A " + GorT + " soldier stabs a " + TorG + " soldier in the [[ pickOne(['neck','back','heart']) ]].",
			"A[[ pickOne(['n arrow', ' spear']) ]] comes flying through the air and skewers a " + GorT + " soldier.",
			"Two " + GorT + " soldiers carry off a wounded comrade."
		]));
	}
}
function fight_soldiers() {
	if(gs(GREEKS_LEAVING)) {
		say("The fighting is over.");
	} else if(!gs(FIGHTING_HAPPENING)) {
		say("You can't see any soldiers here.");
	} else {
		if(!in_inv(sword)) {
			say("You swing your fist and punch out a Trojan soldier. Or maybe he was a Greek.");
		} else {
			say("You swing your sword and cut down a couple of Trojans. Or maybe they were Greeks.");
		}
		say(" It doesn't seem to make much difference to either side.");
	}
	return true;
}
function look_soldiers() {
	if(gs(GREEKS_LEAVING)) {
		say("Greek soldiers continue to walk, limp, or be carried out of the city with weary faces.");
		return true;
	} else if(gs(FIGHTING_HAPPENING)) {
		say("There is confused fighting all around you between the Trojans, who weren't expecting to be \
		     attacked, and the Greeks, who weren't expecting to attack. It doesn't seem to be going \
		     particularly well for either side.");
		return true;
	} else {
		say("You can't see any soldiers here.");
		return false;
	}
}
function look_dead() {
	if(gs(FIGHTING_HAPPENING) || gs(GREEKS_LEAVING)) {
		
		say("Dead and wounded soldiers pile up at the sides of the streets. The score seems to be \
		     about even.");
		
		return true;
	} else {
		say("You can't see that here.");
		return true;
	}
}

pl('outside_fort',
'Outside Fort',
false,
"You are in the west side of the city of Troy, beside[[ gs(DESTROYED_WALL) ? ' a huge hole in' : '' ]] the great wall. \
Above you is a temporary fortification supported on four wooden struts made from tree trunks. A rope ladder leads up through \
a trapdoor in its floor.",
'[[ describe_war() ]]',
{
	soldiers: look_soldiers,
	greek: look_soldiers,
	trojan: look_soldiers,
	dead: look_dead,
	fort: "A safe-enough-looking rope ladder leads up into a cubical wooden fort supported by struts and [[ gs(DESTROYED_WALL) ? \"what's left of \" : '' ]]the city wall.",
	stair: "A safe-enough-looking rope ladder leads up into a cubical wooden fort supported by struts and [[ gs(DESTROYED_WALL) ? \"what's left of \" : '' ]]the city wall.",
	rope: "[[ outside_fort.sights.stair ]]",
	wall: west_of_troy.sights.wall,
},
{
	'fight.soldiers' : fight_soldiers,
	'fight.greek' : "But you\'re supposed to be on their side, and nobody\'s paying you otherwise.",
	'fight.trojan' : fight_soldiers
},
{
	east: 'palladium_square',
	up: 'fort',
},
{ in: 'up' },
function() {
	if(gs(DESTROYED_WALL)) {
		outside_fort.exits['west'] = 'west_of_troy';
	}
},
war_action
);
outside_fort.isTroy = true;

pl('fort',
"Fort",
true,
"You are in a tall fortification that stands against the inside of the Trojan wall" +
"[[ gs(DESTROYED_WALL) ? ', or at least where the wall used to be' : '']]. The wooden fort " +
"wobbles uncertainly as you move.",
'',
{},
{
	down: leave_fort,
	out: leave_fort,
},
{ down: 'outside_fort' },
{ out: 'down' },
null, 
function() {
	if(heroloc()==fort && (personloc(achilles)==fort || personloc(achilles)==outside_fort) && personloc(hector)==fort) {
		if(gs(ACHILLES_FOLLOWING)) {
			sgs(ACHILLES_FOLLOWING, 0);
			set_personloc(achilles, fort);
			if(personloc(achilles)==outside_fort) {
				say('\nAchilles follows you.');
			}
			say('\n\nPatroclus sees Achilles and gives a cry of joy.\n' +
			    "Achilles and Hector's eyes lock, and they both square their shoulders.");
			
		}
		achilles_fights_hector();
	}
}
);

function leave_fort() {
	if(personloc(achilles)==fort && personloc(hector)==fort && (gs(ACHILLES_BAREFOOT) || gs(PALLADIUM_CURED)) ) {	
		say(pickOne(['Achilles', 'Hector']) + ' dodges a swing and jumps in front of you, blocking your way out.');
		return true;
	} else {
		return false;
	}
}

pl('outside_citadel',
"Outside Citadel",
false,
"You are outside the Citadel of Troy, an impressive fortress of sun-bleached stone. Its huge gates " +
 "[[ !gs(WAR_OVER) ? 'are currently closed and locked due to the war' : 'are open' ]].",
'[[ describe_war() ]]',
{
	castle: "The Citadel of Troy is an enormous, towering structure with narrow windows and high turrets, \
	         set against the wall that boundaries the city to the north." +
	         "[[!gs(WAR_OVER) ? '' : ' It is under lockdown for the duration of the war.']]",
	door: "The huge gates of the Citadel are [[ gs(WAR_OVER) ? 'open' : 'closed' ]].",
	wall: "[[ troy_wall_description ]]",
	soldiers: look_soldiers,
	greek: look_soldiers,
	trojan: look_soldiers,

},
{
	in: enter_citadel,
	north: enter_citadel,
},
{	south: 'palladium_garden',
 	in: 'citadel'
},
{
	north: 'in',
},
null, null
);
outside_citadel.isTroy = true;
function enter_citadel() {
	if(!gs(WAR_OVER)) {
		say("The gates are firmly closed, as the citadel is locked down for the duration of the war.");
		return true;
	}
	return false;
}

pl('citadel',
"Citadel",
true,
"You stand in the wide, candlelit entrance hall to the Citadel of Troy. The war hasn't been over for long, " +
 "so the staff don't seem to have returned to their work yet. A spiral staircase leads upwards.",
"",
{
	stair: "A spiral stairway of dark granite steps, each slightly buckled in the middle by centuries of stair-up-and-down-goers.",
},
{
},
{	out: 'outside_citadel',
	up: 'landing'
},
{},
null, null
);
citadel.isTroy = true;

pl('landing',
"Landing",
true,
"You are on a bare landing in the Citadel, at the top of a spiral staircase. A scarlet-painted door leads north.",
'',
{
	door: "A wooden door painted deep red.[[ !gs(BEDCHAMBER_UNLOCKED) ? ' It is locked, and there\\\'s a heart symbol \
	       engraved on the lock.' : '' ]]",
	lock: "A bronze lock. There is a heart symbol engraved on it.",
},
{
	open: enter_bedchamber,
	north: enter_bedchamber,
	in: enter_bedchamber,
	lock: "That would be pointless.",
	'fight.door' : "Even in the face of such violent treatment, the door continues to do its job admirably.",
},
{
	north: 'helens_chamber',
	down: 'citadel',
	out: 'citadel',
},
{
	in: 'north',
},
null, null);
landing.isTroy = true;
function enter_bedchamber() {
	if(gs(BEDCHAMBER_UNLOCKED)) {
		if(Token[1]!='in' && Token[1]!='north') {
			say('The door is already unlocked.');
			return true;
		} else {
			return false;
		}
	}

	if(!in_inv(key)) {
		say("The door is locked.");
		return true;
	} else {
		say("Your bronze key fits in the lock, and you enter.\n\n");
		get_point_for(BEDCHAMBER_UNLOCKED);
		Token[1] = 'north';
		Token_str = 'north';
		return false;
	}
}

pl('helens_chamber',
"Bedchamber",
true,
"You are in a plush chamber draped with lace and red velvet. At one end of the room is a " +
 "four-poster bed. Opposite it, a painting hangs on the wall.",
'',
{
	bed : "A wooden four-poster with lace curtains. It doesn't look slept <i>in</i>, but there's a dent in the " + 
	 "middle where someone's definitely been sleeping <i>on</i> it.",
	painting : "It's a rather twee painting of a sailing ship on a pleasantly calm sea.",
},
{},
{	out: 'landing'	},
{	south: 'out' },
null, null
);
helens_chamber.isTroy = true;




pl('outside_barbershop',
"Outside barber's shop",
false,
"You stand in the back streets of Troy, surrounded by small stone buildings spangled with pillars \
and onion domes. One building has a red and white striped pole sticking out of it, and a sign \
reading \"BARBER\". There is a narrow gate in the city wall to the east.",
"[[ describe_war() ]]",
{
	soldiers: look_soldiers,
	greek: look_soldiers,
	trojan: look_soldiers,
	dead: look_dead,
	door: "The narrow back gate to Troy, used by the occasional diplomat, washerwoman or god who \
	       needs to get through the siege.",
	pole: "A thin pole with red and white stripes spiralling the length of it.",
	pillar: "Fascinating Trojan architecture.",
	dome: "Fascinating Trojan architecture.",
	wall: '[[ troy_wall_description ]]'
},
{
	'fight.soldiers' : fight_soldiers,
	'fight.greek' : "But you\'re supposed to be on their side, and nobody\'s paying you otherwise.",
	'fight.trojan' : fight_soldiers
},
{ east: 'east_of_troy',
  west: 'palladium_garden',
  in: 'barbershop'
},
{},
null, null
);
outside_barbershop.isTroy = true;

pl('barbershop',
"Barber's shop",
true,
"This is a cozy room with a chair at the centre. A frieze is carved into one wall, and there is a \
bronze mirror on another.",
"",
{
	chair: "A comfortable-looking wooden chair with cloth upholstery.",
	mirror: "You can just about make out the outline of a mercenary adventuress peering back at you. It's not a very good mirror.",
	frieze: "The frieze contains various scenes of this barber at some of his finest moments &ndash; cutting the locks of generals, demigods, and even a mythical creature or two.",
},
{
	sit: barbershop_sit,
	out: lead_barber,
	'look.in.mirror' : "[[ barbershop.sights.mirror ]]",
	'open.mirror' : "[[ barbershop.sights.mirror ]]", // "look in" -> "open"
	'take.mirror' : "It's fixed to the wall.",
},
{ out: 'outside_barbershop' },
{},
null, null);
function barbershop_sit() {
	if(personloc(barber)!=barbershop) {
		return false;
	}
	
	if(gs(PAID_BARBER)) {
		say("You sit down, and the barber cuts a half-inch off your hair.");
		sgs(PAID_BARBER, 0);
	} else {
		say('The barber stops you. "Money up front," he says.');
	}
	return true;
}
function lead_barber() {
	if(gs(PAID_BARBER)) {
		sgs(BARBER_FOLLOWING, 1);
	}
	return false;
}
barbershop.isTroy = true;

pl('palladium_garden',
'Palladium Garden',
false,
"This is a beautiful public square in the middle of Troy, with clean paved paths, short-cut grass, \
and colourful flowers. At the centre is [[ gs(PALLADIUM_CURED) ? 'an empty plinth' : \
'a statue, the Palladium itself' ]].",
"[[ describe_war() ]]",
{
	palladium: "The Palladium is [[ gs(PALLADIUM_CURED) ? 'gone.' : 'a statue of a young woman, prized by the Trojans. The local legend has it that Troy \
	            cannot fall while the Palladium stands. It is life-size and eerily life-like.' ]]",
	ground: "Close-cropped, bright green grass.",
	flowers: "Pretty flowers of all sizes, shapes and colours.",
	plinth: "It's a handsome plinth.",
	trail: "Nice, polished little paths leading in an orderly pattern around the gardens.",
	soldiers: look_soldiers,
	greek: look_soldiers,
	trojan: look_soldiers,
	dead: look_dead
},
{
	'fight.soldiers' : fight_soldiers,
	'fight.greek' : "But you\'re supposed to be on their side, and nobody\'s paying you otherwise.",
	'fight.trojan' : fight_soldiers,
	
	'smell.flower' : "Lovey!",
	
	'fight.palladium' : "Your attack clangs harmlessly off the Palladium.",
	'push.palladium' : "It's too heavy to push over.",
	
	'rub.ointment.palladium' : anoint_palladium,
	'rub.ointment.on.palladium' : anoint_palladium,
	'wear.ointment.palladium' : anoint_palladium,
	'anoint.palladium' : anoint_palladium,
	'anoint.ointment.palladium' : anoint_palladium,
	'anoint.ointment.on.palladium' : anoint_palladium,
	'drop.ointment.palladium' : anoint_palladium,
	'drop.ointment.on.palladium' : anoint_palladium,
	'use.ointment.palladium' : anoint_palladium,
	'use.ointment.on.palladium' : anoint_palladium
},
{ north: 'outside_citadel',
  east: 'outside_barbershop',
  south: 'outside_temple_artemis',
  west: 'outside_fort'
},
{},
function() {
	if(heroloc()==palladium_garden) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='statue') {
				Token[i] = 'palladium';
				Token_str = Token_str.replace('.statue', '.palladium');
			}
		}
	}
},
null);
palladium_garden.isTroy = true;
function anoint_palladium() {
	if(!in_inv(ointment)) {
		say("You haven't got any ointment.");
		return true;
	}
	
	say("You rub some of the ointment on the Palladium.\n\
	     The statue warms up, softens, and changes colour... and you realise you are rubbing a living person.\n\
	     The young woman flinches and blinks as if waking from a nightmare.");
	if(gs(FIGHTING_HAPPENING)) {
		say(" She looks around at the ongoing carnage, screams, and runs away.");
	} else {
		say(" She gives you a puzzled stare, then wanders off in a daze.");
	}
	get_point_for(PALLADIUM_CURED)
	
	if(personloc(achilles)==fort) {
		say("\nA moment later, you hear an enraged scream coming from the west.");
		sgs(GREECE_WON_WAR, 1);
		set_personloc(patroclus, nowhere);
		set_personloc(achilles, sandy_beach);
		sgs(SHIP_STATUS, SHIP_BOARDING);
		end_war();
	}
	
	return true;
}

pl('outside_temple_artemis',
"Outside Temple of Artemis",
false,
"You stand outside the main temple in Troy, built to its matron goddess Artemis. \
It is an octagonal building of yellow sandstone.",
'[[ describe_war() ]]',
{
	temple: "A golden-yellow temple with steps leading up to its open doors."
},
{},
{ north: 'palladium_garden',
  in: 'temple_artemis'
},
{},
null, null);
outside_temple_artemis.isTroy = true;

pl('temple_artemis',
'Temple of Artemis',
true,
"You are in a temple. On the wall opposite the door is a painting of this temple\'s goddess, \
Artemis. Below the painting is a shallow pool.",
'',
{
	painting: "The painting is a depiction of Artemis, goddess of wild animals, and hunting, which seems like a bit of a conflict of interests, and also of women's diseases, possibly because no other gods wanted them. \
	          She is depicted running through a forest with a friendly deer at her side.",
	artemis: "[[ temple_artemis.sights.painting ]]",
	pool: "A shallow ceremonial pool of clear water, about ankle deep.",
	temple: "[[ temple_artemis.description ]]",
},
{
	'in.pool': get_in_pool,
	'jump.in.pool': get_in_pool,
	'stair.in.pool': get_in_pool, // "step into pool"
	'take.in.pool' : get_in_pool,
	'stand.in.pool' : get_in_pool,
	swim : get_in_pool,
	pray: "[[ pray('Artemis') ]]"
},
{ out: 'outside_temple_artemis' },
{},
null, null);
temple_artemis.isTroy = true;

pl('south_of_troy',
'South of Troy',
false,
"You stand outside the southern wall of Troy. The ground here is squelchy and rather smelly &ndash; \
this must be where the Trojans have been tipping out their, er, byproducts for ten besieged years. \
The grass is certainly very green.",
"",
{ wall: "[[ troy_wall_description ]]",
  city: describe_troy,
  troy: describe_troy,
  ground: "Very damp, soggy grass. Your feet almost stick in it. Yuck!",
},
{},
{	northeast: 'east_of_troy',
	west: 'hills',
	northwest: 'west_of_troy'
},
{
	smell: "Everything here smells of ordure.",
	sit: "This doesn't look (or smell) like a nice place to sit down."
},
null,
function() {
	if(heroloc()==south_of_troy) {
		say('\nYour feet are getting wet[[ gs(FEET_WET) ? "ter" : "" ]]. Yuck!');
		sgs(FEET_WET, 1);
	}
	else if(gs(FEET_WET)) {
		say("\nYour feet dry off.");
		sgs(FEET_WET, 0);
	}
}
);

pl('east_of_troy',
"East of Troy",
false,
"You stand outside the eastern wall of Troy. There is a small gate here, providing access for the \
odd diplomat but carefully designed to be narrower than an invading army.",
"",
{
	door: "The narrow back gate to Troy, used by the occasional diplomat, washerwoman or god who \
	       needs to get through the siege.",
	wall: "[[ troy_wall_description ]]",
	city: describe_troy,
	troy: describe_troy
},
{
	west: check_guard,
	in: check_guard
},
{ southwest: 'south_of_troy',
  northwest: 'north_of_troy',
  in: 'outside_barbershop'
},
{ west: 'in' },
null,
null
);
function check_guard() {
	// if the guard is here, he stops you.
	// You can kill, bribe or seduce him.
	
	if(personloc(guard)==east_of_troy && !asleep(guard)) {
		say('The guard lowers his pike to bar your way. "This is a siege, miss," he says. \
		     "That means no Greeks allowed. [[ pickOne(["On your way", "Hop it", "Be off with you"]) ]]."')
		return true;
	}
	
	return false;
}

pl('north_of_troy',
"North of Troy",
false,
"You stand outside the northern wall of Troy, on a dry plain. To the north lies the Sea of Helle, a \
stunningly bright blue.",
"",
{
	sea:  "The Sea of Helle connects the Marmara to the Aegean sea. It's a clear enough day \
	      to make out the land of the Thracian peninsula on the northern horizon.",
	helle: "[[ north_of_troy.sights.sea ]]",
	wall: "[[ troy_wall_description ]]",
	city: describe_troy,
	troy: describe_troy
},
{
	north: "The sea blocks your way in that direction.",
	swim: "Not likely!"
},
{
	southeast: 'east_of_troy',
	southwest: 'west_of_troy'
},
null, null);


pl('siege_camp',
"Siege camp",
false,
"[[ describe_siege_camp() ]]",
"",
{
	tent: "Tents of various sizes and colours, ranging from cloth hovels for the lowly troops \
	       to ornate pavilions for the officers.",
	soldiers: "[[ describe_camp_soldiers() ]]",
	greek: "[[ descripe_camp_soldiers() ]]",
	sea: "The Aegean sea stretches out to the west. Greece is presumably somewhere on the other side.",
	ship: "[[ gs(SHIP_STATUS)==SHIP_GONE ? 'That ship has sailed.' : 'A military ship is moored a way out to sea.' ]]",
	troy: describe_troy,
	coast: "A beach lies to the west, running a way south down the coast.",
},
{
	in: "The tents are buttoned up securely.",
	'open.tent' : "The tents are buttoned up securely.",
	'talk.soldiers': talk_camp_soldiers,
	'fight.soldiers': fight_camp_soldiers,
	'fight.greek': fight_camp_soldiers,
	'soldiers' : misc_camp_soldiers
},
{
	east: 'west_of_troy',
	south: 'hills',
	west: 'sandy_beach'
},
{},
null,
function() {
	if(heroloc()==siege_camp && !gs(DESTROYED_WALL) && !gs(WAR_OVER)) {
		say("\n" + pickOne([
			"A solider emerges from a tent and walks into another tent.",
			"One of the soldiers sharpens his spear.",
			"Two of the soldiers have a practice fight.",
			"A group of soldiers sit down and play dice.",
			"A small troop of soldiers marches by in formation.",
			"A soldier hands a piece of papyrus to another soldier."
		]));
	}	
}
);
function describe_siege_camp() {
	
	var txt = "You stand among the tents and pavilions of a Greek siege camp.";
	
	if(!gs(DESTROYED_WALL) && !gs(WAR_OVER)) {
		txt += " A number of soldiers are pottering about here."
	}
	
	txt += " To the east, in the distance, stands the walled city of Troy. To the west \
	           lies a beach[[ gs(WAR_OVER) ? '' : ', and you see a ship moored a little way out to sea' ]]. The land \
	           becomes hilly to the south.";
	
	return txt;
	
}
function describe_camp_soldiers() {
	if(gs(DESTROYED_WALL)) {
		say("There are no soldiers here.");
	} else {
		say("The camp is bustling with Greek soldiers, carrying spears or swords and wearing \
		     whatever armour they could fit into. Some look busy, some less so, but they all \
		     look mean, and a bit tired.");
	}
}
function talk_camp_soldiers()
{
	if(gs(DESTROYED_WALL)) {
		say("There are no soldiers here.");
	} else {
		say("The soldiers ignore you.");
	}
	return true;
}
function fight_camp_soldiers()
{
	if(gs(DESTROYED_WALL)) {
		say("There are no soldiers here.");
	} else {
		say("You practise a few moves of [[ in_inv(sword) ? 'swordplay' : 'barehanded fighting' ]] \
		    with an obliging soldier. He gives you a nod and moves on.");
	}
	return true;
}
function misc_camp_soldiers() {
	if(gs(DESTROYED_WELL)) {
		say("There are no soldiers here.");
	} else if(Token[2]) {
		say("The soldiers ignore you.");
	} else {
		say("I don't understand what you want to do to the soldiers.");
	}
	return true;
}

//pl(name,fullname,indoors,description,append,sights,special,exits,hExits,daemonBefore,daemonAfter)
pl('hills',
'Foothills',
false,
"You are in the northern foothills of the Ida mountains. Somewhere in the northeast you can make out \
the city of Troy, and there are tents set up in a meadow to the north. West of you, a cliff falls away, \
and you can see the sea beyond it.",
"",
{
	hill: "The hills here are gentle and rolling. They flatten off to the north, and become \
	       sharply mountainous in the south. To your west, a cliff drops down to the beach.",
	cliff: "A sheer cliff falls away to the west.",
	tent: "A variety of tents are pitched on the grassland to the north.",
	coast: "At the foot of the cliff, you can see a beach running north-south along the coast.",
	troy: describe_troy,
	sea: "The Aegean sea stretches out to the west. Greece is presumably somewhere on the other side.",
},
{
	west: "I wouldn't recommend jumping off the cliff.",
	'jump.off.cliff': jump_off_cliff,
	'jump.cliff': jump_off_cliff,
},
{ north: 'siege_camp',
  east: 'south_of_troy',
  south: 'mountains'
},
{},
null, null);
function jump_off_cliff() {
	die("If you insist.\n\
	     Ah, the sensation of flying! The cool air on your skin, the wind in your hair, \
	     the splatter against the &ndash;", "You have jumped off a cliff");
	return true;
}

pl('mountains',
'Mountains',
false,
"You stand in a rocky pass in the Ida Mountains. The landscape is rugged and \
treacherous. There is a small hole in the ground here[[ gs(OBJECT_ON_HOLE) ? \
'' : ', from which a column of smoke is rising' ]].",
"[[ list_object_on_hole() ]]",
{
	smoke: "[[ describe_smoke() ]]",
	hole: "A small hole in the ground, only a few inches across[[ gs(OBJECT_ON_HOLE) ? \
	       (', with ' + Thing[gsn(OBJECT_ON_HOLE)].fullname + ' on top of it' ) : \
	       ', emitting a plume of grey-black smoke' ]]."
},
{
	drop: hole_drop,
	cover: hole_drop,
	wear: hole_drop, // "put X on", yuck
	insert: hole_drop,
	take: hole_take,
	'smell.smoke': "It smells like ordinary wood smoke from a fireplace."
},
{ north: 'hills' },
{},
null, null);
function describe_smoke() {
	if(gs(OBJECT_ON_HOLE)) {
		say("The flow of smoke has been blocked by the " + Thing[gsn(OBJECT_ON_HOLE)].shortname + ".");
	} else {
		say("A narrow column of grey-black smoke rises from the hole.");
	}
}
function list_object_on_hole() {
	if(gs(OBJECT_ON_HOLE)) {
		return "\nOn the hole is " + Thing[gsn(OBJECT_ON_HOLE)].fullname + ".";
	} else {
		return "";
	}
}
function hole_drop() {
	// COVER/BLOCK HOLE (WITH) X	
	if(Token[1]=='cover') { // rearrange words so we can process it as if it's the same phrasing
		if(Token[2]=='hole' && is_thingname(Token[3])) {
			Token[2] = Token[3];
			Token[3] = 'hole';
		} else {
			return false;
		}
	}
	
	// PUT/INSERT/STICK X ON HOLE, PUT/STICK X DOWN HOLE, PUT/STICK X IN(TO) HOLE
	if(Token[3]=='hole' || ((Token[3]=='down' || Token[3]=='in') && Token[4]=='hole')) {
		
		if(!is_thingname(Token[2])) {
			say("I don't understand what you want to put on the hole.");
		} else if(!in_inv(eval(Token[2]))) {
			say("You're not carrying that.");
		} else {
			
			if(gs(OBJECT_ON_HOLE)) {
				say("There's already something covering the hole.");
				return true;
			}
			
			var th = eval(Token[2]);
			take_away(th);
			sgs(OBJECT_ON_HOLE, th.id);
			say("You put the " + th.shortname + " over the hole. It blocks the flow of smoke.");
			get_point_for(PUT_SOMETHING_ON_HOLE);
		}
		
		return true;
		
	} else {
		return false;
	}
	
}
function hole_take() {
	if(is_thingname(Token[2]) && eval(Token[2]).id == gsn(OBJECT_ON_HOLE)) {
		sgs(OBJECT_ON_HOLE, 0);
		var th = eval(Token[2]);
		give_hero(th);
		say("Okay. You have taken the " + th.shortname + ". Smoke begins rising from the hole again.");
		return true;
	} else {
		return false;
	}
}

pl('sandy_beach',
'Sandy beach',
false,
"You are standing on the sandy beach.[[ gs(SHIP_STATUS)==SHIP_GONE ? '' : describe_ship() ]] \
To the east you can make out a number of tents.",
"[[ gs(SHIP_STATUS)==SHIP_BOARDING ? '\\nThe ship appears to have finished boarding the surviving Greek soldiers, but something " +
"is wrong. Its sails are unfurled, but the ship is just jerking, and seems not to be able to launch properly.' : '' ]]",
{
	tent: "A variety of tents are pitched on the grassland to the east.",
	ship: "[[ examine_ship() ]]",
	sea: "The Aegean sea stretches out to the west. Greece is presumably somewhere on the other side.",
	coast: "The sandy beach runs a way south, where it starts to become more rocky.",
},
{
	west: "The sea blocks your way in that direction.",
	swim: "Not likely!"
},
{ east: 'siege_camp',
  south: 'pebbly_beach' },
{},
null, null
);
function describe_ship() {
	if(!gs(SHIP_STATUS)) {
		say(" A Greek military ship is anchored a little way out to sea.");
	} else if(gs(SHIP_STATUS)==SHIP_BOARDING) {
		say(" A Greek military ship sits close to the shore. Its sails are unfurled, but it is jerking and failing to move.");
	} // else the ship's gone; say nothing.
}
function examine_ship() {
	if(gs(SHIP_STATUS)==SHIP_GONE) {
		say("That ship has sailed.")
		return;
	}
	
	say("A ninety-cubit military trireme. ");
	if(gs(SHIP_STATUS)==SHIP_BOARDING) {
		say(" It is loaded with impatient-looking soldiers. Something seems to be wrong: the sails are unfurled and the ship " +
		     "is periodically jerking, but it's not moving.");
	} else {
		say(" It is sitting still on the calm sea, some distance out.");
	}
}

pl('pebbly_beach',
'Pebbly beach',
false,
"The beach becomes more pebbly here, before it turns into jagged rocks to the south. Just east \
of you is a cliff, in which there is a cave entrance.",
"",
{
	cliff: "A sheer cliff rises to the east, with a cave entrance at ground level.",
	cave: "A wide cave entrance leading into the rock. It's gloomy, but there's enough light to see \
	       in there.",
	coast: "The pebbly beach runs down from the north, where the sand gets finer, and ends in rocks to the south.",
	boulder: "Jagged rocks stop you from going any further south down the coast.",
	in: "[[ pebbly_beach.sights.cave ]]",
	door: "[[ pebbly_beach.sights.cave ]]",
	sea: "The Aegean sea stretches out to the west. Greece is presumably somewhere on the other side.",
},
{
	south: "The beach gives way to impassable jagged rocks in that direction.",
	west: "The sea blocks your way in that direction.",
	swim: "Not likely!"
},
{
	north: 'sandy_beach',
	in: 'cave_mouth'
},
{
	east: 'in'
},
null,
function() {
	if(!gs(MEDUSA_CURED) && heroloc()==pebbly_beach && !pick(5) && personloc(medusa)==medusas_cave) {
		say("\nYou hear a faint hissing noise coming from the cave.");
	}
}
);

pl('cave_mouth',
"Cave mouth",
false,
"You are in the mouth of a rocky cave near the sea. It's roomy and light enough to see, \
and there is the smell of a woodfire nearby.[[ gs(PERSEUS_CURED) ? '' : ' There is an unsettlingly lifelike statue \
in the middle of the cave floor here.' ]]",
"[[ (!gs(MEDUSA_CURED) && personloc(medusa)==medusas_cave) ? '\\nYou hear the hissing of snakes coming \
from further inside the cave.' : '' ]]",
{
	statue: '[[ describe_perseus_statue() ]]'
},
{
	'take.shield': "That's part of the statue.",
	'take.statue.shield': "That's part of the statue.",
	'take.sandals': "That's part of the statue.",
	'take.statue.sandals' : "That's part of the statue.",
	'fight.statue' : "Your [[ in_inv(sword) ? 'sword' : 'fist' ]] slams into the statue. \
	                  [[ in_inv(sword) ? 'Krrrring!!' : 'Ow!' ]]",
	
	'rub.ointment.statue' : anoint_statue,
	'rub.ointment.on.statue' : anoint_statue,
	'wear.ointment.statue' : anoint_statue,
	'anoint.statue' : anoint_statue,
	'anoint.ointment.statue' : anoint_statue,
	'anoint.ointment.on.statue' : anoint_statue,
	'drop.ointment.statue' : anoint_statue,
	'drop.ointment.on.statue' : anoint_statue,
	'use.ointment.statue' : anoint_statue,
	'use.ointment.on.statue' : anoint_statue
},
{	southeast: 'medusas_cave',
 	out: 'pebbly_beach'
},
{	in: 'southeast',
	west: 'out',
},
function() {
	// before rescuing perseus, understand 'perseus' as the statue
	if(heroloc()==cave_mouth && !gs(PERSEUS_CURED)) {
		for(var i=1; i<=MAX_TOKENS; ++i) {
			if(Token[i]=='perseus') {
				Token[i] = 'statue';
			}
		}
	}
	Token_str = Token_str.replace('perseus', 'statue');
},
function() {
	if(!gs(MEDUSA_CURED) && heroloc()==cave_mouth && personloc(medusa)==medusas_cave && !pick(2)) {
		say("\nYou hear a loud hissing noise from the southeast.");
	}
});
function describe_perseus_statue() {
	if(gs(PERSEUS_CURED)) {
		say("The statue isn't here any more.");
	} else {
		say('The statue is life-size and extremely lifelike. It depicts a muscly man with winged sandals, a \
		     large sword, and a startled expression. It is wearing a shield inscribed \"PERSEUS\".');
	}
}
function anoint_statue() {
	if(!in_inv(ointment)) {
		say("You haven't got any ointment.");
		return true;
	}
	
	say("You rub some of the ointment on the statue.\n\
	     The stone warms up, softens, and changes colour... and you realise you are rubbing a living person.\n\
	     \"Wow!\" says Perseus, grinning. \"I guess I must have blacked out from being overloaded by \
	     awesomeness after I slew that hideous Medusa. I'll just go and tell everyone about what I did!\"\n\
	     The wings on his sandals start flapping, and he air-surfs away out of the cave.\n\
	     In the spot he was occupying, trodden into the cave floor, you notice a bronze key.");
	get_point_for(PERSEUS_CURED);
	set_thingloc(key, cave_mouth);
	return true;
}


pl('medusas_cave',
"Cave lair",
true,
"[[ describe_medusas_cave() ]]",
"[[ append_medusas_cave() ]]",
{
	fire: "A cooking-fire made of driftwood. It is smoking [[gs(OBJECT_ON_HOLE) ? 'thickly' : 'gently']].",
	smoke: "A narrow column of grey-black smoke rises from the fire \
	        [[ gs(OBJECT_ON_HOLE) ? 'and fills the room' : 'and flows through a hole in the cave ceiling' ]].",
	crates: "They're branded \"SO Crates!\"",
	blankets: "A pile of dirty old blankets, worn into a human shape. Someone has apparently been living here for some time."

},
{
	look: look_cave
},
{
	northwest: 'cave_mouth'
},
{
	out: 'northwest'
},
null,
function() {
	if(heroloc()==medusas_cave || heroloc()==cave_mouth) {
		// only bother when the player is in or right next to the cave
		hide_cave_things();
	}
}
);
function look_cave() {
	if(Token[2] && smoky()) {
		say("It's too smoky to see anything in any detail.");
		return true;
	}
	return false; // intransitive "LOOK" works
}
function hide_cave_things() { // or unhide them.

	if(gs(OBJECT_ON_HOLE)) { // hide things
		for(var i=1; i<=NUM_THNG; ++i) {
			if(thingloc(Thing[i])==medusas_cave) {
				set_thingloc(Thing[i], cave_hideyhole);
			}
		}
	} else { // unhide things
		for(var i=1; i<=NUM_THNG; ++i) {
			if(thingloc(Thing[i])==cave_hideyhole) {
				set_thingloc(Thing[i], medusas_cave);
			}
		}
	}
}

function describe_medusas_cave() {
	if(!gs(OBJECT_ON_HOLE)) {
		say("You are in a roughly circular chamber in a rocky cave. There is straw on the floor here, a pile of blankets by the \
		     wall, and a few upturned crates apparently serving as furniture. A fire burns on the \
		     cave floor, giving off a plume of smoke which rises through a natural chimney above you.");
	} else {
		say("You are in a roughly circular chamber in a rocky cave. A fire burns on the cave floor, \
		     and has filled this part of the cave with thick smoke, making it almost impossible to see.");
	}
}
function append_medusas_cave() {
	if(!gs(MEDUSA_CURED) && personloc(medusa)==medusas_cave && gs(OBJECT_ON_HOLE)) {
		return '\nYou hear a loud hissing nearby.';
	} else {
		return ''
	}
}

// dummy place used to hide anything in the cave
// pl(name,fullname,indoors,description,append,sights,special,exits,hExits,daemonBefore,daemonAfter)
pl('cave_hideyhole', 'Hideyhole', true, '', '', {}, {}, {}, {}, null, null);






