/*
 * The Xylophoniad
 *
 * Vocabulary
 *
 */

var Synonyms = new Object;
NUM_SYNS = 0;

function words(string)
{
	if(string.indexOf('.')==-1)  // er... I have no idea why this should be
		string += '.' + string;  // necessary, but nothing works without it!
	
	Synonyms[++NUM_SYNS] = string.substring(0,string.indexOf('.')) +
	  '.' + string + '.';
}

// All recognised words, and their synonyms
// Names of persons, places and things need not be listed here,
// unless they have synonyms

// directions come first...
words('north.n');
words('northeast.north-east.ne');
words('northwest.north-west.nw');
words('south.s');
words('southeast.south-east.se');
words('southwest.south-west.sw');
words('east.e');
words('west.w');
words('down.d.descend.downward');
words('up.u.ascend.upstair.upward.climb');
words('out.exit.exeunt.outward.outside');
words('in.enter.inward.inside.into');
words('port.p');
words('starboard.sb');
words('fore.f');
words('aft');
// ...so that we can do this
DIRECTIONS='';
for(var i=1;i<=NUM_SYNS;++i)
	DIRECTIONS+=Synonyms[i];
// all other words come now.

words('insert.contain');
words('cover.block');
words('from');

// added for engine v0.4
words('undo');
words('transcript');
words('terse.unverbose');
words('verbose.unterse');
words('wait.z');

words('all.everything');
words('dir');
words('it.them');
words('him');
words('her');
words('help');
words('hint');
words('score');
words('inventory.inv.invent.i.list.carrying.stuff.possession');
words('game');
words('restart.restart');
words('save');
words('load.restore');
words('delete');
words('take.steal.get.pick.grab.lift.acquire.procure');
words('drop.put');
words('throw.fling.chuck.lob');
words('talk.tell.chat.ask.speak.say.question');
words('pole.stick.post');
words('give.show.present.bequeathe.offer.proffer.feed');
words('wake.awake.awaken');
words('painting.mural.portrait.picture.canvas.rectangle.surrealist');
words('pitchfork.fork.trident.bident');
words('poster.propaganda');
words('hang');
words('table.desk');
words('look.l.x.lookat.lookit.looky.examine.exam.see.view.read.peruse.search.describe');
words('lookin');
words('fight.hit.kill.smite.punch.kick.stab.attack.batter.bash.beat.duff.break.smash.destroy.murder.slay');
words('knock');
words('loosen');
words('wear.puton.don');
words('remove.takeoff.unwear.doff.disrobe');
words('on');
words('off');
words('push.press.touch');
words('button.switch');
words('dial.arrow.gauge.meter.sextant');
words('kiss.snog.smooch.seduce');
words('self.me.you.myself.yourself.xylophone');
words('xyzzy.plugh');

words('listen.hear');

words('start.begin');
words('make');
words('bed.four-poster.fourposter');
words('door.doorway.entrance.gate.gateway');
words('lock.keyhole');
words('open.unzip.unlock.unbutton');
words('untie.unchain.unfetter.release');
words('close.shut');
words('window.porthole');
words('chicken.leg.meat.chickenleg.chicken-leg');
words('bones.bone.skull.skeleton.skellington');
words('stains.stain.blood.bloodstain');
words('saddle.seat');
words('footprints');
words('cave');
words('smoke.steam.gas');
words('hole');
words('pool.pond.lake');
words('wine.booze');
words('flagstones.flagstone');
words('courtroom.court');
words('narcissus.echo');
words('boulder.rock.stone');
words('slope.slant.ramp.incline');
words('water');
words('stair.staircase.step.stairway.stairwell.ladder.stepladder');
words('passage.passageway.corridor.hallway');
words('shovel.spade');
words('pirate.buccaneer');
words('handkerchief.hanky.napkin');
words('sea.ocean');
words('helle.hellespont.dardanelles');
words('spill.pour.empty');
words('jetty.pier.mooring');
words('swim.paddle.swimming');
words('sit');
words('stand');
words('sleep');
words('chair.throne.armchair');
words('pillar.column');
words('dome');
words('dais.platform');
words('bench.benches');
words('ship.boat.ferry.rowboat.trireme');
words('cut.snip.chop');
words('eat.taste.munch.chew');
words('drink.quaff');
words('brewing.brew.brewery.yeast');
words('jump.leap');
words('move');
words('smell.sniff.inhale.breathe');
words('chest.treasure');
words('money.obol.drachma.coins.coin.groat.doubloon.cash.dosh.moolah');
words('buy.purchase');
words('wall.bulkhead');
words('ground.floor.grass.deck');
words('flowers.flower.plant.primrose');
words('roof.ceiling');
words('shout.scream.yell');
words('sneeze');
words('bat.fruitbat');
words('wave.flap.shake.swing');
words('sword.sabre.saber.weapon.blade.rapier');
words('swear.' + rot13('shpx.sneg.phag.nefr.pbpx.jnax.fuvg.fuvgr.funt.obyybpxf'));
words('themself.themselves.himself.herself.itself');
words('sign.signpost.notice.noticeboard.plaque');
words('paper.scrap.note.notepaper');
words('scroll.page');
words('guard.guardsman.sentry');
words('figurine.figure.statuette.model.ivory.nymph.naiad');
words('plinth.pedestal');
words('beads.bead.chime.hanging');
words('kithara.lyre.harp');
words('aulos.flute.pipe');
words('play.blow.pluck.strum');
words('abandon');
words('hope');

words('shack.hut.shed.hovel.cupboard.workshop.shop');
words('house.building');
words('hall.townhall.cityhall');
words('inn.pub.boozer.hotel.tavern.rampart');
words('hall');
words('barrel.cask.keg');
words('pay.bribe');

words('temple.church.cathedral.kirk');
words('god.divine.theology.goddess.goddesses.deity.deities.religion.religious');
words('pray');

words('thespis.actor.thespian');
words('theatre.theater');
words('script.playscript.stageplay.screenplay.papyrus');
words('trail.path.road');
words('symbol.glyph');

words('not.don\'t.dont');

words('count');

words('stage');

words('robin.johnson');

words('stall.market');

words('catapult.trebuchet.tribuchet.tri-buchet.tri.buchet');
words('fire.shoot.twang');
words('rope.string.cord.loop');

words('furnace.fireplace');

words('surrender.surrendered.surrendering');
words('poor.poverty.destitute');


words('castle.palace.fortress.citadel');
words('fort.fortification');
words('tower');

words('pull.yank.tug');
words('lever.knob');


words('cerberus.kerberos.hellhound');
words('dog.hound.pup.puppy.mut.pug');
words('helen');
words('stroke.pet.scratch.tickle');

words('book.textbook.tome');

words('helmet.helm.hat.plume');

words('diogenes.diogynes.grouch');
words('philosopher.thinker.scientist.inventor.inventer');
words('daedalus.dedalus');
words('minotaur.bull');
words('trinkets.trinket.mechanism.invention');
words('shelves.shelve.shelf.bookshelf.bookshelve');
words('wing.prosthetic.prosthesis.prostheses');
words('eurystheus.euristheus.king');
words('goblet.copper');
words('dock.jetty.harbour');
words('coast.coastline.beach.sand');

words('bicyclops.cyclops.giant.cyclopes.polyphaemus.polyphemus');
words('troy');
words('soldiers.soldier.army.troop.trooper.war.fighting.horde');
words('trojan');
words('greek');
words('tent.pavilion.pavilia.camp');
words('dead.corpse.wounded.bodies.injured');
words('usurp');
words('commit');
words('regicide');

words('sappho.bard.poet.lesbian');
words('cat.moggy.kitten.kittycat.pussycat.pussy.puss.hecate');
words('fish.sole');

words('handcart.cart.wagon.waggon.barrow.wheelbarrow.basket.handbasket');
words('cartwheels.wheels.cartwheel.wheel');
words('bicicicle.bicycle.bicicycle.bicycyle.bycycycle.bicicle.bycicle.bycycle.bike.vehicle.contraption.boneshaker.velocipede.cycle.pushbike');
words('ride.mount');

words('cabbage');
words('match');
words('ball');

words('eris.discordia.discord');
words('artemis.diana');
words('poseidon.neptune');

words('hades.hell.inferno.underworld.hellfire');
words('tantalus');
words('sisyphus.sysyphus.sisiphus.sysyphys.sisyphis.sisyphys.sisiphis.sysyphis');
words('key.bronze');

words('horse.equine.equus');
words('city.town');
words('anachronopolis');

words('control.panel');
words('rubble.rubbish.garbage.trash.mess');
words('fix.mend.repair');

words('achilles.akhilleus.general');
words('heel.ankle.foot.tendon.feet');
words('boot.shoe');
words('sandal.sandal');
words('armour.armor');

words('patroclus.patroklos.loverboy');

words('medusa.gorgon');
words('woman.person.girl');
words('crates.crate.boxes.box');
words('cold');
words('coldbox.cooler.fridge.refrigerator.rephrygiarator.anatoliarator');
words('cheese.wedge');
words('perseus');
words('statue');
words('palladium.paladium');
words('ointment.cream.balm.myrrh.pot.tub.poultice');
words('rub.smear.wipe.slather');
words('blankets.blanket.blanky.blankie.duvet.eiderdown');
words('use.apply.try');
words('anoint');
words('skin.face');



words('hill.mountain');
words('cliff.clifftop.crag');

words('barber.hairdresser.haircutter.hairstylist.stylist');
words('haircut');
words('eyes.eye.sight.blind.blindness');
words('blindfold.rag');
words('hair.head');
words('snakes.snake.serpent.hiss.hissing');
words('frieze.carving.engraving');
words('mirror');

function rot13(txt)
{
	var rot_alpha = 'abcdefghijklmnopqrstuvwxyzabcdefghijklmABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLM';
	var op = '';
	for(var i=0;i<txt.length;++i)
	{
		var c = txt.charAt(i);
		if(rot_alpha.indexOf(c)!=-1)
			op += rot_alpha.charAt(rot_alpha.indexOf(c)+13)
		else
			op += c;
	}
	return(op);
}

