

function handle_start_message(cmd) {

    const tokens = [
        'begin',
        'restore',
        'about',
    ];

    if (tokens.includes(cmd) !== true) {
        show_preview('');
    }

    if (cmd === '') {
        show_preview('');
    }

}


function handle_command_message(cmd) {

    const verbs = [
        'push',
        'pull',
        'open',
        'close',
        'unlock',
        'lock',
        'turn',
        'rotate',
        'take',
        'drop',
        'jump',
        'read',
        'attack',
        'kiss',
        'smell',
        'taste',
        'eat',
        'drink',
        'consume',
        'climb',
    ];

    if (game.record_val_to) {
        return;
    }

    if (game.current === 'start') {
        handle_start_message(cmd);
        return;
    }


    /*
    const directions = [
        ['n', ''],
        ['s', ''],
        ['e', ''],
        ['w', ''],
    ]

    for (const dir of directions) {
        const [letter, glyph] = dir;
        const abbv = {
            n: 'north',
            e: 'east',
            s: 'south',
            w: 'west'
        }
        if (letter === cmd) {
            show_preview(`I can't go ${glyph} ${abbv[cmd]}`);
            return;    
        }
    }
    */


    if (cmd.length < 4) {
        show_preview('');
        return;
    }

    if (strcmp('examine', cmd)) {
        preview(`examine`, `you see nothing special`);
        return;   
    }

    if (strcmp('help', cmd)) {
        show_preview(`always a good idea`);
        return;   
    }

    for (const verb of verbs) {
        if (strcmp(verb, cmd)) {
            show_preview(`?`);
            return;    
        }
    } 

    show_preview(`?`);

}


function handle_symbols() {

    const table = {
        '`': `A thunderous crash, like a thousand bricks falling through a thousand baubles of
        thin glass, crescendos through the air!`,
        
        '~': `You raise an eyebrow while thinking.`,
        
        '@': `It looks like you're writing an email. Can I help?`,
        
        '#': `A sharp slash sound zings through the air.`,
        
        '!': `Like a period, but more exciting.`,
        
        '$': `The sound of tinkling coins rings merrily in your ears.`,
        
        '%': `Sadly, Yurf was not implemented in a spreadsheet.`,
        
        '^': `Hmmm. Looks like you've got a point.`,
        
        '&': `A fine stand for all your er's or and's.`,

        '*': `You hear the twinkling of a distant star.`,

        '?': `Just leave that hanging in the air, eh?`,

        '.': `Period, finale, end of story.`,

    }

    for (const key in table) {
        check(key, () => table[key]);
    }

}


function handle_synonyms(word) {

    const w = word.toLocaleLowerCase();
    if (w in synonym_dictionary) {
        return synonym_dictionary[w];
    }
    return w;

}


function std_handle_phlonk() {

    if (game?.the_buzzword) {

        function snicker() {

            if (game.current === 'oaktree') {
                return `<p>The tree snickers with barely concealed delight.</p>`;
            }

            return '';
        }

        if (game?.tried_phlonk) {
            preview(['phlonk', 'phlonck', 'flonk', 'flonck'], `not again!`);
        } else {
            preview(['phlonk', 'phlonck', 'flonk', 'flonck'], `say <i>the buzzword</i>`);
        }
        check(['phlonk', 'phlonck', 'flonk', 'flonck'], () => {
            
            game.tried_phlonk = true;
            if (game.current === 'sword') {
                game.tried_phlonk_on_sword = true;
                return `A hefty PHLONK appears from thin air and bonks you on the noggin!
                Ouch! <p>The sword is unaffected. It would seem that tree
                has a sense of humor.</p>`
            }
            
            return `A hefty PHLONK appears from thin air and bonks you on the noggin!
            Ouch! ${snicker()}`
        });
    } else {

        if (game?.tried_phlonk) {
            preview(['phlonk', 'phlonck', 'flonk', 'flonck'], `not again!`);
        } else {
            preview(['phlonk', 'phlonck', 'flonk', 'flonck'], `say <i>phlonk</i>`);
        }
        check(['phlonk', 'phlonck', 'flonk', 'flonck'], () => {
            
            game.tried_phlonk = true;

            if (game.current === 'sword') {
                game.tried_phlonk_on_sword = true;
                return `A hefty PHLONK appears from thin air and bonks you on the noggin!
                Ouch!`
            }
            
            return `A hefty PHLONK appears from thin air and bonks you on the noggin!
            Ouch!`
        });

    }

}


function stdlib() {

    preview('xyzzy', `not in this game, friend`);

    preview('n', `you can't go that way`);
    preview('w', `you can't go that way`);
    preview('s', `you can't go that way`);
    preview('e', `you can't go that way`);

    burn(`there's nothing (useless) here to burn`);
    blues(`there's no-one here who wants the blues`);

    preview('plus', `but there are no numbers to add`);
    preview('minus', `but there are no numbers to subtract`);
    preview('blorps', `but there are no numbers to blorpzle`);
    preview('mlotz', `but there are no numbers to dip in vanilla custard`);
    preview('yell', `time for a good scream`);
    preview('talk', `there's no-one here to talk to`);
    preview('drop', `DROP command is not used in this game, Sorry!`);
    preview('look', `look around`);
    preview('kneel', `changing your altitude doesn't help`);
    preview(['jump', 'hop', 'pounce', 'leap'], `take a leap`);
    preview(['nap', 'sleep'], `zzzzzzz`);

    check(['jump', 'hop', 'pounce', 'leap'], () => `You make a slight hop off the ground.`);
    check('look', () => execute_room(game.current, { silent: false }));
    check('help', help_msg);
    check('yell', () => `AAAAAHH! That's better.`);
    check(['nap', 'sleep'], () => `You nod off for a moment.`);

    preview(['again', 'g'], `repeat last command`);
    preview(['wait', 'z'], `wait`);
    check(['wait', 'z'], () => `Time passes.`);

    if (!game.boss) {
        preview('hint', 'no hints available here');
    } else {
        preview('hint', 'not in boss mode, friend');
        
    }

    if (!game.boss) {
        check('boss', () => {
            game.boss = true;
            return `Boss mode enabled. The game's difficulty is now increased, but the ending is (mostly) the same.
            <p>
            Also, hints are turned off.
            </p>
            ${aside(`Type <span class="key-command">boss</span> to disable boss mode.`)}
            `
        });
    } else {
        check('boss', () => {
            game.boss = false;
            return `Boss mode disabled. Hints work again!
            ${aside(`Type <span class="key-command">boss</span> to enable boss mode.`)}
            `
        });
    }

    std_handle_phlonk();
    handle_symbols();

}


function immobile(label, error_msg) {

    const msg = (error_msg) ?? `${label} fixed in place`;
    preview(`examine`, `you see nothing special`);
    preview(`read`, `there's nothing to read`);
    preview(`smell`, `you smell nothing special`);
    preview(`attack`, `violence is never the answer`);
    burn(`${label} isn't useless, and why burn it in the first place?`);
    blues(`you can't give ${label} the blues`);


    const cant_move = [
        'push',
        'pull',
        'turn',
        'rotate',
        'take',
    ];

    const verbs = [
        'open',
        'close',
        'unlock',
        'lock',
        'eat',
        'drink',
        'consume',
        'climb',
    ];

    const weird = [
        'kiss',
        'taste',
    ];

    for (const m of cant_move) {
        preview(m, msg)
    }

    for (const v of verbs) {
        preview(v, `you can't ${v} ${label}`)
    }

    for (const w of weird) {
        preview(w, `umm, why would you do that to ${label}?`)
    }

}


function person(label, error_msg) {

    immobile(label, `don't do that to ${label}!`)
    burn(`please don't burn ${label}`);
    blues(`${label} doesn't want the blues`);

    const verbs = [
        'kiss',
        'attack',
        'taste',        
    ]

    for (const v of verbs) {
        preview(v, `${v} ${label}`)
    }

    for (const v of verbs) {
        check(v, error_msg);
    }

}
