
function qwertiLabel() {
    const v = [
        `platypus`,
        `koala bear`,
        `beaver`,
        `penguin`
    ]
    return shuffle(v)[0]
}


function qwertiTalk() {
    const arr = [
        `
        "If you're headed for the edge of the world east of here, be careful," says
        Qwerti. "It's a strange place. Rumors say all the moon rocks in the
        soil mess with the gravity."
        <p>
        On closer inspection, she appears to be a ${qwertiLabel()}.
        </p>
        `,
        `
        "We're all so happy you're here," she says. "Except maybe that big mean
        tree in the forest. Don't let him give you no guff--yank his beard if he
        gets too sassy with you."
        <p>
        You've decided she's definitely a ${qwertiLabel()}.
        </p>
        `,
        `
        "I'm thinking of painting my cottage," she says. "I got bitten by the
        color bug. 'Course, the last time he bit me, I just broke out for a couple
        of days."
        <p>
        Hmmm. Actually you're pretty sure she's a ${qwertiLabel()}.
        </p>
        `
    ];
    on_exit(() => `"See you!" cries Qwerti.`)
    return looping(arr)

}

rooms.qwerti = () => {

    stdlib();

    set_exits('west, north, east')
    cant_go(`the trees grow too thick to go that direction`)

    header('Amongst the Mushrooms')

    person('Qwerti', `"Cut that out," says Qwerti.`)

    const visited = (game.visited['qwerti'])

    if (!game.boss) {
        preview('hint', `no hints available here`)
    }

    preview('e', 'east on the path')
    check('e', () => nav('border'))

    preview('n', 'to the picnic')
    check('n', () => nav('picnic'))

    preview('w', 'west on the path')
    check('w', () => nav('hilltop'))

    blues('give the blues to Qwerti', () => `
        "No thanks," says Qwerti, "But somebody around here would surely like
        some blues."
    `)


    const desc = `The forest path widens under a cluster of great old beeches, and
    winds through the foliage at a long east-west curve.`

    preview('talk', `converse with Qwerti`)
    check('talk', qwertiTalk);

    preview('take', `steal some mushrooms`)
    check('take', `She worked hard to gather those. What kind of hero are you?`)

    preview('smell', `sniff the air`)
    check('smell', `It smells of old growth forest.`)

    preview('examine', `examine Qwerti`)
    check('examine', `She's clad in old coveralls and wearing good thick gloves.
    Each mushroom tossed into her hat is carefully inspected--she somewhat resembles
    a monocled jeweler appraising diamonds made of fungus.
    <p>
    After getting a good look at her, she's almost certainly a ${qwertiLabel()}.
    </p>
    `)

    return (visited) ? `${desc}
    
    <p>Qwerti is hobbling about on her knees, gathering more mushrooms into her
    wide-brimmed hat.</p>` :

    `${desc}
    
    <p>There's crouched figure in the shadow of the mossy boughs, poking around near the roots 
    of the big trees.
    She appears to be quite strong, especially for her age. Her hat is on the ground next to her,
    upside-down, and is half-full of little white mushrooms. Oh, forgot to mention--she's
    a walrus.</p>

    <p>"Hullo, hullo!" she says with a friendly grin. "You must be that new adventurer.
    My name is Qwerti-Qwerti Froop. Very pleased to meet you!
    How's saving the kingdom going?"
    
    `

}
