

function color_bug_needs_blues() {

    if (game?.blues) {
        preview(['blues', 'blue'], `give the color bug the blues`)
        check(['blues', 'blue'], () => {

            award("blues to bug")
            game.blues = false;
            game.color_bug_has_blues = true;
            game.diamond_gem_on_ground = true;

            return `"That's it!" says the color bug with a cheery glow.
            "Thank you, I've been missing that!"
            <p>The color bug gratefully takes the blues away from you. "Here,"
            he says with a warm smile on his mandibles, "Take this, I know you
            will make good use of it."</p>
            <p>From the his (mouth? front-facing orifice?) a large droplet of goo spews to the ground;
            in the slime you can discern a diamond-shaped gem.</p>
            `
        })
    }

    preview('talk', `converse with the color bug`)

    check('talk', () => `
    "Check out my rainbow!" cries the color bug with glee.
    "Though, I'll be honest, I can't help but feel it's missing something."
    <p>The bug begins to dance an array of colors: red, orange, yellow, green, indigo, violet...</p>
    <div class='color-array'>
        <div class='color-splotch-red'></div>
        <div class='color-splotch-orange'></div>
        <div class='color-splotch-yellow'></div>
        <div class='color-splotch-green'></div>
        <div class='color-splotch-indigo'></div>
        <div class='color-splotch-violet'></div>
    </div>
    `)
}


rooms.thecolorbug = () => {

    let gem = '';
    header('In the Colossally Colorful Cave')

    set_exits('south (or exit)')

    stdlib()

    preview(['e', 'w', 'n'], `that would send you into a rock wall swirling with light`)

    preview(['s', 'exit'], `leave the cave`)
    check(['s', 'exit'], () => {
        on_exit(() => `"See you later!" calls out the color bug.`)
        nav('oldcave')
    })

    person('the color bug', `Ick, he's a giant bug.`)

    preview('examine', 'examine the color bug')
    check('examine', `"Drink me in!" cries the color bug. "My festival of hues is for none-other than <i>yous</i>!"`);

    preview('attack', 'attack the color bug')
    check('attack', `He's done nothing to you.`);

    preview('eat', 'eat the color bug')
    check('eat', `He's more likely to bite you than the other way around.`);

    preview('taste', 'taste the color bug')
    check('taste', `He's more likely to bite you than the other way around.`);

    if (!game?.color_bug_has_blues) {
        color_bug_needs_blues()
        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            The color bug needs another color. Do you happen to be carrying one around?
            `)
        }

    } else {
        gem = diamond_gem() ?? '';
        preview('talk', `converse with the color bug`)
        check('talk', () => `
        The color bug is too caught up in his dance to converse.
        `)
    }

    return first_time(`
    From deep in the swirling luminescence of color--reds, purples, blues, yellow, greens and
    everything in between--there stirs a motion. The ripple of movement grows into a creature,
    an enormous centipede, each segment and leg and different color.
    <p>"Welcome, friend!" says the centipede with a merry little jig. "I am none other
    than the color bug! Come join in my parade of pigments, my hoedown of hues!"</p>
    <p>The spectacle of light dances in a swirl of the spectrum, and the color bug
    ends his welcome-to-the-cave celebration with a series of elaborate chroma-casting leg
    kicks.</p> ${gem}
    
    `) ?? `
    The color bug continues his merry jig, splashing light and color on the walls in 
    ferocious kaleidoscopic display. ${gem}
    ` 
    
}

