

function gnomon() {

    person('Gnomon', `Hey, what did Gnomon do to you?`)

    preview('examine', `look closer at Gnomon`)
    check('examine', `
    Gnomon is a funny little man with a floppy hat and equally floppy boots. He is sitting on a 
    sundial, cross-legged, his face spread with a goofy grin.
    `)

    blues(`give the blues to Gnomon`, `
    "Suddenly I'm feeling a bit down," says Gnomon, slumping into
    a crouch.
    `);

    if (!game.boss) {
        preview('hint', `get a hint`)
        check('hint', () => `
        Talk to Gnomon, he's full of useful information.
        `)
    }

    preview('talk', `converse with Gnomon`)
    check('talk', () => {
        return looping([
        `
        "Sometimes people ask how such a beautiful land ended up with such a goofy name,"
        he says. "Well, I'll tell you the story. The first king asked his best friend what he
        should name this new realm. His friend responded with just one word:
        <div class="grow-text">Yurf</div>
        <p>"Also, I should menton that his best friend was dog."</p>
        `,
        `
        "I hear the Mathegardener is looking for a round number," says Gnomon.
        "The last round number she had was so round, we made pies with it."
        `,
        `
        "Have you met the Editor yet?" he asks. "He may be a bit annoying, but he's the
        the best at repairing broken verse."
        `,
        `
        "I got this from the Mathegardener a while back," says Gnomon, flattening out
        a small piece of paper from his pocket.
        "You might find these handy."
        <div class="verse-div">
        <span class="key-command">plus</span> adds two numbers together
        </div>
        <div class="verse-div">
        <span class="key-command">minus</span> subtracts one number from the other
        </div>
        <div class="verse-div">
        <span class="key-command">blorps</span> adds two numbers together and subtracts 4 from the result
        </div>
        <div class="verse-div">
        <span class="key-command">mlotz</span> covers all numbers in vanilla custard
        </div>
        `
    ])});

}


rooms.gnomon = () => {

    stdlib()
    header('By the Sundial')
    set_exits('west')
    cant_go(`the forest is too thick that direction`)


    preview('w', `back to the oak tree`)
    check('w', () => nav('oaktree'))

    gnomon()

    const tm = new Date();
    const nm = game?.player_name ?? 'hullo';

    const desc = first_time(`
    There's a funny little man with a floppy hat and equally floppy boots lying on a mossy quartz sundial.
    He hops to his feet and gives you a wink.
    <p>
    "Well, hullo there! No, I'm not a gnome, don't be silly. I'm Gnomon, the knave
    of numbers and the teller of times. From night," and the sky turns dark, "&rsquo;Till
    morning," and the dawn breaks through the trees, "And even right now!" The sky returns to normal.
    </p>
    <p>
    He continues with a friendly grin: "You look a little lost. Can I help?"
    </p>
    `) ?? `
    Pillars of elm and birch grow in a sparse circle, forming a meadow dense with wildflowers. At the center
    is a heavy quartz sundial, perched on which is Gnomon.
    <p>"Hullo ${nm}!" he says with a quick grin, "the time is now ${tm.toLocaleTimeString()}!" He leans upwards
    with a jolly little chuckle; indeed, he seems most happy for your company.</p>
    `

    return desc

}

