

function normal_finale() {

    header('You Win!')
    set_exits('Congratulations')

    const s = score_text(`You have won by--`);

    preview('boss', `travel through time`)
    check('boss', () => {

        view.innerHTML = '';
        game = JSON.parse(JSON.stringify(Game));
        undo_mode_active = true;
        nav('start');
        submit_command('begin', () => {});
        undo_mode_active = false;
        submit_command('boss', () => {});

    })

    return `
    You have solved the game of Yurf!
    <p>
    ${s}
    </p>
    <p>
    On your next play-through, type type <span class="key-command">boss</span> during
    normal play to enable boss mode. This will increase the difficulty of several puzzles, 
    and disable hints. If you complete all puzzles in boss mode, you'll be awarded with
    special prize.
    </p>
    <p>
    If you'd like to play again, type <span class="key-command">boss</span>
    now.
    </p>
    
    `

}


function boss_finale() {

    header('You Are Boss!')
    set_exits('Congratulations')

    const s = score_text(`You have won by--`);
    
    preview(['take', '.', 'get', 'grab', 'accept'], `accept award`)
    check(['take', '.', 'get', 'grab', 'accept'], () => {

        createPdf();

    })

    preview('boss', `travel through time`)
    check('boss', () => {

        view.innerHTML = '';
        game = JSON.parse(JSON.stringify(Game));
        undo_mode_active = true;
        nav('start');
        submit_command('begin', () => {});
        undo_mode_active = false;
        submit_command('boss', () => {});

    })

    return `
    You have solved the game of Yurf <b>in Boss Mode!</b>
    <p>
    ${s}
    </p>
    <p>
    "You deserve this," says the Queen, handing you your prize. "Well done!"
    </p>
    <p>
    Type <span class="key-command">take</span> to receive your award.
    </p>
    `

}


rooms.finale = () => {

    const boss_mode_completed = (get_max_score() === get_boss_score());
    if (!boss_mode_completed) {
        return normal_finale();
    } else {
        return boss_finale();
    }

}


rooms.endgame5 = () => {

    stdlib();
    header('Before the Vault')
    set_exits('time to go home')
    immobile('vault', `umm everyone's waiting on you`)

    preview('talk', 'now is not the time for words')

    replace_commands(() => `
    ${aside(`Type <span class="key-command">open</span> to see what's inside...`)}
    `)

    preview('open', `open the vault of Yurf`)
    check('open', () => {

        on_exit(() => `
        The vault swings wide...
        <p>
        "Nothing!" cries Gnomon. "The vault is empty!"
        </p>
        <p>
        "Of course," says the king. "Because ${game.player_name} saved the
        kingdom by gathering the gems to open the vault, not opening
        the vault itself!"
        </p>
        <p>
        "Wait!" says the queen. "There is something in there!"
        </p>
        <p>
        The king peers into the opening. "Your keen eyes piece the shadows, my dear. You're right!"
        </p>
        <p>
        Boz and Dodo retrieve a large, glimmering golden key hidden in the shadows. Embossed on the side is
        the word:
        </p>
        <h4>
        boss
        </h4>
        <p>
        "I've heard of this," says Gnomon. "This artifact was thought to be lost. It is, in fact,
        the key to time travel!"
        </p>
        <p>
        A murmur passes through the crowd. "${game.player_name} should have it," says the queen.
        </p>
        <p>
        "Of course," says the king. "I can think of no finer reward. Except this: please come visit again some
        time, won't you ${game.player_name}?"
        </p>
        <p>
        The king and queen both embrace you. "We can't thank you enough, ${game.player_name}. Everyone
        will miss you terribly! Won't you please visit again?"
        </p>
        `)

        nav('finale')

    })

    return first_time(`
    A staggeringly heavy PHLONK hit the Air to the Throne on the head.
    <p>
    "So, do you like my song?" asks the Air, his voice mingling with pain and hope.
    </p>
    <p>
    "No," says the Lady Gale. She is wearing a long robe of thick white clouds, and
    a tiara of finest windinum. "I don't want you to damage yourself in some foolish gesture.
    I love you, you don't need to get hurt to prove anything!"
    </p>
    <p>
    "Really?" the Air brings himself to rights. "What about my other songs?"
    </p>
    <p>
    She rolls her eyes. "Oh lord," she says, "You are so full of hot air."
    </p>
    <p>
    Boz and Dodo are here, talking amongst themselves. The Mathegardener sees them and asks:
    </p>
    <p>
    "So, are you two brothers?"
    </p>
    <p>
    "Of course not," says Boz.
    </p>
    <p>
    "Though we do both have the same first name," says Dodo.
    </p>
    <p>
    "Really?" exclaims Gnomon. "I never knew that!"
    </p>
    <p>
    "True," says Boz. "Secretly, we're both named Charles."
    </p>
    <p>
    "Not a lot of people know that," chortles Dodo.
    </p>
    <p>
    King Humphrey raises his hand. "Shush! I think we're forgetting the main event. First, how
    'bout a cheer for our adventurer?"
    </p>
    <p>
    And everyone cheers, calling out "Hip-hip hooray!" and "Yay for ${game.player_name}!"
    </p>
    <p>
    "And thus, we now prepare for the grand reveal, as ${game.player_name} opens the Vault of Yurf!" The king and queen
    stand aside, making way for you to approach the vault. 
    </p>
    ${aside(`Type <span class="key-command">open</span> to see what's inside...`)}
    `) ?? `
    Everyone is waiting for you to open the vault.
    `

}


rooms.endgame4 = () => {

    header('The Throne of Endless Happy Sunshine')
    set_exits('')
    immobile('gem', `seriously, just take it`)
    preview('talk', `what, do you need to talk to the gem before grabbing it?`)

    preview('examine', `examine the heart gem`)
    check('examine', `
    Qwerti is holding the heart gem. It is carved
    into the shape of a heart, and appears to be made of red ruby.
    A flowing letter Y is on the back-facing side.
    `)

    replace_commands(() => `
    The heart gem is hanging in the air for you to take...
    `)

    preview('take', `take the heart gem`)
    check('take', () => {

        award_gem('hearts')
        award('take hearts')
        on_exit(() => `
        "It's whole!" says the king.
        <p>
        "How is that possible?" asks the queen. "We tried everything before, and half a legion
        of the strongest men couldn't fuse it together!"
        </p>
        <p>
        "The bygones are gone," says Gnomon. "There's nothing keeping it apart anymore."
        </p>
        <br>
        <div class='dropcaps'>
        Thus it was that the King and Queen of Yurf learned to live without their bygones.
        And so the kingdom itself was healed, and there was a celebration, and everyone in
        the whole of Yurf, from the moon to the earth, was invited. The merrymaking and dancing
        continued for days.
        </div>
        <p>
        Melody created many new concertos, songs, and symphonies, and never once hit
        writer's block. The Thesaurus raised his head in a most noble way:
        </p>
        ${get_poem_lines('buds')}
        <p>
        His poem continued until their wasn't a dry eye in the whole of Yurf, and all
        agreed he'd outdone himself. Even the Editor couldn't find fault in a
        single word.
        </p>
        <p>
        0wlgebra recovered beautifully, and resumed his fierce vigilance against
        the number mites. The color bug invented a whole new color, snmoople,
        for the occasion, and danced all the hues with abandon. Emilio
        created an exquisite new painting, which defied all words to describe,
        as the Editor had made off with all of them. Melody promised to
        start immediately on a new piece of music to accompany the
        artwork.
        </p>
        <p>
        The <i>Soaring Narwhal</i> resumed scheduled flights, bringing new
        visitors each day to the Tower of the Moon. There, the Queen
        taught her subjects to appreciate not just the light, but the
        shadows as well. The King of Yurf was delighted to have salads,
        spinach smoothies, and steamed greens for days--and the occasional
        sundae as well.
        </p>
        <p>
        It was wonderful, and no-one wanted the festivities to end. But soon, it
        had to.
        </p>
        <p>
        Because it was time for ${game.player_name} to go home.
        </p>
        `)

        nav('endgame5')

    })

    return `
    The heart gem hangs from Qwerti's paw for you to take...
    `

}


rooms.endgame3 = () => {

    header('Against the Wall')
    set_exits('no-where to run')

    person('0wlgebra', `stop, he needs your help!`)

    replace_commands(() => `
    ${aside(`Type <span class="key-command">kneel</span> to continue...`)}
    `)

    preview('kneel', `kneel down next to 0wlgebra`)
    check('kneel', () => {
        
        on_exit(() => `
            "Please, ${game.player_name}," pleads the Mathegardener, "Tell me the staff didn't touch my poor little 0wlgebra."
            <p>
            "What have I done?" says the king, his jaw quivering.
            </p>
            <p>
            The queen shakes her head. "Not just you," she says quietly. "It was my staff."
            </p>
            <p>
            Deep within his feathered chest, you barely manage to discern a tiny heartbeat.
            </p>
            <p>
            "Bring him in at once!" the king orders. "The queen and I know a thing or two about
            healing."
            </p>
            <p>
            The queen grips both of the Mathegardener's hands with her own. "We shall not rest
            until he is on the mend."
            </p>
            <br>
            <div class='dropcaps'>0wlgebra is on a little table in the palace, not far from the throne itself.
            The king and queen labor for hours with medicines, consulting a variety of texts as they do.
            The Mathegardener stands pensively, doing multiplication tables under her breath.
            <p>At last, when the king and queen were both exhausted, from the
            table came the smallest of sounds:</p>
            <p>${owl_speak('333')}</p>
            <br>
            <p>
            With tears running down her lined face, the Mathegardener cries: "He's going to be all right!"
            </p>
            <p>
            "I suppose," says the king, "We must now deal with the traitors, eh?"
            </p>
            <p>
            "Humphrey, you stubborn dolt," says the queen with a glare. "Just give the two halves of the heart
            gem to ${game.player_name}. It's the least we can do after all our foolishness."
            </p>
            <p>
            "Where are they?" cries the king. "Mine's missing!"
            </p>
            <p>
            "So's mine!" the queen is feeling for where it should have been around her neck. "In all the
            madness it must have fallen off."
            </p>
            <p>
            "Over here!" cries Qwerti, who was most obviously an otter. "But look at it first!"
            </p>
            <p>
            There, in Qwerti's paws, hung both halves of the heart gem, fused together.
            </p>
            `
        )
        nav('endgame4', { show_header: false })
    })

    return first_time(`
    You run as fast and as far as you can, but are soon cornered. Guards surround on every side.
    <p>
    "There's no escape!" the king declares.
    </p>
    <p>
    "You'll be locked in the deepest dungeon, with no sunshine <i>or</i> night!" rules the queen.
    </p>
    <p>
    "Not if I can help it!" Melody says, readying her sharpest note. "We all stand with ${game.player_name}!"
    </p>
    <p>
    "Don't count me out either!" declares the Mathegardener, wielding her most powerful exponent.
    </p>
    <p>
    "Nor me!" shouts Emilio, drawing his fiercest weapon (with a newly sharpened pencil.)
    </p>
    <p>
    "Art, music, poetry, mathematics, light and darkness," cries the Auntonym, "We belong together!"
    </p>
    <p>
    "<b>Treason!</b>" thunders the king. "You'll all see the dungeon! I'll lock the whole of the kingdom if I must!"
    </p>
    <p>
    The queen raises her star-staff to strike--
    </p>
    <p>
    ${owl_speak('004')}! a bunch of feathers fly and a weak, cold shape falls to the ground.
    </p>
    <p>
    Everyone stops and gathers round the motionless owl. The Mathegardener's voice quivers:
    </p>
    <p>
    "0wlgebra!"
    </p>
    ${aside(`Type <span class="key-command">kneel</span> to continue...`)}
    `) ?? `
    Everyone is still, listening for any sign of life in poor little 0wlgebra.
    `

}


rooms.endgame2 = () => {

    stdlib();
    set_exits('north west east south')

    preview(['w', 'e', 's', 'n', 'amscray', 'run', 'jet', 'flee'], `amscray`)
    check(['w', 'e', 's', 'n', 'amscray', 'run', 'jet', 'flee'], () => {

        on_exit(() => `
        "Guards!" cries the queen, "Seize!"
        <p>
        The queen had intended to say "Seize them!" but the last word had been snatched
        mid-air by the Editor, leaving the guards hopelessly confused as to whom to seize.
        </p>
        <p>
        "Now's your chance!" shouts the color bug. "I'll hold them off with my fierce
        mandibles!" He snaps ferociously and the guards recoil, all color draining from
        their faces.
        </p>
        `)
        nav('endgame3')

    })

    immobile('ever-growing assortment of guards', `the guards have you out-numbered`)

    preview('attack', `even here, violence isn't the answer`)

    return `An ever-growing number of guards is gathering around you.`
}


rooms.endgame1 = () => {

    stdlib()
    header('Courtyard of the Sun Palace')

    set_exits('north west east south')
    preview(['w', 'e', 's', 'n'], `the crowd is hemming you in on all sides`)

    immobile('the useless bygones', `your hands would just sink into the useless,
    oily bygones`)

    preview('talk', `no-one can hear over the queen and king shouting`)

    preview('burn', `light very oily gross bygones with the tinder box`)
    check('burn', () => {
        on_exit(() => `
        The tiny flame touches the slick slime...
        <p>
        <b>KABOOM!</b> The flame turns into an inferno and the bygones, both piles,
        tumble entirely into the water, where they melt into a puddle of revolting
        slime. At least it already smells better.
        </p>
        <p>
        "Look!" Bedeilia points at the water under the bridge, "They're gone!"
        </p>
        <p>
        "Someone had the guts to clear the air," says the Air to the Throne.
        </p>
        <p>The Thesaurus raises his head, in a most solemn fashion:</p>
        ${get_poem_lines('fool')}
        <p>
        "Who would dare?" screams the queen.
        </p>
        <p>
        "That was royal property!" thunders the king.
        </p>
        <p>
        "${game.player_name}," whispers the Auntonym, "Run!"
        </p>
        `)
        nav('endgame2', { silent: true, show_header: false })
    })

    const desc = first_time(`
    The whole of the kingdom has turned out--everyone you've met in your travels,
    and even more besides. You've been stuffed into the crowd next to Melody and
    the Mathegardener. Everyone is excited--perhaps there's a chance the heart
    gem can be restored?
    <p>
    The courtyard itself is vast, and a fresh watercourse flowing from the moat
    runs through the middle. A neat little white bridge arches over the water,
    with the king standing on one side, and the queen on the other. They appear
    to be as close to each other as they can stand.
    </p>
    <p>
    "Hey, have you any fresh fractions? I've been composing again," says Melody.
    "I could use some 7/8."
    </p>
    <p>
    "I've got a few," replies the Mathegardener. "Want some half
    notes too?"
    </p>
    <p>
    "If you're offering," shrugs Melody.
    </p>
    <br>
    <div class='dropcaps'>
    Presently a royal guard was wheeling forth a smelly, oily, disgusting,
    slimy, <i>useless</i> pile of bygones. He poured them all out from a
    cart and they oozed into heap near the bridge.
    </div>
    <p>
    "That's what was in the forbidden chamber!" cries Gnomon. "Look at all
    those bygones!"
    </p>
    <p>
    "Look!" cries the Auntonym. "They're wheeling in the queens bygones also!"
    </p>
    <p>
    True enough, another guard was wheeling an equally smelly pile of bygones,
    which were deposited next to the first pile. The combined stench of all
    the bygones hefted together was almost too much to bear, and the crowd
    issued an almost audible <i>yuck</i> noise.
    </p>
    <p>
    "Hear, ye, hear ye," cries the king so all can hear. "Before we attempt
    to fuse together the broken heart gem, all present must bear witness to
    to the many disgusting grievances inflicted on me by this so-called
    queen."
    </p>
    <p>
    "Hear, ye, hear ye," cries the queen with a snarl. "Let it be declared
    that the king is a massive idiot, and I shall declare my grievances even
    louder."
    </p>
    <p>
    Thus both begin to shout their issues with each other to everybody, whilst the entire
    kingdom attempts to ignore them.
    </p>
    `) ?? `
    The courtyard is vast, and a fresh watercourse flowing from the moat
    runs through the middle. A neat little white bridge arches over the water.
    The king is standing on one side, and the queen on the other. They appear
    to be as close to each other as they can stand. Two gigantic piles of bygones
    are oozing disgustingly next to the water.
    <p>
    Presently, the king and queen are shouting about their issues with each other to everyone who
    will hear, as loudly as possible.
    </p>
    `

    return desc

}
