

function is_numeric(str) {
    if (typeof str != "string") return false  
    return !isNaN(str) && !isNaN(parseFloat(str))
}


rooms.boss_check_number = () => {

    const n = game.boss_garden_number.trim();
    const is_prime = num => {
        for (let i = 2, s = Math.sqrt(num); i <= s; i++) {
            if (num % i === 0) {
                return false;
            }
        }
        return num > 1;
    }

    if (n === '123') {
        game.round_number = true;
        game.spades_gem_on_ground = true;
        nav('mathegarden', { silent: true, show_header: false });
        return `
        
        <p>
        "That's it!" she cries with
        a clap of glee. "Thank you!"
        </p>
        <p>
        She then produces a small spades gem and lays it on the ground. "I guess
        I won't be needing this. It was a very poor spade for a garden anyway;
        I hope it proves useful in saving the kingdom."
        </p>
        
        `
    }

    if (!is_numeric(n)) {
        nav('mathegarden', { silent: true, show_header: false });
        return `"I don't think that's a number," says the Mathegardener.
        "Oh well, gardening requires patience if nothing else.`
    }

    nav('mathegarden', { silent: true, show_header: false });
    return `
    
    <p>
    "Nice, but not the next number in the sequence I need," she says.
    </p>

    `

}



rooms.check_number = () => {

    const n = game.garden_number.trim();
    const is_prime = num => {
        for (let i = 2, s = Math.sqrt(num); i <= s; i++) {
            if (num % i === 0) {
                return false;
            }
        }
        return num > 1;
    }

    if (n.startsWith('3.14') || n === 'π') {
        game.round_number = true;
        game.spades_gem_on_ground = true;
        nav('mathegarden', { silent: true, show_header: false });
        return `
        
        <p>
        "Now that is the kind of number I've been looking for!" she cries with
        a clap of glee. "Thank you!"
        </p>
        <p>
        She then produces a small spades gem and lays it on the ground. "I guess
        I won't be needing this. It was a very poor spade for a garden anyway;
        I hope it proves useful in saving the kingdom."
        </p>
        
        `
    }

    if (!is_numeric(n)) {
        nav('mathegarden', { silent: true, show_header: false });
        return `"I don't think that's a number," says the Mathegardener.
        "Oh well, gardening requires patience if nothing else.`
    }

    const number = parseFloat(n);

    if (number === 0) {
        nav('mathegarden', { silent: true, show_header: false });
        return `
        
        "That <i>is</i> a nice number," she says, her jaw open like an O.
        "I wonder if I can divide by it?"

        <p>The gardener takes her sharpest shears to the 0, and...</p>

        <p>BOOOM! A huge explosions knocks you backwards as everything crackles in
        a blast of natural-rational energy!</p>

        <p>The Mathegardener is unfazed--not even a tiny bit singed. "Hmm. I
        might have known."</p>
        
        `
    }

    if (is_prime(number)) {
        nav('mathegarden', { silent: true, show_header: false });
        return `
        
        "I do love a prime number," says the Mathegardener, "But that
        is not round enough. I need a <i>very</i> round number! Like a
        circle, see?"
        
        `
    }

    nav('mathegarden', { silent: true, show_header: false });
    return `
    
    <p>
    "Nice, but not round enough," she says. "Thanks, though."
    </p>

    `

}
