
const poem_book = {
	"fool": {
		"line1": "Earth bears no balsam for mistakes;",
		"line2": "Men crown the knave, and scourge the tool.",
		"author": "Edward Rowland Sill",
		"title": "The Fool's Prayer"
	},
	"traveler": {
		"line1": "I met a traveler from an antique land",
		"line2": "Who said: two vast and trunkless legs of stone",
		"author": "Percy Bysse Shelly",
		"title": "Ozymandias"
	},
	"stars": {
		"line1": "Continuous as the stars that shine",
		"line2": "And twinkle on the Milky Way",
		"author": "William Wordsworth",
		"title": "Daffodils"
	},
	"bells": {
		"line1": "That night I think that no-one slept",
		"line2": "No bells were struck, no whistle blew",
		"author": "L Frank Tooker",
		"title": "The Last Fight"
	},
	"buds": {
		"line1": "All in the merry month of May,",
		"line2": "When green buds they were swelling",
		"author": "Anonymous",
		"title": "Barbara Allen's Cruelty"
	},
	"jubjub": {
		"line1": "Beware the jubjub bird, and shun",
		"line2": "The Frumious Bandersnatch!",
		"author": "Lewis Carroll",
		"title": "Jabberwocky"
	},
	"shay": {
		"line1": "You see, of course, if you're not a dunce,",
		"line2": "How it went to pieces all at once",
		"author": "Oliver Wendell Holmes",
		"title": "The Wonderful One-Hoss Shay"
	}
};


function get_poem_lines(p) {
	const x1 = poem_book[p].line1;
	const x2 = poem_book[p].line2;
	return `
	<div class="verse-div">${x1}</div>
	<div class="verse-div">${x2}</div>
	`
}


function set_verses(v) {
	return v.split('\n').map(x => `<div class="verse-div">${x}</div>`).join('')
}


function air_song() {
return `We're all so jolly, high!
Up amongst the clouds, ho!
Above the sweet birds, hey!
Away from sun and trees.`
}


function wind_song() {
return `A wounded beast drew near,
So I left to his care,
A swift and wonderful --`;
}


function song_of_the_number_mites() {
	return `Aye, fear not the booji bird,
Though his beak is sharp and keen,
The number mites, they come for you,
Beware! If you know what I mean.
<br>
When your sixes look like eights,
And your figures won't come right,
Then check your arms for marks my friend,
From the bite of the number mite!
`
}


function get_poem_data() {
    return `<h4>Poems</h4>` + Object.keys(poem_book).map(p => `<div> ${poem_book[p].title} -- ${poem_book[p].author} </div>`).join('');
}


function broken() {

   return `Love shall taco fade
As the sun hamburgers grows old
When doughnut the sky is black
And the shining stars grow cold waffles.`

}


function correct() {

   return `Love shall fade
As the sun grows old
When the sky is black
And the shining stars grow cold.`

}


