
function tree_face() {

    immobile('the oak tree', 'the oak tree is rooted in place');

    function tree_talk_awake() {

        blues('give the blues to the oak tree', () => `
        The tree is already belligerent enough.
        `)
        
        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            Try talking to the tree.
            `)
        }

        preview('talk', 'converse with the sleepy tree')

        check('talk', () => {

            if (!game?.tried_phlonk_on_sword) {

                game.the_buzzword = true;
                return `
                
                "Greetings, great adventurer," says the tree. "Not far from here
                is a mighty sword which may be helpful in your quest. To wield the
                sword, you must use <i>the buzzword!</i>

                <p>A swarm of bees twist and twirl in the air, and coalescing into letters:</p>

                <p>PHLONK</p>
                ${aside(`To use the buzzword, type
                <span class="key-command">phlonk</span>
                at any time into the command prompt.`)}

                <p>The word floats serenely above your head for a moment, then the
                bees scatter.</p>

                <p>"Use the buzzword, dear adventurer! Fare thee well!"</p>
                
                `

            } else {

                return `
                
                "Did you find using the buzzword... Painful?" asked the tree with a sneer.
                "Maybe you shouldn't go around waking people in the forest who are trying
                to sleep."
                
                `
            }
            
        })

    }


    function tree_talk_asleep() {

        blues('give the blues to the oak tree', () => `
        The tree snoozes loudly in response to your kind offer of the blues.
        `)

        preview('talk', 'converse with the slumbering tree')

        check('talk', `A snore is your only response.`)

    }


    function handle_pull_awake() {

        preview(['pull', 'take'], `yank tree beard again (snicker)`);
        check(['pull', 'take'], `"Do that again and I'll bite your hand off," says the tree.`);

    }

    function handle_pull_asleep() {

        if (!game.boss) {
            preview('hint', `get a hint`)
            check('hint', () => `
            Go ahead... Grab that beard...
            `)
        }

        const content = `
        
        YANK! You grip the mossy beard in your fingers and pull. The tree face comes to life,
        and casts a furious (fur-ious?) glare in your direction.
        
        `;

        preview(['pull', 'take'], `yank tree beard`);
        check(['pull', 'take'], () => {
            game.tree_awake = true;
            return content;
        });

    }


    if (!game?.tree_awake) {
        preview('smell', 'smell the oak tree');
        check('smell', `The oak tree smells of mossy Z's.`);
        tree_talk_asleep();
        preview('yell', `this oughta wake him`);
        check('yell', () => `You can almost hear an audible snore from the tree in response.`);    
        preview('examine', `examine the old oak tree`);
        check('examine', () => `He appears to be sleeping. There's drool (sap?) on the beard.`);
        handle_pull_asleep();
    } else {
        tree_talk_awake();
        preview('smell', 'smell the oak tree');
        check('smell', `The oak tree smells damp wood and mild annoyance.`);
        preview('yell', `time to make some noise`);
        check('yell', () => `"Please no more racket," says the tree.`);
        preview('examine', `the tree is not happy`);
        check('examine', () => `What a lovely scowl.`);
        handle_pull_awake();
    }

    preview('climb', `it's not a very climbable tree`)

}
