
let transcript_content = ``;


function export_transcript() {

    const parser_arrow_char = (game?.dos_mode) ? '¯' : '›';

    const view = document.querySelector('#view');
    const content = view.innerText;
    const commands = content.split(`\n${parser_arrow_char}\n`);
    const a = commands.map(x => {
        const v = x.split('\n');
        const first = `> ${v.shift()}`;
        return [first, v.filter(y => y !== '').join('\n')].join('\n');
    }).join('\n\n');

    transcript_content = `${create_transcript_header()}${a.replace(`${parser_arrow_char} `, '')}`;
    show_transcript_box();

}


function create_transcript_header() {
    const title = game.title;
    const turns = game.turn;
    const day = new Date();
    const dy = day.toLocaleDateString();
    const tm = day.toLocaleTimeString();
    const score = get_score();
    return `
=== ${title} ===
Date: ${dy} ${tm}
Turns: ${turns} / Score: ${score}

    `
}


function show_transcript_box() {
    const view = document.querySelector('#view');
    const a = document.createElement('div');
    const b = document.createElement('div');
    const c = document.createElement('a');
    const d = document.createElement('div');
    const day = new Date();
    const dy = day.toLocaleDateString();
    const tm = day.toLocaleTimeString();
    a.className = 'redo-commands-box';
    b.className = 'div-aside';
    a.append(b);
    c.title = `Download transcript`;
    c.innerText = `Download`;
    c.ariaLabel = `Transcript`;
    d.innerHTML = 'Transcript ready.';
    c.className = 'redo-button';
    c.href = 'data:text/plain;charset=utf-8,' + encodeURIComponent(transcript_content);
    c.download = `transcript-${game.title}-${dy} ${tm}.txt`;
    b.append(d);
    b.append(c);
    view.append(a);
}
