
// savegame system

function save_game() {
    const transcript = [...game.transcript];
    const json = JSON.stringify(transcript);
    localStorage.setItem("savegame", json);
    show_save_box(`Game saved.`);
}


function restore_game() {
    const view = document.querySelector('#view');
    const a = localStorage.getItem("savegame");
    if (!a) {
        show_save_box(`No save game found.`);
        return;
    }
    const b = JSON.parse(a);
    if (!b) {
        show_save_box(`No save game found.`);
        return;
    }
    view.innerHTML = '';
    game = JSON.parse(JSON.stringify(Game));
    undo_mode_active = true;
    setTimeout(() => {
        const last = b.pop();
        execute_room(game.current, { silent: true, show_header: false });
        for (const c of b) {
            submit_command(c, () => {});
        }
        undo_mode_active = false;
        setTimeout(() => {
            submit_command(last, () => {});
            backup_transcript = [];
            show_save_box(`Game restored.`);
        }, 100);
    }, 100);
}


function show_save_box(content) {
    const view = document.querySelector('#view');
    const a = document.createElement('div');
    const b = document.createElement('div');
    const c = document.createElement('div');
    a.id = 'redo-commands-box';
    a.className = 'aside-wrapper';
    b.className = 'div-aside';
    a.append(b);
    c.innerHTML = content;
    b.append(c);
    b.append(c);
    view.append(a);
}
