
# A Very Yurfy Post-Mortem
Here's more than *anybody* wanted to know about Yurf -- everything past this point is spoilery, so make
sure you've played the game first!

## A One-word Parser?
Why center a whole game around a one-word parser? Even very primitive text adventures written in BASIC can parse
more than one word.

It came from my frustration with typing out long commands when I knew
the system could just guess (reasonably) what I wanted it to do. For example: if you're playing Zork I,
at the beginning of the game, you can examine the white house and the mailbox. The game pretty much describes
everything you need to read about the house in room description. So, if we had a very smart parser, it could
infer all I want to examine is the mailbox if a type X.

Zork is very old so this doesn't work. (Actually, it requires you to type out EXAMINE MAILBOX all the way, which
is a bit silly.) Why can't the parser make the obvious inference that X means examine the obvious thing? It doesn't give
away any puzzles. LucasFilm Games would eventually do the mouse equivalent of this by allowing you to right click
an object on screen, performing some obvious action. 

Usually, when I'm playing a parser game, I want the game to do what I want in as few keystrokes as possible.
Scott Adams games did this by accident, by making the parser check only the first three or four characters.
This was pretty cool once you figured it out--instead of typing OPEN CHEST, you could just type OPE CHE
and save yourself some keys. Modern IF does a pretty good job at this, offering sensible abbreviations for a 
bunch of things.

Unless, of course, the player knows going in that the game only accepts single word (or even single letter) commands.
This greatly simplifies matters for the author, and makes testing/debugging much easier. To further smooth the player
experience, I thought it would be helpful to have a preview line, which tells the player what the parser is thinking.
I thought of a few gags around this idea, like making the in-game hero character do something truly unpleasant,
to which the parser would beg you to do some other action. In the end, it mostly became a player convenience.
This approach also reduced the number of error messages, which no-one likes: how many times do you want to read
"you can't go that direction?"

Having made a whole game with this simplified command system, the cracks begin to show. It *is* nice to be able
to examine more than one thing in a room, or specify which character to converse with. I still think parsers
can (and should) be tremendously simplified; this makes everything easier for the author, which in turn
creates a better player experience. Exactly how to do this requires more thought, and much smarter people than
me are already working on the problem. As parser commands become increasingly reductive, token sequences
begin to resemble communicating with the text editor Vim.

## A Trip Back in Time
My first interactive fiction experience was sitting on my Dad's lap. I don't remember how old I was--I couldn't
read, for sure. Dad had a Texas Instruments TI-994a Home Computer, which loaded Scott Adams games from casette tapes.
Loading a game into memory was a long, slow process. The TI would make all kinds of early 80's electronic noises as the tape
turned, because it was literally storing the game data as sound. To me, it was almost a part of the game itself; the noises
were strange, mysterious, like you were taking a journey into some other world. Anything could happen...

But then the game would finish loading. Dad would read to me what the game was saying onscreen, and he even let me hit a 
few keys. Eventually I figured out how to move around.

"Don't do that," Dad would say. "The pirate will kill you."

"What do I have to do?"

"Give him the rum," Dad said. "Pirates like rum."

I learnt to read playing old text adventures on his lap, in front of that fuzzy yellow screen in the bedroom.
In time, I even learned how to load up those old tape
games without help. The preview bar in Yurf kind of came from those memories: Dad gently prodding me the
right direction, giving me pointers on how to not die.

At the risk of sounding like an old man, kids today don't know what it was like. They get smartphones barely out
of the crib, and the idea of having to learn HOW to use a computer to play a primitive game is unheard of. I, for
one, am glad the games I had as a youngster needed some hands-on assistance. I hope that with Yurf, some other kid
receives the same gift--to experience the joy of exploring some new world with Mom or Dad as a guide.

It's the reason I've dedicated this game to my Dad.

## Ageless, Faceless Protagonist
Before you can get too far in Yurf, the game attempts to figure out what your name is. A lot of people prefer to
play a character rather than playing a version of yourself. In Yurf, you are the character.

Why? Mostly because I've found that children love that brand of immersion. I wonder if it's because of the
way a child's imagination works. When you're a kid, and you read a character in the game saying *your*
name, talking to *you*, it's a big deal.

## Off to Wonderland 
Most everybody figured out the literary influences for Yurf right away, which the game wears on it's sleeve.
Of course, you should read *The Phantom Tollbooth*, if you haven't. And *Alice in Wonderland*. Everybody goes on
about those books for a reason.

It occurred to me years ago reading those books that the events in the narrative could be mixed around
in a different order without really affecting the plot too much. Really, a story like *The Phantom Tollbooth*
is a series of vignettes; Milo goes from character to character, and situation to situation, without really
a lot of narrative mortar between each chapter. It occurred to me that this is kind of ideal for a game:
have a loose collection of events, which the player can encounter in any order, and a big finish at the end
where all the friends you've made come together to help you at the end. This solves another issue I've had
with interactive fiction protagonists over the years; often, players are tasked with controlling an
entirely amoral character, stealing everything that isn't nailed down, and you can't get to the ending otherwise.
Guybrush ruins a guy's life while he's just doing his job as a cook, only to swindle his boss out of
a week's pay.

But what if the game was about meeting new people in this fantastical place? Instead of stealing and
being a general menace to society, you're experiencing new places and characters, and helping
them out. Milo, from *Tollbooth*, and Alice from *Wonderland*, don't have a ton of personality.
They're really just analogues for the audience. Why not remove that stand-in character altogether and
make *you* personally travel through Wonderland? If you personally could take the trip, would anyone
really miss Alice?

## My Favorite Part
There's a lot of Yurf that I wish was better. Going on about that would be a long, boring, rambling tract,
more so than what you're already reading. But overall, I'm very proud of Yurf, and think a lot of it works.
I quite like the ending, especially, because I feel most interactive fiction ends up being somewhat
anticlimactic.

My second favorite bit is the poem about the number mites.

## A Few Extra Secrets for Good Measure
* At the end of the game, you discover that both the guard turtles, Dodo and Boz, are in fact both
named Charles. This is a reference to Charles Dodgson, Dodo, and Charles Dickens, Boz. This is 
why I made sure Dodo chortles at least once -- the word *chortle* was apparently invented by
Dodgson. 
* One of the things I loved about text adventures as kid, and still love, is the ability
to type anything in and see what the game does. I didn't put as much of this into Yurf as I should
have. Still, there are some secrets. For example, one puzzle requires that you type the grave key.
(You know, silent as the grave?) Other symbols, like !@#$%^&* do things too. When (or if) I write
another game engine, I want to make it easier for the author to put in little gems just under
the surface.
* Yurf features a couple of paintings. Melody's story (and painting) are based the real
life story of Pictures at an Exhibition by Mussorgsky. The painting itself is Cart with Black Ox
by Van Gogh. For a full listing of all the poems and pictures, type CREDITS at any time into the
command prompt.
* I've uploaded the complete source code for this game to the IF Archive. If some curious kid
wants to poke around in the internals of Yurf, I ask forgiveness in advance for my atrocious
JavaScript style.
