! keyboard.inf - some general keyboard reading routines.

! ZBefunge - a Befunge interpreter for a Z Machine.
! Copyright 1998 Francis Irving.

! This source code is distributed under the GNU general public license,
! version 2 or later (at your option).  See the file copying.txt for
! full information.

! Ask for yes/no and return true/false
[ YesNo code;
	@read_char 1 -> code;
	while (code ~= 'y' or 'Y' or 'n' or 'N')
	{
		@read_char 1 -> code;
	}
	if (code == 'y' or 'Y')
		rtrue;
	else
	   rfalse;
];

! Read a single char from the keyboard and return its code.
[ ReadKey code;
	code = PreFunctionise();
	if (code >= 0)
		return code;
	@read_char 1 -> code;
	code = Functionise(code);
	if (code == -2)
		return ReadKey(code);
	return code;
];

! Used in ReadTimedKey below
global timed_out;
[ KeyInterrupt;
  timed_out = 1;
  rtrue;
];

! Read a key, waiting for 1/10th sec.  If timed out, return -1
[  ReadTimedKey code;
	code = PreFunctionise();
	if (code >= 0)
		return code;
	 timed_out = 0;
	 @read_char 1 1 KeyInterrupt code;
	if (timed_out)
	   code = -1;
	else
	{
		code = Functionise(code);
		if (code == -2)
			return ReadTimedKey(code);
	}
	return code;
];

global function_escape = false;
global function_escape_mid_cancel = false;
global f_pressed;
global after_f_pressed;

! Allow user to type 'f' '9' for F9 etc.
[ PreFunctionise;	
	if  (function_escape_mid_cancel)
	{
		function_escape_mid_cancel = false;
		return after_f_pressed;
	}
	return -1;
];

[ Functionise code;
	if (code < 0)
		return code;

	if (function_escape)
	{
		function_escape = false;
		if (code >= '1' && code <= '9')
		{
			return (code - '1' + FUNCTION_1);
		}
		if (code == '0')
			return FUNCTION_10;
		after_f_pressed = code;
		function_escape_mid_cancel = true;
		return f_pressed;
	}

	if (code == 'f' || code == 'F')
	{
		f_pressed = code;
		function_escape = true;
		return -2;
	}
	return code;
];

