
Object sc_6
  class Scene,
  with
	number 6,
	init_scene [;
		SetQuestion(q6_1);
	],
	begin_scene [ rock;
		loseguardseast.startup();
		give finaldrawer ~open ~general;
		give hypervent ~open;
		give finaldoor ~open;
		switch (rock) {
			1: ! first time in
				move activeplayer to FakeFrontier; 
				! give FakeFrontier visited; ! Good idea? Dunno.
				SaveToolPositions();
			2, -1, -2, -3: ! all subsequent times (including boom/splat/pow)
				move activeplayer to FakeFrontier; 
				RestoreToolPositions();
				set_parent(poisonpen, activeplayer); ! the heck with subtlety
				move pennib to poisonpen;
				remove penstain;
		}
	],
	end_scene [ rock subrock;
		loseguardseast.shutdown();
		loneguard.shutdown();
		loseguardsnorth.shutdown();
		if (hypervent has general) {
			rock = 20; ! the paranoia override
		}
		switch (rock) {
			-1:
				if (q6_da1 hasnt general) {
					give q6_da1 general;
					SetQuestion(q6_da1);
				}
				else {
					SetQuestion(q6_dab1r);
				}
			-2:
				if (q6_db1 hasnt general) {
					give q6_db1 general;
					SetQuestion(q6_db1);
				}
				else {
					SetQuestion(q6_dab1r);
				}
			-3: ! security door open
				"The door opens, only it's ajar. Ha! Ha! Ha! [BUG]";
			-4: ! pen suicide
				SetQuestion(q6_dp1);
			-5: ! gun suicide
				SetQuestion(q6_dp1);
			1: ! run into guards in upper hallways (before loneguard)
				SetQuestion(q6_d1);
			2: ! lone guard shoots you
				SetQuestion(q6_d2);
			3: ! still holding everything
				SetQuestion(q6_d3);
			4: ! put everything in drawer
				SetQuestion(q6_d4, subrock);
			5: ! things in more than one place
				SetQuestion(q6_d5, subrock);
			20: ! he sees the vent
				SetScene(sc_7);
		}
	];

! Emotional status to date: (absolute strained maximums)
! Minimum: 8 helpful, 6 cosmos, nothing else.
! Maximum: 6 blatant lies, 4 sneaky lies, 12 stubborns, 6 angries, 7 stupid,
!   7 jingos, 4 dumb recall.
! (That's not counting acid/blast queries, which are 1 sneaky, 3 blatant,
! 3 stubborn, 1 angry; or 1 helpful.)
! In startup: +1 dumb recall.

Object q6_1
  class Question,
  with
	query [;
		print "^~And away you went.~ ";
		print "He considers. ~You were searching the
			storage room for your lockpick, of course. I'm afraid I had it
			at the time. ...Although whoever left the pen lying out is due
			a reprimand. Sloppy, and you provided an excellent demonstration
			of why.~ His smile is, for the first time, self-satisfied. It's
			more frightening even than you expected -- but quickly gone.^^";
		print "~And you entered my office looking for... what?";
		if (SecurityOffice hasnt general) {
			print " Obviously not to duck in for a single breath of air,
				as you just showed me. What, then?";
		}
		if (OfficeSketchNumHanging() ~= 3) {
			print " I'm sure it wasn't my artwork -- that's still there,
				and petty vandalism is beneath you in any case. What, then?";
			OfficeSketchStartup();
		}
		print " Passcodes, keys, open drawers and indiscretions?~^";
	],
	time_limit 4,
	answer_yes [;
		num_dumb_recall++;
		print "~I'm not at all sorry to have disappointed you. I am good
			at my job, and I am careful, which is the same thought. If you
			could have caught me loose, caught me blind or far-eyed,
			you might have succeeded. You did not.~ And there is a brief
			silence.^";
		SetQuestion(q6_2);
	],
	answer_no [;
		print "~What, then, my books of dawn-tales? I wonder if I understand
			you at all.~ His gaze rests on yours, deceptively light. After
			a moment he continues as lightly.^";
		SetQuestion(q6_2);
	],
	answer_wait [;
		self.answer_yes();
	];

Object q6_2
  class Question,
  with
	query [ ix;
		print "^~What am I to make of you?";
		if (num_blatant_lies + num_sneaky_lies >= 4) {
			print " You are endlessly inventive in your lies";
			if (num_blatant_lies - num_sneaky_lies >= 3)
				print ", if less subtle than brazen";
			else if (num_blatant_lies - num_sneaky_lies <= -2)
				print ", and more subtle than most in trying to mislead
					me";
			ix = 1;
		}
		else {
			print " You speak me the truth as best you can";
			ix = 2;
		}
		if (num_stubborns - num_helpfuls >= 4) {
			if (ix == 2)
				print ", when you do speak; yet you";
			else
				print ". You";
			print " are stubborn as Tarn ice to my questioning";
		}
		else if (num_stubborns - num_helpfuls <= -2) {
			if (ix == 1)
				print ". Yet you";
			else
				print ". You";
			print " are plain with me, when you could drag your feet
				and slow my questioning";
		}
		else {
			print "; you flex like grass, sometimes stubborn as stone,
				sometimes easy with your answers";
		}
		if (num_got_angry > 1) {
			print ". You have made me angry";
			if (num_got_angry > 3)
				print ", more than once over these past few hours;";
			else
				print ", once or twice;";
			print " that is unusual";
		}
		else {
			print ". You have striven to keep this session calm, and I do
				not think it was out of fear of my anger";
		}
		print ". Your eyes never, never waver from mine.~";
		print "^^He leans back in his own chair, bearing your gaze. ~I have
			tried to treat you as an equal, a companion in our work. That
			is technique, of course; we both know that. But it is also sincere";
		if (num_jingos - num_cosmos < 1) {
			print ". And I think you have taken it in that faith. We ",
				(emphstring) "are", " faces reflected in the mirror 
				of our countries'
				border. I think you understand that.~ He nods.";
			ix = 1;
		}
		else {
			print ". ...You are different, I think. You are convinced your
				side is right, and ours is wrong, and that you must win.
				Perhaps I should envy that conviction. It is my own burden
				that I cannot even do that.~ He shakes his head.";
			ix = 2;
		}
		if (num_stupids + num_dumb_recall > 5) {
			print "^^~";
			if (ix == 1)
				print "You do see that much";
			else
				print "You have that much";
			print ". You may not be brilliant -- you make mistakes -- but
				you are determined. You hold that strength to what you
				believe";
		}
		else {
			print "^^~";
			if (ix == 2)
				print "And in spite of this, I";
			else
				print "I";
			print " know you are intelligent, as well as determined. You hold
				those strengths to what you believe";
		}
		if (ix == 1)
			print ", and in that you are not so different from me";
		else
			print ", even if what you believe seems -- well. As I said";
		print ".~^^He shrugs, and offers a smile as honest as you have
			seen. ~Well? Have I done well? It is my job to know everything
			about you, after all.~^";
	],
	answer_general " reaches again for his controls. ~But we are nearly done.
		You have only a few more seconds; and you have yet to show me
		what becomes of your mysterious cloth-wrapped package.~",
	answer_yes [;
		print "He bows in place, both palms open. ~I am delighted.~^^And
			then he";
		self.answer_general();
		BeginScene(1);
	],
	answer_no [;
		print "~No? Or is this merely the final lie?~ He smiles again, to
			show he is joking.^^And then he";
		self.answer_general();
		BeginScene(1);
	],
	answer_wait [;
		print "~One last bout of silence?~ He shrugs, and";
		self.answer_general();
		BeginScene(1);
	];

Object q6_d1
  class Question,
  with
	query [;
		print "^~Cutting matters a bit short, aren't we? There's someone
			you forgot to meet. And we did not capture you with your tools --
			much less that fascinating package.~^";
		BeginScene(2);
	];
	
Object q6_d2
  class Question,
  with
	query [;
		print "^~The guard shot you? And then shot himself, one must suppose.
			No. He has not yet regained his wits, but I think when he does,
			he will tell a different story.~^";
		BeginScene(2);
	];

Global DumbGlobalGuardOut;

Object q6_d3
  class Question,
  with
	answer_general [;
		! ok, query_general
		if (self hasnt general)
			print "^~Well done.~ The man is applauding softly. ~A heroic end
				to your shining tale; and in the large, an accurate one.
				But not precise.";
		else
			print "^~Yes, yes, but you still have not bought the details.";
		give self general;
		if (DumbGlobalGuardOut == 0)
			print " The guard, for a beginning, was left in considerably
				worse shape than you have admitted. But that is of less
				concern.";
		rtrue;
	],
	query [;
		q6_d3.answer_general();
		print " You fell into our hands without those fascinating tools
			you have been showing off all this time. And without the package,
			you understand, the one you found in ", (emphstring) "my",
			" corridor ceiling. I am very curious to know what you did with
			those things.~^";
		BeginScene(2);
	],
  has ~general; ! general, for once, means the answer_general variant

Object q6_d4
  class Question,
  with
	query [;
		q6_d3.answer_general();
		print " We were certainly not fools enough to ignore the broken
			cabinet drawer";
		if (self.variant)
			print " -- not after you left it standing open";
		print ". You left nothing inside it.~^";
		BeginScene(2);
	];
	
Object q6_d5
  class Question,
  with
	query [;
		q6_d3.answer_general();
		print " You did not leave your things scattered about the hallway";
		if (self.variant)
			print "; and nothing inside the cabinet drawer, either";
		print ". We have found no sign of those fascinating tools,
			or of that package. I am very curious to know what you did
			with them.~^";
		BeginScene(2);
	];
	
Object q6_da1
  class Question,
  with
	query [;
		print "^~Everyone was watching. You didn't have your precious
			acid. You didn't have anything when you were captured; you
			still haven't told me where you put it all. I still want
			to know.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked
	
Object q6_db1
  class Question,
  with
	query [;
		print "^~No. You didn't have your clever little explosive.
			You didn't have anything when you were captured; you
			still haven't told me where you put it all. I still want
			to know.~^";
		BeginScene(2);
	],
  has ~general; ! general means it's been asked
	
Object q6_dab1r
  class Question,
  with
	query [;
		print "^~Enough. No magic tricks, no bursts of acid, no explosions;
			just the truth.~^";
		BeginScene(2);
	];
	
Object q6_dp1
  class Question,
  with
	query [;
		print "^~Believe me, we would have been delighted to find you lying
			unconscious in the hallway. We were not so lucky.~^";
		BeginScene(2);
	];
	
! ------------- The scene where you lose

Object loseguardseast "footsteps to the east"
  with
	name 'guard' 'guards' 'footstep' 'footsteps' 'step' 'steps' 
		'e//' 'east' 'eastern',
	description "Footsteps are approaching.",
	react_before [;
		Listen:
			if (noun == nothing)
				<<Listen self>>;
		ThrowDir:
			if (second == e_obj or nw_obj)
				<<ThrowAt noun self>>;
		Hide:
			return L__M(##Hide, 2);
	],
	before [;
		Examine:
			rfalse;
		Listen:
			<<Examine self>>;
		Enter:
			<<Go e_obj>>;
		ThrownAt:
			print "You lean around the corner and hurl ", (the) noun, 
				" at the guards. Shouts chase you back.
				You have a bare second before the guards fall into
				the intersection -- from both the
				east and northwest -- dropping to the ground, guns out and
				braced.^";
			EndScene(1, 0);
			rtrue;
		default:
			"The guards are off to the east.";
	],
	life [;
		<<Touch self>>;
	],
	startup [;
		move self to FakeFrontier;
		move loseguardswest to FakeFrontier;
		self.number = 0;
		StartDaemon(self);
	],
	shutdown [;
		StopDaemon(self);
		remove self;
		remove loseguardswest;
	],
	number 0,
	daemon [;
		self.number++;
		switch (self.number) {
			1:
				print "^You throw yourself to a halt, nearly stumbling, as you
					hear footsteps approaching from the northwest...
					and then the guards behind you become audible as well.
					You duck around the southern corner and glance about
					desperately.^";
			2, 4:
				print "^The guards to the east are drawing closer.^";
			3, 5:
				print "^The guards to the northwest are drawing closer.^";
			6:
				print "^A group of guards comes around the corner from the
					east. One begins to salute lazily up the northwest corridor;
					then they spot you, all at once, and all at once they
					hurl themselves at you. You are pinned before you can
					begin to retreat.^";
				EndScene(1, 1);
				rtrue;
		}
	],
  has scenery animate pluralname;

Object loseguardswest "footsteps to the northwest"
  with
	name 'guard' 'guards' 'footstep' 'footsteps' 'step' 'steps' 
		'nw' 'northwest' 'northwestern',
	description "Footsteps are approaching.",
	before [;
		Examine:
			rfalse;
		Listen:
			<<Examine self>>;
		Enter:
			<<Go nw_obj>>;
		ThrownAt:
			<<ThrowAt noun loseguardseast>>;
		default:
			"The guards are off to the northwest.";
	],
	life [;
		<<Touch self>>;
	],
  has scenery animate pluralname;

Object loseguardsnorth 
  with
	name 'group' 'guards' 'footstep' 'footsteps' 'step' 'steps' 
		'n//' 'north' 'northern',
	short_name [;
		if (self hasnt general)
			print "footsteps to the north";
		else
			print "guards to the north";
		rtrue;
	],
	description [;
		if (self hasnt general)
			"Footsteps are still approaching.";
		else
			"Several guards are arrayed in the intersection -- crouched, sheltered
				by the corners, or prone on the floor. They all seem intent on
				taking you down.";
	],
	react_before [;
		Listen:
			if (noun == nothing)
				<<Listen self>>;
		ThrowDir:
			if (second == n_obj)
				<<ThrowAt noun self>>;
		Hide:
			if (loneguard in FinalEnd && loneguard hasnt general) {
				! he's there and awake
				return L__M(##Hide, 3);
			}
			else {
				if (self hasnt general)
					return L__M(##Hide, 4);
				"It's too late to hide.";
			}
	],
	before [;
		Examine:
			rfalse;
		ShootAttack:
			rfalse;
		AttackWith:
			if (second ofclass PulseGun)
				rfalse;
			<<Touch self>>;
		Listen:
			if (self hasnt general)
				"Footsteps are still approaching.";
			else
				"The guards are well-trained to shoot first, talk later. That's
					the beauty of pulse guns.";
		Enter:
			<<Go n_obj>>;
		ThrownAt:
			move noun to FakeFrontier;
			if (self hasnt general)
				print_ret "You toss ", (the) noun, " up the corridor.
					It clatters into the intersection, and you hear startled
					words from the guards around the corner.";
			else
				print_ret "You toss ", (the) noun, " up the corridor.
					It clatters among the guards, and they shift reflexively
					to let it pass.";
		default:
			print "The guards are";
			if (self hasnt general)
				" around the corner, off to the north... for the moment.";
			else
				" off to the north.";
	],
	life [;
		ShootAttack:
			if (self hasnt general)
				"The guards are not yet in sight.";
			if (player in finalcabinet) {
				print "You drop from your perch";
			}
			else {
				print "You roll backwards";
			}
			print ", aiming blindly up the corridor -- 
				precision doesn't matter now. And then the crackle of
				pulse charges begins to echo. You hear someone fall, good,
				a mark; you are ducking behind the filing cabinet, you have
				no attention to spare.^^";
			print "Sparks shower off the cabinet. You lean around and snap
				off more shots; clean misses. Pulses flash by you. You peer
				into the hail, and aim -- two down, three --^^";
			print "There is a weightless impact of darkness, and you are borne
				down in a sparkling corona.^";
			TryToDie();
			rtrue;
		default:
			<<Touch self>>;
	],
	startup [;
		move self to FinalEnd;
		self.number = 0;
		self.number2 = 0;
		give self ~general;
		StartDaemon(self);
	],
	shutdown [;
		StopDaemon(self);
		remove self;
	],
	number 0,
	number2 0, ! for door hack
	daemon [;
		if (finaldoor has open) {
			! this relies on this daemon happening after loneguard
			if (self.number2 == 0) {
				self.number2 = 1;
			}
			else {
				give finaldoor ~open;
				print "^The door slides shut.^";
			}
		}
		self.number++;
		switch (self.number) {
			6:
				print "^The footsteps to the north are closer now.";
				if (loneguard hasnt general) {
					print " The guard glances swiftly that way, and then
						shouts hoarsely.^";
					self.number = 11;
				}
				else {
					new_line;
				}
			8, 10:
				print "^The footsteps to the north are closer now.^";
			12:
				give self general;
				print "^~Hold you!~ comes a shout from the north. You take
					a quick glance; several guards have come around the
					corner. Their narrow eyes take in";
				if (loneguard hasnt general) {
					print " your struggle";
				}
				else {
					print " the fallen shape";
					if (player in finalcabinet)
						print " below you";
					else
						print " at your feet";
				}
				print ", and they bring up their weapons.^";
			13:
				print "^The pulse-guns to the north begins crackling.";
				if (loneguard hasnt general)
					print " The guard and you, still scuffling, are both
						unconscious within moments.^";
				else
					print " You dive for cover behind the cabinet, 
						but a bolt slaps into you before you are
						halfway there.^";
				TryToDie();
		}
	],
  has scenery animate pluralname; ! general means in sight

Object FakeFrontier "Diagonal Branch"
  with
	description [;
		if (escaping)
			"This set has been struck for the night. Go e, nw, or s. [BUG]";
		print "This bare stretch of hallway angles from the northwest to
			the east; another short hall leads south.";
		if (loseguardseast.number > 0)
			print " You are backed into the southern branch.";
		new_line;
		rtrue;
	],
	e_to [;
		print "You leap around the corner and charge the guards. You almost 
			get within twenty feet before their pulse guns cut you down.^";
		EndScene(1, 0);
		rtrue;
	],
	nw_to [;
		<<Go e_obj>>;
	],
	s_to [;
		print "You back down the corridor, as silently as you can.^";
		loseguardseast.shutdown();
		loneguard.startup();
		loseguardsnorth.startup();
		return FinalEnd;
	],
	cant_go "Hallways run northwest, east, and south.";

Object -> fakeequipend "south hall"
  with
	name 'south' 'southern' 's//' 'short' 'hall' 'hallway' 'branch'
		'dead' 'end',
	description "The hall runs a few yards to the south, and then dead-ends.
		There is a closed door to one side.",
	react_before [;
		ThrowDir:
			if (second == s_obj)
				<<ThrowAt noun self>>;
	],
	before [;
		Examine: 
			rfalse;
		Enter:
			<<Go s_obj>>;
		ThrownAt:
			move noun to FinalEnd;
			print_ret (The) noun, " clatters down the hall into the dead
				end.";
		default: 
			"The hallway is off to the south.";
	],
  has scenery;

Object -> fakeequipdoor "door"
  with
	name 'door',
	description "The door at the end of the south hall is closed.",
	before [;
		Examine: 
			rfalse;
		ThrownAt:
			<<ThrowAt noun fakeequipend>>;
		default: 
			"The door is at the end of the hallway, to the south.";
	],
  has scenery;

Object FinalEnd "Dead End"
  with
	description [;
		print "The hallway ends in a blank white wall. A metal door stands";
		if (finaldoor hasnt open)
			print " closed";
		else
			print " open";
		print " to the west.";
		new_line;
		if (loseguardsnorth in self && loseguardsnorth has general)
			print "^A large group of guards is visible to the north.^";
		rtrue;
	],
	n_to [;
		if (escaping) {
			return SouthFrontier;
		}
		if (loseguardsnorth hasnt general)
			print "You make a break up the hallway -- only to come into view of
				two groups of guards, at once. Their pulse guns knock you sprawling
				before you can duck back.^";
		else
			print "You charge the guards and all their guns. It doesn't work.^";
		if (parent(loneguard) == nothing)
			EndScene(1, 0);
		else
			TryToDie();
		rtrue;
	],
	w_to finaldoor,
	cant_go "You can only return to the north, or face the western door.";
	
Object -> finalcabinet "filing cabinet"
  with
	name 'filing' 'cabinet',
	initial [;
		print "A discarded filing cabinet is standing by the wall. ";
		<Examine finaldrawer>;
		rtrue;
	],
	description [;
		print "It's a standard three-drawer file cabinet. ";
		<<Examine finaldrawer>>;
	],
	vehicle_name " (standing on the filing cabinet)",
	ceiling_reachable true,
	react_before [;
		Exit:
			if (player in self) {
				move player to parent(self);
				if (keep_silent == 0)
					print "You get down off ", (the) self, ".^";
				rtrue;
			}
		Go:
			if (player in self && noun == d_obj)
				<<Exit>>;
	],
	before [;
		Climb:
			<<Enter self>>;
		Take:
			if (player in self)
				<<Push self>>;
			"The cabinet is too heavy to lift.";
		Push:
			if (player in self)
				"Not while you're standing on it.";
			"You give the cabinet a tentative push; it moves, with a metallic
				screech which freezes you with alarm.";
		Pull:
			if (player in self)
				<<Push self>>;
			"You give the cabinet a tentative pull; it moves, with a metallic
				screech which freezes you with alarm.";
		Search:
			<<Search finaldrawer>>;
		Open, Close, Empty:
			<<(action) finaldrawer>>;
		Receive:
			if (receive_action == ##Insert)
				<<Insert noun finaldrawer>>;
		HideBehind:
			if (loneguard in FinalEnd && loneguard hasnt general) {
				rfalse; ! leave it to the loseguardsnorth
			}
			if (loseguardsnorth has general) {
				rfalse;
			}
			"It's not much cover.";
	],
  has supporter static enterable;

Object -> finaldrawer "drawer"
  with
	name 'drawer' 'drawers',
	description [;
		if (self hasnt open) {
			"The drawers are closed.";
		}
		else {
			if (child(self) == 0)
				"One drawer is open; it is empty.";
			print "One drawer is open. ";
			<<Search self>>;
		}
	],
	before [;
		Take:
			if (self has open)
				<<Open self>>;
			print_ret "That is a part of ", (the) finalcabinet, ".";
		Pull:
			<<Open self>>;
		Push:
			<<Close self>>;
		Open:
			if (self has open)
				"The drawer won't come out any farther.";
	],
	after [;
		Open:
			if (self has general) {
				print "You open the drawer. ";
				<<Search self>>;
			}
			give self general;
			"You yank on the drawers; two are locked, but one comes open
				with an internal clank. The drawer is empty.";
	],
  has scenery container openable ~open ~general; ! general for open message

Object -> finaldoor "metal door"
  class InteriorDoor,
  with
	name 'w//' 'west' 'western',
	description [;
		print "The door to the west is metal. It has no handle;
			another black plate is visible beside it. The door is";
		if (self hasnt open)
			" closed.";
		else
			" open; you can see a large room beyond, busy with
				computer terminals and moving figures.";
	],
	door_dir w_to,
	door_try [; 
		if (self has open)
			"The guard is still standing in front of the doorway.";
		PronounNotice(self);
		print_ret (The) self, " is very definitely closed."; 
	],
	before [;
		ActivateTool:
			"^The door opens, revealing a phone booth. [BUG]";
	];

Object -> finaldoorplate
  class InteriorPlate,
  with
	work_target finaldoor;

Object -> hypervent "ventilator grille"
  with
	parse_name [ num wd;
		num = 0;
		wd = NextWord();
		while ((WordInProperty(wd, ventilator, name) ~= 0)) {
			num++;
			wd = NextWord();
		} 
		return num;
	],
	description [;
		if (self hasnt open)
			<<Examine ventilator>>;
		print "A plastic grille is visible high on the wall, just below the
			ceiling. It's hanging open";
		if (player notin finalcabinet)
			", but you can't see in from this low angle.";
		if (child(self)) {
			print ". In the duct behind it, you can see ";
			WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
			".";
		}
		else {
			"; the duct behind appears empty.";
		}
	],
	before [;
		Examine:
			rfalse;
		Search:
			if (self hasnt open)
				<<Search ventilator>>;
			if (player notin finalcabinet)
				"You can't see into the grille from down here.";
			if (child(self)) {
				print "In the duct, you can see ";
				WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
				".";
			}
			else {
				"The ventilation duct appears empty.";
			}
		Enter:
			if (player notin finalcabinet)
				<<Touch ventilator>>;
			"The grille is barely a foot wide.";
		EmptyT:
			if (player notin finalcabinet)
				<<Touch ventilator>>;
			"Your position is precarious enough without that kind of juggling.";
		Empty:
			if (player notin finalcabinet)
				<<Touch ventilator>>;
			if (self hasnt open)
				rfalse;
			if (child(self) == nothing)
				"You can't see anything in the ventilation duct.";
		Open:
			if (self has open)
				print_ret (The) self, " is already open.";
			if (player notin finalcabinet)
				<<Touch ventilator>>;
			give self open;
			give self general;
			print "You lever the grille open with your fingers.^";
			if (child(self)) {
				print "^Inside, you can see ";
				WriteListFrom(child(self), TERSE_BIT + ENGLISH_BIT + PARTINV_BIT);
				print ".^";
			}
			rtrue;
		Close:
			if (self hasnt open)
				print_ret (The) self, " is already closed.";
			if (player notin finalcabinet)
				<<Touch ventilator>>;
			give self ~open;
			"You close the grille.";
		Listen:
			<<Listen ventilator>>;
		ThrownAt:
			rfalse;
		default: ! including LetGo
			if (player notin finalcabinet)
				<<Touch ventilator>>;
			rfalse;
	],
  has scenery container ~open ~general; 
	! general means you've done something suspicious with it.

Object loneguard "guard"
  with
	name 'guard' 'man',
	describe [;
		if (self hasnt general) {
			if (self.number == 2)
				"^The guard stands in the open doorway, staring wildly, but also
					reaching for his gun.";
			else 
				"^The guard is backpedalling, levelling his gun at you.";
		}
		else {
			"^The guard is sprawled unconscious on the floor.";
		}
	],
	description [;
		if (self hasnt general) {
			print "He is young, with short dark hair. His uniform is tightly
				creased and perfectly clean. And the confusion is rapidly 
				clearing from his eyes, as he reaches for the pulse gun in his
				holster.^";
		}
		else {
			print "He is young, with short dark hair. He lies sprawled on the floor,
				unconscious, uniform mussed now.";
			if (loneguardgun in parent(self))
				print " His gun has fallen on the floor nearby.";
			new_line;
		}
		rtrue;
	],
	before [;
		ActivateTool:
			if (player in finalcabinet) {
				keep_silent = 1;
				<Exit>;
				keep_silent = 0;
				print "You hurl yourself off the cabinet, pen clutched in your
					fist; your weight drives it into the guard's shoulder.";
			}
			else {
				print "You feint, and then jab the pen into the guard's shoulder,
					as hard as you can.";
			}
			print " His reflexive counter hurls you into
				the wall.^^But then he shivers, once, and slides to the ground,
				and remains there.^";
			StopDaemon(self);
			give self general;
			move loneguardgun to parent(self);
			move self to parent(self); ! to get order right
			rtrue;
		Search:
			if (self hasnt general)
				"Not while he's trying to shoot you.";
			"You pat the body down quickly, but nothing is immediately
				apparent. And you don't have time for a more thorough
				search.";
		Push, Pull:
			if (self hasnt general)
				<<Attack self>>;
			"The guard shifts limply.";
		Take:
			if (self hasnt general)
				"Not likely, particularly when he's trying to shoot you.";
			"Not likely.";
	],
	life [;
		Attack:
			if (self hasnt general) {
				if (player in finalcabinet) {
					keep_silent = 1;
					<Exit>;
					keep_silent = 0;
					print "You hurl yourself off the cabinet, knocking the
						guard to the floor with your full weight.^";
				}
				else {
					switch (random(3)) {
						1: print "You knock the guard's feet out from under
							him.^";
						2: print "You land a fierce blow, driving the guard into
							the wall.^";
						default: print "You lash at the guard; he staggers back.^";
					}
				}
				self.number = 10;
				rtrue;
			}
			else {
				"That would be redundant; he's not waking up soon.";
			}
		ShootAttack:
			"That would be redundant; he won't be waking up soon.";
		Ask, Tell, AskFor, Answer:
			if (self hasnt general)
				"He ignores this.";
			else
				"He can't hear you.";
		Show, Give:
			if (self hasnt general)
				"He ignores this.";
			else
				"He can't see you.";
		Kiss:
			#ifdef ZDEBUG;
			self.number = 20;
			"The guard decides he likes you. [DEBUG]";
			#ifnot;
			"What an extremely bad idea.";
			#endif; ! ZDEBUG;
	],
	orders [;
		if (self hasnt general)
			"He ignores you.";
		else
			"He can't hear you.";
	],
	startup [;
		remove self;
		self.number = 0;
		give self ~general;
		move loneguardgun to self;
		give loneguardgun ~moved;
		move loneguarduniform to self;
		StartDaemon(self);
	],
	shutdown [;
		StopDaemon(self);
		remove self;
		remove loneguardgun;
	],
	number 0,
	daemon [;
		if (location ~= FinalEnd) {
			self.shutdown();
			"Somewhere, a guard sings ~O Sole Mio.~ [BUG]";
		}
		self.number++;
		switch (self.number) {
			! 1: do nothing
			2: 
				give finaldoor open;
				move self to FinalEnd;
				PronounNotice(self);
				print "^The door snaps open suddenly, and the uniformed figure
					of a guard begins to step through. ~No, what's ",
					(emphstring) "frustrating", " is that you can't tell us
					what's in that blood-cursed lab,~ he is saying, back over his
					shoulder.^^Then he sees you. He fumbles for his pulse gun.^";
			3:
				if (self hasnt general)
					print "^The guard's gun is in his hand.^";
			4:
				print "^The guard tracks you carefully, and squeezes the
					trigger. Blackness slaps through you like a wave
					of cold iron.^";
				EndScene(2);
				rtrue;
			11:
				switch (random(3)) {
					1: print "^The guard pulls himself to his feet, and levels
						the gun again.^";
					2: print "^The guard hurls himself backward, rolls to his
						feet, and brings up his gun.^";
					default: print "^The guard gathers himself and aims again.^";
				}
			12:
				print "^The guard squeezes his trigger convulsively.
					Blackness slaps through you like a wave
					of cold iron.^";
				EndScene(2);
				rtrue;
		}
	],
  has static animate transparent ~general; ! general means unconscious

Object loneguardgun
  class PulseGun,
  with
	short_name "guard's gun",
	name 'guard^s',
	article "the",
	initial "His gun lies near his limp hand.",
	description [;
		print "It's a standard pulse gun, a typically sharp-lined weapon.
			Quiet, compact, capable of knocking a person unconscious across
			the length of a corridor -- perfect for indoor guard duty.";
		if (self in loneguard) {
			if (loneguard.number == 2)
				" The gun is in the guard's holster.";
			else
				" The gun is in the guard's hand.";
		}
		new_line;
		rtrue;
	],
	before [;
		Take:
			if (self in loneguard) {
				"You grab for the gun; but the guard twists it out of
					your reach.";
			}
		Attack:
			if (self in loneguard) {
				"You strike at the guard's gun, trying to knock it from
					him; but he evades you.";
			}
	];

Object loneguarduniform "guard's uniform"
  with
	name 'guard^s' 'uniform' 'clothing',
	description "You see nothing unusual about the guard's uniform.",
	before [;
		Take:
			if (loneguard hasnt general)
				"He doesn't look like he's interested in that kind of thing.";
			else
				"You don't have time. Stripping a limp body is impossibly
					awkward.";
		Search:
			<<Search loneguard>>;
	],
  has scenery;

[ TryToDie   ix jx;

	print "^^    ";
	print (boldstring) "*** You have been captured ***";
	print "^^";

	DumbGlobalGuardOut = (loneguard has general);
	
	! if attention is drawn to the vent *at all* -- like if the
	!   vent has been opened -- we proceed immediately to the escape
	!   sequence, regardless of what else has occurred. This is checked
	!   in end_scene().

	ix = LeftToolsBehind(6, player);
	if (ix == 0) {
		! still holding everything
		EndScene(3);
		rtrue;
	}
	
	jx = LeftToolsBehind(6, finaldrawer);
	if (jx == 0) {
		! hid everything in finaldrawer... unless it's open.
		EndScene(4, finaldrawer has open);
		rtrue;
	}
	
	! otherwise, there is stuff just scattered around. 
	! (But nothing in the vent.)
	EndScene(5, children(finaldrawer));
	rtrue;
];
