!***************************************************************************
!**
!** Not Just A Game - Copyright (c) 1999 by John Menichelli
!** 
!**                    Part 2 - Go Room and Maze
!**
!***************************************************************************

Object go_room "Dim Chamber"
   with description [;
           print "This chamber has been crudely carved out of solid rock. 
                  A marble pedestal occupies the center of the room. You 
                  may exit by going up the stairs or by following the tunnel 
                  which leads northeast.";

           if (self hasnt general) {
              give self general;
              "^^Thinking back, you seem to remember your teacher mentioning
               something about a basement. You always thought she was referring
               to a different house."; }
           else
              new_line; rtrue;
        ],
        u_to Living_Room,
        ne_to [; 
           #ifdef INCLUDE_HINTS;
              move maze_menu to hint_menu;
              return Maze;
           #ifnot;
              return Maze;
           #endif;
        ],
   has  light;

Object -> chamber_rock "solid rock"
   with name "walls" "walls" "floor" "ceiling" "room" "chamber" "solid" 
             "rock" "granite",
        description
           "The chamber has been carved out of solid granite.",
   has  scenery;

Object -> go_pedestal "pedestal"
   with name "marble" "pedestal",
        description
           "The marble pedestal dominates the center of the room. A wood 
            Go board rests on top of the pedestal.",
        before [;
           Receive:
              "There's already something there.";
        ],
   has  scenery;

!***************************************************************************
!**
!** The 9x9 go board is internally represented as follows:
!**
!**  I   0  1  2  3  4  5  6  7  8
!**  H   9 10 11 12 13 14 15 16 17
!**  G  18 19 20 21 22 23 24 25 26
!**  F  27 28 29 30 31 32 33 34 35
!**  E  36 37 38 39 40 41 42 43 44
!**  D  45 46 47 48 49 50 51 52 53
!**  C  54 55 56 57 58 59 60 61 62
!**  B  63 64 65 66 67 68 69 70 71
!**  A  72 73 74 75 76 77 78 79 80
!**
!**      1  2  3  4  5  6  7  8  9
!**
!***************************************************************************

!***************************************************************************
!**
!**   Used to see if a go stone has been captured
!**
!***************************************************************************

[ fadeout e f g h upper lower a b c d ;

      a = go_bd->e;
      b = go_bd->f;
      c = go_bd->g;
      d = go_bd->h;
      
      if ((a >= lower && a <= upper) &&
          (b >= lower && b <= upper) &&
          (c >= lower && c <= upper) &&
          (d >= lower && d <= upper))

         return 1;
      else
         return 0;
];

!***************************************************************************
!**
!** The value of go_bd->i determine what kind of stone occupies that 
!** position: 0 = empty, 1 = black, 2 to 5 = white, 6 to 9 = silver, 
!** 10 = gold
!**
!** The each_turn routine works like this:
!**
!** Check to see if four stones of the appropriate color
!** occupy the correct locations. If so, set the stair value to 1.
!** If the stairwell value is non-zero *and* the center location is also
!** non-zero (meaning there is still a stone there), remove the center
!** stone (go_bd->i = 0) and print a message.
!**
!***************************************************************************

[ PrintBoard i j f1 f2 f3 f4;
      font off;
      for (i=0: i<=80: i++) {
         if (i%9 == 0) {
            j = (i / 9) + 1;
            print (char) go_coord->j;
            print "  "; }

         switch (go_bd->i) { 
            0: if (i == 20 || i == 24 || i == 56 || i == 60) 
                  print "+ "; else print ". ";
            1:      print "X ";
            2 to 5: print "O ";
            6 to 9: print "S ";
            10:     print "G "; }

         if (i%9 == 8)
            print "^"; }

      print "^   1 2 3 4 5 6 7 8 9^^";

      font on;      

      for (i=0: i<=80: i++) {
         switch (go_bd->i) {
            1:      f1++;
            2 to 5: f2++;    ! There are white stones on the board
            6 to 9: f3++;    ! There are silver stones on the board
            10:     f4++; }} ! There is a gold stone on the board

      if (f1 > 0 || f2 > 0 || f3 > 0 || f4 > 0) {
         print "Legend:^^";
         if (f1 == 1) print "X: Black stone^";
         if (f1 > 1)  print "X: Black stones^";
         if (f2 == 1) print "O: White stone^";
         if (f2 > 1)  print "O: White stones^";
         if (f3 == 1) print "S: Silver stone^";
         if (f3 > 1)  print "S: Silver stones^";
         if (f4 == 1) print "G: Gold stone^"; }
      else
         rtrue;
];

[ CaptureMsg a b;
   print "As you place the last ";
   
   if (a == 1)
      print "white";
   else
      print "silver";
   
   print " stone on the board, the surrounded ";

   if (a == 1) 
      print "black"; 
   else
      print "gold";

   print " stone fades away. In the distance you hear a rumbling noise, as if 
           enormous stones were grinding against each other. After several 
           moments the noise subsides.^^";

   for (a=0: a<=80: a++) {
      if (go_bd->b == 1) b++; }
   
   if (b == 0)
      remove bl_stones;

   rtrue;
];

Object -> small_board "small Go board"
   with name "small" "wood" "wooden" "go" "board",
        description [ i j;
           print "The wooden Go board rests atop the pedestal. Here is a
           close-up of the board:^^";

           PrintBoard();

           ! Show instructions only if the player is holding Go stones

           objectloop (i in player) if (i has stone) j++;

           if (self hasnt general && j > 0) {
              give self general;
              "^To place stones on the board, you'll have to specify 
               which coordinate to put the stone on, such as, ~PUT [or PLACE 
               or PLAY] THE WHITE STONE ON E5.~ To take stones off of the 
               board, use the command ~REMOVE [or TAKE or GET] THE WHITE STONE 
               FROM D8~ or simply, ~GET E5.~ As a shortcut, you can also use 
               the command ~RESET BOARD~ to quickly remove all of the stones 
               you have placed on the board."; }
           else
              rtrue;
        ],
        before [ ;
           Search: <<Examine self>>;

           Burn:
              if (second == match && match has light) {
                 deadflag = 1;
                 "A booming voice says ~Wrong, cretin!~ and
                  you notice that you have turned into a pile
                  of dust. Wait - wrong game.... Oh, well, too late
                  now."; }
               rfalse;

           Take:
              "It's firmly attached to the pedestal.";

           Receive:
              if (noun hasnt stone)
                 "It's a Go board, not a table.";
              else
                 "You'll have to specify which coordinate to put 
                  the stone on, such as, ~PUT THE WHITE STONE ON E5.~";

           LetGo:
              if (noun == bl_stones)
                 <<Take bl_stones>>;
              else
                 "You'll have to specify which coordinate to get the stone 
                 from, such as, ~REMOVE THE WHITE STONE FROM D8~ or simply, 
                 ~GET E5.~ As a shortcut, you also use the command ~RESET 
                 BOARD~ to quickly remove all of the stones you have placed
                 on the board.";
        ],
        each_turn [ ;
           if (fadeout(11, 19, 21, 29, 5, 2) == 1 && go_bd->20 == 1) {
              Achieved(2);
              stair1 = 1;
              go_bd->20 = 0;
              print "^";
              CaptureMsg(1);
              PrintBoard(); }
           
           if (fadeout(15, 23, 25, 33, 5, 2) == 1 && go_bd->24 == 1) {
              Achieved(2);
              stair2 = 1;
              go_bd->24 = 0;
              print "^";
              CaptureMsg(1);
              PrintBoard(); }

           if (fadeout(47, 55, 57, 65, 5, 2) == 1 && go_bd->56 == 1) {
              Achieved(2);
              stair4 = 1;
              go_bd->56 = 0;
              print "^";
              CaptureMsg(1);
              PrintBoard(); }

           if (fadeout(51, 59, 61, 69, 5, 2) == 1 && go_bd->60 == 1) {
              Achieved(2);
              stair5 = 1;
              go_bd->60 = 0;
              print "^";
              CaptureMsg(1);
              PrintBoard(); }

           if (fadeout(31, 39, 41, 49, 9, 6) == 1 && go_bd->40 == 10) {
              stair3 = 1;
              go_bd->40 = 0;
              remove gold_stone1;
              print "^";
              CaptureMsg(2);
              PrintBoard(); }
           rtrue;
        ],
   has  scenery supporter;

Object -> -> bl_stones "black Go stones"
   with name "Go" "stone" "stones" "black" "slate",
        description
           "The black stones are made of slate.",
        before [;
           Take:
              "The black stones are fixed in place.";
        ],      
   has  scenery pluralname;

!***************************************************************************
!**
!**   Used to print MazeRoom descriptions
!**
!***************************************************************************

[ RoomDesc i;
      print "This room is shaped like a perfect cube. The
      walls, floor and ceiling are a ";
      switch (go_bd->i) {
         0:      print "light brown";
         1:      print "glossy jet black";
         2 to 5: print "creamy white";
         6 to 9: print "shiny silver";
         10:     print "bright gold"; }

      print " color. You may leave via the ";
      switch (i) {
      	 0:        print "south or east";
      	 1 to 7:   print "south, east or west";
      	 8:        print "south or west";
      	 9, 18, 27, 36, 45, 54, 63:  print "north, south or east";
      	 17, 26, 35, 44, 53, 62, 71: print "north, south or west";
         72:       print "north, east, or southwest";
         73 to 79: print "north, east or west";
         80:       print "north or west";
         default:  print "north, south, east or west"; }


      if ((stair1 == 1 && i == 20) ||         ! Water
          (stair2 == 1 && i == 24) ||         ! Wood
          (stair3 == 1 && i == 40) ||         ! Earth
          (stair4 == 1 && i == 56) ||         ! Metal
          (stair5 == 1 && i == 60))           ! Fire
         ". You may also go down the steep, narrow stone steps 
          descending through the hole in the floor.";
      else
         ".";
];

!***************************************************************************
!**
!**   This single room actually represents 81 "virtual rooms", arranged
!**   in a 9x9 pattern.
!**
!**   The color of the walls in each "room" are determined by what color 
!**   stone occupies the corresponding position on the 9x9 Go board
!**
!**   When the player drops anything in a virtual room, it is sent back 
!**   to the go_room - this way you don't have to track each item's
!**   virtual location.
!**
!***************************************************************************

Object Maze "Cube Room" 
   with description [; return RoomDesc(virtual_loc); ],
        before [ a;
           Drop:
             move noun to go_room;
             print_ret (The) noun, " shimmers out of existence as soon as 
                        it leaves your hand.";

           Go:
             if (noun==sw_obj && virtual_loc == 72) {
                PlayerTo(go_room);
                return 1; }

             if (noun==n_obj) {
                if (virtual_loc < 9)
                   return 0;
                else {
                   virtual_loc = virtual_loc - 9;
                   return RoomDesc(virtual_loc); }}

             if (noun==s_obj) {
                if (virtual_loc > 71)
                   return 0;
                else {
                   virtual_loc = virtual_loc + 9;
                   return RoomDesc(virtual_loc); }}

             if (noun==e_obj) {
                a = virtual_loc;
                a = ((a + 1)%9);
                if (a==0)
                   return 0;
                else {
                   virtual_loc++;
                   return RoomDesc(virtual_loc); }}

             if (noun==w_obj) {
                a = virtual_loc;
                a = a%9;
                if (a==0 || virtual_loc == 0)
                   return 0;
                else {
                   virtual_loc--;
                   return RoomDesc(virtual_loc); }}

             if (noun==d_obj && stair1 == 1 && virtual_loc == 20) {
                #ifdef INCLUDE_HINTS;
                   move water_menu to hint_menu;
                #endif;
                PlayerTo(Room1);
                return 1; }

             if (noun==d_obj && stair2 == 1 && virtual_loc == 24) {
                #ifdef INCLUDE_HINTS;
                   move wood_menu to hint_menu;
                #endif;
                PlayerTo(Room2);
                return 1; }

             if (noun==d_obj && stair3 == 1 && virtual_loc == 40) {
                RemoveStones();
                PlayerTo(Room3);
                return 1; }

             if (noun==d_obj && stair4 == 1 && virtual_loc == 56) {
                #ifdef INCLUDE_HINTS;
                   move metal_menu to hint_menu;
                #endif;
                PlayerTo(Room4);
                return 1; }

             if (noun==d_obj && stair5 == 1 && virtual_loc == 60) {
                #ifdef INCLUDE_HINTS;
                   move fire_menu to hint_menu;
                #endif;
                PlayerTo(Room5);
                return 1; }

             return 0;
        ],
   has  light;

Object -> steps "steep steps"
   with name "steep" "narrow" "stone" "steps" "stairs" "hole"
   with description [;
           if ((stair1 == 1 && virtual_loc == 20) ||
               (stair2 == 1 && virtual_loc == 24) ||
               (stair3 == 1 && virtual_loc == 40) ||
               (stair4 == 1 && virtual_loc == 56) ||
               (stair5 == 1 && virtual_loc == 60)) {
              "The stone steps descend into an underground chamber. You
               can't see much more than that from here."; }

           else
              "You can't see any such thing.";
        ],
   has  scenery;
