/* cvdie.c
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include "cvobj.h"
#include "cvorcs.h"
#include "cvocab.h"
#include "cvlocs.h"
#include "cvmisc.h"

/* "You're dead, Jim."  You got yourself killed somehow, clown.  The
 * easiest way is to go to location DEAD, which is the destination of
 * some entries in travel structures.  We allow this 'maxdie' times,
 * where maxdie is automatically initialized based on the number of
 * snide messages we have available (and how much orange smoke...) in
 * messages around rmsg[81].  Each death results in a message (81,83,...)
 * which offers reincarnation; if accepted, this results in message 82, 84,
 * etc.  The last time, if he wants another chance, he gets a snide
 * remark (what else? so what's new?) as we exit.  When reincarnated,
 * all objects being carried get moved to 'oldlc2' (presumably the last
 * place prior to getting killed) without change of prop number.  The lamp
 * is turned off and left outside the building (only if he was carrying
 * it, of course).  He himself is left outside the privy (and heaven help
 * him if he tries to "hope" back into the cave without the lamp!).
 *
 * 'oldlc2' is zapped so he can't just "retreat".
 */

void
die()
{
    int yea;
    struct cvobj *curobj;

    blklin = TRUE;
    if ((UNICRN->conn1.where == oldlc2)
	&& (loc == oldlc2)
	&& (UNICRN->prop)) {
	pspeak(UNICRN, 5);	/* very lucky! */
	UNICRN->prop = 1;
	loc = oldlc2;
    } else {
	if (closing || demo) {
	    rspeak(131);
	    ++numdie;
	    finish = TRUE;
	    return;
	}
	yea = yes(81 + numdie * 2, 82 + numdie * 2, 54);
	++numdie;
	if ((numdie == maxdie) || !yea) {
	    finish = TRUE;
	    return;
	}
	if (TOTING(LAMP)) {
	    move(LAMP, LAMPLOC);
	    LAMP->prop = 0;
	}
	loc = LAMPLOC;
	move(COMPASS, LAMPLOC);
	/* the following may be confusing. GIANT and PRIEST
	 * represent the same thing to the adventurer, but
	 * here they are represented by an 'object' and a
	 * 'monster'.
	 */
	if ((GIANT->prop == 1) && PRIEST->dseen)
	    destry(GIANT);
    }
    /* may or may not be dead; objects still get dropped */
    /* drop all objects (still) being carried. Throw away if over water. */

    /* BUGFIX - if oldlc2 is NULL, drop things at last loc instead.  
     * Some (admittedly rare) conditions can cause you to die without 
     * oldlc2 being set - for instance, restoring a game and then 
     * immediately dying */
    if (oldlc2 != NULL) {
	newloc = (oldlc2->flags & DROWN) ? LOST : oldlc2;
    } else {
	newloc = (loc->flags & DROWN) ? LOST : loc;
    }
    for (curobj = cvobj; curobj->desc != NULL; ++curobj)
	if (TOTING(curobj))
	    move(curobj, newloc);	/* drop them */
    if (RUG->prop == 1)
	RUG->prop = 0;		/* get off the rug */
    if ((BOAT->prop / 2) == 1)
	BOAT->prop -= 2;	/* leave the boat */
    if ((LNUM(SCROLL->conn1.where) == 91)
	|| INMAZE(SCROLL->conn1.where))
	move(SCROLL, &(cvloc[SCROLL->iloc]));
    if ((LNUM(MEDAL->conn1.where) == CAPE->iloc)
	|| (LNUM(MEDAL->conn1.where) == SPICE->iloc))
	move(MEDAL, &(cvloc[MEDAL->iloc]));
    if (SKELTN->prop == 1)
	SKELTN->prop = 2;
    newloc = oldloc = loc;
}
