/* cvact.c
 *	perform actions
 *************************************************************************/

#include <stdio.h>
#include "cvobj.h"
#include "cvocab.h"
#include "cvlocs.h"
#include "cvmisc.h"
#include "cvorcs.h"
#include "cvcode.h"
#include "cvrand.h"

extern int actspk[];		/* cvocab.c */
extern char *oword;

extern int cvsave();
extern int cvrest();
extern void putcode();
extern int mutilate();
extern void juggle();

#define	OKAY(msg) {rspeak(msg); return S_okay;}

#define	DEFMSG	OKAY(actspk[verb%1000])

#define	BREAKIT {                                                       \
        int i;                                                          \
        if ((i = mutilate(object))) {                                   \
            newloc = &(cvloc[i]);                                       \
            return S_move;                                              \
        } else {                                                        \
            return S_okay;                                              \
        }                                                               \
}

#define	FILLIT(object, liquid) \
    {(object)->prop = (liquid) - _WATER + 1;}

#define	INTRANS
#define	TRANS	10000 +

int
suicide()
{
    pspeak(SELF, 1);
    die();
    return S_show;
}

static void
dolight(object, state)
struct cvobj *object;
int state;
{
    if (object != LAMP) {
	rspeak(180);
    } else if (limit < 0) {
	rspeak(184);
    } else if (object->prop == state) {
	rspeak(182 - state);	/* already in that state */
    } else {
	rspeak(40 - state);
	object->prop = state;
	if (DARK) {
	    rspeak(16);
	}
    }
    return;
}

int
drownch()
{
    if (loc->flags & DROWN) {
	rspeak(120);		/* You can't swim */
	oldlc2 = loc;		/* and all your stuff gets lost in the water */
	die();			/* you guessed it! */
	return TRUE;
    } else {
	return FALSE;
    }
}

void
didorc()
{
    pspeak(ORCS, 3);		/* the orcs agree */
    ORCS->prop = 0;		/* now kill THEM off */
    pspeak(IDOL, 2);		/* idol explodes (which is what kills the orcs) */
    IDOL->prop = 0;		/* make idol toteable */
    destr2(IDOL);		/* unfix the idol */
    pspeak(IDOL, 0);		/* report the new state of the (now small) idol */
    GIANT->prop = 1;		/* Now for the BAD NEWS */
    pspeak(GIANT, 1);		/* He's after you for sure */

    /* Now start giant (as the priest) and the balrog */
    PRIEST->dloc = PRIEST->oloc = loc;	/* he's right with you */
    PRIEST->dseen = TRUE;	/* of course */

    BALLY->dloc = BALLY->oloc = &(cvloc[141]);	/* anchor ledge */
    BALLY->dseen = FALSE;	/* he'll get you later */
    return;
}

void
newcon(object, p, liquid)
struct cvobj *object;
int p, liquid;
{
    pspeak(object, p);		/* tell what the new contents are */
    if (HERE(ORCS) && (ORCS->prop == 1) && (liquid == _COLA))
	didorc();
}

int
drunkbear(object)
struct cvobj *object;
{
    BEAR->prop = 0;
    object->prop = (object == KEG) ? 1 : 0;
    move(object, loc);
    juggle(BEAR);
    move2(object, FIXED);
    YOGI->dseen = FALSE;
    YOGI->dloc = DEAD;
    if (AXE->prop == 1 && AXE->conn2.where == FIXED) {
	AXE->prop = 0;
	destr2(AXE);
    }
    return S_show;
}

int
wakeking()
{
    HELM->prop = 0;
    destry(HELM);
    ARTHUR->dseen = TRUE;
    ARTHUR->dloc = loc;
    pspeak(HELM, 2);		/* oops, he's after you */
    return S_okay;
}

int
unicorn()
{
    pspeak(UNICRN, UNICRN->prop + 2);
    if (UNICRN->prop == 1) {
	destr2(UNICRN);
	UNICRN->prop = 0;
	EINHORN->dseen = FALSE;
	EINHORN->dloc = EINHORN->oloc = DEAD;
	pspeak(UNICRN, 0);
    }
    return S_okay;
}

int
cvact(verb, obj, object)
int verb, obj;
struct cvobj *object;
{
    int k;

    switch ((!!obj * 10000) + verb) {
    case TRANS DROP:
    case TRANS THROW:		/* a few cases handled elsewhere */
    case INTRANS FEED:
    case TRANS FEED:
    case INTRANS POUR:
    case TRANS POUR:
    case INTRANS FILL:
    case TRANS FILL:
	return cvatt(verb, obj, object);

    case INTRANS SAVE:
	if (cvsave()) {
	    OKAY(54);
	} else {
	    return S_okay;
	}

    case INTRANS RESTOR:
	if (cvrest()) {
	    rspeak(54);
	    return S_show;
	} else {
	    return S_okay;
	}

    case INTRANS TAKE:
	/* take what?  I can figure it out if there's only one thing here,
	but otherwise, I complain. */
	if ((loc->atloc.link == NULL) || (loc->atloc.link->link != NULL)) {
	    return S_what;
	}
	/* if there's liquid here, too, I get confused, which may just
	confuse the adventurer, or may give him the hint he needs */
	if (LIQLOC(loc)) {
	    return S_what;
	}
	/* if the one object is the skeleton in attack mode, there's a
	cutlass too, so we treat it as confusing, too */
	if (HERE(SKELTN) && (SKELTN->prop == 1)) {
	    return S_what;
	}
	/* if any creatures are here, they confuse things, too */
	{
	    struct monster *cre;

	    for (cre = orcs; cre->iloc != -1; ++cre) {
		if (cre->dloc == loc) {
		    return S_what;
		}
	    }
	}

	object = loc->atloc.link->who;
	obj = (object - cvobj) + 1000;

    case TRANS TAKE:
	/* taking something
	 *	artifacts get destroyed (this should annoy the usual greedy
			players
	 *	liquids are treated specially, since they are shown as
			properties of places and vessels.
	 *	there are some other interesting side-effects, too!
	 */

	if ((object >= MINART) && (object <= MAXART))
	    BREAKIT;

	if (HERE(DRAGON) && DRAGON->prop)
	    OKAY(203);

	if (object == SHOWER) {
	    pspeak(SHOWER, 1);
	    CRAP->prop = 0;
	    return S_okay;
	}
	if ((object == ROPE)
	    && (TOTING(ROPE) || (ROPE->prop % 2))
	    && HERE(ROPE2)) {
	    obj = _ROPE2;
	    object = ROPE2;
	}
	if (TOTING(object))
	    DEFMSG;

	if (DARK)
	    OKAY(202);

	if ((object == WINE) || (object == COLA) || (object == WATER)) {
	    int k;

	    k = obj;
	    obj = 0;
	    if (AT(BOTTLE) && (LIQ(BOTTLE) == k))
		obj = _BOTTLE;
	    if (AT(CUP) && (LIQ(CUP) == k))
		obj = obj * 100 + _CUP;
	    if (obj > 4000) {
		return S_what;
	    }
	    if (LIQLOC(loc) == k) {
		if (obj) {
		    return S_what;
		}		/* quibble about ambiguity */
		if (TOTING(BOTTLE) && !(BOTTLE->prop))
		    obj = _BOTTLE;
		if (TOTING(CUP) && !(CUP->prop))
		    obj = obj * 100 + _CUP;
		if (obj > 4000) {
		    fputs("Into what?\n", stdout);
		    mltcmd = FALSE;
		    return S_obj;
		}
		if (obj) {
		    object = OBJ(obj);
		    FILLIT(object, k);
		    newcon(object, object->prop + 7, k);
		} else {
		    rspeak(104);/* nothing to put it in */
		}
		return S_okay;
	    }
	    if (!obj)
		OKAY(24);
	    object = OBJ(obj);
	}
	if (holding >= 9)
	    OKAY(92);		/* too many */

	if (object == TOAD) {
	    pspeak(TOAD, 1);	/* all this for fun and games! */
	    destry(TOAD);	/* he oughtta get points just for reading this*/
	    return S_okay;
	}
	if (object == HANG) {
	    pspeak(HANG, HANG->prop + 1);
	    if (HANG->prop == 0) {
		HANG->prop = 2;
		juggle(HANG);
	    }
	    return S_show;
	}
	if ((object == UNICRN) && UNICRN->prop) {
	    pspeak(UNICRN, UNICRN->prop + 2);
	    if (UNICRN->prop != 1)
		return S_okay;
	    destr2(UNICRN);	/* make it not fixed any more */
	    EINHORN->dseen = FALSE;
	    EINHORN->dloc = EINHORN->oloc = DEAD;
	    pspeak(UNICRN, (UNICRN->prop = 0));	/* make it just a collar */
	    return S_okay;
	}
	if (object == BOAT)
	    object->prop += 2;

	/* if the object has a second location, you can't touch it! */
	/* the reason given is it's beyond your power or just ridiculous */
	if (object->conn2.where != LOST)
	    OKAY(IFTREAS(object) ? 146 : 25);

	if ((object == RING) && (JEANNIE->dloc != DEAD)) {
	    if (JEANNIE->dloc != loc)
		OKAY(146);	/* beyond YOUR power (need jinni) */
	    carry(object);
	    JEANNIE->oloc = JEANNIE->dloc = DEAD;
	    JEANNIE->dseen = FALSE;
	    OKAY(209);		/* explain what happened to jinni */
	}
	carry(object);

	if ((object == CROWN) && (HELM->prop))
	    return wakeking();

	if ((object == CHEST) && (SKELTN->prop)) {
	    rspeak(54);		/* okay, but ... */
	    rspeak(96);		/* it DOES have a side effect! */
	    SKELTN->prop = 1;
	    rspeak(101);	/* he always misses the first swing */
	    return S_miss;	/* of course, everything else is just FINE! */
	}
	OKAY(54);

    case INTRANS UNLOC:
	obj = 0;
	if (HERE(HELM) & HELM->prop)
	    obj = _HELM;
	if (AT(DOOR)) {
	    if (obj)
		return S_what;
	    else
		obj = _DOOR;
	}
	if (HERE(CHAIN) && CHAIN->prop) {
	    if (obj)
		return S_what;
	    else
		obj = _CHAIN;
	}
	if (!obj)
	    return S_what;
	object = OBJ(obj);
    case TRANS UNLOC:
	if (object == HELM)
	    return wakeking();
	if (object == BEAR && HERE(CHAIN) && CHAIN->prop == 2) {
	    obj = _CHAIN;
	    object = OBJ(obj);
	}
	if (object == CHAIN) {
	    if (!HERE(KEY))
		OKAY(31);
	    if (CHAIN->prop == 0)
		OKAY(37);
	    CHAIN->prop = 0;
	    destr2(CHAIN);
	    if (!HERE(BEAR) || BEAR->prop <= 2)
		OKAY(54);
	    BEAR->prop -= 2;
	    YOGI->dseen = TRUE;
	    YOGI->dloc = loc;
	    return S_show;
	}
	goto Leave;

    case INTRANS LOCK:
	if (AT(DOOR))
	    obj = _DOOR;
	if (HERE(CHAIN)) {
	    if (obj)
		return S_what;
	    else
		obj = _CHAIN;
	}
	if (!obj)
	    return S_what;
	object = OBJ(obj);
    case TRANS LOCK:
	if (object == CHAIN) {
	    if (!HERE(KEY))
		OKAY(31);
	    if (TOTING(CHAIN))
		move(CHAIN, loc);
	    CHAIN->prop = 1;
	    move2(CHAIN, FIXED);
	    return S_okay;
	}
      Leave:
	if (object == NULL)
	    DEFMSG;
	if (object == DOOR && HERE(KEY)) {
	    if (closing) {
		if (!panic)
		    clock2 = 15;
		panic = TRUE;
		OKAY(130);
	    } else {
		k = 34 + DOOR->prop;
		DOOR->prop = (verb == LOCK) ? 0 : 1;
		OKAY(k + 2 * (DOOR->prop));
	    }
	} else {
	    if (object == DOOR)
		OKAY(31);
	    if (object == KEY)
		OKAY(55);
	    OKAY(33);
	}

    case INTRANS PAY:
	if (loc == O_GATE->conn1.where)
	    object = O_GATE;
	else
	    OKAY(8);
    case TRANS PAY:
	if (object != O_GATE)
	    OKAY(8);
	if (TOTING(RUG) && RUG->prop == 1)
	    OKAY(117);
	if (!HERE(WALLET))
	    OKAY(20);
	if (WALLET->prop > 3)
	    OKAY(21);
	if (O_GATE->prop == 2)
	    OKAY(46);
	if (CRAP->prop)
	    OKAY(113);
	(WALLET->prop)++;
	loc++;
	return S_show;

    case TRANS BREAK:
	if (object <= MINART && object >= MAXART)
	    BREAKIT;
	if (object == MIRROR) {
	    pspeak(object, object->prop + 3);
	    bonus = !(object->prop);
	    finish = TRUE;
	    return S_show;
	} else if (object == DAM) {
	    if (DAM->prop)
		return S_what;
	    BRIDGE->prop = 1;
            DAM->prop = 1;
	    O_GATE->prop = 2;
	    rspeak(41);
	    if (BOAT->prop % 2) {
		move(BOAT, BOATPLC);
		k = BOAT->prop;
		BOAT->prop = 4;
		move2(BOAT, FIXED);
		rspeak(32);
		if (k == 3) {
		    rspeak(45);
		    die();
		}
	    }
	    return S_show;
	} else
	    DEFMSG;

    case INTRANS TEST:
    case TRANS TEST:
	if (object == ROPE) {
	    if (HERE(ROPE) && (ROPE->prop == 4 || ROPE->prop == 6)) {
		ROPE->prop = 6;
		OKAY(54);
	    } else
		OKAY(29);
	}
	if (!HERE(LAMP))
	    DEFMSG;
	printf("%d turns of life left in your lamp batteries.", limit);
	return S_okay;

    case INTRANS CUT:
	object = ROPE;
	if (!HERE(ROPE) && HERE(ROPE2))
	    object = ROPE2;
	else if (!HERE(ROPE) && HERE(EROPE))
	    object = EROPE;
	else if (!HERE(ROPE))
	    return S_what;
    case TRANS CUT:
	if (!HERE(AXE) && !HERE(SWORD))
	    DEFMSG;
	if (object != ROPE && object != ROPE2 && object != EROPE)
	    return S_what;
	k = ROPE->prop > 3 ? 167 : 54;	/* untie it sometimes */
	if (object == EROPE) {
	    if (object->prop < 3)
		OKAY(108);	/* It's gotta be long */
	    ROPE->prop = 3;	/* anchored 60-foot rope */
	    EROPE->prop = 0;	/* end of 60-foot rope */
	    ROPE2->prop = 2;	/* loose 60-foot rope */
	    move(ROPE2, loc);	/* bring it here */
	    destry(EROPE2);
	} else {
	    if (object->prop % 2)
		OKAY(168);	/* not at anchor */
	    if (object->prop == 2)
		OKAY(108);	/* too short */
	    ROPE->prop = 2;
            ROPE2->prop = 2;
	    move(ROPE2, loc);
	}
	rspeak(k);
	return S_show;

    case INTRANS TIE:
	if (HERE(ROPE))
	    object = ROPE;
	if (HERE(ROPE2))
	    object = ROPE2;
	if (HERE(BOAT)) {
	    if (object != NULL)
		return S_what;
	    object = BOAT;
	}
    case TRANS TIE:
	if (object == BOAT) {
	    if (object->prop == 4)
		OKAY(30);
	    if (!(object->prop % 2))
		OKAY(27);
	    object->prop--;
	    OKAY(54);
	}
	if (HERE(ROPE) && HERE(ROPE2) && ROPE->prop == 2) {
	    ROPE->prop = 4;
	    destry(ROPE2);
	    destry(EROPE2);	/* just in case it was rigged */
	    OKAY(54);
	}
	/* NOTE: fall through to RIG when tying complete rope */
    case INTRANS RIG:
    case TRANS RIG:
	object = NULL;
	if (HERE(ROPE) && !(ROPE->prop % 2))
	    object = ROPE;
	else if (HERE(ROPE2) && ROPE2->prop == 2)
	    object = ROPE2;
	else
	    OKAY(205);		/* You have no rope */
	{
	    struct rtr *rtr;
	    struct cvobj *obj2;

	    obj2 = object + 2;	/* EROPE object */
	    k = loc - cvloc;
	    for (rtr = rtrav; rtr->top != -1; rtr++)
		if (k == rtr->top)
		    break;
	    if (rtr->top == -1)
		OKAY(204);	/* nothing to tie it to */
	    if (rtr->mid == 0 && object->prop == 2)
		rspeak(206);	/* It won't reach */
	    object->prop++;	/* tie it */
	    if (TOTING(object))
		move(object, loc);	/* drop it */
	    move2(object, FIXED);	/* fix it */
	    move(obj2, &(cvloc[rtr->mid]));	/* move the end */
	    move2(obj2, FIXED);	/* fix the end */
	    obj2->prop = 0;	/* assume the bottom */
	    if (object == ROPE && !(rtr->bot) && ROPE->prop != 3) {
		if (rtr->mid == DUNGEON) {
		    obj2->prop = 3;	/* show the rest of the rope */
		} else {
		    obj2->prop = 4;	/* show the rest of the rope */
		}
	    }
	    if (rtr->bot && object == ROPE && object->prop != 3) {
		if (rtr->mid) {
		    obj2 = EROPE2;
		    EROPE->prop = (int) (ROPE->prop / 4) + 1;
		} else
		    obj2 = EROPE;
		move(obj2, &(cvloc[rtr->bot]));
		move2(obj2, FIXED);
	    }
	    return S_show;
	}

    case INTRANS UNTIE:
	if (HERE(BOAT)) {
	    if (HERE(ROPE) || HERE(ROPE2))
		return S_what;
	    object = BOAT;
	} else if (HERE(ROPE))
	    object = ROPE;
	else if (HERE(ROPE2))
	    object = ROPE2;
    case TRANS UNTIE:
	if (object == BOAT) {
	    if (object->prop == 4)
		OKAY(30);
	    if (object->prop % 2)
		OKAY(26);
	    object->prop++;
	    OKAY(54);
	}
	if (HERE(ROPE) && (ROPE->prop == 4 || ROPE->prop == 6)) {
	    ROPE->prop = 2;
            ROPE2->prop = 2;
	    move(ROPE2, loc);
	    rspeak(54);
	    return S_show;
	}
	if (HERE(EROPE) && (ROPE->prop > 3) && (EROPE->prop > 2)) {
	    /* dividing a long rope while it's rigged */
	    ROPE->prop = 3;	/* make it short */
	    EROPE->prop = 0;	/* make the end short, too */
	    ROPE2->prop = 2;	/* create a short coil */
	    destry(EROPE2);	/* with no end */
	    move(ROPE2, loc);	/* bring it here */
	    rspeak(54);
	    return S_show;
	}
	/* now try this as an "unrig" */
	if (HERE(ROPE) && (ROPE->prop % 2))
	    object = ROPE;
	else if (HERE(ROPE2) && ROPE2->prop == 3)
	    object = ROPE2;
	else
	    DEFMSG;
	object->prop--;
	destr2(object);
	if (object == ROPE && EROPE->prop)
	    destry(EROPE2);
	destry(object + 2);	/* destroy the end */
	return S_show;

	/* rubbing the helm gets you in trouble (but you gotta do it),
		rubbing the lamp gives you a ribbing, rubbing anything else is
		just useless */
    case TRANS RUB:
	if (object == LAMP)
	    DEFMSG;
	if (object == HELM && HELM->prop)
	    return wakeking();
	OKAY(76);

    case TRANS INVENT:
    case TRANS FIND:
	if (object == UNICRN && UNICRN->prop && HERE(UNICRN))
	    return unicorn();
	if (TOTING(object))
	    OKAY(24);
	if (closed)
	    OKAY(138);
	if (obj == _DWARF) {
	    struct monster *cre;

	    for (cre = MINDWR; cre <= MAXDWR; ++cre) {
		if (cre->dloc == loc && dflag >= 2) {
		    OKAY(94);
		}
	    }
	}
	if (AT(object)
	    || (LIQ(BOTTLE) == obj && AT(BOTTLE))
	    || (LIQLOC(loc) == obj)) {
	    OKAY(94);
	}
    case INTRANS INVENT:
	k = FALSE;
	for (object = cvobj; object->desc != NULL; object++) {
	    if (strlen(object->desc) && TOTING(object)) {
		if (!k) {
		    rspeak(99);
		    k = TRUE;
		}
		blklin = FALSE;
		fputs("  ", stdout);
		putcode(object->desc);
		putchar('\n');
		if ((object == CUP || object == BOTTLE)
		    && object->prop) {
		    pspeak(object, object->prop + 3);
		}
		blklin = TRUE;
	    }
	}
	if (!k)
	    rspeak(98);
	return S_okay;

    case TRANS CALM:
	if (object == UNICRN && UNICRN->prop)
	    return unicorn();
	DEFMSG;

    case INTRANS KILL:
	obj = 0;
	if (ME->dloc == loc)
	    obj = _SELF;
	if (YOGI->dloc == loc) {
	    if (obj)
		return S_what;
	    else
		obj = _BEAR;
	}
	if (!obj) {
	    struct monster *cre;

	    for (cre = orcs; cre->iloc != -1; ++cre) {
		if (cre->dloc == loc)
		    OKAY(49);
	    }
	    OKAY(44);
	}
	object = OBJ(obj);
    case TRANS KILL:
	if (object >= MINART && object <= MAXART)
	    BREAKIT;
	if (object == SELF)
	    return suicide();
	if (object == BEAR)
	    OKAY(165);
	OKAY(49);

    case INTRANS EAT:
	if (HERE(FOOD)) {
	    destry(FOOD);
	    OKAY(72);
	} else {
	    return S_what;
	}

    case TRANS EAT:
	if (object == FOOD) {
	    destry(FOOD);
	    OKAY(72);
	}
	if (object == BEAR
	    || object == SPIDER
	    || object == SELF
	    || object == DRAGON
	    || object == SKELTN
	    || object == BALROG
	    || object == DWARF)
	    OKAY(71);
	DEFMSG;

    case INTRANS DRINK:
	obj = LIQLOC(loc);
	if (HERE(CUP)) {
	    if (obj)
		return S_what;
	    else
		obj = LIQ(CUP);
	}
	if (HERE(BOTTLE)) {
	    if (obj)
		return S_what;
	    else
		obj = LIQ(BOTTLE);
	}
	if (!obj)
	    return S_what;
	object = OBJ(obj);
    case TRANS DRINK:
	if (object != BOTTLE && object != CUP) {
	    k = obj;
	    obj = 0;
	    if (HERE(CUP) && OBJ(LIQ(CUP)) == object)
		obj = _CUP;
	    if (HERE(BOTTLE) && OBJ(LIQ(BOTTLE)) == object) {
		if (obj)
		    OKAY(143);	/* From what? (2 possibilities) */
		obj = _BOTTLE;
	    }
	    if (OBJ(LIQLOC(loc)) == object) {
		if (obj)
		    OKAY(143);	/* From what? (2 possibilities) */
		OKAY(object == WATER ? 73 : 72);
	    }
	    if (!obj)
		OKAY(143);	/* from what? no possibilities */
	}
	object = OBJ(obj);	/* object is now the container */
	if ((k = LIQ(object)) == 0) {
	    pspeak(object, 11);
	    return S_okay;
	}
	rspeak(object == WATER ? 73 : 72);	/* take the drink */
	object->prop = 0;
	newcon(object, 7, k);
	return S_okay;

    case INTRANS SIT:
	if (!HERE(THRONE) || THRONE->prop == 0) {
	    if ((HERE(BOAT) && BOAT->prop / 2 == 1)
		|| (TOTING(RUG) && RUG->prop == 1))
		rspeak(192);
	    else
		DEFMSG;
	    return S_okay;
	}
	k = 0;
	if (HERE(SCEPT))
	    k++;
	if (HERE(CROWN))
	    k++;
	if (HERE(CAPE))
	    k++;
	if (HERE(ORB))
	    k++;
	pspeak(THRONE, 2);
	pspeak(THRONE, k + 3);
	oldlc2 = loc;
	if (k == 0)
	    die();
	if (k != 4)
	    return S_show;
	/* He got it right -- cast him into new universe of adventures */
	THRONE->prop = 0;
	destr2(THRONE);		/* throne is now a treasure */
	newloc = &(cvloc[124]);
	/* start some new monsters */
	JEANNIE->dloc = RING->conn1.where;
	SLASHER->dloc = JEWLRY->conn1.where;
	EINHORN->dloc = RUG->conn1.where;
	return S_move;

    case INTRANS FLY:
	if (!TOTING(RUG))
	    DEFMSG;
	if (RUG->prop)
	    OKAY(154);
	if (loc > &(cvloc[137]))
	    OKAY(136);
	if (loc < &(cvloc[63]))
	    OKAY(136);
	RUG->prop = 1;
	OKAY(54);

    case TRANS WAVE:
	if (!TOTING(object))
	    OKAY(29);
	if (closing)
	    DEFMSG;
	if (object != SCEPT)
	    OKAY(42);
	if (HERE(HELM) && HELM->prop)
	    return wakeking();
	if (ARTHUR->dloc != loc)
	    OKAY(76);
	ARTHUR->dloc = DEAD;
	ARTHUR->dseen = FALSE;
	move(HELM, loc);	/* bring helm here (was destroyed while Arthur
							was walking around */
	destr2(HELM);		/* make it takeable */
	pspeak(HELM, 6);	/* crumble Arthur to dust */
	newloc = loc;
	return S_move;

    case INTRANS BRIEF:
	abbnum = 10000;
	detail = 99;
	OKAY(156);

    case INTRANS READ:
	if (DARK)
	    return S_what;
	if (HERE(SCROLL))
	    object = SCROLL;
	else
	    return S_what;
    case TRANS READ:
	if (DARK)
	    return S_dark;
	if (object != SCROLL)
	    DEFMSG;
	OKAY(126);

    case INTRANS SCORE:
	getscore();
	printf("\nIf you were to quit now (after %d moves), you would \
score %d\nout of a possible %d points.\n", turns, score, mxscore);
	return S_okay;

    case TRANS BLAST:
    case INTRANS BLAST:
	if (!closed)
	    DEFMSG;
	finish = TRUE;
	return S_show;

    case INTRANS ON:
	if (!HERE(LAMP))
	    DEFMSG;
	object = LAMP;
    case TRANS ON:
	dolight(object, 1);
	return S_light;

    case INTRANS OFF:
	if (!HERE(LAMP))
	    DEFMSG;
	object = LAMP;
    case TRANS OFF:
	dolight(object, 0);
	return S_light;

    case INTRANS DESCRB:
    case INTRANS TOUCH:
	if (detail++ < 3)
	    rspeak(15);
	wzdark = FALSE;
	loc->abb = 0;
	newloc = loc;
	return S_move;

    case TRANS TOUCH:
	if (object == TOAD) {
	    pspeak(TOAD, 1);
	    destry(TOAD);
	    return S_okay;
	}
	if (object >= MINART && object <= MAXART)
	    BREAKIT;
	if (object == UNICRN && HERE(object) && object->prop)
	    return unicorn();
	/* fall through to describe */
    case TRANS DESCRB:
	k = vocab(oword, 3);
	if (k > 0)
	    OKAY(k % 1000);
	rspeak(15);
	wzdark = FALSE;
	loc->abb = 0;
	newloc = loc;
	return S_move;

    case INTRANS PLAY:
	if (!HERE(HARP))
	    return S_what;
	object = HARP;
    case TRANS PLAY:
	if (object != HARP)
	    DEFMSG;
	pspeak(object, 1);
	if (UNICRN->prop == 2 && HERE(UNICRN)) {
	    UNICRN->prop = 1;
	    OKAY(222);
	}
	if (UNICRN->prop != -1 && UNICRN->prop != 2)
	    return S_okay;
	if ((loc >= &(cvloc[62]))
	    && (dflag >= 2)
	    && (EINHORN->dloc != DEAD)
	    && (!(EINHORN->dseen))
	    && (!(BADPLC(loc)))) {
	    move(UNICRN, loc);
	    EINHORN->dloc = EINHORN->oloc = loc;
	    EINHORN->dseen = TRUE;
	    rspeak(222);
	}
	return S_okay;

    case INTRANS DROP:
    case INTRANS SAY:
    case INTRANS RUB:
    case INTRANS FIND:
    case INTRANS BREAK:
    case INTRANS THROW:
    case INTRANS WAVE:
    case INTRANS CALM:
    case INTRANS WAKE:
    case TRANS SIT:
	return S_what;

    case INTRANS HELP:
	rspeak(157);
	while (getchar() != '\n');
	rspeak(158);
	return S_okay;

    case INTRANS QUIT:
	if (!(gaveup = yes(22, 54, 54)))
	    return S_okay;
	finish = TRUE;
	return S_show;

    case TRANS QUIT:
    case TRANS SCORE:
    case TRANS SAVE:
    case TRANS RESTOR:
    case TRANS BRIEF:
    case TRANS WALK:
    case TRANS FLY:
    case TRANS WAKE:
    case TRANS HELP:
	DEFMSG;

    case INTRANS NOTHI:
    case TRANS NOTHI:
	OKAY(54);
    }

    fputs("Unknown verb.\n", stdout);
    return S_okay;
}
