import "story/milpreve"

function waterway()
	if not visitedWaterway then
		clearImage()
		text [[Turning yourself sideways, you step through the gap in the bars. It's a mild squeeze, but not uncomfortable.]]
		visitedWaterway = true

		text [[You continue down the passage, following it down a long flight of steps.]]
	end
	image("waterway", "cover")

	clearText()

	text [[You are in an underground waterway. While deserted, you notice the signs of a working dock, with active fuel lines linking the lamps. The ropes appear modern, the pulleys and fixtures are oiled, and paint is worn away from the middle of the boatholds. The water is green and devoid of fish.]]

	if not metMilpreve then
		text [[Along the walkway is a grandiose door, built to last. The carving above it declares it to be "CUSTOMS HOUSE". Light bleeds out from under the door, casting fire onto the wet flagstones.]]
	else
		text [[Light still shows underneath the door to Customs House, indicating Milpreve stays hard at work within.]]
	end

	text [[There is also a staircase that leads down towards the water.]]

	jump "waterway_hub"
end

function waterway_hub()
	if not metMilpreve then
		choice([[Knock on the door of Customs House.]], "milpreve")
	else
		choice([[Visit Milpreve's office.]], "waterway_milpreve")
	end
	choice([[Climb down the steps towards the water.]], "waterway_steps")
	choice([[Go back to the archways.]], "archway")
end

function waterway_steps()
	text [[The steps are slimy with algae and waterweed, but you manage to get to the water level. There is nothing down here of interest.]]

	choice([[Go back.]], "waterway_hub")
end

function waterway_milpreve()
	if haveGargoylePass then
		text [[As you prepare to knock on the door of Customs House, your arm stills and drops limp by your side.]]

		text [[Milpreve already issued you with a Shrine pass. You have no more business with him for the time being, and reminding him of your existence might cause him to rethink your agreement. Better not.]]

		jump "waterway_hub"
	end
	jump "milpreve"
end
