//# 1 ".fablejs.eobjs/jsoo/fablejs.bc.runtime.js"
// Generated by js_of_ocaml
//# buildInfo:effects=false, kind=unknown, use-js-string=true, version=5.7.2
//# 3 ".fablejs.eobjs/jsoo/fablejs.bc.runtime.js"

//# 7 ".fablejs.eobjs/jsoo/fablejs.bc.runtime.js"
(function
  (Object){
   typeof globalThis !== "object"
   &&
    (this
      ? get()
      : (Object.defineProperty
         (Object.prototype, "_T_", {configurable: true, get: get}),
        _T_));
   function get(){
    var global = this || self;
    global.globalThis = global;
    delete Object.prototype._T_;
   }
  }
  (Object));
(function(globalThis){
   "use strict";
   function caml_int64_is_zero(x){return + x.isZero();}
   function caml_str_repeat(n, s){
    if(n == 0) return "";
    if(s.repeat) return s.repeat(n);
    var r = "", l = 0;
    for(;;){
     if(n & 1) r += s;
     n >>= 1;
     if(n == 0) return r;
     s += s;
     l++;
     if(l == 9) s.slice(0, 1);
    }
   }
   var caml_int64_offset = Math.pow(2, - 24);
   function caml_raise_constant(tag){throw tag;}
   var caml_global_data = [0];
   function caml_raise_zero_divide(){
    caml_raise_constant(caml_global_data.Division_by_zero);
   }
   function MlInt64(lo, mi, hi){
    this.lo = lo & 0xffffff;
    this.mi = mi & 0xffffff;
    this.hi = hi & 0xffff;
   }
   MlInt64.prototype.caml_custom = "_j";
   MlInt64.prototype.copy =
    function(){return new MlInt64(this.lo, this.mi, this.hi);};
   MlInt64.prototype.ucompare =
    function(x){
     if(this.hi > x.hi) return 1;
     if(this.hi < x.hi) return - 1;
     if(this.mi > x.mi) return 1;
     if(this.mi < x.mi) return - 1;
     if(this.lo > x.lo) return 1;
     if(this.lo < x.lo) return - 1;
     return 0;
    };
   MlInt64.prototype.compare =
    function(x){
     var hi = this.hi << 16, xhi = x.hi << 16;
     if(hi > xhi) return 1;
     if(hi < xhi) return - 1;
     if(this.mi > x.mi) return 1;
     if(this.mi < x.mi) return - 1;
     if(this.lo > x.lo) return 1;
     if(this.lo < x.lo) return - 1;
     return 0;
    };
   MlInt64.prototype.neg =
    function(){
     var
      lo = - this.lo,
      mi = - this.mi + (lo >> 24),
      hi = - this.hi + (mi >> 24);
     return new MlInt64(lo, mi, hi);
    };
   MlInt64.prototype.add =
    function(x){
     var
      lo = this.lo + x.lo,
      mi = this.mi + x.mi + (lo >> 24),
      hi = this.hi + x.hi + (mi >> 24);
     return new MlInt64(lo, mi, hi);
    };
   MlInt64.prototype.sub =
    function(x){
     var
      lo = this.lo - x.lo,
      mi = this.mi - x.mi + (lo >> 24),
      hi = this.hi - x.hi + (mi >> 24);
     return new MlInt64(lo, mi, hi);
    };
   MlInt64.prototype.mul =
    function(x){
     var
      lo = this.lo * x.lo,
      mi = (lo * caml_int64_offset | 0) + this.mi * x.lo + this.lo * x.mi,
      hi =
        (mi * caml_int64_offset | 0) + this.hi * x.lo + this.mi * x.mi
        + this.lo * x.hi;
     return new MlInt64(lo, mi, hi);
    };
   MlInt64.prototype.isZero =
    function(){return (this.lo | this.mi | this.hi) == 0;};
   MlInt64.prototype.isNeg = function(){return this.hi << 16 < 0;};
   MlInt64.prototype.and =
    function(x){
     return new MlInt64(this.lo & x.lo, this.mi & x.mi, this.hi & x.hi);
    };
   MlInt64.prototype.or =
    function(x){
     return new MlInt64(this.lo | x.lo, this.mi | x.mi, this.hi | x.hi);
    };
   MlInt64.prototype.xor =
    function(x){
     return new MlInt64(this.lo ^ x.lo, this.mi ^ x.mi, this.hi ^ x.hi);
    };
   MlInt64.prototype.shift_left =
    function(s){
     s = s & 63;
     if(s == 0) return this;
     if(s < 24)
      return new
              MlInt64
              (this.lo << s,
               this.mi << s | this.lo >> 24 - s,
               this.hi << s | this.mi >> 24 - s);
     if(s < 48)
      return new
              MlInt64
              (0, this.lo << s - 24, this.mi << s - 24 | this.lo >> 48 - s);
     return new MlInt64(0, 0, this.lo << s - 48);
    };
   MlInt64.prototype.shift_right_unsigned =
    function(s){
     s = s & 63;
     if(s == 0) return this;
     if(s < 24)
      return new
              MlInt64
              (this.lo >> s | this.mi << 24 - s,
               this.mi >> s | this.hi << 24 - s,
               this.hi >> s);
     if(s < 48)
      return new
              MlInt64
              (this.mi >> s - 24 | this.hi << 48 - s, this.hi >> s - 24, 0);
     return new MlInt64(this.hi >> s - 48, 0, 0);
    };
   MlInt64.prototype.shift_right =
    function(s){
     s = s & 63;
     if(s == 0) return this;
     var h = this.hi << 16 >> 16;
     if(s < 24)
      return new
              MlInt64
              (this.lo >> s | this.mi << 24 - s,
               this.mi >> s | h << 24 - s,
               this.hi << 16 >> s >>> 16);
     var sign = this.hi << 16 >> 31;
     if(s < 48)
      return new
              MlInt64
              (this.mi >> s - 24 | this.hi << 48 - s,
               this.hi << 16 >> s - 24 >> 16,
               sign & 0xffff);
     return new MlInt64(this.hi << 16 >> s - 32, sign, sign);
    };
   MlInt64.prototype.lsl1 =
    function(){
     this.hi = this.hi << 1 | this.mi >> 23;
     this.mi = (this.mi << 1 | this.lo >> 23) & 0xffffff;
     this.lo = this.lo << 1 & 0xffffff;
    };
   MlInt64.prototype.lsr1 =
    function(){
     this.lo = (this.lo >>> 1 | this.mi << 23) & 0xffffff;
     this.mi = (this.mi >>> 1 | this.hi << 23) & 0xffffff;
     this.hi = this.hi >>> 1;
    };
   MlInt64.prototype.udivmod =
    function(x){
     var
      offset = 0,
      modulus = this.copy(),
      divisor = x.copy(),
      quotient = new MlInt64(0, 0, 0);
     while(modulus.ucompare(divisor) > 0){offset++; divisor.lsl1();}
     while(offset >= 0){
      offset--;
      quotient.lsl1();
      if(modulus.ucompare(divisor) >= 0){
       quotient.lo++;
       modulus = modulus.sub(divisor);
      }
      divisor.lsr1();
     }
     return {quotient: quotient, modulus: modulus};
    };
   MlInt64.prototype.div =
    function(y){
     var x = this;
     if(y.isZero()) caml_raise_zero_divide();
     var sign = x.hi ^ y.hi;
     if(x.hi & 0x8000) x = x.neg();
     if(y.hi & 0x8000) y = y.neg();
     var q = x.udivmod(y).quotient;
     if(sign & 0x8000) q = q.neg();
     return q;
    };
   MlInt64.prototype.mod =
    function(y){
     var x = this;
     if(y.isZero()) caml_raise_zero_divide();
     var sign = x.hi;
     if(x.hi & 0x8000) x = x.neg();
     if(y.hi & 0x8000) y = y.neg();
     var r = x.udivmod(y).modulus;
     if(sign & 0x8000) r = r.neg();
     return r;
    };
   MlInt64.prototype.toInt = function(){return this.lo | this.mi << 24;};
   MlInt64.prototype.toFloat =
    function(){
     return (this.hi << 16) * Math.pow(2, 32) + this.mi * Math.pow(2, 24)
            + this.lo;
    };
   MlInt64.prototype.toArray =
    function(){
     return [this.hi >> 8,
             this.hi & 0xff,
             this.mi >> 16,
             this.mi >> 8 & 0xff,
             this.mi & 0xff,
             this.lo >> 16,
             this.lo >> 8 & 0xff,
             this.lo & 0xff];
    };
   MlInt64.prototype.lo32 =
    function(){return this.lo | (this.mi & 0xff) << 24;};
   MlInt64.prototype.hi32 =
    function(){return this.mi >>> 8 & 0xffff | this.hi << 16;};
   function caml_int64_of_int32(x){
    return new MlInt64(x & 0xffffff, x >> 24 & 0xffffff, x >> 31 & 0xffff);
   }
   function caml_int64_to_int32(x){return x.toInt();}
   function caml_int64_is_negative(x){return + x.isNeg();}
   function caml_int64_neg(x){return x.neg();}
   function caml_jsbytes_of_string(x){return x;}
   function jsoo_sys_getenv(n){
    var process = globalThis.process;
    if(process && process.env && process.env[n] != undefined)
     return process.env[n];
    if(globalThis.jsoo_static_env && globalThis.jsoo_static_env[n])
     return globalThis.jsoo_static_env[n];
   }
   var caml_record_backtrace_flag = 0;
   (function(){
      var r = jsoo_sys_getenv("OCAMLRUNPARAM");
      if(r !== undefined){
       var l = r.split(",");
       for(var i = 0; i < l.length; i++)
        if(l[i] == "b"){
         caml_record_backtrace_flag = 1;
         break;
        }
        else if(l[i].startsWith("b="))
         caml_record_backtrace_flag = + l[i].slice(2);
        else
         continue;
      }
     }
     ());
   function caml_exn_with_js_backtrace(exn, force){
    if(! exn.js_error || force || exn[0] == 248)
     exn.js_error = new globalThis.Error("Js exception containing backtrace");
    return exn;
   }
   function caml_maybe_attach_backtrace(exn, force){
    return caml_record_backtrace_flag
            ? caml_exn_with_js_backtrace(exn, force)
            : exn;
   }
   function caml_raise_with_arg(tag, arg){
    throw caml_maybe_attach_backtrace([0, tag, arg]);
   }
   function caml_string_of_jsbytes(x){return x;}
   function caml_raise_with_string(tag, msg){
    caml_raise_with_arg(tag, caml_string_of_jsbytes(msg));
   }
   function caml_invalid_argument(msg){
    caml_raise_with_string(caml_global_data.Invalid_argument, msg);
   }
   function caml_parse_format(fmt){
    fmt = caml_jsbytes_of_string(fmt);
    var len = fmt.length;
    if(len > 31) caml_invalid_argument("format_int: format too long");
    var
     f =
       {justify: "+",
        signstyle: "-",
        filler: " ",
        alternate: false,
        base: 0,
        signedconv: false,
        width: 0,
        uppercase: false,
        sign: 1,
        prec: - 1,
        conv: "f"};
    for(var i = 0; i < len; i++){
     var c = fmt.charAt(i);
     switch(c){
       case "-":
        f.justify = "-"; break;
       case "+":
       case " ":
        f.signstyle = c; break;
       case "0":
        f.filler = "0"; break;
       case "#":
        f.alternate = true; break;
       case "1":
       case "2":
       case "3":
       case "4":
       case "5":
       case "6":
       case "7":
       case "8":
       case "9":
        f.width = 0;
        while(c = fmt.charCodeAt(i) - 48, c >= 0 && c <= 9){f.width = f.width * 10 + c; i++;}
        i--;
        break;
       case ".":
        f.prec = 0;
        i++;
        while(c = fmt.charCodeAt(i) - 48, c >= 0 && c <= 9){f.prec = f.prec * 10 + c; i++;}
        i--;
       case "d":
       case "i":
        f.signedconv = true;
       case "u":
        f.base = 10; break;
       case "x":
        f.base = 16; break;
       case "X":
        f.base = 16; f.uppercase = true; break;
       case "o":
        f.base = 8; break;
       case "e":
       case "f":
       case "g":
        f.signedconv = true; f.conv = c; break;
       case "E":
       case "F":
       case "G":
        f.signedconv = true;
        f.uppercase = true;
        f.conv = c.toLowerCase();
        break;
     }
    }
    return f;
   }
   function caml_finish_formatting(f, rawbuffer){
    if(f.uppercase) rawbuffer = rawbuffer.toUpperCase();
    var len = rawbuffer.length;
    if(f.signedconv && (f.sign < 0 || f.signstyle != "-")) len++;
    if(f.alternate){if(f.base == 8) len += 1; if(f.base == 16) len += 2;}
    var buffer = "";
    if(f.justify == "+" && f.filler == " ")
     for(var i = len; i < f.width; i++) buffer += " ";
    if(f.signedconv)
     if(f.sign < 0)
      buffer += "-";
     else if(f.signstyle != "-") buffer += f.signstyle;
    if(f.alternate && f.base == 8) buffer += "0";
    if(f.alternate && f.base == 16) buffer += f.uppercase ? "0X" : "0x";
    if(f.justify == "+" && f.filler == "0")
     for(var i = len; i < f.width; i++) buffer += "0";
    buffer += rawbuffer;
    if(f.justify == "-") for(var i = len; i < f.width; i++) buffer += " ";
    return caml_string_of_jsbytes(buffer);
   }
   function caml_int64_format(fmt, x){
    var f = caml_parse_format(fmt);
    if(f.signedconv && caml_int64_is_negative(x)){f.sign = - 1; x = caml_int64_neg(x);}
    var
     buffer = "",
     wbase = caml_int64_of_int32(f.base),
     cvtbl = "0123456789abcdef";
    do{
     var p = x.udivmod(wbase);
     x = p.quotient;
     buffer = cvtbl.charAt(caml_int64_to_int32(p.modulus)) + buffer;
    }
    while
     (! caml_int64_is_zero(x));
    if(f.prec >= 0){
     f.filler = " ";
     var n = f.prec - buffer.length;
     if(n > 0) buffer = caml_str_repeat(n, "0") + buffer;
    }
    return caml_finish_formatting(f, buffer);
   }
   function caml_expm1_float(x){return Math.expm1(x);}
   function caml_ml_condition_broadcast(t){return 0;}
   function jsoo_is_ascii(s){
    if(s.length < 24){
     for(var i = 0; i < s.length; i++) if(s.charCodeAt(i) > 127) return false;
     return true;
    }
    else
     return ! /[^\x00-\x7f]/.test(s);
   }
   function caml_utf16_of_utf8(s){
    for(var b = "", t = "", c, c1, c2, v, i = 0, l = s.length; i < l; i++){
     c1 = s.charCodeAt(i);
     if(c1 < 0x80){
      for(var j = i + 1; j < l && (c1 = s.charCodeAt(j)) < 0x80; j++) ;
      if(j - i > 512){
       t.substr(0, 1);
       b += t;
       t = "";
       b += s.slice(i, j);
      }
      else
       t += s.slice(i, j);
      if(j == l) break;
      i = j;
     }
     v = 1;
     if(++i < l && ((c2 = s.charCodeAt(i)) & - 64) == 128){
      c = c2 + (c1 << 6);
      if(c1 < 0xe0){
       v = c - 0x3080;
       if(v < 0x80) v = 1;
      }
      else{
       v = 2;
       if(++i < l && ((c2 = s.charCodeAt(i)) & - 64) == 128){
        c = c2 + (c << 6);
        if(c1 < 0xf0){
         v = c - 0xe2080;
         if(v < 0x800 || v >= 0xd7ff && v < 0xe000) v = 2;
        }
        else{
         v = 3;
         if(++i < l && ((c2 = s.charCodeAt(i)) & - 64) == 128 && c1 < 0xf5){
          v = c2 - 0x3c82080 + (c << 6);
          if(v < 0x10000 || v > 0x10ffff) v = 3;
         }
        }
       }
      }
     }
     if(v < 4){
      i -= v;
      t += "\ufffd";
     }
     else if(v > 0xffff)
      t += String.fromCharCode(0xd7c0 + (v >> 10), 0xdc00 + (v & 0x3FF));
     else
      t += String.fromCharCode(v);
     if(t.length > 1024){t.substr(0, 1); b += t; t = "";}
    }
    return b + t;
   }
   function caml_jsstring_of_string(s){
    if(jsoo_is_ascii(s)) return s;
    return caml_utf16_of_utf8(s);
   }
   function fs_node_supported(){
    return typeof globalThis.process !== "undefined"
           && typeof globalThis.process.versions !== "undefined"
           && typeof globalThis.process.versions.node !== "undefined";
   }
   function make_path_is_absolute(){
    function posix(path){
     if(path.charAt(0) === "/") return ["", path.substring(1)];
     return;
    }
    function win32(path){
     var
      splitDeviceRe =
        /^([a-zA-Z]:|[\\/]{2}[^\\/]+[\\/]+[^\\/]+)?([\\/])?([\s\S]*?)$/,
      result = splitDeviceRe.exec(path),
      device = result[1] || "",
      isUnc = Boolean(device && device.charAt(1) !== ":");
     if(Boolean(result[2] || isUnc)){
      var root = result[1] || "", sep = result[2] || "";
      return [root, path.substring(root.length + sep.length)];
     }
     return;
    }
    return fs_node_supported() && globalThis.process
            && globalThis.process.platform
            ? globalThis.process.platform === "win32" ? win32 : posix
            : posix;
   }
   var path_is_absolute = make_path_is_absolute();
   function caml_trailing_slash(name){
    return name.slice(- 1) !== "/" ? name + "/" : name;
   }
   if(fs_node_supported() && globalThis.process && globalThis.process.cwd)
    var caml_current_dir = globalThis.process.cwd().replace(/\\/g, "/");
   else
    var caml_current_dir = "/static";
   caml_current_dir = caml_trailing_slash(caml_current_dir);
   function caml_make_path(name){
    name = caml_jsstring_of_string(name);
    if(! path_is_absolute(name)) name = caml_current_dir + name;
    var
     comp0 = path_is_absolute(name),
     comp = comp0[1].split("/"),
     ncomp = [];
    for(var i = 0; i < comp.length; i++)
     switch(comp[i]){
       case "..":
        if(ncomp.length > 1) ncomp.pop(); break;
       case ".": break;
       case "": break;
       default: ncomp.push(comp[i]); break;
     }
    ncomp.unshift(comp0[0]);
    ncomp.orig = name;
    return ncomp;
   }
   function caml_utf8_of_utf16(s){
    for(var b = "", t = b, c, d, i = 0, l = s.length; i < l; i++){
     c = s.charCodeAt(i);
     if(c < 0x80){
      for(var j = i + 1; j < l && (c = s.charCodeAt(j)) < 0x80; j++) ;
      if(j - i > 512){
       t.substr(0, 1);
       b += t;
       t = "";
       b += s.slice(i, j);
      }
      else
       t += s.slice(i, j);
      if(j == l) break;
      i = j;
     }
     if(c < 0x800){
      t += String.fromCharCode(0xc0 | c >> 6);
      t += String.fromCharCode(0x80 | c & 0x3f);
     }
     else if(c < 0xd800 || c >= 0xdfff)
      t +=
       String.fromCharCode
        (0xe0 | c >> 12, 0x80 | c >> 6 & 0x3f, 0x80 | c & 0x3f);
     else if
      (c >= 0xdbff || i + 1 == l || (d = s.charCodeAt(i + 1)) < 0xdc00
       || d > 0xdfff)
      t += "\xef\xbf\xbd";
     else{
      i++;
      c = (c << 10) + d - 0x35fdc00;
      t +=
       String.fromCharCode
        (0xf0 | c >> 18,
         0x80 | c >> 12 & 0x3f,
         0x80 | c >> 6 & 0x3f,
         0x80 | c & 0x3f);
     }
     if(t.length > 1024){t.substr(0, 1); b += t; t = "";}
    }
    return b + t;
   }
   function caml_string_of_jsstring(s){
    return jsoo_is_ascii(s)
            ? caml_string_of_jsbytes(s)
            : caml_string_of_jsbytes(caml_utf8_of_utf16(s));
   }
   var
    unix_error =
      ["E2BIG",
       "EACCES",
       "EAGAIN",
       "EBADF",
       "EBUSY",
       "ECHILD",
       "EDEADLK",
       "EDOM",
       "EEXIST",
       "EFAULT",
       "EFBIG",
       "EINTR",
       "EINVAL",
       "EIO",
       "EISDIR",
       "EMFILE",
       "EMLINK",
       "ENAMETOOLONG",
       "ENFILE",
       "ENODEV",
       "ENOENT",
       "ENOEXEC",
       "ENOLCK",
       "ENOMEM",
       "ENOSPC",
       "ENOSYS",
       "ENOTDIR",
       "ENOTEMPTY",
       "ENOTTY",
       "ENXIO",
       "EPERM",
       "EPIPE",
       "ERANGE",
       "EROFS",
       "ESPIPE",
       "ESRCH",
       "EXDEV",
       "EWOULDBLOCK",
       "EINPROGRESS",
       "EALREADY",
       "ENOTSOCK",
       "EDESTADDRREQ",
       "EMSGSIZE",
       "EPROTOTYPE",
       "ENOPROTOOPT",
       "EPROTONOSUPPORT",
       "ESOCKTNOSUPPORT",
       "EOPNOTSUPP",
       "EPFNOSUPPORT",
       "EAFNOSUPPORT",
       "EADDRINUSE",
       "EADDRNOTAVAIL",
       "ENETDOWN",
       "ENETUNREACH",
       "ENETRESET",
       "ECONNABORTED",
       "ECONNRESET",
       "ENOBUFS",
       "EISCONN",
       "ENOTCONN",
       "ESHUTDOWN",
       "ETOOMANYREFS",
       "ETIMEDOUT",
       "ECONNREFUSED",
       "EHOSTDOWN",
       "EHOSTUNREACH",
       "ELOOP",
       "EOVERFLOW"];
   function make_unix_err_args(code, syscall, path, errno){
    var variant = unix_error.indexOf(code);
    if(variant < 0){if(errno == null) errno = - 9999; variant = [0, errno];}
    var
     args =
       [variant,
        caml_string_of_jsstring(syscall || ""),
        caml_string_of_jsstring(path || "")];
    return args;
   }
   var caml_named_values = {};
   function caml_named_value(nm){return caml_named_values[nm];}
   function caml_raise_with_args(tag, args){
    throw caml_maybe_attach_backtrace([0, tag].concat(args));
   }
   function caml_subarray_to_jsbytes(a, i, len){
    var f = String.fromCharCode;
    if(i == 0 && len <= 4096 && len == a.length) return f.apply(null, a);
    var s = "";
    for(; 0 < len; i += 1024, len -= 1024)
     s += f.apply(null, a.slice(i, i + Math.min(len, 1024)));
    return s;
   }
   function caml_convert_string_to_bytes(s){
    if(s.t == 2)
     s.c += caml_str_repeat(s.l - s.c.length, "\0");
    else
     s.c = caml_subarray_to_jsbytes(s.c, 0, s.c.length);
    s.t = 0;
   }
   function MlBytes(tag, contents, length){
    this.t = tag;
    this.c = contents;
    this.l = length;
   }
   MlBytes.prototype.toString =
    function(){
     switch(this.t){
       case 9:
        return this.c;
       default: caml_convert_string_to_bytes(this);
       case 0:
        if(jsoo_is_ascii(this.c)){this.t = 9; return this.c;} this.t = 8;
       case 8:
        return this.c;
     }
    };
   MlBytes.prototype.toUtf16 =
    function(){
     var r = this.toString();
     if(this.t == 9) return r;
     return caml_utf16_of_utf8(r);
    };
   MlBytes.prototype.slice =
    function(){
     var content = this.t == 4 ? this.c.slice() : this.c;
     return new MlBytes(this.t, content, this.l);
    };
   function caml_is_ml_bytes(s){return s instanceof MlBytes;}
   function caml_is_ml_string(s){
    return typeof s === "string" && ! /[^\x00-\xff]/.test(s);
   }
   function caml_bytes_of_array(a){
    if(! (a instanceof Uint8Array)) a = new Uint8Array(a);
    return new MlBytes(4, a, a.length);
   }
   function caml_bytes_of_jsbytes(s){return new MlBytes(0, s, s.length);}
   function caml_bytes_of_string(s){
    return caml_bytes_of_jsbytes(caml_jsbytes_of_string(s));
   }
   function caml_raise_sys_error(msg){
    caml_raise_with_string(caml_global_data.Sys_error, msg);
   }
   function caml_raise_no_such_file(name){
    caml_raise_sys_error(name + ": No such file or directory");
   }
   function caml_convert_bytes_to_array(s){
    var a = new Uint8Array(s.l), b = s.c, l = b.length, i = 0;
    for(; i < l; i++) a[i] = b.charCodeAt(i);
    for(l = s.l; i < l; i++) a[i] = 0;
    s.c = a;
    s.t = 4;
    return a;
   }
   function caml_uint8_array_of_bytes(s){
    if(s.t != 4) caml_convert_bytes_to_array(s);
    return s.c;
   }
   function caml_create_bytes(len){
    if(len < 0) caml_invalid_argument("Bytes.create");
    return new MlBytes(len ? 2 : 9, "", len);
   }
   function caml_ml_bytes_length(s){return s.l;}
   function caml_blit_bytes(s1, i1, s2, i2, len){
    if(len == 0) return 0;
    if(i2 == 0 && (len >= s2.l || s2.t == 2 && len >= s2.c.length)){
     s2.c =
      s1.t == 4
       ? caml_subarray_to_jsbytes(s1.c, i1, len)
       : i1 == 0 && s1.c.length == len ? s1.c : s1.c.substr(i1, len);
     s2.t = s2.c.length == s2.l ? 0 : 2;
    }
    else if(s2.t == 2 && i2 == s2.c.length){
     s2.c +=
      s1.t == 4
       ? caml_subarray_to_jsbytes(s1.c, i1, len)
       : i1 == 0 && s1.c.length == len ? s1.c : s1.c.substr(i1, len);
     s2.t = s2.c.length == s2.l ? 0 : 2;
    }
    else{
     if(s2.t != 4) caml_convert_bytes_to_array(s2);
     var c1 = s1.c, c2 = s2.c;
     if(s1.t == 4)
      if(i2 <= i1)
       for(var i = 0; i < len; i++) c2[i2 + i] = c1[i1 + i];
      else
       for(var i = len - 1; i >= 0; i--) c2[i2 + i] = c1[i1 + i];
     else{
      var l = Math.min(len, c1.length - i1);
      for(var i = 0; i < l; i++) c2[i2 + i] = c1.charCodeAt(i1 + i);
      for(; i < len; i++) c2[i2 + i] = 0;
     }
    }
    return 0;
   }
   function MlFile(){}
   function MlFakeFile(content){this.data = content;}
   MlFakeFile.prototype = new MlFile();
   MlFakeFile.prototype.constructor = MlFakeFile;
   MlFakeFile.prototype.truncate =
    function(len){
     var old = this.data;
     this.data = caml_create_bytes(len | 0);
     caml_blit_bytes(old, 0, this.data, 0, len);
    };
   MlFakeFile.prototype.length =
    function(){return caml_ml_bytes_length(this.data);};
   MlFakeFile.prototype.write =
    function(offset, buf, pos, len){
     var clen = this.length();
     if(offset + len >= clen){
      var new_str = caml_create_bytes(offset + len), old_data = this.data;
      this.data = new_str;
      caml_blit_bytes(old_data, 0, this.data, 0, clen);
     }
     caml_blit_bytes(caml_bytes_of_array(buf), pos, this.data, offset, len);
     return 0;
    };
   MlFakeFile.prototype.read =
    function(offset, buf, pos, len){
     var clen = this.length();
     if(offset + len >= clen) len = clen - offset;
     if(len){
      var data = caml_create_bytes(len | 0);
      caml_blit_bytes(this.data, offset, data, 0, len);
      buf.set(caml_uint8_array_of_bytes(data), pos);
     }
     return len;
    };
   function MlFakeFd(name, file, flags){
    this.file = file;
    this.name = name;
    this.flags = flags;
   }
   MlFakeFd.prototype.err_closed =
    function(){
     caml_raise_sys_error(this.name + ": file descriptor already closed");
    };
   MlFakeFd.prototype.length =
    function(){if(this.file) return this.file.length(); this.err_closed();};
   MlFakeFd.prototype.write =
    function(offset, buf, pos, len){
     if(this.file) return this.file.write(offset, buf, pos, len);
     this.err_closed();
    };
   MlFakeFd.prototype.read =
    function(offset, buf, pos, len){
     if(this.file) return this.file.read(offset, buf, pos, len);
     this.err_closed();
    };
   MlFakeFd.prototype.close = function(){this.file = undefined;};
   function MlFakeDevice(root, f){
    this.content = {};
    this.root = root;
    this.lookupFun = f;
   }
   MlFakeDevice.prototype.nm = function(name){return this.root + name;};
   MlFakeDevice.prototype.create_dir_if_needed =
    function(name){
     var comp = name.split("/"), res = "";
     for(var i = 0; i < comp.length - 1; i++){
      res += comp[i] + "/";
      if(this.content[res]) continue;
      this.content[res] = Symbol("directory");
     }
    };
   MlFakeDevice.prototype.slash =
    function(name){return /\/$/.test(name) ? name : name + "/";};
   MlFakeDevice.prototype.lookup =
    function(name){
     if(! this.content[name] && this.lookupFun){
      var
       res =
         this.lookupFun
          (caml_string_of_jsbytes(this.root), caml_string_of_jsbytes(name));
      if(res !== 0){
       this.create_dir_if_needed(name);
       this.content[name] = new MlFakeFile(caml_bytes_of_string(res[1]));
      }
     }
    };
   MlFakeDevice.prototype.exists =
    function(name){
     if(name == "") return 1;
     var name_slash = this.slash(name);
     if(this.content[name_slash]) return 1;
     this.lookup(name);
     return this.content[name] ? 1 : 0;
    };
   MlFakeDevice.prototype.isFile =
    function(name){return this.exists(name) && ! this.is_dir(name) ? 1 : 0;};
   MlFakeDevice.prototype.mkdir =
    function(name, mode, raise_unix){
     var unix_error = raise_unix && caml_named_value("Unix.Unix_error");
     if(this.exists(name))
      if(unix_error)
       caml_raise_with_args
        (unix_error, make_unix_err_args("EEXIST", "mkdir", this.nm(name)));
      else
       caml_raise_sys_error(name + ": File exists");
     var parent = /^(.*)\/[^/]+/.exec(name);
     parent = parent && parent[1] || "";
     if(! this.exists(parent))
      if(unix_error)
       caml_raise_with_args
        (unix_error, make_unix_err_args("ENOENT", "mkdir", this.nm(parent)));
      else
       caml_raise_sys_error(parent + ": No such file or directory");
     if(! this.is_dir(parent))
      if(unix_error)
       caml_raise_with_args
        (unix_error, make_unix_err_args("ENOTDIR", "mkdir", this.nm(parent)));
      else
       caml_raise_sys_error(parent + ": Not a directory");
     this.create_dir_if_needed(this.slash(name));
    };
   MlFakeDevice.prototype.rmdir =
    function(name, raise_unix){
     var
      unix_error = raise_unix && caml_named_value("Unix.Unix_error"),
      name_slash = name == "" ? "" : this.slash(name),
      r = new RegExp("^" + name_slash + "([^/]+)");
     if(! this.exists(name))
      if(unix_error)
       caml_raise_with_args
        (unix_error, make_unix_err_args("ENOENT", "rmdir", this.nm(name)));
      else
       caml_raise_sys_error(name + ": No such file or directory");
     if(! this.is_dir(name))
      if(unix_error)
       caml_raise_with_args
        (unix_error, make_unix_err_args("ENOTDIR", "rmdir", this.nm(name)));
      else
       caml_raise_sys_error(name + ": Not a directory");
     for(var n in this.content)
      if(n.match(r))
       if(unix_error)
        caml_raise_with_args
         (unix_error, make_unix_err_args("ENOTEMPTY", "rmdir", this.nm(name)));
       else
        caml_raise_sys_error(this.nm(name) + ": Directory not empty");
     delete this.content[name_slash];
    };
   MlFakeDevice.prototype.readdir =
    function(name){
     var name_slash = name == "" ? "" : this.slash(name);
     if(! this.exists(name))
      caml_raise_sys_error(name + ": No such file or directory");
     if(! this.is_dir(name)) caml_raise_sys_error(name + ": Not a directory");
     var r = new RegExp("^" + name_slash + "([^/]+)"), seen = {}, a = [];
     for(var n in this.content){
      var m = n.match(r);
      if(m && ! seen[m[1]]){seen[m[1]] = true; a.push(m[1]);}
     }
     return a;
    };
   MlFakeDevice.prototype.opendir =
    function(name, raise_unix){
     var
      unix_error = raise_unix && caml_named_value("Unix.Unix_error"),
      a = this.readdir(name),
      c = false,
      i = 0;
     return {readSync:
             function(){
              if(c)
               if(unix_error)
                caml_raise_with_args
                 (unix_error,
                  make_unix_err_args("EBADF", "closedir", this.nm(name)));
               else
                caml_raise_sys_error(name + ": closedir failed");
              if(i == a.length) return null;
              var entry = a[i];
              i++;
              return {name: entry};
             },
             closeSync:
             function(){
              if(c)
               if(unix_error)
                caml_raise_with_args
                 (unix_error,
                  make_unix_err_args("EBADF", "closedir", this.nm(name)));
               else
                caml_raise_sys_error(name + ": closedir failed");
              c = true;
              a = [];
             }};
    };
   MlFakeDevice.prototype.is_dir =
    function(name){
     if(name == "") return true;
     var name_slash = this.slash(name);
     return this.content[name_slash] ? 1 : 0;
    };
   MlFakeDevice.prototype.unlink =
    function(name){
     var ok = this.content[name] ? true : false;
     delete this.content[name];
     return ok;
    };
   MlFakeDevice.prototype.open =
    function(name, f){
     var file;
     if(f.rdonly && f.wronly)
      caml_raise_sys_error
       (this.nm(name)
        + " : flags Open_rdonly and Open_wronly are not compatible");
     if(f.text && f.binary)
      caml_raise_sys_error
       (this.nm(name)
        + " : flags Open_text and Open_binary are not compatible");
     this.lookup(name);
     if(this.content[name]){
      if(this.is_dir(name))
       caml_raise_sys_error(this.nm(name) + " : is a directory");
      if(f.create && f.excl)
       caml_raise_sys_error(this.nm(name) + " : file already exists");
      file = this.content[name];
      if(f.truncate) file.truncate();
     }
     else if(f.create){
      this.create_dir_if_needed(name);
      this.content[name] = new MlFakeFile(caml_create_bytes(0));
      file = this.content[name];
     }
     else
      caml_raise_no_such_file(this.nm(name));
     return new MlFakeFd(this.nm(name), file, f);
    };
   MlFakeDevice.prototype.open =
    function(name, f){
     var file;
     if(f.rdonly && f.wronly)
      caml_raise_sys_error
       (this.nm(name)
        + " : flags Open_rdonly and Open_wronly are not compatible");
     if(f.text && f.binary)
      caml_raise_sys_error
       (this.nm(name)
        + " : flags Open_text and Open_binary are not compatible");
     this.lookup(name);
     if(this.content[name]){
      if(this.is_dir(name))
       caml_raise_sys_error(this.nm(name) + " : is a directory");
      if(f.create && f.excl)
       caml_raise_sys_error(this.nm(name) + " : file already exists");
      file = this.content[name];
      if(f.truncate) file.truncate();
     }
     else if(f.create){
      this.create_dir_if_needed(name);
      this.content[name] = new MlFakeFile(caml_create_bytes(0));
      file = this.content[name];
     }
     else
      caml_raise_no_such_file(this.nm(name));
     return new MlFakeFd(this.nm(name), file, f);
    };
   MlFakeDevice.prototype.register =
    function(name, content){
     var file;
     if(this.content[name])
      caml_raise_sys_error(this.nm(name) + " : file already exists");
     if(caml_is_ml_bytes(content)) file = new MlFakeFile(content);
     if(caml_is_ml_string(content))
      file = new MlFakeFile(caml_bytes_of_string(content));
     else if(content instanceof Array)
      file = new MlFakeFile(caml_bytes_of_array(content));
     else if(typeof content === "string")
      file = new MlFakeFile(caml_bytes_of_jsbytes(content));
     else if(content.toString){
      var
       bytes =
         caml_bytes_of_string(caml_string_of_jsstring(content.toString()));
      file = new MlFakeFile(bytes);
     }
     if(file){
      this.create_dir_if_needed(name);
      this.content[name] = file;
     }
     else
      caml_raise_sys_error
       (this.nm(name) + " : registering file with invalid content type");
    };
   MlFakeDevice.prototype.constructor = MlFakeDevice;
   function caml_ml_string_length(s){return s.length;}
   function caml_string_unsafe_get(s, i){return s.charCodeAt(i);}
   function caml_uint8_array_of_string(s){
    var l = caml_ml_string_length(s), a = new Uint8Array(l), i = 0;
    for(; i < l; i++) a[i] = caml_string_unsafe_get(s, i);
    return a;
   }
   function caml_bytes_bound_error(){
    caml_invalid_argument("index out of bounds");
   }
   function caml_bytes_unsafe_set(s, i, c){
    c &= 0xff;
    if(s.t != 4){
     if(i == s.c.length){
      s.c += String.fromCharCode(c);
      if(i + 1 == s.l) s.t = 0;
      return 0;
     }
     caml_convert_bytes_to_array(s);
    }
    s.c[i] = c;
    return 0;
   }
   function caml_bytes_set(s, i, c){
    if(i >>> 0 >= s.l) caml_bytes_bound_error();
    return caml_bytes_unsafe_set(s, i, c);
   }
   function MlNodeFd(fd, flags){
    this.fs = require("fs");
    this.fd = fd;
    this.flags = flags;
   }
   MlNodeFd.prototype = new MlFile();
   MlNodeFd.prototype.constructor = MlNodeFd;
   MlNodeFd.prototype.truncate =
    function(len){
     try{this.fs.ftruncateSync(this.fd, len | 0);}
     catch(err){caml_raise_sys_error(err.toString());}
    };
   MlNodeFd.prototype.length =
    function(){
     try{return this.fs.fstatSync(this.fd).size;}
     catch(err){caml_raise_sys_error(err.toString());}
    };
   MlNodeFd.prototype.write =
    function(offset, buf, buf_offset, len){
     try{
      if(this.flags.isCharacterDevice)
       this.fs.writeSync(this.fd, buf, buf_offset, len);
      else
       this.fs.writeSync(this.fd, buf, buf_offset, len, offset);
     }
     catch(err){caml_raise_sys_error(err.toString());}
     return 0;
    };
   MlNodeFd.prototype.read =
    function(offset, a, buf_offset, len){
     try{
      if(this.flags.isCharacterDevice)
       var read = this.fs.readSync(this.fd, a, buf_offset, len);
      else
       var read = this.fs.readSync(this.fd, a, buf_offset, len, offset);
      return read;
     }
     catch(err){caml_raise_sys_error(err.toString());}
    };
   MlNodeFd.prototype.close =
    function(){
     try{this.fs.closeSync(this.fd); return 0;}
     catch(err){caml_raise_sys_error(err.toString());}
    };
   function MlNodeDevice(root){this.fs = require("fs"); this.root = root;}
   MlNodeDevice.prototype.nm = function(name){return this.root + name;};
   MlNodeDevice.prototype.exists =
    function(name){
     try{return this.fs.existsSync(this.nm(name)) ? 1 : 0;}
     catch(err){return 0;}
    };
   MlNodeDevice.prototype.isFile =
    function(name){
     try{return this.fs.statSync(this.nm(name)).isFile() ? 1 : 0;}
     catch(err){caml_raise_sys_error(err.toString());}
    };
   MlNodeDevice.prototype.mkdir =
    function(name, mode, raise_unix){
     try{this.fs.mkdirSync(this.nm(name), {mode: mode}); return 0;}
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.rmdir =
    function(name, raise_unix){
     try{this.fs.rmdirSync(this.nm(name)); return 0;}
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.readdir =
    function(name, raise_unix){
     try{return this.fs.readdirSync(this.nm(name));}
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.is_dir =
    function(name){
     try{return this.fs.statSync(this.nm(name)).isDirectory() ? 1 : 0;}
     catch(err){caml_raise_sys_error(err.toString());}
    };
   MlNodeDevice.prototype.unlink =
    function(name, raise_unix){
     try{
      var b = this.fs.existsSync(this.nm(name)) ? 1 : 0;
      this.fs.unlinkSync(this.nm(name));
      return b;
     }
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.open =
    function(name, f, raise_unix){
     var consts = require("constants"), res = 0;
     for(var key in f)
      switch(key){
        case "rdonly":
         res |= consts.O_RDONLY; break;
        case "wronly":
         res |= consts.O_WRONLY; break;
        case "append":
         res |= consts.O_WRONLY | consts.O_APPEND; break;
        case "create":
         res |= consts.O_CREAT; break;
        case "truncate":
         res |= consts.O_TRUNC; break;
        case "excl":
         res |= consts.O_EXCL; break;
        case "binary":
         res |= consts.O_BINARY; break;
        case "text":
         res |= consts.O_TEXT; break;
        case "nonblock":
         res |= consts.O_NONBLOCK; break;
      }
     try{
      var
       fd = this.fs.openSync(this.nm(name), res),
       isCharacterDevice =
         this.fs.lstatSync(this.nm(name)).isCharacterDevice();
      f.isCharacterDevice = isCharacterDevice;
      return new MlNodeFd(fd, f);
     }
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.rename =
    function(o, n, raise_unix){
     try{this.fs.renameSync(this.nm(o), this.nm(n));}
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.stat =
    function(name, raise_unix){
     try{
      var js_stats = this.fs.statSync(this.nm(name));
      return this.stats_from_js(js_stats);
     }
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.lstat =
    function(name, raise_unix){
     try{
      var js_stats = this.fs.lstatSync(this.nm(name));
      return this.stats_from_js(js_stats);
     }
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.symlink =
    function(to_dir, target, path, raise_unix){
     try{
      this.fs.symlinkSync
       (this.nm(target), this.nm(path), to_dir ? "dir" : "file");
      return 0;
     }
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.readlink =
    function(name, raise_unix){
     try{
      var link = this.fs.readlinkSync(this.nm(name), "utf8");
      return caml_string_of_jsstring(link);
     }
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.opendir =
    function(name, raise_unix){
     try{return this.fs.opendirSync(this.nm(name));}
     catch(err){this.raise_nodejs_error(err, raise_unix);}
    };
   MlNodeDevice.prototype.raise_nodejs_error =
    function(err, raise_unix){
     var unix_error = caml_named_value("Unix.Unix_error");
     if(raise_unix && unix_error){
      var
       args = make_unix_err_args(err.code, err.syscall, err.path, err.errno);
      caml_raise_with_args(unix_error, args);
     }
     else
      caml_raise_sys_error(err.toString());
    };
   MlNodeDevice.prototype.stats_from_js =
    function(js_stats){
     var file_kind;
     if(js_stats.isFile())
      file_kind = 0;
     else if(js_stats.isDirectory())
      file_kind = 1;
     else if(js_stats.isCharacterDevice())
      file_kind = 2;
     else if(js_stats.isBlockDevice())
      file_kind = 3;
     else if(js_stats.isSymbolicLink())
      file_kind = 4;
     else if(js_stats.isFIFO())
      file_kind = 5;
     else if(js_stats.isSocket()) file_kind = 6;
     return [0,
             js_stats.dev,
             js_stats.ino,
             file_kind,
             js_stats.mode,
             js_stats.nlink,
             js_stats.uid,
             js_stats.gid,
             js_stats.rdev,
             js_stats.size,
             js_stats.atimeMs,
             js_stats.mtimeMs,
             js_stats.ctimeMs];
    };
   MlNodeDevice.prototype.constructor = MlNodeDevice;
   function caml_get_root(path){
    var x = path_is_absolute(path);
    if(! x) return;
    return x[0] + "/";
   }
   function caml_failwith(msg){
    if(! caml_global_data.Failure)
     caml_global_data.Failure = [248, caml_string_of_jsbytes("Failure"), - 3];
    caml_raise_with_string(caml_global_data.Failure, msg);
   }
   var
    caml_root =
      caml_get_root(caml_current_dir)
      || caml_failwith("unable to compute caml_root"),
    jsoo_mount_point = [];
   if(fs_node_supported())
    jsoo_mount_point.push
     ({path: caml_root, device: new MlNodeDevice(caml_root)});
   else
    jsoo_mount_point.push
     ({path: caml_root, device: new MlFakeDevice(caml_root)});
   jsoo_mount_point.push
    ({path: "/static/", device: new MlFakeDevice("/static/")});
   function resolve_fs_device(name){
    var
     path = caml_make_path(name),
     name = path.join("/"),
     name_slash = caml_trailing_slash(name),
     res;
    for(var i = 0; i < jsoo_mount_point.length; i++){
     var m = jsoo_mount_point[i];
     if
      (name_slash.search(m.path) == 0
       && (! res || res.path.length < m.path.length))
      res =
       {path: m.path,
        device: m.device,
        rest: name.substring(m.path.length, name.length)};
    }
    if(! res && fs_node_supported()){
     var root = caml_get_root(name);
     if(root && root.match(/^[a-zA-Z]:\/$/)){
      var m = {path: root, device: new MlNodeDevice(root)};
      jsoo_mount_point.push(m);
      res =
       {path: m.path,
        device: m.device,
        rest: name.substring(m.path.length, name.length)};
     }
    }
    if(res) return res;
    caml_raise_sys_error("no device found for " + name_slash);
   }
   function caml_sys_is_directory(name){
    var root = resolve_fs_device(name), a = root.device.is_dir(root.rest);
    return a ? 1 : 0;
   }
   function caml_raise_not_found(){
    caml_raise_constant(caml_global_data.Not_found);
   }
   function caml_sys_getenv(name){
    var r = jsoo_sys_getenv(caml_jsstring_of_string(name));
    if(r === undefined) caml_raise_not_found();
    return caml_string_of_jsstring(r);
   }
   function shift_right_nat(nat1, ofs1, len1, nat2, ofs2, nbits){
    if(nbits == 0){nat2.data[ofs2] = 0; return 0;}
    var wrap = 0;
    for(var i = len1 - 1; i >= 0; i--){
     var a = nat1.data[ofs1 + i] >>> 0;
     nat1.data[ofs1 + i] = a >>> nbits | wrap;
     wrap = a << 32 - nbits;
    }
    nat2.data[ofs2] = wrap;
    return 0;
   }
   var caml_gr_state;
   function caml_gr_state_get(){
    if(caml_gr_state) return caml_gr_state;
    throw caml_maybe_attach_backtrace
           ([0,
             caml_named_value("Graphics.Graphic_failure"),
             caml_string_of_jsbytes("Not initialized")]);
   }
   function caml_gr_point_color(x, y){
    var
     s = caml_gr_state_get(),
     im = s.context.getImageData(x, s.height - y, 1, 1),
     d = im.data;
    return (d[0] << 16) + (d[1] << 8) + d[2];
   }
   function caml_runtime_events_user_resolve(){return 0;}
   var MlObjectTable;
   if(typeof globalThis.Map === "undefined")
    MlObjectTable =
     function(){
       function NaiveLookup(objs){this.objs = objs;}
       NaiveLookup.prototype.get =
        function(v){
         for(var i = 0; i < this.objs.length; i++)
          if(this.objs[i] === v) return i;
        };
       NaiveLookup.prototype.set = function(){};
       return function(){
        this.objs = [];
        this.lookup = new NaiveLookup(this.objs);};
      }
      ();
   else
    MlObjectTable =
     function(){this.objs = []; this.lookup = new globalThis.Map();};
   MlObjectTable.prototype.store =
    function(v){this.lookup.set(v, this.objs.length); this.objs.push(v);};
   MlObjectTable.prototype.recall =
    function(v){
     var i = this.lookup.get(v);
     return i === undefined ? undefined : this.objs.length - i;
    };
   function caml_sys_rename(o, n){
    var o_root = resolve_fs_device(o), n_root = resolve_fs_device(n);
    if(o_root.device != n_root.device)
     caml_failwith("caml_sys_rename: cannot move file between two filesystem");
    if(! o_root.device.rename)
     caml_failwith("caml_sys_rename: no implemented");
    o_root.device.rename(o_root.rest, n_root.rest);
   }
   function caml_log10_float(x){return Math.log10(x);}
   var caml_runtime_warnings = 0;
   function caml_ml_enable_runtime_warnings(bool){caml_runtime_warnings = bool; return 0;
   }
   function caml_classify_float(x){
    if(isFinite(x)){
     if(Math.abs(x) >= 2.2250738585072014e-308) return 0;
     if(x != 0) return 1;
     return 2;
    }
    return isNaN(x) ? 4 : 3;
   }
   var caml_ml_channels = new Array();
   function caml_refill(chan){
    if(chan.refill != null){
     var str = chan.refill(), str_a = caml_uint8_array_of_string(str);
     if(str_a.length == 0)
      chan.refill = null;
     else{
      if(chan.buffer.length < chan.buffer_max + str_a.length){
       var b = new Uint8Array(chan.buffer_max + str_a.length);
       b.set(chan.buffer);
       chan.buffer = b;
      }
      chan.buffer.set(str_a, chan.buffer_max);
      chan.offset += str_a.length;
      chan.buffer_max += str_a.length;
     }
    }
    else{
     var
      nread =
        chan.file.read
         (chan.offset,
          chan.buffer,
          chan.buffer_max,
          chan.buffer.length - chan.buffer_max);
     chan.offset += nread;
     chan.buffer_max += nread;
    }
   }
   function caml_array_bound_error(){
    caml_invalid_argument("index out of bounds");
   }
   function caml_ml_input_scan_line(chanid){
    var chan = caml_ml_channels[chanid], p = chan.buffer_curr;
    do
     if(p >= chan.buffer_max){
      if(chan.buffer_curr > 0){
       chan.buffer.set(chan.buffer.subarray(chan.buffer_curr), 0);
       p -= chan.buffer_curr;
       chan.buffer_max -= chan.buffer_curr;
       chan.buffer_curr = 0;
      }
      if(chan.buffer_max >= chan.buffer.length) return - chan.buffer_max | 0;
      var prev_max = chan.buffer_max;
      caml_refill(chan);
      if(prev_max == chan.buffer_max) return - chan.buffer_max | 0;
     }
    while
     (chan.buffer[p++] != 10);
    return p - chan.buffer_curr | 0;
   }
   function caml_gc_minor(unit){
    if(typeof globalThis.gc == "function") globalThis.gc(true);
    return 0;
   }
   function caml_ml_condition_new(unit){return {condition: 1};}
   function caml_ba_to_typed_array(ba){return ba.data;}
   function caml_ml_input_block(chanid, ba, i, l){
    var
     chan = caml_ml_channels[chanid],
     n = l,
     avail = chan.buffer_max - chan.buffer_curr;
    if(l <= avail){
     ba.set(chan.buffer.subarray(chan.buffer_curr, chan.buffer_curr + l), i);
     chan.buffer_curr += l;
    }
    else if(avail > 0){
     ba.set
      (chan.buffer.subarray(chan.buffer_curr, chan.buffer_curr + avail), i);
     chan.buffer_curr += avail;
     n = avail;
    }
    else{
     chan.buffer_curr = 0;
     chan.buffer_max = 0;
     caml_refill(chan);
     var avail = chan.buffer_max - chan.buffer_curr;
     if(n > avail) n = avail;
     ba.set(chan.buffer.subarray(chan.buffer_curr, chan.buffer_curr + n), i);
     chan.buffer_curr += n;
    }
    return n | 0;
   }
   function caml_ml_input_bigarray(chanid, b, i, l){
    var ba = caml_ba_to_typed_array(b);
    return caml_ml_input_block(chanid, ba, i, l);
   }
   function caml_int64_of_bytes(a){
    return new
            MlInt64
            (a[7] << 0 | a[6] << 8 | a[5] << 16,
             a[4] << 0 | a[3] << 8 | a[2] << 16,
             a[1] << 0 | a[0] << 8);
   }
   function caml_ba_uint8_get64(ba, i0){
    var ofs = ba.offset(i0);
    if(ofs + 7 >= ba.data.length) caml_array_bound_error();
    var
     b1 = ba.get(ofs + 0),
     b2 = ba.get(ofs + 1),
     b3 = ba.get(ofs + 2),
     b4 = ba.get(ofs + 3),
     b5 = ba.get(ofs + 4),
     b6 = ba.get(ofs + 5),
     b7 = ba.get(ofs + 6),
     b8 = ba.get(ofs + 7);
    return caml_int64_of_bytes([b8, b7, b6, b5, b4, b3, b2, b1]);
   }
   function caml_int64_to_bytes(x){return x.toArray();}
   function caml_int64_marshal(writer, v, sizes){
    var b = caml_int64_to_bytes(v);
    for(var i = 0; i < 8; i++) writer.write(8, b[i]);
    sizes[0] = 8;
    sizes[1] = 8;
   }
   function caml_ba_num_dims(ba){return ba.dims.length;}
   function caml_wrap_exception(e){
    {
     if(e instanceof Array) return e;
     var exn;
     if
      (globalThis.RangeError && e instanceof globalThis.RangeError
       && e.message
       && e.message.match(/maximum call stack/i))
      exn = caml_global_data.Stack_overflow;
     else if
      (globalThis.InternalError && e instanceof globalThis.InternalError
       && e.message
       && e.message.match(/too much recursion/i))
      exn = caml_global_data.Stack_overflow;
     else if(e instanceof globalThis.Error && caml_named_value("jsError"))
      exn = [0, caml_named_value("jsError"), e];
     else
      exn = [0, caml_global_data.Failure, caml_string_of_jsstring(String(e))];
     if(e instanceof globalThis.Error) exn.js_error = e;
     return exn;
    }
   }
   function caml_create_file(name, content){
    var root = resolve_fs_device(name);
    if(! root.device.register) caml_failwith("cannot register file");
    root.device.register(root.rest, content);
    return 0;
   }
   function jsoo_create_file(name, content){
    var
     name = caml_string_of_jsbytes(name),
     content = caml_string_of_jsbytes(content);
    return caml_create_file(name, content);
   }
   function caml_fs_init(){
    var tmp = globalThis.caml_fs_tmp;
    if(tmp)
     for(var i = 0; i < tmp.length; i++)
      jsoo_create_file(tmp[i].name, tmp[i].content);
    globalThis.jsoo_create_file = jsoo_create_file;
    globalThis.caml_fs_tmp = [];
    return 0;
   }
   function caml_get_continuation_callstack(){return [0];}
   var caml_parser_trace = 0;
   function caml_set_parser_trace(bool){
    var oldflag = caml_parser_trace;
    caml_parser_trace = bool;
    return oldflag;
   }
   function caml_list_of_js_array(a){
    var l = 0;
    for(var i = a.length - 1; i >= 0; i--){var e = a[i]; l = [0, e, l];}
    return l;
   }
   function caml_mul(a, b){return Math.imul(a, b);}
   function caml_hash_mix_int(h, d){
    d = caml_mul(d, 0xcc9e2d51 | 0);
    d = d << 15 | d >>> 32 - 15;
    d = caml_mul(d, 0x1b873593);
    h ^= d;
    h = h << 13 | h >>> 32 - 13;
    return (h + (h << 2) | 0) + (0xe6546b64 | 0) | 0;
   }
   function num_digits_nat(nat, ofs, len){
    for(var i = len - 1; i >= 0; i--) if(nat.data[ofs + i] != 0) return i + 1;
    return 1;
   }
   function caml_hash_nat(x){
    var len = num_digits_nat(x, 0, x.data.length), h = 0;
    for(var i = 0; i < len; i++) h = caml_hash_mix_int(h, x.data[i]);
    return h;
   }
   function caml_call_gen(f, args){
    var
     n = f.l >= 0 ? f.l : f.l = f.length,
     argsLen = args.length,
     d = n - argsLen;
    if(d == 0)
     return f.apply(null, args);
    else if(d < 0){
     var g = f.apply(null, args.slice(0, n));
     if(typeof g !== "function") return g;
     return caml_call_gen(g, args.slice(n));
    }
    else{
     switch(d){
       case 1:
        {
         var
          g =
            function(x){
             var nargs = new Array(argsLen + 1);
             for(var i = 0; i < argsLen; i++) nargs[i] = args[i];
             nargs[argsLen] = x;
             return f.apply(null, nargs);
            };
         break;
        }
       case 2:
        {
         var
          g =
            function(x, y){
             var nargs = new Array(argsLen + 2);
             for(var i = 0; i < argsLen; i++) nargs[i] = args[i];
             nargs[argsLen] = x;
             nargs[argsLen + 1] = y;
             return f.apply(null, nargs);
            };
         break;
        }
       default:
        var
         g =
           function(){
            var
             extra_args = arguments.length == 0 ? 1 : arguments.length,
             nargs = new Array(args.length + extra_args);
            for(var i = 0; i < args.length; i++) nargs[i] = args[i];
            for(var i = 0; i < arguments.length; i++)
             nargs[args.length + i] = arguments[i];
            return caml_call_gen(f, nargs);
           };
     }
     g.l = d;
     return g;
    }
   }
   var caml_callback = caml_call_gen;
   function caml_js_wrap_callback_arguments(f){
    return function(){
     var len = arguments.length, args = new Array(len);
     for(var i = 0; i < len; i++) args[i] = arguments[i];
     return caml_callback(f, [args]);};
   }
   function caml_sys_chdir(dir){
    var root = resolve_fs_device(dir);
    if(root.device.exists(root.rest)){
     if(root.rest)
      caml_current_dir = caml_trailing_slash(root.path + root.rest);
     else
      caml_current_dir = root.path;
     return 0;
    }
    else
     caml_raise_no_such_file(caml_jsbytes_of_string(dir));
   }
   function caml_obj_update_tag(b, o, n){
    if(b[0] == o){b[0] = n; return 1;}
    return 0;
   }
   function caml_lazy_update_to_forcing(o){
    return o instanceof Array && o[0] == o[0] >>> 0
            && caml_obj_update_tag(o, 246, 244)
            ? 0
            : 1;
   }
   function caml_gc_counters(){return [254, 0, 0, 0];}
   function caml_gr_synchronize(){
    caml_failwith("caml_gr_synchronize not Implemented");
   }
   function caml_unix_closedir(dir_handle){
    try{dir_handle.pointer.closeSync();}
    catch(e){
     var unix_error = caml_named_value("Unix.Unix_error");
     caml_raise_with_args
      (unix_error, make_unix_err_args("EBADF", "closedir", dir_handle.path));
    }
   }
   function caml_unix_opendir(path){
    var root = resolve_fs_device(path);
    if(! root.device.opendir)
     caml_failwith("caml_unix_opendir: not implemented");
    var dir_handle = root.device.opendir(root.rest, true);
    return {pointer: dir_handle, path: path};
   }
   function caml_unix_rewinddir(dir_handle){
    caml_unix_closedir(dir_handle);
    var new_dir_handle = caml_unix_opendir(dir_handle.path);
    dir_handle.pointer = new_dir_handle.pointer;
    return 0;
   }
   function caml_raise_end_of_file(){
    caml_raise_constant(caml_global_data.End_of_file);
   }
   function caml_unix_readdir(dir_handle){
    var entry;
    try{entry = dir_handle.pointer.readSync();}
    catch(e){
     var unix_error = caml_named_value("Unix.Unix_error");
     caml_raise_with_args
      (unix_error, make_unix_err_args("EBADF", "readdir", dir_handle.path));
    }
    if(entry === null)
     caml_raise_end_of_file();
    else
     return caml_string_of_jsstring(entry.name);
   }
   function caml_unix_findfirst(path){
    var path_js = caml_jsstring_of_string(path);
    path_js = path_js.replace(/(^|[\\\/])\*\.\*$/, "");
    path = caml_string_of_jsstring(path_js);
    var
     dir_handle = caml_unix_opendir(path),
     first_entry = caml_unix_readdir(dir_handle);
    return [0, first_entry, dir_handle];
   }
   function caml_is_continuation_tag(t){return t == 245 ? 1 : 0;}
   var log2_ok = Math.log2 && Math.log2(1.1235582092889474E+307) == 1020;
   function jsoo_floor_log2(x){
    if(log2_ok) return Math.floor(Math.log2(x));
    var i = 0;
    if(x == 0) return - Infinity;
    if(x >= 1) while(x >= 2){x /= 2; i++;} else while(x < 1){x *= 2; i--;}
    return i;
   }
   function caml_int32_bits_of_float(x){
    var float32a = new Float32Array(1);
    float32a[0] = x;
    var int32a = new Int32Array(float32a.buffer);
    return int32a[0] | 0;
   }
   function caml_int64_create_lo_mi_hi(lo, mi, hi){return new MlInt64(lo, mi, hi);
   }
   function caml_int64_bits_of_float(x){
    if(! isFinite(x)){
     if(isNaN(x)) return caml_int64_create_lo_mi_hi(1, 0, 0x7ff0);
     return x > 0
             ? caml_int64_create_lo_mi_hi(0, 0, 0x7ff0)
             : caml_int64_create_lo_mi_hi(0, 0, 0xfff0);
    }
    var sign = x == 0 && 1 / x == - Infinity ? 0x8000 : x >= 0 ? 0 : 0x8000;
    if(sign) x = - x;
    var exp = jsoo_floor_log2(x) + 1023;
    if(exp <= 0){
     exp = 0;
     x /= Math.pow(2, - 1026);
    }
    else{
     x /= Math.pow(2, exp - 1027);
     if(x < 16){x *= 2; exp -= 1;}
     if(exp == 0) x /= 2;
    }
    var k = Math.pow(2, 24), r3 = x | 0;
    x = (x - r3) * k;
    var r2 = x | 0;
    x = (x - r2) * k;
    var r1 = x | 0;
    r3 = r3 & 0xf | sign | exp << 4;
    return caml_int64_create_lo_mi_hi(r1, r2, r3);
   }
   function caml_ba_serialize(writer, ba, sz){
    writer.write(32, ba.dims.length);
    writer.write(32, ba.kind | ba.layout << 8);
    if(ba.caml_custom == "_bigarr02")
     for(var i = 0; i < ba.dims.length; i++)
      if(ba.dims[i] < 0xffff)
       writer.write(16, ba.dims[i]);
      else{
       writer.write(16, 0xffff);
       writer.write(32, 0);
       writer.write(32, ba.dims[i]);
      }
    else
     for(var i = 0; i < ba.dims.length; i++) writer.write(32, ba.dims[i]);
    switch(ba.kind){
      case 2:
      case 3:
      case 12:
       for(var i = 0; i < ba.data.length; i++) writer.write(8, ba.data[i]);
       break;
      case 4:
      case 5:
       for(var i = 0; i < ba.data.length; i++) writer.write(16, ba.data[i]);
       break;
      case 6:
       for(var i = 0; i < ba.data.length; i++) writer.write(32, ba.data[i]);
       break;
      case 8:
      case 9:
       writer.write(8, 0);
       for(var i = 0; i < ba.data.length; i++) writer.write(32, ba.data[i]);
       break;
      case 7:
       for(var i = 0; i < ba.data.length / 2; i++){
        var b = caml_int64_to_bytes(ba.get(i));
        for(var j = 0; j < 8; j++) writer.write(8, b[j]);
       }
       break;
      case 1:
       for(var i = 0; i < ba.data.length; i++){
        var b = caml_int64_to_bytes(caml_int64_bits_of_float(ba.get(i)));
        for(var j = 0; j < 8; j++) writer.write(8, b[j]);
       }
       break;
      case 0:
       for(var i = 0; i < ba.data.length; i++){
        var b = caml_int32_bits_of_float(ba.get(i));
        writer.write(32, b);
       }
       break;
      case 10:
       for(var i = 0; i < ba.data.length / 2; i++){
        var j = ba.get(i);
        writer.write(32, caml_int32_bits_of_float(j[1]));
        writer.write(32, caml_int32_bits_of_float(j[2]));
       }
       break;
      case 11:
       for(var i = 0; i < ba.data.length / 2; i++){
        var
         complex = ba.get(i),
         b = caml_int64_to_bytes(caml_int64_bits_of_float(complex[1]));
        for(var j = 0; j < 8; j++) writer.write(8, b[j]);
        var b = caml_int64_to_bytes(caml_int64_bits_of_float(complex[2]));
        for(var j = 0; j < 8; j++) writer.write(8, b[j]);
       }
       break;
    }
    sz[0] = (4 + ba.dims.length) * 4;
    sz[1] = (4 + ba.dims.length) * 8;
   }
   function caml_ba_get_size_per_element(kind){
    switch(kind){case 7:case 10:case 11: return 2;default: return 1;
    }
   }
   function caml_ba_create_buffer(kind, size){
    var view;
    switch(kind){
      case 0:
       view = Float32Array; break;
      case 1:
       view = Float64Array; break;
      case 2:
       view = Int8Array; break;
      case 3:
       view = Uint8Array; break;
      case 4:
       view = Int16Array; break;
      case 5:
       view = Uint16Array; break;
      case 6:
       view = Int32Array; break;
      case 7:
       view = Int32Array; break;
      case 8:
       view = Int32Array; break;
      case 9:
       view = Int32Array; break;
      case 10:
       view = Float32Array; break;
      case 11:
       view = Float64Array; break;
      case 12:
       view = Uint8Array; break;
    }
    if(! view) caml_invalid_argument("Bigarray.create: unsupported kind");
    var data = new view(size * caml_ba_get_size_per_element(kind));
    return data;
   }
   function caml_int32_float_of_bits(x){
    var int32a = new Int32Array(1);
    int32a[0] = x;
    var float32a = new Float32Array(int32a.buffer);
    return float32a[0];
   }
   function caml_int64_float_of_bits(x){
    var lo = x.lo, mi = x.mi, hi = x.hi, exp = (hi & 0x7fff) >> 4;
    if(exp == 2047)
     return (lo | mi | hi & 0xf) == 0
             ? hi & 0x8000 ? - Infinity : Infinity
             : NaN;
    var k = Math.pow(2, - 24), res = (lo * k + mi) * k + (hi & 0xf);
    if(exp > 0){
     res += 16;
     res *= Math.pow(2, exp - 1027);
    }
    else
     res *= Math.pow(2, - 1026);
    if(hi & 0x8000) res = - res;
    return res;
   }
   function caml_ba_get_size(dims){
    var n_dims = dims.length, size = 1;
    for(var i = 0; i < n_dims; i++){
     if(dims[i] < 0)
      caml_invalid_argument("Bigarray.create: negative dimension");
     size = size * dims[i];
    }
    return size;
   }
   function caml_int64_create_lo_hi(lo, hi){
    return new
            MlInt64
            (lo & 0xffffff,
             lo >>> 24 & 0xff | (hi & 0xffff) << 8,
             hi >>> 16 & 0xffff);
   }
   function caml_int64_hi32(v){return v.hi32();}
   function caml_int64_lo32(v){return v.lo32();}
   var caml_ba_custom_name = "_bigarr02";
   function Ml_Bigarray(kind, layout, dims, buffer){
    this.kind = kind;
    this.layout = layout;
    this.dims = dims;
    this.data = buffer;
   }
   Ml_Bigarray.prototype.caml_custom = caml_ba_custom_name;
   Ml_Bigarray.prototype.offset =
    function(arg){
     var ofs = 0;
     if(typeof arg === "number") arg = [arg];
     if(! (arg instanceof Array))
      caml_invalid_argument("bigarray.js: invalid offset");
     if(this.dims.length != arg.length)
      caml_invalid_argument("Bigarray.get/set: bad number of dimensions");
     if(this.layout == 0)
      for(var i = 0; i < this.dims.length; i++){
       if(arg[i] < 0 || arg[i] >= this.dims[i]) caml_array_bound_error();
       ofs = ofs * this.dims[i] + arg[i];
      }
     else
      for(var i = this.dims.length - 1; i >= 0; i--){
       if(arg[i] < 1 || arg[i] > this.dims[i]) caml_array_bound_error();
       ofs = ofs * this.dims[i] + (arg[i] - 1);
      }
     return ofs;
    };
   Ml_Bigarray.prototype.get =
    function(ofs){
     switch(this.kind){
       case 7:
        var l = this.data[ofs * 2 + 0], h = this.data[ofs * 2 + 1];
        return caml_int64_create_lo_hi(l, h);
       case 10:
       case 11:
        var r = this.data[ofs * 2 + 0], i = this.data[ofs * 2 + 1];
        return [254, r, i];
       default: return this.data[ofs];
     }
    };
   Ml_Bigarray.prototype.set =
    function(ofs, v){
     switch(this.kind){
       case 7:
        this.data[ofs * 2 + 0] = caml_int64_lo32(v);
        this.data[ofs * 2 + 1] = caml_int64_hi32(v);
        break;
       case 10:
       case 11:
        this.data[ofs * 2 + 0] = v[1]; this.data[ofs * 2 + 1] = v[2]; break;
       default: this.data[ofs] = v; break;
     }
     return 0;
    };
   Ml_Bigarray.prototype.fill =
    function(v){
     switch(this.kind){
       case 7:
        var a = caml_int64_lo32(v), b = caml_int64_hi32(v);
        if(a == b)
         this.data.fill(a);
        else
         for(var i = 0; i < this.data.length; i++)
          this.data[i] = i % 2 == 0 ? a : b;
        break;
       case 10:
       case 11:
        var im = v[1], re = v[2];
        if(im == re)
         this.data.fill(im);
        else
         for(var i = 0; i < this.data.length; i++)
          this.data[i] = i % 2 == 0 ? im : re;
        break;
       default: this.data.fill(v); break;
     }
    };
   Ml_Bigarray.prototype.compare =
    function(b, total){
     if(this.layout != b.layout || this.kind != b.kind){
      var k1 = this.kind | this.layout << 8, k2 = b.kind | b.layout << 8;
      return k2 - k1;
     }
     if(this.dims.length != b.dims.length)
      return b.dims.length - this.dims.length;
     for(var i = 0; i < this.dims.length; i++)
      if(this.dims[i] != b.dims[i]) return this.dims[i] < b.dims[i] ? - 1 : 1;
     switch(this.kind){
       case 0:
       case 1:
       case 10:
       case 11:
        var x, y;
        for(var i = 0; i < this.data.length; i++){
         x = this.data[i];
         y = b.data[i];
         if(x < y) return - 1;
         if(x > y) return 1;
         if(x != y){
          if(! total) return NaN;
          if(x == x) return 1;
          if(y == y) return - 1;
         }
        }
        break;
       case 7:
        for(var i = 0; i < this.data.length; i += 2){
         if(this.data[i + 1] < b.data[i + 1]) return - 1;
         if(this.data[i + 1] > b.data[i + 1]) return 1;
         if(this.data[i] >>> 0 < b.data[i] >>> 0) return - 1;
         if(this.data[i] >>> 0 > b.data[i] >>> 0) return 1;
        }
        break;
       case 2:
       case 3:
       case 4:
       case 5:
       case 6:
       case 8:
       case 9:
       case 12:
        for(var i = 0; i < this.data.length; i++){
         if(this.data[i] < b.data[i]) return - 1;
         if(this.data[i] > b.data[i]) return 1;
        }
        break;
     }
     return 0;
    };
   function Ml_Bigarray_c_1_1(kind, layout, dims, buffer){
    this.kind = kind;
    this.layout = layout;
    this.dims = dims;
    this.data = buffer;
   }
   Ml_Bigarray_c_1_1.prototype = new Ml_Bigarray();
   Ml_Bigarray_c_1_1.prototype.offset =
    function(arg){
     if(typeof arg !== "number")
      if(arg instanceof Array && arg.length == 1)
       arg = arg[0];
      else
       caml_invalid_argument("Ml_Bigarray_c_1_1.offset");
     if(arg < 0 || arg >= this.dims[0]) caml_array_bound_error();
     return arg;
    };
   Ml_Bigarray_c_1_1.prototype.get = function(ofs){return this.data[ofs];};
   Ml_Bigarray_c_1_1.prototype.set =
    function(ofs, v){this.data[ofs] = v; return 0;};
   Ml_Bigarray_c_1_1.prototype.fill =
    function(v){this.data.fill(v); return 0;};
   function caml_ba_create_unsafe(kind, layout, dims, data){
    var size_per_element = caml_ba_get_size_per_element(kind);
    if(caml_ba_get_size(dims) * size_per_element != data.length)
     caml_invalid_argument("length doesn't match dims");
    if(layout == 0 && dims.length == 1 && size_per_element == 1)
     return new Ml_Bigarray_c_1_1(kind, layout, dims, data);
    return new Ml_Bigarray(kind, layout, dims, data);
   }
   function caml_ba_deserialize(reader, sz, name){
    var num_dims = reader.read32s();
    if(num_dims < 0 || num_dims > 16)
     caml_failwith("input_value: wrong number of bigarray dimensions");
    var
     tag = reader.read32s(),
     kind = tag & 0xff,
     layout = tag >> 8 & 1,
     dims = [];
    if(name == "_bigarr02")
     for(var i = 0; i < num_dims; i++){
      var size_dim = reader.read16u();
      if(size_dim == 0xffff){
       var size_dim_hi = reader.read32u(), size_dim_lo = reader.read32u();
       if(size_dim_hi != 0)
        caml_failwith("input_value: bigarray dimension overflow in 32bit");
       size_dim = size_dim_lo;
      }
      dims.push(size_dim);
     }
    else
     for(var i = 0; i < num_dims; i++) dims.push(reader.read32u());
    var
     size = caml_ba_get_size(dims),
     data = caml_ba_create_buffer(kind, size),
     ba = caml_ba_create_unsafe(kind, layout, dims, data);
    switch(kind){
      case 2:
       for(var i = 0; i < size; i++) data[i] = reader.read8s(); break;
      case 3:
      case 12:
       for(var i = 0; i < size; i++) data[i] = reader.read8u(); break;
      case 4:
       for(var i = 0; i < size; i++) data[i] = reader.read16s(); break;
      case 5:
       for(var i = 0; i < size; i++) data[i] = reader.read16u(); break;
      case 6:
       for(var i = 0; i < size; i++) data[i] = reader.read32s(); break;
      case 8:
      case 9:
       var sixty = reader.read8u();
       if(sixty)
        caml_failwith
         ("input_value: cannot read bigarray with 64-bit OCaml ints");
       for(var i = 0; i < size; i++) data[i] = reader.read32s();
       break;
      case 7:
       var t = new Array(8);
       for(var i = 0; i < size; i++){
        for(var j = 0; j < 8; j++) t[j] = reader.read8u();
        var int64 = caml_int64_of_bytes(t);
        ba.set(i, int64);
       }
       break;
      case 1:
       var t = new Array(8);
       for(var i = 0; i < size; i++){
        for(var j = 0; j < 8; j++) t[j] = reader.read8u();
        var f = caml_int64_float_of_bits(caml_int64_of_bytes(t));
        ba.set(i, f);
       }
       break;
      case 0:
       for(var i = 0; i < size; i++){
        var f = caml_int32_float_of_bits(reader.read32s());
        ba.set(i, f);
       }
       break;
      case 10:
       for(var i = 0; i < size; i++){
        var
         re = caml_int32_float_of_bits(reader.read32s()),
         im = caml_int32_float_of_bits(reader.read32s());
        ba.set(i, [254, re, im]);
       }
       break;
      case 11:
       var t = new Array(8);
       for(var i = 0; i < size; i++){
        for(var j = 0; j < 8; j++) t[j] = reader.read8u();
        var re = caml_int64_float_of_bits(caml_int64_of_bytes(t));
        for(var j = 0; j < 8; j++) t[j] = reader.read8u();
        var im = caml_int64_float_of_bits(caml_int64_of_bytes(t));
        ba.set(i, [254, re, im]);
       }
       break;
    }
    sz[0] = (4 + num_dims) * 4;
    return caml_ba_create_unsafe(kind, layout, dims, data);
   }
   function caml_ba_compare(a, b, total){return a.compare(b, total);}
   function caml_hash_mix_int64(h, v){
    h = caml_hash_mix_int(h, caml_int64_lo32(v));
    h = caml_hash_mix_int(h, caml_int64_hi32(v));
    return h;
   }
   function caml_hash_mix_float(h, v0){
    return caml_hash_mix_int64(h, caml_int64_bits_of_float(v0));
   }
   function caml_ba_hash(ba){
    var num_elts = caml_ba_get_size(ba.dims), h = 0;
    switch(ba.kind){
      case 2:
      case 3:
      case 12:
       if(num_elts > 256) num_elts = 256;
       var w = 0, i = 0;
       for(i = 0; i + 4 <= ba.data.length; i += 4){
        w =
         ba.data[i + 0] | ba.data[i + 1] << 8 | ba.data[i + 2] << 16
         | ba.data[i + 3] << 24;
        h = caml_hash_mix_int(h, w);
       }
       w = 0;
       switch(num_elts & 3){
         case 3:
          w = ba.data[i + 2] << 16;
         case 2:
          w |= ba.data[i + 1] << 8;
         case 1:
          w |= ba.data[i + 0]; h = caml_hash_mix_int(h, w);
       }
       break;
      case 4:
      case 5:
       if(num_elts > 128) num_elts = 128;
       var w = 0, i = 0;
       for(i = 0; i + 2 <= ba.data.length; i += 2){
        w = ba.data[i + 0] | ba.data[i + 1] << 16;
        h = caml_hash_mix_int(h, w);
       }
       if((num_elts & 1) != 0) h = caml_hash_mix_int(h, ba.data[i]);
       break;
      case 6:
       if(num_elts > 64) num_elts = 64;
       for(var i = 0; i < num_elts; i++) h = caml_hash_mix_int(h, ba.data[i]);
       break;
      case 8:
      case 9:
       if(num_elts > 64) num_elts = 64;
       for(var i = 0; i < num_elts; i++) h = caml_hash_mix_int(h, ba.data[i]);
       break;
      case 7:
       if(num_elts > 32) num_elts = 32;
       num_elts *= 2;
       for(var i = 0; i < num_elts; i++) h = caml_hash_mix_int(h, ba.data[i]);
       break;
      case 10:
       num_elts *= 2;
      case 0:
       if(num_elts > 64) num_elts = 64;
       for(var i = 0; i < num_elts; i++)
        h = caml_hash_mix_float(h, ba.data[i]);
       break;
      case 11:
       num_elts *= 2;
      case 1:
       if(num_elts > 32) num_elts = 32;
       for(var i = 0; i < num_elts; i++)
        h = caml_hash_mix_float(h, ba.data[i]);
       break;
    }
    return h;
   }
   function caml_int32_unmarshal(reader, size){size[0] = 4; return reader.read32s();
   }
   function caml_nativeint_unmarshal(reader, size){
    switch(reader.read8u()){
      case 1:
       size[0] = 4; return reader.read32s();
      case 2:
       caml_failwith("input_value: native integer value too large");
      default: caml_failwith("input_value: ill-formed native integer");
    }
   }
   function caml_int64_unmarshal(reader, size){
    var t = new Array(8);
    for(var j = 0; j < 8; j++) t[j] = reader.read8u();
    size[0] = 8;
    return caml_int64_of_bytes(t);
   }
   function caml_int64_compare(x, y, total){return x.compare(y);}
   function caml_int64_hash(v){return v.lo32() ^ v.hi32();}
   var
    caml_custom_ops =
      {"_j":
       {deserialize: caml_int64_unmarshal,
        serialize: caml_int64_marshal,
        fixed_length: 8,
        compare: caml_int64_compare,
        hash: caml_int64_hash},
       "_i": {deserialize: caml_int32_unmarshal, fixed_length: 4},
       "_n": {deserialize: caml_nativeint_unmarshal, fixed_length: 4},
       "_bigarray":
       {deserialize:
        function(reader, sz){
         return caml_ba_deserialize(reader, sz, "_bigarray");
        },
        serialize: caml_ba_serialize,
        compare: caml_ba_compare,
        hash: caml_ba_hash},
       "_bigarr02":
       {deserialize:
        function(reader, sz){
         return caml_ba_deserialize(reader, sz, "_bigarr02");
        },
        serialize: caml_ba_serialize,
        compare: caml_ba_compare,
        hash: caml_ba_hash}};
   function caml_compare_val_get_custom(a){
    return caml_custom_ops[a.caml_custom]
           && caml_custom_ops[a.caml_custom].compare;
   }
   function caml_compare_val_number_custom(num, custom, swap, total){
    var comp = caml_compare_val_get_custom(custom);
    if(comp){
     var x = swap > 0 ? comp(custom, num, total) : comp(num, custom, total);
     if(total && x != x) return swap;
     if(+ x != + x) return + x;
     if((x | 0) != 0) return x | 0;
    }
    return swap;
   }
   function caml_compare_val_tag(a){
    if(typeof a === "number")
     return 1000;
    else if(caml_is_ml_bytes(a))
     return 252;
    else if(caml_is_ml_string(a))
     return 1252;
    else if(a instanceof Array && a[0] === a[0] >>> 0 && a[0] <= 255){var tag = a[0] | 0; return tag == 254 ? 0 : tag;}
    else if(a instanceof String)
     return 12520;
    else if(typeof a == "string")
     return 12520;
    else if(a instanceof Number)
     return 1000;
    else if(a && a.caml_custom)
     return 1255;
    else if(a && a.compare)
     return 1256;
    else if(typeof a == "function")
     return 1247;
    else if(typeof a == "symbol") return 1251;
    return 1001;
   }
   function caml_int_compare(a, b){
    if(a < b) return - 1;
    if(a == b) return 0;
    return 1;
   }
   function caml_string_compare(s1, s2){
    return s1 < s2 ? - 1 : s1 > s2 ? 1 : 0;
   }
   function caml_bytes_compare(s1, s2){
    s1.t & 6 && caml_convert_string_to_bytes(s1);
    s2.t & 6 && caml_convert_string_to_bytes(s2);
    return s1.c < s2.c ? - 1 : s1.c > s2.c ? 1 : 0;
   }
   function caml_compare_val(a, b, total){
    var stack = [];
    for(;;){
     if(! (total && a === b)){
      var tag_a = caml_compare_val_tag(a);
      if(tag_a == 250){a = a[1]; continue;}
      var tag_b = caml_compare_val_tag(b);
      if(tag_b == 250){b = b[1]; continue;}
      if(tag_a !== tag_b){
       if(tag_a == 1000){
        if(tag_b == 1255)
         return caml_compare_val_number_custom(a, b, - 1, total);
        return - 1;
       }
       if(tag_b == 1000){
        if(tag_a == 1255)
         return caml_compare_val_number_custom(b, a, 1, total);
        return 1;
       }
       return tag_a < tag_b ? - 1 : 1;
      }
      switch(tag_a){
        case 247:
         caml_invalid_argument("compare: functional value"); break;
        case 248:
         var x = caml_int_compare(a[2], b[2]); if(x != 0) return x | 0; break;
        case 249:
         caml_invalid_argument("compare: functional value"); break;
        case 250:
         caml_invalid_argument("equal: got Forward_tag, should not happen");
         break;
        case 251:
         caml_invalid_argument("equal: abstract value"); break;
        case 252:
         if(a !== b){
          var x = caml_bytes_compare(a, b);
          if(x != 0) return x | 0;
         }
         break;
        case 253:
         caml_invalid_argument("equal: got Double_tag, should not happen");
         break;
        case 254:
         caml_invalid_argument
          ("equal: got Double_array_tag, should not happen");
         break;
        case 255:
         caml_invalid_argument("equal: got Custom_tag, should not happen");
         break;
        case 1247:
         caml_invalid_argument("compare: functional value"); break;
        case 1255:
         var comp = caml_compare_val_get_custom(a);
         if(comp != caml_compare_val_get_custom(b))
          return a.caml_custom < b.caml_custom ? - 1 : 1;
         if(! comp) caml_invalid_argument("compare: abstract value");
         var x = comp(a, b, total);
         if(x != x) return total ? - 1 : x;
         if(x !== (x | 0)) return - 1;
         if(x != 0) return x | 0;
         break;
        case 1256:
         var x = a.compare(b, total);
         if(x != x) return total ? - 1 : x;
         if(x !== (x | 0)) return - 1;
         if(x != 0) return x | 0;
         break;
        case 1000:
         a = + a;
         b = + b;
         if(a < b) return - 1;
         if(a > b) return 1;
         if(a != b){
          if(! total) return NaN;
          if(a == a) return 1;
          if(b == b) return - 1;
         }
         break;
        case 1001:
         if(a < b) return - 1;
         if(a > b) return 1;
         if(a != b){
          if(! total) return NaN;
          if(a == a) return 1;
          if(b == b) return - 1;
         }
         break;
        case 1251:
         if(a !== b){if(! total) return NaN; return 1;} break;
        case 1252:
         var a = caml_jsbytes_of_string(a), b = caml_jsbytes_of_string(b);
         if(a !== b){if(a < b) return - 1; if(a > b) return 1;}
         break;
        case 12520:
         var a = a.toString(), b = b.toString();
         if(a !== b){if(a < b) return - 1; if(a > b) return 1;}
         break;
        case 246:
        case 254:
        default:
         if(caml_is_continuation_tag(tag_a)){
          caml_invalid_argument("compare: continuation value");
          break;
         }
         if(a.length != b.length) return a.length < b.length ? - 1 : 1;
         if(a.length > 1) stack.push(a, b, 1);
         break;
      }
     }
     if(stack.length == 0) return 0;
     var i = stack.pop();
     b = stack.pop();
     a = stack.pop();
     if(i + 1 < a.length) stack.push(a, b, i + 1);
     a = a[i];
     b = b[i];
    }
   }
   function caml_greaterthan(x, y){
    return + (caml_compare_val(x, y, false) > 0);
   }
   function div_helper(a, b, c){
    var
     x = a * 65536 + (b >>> 16),
     y = Math.floor(x / c) * 65536,
     z = x % c * 65536,
     w = z + (b & 0x0000FFFF);
    return [y + Math.floor(w / c), w % c];
   }
   function div_digit_nat(natq, ofsq, natr, ofsr, nat1, ofs1, len, nat2, ofs2){
    var rem = nat1.data[ofs1 + len - 1] >>> 0;
    for(var i = len - 2; i >= 0; i--){
     var
      x = div_helper(rem, nat1.data[ofs1 + i] >>> 0, nat2.data[ofs2] >>> 0);
     natq.data[ofsq + i] = x[0];
     rem = x[1];
    }
    natr.data[ofsr] = rem;
    return 0;
   }
   function num_leading_zero_bits_in_digit(nat, ofs){
    var a = nat.data[ofs], b = 0;
    if(a & 0xFFFF0000){b += 16; a >>>= 16;}
    if(a & 0xFF00){b += 8; a >>>= 8;}
    if(a & 0xF0){b += 4; a >>>= 4;}
    if(a & 12){b += 2; a >>>= 2;}
    if(a & 2){b += 1; a >>>= 1;}
    if(a & 1) b += 1;
    return 32 - b;
   }
   function shift_left_nat(nat1, ofs1, len1, nat2, ofs2, nbits){
    if(nbits == 0){nat2.data[ofs2] = 0; return 0;}
    var wrap = 0;
    for(var i = 0; i < len1; i++){
     var a = nat1.data[ofs1 + i] >>> 0;
     nat1.data[ofs1 + i] = a << nbits | wrap;
     wrap = a >>> 32 - nbits;
    }
    nat2.data[ofs2] = wrap;
    return 0;
   }
   function MlNat(x){
    this.data = new Int32Array(x);
    this.length = this.data.length + 2;
   }
   MlNat.prototype.caml_custom = "_nat";
   function create_nat(size){
    var arr = new MlNat(size);
    for(var i = 0; i < size; i++) arr.data[i] = - 1;
    return arr;
   }
   function set_to_zero_nat(nat, ofs, len){
    for(var i = 0; i < len; i++) nat.data[ofs + i] = 0;
    return 0;
   }
   function incr_nat(nat, ofs, len, carry_in){
    var carry = carry_in;
    for(var i = 0; i < len; i++){
     var x = (nat.data[ofs + i] >>> 0) + carry;
     nat.data[ofs + i] = x | 0;
     if(x == x >>> 0){carry = 0; break;} else carry = 1;
    }
    return carry;
   }
   function add_nat(nat1, ofs1, len1, nat2, ofs2, len2, carry_in){
    var carry = carry_in;
    for(var i = 0; i < len2; i++){
     var
      x = (nat1.data[ofs1 + i] >>> 0) + (nat2.data[ofs2 + i] >>> 0) + carry;
     nat1.data[ofs1 + i] = x;
     if(x == x >>> 0) carry = 0; else carry = 1;
    }
    return incr_nat(nat1, ofs1 + len2, len1 - len2, carry);
   }
   function nat_of_array(l){return new MlNat(l);}
   function mult_digit_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat3, ofs3){
    var carry = 0, a = nat3.data[ofs3] >>> 0;
    for(var i = 0; i < len2; i++){
     var
      x1 =
        (nat1.data[ofs1 + i] >>> 0)
        + (nat2.data[ofs2 + i] >>> 0) * (a & 0x0000FFFF)
        + carry,
      x2 = (nat2.data[ofs2 + i] >>> 0) * (a >>> 16);
     carry = Math.floor(x2 / 65536);
     var x3 = x1 + x2 % 65536 * 65536;
     nat1.data[ofs1 + i] = x3;
     carry += Math.floor(x3 / 4294967296);
    }
    return len2 < len1 && carry
            ? add_nat
              (nat1, ofs1 + len2, len1 - len2, nat_of_array([carry]), 0, 1, 0)
            : carry;
   }
   function decr_nat(nat, ofs, len, carry_in){
    var borrow = carry_in == 1 ? 0 : 1;
    for(var i = 0; i < len; i++){
     var x = (nat.data[ofs + i] >>> 0) - borrow;
     nat.data[ofs + i] = x;
     if(x >= 0){borrow = 0; break;} else borrow = 1;
    }
    return borrow == 1 ? 0 : 1;
   }
   function sub_nat(nat1, ofs1, len1, nat2, ofs2, len2, carry_in){
    var borrow = carry_in == 1 ? 0 : 1;
    for(var i = 0; i < len2; i++){
     var
      x = (nat1.data[ofs1 + i] >>> 0) - (nat2.data[ofs2 + i] >>> 0) - borrow;
     nat1.data[ofs1 + i] = x;
     if(x >= 0) borrow = 0; else borrow = 1;
    }
    return decr_nat(nat1, ofs1 + len2, len1 - len2, borrow == 1 ? 0 : 1);
   }
   function compare_nat(nat1, ofs1, len1, nat2, ofs2, len2){
    var
     a = num_digits_nat(nat1, ofs1, len1),
     b = num_digits_nat(nat2, ofs2, len2);
    if(a > b) return 1;
    if(a < b) return - 1;
    for(var i = len1 - 1; i >= 0; i--){
     if(nat1.data[ofs1 + i] >>> 0 > nat2.data[ofs2 + i] >>> 0) return 1;
     if(nat1.data[ofs1 + i] >>> 0 < nat2.data[ofs2 + i] >>> 0) return - 1;
    }
    return 0;
   }
   function div_nat(nat1, ofs1, len1, nat2, ofs2, len2){
    if(len2 == 1){
     div_digit_nat(nat1, ofs1 + 1, nat1, ofs1, nat1, ofs1, len1, nat2, ofs2);
     return 0;
    }
    var s = num_leading_zero_bits_in_digit(nat2, ofs2 + len2 - 1);
    shift_left_nat(nat2, ofs2, len2, nat_of_array([0]), 0, s);
    shift_left_nat(nat1, ofs1, len1, nat_of_array([0]), 0, s);
    var d = (nat2.data[ofs2 + len2 - 1] >>> 0) + 1, a = create_nat(len2 + 1);
    for(var i = len1 - 1; i >= len2; i--){
     var
      quo =
        d == 4294967296
         ? nat1.data[ofs1 + i] >>> 0
         : div_helper
            (nat1.data[ofs1 + i] >>> 0, nat1.data[ofs1 + i - 1] >>> 0, d)
           [0];
     set_to_zero_nat(a, 0, len2 + 1);
     mult_digit_nat(a, 0, len2 + 1, nat2, ofs2, len2, nat_of_array([quo]), 0);
     sub_nat(nat1, ofs1 + i - len2, len2 + 1, a, 0, len2 + 1, 1);
     while
     (nat1.data[ofs1 + i] != 0
      || compare_nat(nat1, ofs1 + i - len2, len2, nat2, ofs2, len2) >= 0){
      quo = quo + 1;
      sub_nat(nat1, ofs1 + i - len2, len2 + 1, nat2, ofs2, len2, 1);
     }
     nat1.data[ofs1 + i] = quo;
    }
    shift_right_nat(nat1, ofs1, len2, nat_of_array([0]), 0, s);
    shift_right_nat(nat2, ofs2, len2, nat_of_array([0]), 0, s);
    return 0;
   }
   function caml_ba_blit(src, dst){
    if(dst.dims.length != src.dims.length)
     caml_invalid_argument("Bigarray.blit: dimension mismatch");
    for(var i = 0; i < dst.dims.length; i++)
     if(dst.dims[i] != src.dims[i])
      caml_invalid_argument("Bigarray.blit: dimension mismatch");
    dst.data.set(src.data);
    return 0;
   }
   function is_digit_int(nat, ofs){if(nat.data[ofs] >= 0) return 1; return 0;}
   function caml_int64_div(x, y){return x.div(y);}
   function caml_js_html_entities(s){
    var entity = /^&#?[0-9a-zA-Z]+;$/;
    if(s.match(entity)){
     var str, temp = document.createElement("p");
     temp.innerHTML = s;
     str = temp.textContent || temp.innerText;
     temp = null;
     return str;
    }
    else
     caml_failwith("Invalid entity " + s);
   }
   function caml_string_unsafe_set(s, i, c){
    caml_failwith("caml_string_unsafe_set");
   }
   function caml_int64_of_float(x){
    if(x < 0) x = Math.ceil(x);
    return new
            MlInt64
            (x & 0xffffff,
             Math.floor(x * caml_int64_offset) & 0xffffff,
             Math.floor(x * caml_int64_offset * caml_int64_offset) & 0xffff);
   }
   function caml_ml_channel_size_64(chanid){
    var chan = caml_ml_channels[chanid];
    return caml_int64_of_float(chan.file.length());
   }
   function caml_ba_set_2(ba, i0, i1, v){
    ba.set(ba.offset([i0, i1]), v);
    return 0;
   }
   var
    caml_argv =
      function(){
        var process = globalThis.process, main = "a.out", args = [];
        if(process && process.argv && process.argv.length > 1){
         var argv = process.argv;
         main = argv[1];
         args = argv.slice(2);
        }
        var p = caml_string_of_jsstring(main), args2 = [0, p];
        for(var i = 0; i < args.length; i++)
         args2.push(caml_string_of_jsstring(args[i]));
        return args2;
       }
       (),
    caml_executable_name = caml_argv[1];
   function caml_js_eval_string(s){return eval(caml_jsstring_of_string(s));}
   function serialize_nat(writer, nat, sz){
    var len = nat.data.length;
    writer.write(32, len);
    for(var i = 0; i < len; i++) writer.write(32, nat.data[i]);
    sz[0] = len * 4;
    sz[1] = len * 8;
   }
   function caml_memprof_set(_control){return 0;}
   function caml_sys_exit(code){
    if(globalThis.quit) globalThis.quit(code);
    if(globalThis.process && globalThis.process.exit)
     globalThis.process.exit(code);
    caml_invalid_argument("Function 'exit' not implemented");
   }
   function caml_channel_descriptor(chanid){
    var chan = caml_ml_channels[chanid];
    return chan.fd;
   }
   function caml_js_from_array(a){return a.slice(1);}
   function caml_ba_reshape(ba, vind){
    vind = caml_js_from_array(vind);
    var new_dim = [], num_dims = vind.length;
    if(num_dims < 0 || num_dims > 16)
     caml_invalid_argument("Bigarray.reshape: bad number of dimensions");
    var num_elts = 1;
    for(var i = 0; i < num_dims; i++){
     new_dim[i] = vind[i];
     if(new_dim[i] < 0)
      caml_invalid_argument("Bigarray.reshape: negative dimension");
     num_elts = num_elts * new_dim[i];
    }
    var size = caml_ba_get_size(ba.dims);
    if(num_elts != size)
     caml_invalid_argument("Bigarray.reshape: size mismatch");
    return caml_ba_create_unsafe(ba.kind, ba.layout, new_dim, ba.data);
   }
   var caml_oo_last_id = 0;
   function caml_set_oo_id(b){b[2] = caml_oo_last_id++; return b;}
   function caml_gr_fill_rect(x, y, w, h){
    var s = caml_gr_state_get();
    s.context.fillRect(x, s.height - y, w, - h);
    return 0;
   }
   function caml_bigstring_blit_string_to_ba(str1, pos1, ba2, pos2, len){
    if(12 != ba2.kind)
     caml_invalid_argument("caml_bigstring_blit_string_to_ba: kind mismatch");
    if(len == 0) return 0;
    var ofs2 = ba2.offset(pos2);
    if(pos1 + len > caml_ml_string_length(str1)) caml_array_bound_error();
    if(ofs2 + len > ba2.data.length) caml_array_bound_error();
    var slice = caml_uint8_array_of_string(str1).slice(pos1, pos1 + len);
    ba2.data.set(slice, ofs2);
    return 0;
   }
   function caml_gr_set_window_title(name){
    var s = caml_gr_state_get();
    s.title = name;
    var jsname = caml_jsstring_of_string(name);
    if(s.set_title) s.set_title(jsname);
    return 0;
   }
   function caml_get_global_data(){return caml_global_data;}
   function caml_int64_shift_right_unsigned(x, s){return x.shift_right_unsigned(s);
   }
   function caml_ba_uint8_get16(ba, i0){
    var ofs = ba.offset(i0);
    if(ofs + 1 >= ba.data.length) caml_array_bound_error();
    var b1 = ba.get(ofs), b2 = ba.get(ofs + 1);
    return b1 | b2 << 8;
   }
   function caml_compare(a, b){return caml_compare_val(a, b, true);}
   var
    caml_MD5Transform =
      function(){
        function add(x, y){return x + y | 0;}
        function xx(q, a, b, x, s, t){
         a = add(add(a, q), add(x, t));
         return add(a << s | a >>> 32 - s, b);
        }
        function ff(a, b, c, d, x, s, t){
         return xx(b & c | ~ b & d, a, b, x, s, t);
        }
        function gg(a, b, c, d, x, s, t){
         return xx(b & d | c & ~ d, a, b, x, s, t);
        }
        function hh(a, b, c, d, x, s, t){return xx(b ^ c ^ d, a, b, x, s, t);}
        function ii(a, b, c, d, x, s, t){
         return xx(c ^ (b | ~ d), a, b, x, s, t);
        }
        return function(w, buffer){
         var a = w[0], b = w[1], c = w[2], d = w[3];
         a = ff(a, b, c, d, buffer[0], 7, 0xD76AA478);
         d = ff(d, a, b, c, buffer[1], 12, 0xE8C7B756);
         c = ff(c, d, a, b, buffer[2], 17, 0x242070DB);
         b = ff(b, c, d, a, buffer[3], 22, 0xC1BDCEEE);
         a = ff(a, b, c, d, buffer[4], 7, 0xF57C0FAF);
         d = ff(d, a, b, c, buffer[5], 12, 0x4787C62A);
         c = ff(c, d, a, b, buffer[6], 17, 0xA8304613);
         b = ff(b, c, d, a, buffer[7], 22, 0xFD469501);
         a = ff(a, b, c, d, buffer[8], 7, 0x698098D8);
         d = ff(d, a, b, c, buffer[9], 12, 0x8B44F7AF);
         c = ff(c, d, a, b, buffer[10], 17, 0xFFFF5BB1);
         b = ff(b, c, d, a, buffer[11], 22, 0x895CD7BE);
         a = ff(a, b, c, d, buffer[12], 7, 0x6B901122);
         d = ff(d, a, b, c, buffer[13], 12, 0xFD987193);
         c = ff(c, d, a, b, buffer[14], 17, 0xA679438E);
         b = ff(b, c, d, a, buffer[15], 22, 0x49B40821);
         a = gg(a, b, c, d, buffer[1], 5, 0xF61E2562);
         d = gg(d, a, b, c, buffer[6], 9, 0xC040B340);
         c = gg(c, d, a, b, buffer[11], 14, 0x265E5A51);
         b = gg(b, c, d, a, buffer[0], 20, 0xE9B6C7AA);
         a = gg(a, b, c, d, buffer[5], 5, 0xD62F105D);
         d = gg(d, a, b, c, buffer[10], 9, 0x02441453);
         c = gg(c, d, a, b, buffer[15], 14, 0xD8A1E681);
         b = gg(b, c, d, a, buffer[4], 20, 0xE7D3FBC8);
         a = gg(a, b, c, d, buffer[9], 5, 0x21E1CDE6);
         d = gg(d, a, b, c, buffer[14], 9, 0xC33707D6);
         c = gg(c, d, a, b, buffer[3], 14, 0xF4D50D87);
         b = gg(b, c, d, a, buffer[8], 20, 0x455A14ED);
         a = gg(a, b, c, d, buffer[13], 5, 0xA9E3E905);
         d = gg(d, a, b, c, buffer[2], 9, 0xFCEFA3F8);
         c = gg(c, d, a, b, buffer[7], 14, 0x676F02D9);
         b = gg(b, c, d, a, buffer[12], 20, 0x8D2A4C8A);
         a = hh(a, b, c, d, buffer[5], 4, 0xFFFA3942);
         d = hh(d, a, b, c, buffer[8], 11, 0x8771F681);
         c = hh(c, d, a, b, buffer[11], 16, 0x6D9D6122);
         b = hh(b, c, d, a, buffer[14], 23, 0xFDE5380C);
         a = hh(a, b, c, d, buffer[1], 4, 0xA4BEEA44);
         d = hh(d, a, b, c, buffer[4], 11, 0x4BDECFA9);
         c = hh(c, d, a, b, buffer[7], 16, 0xF6BB4B60);
         b = hh(b, c, d, a, buffer[10], 23, 0xBEBFBC70);
         a = hh(a, b, c, d, buffer[13], 4, 0x289B7EC6);
         d = hh(d, a, b, c, buffer[0], 11, 0xEAA127FA);
         c = hh(c, d, a, b, buffer[3], 16, 0xD4EF3085);
         b = hh(b, c, d, a, buffer[6], 23, 0x04881D05);
         a = hh(a, b, c, d, buffer[9], 4, 0xD9D4D039);
         d = hh(d, a, b, c, buffer[12], 11, 0xE6DB99E5);
         c = hh(c, d, a, b, buffer[15], 16, 0x1FA27CF8);
         b = hh(b, c, d, a, buffer[2], 23, 0xC4AC5665);
         a = ii(a, b, c, d, buffer[0], 6, 0xF4292244);
         d = ii(d, a, b, c, buffer[7], 10, 0x432AFF97);
         c = ii(c, d, a, b, buffer[14], 15, 0xAB9423A7);
         b = ii(b, c, d, a, buffer[5], 21, 0xFC93A039);
         a = ii(a, b, c, d, buffer[12], 6, 0x655B59C3);
         d = ii(d, a, b, c, buffer[3], 10, 0x8F0CCC92);
         c = ii(c, d, a, b, buffer[10], 15, 0xFFEFF47D);
         b = ii(b, c, d, a, buffer[1], 21, 0x85845DD1);
         a = ii(a, b, c, d, buffer[8], 6, 0x6FA87E4F);
         d = ii(d, a, b, c, buffer[15], 10, 0xFE2CE6E0);
         c = ii(c, d, a, b, buffer[6], 15, 0xA3014314);
         b = ii(b, c, d, a, buffer[13], 21, 0x4E0811A1);
         a = ii(a, b, c, d, buffer[4], 6, 0xF7537E82);
         d = ii(d, a, b, c, buffer[11], 10, 0xBD3AF235);
         c = ii(c, d, a, b, buffer[2], 15, 0x2AD7D2BB);
         b = ii(b, c, d, a, buffer[9], 21, 0xEB86D391);
         w[0] = add(a, w[0]);
         w[1] = add(b, w[1]);
         w[2] = add(c, w[2]);
         w[3] = add(d, w[3]);};
       }
       ();
   function caml_MD5Update(ctx, input, input_len){
    var in_buf = ctx.len & 0x3f, input_pos = 0;
    ctx.len += input_len;
    if(in_buf){
     var missing = 64 - in_buf;
     if(input_len < missing){
      ctx.b8.set(input.subarray(0, input_len), in_buf);
      return;
     }
     ctx.b8.set(input.subarray(0, missing), in_buf);
     caml_MD5Transform(ctx.w, ctx.b32);
     input_len -= missing;
     input_pos += missing;
    }
    while(input_len >= 64){
     ctx.b8.set(input.subarray(input_pos, input_pos + 64), 0);
     caml_MD5Transform(ctx.w, ctx.b32);
     input_len -= 64;
     input_pos += 64;
    }
    if(input_len)
     ctx.b8.set(input.subarray(input_pos, input_pos + input_len), 0);
   }
   function caml_runtime_events_read_poll(cursor, callbacks, num){return 0;}
   function caml_fresh_oo_id(){return caml_oo_last_id++;}
   function caml_int64_to_float(x){return x.toFloat();}
   function caml_ba_get_1(ba, i0){return ba.get(ba.offset(i0));}
   function caml_bigstring_memcmp(s1, pos1, s2, pos2, len){
    for(var i = 0; i < len; i++){
     var a = caml_ba_get_1(s1, pos1 + i), b = caml_ba_get_1(s2, pos2 + i);
     if(a < b) return - 1;
     if(a > b) return 1;
    }
    return 0;
   }
   function caml_new_string(s){return caml_string_of_jsbytes(s);}
   function caml_erf_float(x){
    var
     a1 = 0.254829592,
     a2 = - 0.284496736,
     a3 = 1.421413741,
     a4 = - 1.453152027,
     a5 = 1.061405429,
     p = 0.3275911,
     sign = 1;
    if(x < 0) sign = - 1;
    x = Math.abs(x);
    var
     t = 1.0 / (1.0 + p * x),
     y =
       1.0
       -
        ((((a5 * t + a4) * t + a3) * t + a2) * t + a1) * t
        * Math.exp(- (x * x));
    return sign * y;
   }
   function caml_ba_uint8_get32(ba, i0){
    var ofs = ba.offset(i0);
    if(ofs + 3 >= ba.data.length) caml_array_bound_error();
    var
     b1 = ba.get(ofs + 0),
     b2 = ba.get(ofs + 1),
     b3 = ba.get(ofs + 2),
     b4 = ba.get(ofs + 3);
    return b1 << 0 | b2 << 8 | b3 << 16 | b4 << 24;
   }
   function caml_raw_backtrace_length(){return 0;}
   function caml_str_initialize(unit){return 0;}
   function caml_obj_block(tag, size){
    var o = new Array(size + 1);
    o[0] = tag;
    for(var i = 1; i <= size; i++) o[i] = 0;
    return o;
   }
   function caml_gr_clear_graph(){
    var s = caml_gr_state_get();
    s.canvas.width = s.width;
    s.canvas.height = s.height;
    return 0;
   }
   function bigstring_to_array_buffer(bs){return bs.data.buffer;}
   function caml_sys_const_naked_pointers_checked(_unit){return 0;}
   function lxor_digit_nat(nat1, ofs1, nat2, ofs2){nat1.data[ofs1] ^= nat2.data[ofs2]; return 0;
   }
   function caml_obj_add_offset(v, offset){
    caml_failwith("Obj.add_offset is not supported");
   }
   function caml_final_release(){return 0;}
   var caml_marshal_header_size = 16;
   function caml_js_to_array(a){
    var len = a.length, b = new Array(len + 1);
    b[0] = 0;
    for(var i = 0; i < len; i++) b[i + 1] = a[i];
    return b;
   }
   function caml_sys_is_regular_file(name){
    var root = resolve_fs_device(name);
    return root.device.isFile(root.rest);
   }
   function caml_gr_plot(x, y){
    var
     s = caml_gr_state_get(),
     im = s.context.createImageData(1, 1),
     d = im.data,
     color = s.color;
    d[0] = color >> 16 & 0xff;
    d[1] = color >> 8 & 0xff, d[2] = color >> 0 & 0xff;
    d[3] = 0xFF;
    s.x = x;
    s.y = y;
    s.context.putImageData(im, x, s.height - y);
    return 0;
   }
   function caml_bytes_set64(s, i, i64){
    if(i >>> 0 >= s.l - 7) caml_bytes_bound_error();
    var a = caml_int64_to_bytes(i64);
    for(var j = 0; j < 8; j++) caml_bytes_unsafe_set(s, i + 7 - j, a[j]);
    return 0;
   }
   function caml_string_set16(s, i, i16){caml_failwith("caml_string_set16");}
   function caml_int64_bswap(x){
    var y = caml_int64_to_bytes(x);
    return caml_int64_of_bytes
            ([y[7], y[6], y[5], y[4], y[3], y[2], y[1], y[0]]);
   }
   function caml_gc_major(unit){
    if(typeof globalThis.gc == "function") globalThis.gc();
    return 0;
   }
   function caml_lex_array(s){
    s = caml_jsbytes_of_string(s);
    var l = s.length / 2, a = new Array(l);
    for(var i = 0; i < l; i++)
     a[i] = (s.charCodeAt(2 * i) | s.charCodeAt(2 * i + 1) << 8) << 16 >> 16;
    return a;
   }
   function caml_lex_engine(tbl, start_state, lexbuf){
    var
     lex_buffer = 2,
     lex_buffer_len = 3,
     lex_start_pos = 5,
     lex_curr_pos = 6,
     lex_last_pos = 7,
     lex_last_action = 8,
     lex_eof_reached = 9,
     lex_base = 1,
     lex_backtrk = 2,
     lex_default = 3,
     lex_trans = 4,
     lex_check = 5;
    if(! tbl.lex_default){
     tbl.lex_base = caml_lex_array(tbl[lex_base]);
     tbl.lex_backtrk = caml_lex_array(tbl[lex_backtrk]);
     tbl.lex_check = caml_lex_array(tbl[lex_check]);
     tbl.lex_trans = caml_lex_array(tbl[lex_trans]);
     tbl.lex_default = caml_lex_array(tbl[lex_default]);
    }
    var
     c,
     state = start_state,
     buffer = caml_uint8_array_of_bytes(lexbuf[lex_buffer]);
    if(state >= 0){
     lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];
     lexbuf[lex_last_action] = - 1;
    }
    else
     state = - state - 1;
    for(;;){
     var base = tbl.lex_base[state];
     if(base < 0) return - base - 1;
     var backtrk = tbl.lex_backtrk[state];
     if(backtrk >= 0){
      lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];
      lexbuf[lex_last_action] = backtrk;
     }
     if(lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len])
      if(lexbuf[lex_eof_reached] == 0) return - state - 1; else c = 256;
     else{c = buffer[lexbuf[lex_curr_pos]]; lexbuf[lex_curr_pos]++;}
     if(tbl.lex_check[base + c] == state)
      state = tbl.lex_trans[base + c];
     else
      state = tbl.lex_default[state];
     if(state < 0){
      lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];
      if(lexbuf[lex_last_action] == - 1)
       caml_failwith("lexing: empty token");
      else
       return lexbuf[lex_last_action];
     }
     else if(c == 256) lexbuf[lex_eof_reached] = 0;
    }
   }
   function caml_sys_file_exists(name){
    var root = resolve_fs_device(name);
    return root.device.exists(root.rest);
   }
   function caml_convert_raw_backtrace_slot(){
    caml_failwith("caml_convert_raw_backtrace_slot");
   }
   function caml_array_sub(a, i, len){
    var a2 = new Array(len + 1);
    a2[0] = 0;
    for(var i2 = 1, i1 = i + 1; i2 <= len; i2++, i1++) a2[i2] = a[i1];
    return a2;
   }
   function caml_bytes_equal(s1, s2){
    if(s1 === s2) return 1;
    s1.t & 6 && caml_convert_string_to_bytes(s1);
    s2.t & 6 && caml_convert_string_to_bytes(s2);
    return s1.c == s2.c ? 1 : 0;
   }
   function caml_gr_size_x(){var s = caml_gr_state_get(); return s.width;}
   function caml_ml_debug_info_status(){return 0;}
   function caml_atomic_fetch_add(ref, i){
    var old = ref[1];
    ref[1] += i;
    return old;
   }
   var
    os_type =
      globalThis.process && globalThis.process.platform
       && globalThis.process.platform == "win32"
       ? "Cygwin"
       : "Unix";
   function caml_sys_const_ostype_cygwin(){return os_type == "Cygwin" ? 1 : 0;
   }
   function caml_cosh_float(x){return Math.cosh(x);}
   function MlMutex(){this.locked = false;}
   function caml_ml_mutex_new(unit){return new MlMutex();}
   var caml_ephe_key_offset = 3;
   function caml_ephe_check_key(x, i){
    var weak = x[caml_ephe_key_offset + i];
    if(globalThis.WeakRef && weak instanceof globalThis.WeakRef)
     weak = weak.deref();
    return weak === undefined ? 0 : 1;
   }
   function caml_hash_mix_final(h){
    h ^= h >>> 16;
    h = caml_mul(h, 0x85ebca6b | 0);
    h ^= h >>> 13;
    h = caml_mul(h, 0xc2b2ae35 | 0);
    h ^= h >>> 16;
    return h;
   }
   function caml_gr_text_size(txt){
    var
     s = caml_gr_state_get(),
     w = s.context.measureText(caml_jsstring_of_string(txt)).width;
    return [0, w, s.text_size];
   }
   function caml_lex_run_mem(s, i, mem, curr_pos){
    for(;;){
     var dst = s.charCodeAt(i);
     i++;
     if(dst == 0xff) return;
     var src = s.charCodeAt(i);
     i++;
     if(src == 0xff)
      mem[dst + 1] = curr_pos;
     else
      mem[dst + 1] = mem[src + 1];
    }
   }
   function caml_lex_run_tag(s, i, mem){
    for(;;){
     var dst = s.charCodeAt(i);
     i++;
     if(dst == 0xff) return;
     var src = s.charCodeAt(i);
     i++;
     if(src == 0xff) mem[dst + 1] = - 1; else mem[dst + 1] = mem[src + 1];
    }
   }
   function caml_new_lex_engine(tbl, start_state, lexbuf){
    var
     lex_buffer = 2,
     lex_buffer_len = 3,
     lex_start_pos = 5,
     lex_curr_pos = 6,
     lex_last_pos = 7,
     lex_last_action = 8,
     lex_eof_reached = 9,
     lex_mem = 10,
     lex_base = 1,
     lex_backtrk = 2,
     lex_default = 3,
     lex_trans = 4,
     lex_check = 5,
     lex_base_code = 6,
     lex_backtrk_code = 7,
     lex_default_code = 8,
     lex_trans_code = 9,
     lex_check_code = 10,
     lex_code = 11;
    if(! tbl.lex_default){
     tbl.lex_base = caml_lex_array(tbl[lex_base]);
     tbl.lex_backtrk = caml_lex_array(tbl[lex_backtrk]);
     tbl.lex_check = caml_lex_array(tbl[lex_check]);
     tbl.lex_trans = caml_lex_array(tbl[lex_trans]);
     tbl.lex_default = caml_lex_array(tbl[lex_default]);
    }
    if(! tbl.lex_default_code){
     tbl.lex_base_code = caml_lex_array(tbl[lex_base_code]);
     tbl.lex_backtrk_code = caml_lex_array(tbl[lex_backtrk_code]);
     tbl.lex_check_code = caml_lex_array(tbl[lex_check_code]);
     tbl.lex_trans_code = caml_lex_array(tbl[lex_trans_code]);
     tbl.lex_default_code = caml_lex_array(tbl[lex_default_code]);
    }
    if(tbl.lex_code == null)
     tbl.lex_code = caml_jsbytes_of_string(tbl[lex_code]);
    var
     c,
     state = start_state,
     buffer = caml_uint8_array_of_bytes(lexbuf[lex_buffer]);
    if(state >= 0){
     lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];
     lexbuf[lex_last_action] = - 1;
    }
    else
     state = - state - 1;
    for(;;){
     var base = tbl.lex_base[state];
     if(base < 0){
      var pc_off = tbl.lex_base_code[state];
      caml_lex_run_tag(tbl.lex_code, pc_off, lexbuf[lex_mem]);
      return - base - 1;
     }
     var backtrk = tbl.lex_backtrk[state];
     if(backtrk >= 0){
      var pc_off = tbl.lex_backtrk_code[state];
      caml_lex_run_tag(tbl.lex_code, pc_off, lexbuf[lex_mem]);
      lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];
      lexbuf[lex_last_action] = backtrk;
     }
     if(lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len])
      if(lexbuf[lex_eof_reached] == 0) return - state - 1; else c = 256;
     else{c = buffer[lexbuf[lex_curr_pos]]; lexbuf[lex_curr_pos]++;}
     var pstate = state;
     if(tbl.lex_check[base + c] == state)
      state = tbl.lex_trans[base + c];
     else
      state = tbl.lex_default[state];
     if(state < 0){
      lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];
      if(lexbuf[lex_last_action] == - 1)
       caml_failwith("lexing: empty token");
      else
       return lexbuf[lex_last_action];
     }
     else{
      var base_code = tbl.lex_base_code[pstate], pc_off;
      if(tbl.lex_check_code[base_code + c] == pstate)
       pc_off = tbl.lex_trans_code[base_code + c];
      else
       pc_off = tbl.lex_default_code[pstate];
      if(pc_off > 0)
       caml_lex_run_mem
        (tbl.lex_code, pc_off, lexbuf[lex_mem], lexbuf[lex_curr_pos]);
      if(c == 256) lexbuf[lex_eof_reached] = 0;
     }
    }
   }
   function caml_ba_uint8_set64(ba, i0, v){
    var ofs = ba.offset(i0);
    if(ofs + 7 >= ba.data.length) caml_array_bound_error();
    var v = caml_int64_to_bytes(v);
    for(var i = 0; i < 8; i++) ba.set(ofs + i, v[7 - i]);
    return 0;
   }
   function caml_sys_executable_name(a){return caml_executable_name;}
   function caml_lessequal(x, y){
    return + (caml_compare_val(x, y, false) <= 0);
   }
   function caml_acosh_float(x){return Math.acosh(x);}
   function caml_MD5Init(){
    var
     buffer = new ArrayBuffer(64),
     b32 = new Uint32Array(buffer),
     b8 = new Uint8Array(buffer);
    return {len: 0,
            w:
            new Uint32Array([0x67452301, 0xEFCDAB89, 0x98BADCFE, 0x10325476]),
            b32: b32,
            b8: b8};
   }
   function caml_ml_flush(chanid){
    var chan = caml_ml_channels[chanid];
    if(! chan.opened) caml_raise_sys_error("Cannot flush a closed channel");
    if(! chan.buffer || chan.buffer_curr == 0) return 0;
    if(chan.output)
     chan.output(caml_subarray_to_jsbytes(chan.buffer, 0, chan.buffer_curr));
    else
     chan.file.write(chan.offset, chan.buffer, 0, chan.buffer_curr);
    chan.offset += chan.buffer_curr;
    chan.buffer_curr = 0;
    return 0;
   }
   function caml_seek_out(chanid, pos){
    caml_ml_flush(chanid);
    var chan = caml_ml_channels[chanid];
    chan.offset = pos;
    return 0;
   }
   function caml_ml_seek_out_64(chanid, pos){
    var pos = caml_int64_to_float(pos);
    return caml_seek_out(chanid, pos);
   }
   function compare_nat_real(nat1, nat2){
    return compare_nat(nat1, 0, nat1.data.length, nat2, 0, nat2.data.length);
   }
   function caml_gc_set(_control){return 0;}
   function caml_js_get(o, f){return o[f];}
   function caml_unix_isatty(fileDescriptor){
    if(fs_node_supported()){
     var tty = require("tty");
     return tty.isatty(fileDescriptor) ? 1 : 0;
    }
    else
     return 0;
   }
   function caml_ml_set_buffered(chanid, v){
    caml_ml_channels[chanid].buffered = v;
    if(! v) caml_ml_flush(chanid);
    return 0;
   }
   function caml_gc_compaction(){return 0;}
   function caml_ephe_get_key(x, i){
    if(i < 0 || caml_ephe_key_offset + i >= x.length)
     caml_invalid_argument("Weak.get_key");
    var weak = x[caml_ephe_key_offset + i];
    if(globalThis.WeakRef && weak instanceof globalThis.WeakRef)
     weak = weak.deref();
    return weak === undefined ? 0 : [0, weak];
   }
   function caml_unix_localtime(t){
    var
     d = new Date(t * 1000),
     d_num = d.getTime(),
     januaryfirst = new Date(d.getFullYear(), 0, 1).getTime(),
     doy = Math.floor((d_num - januaryfirst) / 86400000),
     jan = new Date(d.getFullYear(), 0, 1),
     jul = new Date(d.getFullYear(), 6, 1),
     stdTimezoneOffset =
       Math.max(jan.getTimezoneOffset(), jul.getTimezoneOffset());
    return [0,
            d.getSeconds(),
            d.getMinutes(),
            d.getHours(),
            d.getDate(),
            d.getMonth(),
            d.getFullYear() - 1900,
            d.getDay(),
            doy,
            d.getTimezoneOffset() < stdTimezoneOffset | 0];
   }
   function caml_unix_mktime(tm){
    var
     d = new Date(tm[6] + 1900, tm[5], tm[4], tm[3], tm[2], tm[1]).getTime(),
     t = Math.floor(d / 1000),
     tm2 = caml_unix_localtime(t);
    return [0, t, tm2];
   }
   function caml_bigstring_blit_bytes_to_ba(str1, pos1, ba2, pos2, len){
    if(12 != ba2.kind)
     caml_invalid_argument("caml_bigstring_blit_string_to_ba: kind mismatch");
    if(len == 0) return 0;
    var ofs2 = ba2.offset(pos2);
    if(pos1 + len > caml_ml_bytes_length(str1)) caml_array_bound_error();
    if(ofs2 + len > ba2.data.length) caml_array_bound_error();
    var slice = caml_uint8_array_of_bytes(str1).slice(pos1, pos1 + len);
    ba2.data.set(slice, ofs2);
    return 0;
   }
   var caml_sys_fds = new Array(3);
   function caml_sys_close(fd){
    var file = caml_sys_fds[fd];
    if(file) file.close();
    delete caml_sys_fds[fd];
    return 0;
   }
   function caml_ml_close_channel(chanid){
    var chan = caml_ml_channels[chanid];
    if(chan.opened){
     chan.opened = false;
     caml_sys_close(chan.fd);
     chan.fd = - 1;
     chan.buffer = new Uint8Array(0);
     chan.buffer_curr = 0;
     chan.buffer_max = 0;
    }
    return 0;
   }
   function caml_atomic_exchange(ref, v){
    var r = ref[1];
    ref[1] = v;
    return r;
   }
   function caml_sys_isatty(_chan){return 0;}
   function is_digit_zero(nat, ofs){
    if(nat.data[ofs] == 0) return 1;
    return 0;
   }
   function caml_unix_lstat(name){
    var root = resolve_fs_device(name);
    if(! root.device.lstat) caml_failwith("caml_unix_lstat: not implemented");
    return root.device.lstat(root.rest, true);
   }
   function caml_unix_lstat_64(name){
    var r = caml_unix_lstat(name);
    r[9] = caml_int64_of_int32(r[9]);
    return r;
   }
   function caml_js_set(o, f, v){o[f] = v; return 0;}
   function caml_array_get(array, index){
    if(index < 0 || index >= array.length - 1) caml_array_bound_error();
    return array[index + 1];
   }
   function caml_continuation_use_noexc(cont){
    var stack = cont[1];
    cont[1] = 0;
    return stack;
   }
   function caml_unix_rmdir(name){
    var root = resolve_fs_device(name);
    if(! root.device.rmdir) caml_failwith("caml_unix_rmdir: not implemented");
    return root.device.rmdir(root.rest, true);
   }
   function caml_log2_float(x){return Math.log2(x);}
   function caml_gc_huge_fallback_count(unit){return 0;}
   function caml_spacetime_only_works_for_native_code(){
    caml_failwith("Spacetime profiling only works for native code");
   }
   function caml_int64_sub(x, y){return x.sub(y);}
   function caml_seek_in(chanid, pos){
    var chan = caml_ml_channels[chanid];
    if(chan.refill != null) caml_raise_sys_error("Illegal seek");
    if
     (pos >= chan.offset - chan.buffer_max && pos <= chan.offset
      && chan.file.flags.binary)
     chan.buffer_curr = chan.buffer_max - (chan.offset - pos);
    else{chan.offset = pos; chan.buffer_curr = 0; chan.buffer_max = 0;}
    return 0;
   }
   function caml_ml_seek_in_64(chanid, pos){
    var pos = caml_int64_to_float(pos);
    return caml_seek_in(chanid, pos);
   }
   var caml_domain_id = 0;
   function caml_ml_mutex_unlock(t){t.locked = false; return 0;}
   var caml_domain_latest_idx = 1;
   function caml_domain_spawn(f, mutex){
    var id = caml_domain_latest_idx++, old = caml_domain_id;
    caml_domain_id = id;
    var res = caml_callback(f, [0]);
    caml_domain_id = old;
    caml_ml_mutex_unlock(mutex);
    return id;
   }
   function caml_unix_mkdir(name, perm){
    var root = resolve_fs_device(name);
    if(! root.device.mkdir) caml_failwith("caml_unix_mkdir: not implemented");
    return root.device.mkdir(root.rest, perm, true);
   }
   function caml_int64_shift_left(x, s){return x.shift_left(s);}
   function caml_notequal(x, y){
    return + (caml_compare_val(x, y, false) != 0);
   }
   function caml_sys_const_int_size(){return 32;}
   function caml_js_wrap_callback(f){
    return function(){
     var len = arguments.length;
     if(len > 0){
      var args = new Array(len);
      for(var i = 0; i < len; i++) args[i] = arguments[i];
     }
     else
      args = [undefined];
     var res = caml_callback(f, args);
     return res instanceof Function ? caml_js_wrap_callback(res) : res;};
   }
   function caml_js_wrap_meth_callback(f){
    return function(){
     var len = arguments.length, args = new Array(len + 1);
     args[0] = this;
     for(var i = 0; i < len; i++) args[i + 1] = arguments[i];
     var res = caml_callback(f, args);
     return res instanceof Function ? caml_js_wrap_callback(res) : res;};
   }
   function caml_is_js(){return 1;}
   function caml_lazy_update_to_forward(o){
    caml_obj_update_tag(o, 244, 250);
    return 0;
   }
   function caml_ba_dim(ba, i){
    if(i < 0 || i >= ba.dims.length) caml_invalid_argument("Bigarray.dim");
    return ba.dims[i];
   }
   function caml_ba_dim_1(ba){return caml_ba_dim(ba, 0);}
   function caml_js_meth_call(o, f, args){
    return o[caml_jsstring_of_string(f)].apply(o, caml_js_from_array(args));
   }
   var caml_ephe_data_offset = 2;
   function caml_weak_create(n){
    if(n < 0) caml_invalid_argument("Weak.create");
    var x = [251, "caml_ephe_list_head"];
    x.length = caml_ephe_key_offset + n;
    return x;
   }
   function caml_ephe_create(n){var x = caml_weak_create(n); return x;}
   function caml_js_to_byte_string(s){return caml_string_of_jsbytes(s);}
   function caml_trampoline(res){
    var c = 1;
    while(res && res.joo_tramp){
     res = res.joo_tramp.apply(null, res.joo_args);
     c++;
    }
    return res;
   }
   function caml_maybe_print_stats(unit){return 0;}
   function caml_bytes_unsafe_get(s, i){
    switch(s.t & 6){
      default: if(i >= s.c.length) return 0;
      case 0:
       return s.c.charCodeAt(i);
      case 4:
       return s.c[i];
    }
   }
   function caml_bytes_get64(s, i){
    if(i >>> 0 >= s.l - 7) caml_bytes_bound_error();
    var a = new Array(8);
    for(var j = 0; j < 8; j++) a[7 - j] = caml_bytes_unsafe_get(s, i + j);
    return caml_int64_of_bytes(a);
   }
   var caml_custom_event_index = 0;
   function caml_runtime_events_user_register
   (event_name, event_tag, event_type){
    caml_custom_event_index += 1;
    return [0, caml_custom_event_index, event_name, event_type, event_tag];
   }
   function caml_unix_has_symlink(unit){return fs_node_supported() ? 1 : 0;}
   function caml_ephe_set_key(x, i, v){
    if(i < 0 || caml_ephe_key_offset + i >= x.length)
     caml_invalid_argument("Weak.set");
    if(v instanceof Object && globalThis.WeakRef){
     if(x[1].register) x[1].register(v, undefined, v);
     x[caml_ephe_key_offset + i] = new globalThis.WeakRef(v);
    }
    else
     x[caml_ephe_key_offset + i] = v;
    return 0;
   }
   function caml_ephe_unset_key(x, i){
    if(i < 0 || caml_ephe_key_offset + i >= x.length)
     caml_invalid_argument("Weak.set");
    if
     (globalThis.WeakRef
      && x[caml_ephe_key_offset + i] instanceof globalThis.WeakRef
      && x[1].unregister){
     var old = x[caml_ephe_key_offset + i].deref();
     if(old !== undefined){
      var count = 0;
      for(var j = caml_ephe_key_offset; j < x.length; j++){
       var key = x[j];
       if(key instanceof globalThis.WeakRef){
        key = key.deref();
        if(key === old) count++;
       }
      }
      if(count == 1) x[1].unregister(old);
     }
    }
    x[caml_ephe_key_offset + i] = undefined;
    return 0;
   }
   function caml_weak_set(x, i, v){
    if(v == 0) caml_ephe_unset_key(x, i); else caml_ephe_set_key(x, i, v[1]);
    return 0;
   }
   function caml_sys_remove(name){
    var root = resolve_fs_device(name), ok = root.device.unlink(root.rest);
    if(ok == 0) caml_raise_no_such_file(caml_jsbytes_of_string(name));
    return 0;
   }
   function caml_string_bound_error(){
    caml_invalid_argument("index out of bounds");
   }
   function caml_string_get32(s, i){
    if(i >>> 0 >= caml_ml_string_length(s) - 3) caml_string_bound_error();
    var
     b1 = caml_string_unsafe_get(s, i),
     b2 = caml_string_unsafe_get(s, i + 1),
     b3 = caml_string_unsafe_get(s, i + 2),
     b4 = caml_string_unsafe_get(s, i + 3);
    return b4 << 24 | b3 << 16 | b2 << 8 | b1;
   }
   function caml_bytes_get(s, i){
    if(i >>> 0 >= s.l) caml_bytes_bound_error();
    return caml_bytes_unsafe_get(s, i);
   }
   function caml_hypot_float(x, y){return Math.hypot(x, y);}
   function caml_js_call(f, o, args){
    return f.apply(o, caml_js_from_array(args));
   }
   function caml_sys_const_max_wosize(){return 0x7FFFFFFF / 4 | 0;}
   function caml_unix_inet_addr_of_string(){return 0;}
   function caml_hash_mix_bytes_arr(h, s){
    var len = s.length, i, w;
    for(i = 0; i + 4 <= len; i += 4){
     w = s[i] | s[i + 1] << 8 | s[i + 2] << 16 | s[i + 3] << 24;
     h = caml_hash_mix_int(h, w);
    }
    w = 0;
    switch(len & 3){
      case 3:
       w = s[i + 2] << 16;
      case 2:
       w |= s[i + 1] << 8;
      case 1:
       w |= s[i]; h = caml_hash_mix_int(h, w);
    }
    h ^= len;
    return h;
   }
   function caml_hash_mix_jsbytes(h, s){
    var len = s.length, i, w;
    for(i = 0; i + 4 <= len; i += 4){
     w =
      s.charCodeAt(i) | s.charCodeAt(i + 1) << 8 | s.charCodeAt(i + 2) << 16
      | s.charCodeAt(i + 3) << 24;
     h = caml_hash_mix_int(h, w);
    }
    w = 0;
    switch(len & 3){
      case 3:
       w = s.charCodeAt(i + 2) << 16;
      case 2:
       w |= s.charCodeAt(i + 1) << 8;
      case 1:
       w |= s.charCodeAt(i); h = caml_hash_mix_int(h, w);
    }
    h ^= len;
    return h;
   }
   function caml_ml_bytes_content(s){
    switch(s.t & 6){
      default: caml_convert_string_to_bytes(s);
      case 0:
       return s.c;
      case 4:
       return s.c;
    }
   }
   function caml_hash_mix_bytes(h, v){
    var content = caml_ml_bytes_content(v);
    return typeof content === "string"
            ? caml_hash_mix_jsbytes(h, content)
            : caml_hash_mix_bytes_arr(h, content);
   }
   function caml_bytes_lessthan(s1, s2){
    s1.t & 6 && caml_convert_string_to_bytes(s1);
    s2.t & 6 && caml_convert_string_to_bytes(s2);
    return s1.c < s2.c ? 1 : 0;
   }
   function caml_erfc_float(x){return 1 - caml_erf_float(x);}
   function caml_gr_fill_poly(ar){
    var s = caml_gr_state_get();
    s.context.beginPath();
    s.context.moveTo(ar[1][1], s.height - ar[1][2]);
    for(var i = 2; i < ar.length; i++)
     s.context.lineTo(ar[i][1], s.height - ar[i][2]);
    s.context.lineTo(ar[1][1], s.height - ar[1][2]);
    s.context.fill();
    return 0;
   }
   function caml_gc_quick_stat(){
    return [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
   }
   function caml_ml_input_char(chanid){
    var chan = caml_ml_channels[chanid];
    if(chan.buffer_curr >= chan.buffer_max){
     chan.buffer_curr = 0;
     chan.buffer_max = 0;
     caml_refill(chan);
    }
    if(chan.buffer_curr >= chan.buffer_max) caml_raise_end_of_file();
    var res = chan.buffer[chan.buffer_curr];
    chan.buffer_curr++;
    return res;
   }
   function caml_ml_input_int(chanid){
    var chan = caml_ml_channels[chanid], res = 0;
    for(var i = 0; i < 4; i++)
     res = (res << 8) + caml_ml_input_char(chanid) | 0;
    return res | 0;
   }
   function caml_gr_display_mode(){
    caml_failwith("caml_gr_display_mode not Implemented");
   }
   function caml_obj_reachable_words(o){return 0;}
   function nth_digit_nat(nat, ofs){return nat.data[ofs];}
   function caml_array_blit(a1, i1, a2, i2, len){
    if(i2 <= i1)
     for(var j = 1; j <= len; j++) a2[i2 + j] = a1[i1 + j];
    else
     for(var j = len; j >= 1; j--) a2[i2 + j] = a1[i1 + j];
    return 0;
   }
   function caml_float_of_string(s){
    var res;
    s = caml_jsbytes_of_string(s);
    res = + s;
    if(s.length > 0 && res === res) return res;
    s = s.replace(/_/g, "");
    res = + s;
    if(s.length > 0 && res === res || /^[+-]?nan$/i.test(s)) return res;
    var m = /^ *([+-]?)0x([0-9a-f]+)\.?([0-9a-f]*)(p([+-]?[0-9]+))?/i.exec(s);
    if(m){
     var
      m3 = m[3].replace(/0+$/, ""),
      mantissa = parseInt(m[1] + m[2] + m3, 16),
      exponent = (m[5] | 0) - 4 * m3.length;
     res = mantissa * Math.pow(2, exponent);
     return res;
    }
    if(/^\+?inf(inity)?$/i.test(s)) return Infinity;
    if(/^-inf(inity)?$/i.test(s)) return - Infinity;
    caml_failwith("float_of_string");
   }
   function caml_sys_getcwd(){
    return caml_string_of_jsbytes(caml_current_dir);
   }
   function caml_int64_add(x, y){return x.add(y);}
   function caml_int64_mul(x, y){return x.mul(y);}
   function caml_int64_ult(x, y){return x.ucompare(y) < 0;}
   function caml_parse_sign_and_base(s){
    var i = 0, len = caml_ml_string_length(s), base = 10, sign = 1;
    if(len > 0)
     switch(caml_string_unsafe_get(s, i)){
       case 45:
        i++; sign = - 1; break;
       case 43:
        i++; sign = 1; break;
     }
    if(i + 1 < len && caml_string_unsafe_get(s, i) == 48)
     switch(caml_string_unsafe_get(s, i + 1)){
       case 120:
       case 88:
        base = 16; i += 2; break;
       case 111:
       case 79:
        base = 8; i += 2; break;
       case 98:
       case 66:
        base = 2; i += 2; break;
       case 117:
       case 85:
        i += 2; break;
     }
    return [i, sign, base];
   }
   function caml_parse_digit(c){
    if(c >= 48 && c <= 57) return c - 48;
    if(c >= 65 && c <= 90) return c - 55;
    if(c >= 97 && c <= 122) return c - 87;
    return - 1;
   }
   function caml_int64_of_string(s){
    var
     r = caml_parse_sign_and_base(s),
     i = r[0],
     sign = r[1],
     base = r[2],
     base64 = caml_int64_of_int32(base),
     threshold =
       new MlInt64(0xffffff, 0xfffffff, 0xffff).udivmod(base64).quotient,
     c = caml_string_unsafe_get(s, i),
     d = caml_parse_digit(c);
    if(d < 0 || d >= base) caml_failwith("int_of_string");
    var res = caml_int64_of_int32(d);
    for(;;){
     i++;
     c = caml_string_unsafe_get(s, i);
     if(c == 95) continue;
     d = caml_parse_digit(c);
     if(d < 0 || d >= base) break;
     if(caml_int64_ult(threshold, res)) caml_failwith("int_of_string");
     d = caml_int64_of_int32(d);
     res = caml_int64_add(caml_int64_mul(base64, res), d);
     if(caml_int64_ult(res, d)) caml_failwith("int_of_string");
    }
    if(i != caml_ml_string_length(s)) caml_failwith("int_of_string");
    if(base == 10 && caml_int64_ult(new MlInt64(0, 0, 0x8000), res))
     caml_failwith("int_of_string");
    if(sign < 0) res = caml_int64_neg(res);
    return res;
   }
   function caml_ba_set_1(ba, i0, v){ba.set(ba.offset(i0), v); return 0;}
   function caml_int64_xor(x, y){return x.xor(y);}
   function caml_int64_or(x, y){return x.or(y);}
   function caml_lxm_next(v){
    function shift_l(x, k){return caml_int64_shift_left(x, k);}
    function shift_r(x, k){return caml_int64_shift_right_unsigned(x, k);}
    function or(a, b){return caml_int64_or(a, b);}
    function xor(a, b){return caml_int64_xor(a, b);}
    function add(a, b){return caml_int64_add(a, b);}
    function mul(a, b){return caml_int64_mul(a, b);}
    function rotl(x, k){return or(shift_l(x, k), shift_r(x, 64 - k));}
    function get(a, i){return caml_ba_get_1(a, i);}
    function set(a, i, x){return caml_ba_set_1(a, i, x);}
    var
     M = caml_int64_of_string(caml_new_string("0xd1342543de82ef95")),
     daba = caml_int64_of_string(caml_new_string("0xdaba0b6eb09322e3")),
     z,
     q0,
     q1,
     st = v,
     a = get(st, 0),
     s = get(st, 1),
     x0 = get(st, 2),
     x1 = get(st, 3);
    z = add(s, x0);
    z = mul(xor(z, shift_r(z, 32)), daba);
    z = mul(xor(z, shift_r(z, 32)), daba);
    z = xor(z, shift_r(z, 32));
    set(st, 1, add(mul(s, M), a));
    var q0 = x0, q1 = x1;
    q1 = xor(q1, q0);
    q0 = rotl(q0, 24);
    q0 = xor(xor(q0, q1), shift_l(q1, 16));
    q1 = rotl(q1, 37);
    set(st, 2, q0);
    set(st, 3, q1);
    return z;
   }
   function caml_sys_const_big_endian(){return 0;}
   function caml_list_to_js_array(l){
    var a = [];
    for(; l !== 0; l = l[2]) a.push(l[1]);
    return a;
   }
   var
    caml_output_val =
      function(){
        function Writer(){this.chunk = [];}
        Writer.prototype =
         {chunk_idx: 20,
          block_len: 0,
          obj_counter: 0,
          size_32: 0,
          size_64: 0,
          write:
          function(size, value){
           for(var i = size - 8; i >= 0; i -= 8)
            this.chunk[this.chunk_idx++] = value >> i & 0xFF;
          },
          write_at:
          function(pos, size, value){
           var pos = pos;
           for(var i = size - 8; i >= 0; i -= 8)
            this.chunk[pos++] = value >> i & 0xFF;
          },
          write_code:
          function(size, code, value){
           this.chunk[this.chunk_idx++] = code;
           for(var i = size - 8; i >= 0; i -= 8)
            this.chunk[this.chunk_idx++] = value >> i & 0xFF;
          },
          write_shared:
          function(offset){
           if(offset < 1 << 8)
            this.write_code(8, 0x04, offset);
           else if(offset < 1 << 16)
            this.write_code(16, 0x05, offset);
           else
            this.write_code(32, 0x06, offset);
          },
          pos: function(){return this.chunk_idx;},
          finalize:
          function(){
           this.block_len = this.chunk_idx - 20;
           this.chunk_idx = 0;
           this.write(32, 0x8495A6BE);
           this.write(32, this.block_len);
           this.write(32, this.obj_counter);
           this.write(32, this.size_32);
           this.write(32, this.size_64);
           return this.chunk;
          }};
        return function(v, flags){
         flags = caml_list_to_js_array(flags);
         var
          no_sharing = flags.indexOf(0) !== - 1,
          closures = flags.indexOf(1) !== - 1;
         if(closures)
          console.warn
           ("in caml_output_val: flag Marshal.Closures is not supported.");
         var
          writer = new Writer(),
          stack = [],
          intern_obj_table = no_sharing ? null : new MlObjectTable();
         function memo(v){
          if(no_sharing) return false;
          var existing_offset = intern_obj_table.recall(v);
          if(existing_offset){
           writer.write_shared(existing_offset);
           return true;
          }
          else{intern_obj_table.store(v); return false;}
         }
         function extern_rec(v){
          if(v.caml_custom){
           if(memo(v)) return;
           var
            name = v.caml_custom,
            ops = caml_custom_ops[name],
            sz_32_64 = [0, 0];
           if(! ops.serialize)
            caml_invalid_argument("output_value: abstract value (Custom)");
           if(ops.fixed_length == undefined){
            writer.write(8, 0x18);
            for(var i = 0; i < name.length; i++)
             writer.write(8, name.charCodeAt(i));
            writer.write(8, 0);
            var header_pos = writer.pos();
            for(var i = 0; i < 12; i++) writer.write(8, 0);
            ops.serialize(writer, v, sz_32_64);
            writer.write_at(header_pos, 32, sz_32_64[0]);
            writer.write_at(header_pos + 4, 32, 0);
            writer.write_at(header_pos + 8, 32, sz_32_64[1]);
           }
           else{
            writer.write(8, 0x19);
            for(var i = 0; i < name.length; i++)
             writer.write(8, name.charCodeAt(i));
            writer.write(8, 0);
            var old_pos = writer.pos();
            ops.serialize(writer, v, sz_32_64);
            if(ops.fixed_length != writer.pos() - old_pos)
             caml_failwith
              ("output_value: incorrect fixed sizes specified by " + name);
           }
           writer.size_32 += 2 + (sz_32_64[0] + 3 >> 2);
           writer.size_64 += 2 + (sz_32_64[1] + 7 >> 3);
          }
          else if(v instanceof Array && v[0] === (v[0] | 0)){
           if(v[0] == 251)
            caml_failwith("output_value: abstract value (Abstract)");
           if(caml_is_continuation_tag(v[0]))
            caml_invalid_argument("output_value: continuation value");
           if(v.length > 1 && memo(v)) return;
           if(v[0] < 16 && v.length - 1 < 8)
            writer.write(8, 0x80 + v[0] + (v.length - 1 << 4));
           else
            writer.write_code(32, 0x08, v.length - 1 << 10 | v[0]);
           writer.size_32 += v.length;
           writer.size_64 += v.length;
           if(v.length > 1) stack.push(v, 1);
          }
          else if(caml_is_ml_bytes(v)){
           if(! caml_is_ml_bytes(caml_string_of_jsbytes("")))
            caml_failwith
             ("output_value: [Bytes.t] cannot safely be marshaled with [--enable use-js-string]");
           if(memo(v)) return;
           var len = caml_ml_bytes_length(v);
           if(len < 0x20)
            writer.write(8, 0x20 + len);
           else if(len < 0x100)
            writer.write_code(8, 0x09, len);
           else
            writer.write_code(32, 0x0A, len);
           for(var i = 0; i < len; i++)
            writer.write(8, caml_bytes_unsafe_get(v, i));
           writer.size_32 += 1 + ((len + 4) / 4 | 0);
           writer.size_64 += 1 + ((len + 8) / 8 | 0);
          }
          else if(caml_is_ml_string(v)){
           if(memo(v)) return;
           var len = caml_ml_string_length(v);
           if(len < 0x20)
            writer.write(8, 0x20 + len);
           else if(len < 0x100)
            writer.write_code(8, 0x09, len);
           else
            writer.write_code(32, 0x0A, len);
           for(var i = 0; i < len; i++)
            writer.write(8, caml_string_unsafe_get(v, i));
           writer.size_32 += 1 + ((len + 4) / 4 | 0);
           writer.size_64 += 1 + ((len + 8) / 8 | 0);
          }
          else if(v != (v | 0)){
           var type_of_v = typeof v;
           caml_failwith("output_value: abstract value (" + type_of_v + ")");
          }
          else if(v >= 0 && v < 0x40)
           writer.write(8, 0X40 + v);
          else if(v >= - (1 << 7) && v < 1 << 7)
           writer.write_code(8, 0x00, v);
          else if(v >= - (1 << 15) && v < 1 << 15)
           writer.write_code(16, 0x01, v);
          else
           writer.write_code(32, 0x02, v);
         }
         extern_rec(v);
         while(stack.length > 0){
          var i = stack.pop(), v = stack.pop();
          if(i + 1 < v.length) stack.push(v, i + 1);
          extern_rec(v[i]);
         }
         if(intern_obj_table)
          writer.obj_counter = intern_obj_table.objs.length;
         writer.finalize();
         return writer.chunk;};
       }
       ();
   function caml_string_of_array(a){
    return caml_string_of_jsbytes(caml_subarray_to_jsbytes(a, 0, a.length));
   }
   function caml_output_value_to_string(v, flags){
    return caml_string_of_array(caml_output_val(v, flags));
   }
   function caml_raise_not_a_dir(name){
    caml_raise_sys_error(name + ": Not a directory");
   }
   function caml_sys_system_command(cmd){
    var cmd = caml_jsstring_of_string(cmd);
    if(typeof require != "undefined"){
     var child_process = require("child_process");
     if(child_process && child_process.execSync)
      try{child_process.execSync(cmd, {stdio: "inherit"}); return 0;}
      catch(e){return 1;}
    }
    else
     return 127;
   }
   function caml_js_error_of_exception(exn){
    if(exn.js_error) return exn.js_error;
    return null;
   }
   function caml_unix_getuid(unit){
    if(globalThis.process && globalThis.process.getuid)
     return globalThis.process.getuid();
    caml_raise_not_found();
   }
   function deserialize_nat(reader, sz){
    var len = reader.read32s(), nat = new MlNat(len);
    for(var i = 0; i < len; i++) nat.data[i] = reader.read32s();
    sz[0] = len * 4;
    return nat;
   }
   function initialize_nat(){
    caml_custom_ops["_nat"] =
     {deserialize: deserialize_nat,
      serialize: serialize_nat,
      hash: caml_hash_nat};
   }
   function caml_bytes_of_utf16_jsstring(s){
    var tag = 9;
    if(! jsoo_is_ascii(s)) tag = 8, s = caml_utf8_of_utf16(s);
    return new MlBytes(tag, s, s.length);
   }
   function caml_gr_open_subwindow(a, b, c, d){
    caml_failwith("caml_gr_open_subwindow not Implemented");
   }
   function UInt8ArrayReader(s, i){this.s = s; this.i = i;}
   UInt8ArrayReader.prototype =
    {read8u: function(){return this.s[this.i++];},
     read8s: function(){return this.s[this.i++] << 24 >> 24;},
     read16u:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 2;
      return s[i] << 8 | s[i + 1];
     },
     read16s:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 2;
      return s[i] << 24 >> 16 | s[i + 1];
     },
     read32u:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 4;
      return (s[i] << 24 | s[i + 1] << 16 | s[i + 2] << 8 | s[i + 3]) >>> 0;
     },
     read32s:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 4;
      return s[i] << 24 | s[i + 1] << 16 | s[i + 2] << 8 | s[i + 3];
     },
     readstr:
     function(len){
      var i = this.i;
      this.i = i + len;
      return caml_string_of_array(this.s.subarray(i, i + len));
     },
     readuint8array:
     function(len){
      var i = this.i;
      this.i = i + len;
      return this.s.subarray(i, i + len);
     }};
   function caml_marshal_data_size(s, ofs){
    var r = new UInt8ArrayReader(caml_uint8_array_of_bytes(s), ofs);
    function readvlq(overflow){
     var c = r.read8u(), n = c & 0x7F;
     while((c & 0x80) != 0){
      c = r.read8u();
      var n7 = n << 7;
      if(n != n7 >> 7) overflow[0] = true;
      n = n7 | c & 0x7F;
     }
     return n;
    }
    switch(r.read32u()){
      case 0x8495A6BE:
       var header_len = 20, data_len = r.read32u(); break;
      case 0x8495A6BD:
       var
        header_len = r.read8u() & 0x3F,
        overflow = [false],
        data_len = readvlq(overflow);
       if(overflow[0])
        caml_failwith
         ("Marshal.data_size: object too large to be read back on this platform");
       break;
      case 0x8495A6BF:
      default: caml_failwith("Marshal.data_size: bad object"); break;
    }
    return header_len - caml_marshal_header_size + data_len;
   }
   function MlStringReader(s, i){
    this.s = caml_jsbytes_of_string(s);
    this.i = i;
   }
   MlStringReader.prototype =
    {read8u: function(){return this.s.charCodeAt(this.i++);},
     read8s: function(){return this.s.charCodeAt(this.i++) << 24 >> 24;},
     read16u:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 2;
      return s.charCodeAt(i) << 8 | s.charCodeAt(i + 1);
     },
     read16s:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 2;
      return s.charCodeAt(i) << 24 >> 16 | s.charCodeAt(i + 1);
     },
     read32u:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 4;
      return (s.charCodeAt(i) << 24 | s.charCodeAt(i + 1) << 16
             | s.charCodeAt(i + 2) << 8
             | s.charCodeAt(i + 3))
             >>> 0;
     },
     read32s:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 4;
      return s.charCodeAt(i) << 24 | s.charCodeAt(i + 1) << 16
             | s.charCodeAt(i + 2) << 8
             | s.charCodeAt(i + 3);
     },
     readstr:
     function(len){
      var i = this.i;
      this.i = i + len;
      return caml_string_of_jsbytes(this.s.substring(i, i + len));
     },
     readuint8array:
     function(len){
      var b = new Uint8Array(len), s = this.s, i = this.i;
      for(var j = 0; j < len; j++) b[j] = s.charCodeAt(i + j);
      this.i = i + len;
      return b;
     }};
   var caml_decompress_input = null;
   function caml_float_of_bytes(a){
    return caml_int64_float_of_bits(caml_int64_of_bytes(a));
   }
   function caml_input_value_from_reader(reader, ofs){
    function readvlq(overflow){
     var c = reader.read8u(), n = c & 0x7F;
     while((c & 0x80) != 0){
      c = reader.read8u();
      var n7 = n << 7;
      if(n != n7 >> 7) overflow[0] = true;
      n = n7 | c & 0x7F;
     }
     return n;
    }
    var magic = reader.read32u();
    switch(magic){
      case 0x8495A6BE:
       var
        header_len = 20,
        compressed = 0,
        data_len = reader.read32u(),
        uncompressed_data_len = data_len,
        num_objects = reader.read32u(),
        _size_32 = reader.read32u(),
        _size_64 = reader.read32u();
       break;
      case 0x8495A6BD:
       var
        header_len = reader.read8u() & 0x3F,
        compressed = 1,
        overflow = [false],
        data_len = readvlq(overflow),
        uncompressed_data_len = readvlq(overflow),
        num_objects = readvlq(overflow),
        _size_32 = readvlq(overflow),
        _size_64 = readvlq(overflow);
       if(overflow[0])
        caml_failwith
         ("caml_input_value_from_reader: object too large to be read back on this platform");
       break;
      case 0x8495A6BF:
       caml_failwith
        ("caml_input_value_from_reader: object too large to be read back on a 32-bit platform");
       break;
      default:
       caml_failwith("caml_input_value_from_reader: bad object"); break;
    }
    var
     stack = [],
     intern_obj_table = num_objects > 0 ? [] : null,
     obj_counter = 0;
    function intern_rec(reader){
     var code = reader.read8u();
     if(code >= 0x40)
      if(code >= 0x80){
       var tag = code & 0xF, size = code >> 4 & 0x7, v = [tag];
       if(size == 0) return v;
       if(intern_obj_table) intern_obj_table[obj_counter++] = v;
       stack.push(v, size);
       return v;
      }
      else
       return code & 0x3F;
     else if(code >= 0x20){
      var len = code & 0x1F, v = reader.readstr(len);
      if(intern_obj_table) intern_obj_table[obj_counter++] = v;
      return v;
     }
     else
      switch(code){
        case 0x00:
         return reader.read8s();
        case 0x01:
         return reader.read16s();
        case 0x02:
         return reader.read32s();
        case 0x03:
         caml_failwith("input_value: integer too large"); break;
        case 0x04:
         var offset = reader.read8u();
         if(compressed == 0) offset = obj_counter - offset;
         return intern_obj_table[offset];
        case 0x05:
         var offset = reader.read16u();
         if(compressed == 0) offset = obj_counter - offset;
         return intern_obj_table[offset];
        case 0x06:
         var offset = reader.read32u();
         if(compressed == 0) offset = obj_counter - offset;
         return intern_obj_table[offset];
        case 0x08:
         var
          header = reader.read32u(),
          tag = header & 0xFF,
          size = header >> 10,
          v = [tag];
         if(size == 0) return v;
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         stack.push(v, size);
         return v;
        case 0x13:
         caml_failwith("input_value: data block too large"); break;
        case 0x09:
         var len = reader.read8u(), v = reader.readstr(len);
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         return v;
        case 0x0A:
         var len = reader.read32u(), v = reader.readstr(len);
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         return v;
        case 0x0C:
         var t = new Array(8);
         for(var i = 0; i < 8; i++) t[7 - i] = reader.read8u();
         var v = caml_float_of_bytes(t);
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         return v;
        case 0x0B:
         var t = new Array(8);
         for(var i = 0; i < 8; i++) t[i] = reader.read8u();
         var v = caml_float_of_bytes(t);
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         return v;
        case 0x0E:
         var len = reader.read8u(), v = new Array(len + 1);
         v[0] = 254;
         var t = new Array(8);
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         for(var i = 1; i <= len; i++){
          for(var j = 0; j < 8; j++) t[7 - j] = reader.read8u();
          v[i] = caml_float_of_bytes(t);
         }
         return v;
        case 0x0D:
         var len = reader.read8u(), v = new Array(len + 1);
         v[0] = 254;
         var t = new Array(8);
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         for(var i = 1; i <= len; i++){
          for(var j = 0; j < 8; j++) t[j] = reader.read8u();
          v[i] = caml_float_of_bytes(t);
         }
         return v;
        case 0x07:
         var len = reader.read32u(), v = new Array(len + 1);
         v[0] = 254;
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         var t = new Array(8);
         for(var i = 1; i <= len; i++){
          for(var j = 0; j < 8; j++) t[7 - j] = reader.read8u();
          v[i] = caml_float_of_bytes(t);
         }
         return v;
        case 0x0F:
         var len = reader.read32u(), v = new Array(len + 1);
         v[0] = 254;
         var t = new Array(8);
         for(var i = 1; i <= len; i++){
          for(var j = 0; j < 8; j++) t[j] = reader.read8u();
          v[i] = caml_float_of_bytes(t);
         }
         return v;
        case 0x10:
        case 0x11:
         caml_failwith("input_value: code pointer"); break;
        case 0x12:
        case 0x18:
        case 0x19:
         var c, s = "";
         while((c = reader.read8u()) != 0) s += String.fromCharCode(c);
         var ops = caml_custom_ops[s], expected_size;
         if(! ops)
          caml_failwith("input_value: unknown custom block identifier");
         switch(code){
           case 0x12: break;
           case 0x19:
            if(! ops.fixed_length)
             caml_failwith("input_value: expected a fixed-size custom block");
            expected_size = ops.fixed_length;
            break;
           case 0x18:
            expected_size = reader.read32u();
            reader.read32s();
            reader.read32s();
            break;
         }
         var
          old_pos = reader.i,
          size = [0],
          v = ops.deserialize(reader, size);
         if(expected_size != undefined)
          if(expected_size != size[0])
           caml_failwith
            ("input_value: incorrect length of serialized custom block");
         if(intern_obj_table) intern_obj_table[obj_counter++] = v;
         return v;
        default: caml_failwith("input_value: ill-formed message");
      }
    }
    if(compressed)
     if(caml_decompress_input)
      var
       data = reader.readuint8array(data_len),
       res = new Uint8Array(uncompressed_data_len),
       res = caml_decompress_input(data, res),
       reader = new UInt8ArrayReader(res, 0);
     else
      caml_failwith("input_value: compressed object, cannot decompress");
    var res = intern_rec(reader);
    while(stack.length > 0){
     var size = stack.pop(), v = stack.pop(), d = v.length;
     if(d < size) stack.push(v, size);
     v[d] = intern_rec(reader);
    }
    if(typeof ofs != "number") ofs[0] = reader.i;
    return res;
   }
   function caml_string_of_bytes(s){
    s.t & 6 && caml_convert_string_to_bytes(s);
    return caml_string_of_jsbytes(s.c);
   }
   function caml_input_value_from_bytes(s, ofs){
    var
     reader =
       new
        MlStringReader
        (caml_string_of_bytes(s), typeof ofs == "number" ? ofs : ofs[0]);
    return caml_input_value_from_reader(reader, ofs);
   }
   function caml_input_value(chanid){
    var
     chan = caml_ml_channels[chanid],
     header = new Uint8Array(caml_marshal_header_size);
    function block(buffer, offset, n){
     var r = 0;
     while(r < n){
      if(chan.buffer_curr >= chan.buffer_max){
       chan.buffer_curr = 0;
       chan.buffer_max = 0;
       caml_refill(chan);
      }
      if(chan.buffer_curr >= chan.buffer_max) break;
      buffer[offset + r] = chan.buffer[chan.buffer_curr];
      chan.buffer_curr++;
      r++;
     }
     return r;
    }
    var r = block(header, 0, caml_marshal_header_size);
    if(r == 0)
     caml_raise_end_of_file();
    else if(r < caml_marshal_header_size)
     caml_failwith("input_value: truncated object");
    var
     len = caml_marshal_data_size(caml_bytes_of_array(header), 0),
     buf = new Uint8Array(len + caml_marshal_header_size);
    buf.set(header, 0);
    var r = block(buf, caml_marshal_header_size, len);
    if(r < len)
     caml_failwith("input_value: truncated object " + r + "  " + len);
    var
     offset = [0],
     res = caml_input_value_from_bytes(caml_bytes_of_array(buf), offset);
    chan.offset = chan.offset + offset[0];
    return res;
   }
   function caml_input_value_to_outside_heap(c){return caml_input_value(c);}
   function caml_atomic_cas(ref, o, n){
    if(ref[1] === o){ref[1] = n; return 1;}
    return 0;
   }
   function caml_copysign_float(x, y){
    if(y == 0) y = 1 / y;
    x = Math.abs(x);
    return y < 0 ? - x : x;
   }
   function caml_gr_set_text_size(size){
    var s = caml_gr_state_get();
    s.text_size = size;
    s.context.font = s.text_size + "px " + caml_jsstring_of_string(s.font);
    return 0;
   }
   function caml_atomic_load(ref){return ref[1];}
   function caml_MD5Final(ctx){
    var in_buf = ctx.len & 0x3f;
    ctx.b8[in_buf] = 0x80;
    in_buf++;
    if(in_buf > 56){
     for(var j = in_buf; j < 64; j++) ctx.b8[j] = 0;
     caml_MD5Transform(ctx.w, ctx.b32);
     for(var j = 0; j < 56; j++) ctx.b8[j] = 0;
    }
    else
     for(var j = in_buf; j < 56; j++) ctx.b8[j] = 0;
    ctx.b32[14] = ctx.len << 3;
    ctx.b32[15] = ctx.len >> 29 & 0x1FFFFFFF;
    caml_MD5Transform(ctx.w, ctx.b32);
    var t = new Uint8Array(16);
    for(var i = 0; i < 4; i++)
     for(var j = 0; j < 4; j++) t[i * 4 + j] = ctx.w[i] >> 8 * j & 0xFF;
    return t;
   }
   function caml_md5_bytes(s, ofs, len){
    var ctx = caml_MD5Init(), a = caml_uint8_array_of_bytes(s);
    caml_MD5Update(ctx, a.subarray(ofs, ofs + len), len);
    return caml_string_of_array(caml_MD5Final(ctx));
   }
   function caml_ba_set_generic(ba, i, v){
    ba.set(ba.offset(caml_js_from_array(i)), v);
    return 0;
   }
   function caml_ml_condition_wait(t, mutext){return 0;}
   function caml_string_lessequal(s1, s2){return s1 <= s2 ? 1 : 0;}
   function caml_string_greaterequal(s1, s2){return caml_string_lessequal(s2, s1);
   }
   function caml_nextafter_float(x, y){
    if(isNaN(x) || isNaN(y)) return NaN;
    if(x == y) return y;
    if(x == 0) return y < 0 ? - Math.pow(2, - 1074) : Math.pow(2, - 1074);
    var bits = caml_int64_bits_of_float(x), one = caml_int64_of_int32(1);
    if(x < y == x > 0)
     bits = caml_int64_add(bits, one);
    else
     bits = caml_int64_sub(bits, one);
    return caml_int64_float_of_bits(bits);
   }
   function caml_gr_size_y(){var s = caml_gr_state_get(); return s.height;}
   function caml_pos_in(chanid){
    var chan = caml_ml_channels[chanid];
    return chan.offset - (chan.buffer_max - chan.buffer_curr) | 0;
   }
   function caml_ml_pos_in(chanid){return caml_pos_in(chanid);}
   function caml_int64_and(x, y){return x.and(y);}
   function caml_ml_runtime_events_resume(){return 0;}
   function caml_sys_const_word_size(){return 32;}
   function caml_unix_unlink(name){
    var root = resolve_fs_device(name);
    if(! root.device.unlink)
     caml_failwith("caml_unix_unlink: not implemented");
    return root.device.unlink(root.rest, true);
   }
   function caml_sys_open_for_node(fd, flags){
    if(flags.name)
     try{
      var fs = require("fs"), fd2 = fs.openSync(flags.name, "rs");
      return new MlNodeFd(fd2, flags);
     }
     catch(e){}
    return new MlNodeFd(fd, flags);
   }
   function MlFakeFd_out(fd, flags){
    MlFakeFile.call(this, caml_create_bytes(0));
    this.log = function(s){return 0;};
    if(fd == 1 && typeof console.log == "function")
     this.log = console.log;
    else if(fd == 2 && typeof console.error == "function")
     this.log = console.error;
    else if(typeof console.log == "function") this.log = console.log;
    this.flags = flags;
   }
   MlFakeFd_out.prototype.length = function(){return 0;};
   MlFakeFd_out.prototype.write =
    function(offset, buf, pos, len){
     if(this.log){
      if
       (len > 0 && pos >= 0 && pos + len <= buf.length
        && buf[pos + len - 1] == 10)
       len--;
      var src = caml_create_bytes(len);
      caml_blit_bytes(caml_bytes_of_array(buf), pos, src, 0, len);
      this.log(src.toUtf16());
      return 0;
     }
     caml_raise_sys_error(this.fd + ": file descriptor already closed");
    };
   MlFakeFd_out.prototype.read =
    function(offset, buf, pos, len){
     caml_raise_sys_error(this.fd + ": file descriptor is write only");
    };
   MlFakeFd_out.prototype.close = function(){this.log = undefined;};
   function caml_sys_open_internal(file, idx){
    if(idx == undefined) idx = caml_sys_fds.length;
    caml_sys_fds[idx] = file;
    return idx | 0;
   }
   function caml_sys_open(name, flags, _perms){
    var f = {};
    while(flags){
     switch(flags[1]){
       case 0:
        f.rdonly = 1; break;
       case 1:
        f.wronly = 1; break;
       case 2:
        f.append = 1; break;
       case 3:
        f.create = 1; break;
       case 4:
        f.truncate = 1; break;
       case 5:
        f.excl = 1; break;
       case 6:
        f.binary = 1; break;
       case 7:
        f.text = 1; break;
       case 8:
        f.nonblock = 1; break;
     }
     flags = flags[2];
    }
    if(f.rdonly && f.wronly)
     caml_raise_sys_error
      (caml_jsbytes_of_string(name)
       + " : flags Open_rdonly and Open_wronly are not compatible");
    if(f.text && f.binary)
     caml_raise_sys_error
      (caml_jsbytes_of_string(name)
       + " : flags Open_text and Open_binary are not compatible");
    var root = resolve_fs_device(name), file = root.device.open(root.rest, f);
    return caml_sys_open_internal(file, undefined);
   }
   (function(){
      function file(fd, flags){
       return fs_node_supported()
               ? caml_sys_open_for_node(fd, flags)
               : new MlFakeFd_out(fd, flags);
      }
      caml_sys_open_internal
       (file(0, {rdonly: 1, altname: "/dev/stdin", isCharacterDevice: true}),
        0);
      caml_sys_open_internal
       (file(1, {buffered: 2, wronly: 1, isCharacterDevice: true}), 1);
      caml_sys_open_internal
       (file(2, {buffered: 2, wronly: 1, isCharacterDevice: true}), 2);
     }
     ());
   function caml_string_get(s, i){
    if(i >>> 0 >= caml_ml_string_length(s)) caml_string_bound_error();
    return caml_string_unsafe_get(s, i);
   }
   var
    re_match =
      function(){
        var
         re_word_letters =
           [0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0xFF,
            0x03,
            0xFE,
            0xFF,
            0xFF,
            0x87,
            0xFE,
            0xFF,
            0xFF,
            0x07,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0xFF,
            0xFF,
            0x7F,
            0xFF,
            0xFF,
            0xFF,
            0x7F,
            0xFF],
         opcodes =
           {CHAR: 0,
            CHARNORM: 1,
            STRING: 2,
            STRINGNORM: 3,
            CHARCLASS: 4,
            BOL: 5,
            EOL: 6,
            WORDBOUNDARY: 7,
            BEGGROUP: 8,
            ENDGROUP: 9,
            REFGROUP: 10,
            ACCEPT: 11,
            SIMPLEOPT: 12,
            SIMPLESTAR: 13,
            SIMPLEPLUS: 14,
            GOTO: 15,
            PUSHBACK: 16,
            SETMARK: 17,
            CHECKPROGRESS: 18};
        function is_word_letter(c){
         return re_word_letters[c >> 3] >> (c & 7) & 1;
        }
        function in_bitset(s, i){
         return caml_string_get(s, i >> 3) >> (i & 7) & 1;
        }
        function re_match_impl(re, s, pos, partial){
         var
          prog = caml_js_from_array(re[1]),
          cpool = caml_js_from_array(re[2]),
          normtable = caml_jsbytes_of_string(re[3]),
          numgroups = re[4] | 0,
          numregisters = re[5] | 0,
          startchars = re[6] | 0,
          s = caml_uint8_array_of_string(s),
          pc = 0,
          quit = false,
          stack = [],
          groups = new Array(numgroups),
          re_register = new Array(numregisters);
         for(var i = 0; i < groups.length; i++)
          groups[i] = {start: - 1, end: - 1};
         groups[0].start = pos;
         function backtrack(){
          while(stack.length){
           var item = stack.pop();
           if(item.undo)
            item.undo.obj[item.undo.prop] = item.undo.value;
           else if(item.pos){pc = item.pos.pc; pos = item.pos.txt; return;}
          }
          quit = true;
         }
         function push(item){stack.push(item);}
         function accept(){
          groups[0].end = pos;
          var result = new Array(1 + groups.length * 2);
          result[0] = 0;
          for(var i = 0; i < groups.length; i++){
           var g = groups[i];
           if(g.start < 0 || g.end < 0) g.start = g.end = - 1;
           result[2 * i + 1] = g.start;
           result[2 * i + 1 + 1] = g.end;
          }
          return result;
         }
         function prefix_match(){
          if(partial) return accept(); else backtrack();
         }
         while(! quit){
          var
           op = prog[pc] & 0xff,
           sarg = prog[pc] >> 8,
           uarg = sarg & 0xff,
           c = s[pos],
           group;
          pc++;
          switch(op){
            case opcodes.CHAR:
             if(pos === s.length){prefix_match(); break;}
             if(c === uarg) pos++; else backtrack();
             break;
            case opcodes.CHARNORM:
             if(pos === s.length){prefix_match(); break;}
             if(normtable.charCodeAt(c) === uarg) pos++; else backtrack();
             break;
            case opcodes.STRING:
             for
             (var arg = caml_jsbytes_of_string(cpool[uarg]), i = 0;
              i < arg.length;
              i++){
              if(pos === s.length){prefix_match(); break;}
              if(c === arg.charCodeAt(i))
               c = s[++pos];
              else{backtrack(); break;}
             }
             break;
            case opcodes.STRINGNORM:
             for
             (var arg = caml_jsbytes_of_string(cpool[uarg]), i = 0;
              i < arg.length;
              i++){
              if(pos === s.length){prefix_match(); break;}
              if(normtable.charCodeAt(c) === arg.charCodeAt(i))
               c = s[++pos];
              else{backtrack(); break;}
             }
             break;
            case opcodes.CHARCLASS:
             if(pos === s.length){prefix_match(); break;}
             if(in_bitset(cpool[uarg], c)) pos++; else backtrack();
             break;
            case opcodes.BOL:
             if(pos > 0 && s[pos - 1] != 10) backtrack(); break;
            case opcodes.EOL:
             if(pos < s.length && s[pos] != 10) backtrack(); break;
            case opcodes.WORDBOUNDARY:
             if(pos == 0){
              if(pos === s.length){prefix_match(); break;}
              if(is_word_letter(s[0])) break;
              backtrack();
             }
             else if(pos === s.length){
              if(is_word_letter(s[pos - 1])) break;
              backtrack();
             }
             else{
              if(is_word_letter(s[pos - 1]) != is_word_letter(s[pos])) break;
              backtrack();
             }
             break;
            case opcodes.BEGGROUP:
             group = groups[uarg];
             push({undo: {obj: group, prop: "start", value: group.start}});
             group.start = pos;
             break;
            case opcodes.ENDGROUP:
             group = groups[uarg];
             push({undo: {obj: group, prop: "end", value: group.end}});
             group.end = pos;
             break;
            case opcodes.REFGROUP:
             group = groups[uarg];
             if(group.start < 0 || group.end < 0){backtrack(); break;}
             for(var i = group.start; i < group.end; i++){
              if(pos === s.length){prefix_match(); break;}
              if(s[i] != s[pos]){backtrack(); break;}
              pos++;
             }
             break;
            case opcodes.SIMPLEOPT:
             if(in_bitset(cpool[uarg], c)) pos++; break;
            case opcodes.SIMPLESTAR:
             while(in_bitset(cpool[uarg], c)) c = s[++pos]; break;
            case opcodes.SIMPLEPLUS:
             if(pos === s.length){prefix_match(); break;}
             if(in_bitset(cpool[uarg], c))
              do c = s[++pos];while(in_bitset(cpool[uarg], c));
             else
              backtrack();
             break;
            case opcodes.ACCEPT: return accept();
            case opcodes.GOTO:
             pc = pc + sarg; break;
            case opcodes.PUSHBACK:
             push({pos: {pc: pc + sarg, txt: pos}}); break;
            case opcodes.SETMARK:
             push
              ({undo: {obj: re_register, prop: uarg, value: re_register[uarg]}});
             re_register[uarg] = pos;
             break;
            case opcodes.CHECKPROGRESS:
             if(re_register[uarg] === pos) backtrack(); break;
            default: throw new Error("Invalid bytecode");
          }
         }
         return 0;
        }
        return re_match_impl;
       }
       ();
   function re_search_backward(re, s, pos){
    if(pos < 0 || pos > caml_ml_string_length(s))
     caml_invalid_argument("Str.search_backward");
    while(pos >= 0){
     var res = re_match(re, s, pos, 0);
     if(res) return res;
     pos--;
    }
    return [0];
   }
   function caml_js_from_string(s){return caml_jsstring_of_string(s);}
   function caml_ml_output_ta(chanid, buffer, offset, len){
    var chan = caml_ml_channels[chanid];
    if(! chan.opened)
     caml_raise_sys_error("Cannot output to a closed channel");
    buffer = buffer.subarray(offset, offset + len);
    if(chan.buffer_curr + buffer.length > chan.buffer.length){
     var b = new Uint8Array(chan.buffer_curr + buffer.length);
     b.set(chan.buffer);
     chan.buffer = b;
    }
    switch(chan.buffered){
      case 0:
       chan.buffer.set(buffer, chan.buffer_curr);
       chan.buffer_curr += buffer.length;
       caml_ml_flush(chanid);
       break;
      case 1:
       chan.buffer.set(buffer, chan.buffer_curr);
       chan.buffer_curr += buffer.length;
       if(chan.buffer_curr >= chan.buffer.length) caml_ml_flush(chanid);
       break;
      case 2:
       var id = buffer.lastIndexOf(10);
       if(id < 0){
        chan.buffer.set(buffer, chan.buffer_curr);
        chan.buffer_curr += buffer.length;
        if(chan.buffer_curr >= chan.buffer.length) caml_ml_flush(chanid);
       }
       else{
        chan.buffer.set(buffer.subarray(0, id + 1), chan.buffer_curr);
        chan.buffer_curr += id + 1;
        caml_ml_flush(chanid);
        chan.buffer.set(buffer.subarray(id + 1), chan.buffer_curr);
        chan.buffer_curr += buffer.length - id - 1;
       }
       break;
    }
    return 0;
   }
   function caml_ba_sub(ba, ofs, len){
    var changed_dim, mul = 1;
    if(ba.layout == 0){
     for(var i = 1; i < ba.dims.length; i++) mul = mul * ba.dims[i];
     changed_dim = 0;
    }
    else{
     for(var i = 0; i < ba.dims.length - 1; i++) mul = mul * ba.dims[i];
     changed_dim = ba.dims.length - 1;
     ofs = ofs - 1;
    }
    if(ofs < 0 || len < 0 || ofs + len > ba.dims[changed_dim])
     caml_invalid_argument("Bigarray.sub: bad sub-array");
    var new_dims = [];
    for(var i = 0; i < ba.dims.length; i++) new_dims[i] = ba.dims[i];
    new_dims[changed_dim] = len;
    mul *= caml_ba_get_size_per_element(ba.kind);
    var new_data = ba.data.subarray(ofs * mul, (ofs + len) * mul);
    return caml_ba_create_unsafe(ba.kind, ba.layout, new_dims, new_data);
   }
   function caml_gc_full_major(unit){
    if(typeof globalThis.gc == "function") globalThis.gc();
    return 0;
   }
   function caml_ml_mutex_try_lock(t){
    if(! t.locked){t.locked = true; return 1;}
    return 0;
   }
   function caml_bytes_set32(s, i, i32){
    if(i >>> 0 >= s.l - 3) caml_bytes_bound_error();
    var
     b4 = 0xFF & i32 >> 24,
     b3 = 0xFF & i32 >> 16,
     b2 = 0xFF & i32 >> 8,
     b1 = 0xFF & i32;
    caml_bytes_unsafe_set(s, i + 0, b1);
    caml_bytes_unsafe_set(s, i + 1, b2);
    caml_bytes_unsafe_set(s, i + 2, b3);
    caml_bytes_unsafe_set(s, i + 3, b4);
    return 0;
   }
   function caml_gr_sigio_signal(){return 0;}
   function caml_ba_uint8_set32(ba, i0, v){
    var ofs = ba.offset(i0);
    if(ofs + 3 >= ba.data.length) caml_array_bound_error();
    ba.set(ofs + 0, v & 0xff);
    ba.set(ofs + 1, v >>> 8 & 0xff);
    ba.set(ofs + 2, v >>> 16 & 0xff);
    ba.set(ofs + 3, v >>> 24 & 0xff);
    return 0;
   }
   function caml_sys_const_ostype_unix(){return os_type == "Unix" ? 1 : 0;}
   function caml_unix_gmtime(t){
    var
     d = new Date(t * 1000),
     d_num = d.getTime(),
     januaryfirst = new Date(Date.UTC(d.getUTCFullYear(), 0, 1)).getTime(),
     doy = Math.floor((d_num - januaryfirst) / 86400000);
    return [0,
            d.getUTCSeconds(),
            d.getUTCMinutes(),
            d.getUTCHours(),
            d.getUTCDate(),
            d.getUTCMonth(),
            d.getUTCFullYear() - 1900,
            d.getUTCDay(),
            doy,
            false | 0];
   }
   function caml_signbit_float(x){if(x == 0) x = 1 / x; return x < 0 ? 1 : 0;}
   function caml_gr_current_x(){var s = caml_gr_state_get(); return s.x;}
   function caml_gr_set_line_width(w){
    var s = caml_gr_state_get();
    s.line_width = w;
    s.context.lineWidth = w;
    return 0;
   }
   function caml_gr_set_font(f){
    var s = caml_gr_state_get();
    s.font = f;
    s.context.font = s.text_size + "px " + caml_jsstring_of_string(s.font);
    return 0;
   }
   function caml_gr_set_color(color){
    var s = caml_gr_state_get();
    function convert(number){
     var str = "" + number.toString(16);
     while(str.length < 2) str = "0" + str;
     return str;
    }
    var r = color >> 16 & 0xff, g = color >> 8 & 0xff, b = color >> 0 & 0xff;
    s.color = color;
    var c_str = "#" + convert(r) + convert(g) + convert(b);
    s.context.fillStyle = c_str;
    s.context.strokeStyle = c_str;
    return 0;
   }
   function caml_gr_moveto(x, y){
    var s = caml_gr_state_get();
    s.x = x;
    s.y = y;
    return 0;
   }
   function caml_gr_resize_window(w, h){
    var s = caml_gr_state_get();
    s.width = w;
    s.height = h;
    s.canvas.width = w;
    s.canvas.height = h;
    return 0;
   }
   function caml_gr_state_init(){
    caml_gr_moveto(caml_gr_state.x, caml_gr_state.y);
    caml_gr_resize_window(caml_gr_state.width, caml_gr_state.height);
    caml_gr_set_line_width(caml_gr_state.line_width);
    caml_gr_set_text_size(caml_gr_state.text_size);
    caml_gr_set_font(caml_gr_state.font);
    caml_gr_set_color(caml_gr_state.color);
    caml_gr_set_window_title(caml_gr_state.title);
    caml_gr_state.context.textBaseline = "bottom";
   }
   function caml_ba_kind_of_typed_array(ta){
    var kind;
    if(ta instanceof Float32Array)
     kind = 0;
    else if(ta instanceof Float64Array)
     kind = 1;
    else if(ta instanceof Int8Array)
     kind = 2;
    else if(ta instanceof Uint8Array)
     kind = 3;
    else if(ta instanceof Uint8ClampedArray)
     kind = 3;
    else if(ta instanceof Int16Array)
     kind = 4;
    else if(ta instanceof Uint16Array)
     kind = 5;
    else if(ta instanceof Int32Array)
     kind = 6;
    else if(ta instanceof Uint32Array)
     kind = 6;
    else
     caml_invalid_argument("caml_ba_kind_of_typed_array: unsupported kind");
    return kind;
   }
   function caml_ba_from_typed_array(ta){
    var
     kind = caml_ba_kind_of_typed_array(ta),
     ta =
       ta instanceof Uint32Array
        ? new Int32Array(ta.buffer, ta.byteOffset, ta.length)
        : ta;
    return caml_ba_create_unsafe(kind, 0, [ta.length], ta);
   }
   function caml_ml_seek_out(chanid, pos){return caml_seek_out(chanid, pos);}
   function caml_js_typeof(o){return typeof o;}
   function caml_hash_mix_string(h, v){
    return caml_hash_mix_jsbytes(h, caml_jsbytes_of_string(v));
   }
   function caml_string_hash(h, v){
    var h = caml_hash_mix_string(h, v), h = caml_hash_mix_final(h);
    return h & 0x3FFFFFFF;
   }
   function caml_restore_raw_backtrace(exn, bt){return 0;}
   function caml_gr_lineto(x, y){
    var s = caml_gr_state_get();
    s.context.beginPath();
    s.context.moveTo(s.x, s.height - s.y);
    s.context.lineTo(x, s.height - y);
    s.context.stroke();
    s.x = x;
    s.y = y;
    return 0;
   }
   function caml_js_function_arity(f){return f.l >= 0 ? f.l : f.l = f.length;}
   function caml_js_wrap_meth_callback_unsafe(f){
    return function(){
     var len = caml_js_function_arity(f) - 1, args = new Array(len + 1);
     args[0] = this;
     for(var i = 0; i < len; i++) args[i + 1] = arguments[i];
     return caml_callback(f, args);};
   }
   function caml_ba_dim_3(ba){return caml_ba_dim(ba, 2);}
   function caml_is_special_exception(exn){
    switch(exn[2]){case - 8:case - 11:case - 12: return 1;default: return 0;
    }
   }
   function caml_format_exception(exn){
    var r = "";
    if(exn[0] == 0){
     r += exn[1][1];
     if
      (exn.length == 3 && exn[2][0] == 0 && caml_is_special_exception(exn[1]))
      var bucket = exn[2], start = 1;
     else
      var start = 2, bucket = exn;
     r += "(";
     for(var i = start; i < bucket.length; i++){
      if(i > start) r += ", ";
      var v = bucket[i];
      if(typeof v == "number")
       r += v.toString();
      else if(v instanceof MlBytes)
       r += '"' + v.toString() + '"';
      else if(typeof v == "string")
       r += '"' + v.toString() + '"';
      else
       r += "_";
     }
     r += ")";
    }
    else if(exn[0] == 248) r += exn[1];
    return r;
   }
   function caml_fatal_uncaught_exception(err){
    if(err instanceof Array && (err[0] == 0 || err[0] == 248)){
     var handler = caml_named_value("Printexc.handle_uncaught_exception");
     if(handler)
      caml_callback(handler, [err, false]);
     else{
      var
       msg = caml_format_exception(err),
       at_exit = caml_named_value("Pervasives.do_at_exit");
      if(at_exit) caml_callback(at_exit, [0]);
      console.error("Fatal error: exception " + msg);
      if(err.js_error) throw err.js_error;
     }
    }
    else
     throw err;
   }
   function caml_ephe_check_data(x){
    return x[caml_ephe_data_offset] === undefined ? 0 : 1;
   }
   function caml_bytes_get16(s, i){
    if(i >>> 0 >= s.l - 1) caml_bytes_bound_error();
    var
     b1 = caml_bytes_unsafe_get(s, i),
     b2 = caml_bytes_unsafe_get(s, i + 1);
    return b2 << 8 | b1;
   }
   function caml_obj_make_forward(b, v){b[0] = 250; b[1] = v; return 0;}
   function caml_js_from_bool(x){return ! ! x;}
   function caml_ml_set_channel_name(chanid, name){
    var chan = caml_ml_channels[chanid];
    chan.name = name;
    return 0;
   }
   function caml_exp2_float(x){return Math.pow(2, x);}
   function caml_gr_close_graph(){
    var s = caml_gr_state_get();
    s.canvas.width = 0;
    s.canvas.height = 0;
    return 0;
   }
   function caml_ml_domain_cpu_relax(unit){return 0;}
   function caml_create_string(len){caml_invalid_argument("String.create");}
   function caml_md5_chan(chanid, toread){
    var ctx = caml_MD5Init(), buffer = new Uint8Array(4096);
    if(toread < 0)
     while(true){
      var read = caml_ml_input_block(chanid, buffer, 0, buffer.length);
      if(read == 0) break;
      caml_MD5Update(ctx, buffer.subarray(0, read), read);
     }
    else
     while(toread > 0){
      var
       read =
         caml_ml_input_block
          (chanid, buffer, 0, toread > buffer.length ? buffer.length : toread);
      if(read == 0) caml_raise_end_of_file();
      caml_MD5Update(ctx, buffer.subarray(0, read), read);
      toread -= read;
     }
    return caml_string_of_array(caml_MD5Final(ctx));
   }
   function caml_atanh_float(x){return Math.atanh(x);}
   function caml_ml_condition_signal(t){return 0;}
   function caml_unix_findnext(dir_handle){return caml_unix_readdir(dir_handle);
   }
   function caml_ml_output_bytes(chanid, buffer, offset, len){
    var buffer = caml_uint8_array_of_bytes(buffer);
    return caml_ml_output_ta(chanid, buffer, offset, len);
   }
   function caml_ml_output(chanid, buffer, offset, len){
    return caml_ml_output_bytes
            (chanid, caml_bytes_of_string(buffer), offset, len);
   }
   function caml_ml_domain_id(unit){return caml_domain_id;}
   function caml_ephe_get_data(x){
    return x[caml_ephe_data_offset] === undefined
            ? 0
            : [0, x[caml_ephe_data_offset]];
   }
   function caml_xmlhttprequest_create(unit){
    if(typeof globalThis.XMLHttpRequest !== "undefined")
     try{return new globalThis.XMLHttpRequest;}catch(e){}
    if(typeof globalThis.activeXObject !== "undefined"){
     try{return new globalThis.activeXObject("Msxml2.XMLHTTP");}catch(e){}
     try{return new globalThis.activeXObject("Msxml3.XMLHTTP");}catch(e){}
     try{return new globalThis.activeXObject("Microsoft.XMLHTTP");}catch(e){}
    }
    caml_failwith("Cannot create a XMLHttpRequest");
   }
   function caml_trampoline_return(f, args){return {joo_tramp: f, joo_args: args};
   }
   function caml_ml_is_buffered(chanid){
    return caml_ml_channels[chanid].buffered ? 1 : 0;
   }
   function caml_array_append(a1, a2){
    var l1 = a1.length, l2 = a2.length, l = l1 + l2 - 1, a = new Array(l);
    a[0] = 0;
    var i = 1, j = 1;
    for(; i < l1; i++) a[i] = a1[i];
    for(; i < l; i++, j++) a[i] = a2[j];
    return a;
   }
   function caml_unix_gettimeofday(){return new Date().getTime() / 1000;}
   function caml_unix_time(){return Math.floor(caml_unix_gettimeofday());}
   function caml_ml_set_channel_refill(chanid, f){
    caml_ml_channels[chanid].refill = f;
    return 0;
   }
   function caml_runtime_events_create_cursor(target){return {};}
   function caml_fill_bytes(s, i, l, c){
    if(l > 0)
     if(i == 0 && (l >= s.l || s.t == 2 && l >= s.c.length))
      if(c == 0){
       s.c = "";
       s.t = 2;
      }
      else{
       s.c = caml_str_repeat(l, String.fromCharCode(c));
       s.t = l == s.l ? 0 : 2;
      }
     else{
      if(s.t != 4) caml_convert_bytes_to_array(s);
      for(l += i; i < l; i++) s.c[i] = c;
     }
    return 0;
   }
   function caml_js_expr(s){
    console.error("caml_js_expr: fallback to runtime evaluation\n");
    return eval(caml_jsstring_of_string(s));
   }
   function caml_ml_runtime_warnings_enabled(_unit){return caml_runtime_warnings;
   }
   function caml_output_value_to_bytes(v, flags){
    return caml_bytes_of_array(caml_output_val(v, flags));
   }
   function caml_eventlog_resume(unit){return 0;}
   function caml_md5_string(s, ofs, len){
    return caml_md5_bytes(caml_bytes_of_string(s), ofs, len);
   }
   function caml_array_of_string(x){return caml_uint8_array_of_string(x);}
   function caml_string_equal(s1, s2){if(s1 === s2) return 1; return 0;}
   function caml_jsoo_flags_use_js_string(unit){return 1;}
   var
    zstd_decompress =
      function(){
        "use strict";
        var
         ab = ArrayBuffer,
         u8 = Uint8Array,
         u16 = Uint16Array,
         i16 = Int16Array,
         u32 = Uint32Array,
         i32 = Int32Array;
        function slc(v, s, e){
         if(u8.prototype.slice) return u8.prototype.slice.call(v, s, e);
         if(s == null || s < 0) s = 0;
         if(e == null || e > v.length) e = v.length;
         var n = new u8(e - s);
         n.set(v.subarray(s, e));
         return n;
        }
        function fill(v, n, s, e){
         if(u8.prototype.fill) return u8.prototype.fill.call(v, n, s, e);
         if(s == null || s < 0) s = 0;
         if(e == null || e > v.length) e = v.length;
         for(; s < e; ++s) v[s] = n;
         return v;
        }
        function cpw(v, t, s, e){
         if(u8.prototype.copyWithin)
          return u8.prototype.copyWithin.call(v, t, s, e);
         if(s == null || s < 0) s = 0;
         if(e == null || e > v.length) e = v.length;
         while(s < e) v[t++] = v[s++];
        }
        var
         ec =
           ["invalid zstd data",
            "window size too large (>2046MB)",
            "invalid block type",
            "FSE accuracy too high",
            "match distance too far back",
            "unexpected EOF"];
        function err(ind, msg, nt){
         var e = new Error(msg || ec[ind]);
         e.code = ind;
         if(! nt) throw e;
         return e;
        }
        function rb(d, b, n){
         var i = 0, o = 0;
         for(; i < n; ++i) o |= d[b++] << (i << 3);
         return o;
        }
        function b4(d, b){
         return (d[b] | d[b + 1] << 8 | d[b + 2] << 16 | d[b + 3] << 24) >>> 0;
        }
        function rzfh(dat, w){
         var n3 = dat[0] | dat[1] << 8 | dat[2] << 16;
         if(n3 == 0x2FB528 && dat[3] == 253){
          var
           flg = dat[4],
           ss = flg >> 5 & 1,
           cc = flg >> 2 & 1,
           df = flg & 3,
           fcf = flg >> 6;
          if(flg & 8) err(0);
          var bt = 6 - ss, db = df == 3 ? 4 : df, di = rb(dat, bt, db);
          bt += db;
          var
           fsb = fcf ? 1 << fcf : ss,
           fss = rb(dat, bt, fsb) + (fcf == 1 && 256),
           ws = fss;
          if(! ss){
           var wb = 1 << 10 + (dat[5] >> 3);
           ws = wb + (wb >> 3) * (dat[5] & 7);
          }
          if(ws > 2145386496) err(1);
          var buf = new u8((w == 1 ? fss || ws : w ? 0 : ws) + 12);
          buf[0] = 1, buf[4] = 4, buf[8] = 8;
          return {b: bt + fsb,
                  y: 0,
                  l: 0,
                  d: di,
                  w: w && w != 1 ? w : buf.subarray(12),
                  e: ws,
                  o: new i32(buf.buffer, 0, 3),
                  u: fss,
                  c: cc,
                  m: Math.min(131072, ws)};
         }
         else if((n3 >> 4 | dat[3] << 20) == 0x184D2A5) return b4(dat, 4) + 8;
         err(0);
        }
        function msb(val){
         var bits = 0;
         for(; 1 << bits <= val; ++bits) ;
         return bits - 1;
        }
        function rfse(dat, bt, mal){
         var tpos = (bt << 3) + 4, al = (dat[bt] & 15) + 5;
         if(al > mal) err(3);
         var
          sz = 1 << al,
          probs = sz,
          sym = - 1,
          re = - 1,
          i = - 1,
          ht = sz,
          buf = new ab(512 + (sz << 2)),
          freq = new i16(buf, 0, 256),
          dstate = new u16(buf, 0, 256),
          nstate = new u16(buf, 512, sz),
          bb1 = 512 + (sz << 1),
          syms = new u8(buf, bb1, sz),
          nbits = new u8(buf, bb1 + sz);
         while(sym < 255 && probs > 0){
          var
           bits = msb(probs + 1),
           cbt = tpos >> 3,
           msk = (1 << bits + 1) - 1,
           val =
             (dat[cbt] | dat[cbt + 1] << 8 | dat[cbt + 2] << 16) >> (tpos & 7)
             & msk,
           msk1fb = (1 << bits) - 1,
           msv = msk - probs - 1,
           sval = val & msk1fb;
          if(sval < msv)
           tpos += bits, val = sval;
          else{tpos += bits + 1; if(val > msk1fb) val -= msv;}
          freq[++sym] = --val;
          if(val == - 1){probs += val; syms[--ht] = sym;} else probs -= val;
          if(! val)
           do{
            var rbt = tpos >> 3;
            re = (dat[rbt] | dat[rbt + 1] << 8) >> (tpos & 7) & 3;
            tpos += 2;
            sym += re;
           }
           while
            (re == 3);
         }
         if(sym > 255 || probs) err(0);
         var sympos = 0, sstep = (sz >> 1) + (sz >> 3) + 3, smask = sz - 1;
         for(var s = 0; s <= sym; ++s){
          var sf = freq[s];
          if(sf < 1){dstate[s] = - sf; continue;}
          for(i = 0; i < sf; ++i){
           syms[sympos] = s;
           do sympos = sympos + sstep & smask;while(sympos >= ht);
          }
         }
         if(sympos) err(0);
         for(i = 0; i < sz; ++i){
          var ns = dstate[syms[i]]++, nb = nbits[i] = al - msb(ns);
          nstate[i] = (ns << nb) - sz;
         }
         return [tpos + 7 >> 3, {b: al, s: syms, n: nbits, t: nstate}];
        }
        function rhu(dat, bt){
         var
          i = 0,
          wc = - 1,
          buf = new u8(292),
          hb = dat[bt],
          hw = buf.subarray(0, 256),
          rc = buf.subarray(256, 268),
          ri = new u16(buf.buffer, 268);
         if(hb < 128){
          var _a = rfse(dat, bt + 1, 6), ebt = _a[0], fdt = _a[1];
          bt += hb;
          var epos = ebt << 3, lb = dat[bt];
          if(! lb) err(0);
          var
           st1 = 0,
           st2 = 0,
           btr1 = fdt.b,
           btr2 = btr1,
           fpos = (++bt << 3) - 8 + msb(lb);
          for(;;){
           fpos -= btr1;
           if(fpos < epos) break;
           var cbt = fpos >> 3;
           st1 +=
            (dat[cbt] | dat[cbt + 1] << 8) >> (fpos & 7) & (1 << btr1) - 1;
           hw[++wc] = fdt.s[st1];
           fpos -= btr2;
           if(fpos < epos) break;
           cbt = fpos >> 3;
           st2 +=
            (dat[cbt] | dat[cbt + 1] << 8) >> (fpos & 7) & (1 << btr2) - 1;
           hw[++wc] = fdt.s[st2];
           btr1 = fdt.n[st1];
           st1 = fdt.t[st1];
           btr2 = fdt.n[st2];
           st2 = fdt.t[st2];
          }
          if(++wc > 255) err(0);
         }
         else{
          wc = hb - 127;
          for(; i < wc; i += 2){
           var byte = dat[++bt];
           hw[i] = byte >> 4;
           hw[i + 1] = byte & 15;
          }
          ++bt;
         }
         var wes = 0;
         for(i = 0; i < wc; ++i){
          var wt = hw[i];
          if(wt > 11) err(0);
          wes += wt && 1 << wt - 1;
         }
         var mb = msb(wes) + 1, ts = 1 << mb, rem = ts - wes;
         if(rem & rem - 1) err(0);
         hw[wc++] = msb(rem) + 1;
         for(i = 0; i < wc; ++i){
          var wt = hw[i];
          ++rc[hw[i] = wt && mb + 1 - wt];
         }
         var
          hbuf = new u8(ts << 1),
          syms = hbuf.subarray(0, ts),
          nb = hbuf.subarray(ts);
         ri[mb] = 0;
         for(i = mb; i > 0; --i){
          var pv = ri[i];
          fill(nb, i, pv, ri[i - 1] = pv + rc[i] * (1 << mb - i));
         }
         if(ri[0] != ts) err(0);
         for(i = 0; i < wc; ++i){
          var bits = hw[i];
          if(bits){
           var code = ri[bits];
           fill(syms, i, code, ri[bits] = code + (1 << mb - bits));
          }
         }
         return [bt, {n: nb, b: mb, s: syms}];
        }
        var
         dllt =
           rfse
             (new
               u8
               ([81,
                 16,
                 99,
                 140,
                 49,
                 198,
                 24,
                 99,
                 12,
                 33,
                 196,
                 24,
                 99,
                 102,
                 102,
                 134,
                 70,
                 146,
                 4]),
              0,
              6)
            [1],
         dmlt =
           rfse
             (new
               u8
               ([33,
                 20,
                 196,
                 24,
                 99,
                 140,
                 33,
                 132,
                 16,
                 66,
                 8,
                 33,
                 132,
                 16,
                 66,
                 8,
                 33,
                 68,
                 68,
                 68,
                 68,
                 68,
                 68,
                 68,
                 68,
                 36,
                 9]),
              0,
              6)
            [1],
         doct =
           rfse
             (new u8([32, 132, 16, 66, 102, 70, 68, 68, 68, 68, 36, 73, 2]),
              0,
              5)
            [1];
        function b2bl(b, s){
         var len = b.length, bl = new i32(len);
         for(var i = 0; i < len; ++i){bl[i] = s; s += 1 << b[i];}
         return bl;
        }
        var
         llb =
           new
            u8
            (new
              i32
              ([0,
                0,
                0,
                0,
                16843009,
                50528770,
                134678020,
                202050057,
                269422093]).buffer,
             0,
             36),
         llbl = b2bl(llb, 0),
         mlb =
           new
            u8
            (new
              i32
              ([0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                16843009,
                50528770,
                117769220,
                185207048,
                252579084,
                16]).buffer,
             0,
             53),
         mlbl = b2bl(mlb, 3);
        function dhu(dat, out, hu){
         var
          len = dat.length,
          ss = out.length,
          lb = dat[len - 1],
          msk = (1 << hu.b) - 1,
          eb = - hu.b;
         if(! lb) err(0);
         var
          st = 0,
          btr = hu.b,
          pos = (len << 3) - 8 + msb(lb) - btr,
          i = - 1;
         for(; pos > eb && i < ss;){
          var
           cbt = pos >> 3,
           val =
             (dat[cbt] | dat[cbt + 1] << 8 | dat[cbt + 2] << 16) >> (pos & 7);
          st = (st << btr | val) & msk;
          out[++i] = hu.s[st];
          pos -= btr = hu.n[st];
         }
         if(pos != eb || i + 1 != ss) err(0);
        }
        function dhu4(dat, out, hu){
         var
          bt = 6,
          ss = out.length,
          sz1 = ss + 3 >> 2,
          sz2 = sz1 << 1,
          sz3 = sz1 + sz2;
         dhu
          (dat.subarray(bt, bt += dat[0] | dat[1] << 8),
           out.subarray(0, sz1),
           hu);
         dhu
          (dat.subarray(bt, bt += dat[2] | dat[3] << 8),
           out.subarray(sz1, sz2),
           hu);
         dhu
          (dat.subarray(bt, bt += dat[4] | dat[5] << 8),
           out.subarray(sz2, sz3),
           hu);
         dhu(dat.subarray(bt), out.subarray(sz3), hu);
        }
        function rzb(dat, st, out){
         var _a, bt = st.b, b0 = dat[bt], btype = b0 >> 1 & 3;
         st.l = b0 & 1;
         var
          sz = b0 >> 3 | dat[bt + 1] << 5 | dat[bt + 2] << 13,
          ebt = (bt += 3) + sz;
         if(btype == 1){
          if(bt >= dat.length) return;
          st.b = bt + 1;
          if(out){fill(out, dat[bt], st.y, st.y += sz); return out;}
          return fill(new u8(sz), dat[bt]);
         }
         if(ebt > dat.length) return;
         if(btype == 0){
          st.b = ebt;
          if(out){
           out.set(dat.subarray(bt, ebt), st.y);
           st.y += sz;
           return out;
          }
          return slc(dat, bt, ebt);
         }
         if(btype == 2){
          var
           b3 = dat[bt],
           lbt = b3 & 3,
           sf = b3 >> 2 & 3,
           lss = b3 >> 4,
           lcs = 0,
           s4 = 0;
          if(lbt < 2)
           if(sf & 1)
            lss |= dat[++bt] << 4 | (sf & 2 && dat[++bt] << 12);
           else
            lss = b3 >> 3;
          else{
           s4 = sf;
           if(sf < 2)
            lss |= (dat[++bt] & 63) << 4, lcs = dat[bt] >> 6 | dat[++bt] << 2;
           else if(sf == 2)
            lss |= dat[++bt] << 4 | (dat[++bt] & 3) << 12,
            lcs = dat[bt] >> 2 | dat[++bt] << 6;
           else
            lss |= dat[++bt] << 4 | (dat[++bt] & 63) << 12,
            lcs = dat[bt] >> 6 | dat[++bt] << 2 | dat[++bt] << 10;
          }
          ++bt;
          var
           buf = out ? out.subarray(st.y, st.y + st.m) : new u8(st.m),
           spl = buf.length - lss;
          if(lbt == 0)
           buf.set(dat.subarray(bt, bt += lss), spl);
          else if(lbt == 1)
           fill(buf, dat[bt++], spl);
          else{
           var hu = st.h;
           if(lbt == 2){
            var hud = rhu(dat, bt);
            lcs += bt - (bt = hud[0]);
            st.h = hu = hud[1];
           }
           else if(! hu) err(0);
           (s4 ? dhu4 : dhu)
            (dat.subarray(bt, bt += lcs), buf.subarray(spl), hu);
          }
          var ns = dat[bt++];
          if(ns){
           if(ns == 255)
            ns = (dat[bt++] | dat[bt++] << 8) + 0x7F00;
           else if(ns > 127) ns = ns - 128 << 8 | dat[bt++];
           var scm = dat[bt++];
           if(scm & 3) err(0);
           var dts = [dmlt, doct, dllt];
           for(var i = 2; i > - 1; --i){
            var md = scm >> (i << 1) + 2 & 3;
            if(md == 1){
             var rbuf = new u8([0, 0, dat[bt++]]);
             dts[i] =
              {s: rbuf.subarray(2, 3),
               n: rbuf.subarray(0, 1),
               t: new u16(rbuf.buffer, 0, 1),
               b: 0};
            }
            else if(md == 2)
             _a = rfse(dat, bt, 9 - (i & 1)), bt = _a[0], dts[i] = _a[1];
            else if(md == 3){if(! st.t) err(0); dts[i] = st.t[i];}
           }
           var
            _b = st.t = dts,
            mlt = _b[0],
            oct = _b[1],
            llt = _b[2],
            lb = dat[ebt - 1];
           if(! lb) err(0);
           var
            spos = (ebt << 3) - 8 + msb(lb) - llt.b,
            cbt = spos >> 3,
            oubt = 0,
            lst =
              (dat[cbt] | dat[cbt + 1] << 8) >> (spos & 7) & (1 << llt.b) - 1;
           cbt = (spos -= oct.b) >> 3;
           var
            ost =
              (dat[cbt] | dat[cbt + 1] << 8) >> (spos & 7) & (1 << oct.b) - 1;
           cbt = (spos -= mlt.b) >> 3;
           var
            mst =
              (dat[cbt] | dat[cbt + 1] << 8) >> (spos & 7) & (1 << mlt.b) - 1;
           for(++ns; --ns;){
            var
             llc = llt.s[lst],
             lbtr = llt.n[lst],
             mlc = mlt.s[mst],
             mbtr = mlt.n[mst],
             ofc = oct.s[ost],
             obtr = oct.n[ost];
            cbt = (spos -= ofc) >> 3;
            var
             ofp = 1 << ofc,
             off =
               ofp
               +
                ((dat[cbt] | dat[cbt + 1] << 8 | dat[cbt + 2] << 16
                | dat[cbt + 3] << 24)
                >>> (spos & 7)
                & ofp - 1);
            cbt = (spos -= mlb[mlc]) >> 3;
            var
             ml =
               mlbl[mlc]
               +
                ((dat[cbt] | dat[cbt + 1] << 8 | dat[cbt + 2] << 16)
                >> (spos & 7)
                & (1 << mlb[mlc]) - 1);
            cbt = (spos -= llb[llc]) >> 3;
            var
             ll =
               llbl[llc]
               +
                ((dat[cbt] | dat[cbt + 1] << 8 | dat[cbt + 2] << 16)
                >> (spos & 7)
                & (1 << llb[llc]) - 1);
            cbt = (spos -= lbtr) >> 3;
            lst =
             llt.t[lst]
             +
              ((dat[cbt] | dat[cbt + 1] << 8) >> (spos & 7) & (1 << lbtr) - 1);
            cbt = (spos -= mbtr) >> 3;
            mst =
             mlt.t[mst]
             +
              ((dat[cbt] | dat[cbt + 1] << 8) >> (spos & 7) & (1 << mbtr) - 1);
            cbt = (spos -= obtr) >> 3;
            ost =
             oct.t[ost]
             +
              ((dat[cbt] | dat[cbt + 1] << 8) >> (spos & 7) & (1 << obtr) - 1);
            if(off > 3){
             st.o[2] = st.o[1];
             st.o[1] = st.o[0];
             st.o[0] = off -= 3;
            }
            else{
             var idx = off - (ll != 0);
             if(idx){
              off = idx == 3 ? st.o[0] - 1 : st.o[idx];
              if(idx > 1) st.o[2] = st.o[1];
              st.o[1] = st.o[0];
              st.o[0] = off;
             }
             else
              off = st.o[0];
            }
            for(var i = 0; i < ll; ++i) buf[oubt + i] = buf[spl + i];
            oubt += ll, spl += ll;
            var stin = oubt - off;
            if(stin < 0){
             var len = - stin, bs = st.e + stin;
             if(len > ml) len = ml;
             for(var i = 0; i < len; ++i) buf[oubt + i] = st.w[bs + i];
             oubt += len, ml -= len, stin = 0;
            }
            for(var i = 0; i < ml; ++i) buf[oubt + i] = buf[stin + i];
            oubt += ml;
           }
           if(oubt != spl)
            while(spl < buf.length) buf[oubt++] = buf[spl++];
           else
            oubt = buf.length;
           if(out) st.y += oubt; else buf = slc(buf, 0, oubt);
          }
          else if(out){
           st.y += lss;
           if(spl) for(var i = 0; i < lss; ++i) buf[i] = buf[spl + i];
          }
          else if(spl) buf = slc(buf, spl);
          st.b = ebt;
          return buf;
         }
         err(2);
        }
        function cct(bufs, ol){
         if(bufs.length == 1) return bufs[0];
         var buf = new u8(ol);
         for(var i = 0, b = 0; i < bufs.length; ++i){
          var chk = bufs[i];
          buf.set(chk, b);
          b += chk.length;
         }
         return buf;
        }
        return function(dat, buf){
         var bt = 0, bufs = [], nb = + ! buf, ol = 0;
         for(; dat.length;){
          var st = rzfh(dat, nb || buf);
          if(typeof st == "object"){
           if(nb){
            buf = null;
            if(st.w.length == st.u){bufs.push(buf = st.w); ol += st.u;}
           }
           else{bufs.push(buf); st.e = 0;}
           for(; ! st.l;){
            var blk = rzb(dat, st, buf);
            if(! blk) err(5);
            if(buf)
             st.e = st.y;
            else{
             bufs.push(blk);
             ol += blk.length;
             cpw(st.w, 0, blk.length);
             st.w.set(blk, st.w.length - blk.length);
            }
           }
           bt = st.b + st.c * 4;
          }
          else
           bt = st;
          dat = dat.subarray(bt);
         }
         return cct(bufs, ol);};
       }
       ();
   function caml_zstd_initialize(unit){
    caml_decompress_input = zstd_decompress;
    return 1;
   }
   function caml_output_value_to_buffer(s, ofs, len, v, flags){
    var t = caml_output_val(v, flags);
    if(t.length > len) caml_failwith("Marshal.to_buffer: buffer overflow");
    caml_blit_bytes(t, 0, s, ofs, t.length);
    return 0;
   }
   function re_replacement_text(repl, groups, orig){
    var
     repl = caml_jsbytes_of_string(repl),
     len = repl.length,
     orig = caml_jsbytes_of_string(orig),
     res = "",
     n = 0,
     cur,
     start,
     end,
     c;
    while(n < len){
     cur = repl.charAt(n++);
     if(cur != "\\")
      res += cur;
     else{
      if(n == len) caml_failwith("Str.replace: illegal backslash sequence");
      cur = repl.charAt(n++);
      switch(cur){
        case "\\":
         res += cur; break;
        case "0":
        case "1":
        case "2":
        case "3":
        case "4":
        case "5":
        case "6":
        case "7":
        case "8":
        case "9":
         c = + cur;
         if(c * 2 >= groups.length - 1)
          caml_failwith("Str.replace: reference to unmatched group");
         start = caml_array_get(groups, c * 2);
         end = caml_array_get(groups, c * 2 + 1);
         if(start == - 1)
          caml_failwith("Str.replace: reference to unmatched group");
         res += orig.slice(start, end);
         break;
        default: res += "\\" + cur;
      }
     }
    }
    return caml_string_of_jsbytes(res);
   }
   function caml_pure_js_expr(s){
    console.error("caml_pure_js_expr: fallback to runtime evaluation\n");
    return eval(caml_jsstring_of_string(s));
   }
   function caml_blit_string(a, b, c, d, e){
    caml_blit_bytes(caml_bytes_of_string(a), b, c, d, e);
    return 0;
   }
   function blit_nat(nat1, ofs1, nat2, ofs2, len){
    for(var i = 0; i < len; i++) nat1.data[ofs1 + i] = nat2.data[ofs2 + i];
    return 0;
   }
   function caml_bigstring_blit_ba_to_bytes(ba1, pos1, bytes2, pos2, len){
    if(12 != ba1.kind)
     caml_invalid_argument("caml_bigstring_blit_string_to_ba: kind mismatch");
    if(len == 0) return 0;
    var ofs1 = ba1.offset(pos1);
    if(ofs1 + len > ba1.data.length) caml_array_bound_error();
    if(pos2 + len > caml_ml_bytes_length(bytes2)) caml_array_bound_error();
    var slice = ba1.data.slice(ofs1, ofs1 + len);
    caml_blit_bytes(caml_bytes_of_array(slice), 0, bytes2, pos2, len);
    return 0;
   }
   function caml_unix_stat(name){
    var root = resolve_fs_device(name);
    if(! root.device.stat) caml_failwith("caml_unix_stat: not implemented");
    return root.device.stat(root.rest, true);
   }
   function caml_register_named_value(nm, v){
    caml_named_values[caml_jsbytes_of_string(nm)] = v;
    return 0;
   }
   function jsoo_create_file_extern(name, content){
    if(globalThis.jsoo_create_file)
     globalThis.jsoo_create_file(name, content);
    else{
     if(! globalThis.caml_fs_tmp) globalThis.caml_fs_tmp = [];
     globalThis.caml_fs_tmp.push({name: name, content: content});
    }
    return 0;
   }
   function caml_unix_stat_64(name){
    var r = caml_unix_stat(name);
    r[9] = caml_int64_of_int32(r[9]);
    return r;
   }
   function caml_to_js_string(s){return caml_jsstring_of_string(s);}
   function caml_ml_mutex_lock(t){
    if(t.locked)
     caml_failwith("Mutex.lock: mutex already locked. Cannot wait.");
    else
     t.locked = true;
    return 0;
   }
   function re_search_forward(re, s, pos){
    if(pos < 0 || pos > caml_ml_string_length(s))
     caml_invalid_argument("Str.search_forward");
    while(pos <= caml_ml_string_length(s)){
     var res = re_match(re, s, pos, 0);
     if(res) return res;
     pos++;
    }
    return [0];
   }
   function caml_make_vect(len, init){
    if(len < 0) caml_array_bound_error();
    var len = len + 1 | 0, b = new Array(len);
    b[0] = 0;
    for(var i = 1; i < len; i++) b[i] = init;
    return b;
   }
   function caml_ml_seek_in(chanid, pos){return caml_seek_in(chanid, pos);}
   function caml_sys_read_directory(name){
    var
     root = resolve_fs_device(name),
     a = root.device.readdir(root.rest),
     l = new Array(a.length + 1);
    l[0] = 0;
    for(var i = 0; i < a.length; i++) l[i + 1] = caml_string_of_jsbytes(a[i]);
    return l;
   }
   function caml_ml_output_char(chanid, c){
    var s = caml_string_of_jsbytes(String.fromCharCode(c));
    caml_ml_output(chanid, s, 0, 1);
    return 0;
   }
   function caml_sys_const_ostype_win32(){return os_type == "Win32" ? 1 : 0;}
   function caml_obj_is_block(x){return + (x instanceof Array);}
   function caml_obj_set_raw_field(o, i, v){return o[i + 1] = v;}
   function caml_js_var(x){
    var x = caml_jsstring_of_string(x);
    if(! x.match(/^[a-zA-Z_$][a-zA-Z_$0-9]*(\.[a-zA-Z_$][a-zA-Z_$0-9]*)*$/))
     console.error
      ('caml_js_var: "' + x
       + '" is not a valid JavaScript variable. continuing ..');
    return eval(x);
   }
   function caml_trunc_float(x){return Math.trunc(x);}
   function caml_ephe_unset_data(x){
    if(globalThis.FinalizationRegistry && globalThis.WeakRef)
     if(x[1] instanceof globalThis.FinalizationRegistry)
      for(var j = caml_ephe_key_offset; j < x.length; j++){
       var key = x[j];
       if(key instanceof globalThis.WeakRef){
        key = key.deref();
        if(key) x[1].unregister(key);
       }
      }
    x[caml_ephe_data_offset] = undefined;
    return 0;
   }
   function caml_ephe_set_data(x, data){
    if(globalThis.FinalizationRegistry && globalThis.WeakRef)
     if(! (x[1] instanceof globalThis.FinalizationRegistry)){
      x[1] =
       new
        globalThis.FinalizationRegistry
        (function(){caml_ephe_unset_data(x);});
      for(var j = caml_ephe_key_offset; j < x.length; j++){
       var key = x[j];
       if(key instanceof globalThis.WeakRef){
        key = key.deref();
        if(key) x[1].register(key, undefined, key);
       }
      }
     }
    x[caml_ephe_data_offset] = data;
    return 0;
   }
   function caml_ephe_blit_data(src, dst){
    var n = src[caml_ephe_data_offset];
    if(n === undefined)
     caml_ephe_unset_data(dst);
    else
     caml_ephe_set_data(dst, n);
    return 0;
   }
   function length_nat(x){return x.data.length;}
   function caml_is_printable(c){return + (c > 31 && c < 127);}
   function caml_bytes_lessequal(s1, s2){
    s1.t & 6 && caml_convert_string_to_bytes(s1);
    s2.t & 6 && caml_convert_string_to_bytes(s2);
    return s1.c <= s2.c ? 1 : 0;
   }
   function caml_array_of_bytes(x){return caml_uint8_array_of_bytes(x);}
   function caml_equal(x, y){return + (caml_compare_val(x, y, false) == 0);}
   function re_partial_match(re, s, pos){
    if(pos < 0 || pos > caml_ml_string_length(s))
     caml_invalid_argument("Str.partial_match");
    var res = re_match(re, s, pos, 1);
    return res ? res : [0];
   }
   function caml_sys_random_seed(){
    if(globalThis.crypto)
     if(globalThis.crypto.getRandomValues){
      var a = globalThis.crypto.getRandomValues(new Int32Array(4));
      return [0, a[0], a[1], a[2], a[3]];
     }
     else if(globalThis.crypto.randomBytes){
      var a = new Int32Array(globalThis.crypto.randomBytes(16).buffer);
      return [0, a[0], a[1], a[2], a[3]];
     }
    var now = new Date().getTime(), x = now ^ 0xffffffff * Math.random();
    return [0, x];
   }
   var all_finalizers = new globalThis.Set();
   function caml_final_register_called_without_value(cb, a){
    if(globalThis.FinalizationRegistry && a instanceof Object){
     var
      x =
        new
         globalThis.FinalizationRegistry
         (function(x){all_finalizers.delete(x); cb(0); return;});
     x.register(a, x);
     all_finalizers.add(x);
    }
    return 0;
   }
   function caml_ba_get_2(ba, i0, i1){return ba.get(ba.offset([i0, i1]));}
   function caml_ba_uint8_set16(ba, i0, v){
    var ofs = ba.offset(i0);
    if(ofs + 1 >= ba.data.length) caml_array_bound_error();
    ba.set(ofs + 0, v & 0xff);
    ba.set(ofs + 1, v >>> 8 & 0xff);
    return 0;
   }
   function caml_lazy_reset_to_lazy(o){
    caml_obj_update_tag(o, 244, 246);
    return 0;
   }
   function caml_js_delete(o, f){delete o[f]; return 0;}
   function caml_int_of_string(s){
    var
     r = caml_parse_sign_and_base(s),
     i = r[0],
     sign = r[1],
     base = r[2],
     len = caml_ml_string_length(s),
     threshold = - 1 >>> 0,
     c = i < len ? caml_string_unsafe_get(s, i) : 0,
     d = caml_parse_digit(c);
    if(d < 0 || d >= base) caml_failwith("int_of_string");
    var res = d;
    for(i++; i < len; i++){
     c = caml_string_unsafe_get(s, i);
     if(c == 95) continue;
     d = caml_parse_digit(c);
     if(d < 0 || d >= base) break;
     res = base * res + d;
     if(res > threshold) caml_failwith("int_of_string");
    }
    if(i != len) caml_failwith("int_of_string");
    res = sign * res;
    if(base == 10 && (res | 0) != res) caml_failwith("int_of_string");
    return res | 0;
   }
   function caml_list_mount_point(){
    var prev = 0;
    for(var i = 0; i < jsoo_mount_point.length; i++){
     var old = prev;
     prev = [0, caml_string_of_jsbytes(jsoo_mount_point[i].path), old];
    }
    return prev;
   }
   var
    caml_marshal_constants =
      {PREFIX_SMALL_BLOCK: 0x80,
       PREFIX_SMALL_INT: 0x40,
       PREFIX_SMALL_STRING: 0x20,
       CODE_INT8: 0x00,
       CODE_INT16: 0x01,
       CODE_INT32: 0x02,
       CODE_INT64: 0x03,
       CODE_SHARED8: 0x04,
       CODE_SHARED16: 0x05,
       CODE_SHARED32: 0x06,
       CODE_BLOCK32: 0x08,
       CODE_BLOCK64: 0x13,
       CODE_STRING8: 0x09,
       CODE_STRING32: 0x0A,
       CODE_DOUBLE_BIG: 0x0B,
       CODE_DOUBLE_LITTLE: 0x0C,
       CODE_DOUBLE_ARRAY8_BIG: 0x0D,
       CODE_DOUBLE_ARRAY8_LITTLE: 0x0E,
       CODE_DOUBLE_ARRAY32_BIG: 0x0F,
       CODE_DOUBLE_ARRAY32_LITTLE: 0x07,
       CODE_CODEPOINTER: 0x10,
       CODE_INFIXPOINTER: 0x11,
       CODE_CUSTOM: 0x12,
       CODE_CUSTOM_LEN: 0x18,
       CODE_CUSTOM_FIXED: 0x19};
   function caml_obj_raw_field(o, i){return o[i + 1];}
   function caml_js_equals(x, y){return + (x == y);}
   function caml_obj_compare_and_swap(x, i, old, n){
    if(x[i + 1] == old){x[i + 1] = n; return 1;}
    return 0;
   }
   function bigstring_to_typed_array(bs){return bs.data;}
   function caml_gr_arc_aux(ctx, cx, cy, ry, rx, a1, a2){
    while(a1 > a2) a2 += 360;
    a1 /= 180;
    a2 /= 180;
    var
     rot = 0,
     xPos,
     yPos,
     xPos_prev,
     yPos_prev,
     space = 2,
     num = (a2 - a1) * Math.PI * ((rx + ry) / 2) / space | 0,
     delta = (a2 - a1) * Math.PI / num,
     i = a1 * Math.PI;
    for(var j = 0; j <= num; j++){
     xPos =
      cx - rx * Math.sin(i) * Math.sin(rot * Math.PI)
      + ry * Math.cos(i) * Math.cos(rot * Math.PI);
     xPos = xPos.toFixed(2);
     yPos =
      cy + ry * Math.cos(i) * Math.sin(rot * Math.PI)
      + rx * Math.sin(i) * Math.cos(rot * Math.PI);
     yPos = yPos.toFixed(2);
     if(j == 0)
      ctx.moveTo(xPos, yPos);
     else if(xPos_prev != xPos || yPos_prev != yPos) ctx.lineTo(xPos, yPos);
     xPos_prev = xPos;
     yPos_prev = yPos;
     i -= delta;
    }
    return 0;
   }
   function caml_gr_fill_arc(x, y, rx, ry, a1, a2){
    var s = caml_gr_state_get();
    s.context.beginPath();
    caml_gr_arc_aux(s.context, x, s.height - y, rx, ry, a1, a2);
    s.context.fill();
    return 0;
   }
   function caml_ba_slice(ba, vind){
    vind = caml_js_from_array(vind);
    var num_inds = vind.length, index = [], sub_dims = [], ofs;
    if(num_inds > ba.dims.length)
     caml_invalid_argument("Bigarray.slice: too many indices");
    if(ba.layout == 0){
     for(var i = 0; i < num_inds; i++) index[i] = vind[i];
     for(; i < ba.dims.length; i++) index[i] = 0;
     sub_dims = ba.dims.slice(num_inds);
    }
    else{
     for(var i = 0; i < num_inds; i++)
      index[ba.dims.length - num_inds + i] = vind[i];
     for(var i = 0; i < ba.dims.length - num_inds; i++) index[i] = 1;
     sub_dims = ba.dims.slice(0, ba.dims.length - num_inds);
    }
    ofs = ba.offset(index);
    var
     size = caml_ba_get_size(sub_dims),
     size_per_element = caml_ba_get_size_per_element(ba.kind),
     new_data =
       ba.data.subarray
        (ofs * size_per_element, (ofs + size) * size_per_element);
    return caml_ba_create_unsafe(ba.kind, ba.layout, sub_dims, new_data);
   }
   function caml_js_wrap_callback_unsafe(f){
    return function(){
     var len = caml_js_function_arity(f), args = new Array(len);
     for(var i = 0; i < len; i++) args[i] = arguments[i];
     return caml_callback(f, args);};
   }
   function caml_ba_kind(ba){return ba.kind;}
   function caml_alloc_dummy_infix(){
    return function f(x){return caml_call_gen(f.fun, [x]);};
   }
   function caml_js_strict_equals(x, y){return + (x === y);}
   function caml_js_fun_call(f, a){
    switch(a.length){
      case 1:
       return f();
      case 2:
       return f(a[1]);
      case 3:
       return f(a[1], a[2]);
      case 4:
       return f(a[1], a[2], a[3]);
      case 5:
       return f(a[1], a[2], a[3], a[4]);
      case 6:
       return f(a[1], a[2], a[3], a[4], a[5]);
      case 7:
       return f(a[1], a[2], a[3], a[4], a[5], a[6]);
      case 8:
       return f(a[1], a[2], a[3], a[4], a[5], a[6], a[7]);
    }
    return f.apply(null, caml_js_from_array(a));
   }
   function caml_gc_major_slice(work){return 0;}
   function caml_js_pure_expr(f){return caml_callback(f, [0]);}
   function compare_digits_nat(nat1, ofs1, nat2, ofs2){
    if(nat1.data[ofs1] > nat2.data[ofs2]) return 1;
    if(nat1.data[ofs1] < nat2.data[ofs2]) return - 1;
    return 0;
   }
   function caml_ml_input(chanid, b, i, l){
    var ba = caml_uint8_array_of_bytes(b);
    return caml_ml_input_block(chanid, ba, i, l);
   }
   function caml_gr_wait_event(_evl){
    caml_failwith
     ("caml_gr_wait_event not Implemented: use Graphics_js instead");
   }
   function caml_gr_sigio_handler(){return 0;}
   function caml_memprof_discard(t){return 0;}
   function caml_hash_mix_bigstring(h, bs){
    return caml_hash_mix_bytes_arr(h, bs.data);
   }
   function caml_record_backtrace(b){
    caml_record_backtrace_flag = b;
    return 0;
   }
   function caml_unix_cleanup(){}
   function caml_sys_get_config(){
    return [0, caml_string_of_jsbytes(os_type), 32, 0];
   }
   function caml_sys_const_backend_type(){
    return [0, caml_string_of_jsbytes("js_of_ocaml")];
   }
   function caml_obj_is_shared(x){return 1;}
   function caml_ml_out_channels_list(){
    var l = 0;
    for(var c = 0; c < caml_ml_channels.length; c++)
     if
      (caml_ml_channels[c] && caml_ml_channels[c].opened
       && caml_ml_channels[c].out)
      l = [0, caml_ml_channels[c].fd, l];
    return l;
   }
   function caml_asinh_float(x){return Math.asinh(x);}
   function caml_pos_out(chanid){
    var chan = caml_ml_channels[chanid];
    return chan.offset + chan.buffer_curr;
   }
   function bigstring_of_array_buffer(ab){
    var ta = new Uint8Array(ab);
    return caml_ba_create_unsafe(12, 0, [ta.length], ta);
   }
   function caml_mod(x, y){if(y == 0) caml_raise_zero_divide(); return x % y;}
   function caml_ba_init(){return 0;}
   function caml_unix_filedescr_of_fd(x){return x;}
   function re_string_match(re, s, pos){
    if(pos < 0 || pos > caml_ml_string_length(s))
     caml_invalid_argument("Str.string_match");
    var res = re_match(re, s, pos, 0);
    return res ? res : [0];
   }
   function BigStringReader(bs, i){this.s = bs; this.i = i;}
   BigStringReader.prototype =
    {read8u: function(){return caml_ba_get_1(this.s, this.i++);},
     read8s: function(){return caml_ba_get_1(this.s, this.i++) << 24 >> 24;},
     read16u:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 2;
      return caml_ba_get_1(s, i) << 8 | caml_ba_get_1(s, i + 1);
     },
     read16s:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 2;
      return caml_ba_get_1(s, i) << 24 >> 16 | caml_ba_get_1(s, i + 1);
     },
     read32u:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 4;
      return (caml_ba_get_1(s, i) << 24 | caml_ba_get_1(s, i + 1) << 16
             | caml_ba_get_1(s, i + 2) << 8
             | caml_ba_get_1(s, i + 3))
             >>> 0;
     },
     read32s:
     function(){
      var s = this.s, i = this.i;
      this.i = i + 4;
      return caml_ba_get_1(s, i) << 24 | caml_ba_get_1(s, i + 1) << 16
             | caml_ba_get_1(s, i + 2) << 8
             | caml_ba_get_1(s, i + 3);
     },
     readstr:
     function(len){
      var i = this.i, arr = new Array(len);
      for(var j = 0; j < len; j++) arr[j] = caml_ba_get_1(this.s, i + j);
      this.i = i + len;
      return caml_string_of_array(arr);
     },
     readuint8array:
     function(len){
      var i = this.i, offset = this.offset(i);
      this.i = i + len;
      return this.s.data.subarray(offset, offset + len);
     }};
   function caml_gr_dump_image(im){
    var data = [0];
    for(var i = 0; i < im.height; i++){
     data[i + 1] = [0];
     for(var j = 0; j < im.width; j++){
      var
       o = i * (im.width * 4) + j * 4,
       r = im.data[o + 0],
       g = im.data[o + 1],
       b = im.data[o + 2];
      data[i + 1][j + 1] = (r << 16) + (g << 8) + b;
     }
    }
    return data;
   }
   function caml_ba_get_generic(ba, i){
    var ofs = ba.offset(caml_js_from_array(i));
    return ba.get(ofs);
   }
   function caml_unix_startup(){}
   function caml_get_exception_backtrace(){return 0;}
   function caml_format_float(fmt, x){
    function toFixed(x, dp){
     if(Math.abs(x) < 1.0)
      return x.toFixed(dp);
     else{
      var e = parseInt(x.toString().split("+")[1]);
      if(e > 20){
       e -= 20;
       x /= Math.pow(10, e);
       x += new Array(e + 1).join("0");
       if(dp > 0) x = x + "." + new Array(dp + 1).join("0");
       return x;
      }
      else
       return x.toFixed(dp);
     }
    }
    var s, f = caml_parse_format(fmt), prec = f.prec < 0 ? 6 : f.prec;
    if(x < 0 || x == 0 && 1 / x == - Infinity){f.sign = - 1; x = - x;}
    if(isNaN(x)){
     s = "nan";
     f.filler = " ";
    }
    else if(! isFinite(x)){
     s = "inf";
     f.filler = " ";
    }
    else
     switch(f.conv){
       case "e":
        var s = x.toExponential(prec), i = s.length;
        if(s.charAt(i - 3) == "e")
         s = s.slice(0, i - 1) + "0" + s.slice(i - 1);
        break;
       case "f":
        s = toFixed(x, prec); break;
       case "g":
        prec = prec ? prec : 1;
        s = x.toExponential(prec - 1);
        var j = s.indexOf("e"), exp = + s.slice(j + 1);
        if(exp < - 4 || x >= 1e21 || x.toFixed(0).length > prec){
         var i = j - 1;
         while(s.charAt(i) == "0") i--;
         if(s.charAt(i) == ".") i--;
         s = s.slice(0, i + 1) + s.slice(j);
         i = s.length;
         if(s.charAt(i - 3) == "e")
          s = s.slice(0, i - 1) + "0" + s.slice(i - 1);
         break;
        }
        else{
         var p = prec;
         if(exp < 0){
          p -= exp + 1;
          s = x.toFixed(p);
         }
         else
          while(s = x.toFixed(p), s.length > prec + 1) p--;
         if(p){
          var i = s.length - 1;
          while(s.charAt(i) == "0") i--;
          if(s.charAt(i) == ".") i--;
          s = s.slice(0, i + 1);
         }
        }
        break;
     }
    return caml_finish_formatting(f, s);
   }
   function caml_mount_autoload(name, f){
    var
     path = caml_make_path(name),
     name = caml_trailing_slash(path.join("/"));
    jsoo_mount_point.push({path: name, device: new MlFakeDevice(name, f)});
    return 0;
   }
   function caml_string_lessthan(s1, s2){return s1 < s2 ? 1 : 0;}
   function caml_string_greaterthan(s1, s2){return caml_string_lessthan(s2, s1);
   }
   function caml_div(x, y){
    if(y == 0) caml_raise_zero_divide();
    return x / y | 0;
   }
   function caml_obj_dup(x){
    var l = x.length, a = new Array(l);
    for(var i = 0; i < l; i++) a[i] = x[i];
    return a;
   }
   function caml_ephe_get_data_copy(x){
    return x[caml_ephe_data_offset] === undefined
            ? 0
            : [0, caml_obj_dup(x[caml_ephe_data_offset])];
   }
   function caml_memprof_start(rate, stack_size, tracker){return 0;}
   function caml_sys_get_argv(a){return [0, caml_argv[1], caml_argv];}
   function caml_ml_domain_set_name(_name){return 0;}
   function caml_js_to_bool(x){return + x;}
   function caml_gr_create_image(x, y){
    var s = caml_gr_state_get();
    return s.context.createImageData(x, y);
   }
   function caml_ephe_get_key_copy(x, i){
    if(i < 0 || caml_ephe_key_offset + i >= x.length)
     caml_invalid_argument("Weak.get_copy");
    var y = caml_ephe_get_key(x, i);
    if(y === 0) return y;
    var z = y[1];
    if(z instanceof Array) return [0, caml_obj_dup(z)];
    return y;
   }
   function caml_lessthan(x, y){return + (caml_compare_val(x, y, false) < 0);}
   function caml_raw_backtrace_next_slot(){return 0;}
   function caml_build_symbols(symb){
    var r = {};
    if(symb)
     for(var i = 1; i < symb.length; i++)
      r[caml_jsstring_of_string(symb[i][1])] = symb[i][2];
    return r;
   }
   function caml_register_global(n, v, name_opt){
    if(name_opt){
     var name = name_opt;
     if(globalThis.toplevelReloc)
      n = caml_callback(globalThis.toplevelReloc, [name]);
     else if(caml_global_data.symbols){
      if(! caml_global_data.symidx)
       caml_global_data.symidx = caml_build_symbols(caml_global_data.symbols);
      var nid = caml_global_data.symidx[name];
      if(nid >= 0)
       n = nid;
      else
       caml_failwith("caml_register_global: cannot locate " + name);
     }
    }
    caml_global_data[n + 1] = v;
    if(name_opt) caml_global_data[name_opt] = v;
   }
   function mult_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat3, ofs3, len3){
    var carry = 0;
    for(var i = 0; i < len3; i++)
     carry +=
      mult_digit_nat
       (nat1, ofs1 + i, len1 - i, nat2, ofs2, len2, nat3, ofs3 + i);
    return carry;
   }
   function square_nat(nat1, ofs1, len1, nat2, ofs2, len2){
    var carry = 0;
    carry += add_nat(nat1, ofs1, len1, nat1, ofs1, len1, 0);
    carry += mult_nat(nat1, ofs1, len1, nat2, ofs2, len2, nat2, ofs2, len2);
    return carry;
   }
   function caml_js_from_float(x){return x;}
   function caml_floatarray_create(len){
    if(len < 0) caml_array_bound_error();
    var len = len + 1 | 0, b = new Array(len);
    b[0] = 254;
    for(var i = 1; i < len; i++) b[i] = 0;
    return b;
   }
   function caml_gc_stat(){return caml_gc_quick_stat();}
   function caml_get_major_credit(n){return 0;}
   function caml_ml_open_descriptor_in(fd){
    var file = caml_sys_fds[fd];
    if(file.flags.wronly) caml_raise_sys_error("fd " + fd + " is writeonly");
    var
     refill = null,
     channel =
       {file: file,
        offset: file.flags.append ? file.length() : 0,
        fd: fd,
        opened: true,
        out: false,
        buffer_curr: 0,
        buffer_max: 0,
        buffer: new Uint8Array(65536),
        refill: refill};
    caml_ml_channels[channel.fd] = channel;
    return channel.fd;
   }
   function caml_ml_open_descriptor_in_with_flags(fd, flags){return caml_ml_open_descriptor_in(fd);
   }
   function caml_sys_modify_argv(arg){caml_argv = arg; return 0;}
   var caml_method_cache = [];
   function caml_get_public_method(obj, tag, cacheid){
    var meths = obj[1], ofs = caml_method_cache[cacheid];
    if(ofs === undefined)
     for(var i = caml_method_cache.length; i < cacheid; i++)
      caml_method_cache[i] = 0;
    else if(meths[ofs] === tag) return meths[ofs - 1];
    var li = 3, hi = meths[1] * 2 + 1, mi;
    while(li < hi){
     mi = li + hi >> 1 | 1;
     if(tag < meths[mi + 1]) hi = mi - 2; else li = mi;
    }
    caml_method_cache[cacheid] = li + 1;
    return tag == meths[li + 1] ? meths[li] : 0;
   }
   function caml_js_get_console(){
    var
     c = console,
     m =
       ["log",
        "debug",
        "info",
        "warn",
        "error",
        "assert",
        "dir",
        "dirxml",
        "trace",
        "group",
        "groupCollapsed",
        "groupEnd",
        "time",
        "timeEnd"];
    function f(){}
    for(var i = 0; i < m.length; i++) if(! c[m[i]]) c[m[i]] = f;
    return c;
   }
   function caml_sys_unsafe_getenv(name){return caml_sys_getenv(name);}
   function bigstring_of_typed_array(ba){
    var
     ta =
       new
        Uint8Array
        (ba.buffer, ba.byteOffset, ba.length * ba.BYTES_PER_ELEMENT);
    return caml_ba_create_unsafe(12, 0, [ta.length], ta);
   }
   function caml_round_float(x){
    if(x >= 0){
     var y = Math.floor(x);
     return x - y >= 0.5 ? y + 1 : y;
    }
    else{var y = Math.ceil(x); return y - x >= 0.5 ? y - 1 : y;}
   }
   function caml_ojs_new_arr(c, a){
    switch(a.length){
      case 0:
       return new c;
      case 1:
       return new c(a[0]);
      case 2:
       return new c(a[0], a[1]);
      case 3:
       return new c(a[0], a[1], a[2]);
      case 4:
       return new c(a[0], a[1], a[2], a[3]);
      case 5:
       return new c(a[0], a[1], a[2], a[3], a[4]);
      case 6:
       return new c(a[0], a[1], a[2], a[3], a[4], a[5]);
      case 7:
       return new c(a[0], a[1], a[2], a[3], a[4], a[5], a[6]);
    }
    function F(){return c.apply(this, a);}
    F.prototype = c.prototype;
    return new F;
   }
   function complement_nat(nat, ofs, len){
    for(var i = 0; i < len; i++)
     nat.data[ofs + i] = (- 1 >>> 0) - (nat.data[ofs + i] >>> 0);
   }
   var caml_domain_dls = [0];
   function caml_domain_dls_set(a){caml_domain_dls = a;}
   function caml_obj_tag(x){
    if(x instanceof Array && x[0] == x[0] >>> 0)
     return x[0];
    else if(caml_is_ml_bytes(x))
     return 252;
    else if(caml_is_ml_string(x))
     return 252;
    else if(x instanceof Function || typeof x == "function")
     return 247;
    else if(x && x.caml_custom) return 255; else return 1000;
   }
   function caml_lazy_read_result(o){
    return caml_obj_tag(o) == 250 ? o[1] : o;
   }
   var caml_js_regexps = {amp: /&/g, lt: /</g, quot: /\"/g, all: /[&<\"]/};
   function caml_js_html_escape(s){
    if(! caml_js_regexps.all.test(s)) return s;
    return s.replace(caml_js_regexps.amp, "&amp;").replace
             (caml_js_regexps.lt, "&lt;").replace
            (caml_js_regexps.quot, "&quot;");
   }
   function caml_ba_dim_2(ba){return caml_ba_dim(ba, 1);}
   function caml_js_wrap_meth_callback_arguments(f){
    return function(){
     var len = arguments.length, args = new Array(len);
     for(var i = 0; i < len; i++) args[i] = arguments[i];
     return caml_callback(f, [this, args]);};
   }
   function caml_sinh_float(x){return Math.sinh(x);}
   function caml_ldexp_float(x, exp){
    exp |= 0;
    if(exp > 1023){
     exp -= 1023;
     x *= Math.pow(2, 1023);
     if(exp > 1023){exp -= 1023; x *= Math.pow(2, 1023);}
    }
    if(exp < - 1023){exp += 1023; x *= Math.pow(2, - 1023);}
    x *= Math.pow(2, exp);
    return x;
   }
   function caml_gr_state_set(ctx){
    caml_gr_state = ctx;
    caml_gr_state_init();
    return 0;
   }
   function caml_js_wrap_callback_strict(arity, f){
    return function(){
     var
      n = arguments.length,
      args = new Array(arity),
      len = Math.min(arguments.length, arity);
     for(var i = 0; i < len; i++) args[i] = arguments[i];
     return caml_callback(f, args);};
   }
   function caml_gc_minor_words(unit){return 0;}
   function caml_get_current_callstack(){return [0];}
   function land_digit_nat(nat1, ofs1, nat2, ofs2){nat1.data[ofs1] &= nat2.data[ofs2]; return 0;
   }
   function caml_int64_mod(x, y){return x.mod(y);}
   function caml_obj_set_tag(x, tag){x[0] = tag; return 0;}
   function caml_int32_bswap(x){
    return (x & 0x000000FF) << 24 | (x & 0x0000FF00) << 8
           | (x & 0x00FF0000) >>> 8
           | (x & 0xFF000000) >>> 24;
   }
   function caml_ba_set_3(ba, i0, i1, i2, v){
    ba.set(ba.offset([i0, i1, i2]), v);
    return 0;
   }
   function caml_js_instanceof(o, c){return o instanceof c ? 1 : 0;}
   function caml_get_major_bucket(n){return 0;}
   function nth_digit_nat_native(nat, ofs){return nat.data[ofs];}
   function set_digit_nat_native(nat, ofs, digit){nat.data[ofs] = digit; return 0;
   }
   function caml_string_set64(s, i, i64){caml_failwith("caml_string_set64");}
   function caml_gr_state_create(canvas, w, h){
    var context = canvas.getContext("2d");
    return {context: context,
            canvas: canvas,
            x: 0,
            y: 0,
            width: w,
            height: h,
            line_width: 1,
            font: caml_string_of_jsbytes("fixed"),
            text_size: 26,
            color: 0x000000,
            title: caml_string_of_jsbytes("")};
   }
   function caml_gr_draw_arc(x, y, rx, ry, a1, a2){
    var s = caml_gr_state_get();
    s.context.beginPath();
    caml_gr_arc_aux(s.context, x, s.height - y, rx, ry, a1, a2);
    s.context.stroke();
    return 0;
   }
   function caml_ba_map_file(vfd, kind, layout, shared, dims, pos){caml_failwith("caml_ba_map_file not implemented");
   }
   function caml_ba_map_file_bytecode(argv, argn){
    return caml_ba_map_file
            (argv[0], argv[1], argv[2], argv[3], argv[4], argv[5]);
   }
   function caml_ba_create_from(data1, data2, jstyp, kind, layout, dims){
    if(data2 || caml_ba_get_size_per_element(kind) == 2)
     caml_invalid_argument
      ("caml_ba_create_from: use return caml_ba_create_unsafe");
    return caml_ba_create_unsafe(kind, layout, dims, data1);
   }
   function caml_tanh_float(x){return Math.tanh(x);}
   function caml_gr_draw_str(str){
    var s = caml_gr_state_get(), m = s.context.measureText(str), dx = m.width;
    s.context.fillText(str, s.x, s.height - s.y);
    s.x += dx | 0;
    return 0;
   }
   function caml_gr_draw_string(str){
    caml_gr_draw_str(caml_jsstring_of_string(str));
    return 0;
   }
   function caml_gr_draw_char(c){
    caml_gr_draw_str(String.fromCharCode(c));
    return 0;
   }
   function caml_unmount(name){
    var
     path = caml_make_path(name),
     name = caml_trailing_slash(path.join("/")),
     idx = - 1;
    for(var i = 0; i < jsoo_mount_point.length; i++)
     if(jsoo_mount_point[i].path == name) idx = i;
    if(idx > - 1) jsoo_mount_point.splice(idx, 1);
    return 0;
   }
   function caml_bigstring_blit_ba_to_ba(ba1, pos1, ba2, pos2, len){
    if(12 != ba1.kind)
     caml_invalid_argument("caml_bigstring_blit_ba_to_ba: kind mismatch");
    if(12 != ba2.kind)
     caml_invalid_argument("caml_bigstring_blit_ba_to_ba: kind mismatch");
    if(len == 0) return 0;
    var ofs1 = ba1.offset(pos1), ofs2 = ba2.offset(pos2);
    if(ofs1 + len > ba1.data.length) caml_array_bound_error();
    if(ofs2 + len > ba2.data.length) caml_array_bound_error();
    var slice = ba1.data.subarray(ofs1, ofs1 + len);
    ba2.data.set(slice, pos2);
    return 0;
   }
   function caml_input_value_from_string(s, ofs){
    var reader = new MlStringReader(s, typeof ofs == "number" ? ofs : ofs[0]);
    return caml_input_value_from_reader(reader, ofs);
   }
   function caml_ml_pos_in_64(chanid){
    return caml_int64_of_float(caml_pos_in(chanid));
   }
   function caml_gr_draw_image(im, x, y){
    var s = caml_gr_state_get();
    if(! im.image){
     var canvas = document.createElement("canvas");
     canvas.width = s.width;
     canvas.height = s.height;
     canvas.getContext("2d").putImageData(im, 0, 0);
     var image = new globalThis.Image();
     image.onload =
      function(){
       s.context.drawImage(image, x, s.height - im.height - y);
       im.image = image;
      };
     image.src = canvas.toDataURL("image/png");
    }
    else
     s.context.drawImage(im.image, x, s.height - im.height - y);
    return 0;
   }
   function caml_register_channel_for_spacetime(_channel){return 0;}
   function caml_string_set(s, i, c){caml_failwith("caml_string_set");}
   function caml_sys_rmdir(name){
    var root = resolve_fs_device(name);
    root.device.rmdir(root.rest);
    return 0;
   }
   function caml_unix_symlink(to_dir, src, dst){
    var src_root = resolve_fs_device(src), dst_root = resolve_fs_device(dst);
    if(src_root.device != dst_root.device)
     caml_failwith
      ("caml_unix_symlink: cannot symlink between two filesystems");
    if(! src_root.device.symlink)
     caml_failwith("caml_unix_symlink: not implemented");
    return src_root.device.symlink(to_dir, src_root.rest, dst_root.rest, true);
   }
   function caml_ml_pos_out(chanid){return caml_pos_out(chanid);}
   function caml_spacetime_enabled(_unit){return 0;}
   function caml_bytes_notequal(s1, s2){return 1 - caml_bytes_equal(s1, s2);}
   function caml_runtime_parameters(_unit){return caml_string_of_jsbytes("");}
   function caml_js_object(a){
    var o = {};
    for(var i = 1; i < a.length; i++){
     var p = a[i];
     o[caml_jsstring_of_string(p[1])] = p[2];
    }
    return o;
   }
   function caml_ba_create(kind, layout, dims_ml){
    var
     dims = caml_js_from_array(dims_ml),
     data = caml_ba_create_buffer(kind, caml_ba_get_size(dims));
    return caml_ba_create_unsafe(kind, layout, dims, data);
   }
   function caml_gr_remember_mode(){
    caml_failwith("caml_gr_remember_mode not Implemented");
   }
   function caml_fma_float(x, y, z){
    var
     SPLIT = Math.pow(2, 27) + 1,
     MIN_VALUE = Math.pow(2, - 1022),
     EPSILON = Math.pow(2, - 52),
     C = 416,
     A = Math.pow(2, + C),
     B = Math.pow(2, - C);
    function multiply(a, b){
     var
      at = SPLIT * a,
      ahi = at - (at - a),
      alo = a - ahi,
      bt = SPLIT * b,
      bhi = bt - (bt - b),
      blo = b - bhi,
      p = a * b,
      e = ahi * bhi - p + ahi * blo + alo * bhi + alo * blo;
     return {p: p, e: e};
    }
    function add(a, b){
     var s = a + b, v = s - a, e = a - (s - v) + (b - v);
     return {s: s, e: e};
    }
    function adjust(x, y){
     return x !== 0 && y !== 0 && SPLIT * x - (SPLIT * x - x) === x
             ? x * (1 + (x < 0 ? - 1 : + 1) * (y < 0 ? - 1 : + 1) * EPSILON)
             : x;
    }
    if
     (x === 0 || x !== x || x === + (1 / 0) || x === - (1 / 0) || y === 0
      || y !== y
      || y === + (1 / 0)
      || y === - (1 / 0))
     return x * y + z;
    if(z === 0) return x * y;
    if(z !== z || z === + (1 / 0) || z === - (1 / 0)) return z;
    var scale = 1;
    while(Math.abs(x) > A){scale *= A; x *= B;}
    while(Math.abs(y) > A){scale *= A; y *= B;}
    if(scale === 1 / 0) return x * y * scale;
    while(Math.abs(x) < B){scale *= B; x *= A;}
    while(Math.abs(y) < B){scale *= B; y *= A;}
    if(scale === 0) return z;
    var xs = x, ys = y, zs = z / scale;
    if(Math.abs(zs) > Math.abs(xs * ys) * 4 / EPSILON) return z;
    if(Math.abs(zs) < Math.abs(xs * ys) * EPSILON / 4 * EPSILON / 4)
     zs = (z < 0 ? - 1 : + 1) * MIN_VALUE;
    var
     xy = multiply(xs, ys),
     s = add(xy.p, zs),
     u = add(xy.e, s.e),
     i = add(s.s, u.s),
     f = i.s + adjust(i.e, u.e);
    if(f === 0) return f;
    var fs = f * scale;
    if(Math.abs(fs) > MIN_VALUE) return fs;
    return fs + adjust(f - fs / scale, i.e) * scale;
   }
   function caml_recommended_domain_count(unit){return 1;}
   function caml_bswap16(x){return (x & 0x00FF) << 8 | (x & 0xFF00) >> 8;}
   function caml_ml_set_binary_mode(chanid, mode){
    var chan = caml_ml_channels[chanid];
    chan.file.flags.text = ! mode;
    chan.file.flags.binary = mode;
    return 0;
   }
   function caml_final_register(){return 0;}
   function caml_gr_draw_rect(x, y, w, h){
    var s = caml_gr_state_get();
    s.context.strokeRect(x, s.height - y, w, - h);
    return 0;
   }
   function caml_string_get16(s, i){
    if(i >>> 0 >= caml_ml_string_length(s) - 1) caml_string_bound_error();
    var
     b1 = caml_string_unsafe_get(s, i),
     b2 = caml_string_unsafe_get(s, i + 1);
    return b2 << 8 | b1;
   }
   function caml_js_to_int32(x){return x | 0;}
   function caml_output_value(chanid, v, flags){
    var s = caml_output_value_to_string(v, flags);
    caml_ml_output(chanid, s, 0, caml_ml_string_length(s));
    return 0;
   }
   function caml_ml_output_bigarray(chanid, buffer, offset, len){
    var buffer = caml_ba_to_typed_array(buffer);
    return caml_ml_output_ta(chanid, buffer, offset, len);
   }
   function caml_ba_get_3(ba, i0, i1, i2){
    return ba.get(ba.offset([i0, i1, i2]));
   }
   function caml_ml_runtime_events_pause(){return 0;}
   function caml_ephe_blit_key(a1, i1, a2, i2, len){
    caml_array_blit
     (a1,
      caml_ephe_key_offset + i1 - 1,
      a2,
      caml_ephe_key_offset + i2 - 1,
      len);
    return 0;
   }
   var caml_initial_time = new Date().getTime() * 0.001;
   function caml_sys_time(){
    var now = new Date().getTime();
    return now * 0.001 - caml_initial_time;
   }
   function caml_sys_time_include_children(b){return caml_sys_time();}
   function caml_check_bound(array, index){
    if(index >>> 0 >= array.length - 1) caml_array_bound_error();
    return array;
   }
   function caml_unix_getpwuid(unit){caml_raise_not_found();}
   function caml_hash(count, limit, seed, obj){
    var queue, rd, wr, sz, num, h, v, i, len;
    sz = limit;
    if(sz < 0 || sz > 256) sz = 256;
    num = count;
    h = seed;
    queue = [obj];
    rd = 0;
    wr = 1;
    while(rd < wr && num > 0){
     v = queue[rd++];
     if(v && v.caml_custom){
      if
       (caml_custom_ops[v.caml_custom] && caml_custom_ops[v.caml_custom].hash){
       var hh = caml_custom_ops[v.caml_custom].hash(v);
       h = caml_hash_mix_int(h, hh);
       num--;
      }
     }
     else if(v instanceof Array && v[0] === (v[0] | 0))
      switch(v[0]){
        case 248:
         h = caml_hash_mix_int(h, v[2]); num--; break;
        case 250:
         queue[--rd] = v[1]; break;
        default:
         if(caml_is_continuation_tag(v[0])) break;
         var tag = v.length - 1 << 10 | v[0];
         h = caml_hash_mix_int(h, tag);
         for(i = 1, len = v.length; i < len; i++){if(wr >= sz) break; queue[wr++] = v[i];
         }
         break;
      }
     else if(caml_is_ml_bytes(v)){
      h = caml_hash_mix_bytes(h, v);
      num--;
     }
     else if(caml_is_ml_string(v)){
      h = caml_hash_mix_string(h, v);
      num--;
     }
     else if(typeof v === "string"){
      h = caml_hash_mix_jsbytes(h, v);
      num--;
     }
     else if(v === (v | 0)){
      h = caml_hash_mix_int(h, v + v + 1);
      num--;
     }
     else if(typeof v === "number"){h = caml_hash_mix_float(h, v); num--;}
    }
    h = caml_hash_mix_final(h);
    return h & 0x3FFFFFFF;
   }
   function caml_domain_dls_get(unit){return caml_domain_dls;}
   function caml_bytes_get32(s, i){
    if(i >>> 0 >= s.l - 3) caml_bytes_bound_error();
    var
     b1 = caml_bytes_unsafe_get(s, i),
     b2 = caml_bytes_unsafe_get(s, i + 1),
     b3 = caml_bytes_unsafe_get(s, i + 2),
     b4 = caml_bytes_unsafe_get(s, i + 3);
    return b4 << 24 | b3 << 16 | b2 << 8 | b1;
   }
   function caml_frexp_float(x){
    if(x == 0 || ! isFinite(x)) return [0, x, 0];
    var neg = x < 0;
    if(neg) x = - x;
    var exp = Math.max(- 1023, jsoo_floor_log2(x) + 1);
    x *= Math.pow(2, - exp);
    while(x < 0.5){x *= 2; exp--;}
    while(x >= 1){x *= 0.5; exp++;}
    if(neg) x = - x;
    return [0, x, exp];
   }
   function caml_string_get64(s, i){
    if(i >>> 0 >= caml_ml_string_length(s) - 7) caml_string_bound_error();
    var a = new Array(8);
    for(var j = 0; j < 8; j++) a[7 - j] = caml_string_unsafe_get(s, i + j);
    return caml_int64_of_bytes(a);
   }
   function caml_js_error_option_of_exception(exn){
    if(exn.js_error) return [0, exn.js_error];
    return 0;
   }
   function caml_ml_pos_out_64(chanid){
    return caml_int64_of_float(caml_pos_out(chanid));
   }
   function caml_unix_findclose(dir_handle){return caml_unix_closedir(dir_handle);
   }
   function caml_gr_close_subwindow(a){
    caml_failwith("caml_gr_close_subwindow not Implemented");
   }
   function caml_floatarray_blit(a1, i1, a2, i2, len){
    if(i2 <= i1)
     for(var j = 1; j <= len; j++) a2[i2 + j] = a1[i1 + j];
    else
     for(var j = len; j >= 1; j--) a2[i2 + j] = a1[i1 + j];
    return 0;
   }
   function caml_get_minor_free(unit){return 0;}
   function caml_set_static_env(k, v){
    if(! globalThis.jsoo_static_env) globalThis.jsoo_static_env = {};
    globalThis.jsoo_static_env[k] = v;
    return 0;
   }
   function caml_ba_change_layout(ba, layout){
    if(ba.layout == layout) return ba;
    var new_dims = [];
    for(var i = 0; i < ba.dims.length; i++)
     new_dims[i] = ba.dims[ba.dims.length - i - 1];
    return caml_ba_create_unsafe(ba.kind, layout, new_dims, ba.data);
   }
   function caml_js_new(c, a){
    switch(a.length){
      case 1:
       return new c;
      case 2:
       return new c(a[1]);
      case 3:
       return new c(a[1], a[2]);
      case 4:
       return new c(a[1], a[2], a[3]);
      case 5:
       return new c(a[1], a[2], a[3], a[4]);
      case 6:
       return new c(a[1], a[2], a[3], a[4], a[5]);
      case 7:
       return new c(a[1], a[2], a[3], a[4], a[5], a[6]);
      case 8:
       return new c(a[1], a[2], a[3], a[4], a[5], a[6], a[7]);
    }
    function F(){return c.apply(this, caml_js_from_array(a));}
    F.prototype = c.prototype;
    return new F;
   }
   function caml_ml_open_descriptor_out(fd){
    var file = caml_sys_fds[fd];
    if(file.flags.rdonly) caml_raise_sys_error("fd " + fd + " is readonly");
    var
     buffered = file.flags.buffered !== undefined ? file.flags.buffered : 1,
     channel =
       {file: file,
        offset: file.flags.append ? file.length() : 0,
        fd: fd,
        opened: true,
        out: true,
        buffer_curr: 0,
        buffer: new Uint8Array(65536),
        buffered: buffered};
    caml_ml_channels[channel.fd] = channel;
    return channel.fd;
   }
   function caml_ml_open_descriptor_out_with_flags(fd, flags){return caml_ml_open_descriptor_out(fd);
   }
   function caml_gr_current_y(){var s = caml_gr_state_get(); return s.y;}
   function caml_format_int(fmt, i){
    if(caml_jsbytes_of_string(fmt) == "%d")
     return caml_string_of_jsbytes("" + i);
    var f = caml_parse_format(fmt);
    if(i < 0) if(f.signedconv){f.sign = - 1; i = - i;} else i >>>= 0;
    var s = i.toString(f.base);
    if(f.prec >= 0){
     f.filler = " ";
     var n = f.prec - s.length;
     if(n > 0) s = caml_str_repeat(n, "0") + s;
    }
    return caml_finish_formatting(f, s);
   }
   function jsoo_effect_not_supported(){
    caml_failwith("Effect handlers are not supported");
   }
   var caml_ml_domain_unique_token_ = [0];
   function caml_ml_domain_unique_token(unit){return caml_ml_domain_unique_token_;
   }
   function caml_continuation_use_and_update_handler_noexc
   (cont, hval, hexn, heff){
    var stack = caml_continuation_use_noexc(cont);
    stack[3] = [0, hval, hexn, heff];
    return stack;
   }
   function caml_obj_truncate(x, s){
    if(s <= 0 || s + 1 > x.length) caml_invalid_argument("Obj.truncate");
    if(x.length != s + 1) x.length = s + 1;
    return 0;
   }
   function caml_js_to_string(s){return caml_string_of_jsstring(s);}
   function is_digit_odd(nat, ofs){if(nat.data[ofs] & 1) return 1; return 0;}
   function caml_runtime_variant(_unit){return caml_string_of_jsbytes("");}
   function caml_array_concat(l){
    var a = [0];
    while(l !== 0){
     var b = l[1];
     for(var i = 1; i < b.length; i++) a.push(b[i]);
     l = l[2];
    }
    return a;
   }
   function caml_gr_open_graph(info){
    var info = caml_jsstring_of_string(info);
    function get(name){
     var res = info.match("(^|,) *" + name + " *= *([a-zA-Z0-9_]+) *(,|$)");
     if(res) return res[2];
    }
    var specs = [];
    if(! (info == "")) specs.push(info);
    var target = get("target");
    if(! target) target = "";
    var status = get("status");
    if(! status) specs.push("status=1");
    var w = get("width");
    w = w ? parseInt(w) : 200;
    specs.push("width=" + w);
    var h = get("height");
    h = h ? parseInt(h) : 200;
    specs.push("height=" + h);
    var win = globalThis.open("about:blank", target, specs.join(","));
    if(! win) caml_failwith("Graphics.open_graph: cannot open the window");
    var doc = win.document, canvas = doc.createElement("canvas");
    canvas.width = w;
    canvas.height = h;
    var ctx = caml_gr_state_create(canvas, w, h);
    ctx.set_title = function(title){doc.title = title;};
    caml_gr_state_set(ctx);
    var body = doc.body;
    body.style.margin = "0px";
    body.appendChild(canvas);
    return 0;
   }
   function caml_make_float_vect(len){
    if(len < 0) caml_array_bound_error();
    var len = len + 1 | 0, b = new Array(len);
    b[0] = 254;
    for(var i = 1; i < len; i++) b[i] = 0;
    return b;
   }
   function caml_cbrt_float(x){return Math.cbrt(x);}
   function caml_eventlog_pause(unit){return 0;}
   function caml_memprof_stop(unit){return 0;}
   function caml_greaterequal(x, y){
    return + (caml_compare_val(x, y, false) >= 0);
   }
   function caml_get_exception_raw_backtrace(){return [0];}
   function caml_log1p_float(x){return Math.log1p(x);}
   function caml_runtime_events_free_cursor(cursor){return 0;}
   function caml_lazy_make_forward(v){return [250, v];}
   function lor_digit_nat(nat1, ofs1, nat2, ofs2){nat1.data[ofs1] |= nat2.data[ofs2]; return 0;
   }
   function caml_gr_blit_image(im, x, y){
    var
     s = caml_gr_state_get(),
     im2 =
       s.context.getImageData
        (x, s.height - im.height - y, im.width, im.height);
    for(var i = 0; i < im2.data.length; i += 4){
     im.data[i] = im2.data[i];
     im.data[i + 1] = im2.data[i + 1];
     im.data[i + 2] = im2.data[i + 2];
     im.data[i + 3] = im2.data[i + 3];
    }
    return 0;
   }
   function caml_gr_window_id(a){
    caml_failwith("caml_gr_window_id not Implemented");
   }
   function caml_atomic_make_contended(a){return [0, a];}
   function caml_js_on_ie(){
    var
     ua =
       globalThis.navigator && globalThis.navigator.userAgent
        ? globalThis.navigator.userAgent
        : "";
    return ua.indexOf("MSIE") != - 1 && ua.indexOf("Opera") != 0;
   }
   function caml_int64_shift_right(x, s){return x.shift_right(s);}
   function caml_ba_layout(ba){return ba.layout;}
   function caml_convert_raw_backtrace(){return [0];}
   function caml_array_set(array, index, newval){
    if(index < 0 || index >= array.length - 1) caml_array_bound_error();
    array[index + 1] = newval;
    return 0;
   }
   function caml_alloc_stack(hv, hx, hf){return 0;}
   function caml_bytes_greaterequal(s1, s2){return caml_bytes_lessequal(s2, s1);
   }
   function set_digit_nat(nat, ofs, digit){nat.data[ofs] = digit; return 0;}
   function caml_bytes_set16(s, i, i16){
    if(i >>> 0 >= s.l - 1) caml_bytes_bound_error();
    var b2 = 0xFF & i16 >> 8, b1 = 0xFF & i16;
    caml_bytes_unsafe_set(s, i + 0, b1);
    caml_bytes_unsafe_set(s, i + 1, b2);
    return 0;
   }
   function caml_gr_doc_of_state(state){
    if(state.canvas.ownerDocument) return state.canvas.ownerDocument;
   }
   function caml_ml_output_int(chanid, i){
    var
     arr = [i >> 24 & 0xFF, i >> 16 & 0xFF, i >> 8 & 0xFF, i & 0xFF],
     s = caml_string_of_array(arr);
    caml_ml_output(chanid, s, 0, 4);
    return 0;
   }
   function caml_obj_with_tag(tag, x){
    var l = x.length, a = new Array(l);
    a[0] = tag;
    for(var i = 1; i < l; i++) a[i] = x[i];
    return a;
   }
   function caml_ml_channel_size(chanid){
    var chan = caml_ml_channels[chanid];
    return chan.file.length();
   }
   function caml_raw_backtrace_slot(){
    caml_invalid_argument
     ("Printexc.get_raw_backtrace_slot: index out of bounds");
   }
   function caml_hexstring_of_float(x, prec, style){
    if(! isFinite(x)){
     if(isNaN(x)) return caml_string_of_jsstring("nan");
     return caml_string_of_jsstring(x > 0 ? "infinity" : "-infinity");
    }
    var sign = x == 0 && 1 / x == - Infinity ? 1 : x >= 0 ? 0 : 1;
    if(sign) x = - x;
    var exp = 0;
    if(x == 0)
     ;
    else if(x < 1)
     while(x < 1 && exp > - 1022){x *= 2; exp--;}
    else
     while(x >= 2){x /= 2; exp++;}
    var exp_sign = exp < 0 ? "" : "+", sign_str = "";
    if(sign)
     sign_str = "-";
    else
     switch(style){
       case 43:
        sign_str = "+"; break;
       case 32:
        sign_str = " "; break;
       default: break;
     }
    if(prec >= 0 && prec < 13){
     var cst = Math.pow(2, prec * 4);
     x = Math.round(x * cst) / cst;
    }
    var x_str = x.toString(16);
    if(prec >= 0){
     var idx = x_str.indexOf(".");
     if(idx < 0)
      x_str += "." + caml_str_repeat(prec, "0");
     else{
      var size = idx + 1 + prec;
      if(x_str.length < size)
       x_str += caml_str_repeat(size - x_str.length, "0");
      else
       x_str = x_str.substr(0, size);
     }
    }
    return caml_string_of_jsstring
            (sign_str + "0x" + x_str + "p" + exp_sign + exp.toString(10));
   }
   function caml_runtime_events_user_write(event, event_content){return 0;}
   function caml_js_wrap_meth_callback_strict(arity, f){
    return function(){
     var args = new Array(arity + 1), len = Math.min(arguments.length, arity);
     args[0] = this;
     for(var i = 0; i < len; i++) args[i + 1] = arguments[i];
     return caml_callback(f, args);};
   }
   function caml_unix_readlink(name){
    var root = resolve_fs_device(name);
    if(! root.device.readlink)
     caml_failwith("caml_unix_readlink: not implemented");
    return root.device.readlink(root.rest, true);
   }
   function caml_backtrace_status(_unit){
    return caml_record_backtrace_flag ? 1 : 0;
   }
   function caml_install_signal_handler(){return 0;}
   function caml_sys_argv(a){return caml_argv;}
   function caml_ba_fill(ba, v){ba.fill(v); return 0;}
   function caml_modf_float(x){
    if(isFinite(x)){
     var neg = 1 / x < 0;
     x = Math.abs(x);
     var i = Math.floor(x), f = x - i;
     if(neg){i = - i; f = - f;}
     return [0, f, i];
    }
    if(isNaN(x)) return [0, NaN, NaN];
    return [0, 1 / x, x];
   }
   function caml_gc_get(){return [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];}
   function caml_float_compare(x, y){
    if(x === y) return 0;
    if(x < y) return - 1;
    if(x > y) return 1;
    if(x === x) return 1;
    if(y === y) return - 1;
    return 0;
   }
   function caml_string_set32(s, i, i32){caml_failwith("caml_string_set32");}
   function caml_parse_engine(tables, env, cmd, arg){
    var
     ERRCODE = 256,
     loop = 6,
     testshift = 7,
     shift = 8,
     shift_recover = 9,
     reduce = 10,
     READ_TOKEN = 0,
     RAISE_PARSE_ERROR = 1,
     GROW_STACKS_1 = 2,
     GROW_STACKS_2 = 3,
     COMPUTE_SEMANTIC_ACTION = 4,
     CALL_ERROR_FUNCTION = 5,
     env_s_stack = 1,
     env_v_stack = 2,
     env_symb_start_stack = 3,
     env_symb_end_stack = 4,
     env_stacksize = 5,
     env_stackbase = 6,
     env_curr_char = 7,
     env_lval = 8,
     env_symb_start = 9,
     env_symb_end = 10,
     env_asp = 11,
     env_rule_len = 12,
     env_rule_number = 13,
     env_sp = 14,
     env_state = 15,
     env_errflag = 16,
     tbl_transl_const = 2,
     tbl_transl_block = 3,
     tbl_lhs = 4,
     tbl_len = 5,
     tbl_defred = 6,
     tbl_dgoto = 7,
     tbl_sindex = 8,
     tbl_rindex = 9,
     tbl_gindex = 10,
     tbl_tablesize = 11,
     tbl_table = 12,
     tbl_check = 13,
     tbl_names_const = 15,
     tbl_names_block = 16;
    function log(x){
     var s = caml_string_of_jsbytes(x + "\n");
     caml_ml_output(2, s, 0, caml_ml_string_length(s));
    }
    function token_name(names, number){
     var str = caml_jsstring_of_string(names);
     if(str[0] == "\x00") return "<unknown token>";
     return str.split("\x00")[number];
    }
    function print_token(state, tok){
     var token, kind;
     if(tok instanceof Array){
      token = token_name(tables[tbl_names_block], tok[0]);
      if(typeof tok[1] == "number")
       kind = "" + tok[1];
      else if(typeof tok[1] == "string")
       kind = tok[1];
      else if(tok[1] instanceof MlBytes)
       kind = caml_jsbytes_of_string(tok[1]);
      else
       kind = "_";
      log("State " + state + ": read token " + token + "(" + kind + ")");
     }
     else{
      token = token_name(tables[tbl_names_const], tok);
      log("State " + state + ": read token " + token);
     }
    }
    if(! tables.dgoto){
     tables.defred = caml_lex_array(tables[tbl_defred]);
     tables.sindex = caml_lex_array(tables[tbl_sindex]);
     tables.check = caml_lex_array(tables[tbl_check]);
     tables.rindex = caml_lex_array(tables[tbl_rindex]);
     tables.table = caml_lex_array(tables[tbl_table]);
     tables.len = caml_lex_array(tables[tbl_len]);
     tables.lhs = caml_lex_array(tables[tbl_lhs]);
     tables.gindex = caml_lex_array(tables[tbl_gindex]);
     tables.dgoto = caml_lex_array(tables[tbl_dgoto]);
    }
    var
     res = 0,
     n,
     n1,
     n2,
     state1,
     sp = env[env_sp],
     state = env[env_state],
     errflag = env[env_errflag];
    exit:
    for(;;)
     next:
     switch(cmd){
       case 0:
        state = 0; errflag = 0;
       case 6:
        n = tables.defred[state];
        if(n != 0){cmd = reduce; break;}
        if(env[env_curr_char] >= 0){cmd = testshift; break;}
        res = READ_TOKEN;
        break exit;
       case 1:
        if(arg instanceof Array){
         env[env_curr_char] = tables[tbl_transl_block][arg[0] + 1];
         env[env_lval] = arg[1];
        }
        else{
         env[env_curr_char] = tables[tbl_transl_const][arg + 1];
         env[env_lval] = 0;
        }
        if(caml_parser_trace) print_token(state, arg);
       case 7:
        n1 = tables.sindex[state];
        n2 = n1 + env[env_curr_char];
        if
         (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize]
          && tables.check[n2] == env[env_curr_char]){cmd = shift; break;}
        n1 = tables.rindex[state];
        n2 = n1 + env[env_curr_char];
        if
         (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize]
          && tables.check[n2] == env[env_curr_char]){
         n = tables.table[n2];
         cmd = reduce;
         break;
        }
        if(errflag <= 0){res = CALL_ERROR_FUNCTION; break exit;}
       case 5:
        if(errflag < 3){
         errflag = 3;
         for(;;){
          state1 = env[env_s_stack][sp + 1];
          n1 = tables.sindex[state1];
          n2 = n1 + ERRCODE;
          if
           (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize]
            && tables.check[n2] == ERRCODE){
           if(caml_parser_trace) log("Recovering in state " + state1);
           cmd = shift_recover;
           break next;
          }
          else{
           if(caml_parser_trace) log("Discarding state " + state1);
           if(sp <= env[env_stackbase]){
            if(caml_parser_trace) log("No more states to discard");
            return RAISE_PARSE_ERROR;
           }
           sp--;
          }
         }
        }
        else{
         if(env[env_curr_char] == 0) return RAISE_PARSE_ERROR;
         if(caml_parser_trace) log("Discarding last token read");
         env[env_curr_char] = - 1;
         cmd = loop;
         break;
        }
       case 8:
        env[env_curr_char] = - 1; if(errflag > 0) errflag--;
       case 9:
        if(caml_parser_trace)
         log("State " + state + ": shift to state " + tables.table[n2]);
        state = tables.table[n2];
        sp++;
        if(sp >= env[env_stacksize]){res = GROW_STACKS_1; break exit;}
       case 2:
        env[env_s_stack][sp + 1] = state;
        env[env_v_stack][sp + 1] = env[env_lval];
        env[env_symb_start_stack][sp + 1] = env[env_symb_start];
        env[env_symb_end_stack][sp + 1] = env[env_symb_end];
        cmd = loop;
        break;
       case 10:
        if(caml_parser_trace) log("State " + state + ": reduce by rule " + n);
        var m = tables.len[n];
        env[env_asp] = sp;
        env[env_rule_number] = n;
        env[env_rule_len] = m;
        sp = sp - m + 1;
        m = tables.lhs[n];
        state1 = env[env_s_stack][sp];
        n1 = tables.gindex[m];
        n2 = n1 + state1;
        if
         (n1 != 0 && n2 >= 0 && n2 <= tables[tbl_tablesize]
          && tables.check[n2] == state1)
         state = tables.table[n2];
        else
         state = tables.dgoto[m];
        if(sp >= env[env_stacksize]){res = GROW_STACKS_2; break exit;}
       case 3:
        res = COMPUTE_SEMANTIC_ACTION; break exit;
       case 4:
        env[env_s_stack][sp + 1] = state;
        env[env_v_stack][sp + 1] = arg;
        var asp = env[env_asp];
        env[env_symb_end_stack][sp + 1] = env[env_symb_end_stack][asp + 1];
        if(sp > asp)
         env[env_symb_start_stack][sp + 1] = env[env_symb_end_stack][asp + 1];
        cmd = loop;
        break;
       default: return RAISE_PARSE_ERROR;
     }
    env[env_sp] = sp;
    env[env_state] = state;
    env[env_errflag] = errflag;
    return res;
   }
   function caml_ml_runtime_events_start(){return 0;}
   function caml_jsoo_flags_effects(unit){return 0;}
   function caml_update_dummy(x, y){
    if(y.fun){x.fun = y.fun; return 0;}
    if(typeof y === "function"){x.fun = y; return 0;}
    var i = y.length;
    while(i--) x[i] = y[i];
    return 0;
   }
   function caml_array_fill(array, ofs, len, v){
    for(var i = 0; i < len; i++) array[ofs + i + 1] = v;
    return 0;
   }
   function caml_sys_mkdir(name, perm){
    var root = resolve_fs_device(name);
    root.device.mkdir(root.rest, perm);
    return 0;
   }
   function caml_string_notequal(s1, s2){
    return 1 - caml_string_equal(s1, s2);
   }
   function caml_bytes_greaterthan(s1, s2){return caml_bytes_lessthan(s2, s1);
   }
   function caml_gr_make_image(arr){
    var
     s = caml_gr_state_get(),
     h = arr.length - 1,
     w = arr[1].length - 1,
     im = s.context.createImageData(w, h);
    for(var i = 0; i < h; i++)
     for(var j = 0; j < w; j++){
      var c = arr[i + 1][j + 1], o = i * (w * 4) + j * 4;
      if(c == - 1){
       im.data[o + 0] = 0;
       im.data[o + 1] = 0;
       im.data[o + 2] = 0;
       im.data[o + 3] = 0;
      }
      else{
       im.data[o + 0] = c >> 16 & 0xff;
       im.data[o + 1] = c >> 8 & 0xff;
       im.data[o + 2] = c >> 0 & 0Xff;
       im.data[o + 3] = 0xff;
      }
     }
    return im;
   }
   function caml_ml_set_channel_output(chanid, f){
    var chan = caml_ml_channels[chanid];
    chan.output = function(s){f(s);};
    return 0;
   }
   function caml_read_file_content(name){
    var
     name = typeof name == "string" ? caml_string_of_jsbytes(name) : name,
     root = resolve_fs_device(name);
    if(root.device.exists(root.rest)){
     var
      file = root.device.open(root.rest, {rdonly: 1}),
      len = file.length(),
      buf = new Uint8Array(len);
     file.read(0, buf, 0, len);
     return caml_string_of_array(buf);
    }
    caml_raise_no_such_file(caml_jsbytes_of_string(name));
   }
   function caml_js_to_float(x){return x;}
   function caml_setup_uncaught_exception_handler(){
    var process = globalThis.process;
    if(process && process.on)
     process.on
      ("uncaughtException",
       function(err, origin){
        caml_fatal_uncaught_exception(err);
        process.exit(2);
       });
    else if(globalThis.addEventListener)
     globalThis.addEventListener
      ("error",
       function(event){
        if(event.error) caml_fatal_uncaught_exception(event.error);
       });
   }
   caml_setup_uncaught_exception_handler();
   globalThis.jsoo_runtime =
    {caml_runtime_events_read_poll: caml_runtime_events_read_poll,
     caml_runtime_events_free_cursor: caml_runtime_events_free_cursor,
     caml_runtime_events_create_cursor: caml_runtime_events_create_cursor,
     caml_ml_runtime_events_resume: caml_ml_runtime_events_resume,
     caml_ml_runtime_events_pause: caml_ml_runtime_events_pause,
     caml_ml_runtime_events_start: caml_ml_runtime_events_start,
     caml_runtime_events_user_resolve: caml_runtime_events_user_resolve,
     caml_runtime_events_user_write: caml_runtime_events_user_write,
     caml_runtime_events_user_register: caml_runtime_events_user_register,
     caml_custom_event_index: caml_custom_event_index,
     caml_zstd_initialize: caml_zstd_initialize,
     caml_decompress_input: caml_decompress_input,
     zstd_decompress: zstd_decompress,
     jsoo_effect_not_supported: jsoo_effect_not_supported,
     caml_ml_condition_signal: caml_ml_condition_signal,
     caml_ml_condition_broadcast: caml_ml_condition_broadcast,
     caml_ml_condition_wait: caml_ml_condition_wait,
     caml_ml_condition_new: caml_ml_condition_new,
     caml_get_continuation_callstack: caml_get_continuation_callstack,
     caml_continuation_use_and_update_handler_noexc:
     caml_continuation_use_and_update_handler_noexc,
     caml_continuation_use_noexc: caml_continuation_use_noexc,
     caml_alloc_stack: caml_alloc_stack,
     caml_ml_mutex_unlock: caml_ml_mutex_unlock,
     caml_ml_mutex_try_lock: caml_ml_mutex_try_lock,
     caml_ml_mutex_lock: caml_ml_mutex_lock,
     caml_ml_mutex_new: caml_ml_mutex_new,
     MlMutex: MlMutex,
     caml_lxm_next: caml_lxm_next,
     caml_ml_domain_cpu_relax: caml_ml_domain_cpu_relax,
     caml_ml_domain_id: caml_ml_domain_id,
     caml_domain_spawn: caml_domain_spawn,
     caml_domain_id: caml_domain_id,
     caml_recommended_domain_count: caml_recommended_domain_count,
     caml_ml_domain_set_name: caml_ml_domain_set_name,
     caml_ml_domain_unique_token: caml_ml_domain_unique_token,
     caml_atomic_make_contended: caml_atomic_make_contended,
     caml_atomic_exchange: caml_atomic_exchange,
     caml_atomic_fetch_add: caml_atomic_fetch_add,
     caml_atomic_cas: caml_atomic_cas,
     caml_atomic_load: caml_atomic_load,
     caml_domain_dls_get: caml_domain_dls_get,
     caml_domain_dls_set: caml_domain_dls_set,
     caml_domain_dls: caml_domain_dls,
     caml_ephe_check_data: caml_ephe_check_data,
     caml_ephe_unset_data: caml_ephe_unset_data,
     caml_ephe_set_data: caml_ephe_set_data,
     caml_ephe_get_data_copy: caml_ephe_get_data_copy,
     caml_ephe_get_data: caml_ephe_get_data,
     caml_ephe_blit_data: caml_ephe_blit_data,
     caml_ephe_blit_key: caml_ephe_blit_key,
     caml_ephe_check_key: caml_ephe_check_key,
     caml_ephe_get_key_copy: caml_ephe_get_key_copy,
     caml_ephe_get_key: caml_ephe_get_key,
     caml_weak_set: caml_weak_set,
     caml_weak_create: caml_weak_create,
     caml_ephe_create: caml_ephe_create,
     caml_ephe_unset_key: caml_ephe_unset_key,
     caml_ephe_set_key: caml_ephe_set_key,
     caml_ephe_data_offset: caml_ephe_data_offset,
     caml_ephe_key_offset: caml_ephe_key_offset,
     caml_unix_inet_addr_of_string: caml_unix_inet_addr_of_string,
     caml_unix_findclose: caml_unix_findclose,
     caml_unix_findnext: caml_unix_findnext,
     caml_unix_findfirst: caml_unix_findfirst,
     caml_unix_rewinddir: caml_unix_rewinddir,
     caml_unix_closedir: caml_unix_closedir,
     caml_unix_readdir: caml_unix_readdir,
     caml_unix_opendir: caml_unix_opendir,
     caml_unix_has_symlink: caml_unix_has_symlink,
     caml_unix_getpwuid: caml_unix_getpwuid,
     caml_unix_getuid: caml_unix_getuid,
     caml_unix_unlink: caml_unix_unlink,
     caml_unix_readlink: caml_unix_readlink,
     caml_unix_symlink: caml_unix_symlink,
     caml_unix_rmdir: caml_unix_rmdir,
     caml_unix_mkdir: caml_unix_mkdir,
     caml_unix_lstat_64: caml_unix_lstat_64,
     caml_unix_lstat: caml_unix_lstat,
     caml_unix_stat_64: caml_unix_stat_64,
     caml_unix_stat: caml_unix_stat,
     make_unix_err_args: make_unix_err_args,
     caml_unix_isatty: caml_unix_isatty,
     caml_unix_filedescr_of_fd: caml_unix_filedescr_of_fd,
     caml_unix_cleanup: caml_unix_cleanup,
     caml_unix_startup: caml_unix_startup,
     caml_unix_mktime: caml_unix_mktime,
     caml_unix_localtime: caml_unix_localtime,
     caml_unix_gmtime: caml_unix_gmtime,
     caml_unix_time: caml_unix_time,
     caml_unix_gettimeofday: caml_unix_gettimeofday,
     caml_str_initialize: caml_str_initialize,
     re_replacement_text: re_replacement_text,
     re_partial_match: re_partial_match,
     re_string_match: re_string_match,
     re_search_backward: re_search_backward,
     re_search_forward: re_search_forward,
     re_match: re_match,
     caml_sys_is_regular_file: caml_sys_is_regular_file,
     caml_spacetime_only_works_for_native_code:
     caml_spacetime_only_works_for_native_code,
     caml_register_channel_for_spacetime: caml_register_channel_for_spacetime,
     caml_sys_const_naked_pointers_checked:
     caml_sys_const_naked_pointers_checked,
     caml_spacetime_enabled: caml_spacetime_enabled,
     caml_ml_runtime_warnings_enabled: caml_ml_runtime_warnings_enabled,
     caml_ml_enable_runtime_warnings: caml_ml_enable_runtime_warnings,
     caml_runtime_warnings: caml_runtime_warnings,
     caml_install_signal_handler: caml_install_signal_handler,
     caml_runtime_parameters: caml_runtime_parameters,
     caml_runtime_variant: caml_runtime_variant,
     caml_sys_isatty: caml_sys_isatty,
     caml_sys_get_config: caml_sys_get_config,
     os_type: os_type,
     caml_sys_const_backend_type: caml_sys_const_backend_type,
     caml_sys_const_ostype_cygwin: caml_sys_const_ostype_cygwin,
     caml_sys_const_ostype_win32: caml_sys_const_ostype_win32,
     caml_sys_const_ostype_unix: caml_sys_const_ostype_unix,
     caml_sys_const_max_wosize: caml_sys_const_max_wosize,
     caml_sys_const_int_size: caml_sys_const_int_size,
     caml_sys_const_word_size: caml_sys_const_word_size,
     caml_sys_const_big_endian: caml_sys_const_big_endian,
     caml_sys_random_seed: caml_sys_random_seed,
     caml_sys_time_include_children: caml_sys_time_include_children,
     caml_sys_time: caml_sys_time,
     caml_sys_system_command: caml_sys_system_command,
     caml_sys_executable_name: caml_sys_executable_name,
     caml_sys_modify_argv: caml_sys_modify_argv,
     caml_sys_argv: caml_sys_argv,
     caml_sys_get_argv: caml_sys_get_argv,
     caml_executable_name: caml_executable_name,
     caml_argv: caml_argv,
     caml_sys_unsafe_getenv: caml_sys_unsafe_getenv,
     caml_sys_getenv: caml_sys_getenv,
     jsoo_sys_getenv: jsoo_sys_getenv,
     caml_set_static_env: caml_set_static_env,
     caml_fatal_uncaught_exception: caml_fatal_uncaught_exception,
     caml_format_exception: caml_format_exception,
     caml_is_special_exception: caml_is_special_exception,
     caml_sys_exit: caml_sys_exit,
     caml_raise_sys_error: caml_raise_sys_error,
     caml_maybe_print_stats: caml_maybe_print_stats,
     caml_is_printable: caml_is_printable,
     caml_get_global_data: caml_get_global_data,
     caml_register_global: caml_register_global,
     caml_build_symbols: caml_build_symbols,
     caml_global_data: caml_global_data,
     caml_named_value: caml_named_value,
     caml_register_named_value: caml_register_named_value,
     caml_named_values: caml_named_values,
     caml_call_gen: caml_call_gen,
     caml_set_parser_trace: caml_set_parser_trace,
     caml_parse_engine: caml_parse_engine,
     caml_parser_trace: caml_parser_trace,
     caml_is_continuation_tag: caml_is_continuation_tag,
     caml_lazy_read_result: caml_lazy_read_result,
     caml_lazy_reset_to_lazy: caml_lazy_reset_to_lazy,
     caml_lazy_update_to_forward: caml_lazy_update_to_forward,
     caml_lazy_update_to_forcing: caml_lazy_update_to_forcing,
     caml_obj_update_tag: caml_obj_update_tag,
     caml_obj_add_offset: caml_obj_add_offset,
     caml_obj_reachable_words: caml_obj_reachable_words,
     caml_obj_set_raw_field: caml_obj_set_raw_field,
     caml_obj_raw_field: caml_obj_raw_field,
     caml_fresh_oo_id: caml_fresh_oo_id,
     caml_set_oo_id: caml_set_oo_id,
     caml_oo_last_id: caml_oo_last_id,
     caml_get_public_method: caml_get_public_method,
     caml_lazy_make_forward: caml_lazy_make_forward,
     caml_obj_is_shared: caml_obj_is_shared,
     caml_obj_compare_and_swap: caml_obj_compare_and_swap,
     caml_obj_make_forward: caml_obj_make_forward,
     caml_obj_truncate: caml_obj_truncate,
     caml_obj_dup: caml_obj_dup,
     caml_obj_with_tag: caml_obj_with_tag,
     caml_obj_block: caml_obj_block,
     caml_obj_set_tag: caml_obj_set_tag,
     caml_obj_tag: caml_obj_tag,
     caml_obj_is_block: caml_obj_is_block,
     caml_alloc_dummy_infix: caml_alloc_dummy_infix,
     caml_update_dummy: caml_update_dummy,
     deserialize_nat: deserialize_nat,
     serialize_nat: serialize_nat,
     lxor_digit_nat: lxor_digit_nat,
     lor_digit_nat: lor_digit_nat,
     land_digit_nat: land_digit_nat,
     compare_nat_real: compare_nat_real,
     compare_nat: compare_nat,
     compare_digits_nat: compare_digits_nat,
     shift_right_nat: shift_right_nat,
     div_nat: div_nat,
     div_digit_nat: div_digit_nat,
     div_helper: div_helper,
     shift_left_nat: shift_left_nat,
     square_nat: square_nat,
     mult_nat: mult_nat,
     mult_digit_nat: mult_digit_nat,
     sub_nat: sub_nat,
     decr_nat: decr_nat,
     complement_nat: complement_nat,
     add_nat: add_nat,
     incr_nat: incr_nat,
     is_digit_odd: is_digit_odd,
     is_digit_zero: is_digit_zero,
     is_digit_int: is_digit_int,
     num_leading_zero_bits_in_digit: num_leading_zero_bits_in_digit,
     num_digits_nat: num_digits_nat,
     nth_digit_nat_native: nth_digit_nat_native,
     set_digit_nat_native: set_digit_nat_native,
     nth_digit_nat: nth_digit_nat,
     set_digit_nat: set_digit_nat,
     blit_nat: blit_nat,
     set_to_zero_nat: set_to_zero_nat,
     create_nat: create_nat,
     nat_of_array: nat_of_array,
     length_nat: length_nat,
     caml_hash_nat: caml_hash_nat,
     MlNat: MlNat,
     initialize_nat: initialize_nat,
     caml_array_of_bytes: caml_array_of_bytes,
     caml_array_of_string: caml_array_of_string,
     caml_js_to_string: caml_js_to_string,
     caml_to_js_string: caml_to_js_string,
     caml_js_from_string: caml_js_from_string,
     caml_new_string: caml_new_string,
     caml_js_to_byte_string: caml_js_to_byte_string,
     caml_is_ml_string: caml_is_ml_string,
     caml_ml_bytes_content: caml_ml_bytes_content,
     caml_is_ml_bytes: caml_is_ml_bytes,
     caml_bytes_of_jsbytes: caml_bytes_of_jsbytes,
     caml_string_of_jsstring: caml_string_of_jsstring,
     caml_jsstring_of_string: caml_jsstring_of_string,
     caml_jsbytes_of_string: caml_jsbytes_of_string,
     caml_string_of_jsbytes: caml_string_of_jsbytes,
     caml_bytes_of_string: caml_bytes_of_string,
     caml_string_of_bytes: caml_string_of_bytes,
     caml_string_lessthan: caml_string_lessthan,
     caml_string_lessequal: caml_string_lessequal,
     caml_string_equal: caml_string_equal,
     caml_string_compare: caml_string_compare,
     caml_ml_string_length: caml_ml_string_length,
     caml_string_unsafe_set: caml_string_unsafe_set,
     caml_string_unsafe_get: caml_string_unsafe_get,
     caml_ml_bytes_length: caml_ml_bytes_length,
     caml_blit_string: caml_blit_string,
     caml_blit_bytes: caml_blit_bytes,
     caml_fill_bytes: caml_fill_bytes,
     caml_bytes_greaterthan: caml_bytes_greaterthan,
     caml_string_greaterthan: caml_string_greaterthan,
     caml_bytes_greaterequal: caml_bytes_greaterequal,
     caml_string_greaterequal: caml_string_greaterequal,
     caml_bytes_lessthan: caml_bytes_lessthan,
     caml_bytes_lessequal: caml_bytes_lessequal,
     caml_bytes_notequal: caml_bytes_notequal,
     caml_string_notequal: caml_string_notequal,
     caml_bytes_equal: caml_bytes_equal,
     caml_bytes_compare: caml_bytes_compare,
     caml_bytes_of_array: caml_bytes_of_array,
     caml_string_of_array: caml_string_of_array,
     caml_create_bytes: caml_create_bytes,
     caml_create_string: caml_create_string,
     caml_uint8_array_of_string: caml_uint8_array_of_string,
     caml_uint8_array_of_bytes: caml_uint8_array_of_bytes,
     caml_convert_bytes_to_array: caml_convert_bytes_to_array,
     caml_convert_string_to_bytes: caml_convert_string_to_bytes,
     MlBytes: MlBytes,
     caml_bytes_of_utf16_jsstring: caml_bytes_of_utf16_jsstring,
     caml_bytes_set: caml_bytes_set,
     caml_string_set64: caml_string_set64,
     caml_bytes_set64: caml_bytes_set64,
     caml_string_set32: caml_string_set32,
     caml_bytes_set32: caml_bytes_set32,
     caml_string_set16: caml_string_set16,
     caml_bytes_set16: caml_bytes_set16,
     caml_string_set: caml_string_set,
     caml_bytes_get: caml_bytes_get,
     caml_bytes_get64: caml_bytes_get64,
     caml_string_get64: caml_string_get64,
     caml_bytes_get32: caml_bytes_get32,
     caml_string_get32: caml_string_get32,
     caml_bytes_get16: caml_bytes_get16,
     caml_string_get16: caml_string_get16,
     caml_string_get: caml_string_get,
     caml_bytes_bound_error: caml_bytes_bound_error,
     caml_string_bound_error: caml_string_bound_error,
     caml_bytes_unsafe_set: caml_bytes_unsafe_set,
     caml_bytes_unsafe_get: caml_bytes_unsafe_get,
     jsoo_is_ascii: jsoo_is_ascii,
     caml_utf16_of_utf8: caml_utf16_of_utf8,
     caml_utf8_of_utf16: caml_utf8_of_utf16,
     caml_subarray_to_jsbytes: caml_subarray_to_jsbytes,
     caml_str_repeat: caml_str_repeat,
     caml_md5_bytes: caml_md5_bytes,
     caml_MD5Final: caml_MD5Final,
     caml_MD5Update: caml_MD5Update,
     caml_MD5Init: caml_MD5Init,
     caml_MD5Transform: caml_MD5Transform,
     caml_md5_string: caml_md5_string,
     caml_md5_chan: caml_md5_chan,
     caml_output_value_to_buffer: caml_output_value_to_buffer,
     caml_output_value_to_bytes: caml_output_value_to_bytes,
     caml_output_value_to_string: caml_output_value_to_string,
     caml_output_val: caml_output_val,
     MlObjectTable: MlObjectTable,
     caml_marshal_data_size: caml_marshal_data_size,
     caml_marshal_header_size: caml_marshal_header_size,
     caml_input_value_from_reader: caml_input_value_from_reader,
     caml_custom_ops: caml_custom_ops,
     caml_nativeint_unmarshal: caml_nativeint_unmarshal,
     caml_int32_unmarshal: caml_int32_unmarshal,
     caml_int64_marshal: caml_int64_marshal,
     caml_int64_unmarshal: caml_int64_unmarshal,
     caml_input_value_from_bytes: caml_input_value_from_bytes,
     caml_input_value_from_string: caml_input_value_from_string,
     caml_float_of_bytes: caml_float_of_bytes,
     BigStringReader: BigStringReader,
     MlStringReader: MlStringReader,
     UInt8ArrayReader: UInt8ArrayReader,
     caml_marshal_constants: caml_marshal_constants,
     caml_new_lex_engine: caml_new_lex_engine,
     caml_lex_engine: caml_lex_engine,
     caml_lex_array: caml_lex_array,
     caml_js_error_of_exception: caml_js_error_of_exception,
     caml_xmlhttprequest_create: caml_xmlhttprequest_create,
     caml_js_get_console: caml_js_get_console,
     caml_js_html_entities: caml_js_html_entities,
     caml_js_html_escape: caml_js_html_escape,
     caml_js_on_ie: caml_js_on_ie,
     caml_js_object: caml_js_object,
     caml_pure_js_expr: caml_pure_js_expr,
     caml_js_expr: caml_js_expr,
     caml_js_eval_string: caml_js_eval_string,
     caml_js_strict_equals: caml_js_strict_equals,
     caml_js_equals: caml_js_equals,
     caml_js_function_arity: caml_js_function_arity,
     caml_js_wrap_meth_callback_unsafe: caml_js_wrap_meth_callback_unsafe,
     caml_js_wrap_meth_callback_strict: caml_js_wrap_meth_callback_strict,
     caml_js_wrap_meth_callback_arguments:
     caml_js_wrap_meth_callback_arguments,
     caml_js_wrap_meth_callback: caml_js_wrap_meth_callback,
     caml_js_wrap_callback_unsafe: caml_js_wrap_callback_unsafe,
     caml_js_wrap_callback_strict: caml_js_wrap_callback_strict,
     caml_js_wrap_callback_arguments: caml_js_wrap_callback_arguments,
     caml_js_wrap_callback: caml_js_wrap_callback,
     caml_ojs_new_arr: caml_ojs_new_arr,
     caml_js_new: caml_js_new,
     caml_js_meth_call: caml_js_meth_call,
     caml_js_fun_call: caml_js_fun_call,
     caml_js_call: caml_js_call,
     caml_js_var: caml_js_var,
     caml_list_to_js_array: caml_list_to_js_array,
     caml_list_of_js_array: caml_list_of_js_array,
     caml_js_to_array: caml_js_to_array,
     caml_js_from_array: caml_js_from_array,
     caml_js_to_int32: caml_js_to_int32,
     caml_js_to_float: caml_js_to_float,
     caml_js_from_float: caml_js_from_float,
     caml_js_to_bool: caml_js_to_bool,
     caml_js_from_bool: caml_js_from_bool,
     caml_js_error_option_of_exception: caml_js_error_option_of_exception,
     caml_exn_with_js_backtrace: caml_exn_with_js_backtrace,
     caml_maybe_attach_backtrace: caml_maybe_attach_backtrace,
     caml_wrap_exception: caml_wrap_exception,
     caml_jsoo_flags_effects: caml_jsoo_flags_effects,
     caml_jsoo_flags_use_js_string: caml_jsoo_flags_use_js_string,
     caml_is_js: caml_is_js,
     caml_callback: caml_callback,
     caml_trampoline_return: caml_trampoline_return,
     caml_trampoline: caml_trampoline,
     caml_js_typeof: caml_js_typeof,
     caml_js_instanceof: caml_js_instanceof,
     caml_js_delete: caml_js_delete,
     caml_js_get: caml_js_get,
     caml_js_set: caml_js_set,
     caml_js_pure_expr: caml_js_pure_expr,
     caml_ml_set_buffered: caml_ml_set_buffered,
     caml_ml_is_buffered: caml_ml_is_buffered,
     caml_ml_output_int: caml_ml_output_int,
     caml_ml_pos_out_64: caml_ml_pos_out_64,
     caml_ml_pos_out: caml_ml_pos_out,
     caml_pos_out: caml_pos_out,
     caml_ml_seek_out_64: caml_ml_seek_out_64,
     caml_ml_seek_out: caml_ml_seek_out,
     caml_seek_out: caml_seek_out,
     caml_output_value: caml_output_value,
     caml_ml_output_char: caml_ml_output_char,
     caml_ml_output: caml_ml_output,
     caml_ml_output_bigarray: caml_ml_output_bigarray,
     caml_ml_output_bytes: caml_ml_output_bytes,
     caml_ml_output_ta: caml_ml_output_ta,
     caml_ml_flush: caml_ml_flush,
     caml_ml_input_scan_line: caml_ml_input_scan_line,
     caml_ml_pos_in_64: caml_ml_pos_in_64,
     caml_ml_pos_in: caml_ml_pos_in,
     caml_pos_in: caml_pos_in,
     caml_ml_seek_in_64: caml_ml_seek_in_64,
     caml_ml_seek_in: caml_ml_seek_in,
     caml_seek_in: caml_seek_in,
     caml_ml_input_int: caml_ml_input_int,
     caml_ml_input_char: caml_ml_input_char,
     caml_input_value_to_outside_heap: caml_input_value_to_outside_heap,
     caml_input_value: caml_input_value,
     caml_ml_input_block: caml_ml_input_block,
     caml_ml_input_bigarray: caml_ml_input_bigarray,
     caml_ml_input: caml_ml_input,
     caml_refill: caml_refill,
     caml_ml_set_channel_refill: caml_ml_set_channel_refill,
     caml_ml_set_channel_output: caml_ml_set_channel_output,
     caml_ml_channel_size_64: caml_ml_channel_size_64,
     caml_ml_channel_size: caml_ml_channel_size,
     caml_ml_close_channel: caml_ml_close_channel,
     caml_ml_set_binary_mode: caml_ml_set_binary_mode,
     caml_channel_descriptor: caml_channel_descriptor,
     caml_ml_open_descriptor_out_with_flags:
     caml_ml_open_descriptor_out_with_flags,
     caml_ml_open_descriptor_in_with_flags:
     caml_ml_open_descriptor_in_with_flags,
     caml_ml_open_descriptor_in: caml_ml_open_descriptor_in,
     caml_ml_open_descriptor_out: caml_ml_open_descriptor_out,
     caml_ml_out_channels_list: caml_ml_out_channels_list,
     caml_ml_channels: caml_ml_channels,
     caml_ml_set_channel_name: caml_ml_set_channel_name,
     caml_sys_open: caml_sys_open,
     caml_sys_close: caml_sys_close,
     caml_sys_fds: caml_sys_fds,
     caml_int64_bswap: caml_int64_bswap,
     caml_int32_bswap: caml_int32_bswap,
     caml_bswap16: caml_bswap16,
     caml_mod: caml_mod,
     caml_div: caml_div,
     caml_mul: caml_mul,
     caml_int_of_string: caml_int_of_string,
     caml_parse_digit: caml_parse_digit,
     caml_parse_sign_and_base: caml_parse_sign_and_base,
     caml_format_int: caml_format_int,
     caml_int64_hash: caml_int64_hash,
     caml_int64_to_bytes: caml_int64_to_bytes,
     caml_int64_of_bytes: caml_int64_of_bytes,
     caml_int64_hi32: caml_int64_hi32,
     caml_int64_lo32: caml_int64_lo32,
     caml_int64_create_lo_hi: caml_int64_create_lo_hi,
     caml_int64_create_lo_mi_hi: caml_int64_create_lo_mi_hi,
     caml_int64_of_string: caml_int64_of_string,
     caml_int64_format: caml_int64_format,
     caml_int64_of_float: caml_int64_of_float,
     caml_int64_to_float: caml_int64_to_float,
     caml_int64_to_int32: caml_int64_to_int32,
     caml_int64_of_int32: caml_int64_of_int32,
     caml_int64_mod: caml_int64_mod,
     caml_int64_div: caml_int64_div,
     caml_int64_shift_right: caml_int64_shift_right,
     caml_int64_shift_right_unsigned: caml_int64_shift_right_unsigned,
     caml_int64_shift_left: caml_int64_shift_left,
     caml_int64_xor: caml_int64_xor,
     caml_int64_or: caml_int64_or,
     caml_int64_and: caml_int64_and,
     caml_int64_is_negative: caml_int64_is_negative,
     caml_int64_is_zero: caml_int64_is_zero,
     caml_int64_mul: caml_int64_mul,
     caml_int64_sub: caml_int64_sub,
     caml_int64_add: caml_int64_add,
     caml_int64_neg: caml_int64_neg,
     caml_int64_compare: caml_int64_compare,
     caml_int64_ult: caml_int64_ult,
     MlInt64: MlInt64,
     caml_int64_offset: caml_int64_offset,
     caml_float_of_string: caml_float_of_string,
     caml_format_float: caml_format_float,
     caml_fma_float: caml_fma_float,
     caml_erfc_float: caml_erfc_float,
     caml_erf_float: caml_erf_float,
     caml_cbrt_float: caml_cbrt_float,
     caml_round_float: caml_round_float,
     caml_atanh_float: caml_atanh_float,
     caml_tanh_float: caml_tanh_float,
     caml_asinh_float: caml_asinh_float,
     caml_sinh_float: caml_sinh_float,
     caml_acosh_float: caml_acosh_float,
     caml_cosh_float: caml_cosh_float,
     caml_log10_float: caml_log10_float,
     caml_hypot_float: caml_hypot_float,
     caml_log2_float: caml_log2_float,
     caml_log1p_float: caml_log1p_float,
     caml_exp2_float: caml_exp2_float,
     caml_expm1_float: caml_expm1_float,
     caml_signbit_float: caml_signbit_float,
     caml_copysign_float: caml_copysign_float,
     caml_float_compare: caml_float_compare,
     caml_frexp_float: caml_frexp_float,
     caml_ldexp_float: caml_ldexp_float,
     caml_modf_float: caml_modf_float,
     caml_classify_float: caml_classify_float,
     caml_int32_float_of_bits: caml_int32_float_of_bits,
     caml_trunc_float: caml_trunc_float,
     caml_nextafter_float: caml_nextafter_float,
     caml_int64_float_of_bits: caml_int64_float_of_bits,
     caml_hexstring_of_float: caml_hexstring_of_float,
     caml_int32_bits_of_float: caml_int32_bits_of_float,
     caml_int64_bits_of_float: caml_int64_bits_of_float,
     jsoo_floor_log2: jsoo_floor_log2,
     caml_string_hash: caml_string_hash,
     caml_hash: caml_hash,
     caml_hash_mix_string: caml_hash_mix_string,
     caml_hash_mix_bytes: caml_hash_mix_bytes,
     caml_hash_mix_bytes_arr: caml_hash_mix_bytes_arr,
     caml_hash_mix_jsbytes: caml_hash_mix_jsbytes,
     caml_hash_mix_int64: caml_hash_mix_int64,
     caml_hash_mix_float: caml_hash_mix_float,
     caml_hash_mix_final: caml_hash_mix_final,
     caml_hash_mix_int: caml_hash_mix_int,
     caml_gr_close_subwindow: caml_gr_close_subwindow,
     caml_gr_open_subwindow: caml_gr_open_subwindow,
     caml_gr_window_id: caml_gr_window_id,
     caml_gr_display_mode: caml_gr_display_mode,
     caml_gr_remember_mode: caml_gr_remember_mode,
     caml_gr_synchronize: caml_gr_synchronize,
     caml_gr_wait_event: caml_gr_wait_event,
     caml_gr_sigio_signal: caml_gr_sigio_signal,
     caml_gr_sigio_handler: caml_gr_sigio_handler,
     caml_gr_blit_image: caml_gr_blit_image,
     caml_gr_create_image: caml_gr_create_image,
     caml_gr_draw_image: caml_gr_draw_image,
     caml_gr_dump_image: caml_gr_dump_image,
     caml_gr_make_image: caml_gr_make_image,
     caml_gr_text_size: caml_gr_text_size,
     caml_gr_set_text_size: caml_gr_set_text_size,
     caml_gr_set_font: caml_gr_set_font,
     caml_gr_draw_string: caml_gr_draw_string,
     caml_gr_draw_char: caml_gr_draw_char,
     caml_gr_draw_str: caml_gr_draw_str,
     caml_gr_fill_arc: caml_gr_fill_arc,
     caml_gr_fill_poly: caml_gr_fill_poly,
     caml_gr_fill_rect: caml_gr_fill_rect,
     caml_gr_set_line_width: caml_gr_set_line_width,
     caml_gr_draw_arc: caml_gr_draw_arc,
     caml_gr_arc_aux: caml_gr_arc_aux,
     caml_gr_draw_rect: caml_gr_draw_rect,
     caml_gr_lineto: caml_gr_lineto,
     caml_gr_current_y: caml_gr_current_y,
     caml_gr_current_x: caml_gr_current_x,
     caml_gr_moveto: caml_gr_moveto,
     caml_gr_point_color: caml_gr_point_color,
     caml_gr_plot: caml_gr_plot,
     caml_gr_set_color: caml_gr_set_color,
     caml_gr_size_y: caml_gr_size_y,
     caml_gr_size_x: caml_gr_size_x,
     caml_gr_clear_graph: caml_gr_clear_graph,
     caml_gr_resize_window: caml_gr_resize_window,
     caml_gr_set_window_title: caml_gr_set_window_title,
     caml_gr_close_graph: caml_gr_close_graph,
     caml_gr_doc_of_state: caml_gr_doc_of_state,
     caml_gr_state_create: caml_gr_state_create,
     caml_gr_state_init: caml_gr_state_init,
     caml_gr_open_graph: caml_gr_open_graph,
     caml_gr_state_set: caml_gr_state_set,
     caml_gr_state_get: caml_gr_state_get,
     caml_gr_state: caml_gr_state,
     caml_get_major_credit: caml_get_major_credit,
     caml_get_major_bucket: caml_get_major_bucket,
     caml_get_minor_free: caml_get_minor_free,
     caml_gc_minor_words: caml_gc_minor_words,
     caml_gc_major_slice: caml_gc_major_slice,
     caml_gc_huge_fallback_count: caml_gc_huge_fallback_count,
     caml_eventlog_pause: caml_eventlog_pause,
     caml_eventlog_resume: caml_eventlog_resume,
     caml_memprof_discard: caml_memprof_discard,
     caml_memprof_stop: caml_memprof_stop,
     caml_memprof_start: caml_memprof_start,
     caml_final_release: caml_final_release,
     caml_final_register_called_without_value:
     caml_final_register_called_without_value,
     caml_final_register: caml_final_register,
     caml_memprof_set: caml_memprof_set,
     caml_gc_get: caml_gc_get,
     caml_gc_set: caml_gc_set,
     caml_gc_stat: caml_gc_stat,
     caml_gc_quick_stat: caml_gc_quick_stat,
     caml_gc_counters: caml_gc_counters,
     caml_gc_compaction: caml_gc_compaction,
     caml_gc_full_major: caml_gc_full_major,
     caml_gc_major: caml_gc_major,
     caml_gc_minor: caml_gc_minor,
     caml_sys_open_for_node: caml_sys_open_for_node,
     MlNodeFd: MlNodeFd,
     MlNodeDevice: MlNodeDevice,
     fs_node_supported: fs_node_supported,
     MlFakeFd: MlFakeFd,
     MlFakeFd_out: MlFakeFd_out,
     MlFakeFile: MlFakeFile,
     MlFakeDevice: MlFakeDevice,
     caml_read_file_content: caml_read_file_content,
     jsoo_create_file: jsoo_create_file,
     caml_create_file: caml_create_file,
     caml_fs_init: caml_fs_init,
     jsoo_create_file_extern: jsoo_create_file_extern,
     caml_ba_map_file_bytecode: caml_ba_map_file_bytecode,
     caml_ba_map_file: caml_ba_map_file,
     caml_sys_rmdir: caml_sys_rmdir,
     caml_sys_mkdir: caml_sys_mkdir,
     caml_sys_rename: caml_sys_rename,
     caml_sys_is_directory: caml_sys_is_directory,
     caml_sys_remove: caml_sys_remove,
     caml_sys_read_directory: caml_sys_read_directory,
     caml_sys_file_exists: caml_sys_file_exists,
     caml_raise_not_a_dir: caml_raise_not_a_dir,
     caml_raise_no_such_file: caml_raise_no_such_file,
     caml_sys_chdir: caml_sys_chdir,
     caml_sys_getcwd: caml_sys_getcwd,
     caml_unmount: caml_unmount,
     caml_mount_autoload: caml_mount_autoload,
     resolve_fs_device: resolve_fs_device,
     caml_list_mount_point: caml_list_mount_point,
     jsoo_mount_point: jsoo_mount_point,
     caml_make_path: caml_make_path,
     path_is_absolute: path_is_absolute,
     MlFile: MlFile,
     caml_root: caml_root,
     caml_get_root: caml_get_root,
     caml_current_dir: caml_current_dir,
     caml_trailing_slash: caml_trailing_slash,
     caml_finish_formatting: caml_finish_formatting,
     caml_parse_format: caml_parse_format,
     caml_array_bound_error: caml_array_bound_error,
     caml_raise_not_found: caml_raise_not_found,
     caml_raise_zero_divide: caml_raise_zero_divide,
     caml_raise_end_of_file: caml_raise_end_of_file,
     caml_invalid_argument: caml_invalid_argument,
     caml_failwith: caml_failwith,
     caml_raise_with_string: caml_raise_with_string,
     caml_raise_with_args: caml_raise_with_args,
     caml_raise_with_arg: caml_raise_with_arg,
     caml_raise_constant: caml_raise_constant,
     caml_lessthan: caml_lessthan,
     caml_lessequal: caml_lessequal,
     caml_greaterthan: caml_greaterthan,
     caml_greaterequal: caml_greaterequal,
     caml_notequal: caml_notequal,
     caml_equal: caml_equal,
     caml_int_compare: caml_int_compare,
     caml_compare: caml_compare,
     caml_compare_val: caml_compare_val,
     caml_compare_val_number_custom: caml_compare_val_number_custom,
     caml_compare_val_get_custom: caml_compare_val_get_custom,
     caml_compare_val_tag: caml_compare_val_tag,
     caml_bigstring_blit_ba_to_bytes: caml_bigstring_blit_ba_to_bytes,
     caml_bigstring_blit_bytes_to_ba: caml_bigstring_blit_bytes_to_ba,
     caml_bigstring_blit_string_to_ba: caml_bigstring_blit_string_to_ba,
     caml_bigstring_blit_ba_to_ba: caml_bigstring_blit_ba_to_ba,
     caml_bigstring_memcmp: caml_bigstring_memcmp,
     bigstring_of_typed_array: bigstring_of_typed_array,
     bigstring_of_array_buffer: bigstring_of_array_buffer,
     bigstring_to_typed_array: bigstring_to_typed_array,
     bigstring_to_array_buffer: bigstring_to_array_buffer,
     caml_hash_mix_bigstring: caml_hash_mix_bigstring,
     caml_ba_from_typed_array: caml_ba_from_typed_array,
     caml_ba_kind_of_typed_array: caml_ba_kind_of_typed_array,
     caml_ba_to_typed_array: caml_ba_to_typed_array,
     caml_ba_hash: caml_ba_hash,
     caml_ba_create_from: caml_ba_create_from,
     caml_ba_deserialize: caml_ba_deserialize,
     caml_ba_serialize: caml_ba_serialize,
     caml_ba_reshape: caml_ba_reshape,
     caml_ba_slice: caml_ba_slice,
     caml_ba_sub: caml_ba_sub,
     caml_ba_blit: caml_ba_blit,
     caml_ba_fill: caml_ba_fill,
     caml_ba_set_3: caml_ba_set_3,
     caml_ba_set_2: caml_ba_set_2,
     caml_ba_set_1: caml_ba_set_1,
     caml_ba_uint8_set64: caml_ba_uint8_set64,
     caml_ba_uint8_set32: caml_ba_uint8_set32,
     caml_ba_uint8_set16: caml_ba_uint8_set16,
     caml_ba_set_generic: caml_ba_set_generic,
     caml_ba_get_3: caml_ba_get_3,
     caml_ba_get_2: caml_ba_get_2,
     caml_ba_get_1: caml_ba_get_1,
     caml_ba_uint8_get64: caml_ba_uint8_get64,
     caml_ba_uint8_get32: caml_ba_uint8_get32,
     caml_ba_uint8_get16: caml_ba_uint8_get16,
     caml_ba_get_generic: caml_ba_get_generic,
     caml_ba_dim_3: caml_ba_dim_3,
     caml_ba_dim_2: caml_ba_dim_2,
     caml_ba_dim_1: caml_ba_dim_1,
     caml_ba_dim: caml_ba_dim,
     caml_ba_num_dims: caml_ba_num_dims,
     caml_ba_layout: caml_ba_layout,
     caml_ba_kind: caml_ba_kind,
     caml_ba_change_layout: caml_ba_change_layout,
     caml_ba_create: caml_ba_create,
     caml_ba_create_unsafe: caml_ba_create_unsafe,
     caml_ba_compare: caml_ba_compare,
     Ml_Bigarray_c_1_1: Ml_Bigarray_c_1_1,
     Ml_Bigarray: Ml_Bigarray,
     caml_ba_custom_name: caml_ba_custom_name,
     caml_ba_create_buffer: caml_ba_create_buffer,
     caml_ba_get_size_per_element: caml_ba_get_size_per_element,
     caml_ba_get_size: caml_ba_get_size,
     caml_ba_init: caml_ba_init,
     caml_convert_raw_backtrace_slot: caml_convert_raw_backtrace_slot,
     caml_get_current_callstack: caml_get_current_callstack,
     caml_restore_raw_backtrace: caml_restore_raw_backtrace,
     caml_raw_backtrace_slot: caml_raw_backtrace_slot,
     caml_raw_backtrace_next_slot: caml_raw_backtrace_next_slot,
     caml_raw_backtrace_length: caml_raw_backtrace_length,
     caml_convert_raw_backtrace: caml_convert_raw_backtrace,
     caml_record_backtrace: caml_record_backtrace,
     caml_get_exception_raw_backtrace: caml_get_exception_raw_backtrace,
     caml_get_exception_backtrace: caml_get_exception_backtrace,
     caml_backtrace_status: caml_backtrace_status,
     caml_ml_debug_info_status: caml_ml_debug_info_status,
     caml_record_backtrace_flag: caml_record_backtrace_flag,
     caml_floatarray_create: caml_floatarray_create,
     caml_make_float_vect: caml_make_float_vect,
     caml_make_vect: caml_make_vect,
     caml_check_bound: caml_check_bound,
     caml_array_fill: caml_array_fill,
     caml_array_get: caml_array_get,
     caml_array_set: caml_array_set,
     caml_floatarray_blit: caml_floatarray_blit,
     caml_array_blit: caml_array_blit,
     caml_array_concat: caml_array_concat,
     caml_array_append: caml_array_append,
     caml_array_sub: caml_array_sub};
   var
    cst_Assert_failure = "Assert_failure",
    cst_Division_by_zero = "Division_by_zero",
    cst_End_of_file = "End_of_file",
    cst_Failure = "Failure",
    cst_Invalid_argument = "Invalid_argument",
    cst_Match_failure = "Match_failure",
    cst_Not_found = "Not_found",
    cst_Out_of_memory = "Out_of_memory",
    cst_Stack_overflow = "Stack_overflow",
    cst_Sys_blocked_io = "Sys_blocked_io",
    cst_Sys_error = "Sys_error",
    cst_Undefined_recursive_module = "Undefined_recursive_module";
   caml_fs_init();
   caml_register_global(0, [248, cst_Out_of_memory, -1], cst_Out_of_memory);
   caml_register_global(1, [248, cst_Sys_error, -2], cst_Sys_error);
   caml_register_global(2, [248, cst_Failure, -3], cst_Failure);
   caml_register_global
    (3, [248, cst_Invalid_argument, -4], cst_Invalid_argument);
   caml_register_global(4, [248, cst_End_of_file, -5], cst_End_of_file);
   caml_register_global
    (5, [248, cst_Division_by_zero, -6], cst_Division_by_zero);
   caml_register_global(6, [248, cst_Not_found, -7], cst_Not_found);
   caml_register_global(7, [248, cst_Match_failure, -8], cst_Match_failure);
   caml_register_global(8, [248, cst_Stack_overflow, -9], cst_Stack_overflow);
   caml_register_global(9, [248, cst_Sys_blocked_io, -10], cst_Sys_blocked_io);
   caml_register_global
    (10, [248, cst_Assert_failure, -11], cst_Assert_failure);
   caml_register_global
    (11,
     [248, cst_Undefined_recursive_module, -12],
     cst_Undefined_recursive_module);
   return;
  }
  (globalThis));


(function(a){"use strict";var
aX="Stdlib__Obj",a_="Brr_webworkers",bw="Cmarkit_data",s="Stdlib__Gc",a9="Stdlib__Random",bv="Str",r=116,aH="Stdlib__Either",I="Cmarkit_base",J="Stdlib__Map",aW="Stdlib__Domain",a8="Stdlib__Array",W="Assert_failure",bu="Cmarkit_data_uchar",q="Stdlib__Lazy",ar="Jv",a7="Jsoo_runtime__",H="Stdlib__Format",aq="Stdlib__In_channel",V="Stdlib__BytesLabels",aG="Yojson__Raw",bt="Stdlib__Bytes",G="End_of_file",aV="Brr_webgpu",bs="Stdlib__Condition",U="Stdlib__Marshal",br="Jstr",bq="Out_of_memory",aF="Not_found",a6="Cmarkit_html",bp="Failure",aU="Yojson",a5="Jsoo_runtime__Runtime_version",a4="Stdlib__String",bo="Stdlib__Printf",ap="Stdlib",bn="Brr_canvas",aT="Stdlib__Callback",ao="Stdlib__Filename",aS="Stdlib__Hashtbl",an="Yojson__Safe",p="Invalid_argument",aR="Yojson__Basic",bm="Stdlib__Mutex",F="Stdlib__Option",bl="Stdlib__ListLabels",aQ="Stdlib__MoreLabels",o="Std_exit",E="Result",bj="Match_failure",bk="Stdlib__Semaphore",n="Stdlib__StringLabels",bh=109,bi="Yojson__Lexer_utils",m=112,a3="Stdlib__Complex",am="Stdlib__Int64",T=118,a2="Stdlib__Sys",aE="CamlinternalLazy",D="Brr_webmidi",bg="Fabula__Common",l="Stdlib__Scanf",aD="Cmarkit_commonmark",bf="Stdlib__Digest",R="Fut",S="Stdlib__Char",aC="Ppx_deriving_yojson_runtime",C="Cmarkit",Q="Stdlib__Int32",B="Sys_error",be="Stdlib__Type",al=107,a1="Stdlib__Unit",bd="Stdlib__Nativeint",bc="Stdlib__Stack",A="CamlinternalFormat",k="Cmarkit_latex",P="Stack_overflow",aB="Stdlib__ArrayLabels",aP="Stdlib__Printexc",j=108,O="Stdlib__Arg",aA="Brr_io",ak="Undefined_recursive_module",aj="CamlinternalFormatBasics",ai="Stdlib__Queue",i="Stdlib__Bool",z="Jsoo_runtime",aO="Division_by_zero",ag="CamlinternalMod",ah="Cmarkit_data_html",af=114,ae="Stdlib__Parsing",aN="Stdlib__Weak",y=110,ad=113,ac="Stdlib__Effect",aL="Brr_webaudio",aM=101,h="Stdlib__Int",x="Stdlib__StdLabels",g="Stdlib__Oo",aa="Stdlib__Bigarray",ab="Stdlib__List",az="Stdlib__Ephemeron",aK="Fabula__",a0="Yojson__Common",aJ=100,aZ="Cmarkit_renderer",f=106,$=111,ay="Stdlib__Fun",e=117,N="Stdlib__Lexing",w=102,bb="Stdlib__Atomic",ax="Stdlib__Result",_="Stdlib__Set",aw="Stdlib__Buffer",aY="Yojson__",av="Stdlib__Out_channel",v="Fabula",aI="Brr",ba="Ppx_deriving_runtime",u="Stdlib__Seq",d=103,M=115,a$="Brr_webcrypto",Z="Sys_blocked_io",L="Stdlib__Float",Y="Stdlib__Uchar",au=105,X="Dune__exe__Fablejs",t="CamlinternalOO",at="Yojson__Codec",K=104,as="Yojson__T",c=a.jsoo_runtime,b=c.caml_get_global_data();b.prim_count=864;b.tocjs=[0,[0,as,m],[0,an,$],[0,aG,y],[0,bi,j],[0,a0,al],[0,at,f],[0,aR,bh],[0,aY,au],[0,aU,ad],[0,ak,11],[0,B,10],[0,Z,9],[0,bv,92],[0,aN,59],[0,a1,31],[0,Y,26],[0,be,17],[0,a2,15],[0,n,72],[0,a4,30],[0,x,74],[0,bc,42],[0,_,40],[0,u,21],[0,bk,47],[0,l,61],[0,ax,23],[0,a9,57],[0,ai,43],[0,bo,50],[0,aP,52],[0,ae,39],[0,av,76],[0,F,22],[0,g,64],[0,aX,16],[0,bd,37],[0,bm,45],[0,aQ,73],[0,U,32],[0,J,41],[0,bl,70],[0,ab,27],[0,N,38],[0,q,20],[0,am,36],[0,Q,35],[0,h,28],[0,aq,75],[0,aS,58],[0,s,54],[0,ay,53],[0,H,60],[0,L,34],[0,ao,67],[0,az,66],[0,aH,14],[0,ac,77],[0,aW,48],[0,bf,55],[0,bs,46],[0,a3,68],[0,S,25],[0,aT,62],[0,V,71],[0,bt,29],[0,aw,44],[0,i,24],[0,aa,56],[0,bb,18],[0,aB,69],[0,a8,33],[0,O,51],[0,ap,13],[0,o,T],[0,P,8],[0,E,w],[0,aC,K],[0,ba,d],[0,bq,7],[0,aF,6],[0,bj,5],[0,ar,82],[0,br,81],[0,a5,79],[0,a7,78],[0,z,80],[0,p,4],[0,R,83],[0,bp,3],[0,bg,M],[0,aK,af],[0,v,r],[0,G,2],[0,X,e],[0,aO,1],[0,aZ,98],[0,k,aM],[0,a6,aJ],[0,bu,94],[0,ah,93],[0,bw,95],[0,aD,99],[0,I,96],[0,C,97],[0,t,63],[0,ag,65],[0,aE,19],[0,aj,12],[0,A,49],[0,a_,91],[0,D,90],[0,aV,87],[0,a$,89],[0,aL,88],[0,aA,85],[0,bn,86],[0,aI,84],[0,W,0]];var
bx=[2,a$],by=[2,a_],bz=[2,C],bA=[2,aD],bB=[2,k],bC=[2,v],bD=[2,bg],bE=[2,as];b.toc=[0,[0,119,[0,[0,[0,[0,[0,[0,[0,0,[2,W],0,0,1],[2,aI],84,[0,0,[2,bn],86,0,1],2],[2,aA],85,[0,[0,[0,0,[2,aL],88,[0,0,bx,89,0,1],2],[2,aV],87,[0,0,[2,D],90,[0,0,by,91,0,1],2],3],[2,A],49,[0,0,[2,aj],12,0,1],4],5],[2,aE],19,[0,[0,[0,0,[2,ag],65,0,1],[2,t],63,[0,[0,[0,0,bz,97,0,1],[2,I],96,[0,0,bA,99,0,1],2],[2,bw],95,0,3],4],[2,ah],93,[0,[0,[0,0,[2,bu],94,0,1],[2,a6],aJ,[0,[0,0,bB,aM,0,1],[2,aZ],98,0,2],3],[2,aO],1,[0,[0,0,[2,X],e,0,1],[2,G],2,[0,[0,0,bC,r,0,1],[2,aK],af,[0,0,bD,M,0,1],2],3],4],5],6],[2,bp],3,[0,[0,[0,[0,0,[2,R],83,0,1],[2,p],4,[0,0,[2,z],80,0,1],2],[2,a7],78,[0,0,[2,a5],79,[0,0,[2,br],81,[0,0,[2,ar],82,0,1],2],3],4],[2,bj],5,[0,[0,0,[2,aF],6,0,1],[2,bq],7,[0,[0,0,[2,ba],d,[0,0,[2,aC],K,0,1],2],[2,E],w,[0,0,[2,P],8,[0,0,[2,o],T,0,1],2],3],4],5],7],[2,ap],13,[0,[0,[0,[0,0,[2,O],51,0,1],[2,a8],33,[0,0,[2,aB],69,0,1],2],[2,bb],18,[0,0,[2,aa],56,0,1],3],[2,i],24,[0,[0,[0,0,[2,aw],44,0,1],[2,bt],29,[0,[0,0,[2,V],71,0,1],[2,aT],62,0,2],3],[2,S],25,[0,[0,0,[2,a3],68,0,1],[2,bs],46,[0,[0,0,[2,bf],55,0,1],[2,aW],48,[0,0,[2,ac],77,0,1],2],3],4],5],8],[2,aH],14,[0,[0,[0,[0,[0,[0,0,[2,az],66,[0,0,[2,ao],67,0,1],2],[2,L],34,[0,0,[2,H],60,0,1],3],[2,ay],53,[0,0,[2,s],54,[0,0,[2,aS],58,[0,0,[2,aq],75,0,1],2],3],4],[2,h],28,[0,0,[2,Q],35,[0,0,[2,am],36,0,1],2],5],[2,q],20,[0,[0,[0,0,[2,N],38,0,1],[2,ab],27,[0,[0,0,[2,bl],70,0,1],[2,J],41,0,2],3],[2,U],32,[0,[0,[0,0,[2,aQ],73,0,1],[2,bm],45,0,2],[2,bd],37,0,3],4],6],[2,aX],16,[0,[0,[0,[0,[0,[0,0,[2,g],64,0,1],[2,F],22,[0,0,[2,av],76,0,1],2],[2,ae],39,[0,[0,0,[2,aP],52,0,1],[2,bo],50,0,2],3],[2,ai],43,[0,[0,0,[2,a9],57,0,1],[2,ax],23,[0,[0,0,[2,l],61,0,1],[2,bk],47,0,2],3],4],[2,u],21,[0,[0,0,[2,_],40,[0,0,[2,bc],42,[0,0,[2,x],74,0,1],2],3],[2,a4],30,[0,0,[2,n],72,0,1],4],5],[2,a2],15,[0,[0,[0,0,[2,be],17,0,1],[2,Y],26,[0,0,[2,a1],31,[0,0,[2,aN],59,[0,0,[2,bv],92,0,1],2],3],4],[2,Z],9,[0,[0,[0,0,[2,B],10,0,1],[2,ak],11,[0,[0,0,[2,aU],ad,0,1],[2,aY],au,[0,0,[2,aR],bh,0,1],2],3],[2,at],f,[0,[0,0,[2,a0],al,0,1],[2,bi],j,[0,0,[2,aG],y,[0,0,[2,an],$,[0,0,bE,m,0,1],2],3],4],5],6],7],8],9]],0,c.caml_list_of_js_array(["%caml_format_int_special","%direct_int_div","%direct_int_mod","%direct_int_mul","%direct_obj_tag","%identity","%int_add","%int_and","%int_asr","%int_div","%int_lsl","%int_lsr","%int_mod","%int_mul","%int_neg","%int_or","%int_sub","%int_xor","BigStringReader","MlBytes","MlFakeDevice","MlFakeFd","MlFakeFd_out","MlFakeFile","MlFile","MlInt64","MlMutex","MlNat","MlNodeDevice","MlNodeFd","MlObjectTable","MlStringReader","Ml_Bigarray","Ml_Bigarray_c_1_1","UInt8ArrayReader","add_nat","bigstring_of_array_buffer","bigstring_of_typed_array","bigstring_to_array_buffer","bigstring_to_typed_array","blit_nat","caml_MD5Final","caml_MD5Init","caml_MD5Transform","caml_MD5Update","caml_abs_float","caml_acos_float","caml_acosh_float","caml_add_float","caml_alloc_dummy","caml_alloc_dummy_float","caml_alloc_dummy_infix","caml_alloc_stack","caml_argv","caml_array_append","caml_array_blit","caml_array_bound_error","caml_array_concat","caml_array_fill","caml_array_get","caml_array_get_addr","caml_array_get_float","caml_array_of_bytes","caml_array_of_string","caml_array_set","caml_array_set_addr","caml_array_set_float","caml_array_sub","caml_array_unsafe_get","caml_array_unsafe_get_float","caml_array_unsafe_set","caml_array_unsafe_set_float","caml_asin_float","caml_asinh_float","caml_atan2_float","caml_atan_float","caml_atanh_float","caml_atomic_cas","caml_atomic_exchange","caml_atomic_fetch_add","caml_atomic_load","caml_atomic_make_contended","caml_ba_blit","caml_ba_change_layout","caml_ba_compare","caml_ba_create","caml_ba_create_buffer","caml_ba_create_from","caml_ba_create_unsafe","caml_ba_custom_name","caml_ba_deserialize","caml_ba_dim","caml_ba_dim_1","caml_ba_dim_2","caml_ba_dim_3","caml_ba_fill","caml_ba_from_typed_array","caml_ba_get_1","caml_ba_get_2","caml_ba_get_3","caml_ba_get_generic","caml_ba_get_size","caml_ba_get_size_per_element","caml_ba_hash","caml_ba_init","caml_ba_kind","caml_ba_kind_of_typed_array","caml_ba_layout","caml_ba_map_file","caml_ba_map_file_bytecode","caml_ba_num_dims","caml_ba_reshape","caml_ba_serialize","caml_ba_set_1","caml_ba_set_2","caml_ba_set_3","caml_ba_set_generic","caml_ba_slice","caml_ba_sub","caml_ba_to_typed_array","caml_ba_uint8_get16","caml_ba_uint8_get32","caml_ba_uint8_get64","caml_ba_uint8_set16","caml_ba_uint8_set32","caml_ba_uint8_set64","caml_backtrace_status","caml_bigstring_blit_ba_to_ba","caml_bigstring_blit_ba_to_bytes","caml_bigstring_blit_bytes_to_ba","caml_bigstring_blit_string_to_ba","caml_bigstring_memcmp","caml_blit_bytes","caml_blit_string","caml_bswap16","caml_build_symbols","caml_bytes_bound_error","caml_bytes_compare","caml_bytes_equal","caml_bytes_get","caml_bytes_get16","caml_bytes_get32","caml_bytes_get64","caml_bytes_greaterequal","caml_bytes_greaterthan","caml_bytes_lessequal","caml_bytes_lessthan","caml_bytes_notequal","caml_bytes_of_array","caml_bytes_of_jsbytes","caml_bytes_of_string","caml_bytes_of_utf16_jsstring","caml_bytes_set","caml_bytes_set16","caml_bytes_set32","caml_bytes_set64","caml_bytes_unsafe_get","caml_bytes_unsafe_set","caml_call_gen","caml_callback","caml_cbrt_float","caml_ceil_float","caml_channel_descriptor","caml_check_bound","caml_classify_float","caml_compare","caml_compare_val","caml_compare_val_get_custom","caml_compare_val_number_custom","caml_compare_val_tag","caml_continuation_use_and_update_handler_noexc","caml_continuation_use_noexc","caml_convert_bytes_to_array","caml_convert_raw_backtrace","caml_convert_raw_backtrace_slot","caml_convert_string_to_bytes","caml_copysign_float","caml_cos_float","caml_cosh_float","caml_create_bytes","caml_create_file","caml_create_string","caml_current_dir","caml_custom_event_index","caml_custom_ops","caml_decompress_input","caml_div","caml_div_float","caml_domain_dls","caml_domain_dls_get","caml_domain_dls_set","caml_domain_id","caml_domain_spawn","caml_ensure_stack_capacity","caml_ephe_blit_data","caml_ephe_blit_key","caml_ephe_check_data","caml_ephe_check_key","caml_ephe_create","caml_ephe_data_offset","caml_ephe_get_data","caml_ephe_get_data_copy","caml_ephe_get_key","caml_ephe_get_key_copy","caml_ephe_key_offset","caml_ephe_set_data","caml_ephe_set_key","caml_ephe_unset_data","caml_ephe_unset_key","caml_eq_float","caml_equal","caml_erf_float","caml_erfc_float","caml_eventlog_pause","caml_eventlog_resume","caml_executable_name","caml_exn_with_js_backtrace","caml_exp2_float","caml_exp_float","caml_expm1_float","caml_failwith","caml_fatal_uncaught_exception","caml_fill_bytes","caml_fill_string","caml_final_register","caml_final_register_called_without_value","caml_final_release","caml_finish_formatting","caml_float_compare","caml_float_of_bytes","caml_float_of_int","caml_float_of_string","caml_floatarray_blit","caml_floatarray_create","caml_floatarray_get","caml_floatarray_set","caml_floatarray_unsafe_get","caml_floatarray_unsafe_set","caml_floor_float","caml_fma_float","caml_fmod_float","caml_format_exception","caml_format_float","caml_format_int","caml_fresh_oo_id","caml_frexp_float","caml_fs_init","caml_gc_compaction","caml_gc_counters","caml_gc_full_major","caml_gc_get","caml_gc_huge_fallback_count","caml_gc_major","caml_gc_major_slice","caml_gc_minor","caml_gc_minor_words","caml_gc_quick_stat","caml_gc_set","caml_gc_stat","caml_ge_float","caml_get_continuation_callstack","caml_get_current_callstack","caml_get_exception_backtrace","caml_get_exception_raw_backtrace","caml_get_global_data","caml_get_major_bucket","caml_get_major_credit","caml_get_minor_free","caml_get_public_method","caml_get_root","caml_global_data","caml_gr_arc_aux","caml_gr_blit_image","caml_gr_clear_graph","caml_gr_close_graph","caml_gr_close_subwindow","caml_gr_create_image","caml_gr_current_x","caml_gr_current_y","caml_gr_display_mode","caml_gr_doc_of_state","caml_gr_draw_arc","caml_gr_draw_char","caml_gr_draw_image","caml_gr_draw_rect","caml_gr_draw_str","caml_gr_draw_string","caml_gr_dump_image","caml_gr_fill_arc","caml_gr_fill_poly","caml_gr_fill_rect","caml_gr_lineto","caml_gr_make_image","caml_gr_moveto","caml_gr_open_graph","caml_gr_open_subwindow","caml_gr_plot","caml_gr_point_color","caml_gr_remember_mode","caml_gr_resize_window","caml_gr_set_color","caml_gr_set_font","caml_gr_set_line_width","caml_gr_set_text_size","caml_gr_set_window_title","caml_gr_sigio_handler","caml_gr_sigio_signal","caml_gr_size_x","caml_gr_size_y","caml_gr_state","caml_gr_state_create","caml_gr_state_get","caml_gr_state_init","caml_gr_state_set","caml_gr_synchronize","caml_gr_text_size","caml_gr_wait_event","caml_gr_window_id","caml_greaterequal","caml_greaterthan","caml_gt_float","caml_hash","caml_hash_mix_bigstring","caml_hash_mix_bytes","caml_hash_mix_bytes_arr","caml_hash_mix_final","caml_hash_mix_float","caml_hash_mix_int","caml_hash_mix_int64","caml_hash_mix_jsbytes","caml_hash_mix_string","caml_hash_nat","caml_hexstring_of_float","caml_hypot_float","caml_input_value","caml_input_value_from_bytes","caml_input_value_from_reader","caml_input_value_from_string","caml_input_value_to_outside_heap","caml_install_signal_handler","caml_int32_add","caml_int32_and","caml_int32_bits_of_float","caml_int32_bswap","caml_int32_compare","caml_int32_div","caml_int32_float_of_bits","caml_int32_format","caml_int32_mod","caml_int32_mul","caml_int32_neg","caml_int32_of_float","caml_int32_of_int","caml_int32_of_string","caml_int32_or","caml_int32_shift_left","caml_int32_shift_right","caml_int32_shift_right_unsigned","caml_int32_sub","caml_int32_to_float","caml_int32_to_int","caml_int32_unmarshal","caml_int32_xor","caml_int64_add","caml_int64_and","caml_int64_bits_of_float","caml_int64_bswap","caml_int64_compare","caml_int64_create_lo_hi","caml_int64_create_lo_mi_hi","caml_int64_div","caml_int64_float_of_bits","caml_int64_format","caml_int64_hash","caml_int64_hi32","caml_int64_is_negative","caml_int64_is_zero","caml_int64_lo32","caml_int64_marshal","caml_int64_mod","caml_int64_mul","caml_int64_neg","caml_int64_of_bytes","caml_int64_of_float","caml_int64_of_int","caml_int64_of_int32","caml_int64_of_nativeint","caml_int64_of_string","caml_int64_offset","caml_int64_or","caml_int64_shift_left","caml_int64_shift_right","caml_int64_shift_right_unsigned","caml_int64_sub","caml_int64_to_bytes","caml_int64_to_float","caml_int64_to_int","caml_int64_to_int32","caml_int64_to_nativeint","caml_int64_ult","caml_int64_unmarshal","caml_int64_xor","caml_int_compare","caml_int_of_float","caml_int_of_string","caml_invalid_argument","caml_is_continuation_tag","caml_is_js","caml_is_ml_bytes","caml_is_ml_string","caml_is_printable","caml_is_special_exception","caml_js_call","caml_js_delete","caml_js_equals","caml_js_error_of_exception","caml_js_error_option_of_exception","caml_js_eval_string","caml_js_expr","caml_js_from_array","caml_js_from_bool","caml_js_from_float","caml_js_from_int32","caml_js_from_nativeint","caml_js_from_string","caml_js_fun_call","caml_js_function_arity","caml_js_get","caml_js_get_console","caml_js_html_entities","caml_js_html_escape","caml_js_instanceof","caml_js_meth_call","caml_js_new","caml_js_object","caml_js_on_ie","caml_js_pure_expr","caml_js_set","caml_js_strict_equals","caml_js_to_array","caml_js_to_bool","caml_js_to_byte_string","caml_js_to_float","caml_js_to_int32","caml_js_to_nativeint","caml_js_to_string","caml_js_typeof","caml_js_var","caml_js_wrap_callback","caml_js_wrap_callback_arguments","caml_js_wrap_callback_strict","caml_js_wrap_callback_unsafe","caml_js_wrap_meth_callback","caml_js_wrap_meth_callback_arguments","caml_js_wrap_meth_callback_strict","caml_js_wrap_meth_callback_unsafe","caml_jsbytes_of_string","caml_jsoo_flags_effects","caml_jsoo_flags_use_js_string","caml_jsstring_of_string","caml_lazy_make_forward","caml_lazy_read_result","caml_lazy_reset_to_lazy","caml_lazy_update_to_forcing","caml_lazy_update_to_forward","caml_ldexp_float","caml_le_float","caml_lessequal","caml_lessthan","caml_lex_array","caml_lex_engine","caml_list_mount_point","caml_list_of_js_array","caml_list_to_js_array","caml_log10_float","caml_log1p_float","caml_log2_float","caml_log_float","caml_lt_float","caml_lxm_next","caml_make_array","caml_make_float_vect","caml_make_path","caml_make_vect","caml_marshal_constants","caml_marshal_data_size","caml_marshal_header_size","caml_maybe_attach_backtrace","caml_maybe_print_stats","caml_md5_bytes","caml_md5_chan","caml_md5_string","caml_memprof_discard","caml_memprof_set","caml_memprof_start","caml_memprof_stop","caml_ml_bytes_content","caml_ml_bytes_length","caml_ml_channel_size","caml_ml_channel_size_64","caml_ml_channels","caml_ml_close_channel","caml_ml_condition_broadcast","caml_ml_condition_new","caml_ml_condition_signal","caml_ml_condition_wait","caml_ml_debug_info_status","caml_ml_domain_cpu_relax","caml_ml_domain_id","caml_ml_domain_set_name","caml_ml_domain_unique_token","caml_ml_enable_runtime_warnings","caml_ml_flush","caml_ml_input","caml_ml_input_bigarray","caml_ml_input_block","caml_ml_input_char","caml_ml_input_int","caml_ml_input_scan_line","caml_ml_is_buffered","caml_ml_mutex_lock","caml_ml_mutex_new","caml_ml_mutex_try_lock","caml_ml_mutex_unlock","caml_ml_open_descriptor_in","caml_ml_open_descriptor_in_with_flags","caml_ml_open_descriptor_out","caml_ml_open_descriptor_out_with_flags","caml_ml_out_channels_list","caml_ml_output","caml_ml_output_bigarray","caml_ml_output_bytes","caml_ml_output_char","caml_ml_output_int","caml_ml_output_ta","caml_ml_pos_in","caml_ml_pos_in_64","caml_ml_pos_out","caml_ml_pos_out_64","caml_ml_runtime_events_pause","caml_ml_runtime_events_resume","caml_ml_runtime_events_start","caml_ml_runtime_warnings_enabled","caml_ml_seek_in","caml_ml_seek_in_64","caml_ml_seek_out","caml_ml_seek_out_64","caml_ml_set_binary_mode","caml_ml_set_buffered","caml_ml_set_channel_name","caml_ml_set_channel_output","caml_ml_set_channel_refill","caml_ml_string_length","caml_mod","caml_modf_float","caml_mount_autoload","caml_mul","caml_mul_float","caml_named_value","caml_named_values","caml_nativeint_add","caml_nativeint_and","caml_nativeint_bswap","caml_nativeint_compare","caml_nativeint_div","caml_nativeint_format","caml_nativeint_mod","caml_nativeint_mul","caml_nativeint_neg","caml_nativeint_of_float","caml_nativeint_of_int","caml_nativeint_of_int32","caml_nativeint_of_string","caml_nativeint_or","caml_nativeint_shift_left","caml_nativeint_shift_right","caml_nativeint_shift_right_unsigned","caml_nativeint_sub","caml_nativeint_to_float","caml_nativeint_to_int","caml_nativeint_to_int32","caml_nativeint_unmarshal","caml_nativeint_xor","caml_neg_float","caml_neq_float","caml_new_lex_engine","caml_new_string","caml_nextafter_float","caml_notequal","caml_obj_add_offset","caml_obj_block","caml_obj_compare_and_swap","caml_obj_dup","caml_obj_is_block","caml_obj_is_shared","caml_obj_make_forward","caml_obj_raw_field","caml_obj_reachable_words","caml_obj_set_raw_field","caml_obj_set_tag","caml_obj_tag","caml_obj_truncate","caml_obj_update_tag","caml_obj_with_tag","caml_ojs_new_arr","caml_oo_last_id","caml_output_val","caml_output_value","caml_output_value_to_buffer","caml_output_value_to_bytes","caml_output_value_to_string","caml_parse_digit","caml_parse_engine","caml_parse_format","caml_parse_sign_and_base","caml_parser_trace","caml_pos_in","caml_pos_out","caml_power_float","caml_pure_js_expr","caml_raise_constant","caml_raise_end_of_file","caml_raise_no_such_file","caml_raise_not_a_dir","caml_raise_not_found","caml_raise_sys_error","caml_raise_with_arg","caml_raise_with_args","caml_raise_with_string","caml_raise_zero_divide","caml_raw_backtrace_length","caml_raw_backtrace_next_slot","caml_raw_backtrace_slot","caml_read_file_content","caml_recommended_domain_count","caml_record_backtrace","caml_record_backtrace_flag","caml_refill","caml_register_channel_for_spacetime","caml_register_global","caml_register_named_value","caml_restore_raw_backtrace","caml_root","caml_round_float","caml_runtime_events_create_cursor","caml_runtime_events_free_cursor","caml_runtime_events_pause","caml_runtime_events_read_poll","caml_runtime_events_resume","caml_runtime_events_start","caml_runtime_events_user_register","caml_runtime_events_user_resolve","caml_runtime_events_user_write","caml_runtime_parameters","caml_runtime_variant","caml_runtime_warnings","caml_seek_in","caml_seek_out","caml_set_oo_id","caml_set_parser_trace","caml_set_static_env","caml_signbit_float","caml_sin_float","caml_sinh_float","caml_spacetime_enabled","caml_spacetime_only_works_for_native_code","caml_sqrt_float","caml_str_initialize","caml_str_repeat","caml_string_bound_error","caml_string_compare","caml_string_equal","caml_string_get","caml_string_get16","caml_string_get32","caml_string_get64","caml_string_greaterequal","caml_string_greaterthan","caml_string_hash","caml_string_lessequal","caml_string_lessthan","caml_string_notequal","caml_string_of_array","caml_string_of_bytes","caml_string_of_jsbytes","caml_string_of_jsstring","caml_string_set","caml_string_set16","caml_string_set32","caml_string_set64","caml_string_unsafe_get","caml_string_unsafe_set","caml_sub_float","caml_subarray_to_jsbytes","caml_sys_argv","caml_sys_chdir","caml_sys_close","caml_sys_const_backend_type","caml_sys_const_big_endian","caml_sys_const_int_size","caml_sys_const_max_wosize","caml_sys_const_naked_pointers_checked","caml_sys_const_ostype_cygwin","caml_sys_const_ostype_unix","caml_sys_const_ostype_win32","caml_sys_const_word_size","caml_sys_executable_name","caml_sys_exit","caml_sys_fds","caml_sys_file_exists","caml_sys_get_argv","caml_sys_get_config","caml_sys_getcwd","caml_sys_getenv","caml_sys_is_directory","caml_sys_is_regular_file","caml_sys_isatty","caml_sys_mkdir","caml_sys_modify_argv","caml_sys_open","caml_sys_open_for_node","caml_sys_random_seed","caml_sys_read_directory","caml_sys_remove","caml_sys_rename","caml_sys_rmdir","caml_sys_system_command","caml_sys_time","caml_sys_time_include_children","caml_sys_unsafe_getenv","caml_tan_float","caml_tanh_float","caml_to_js_string","caml_trailing_slash","caml_trampoline","caml_trampoline_return","caml_trunc_float","caml_uint8_array_of_bytes","caml_uint8_array_of_string","caml_unix_cleanup","caml_unix_closedir","caml_unix_filedescr_of_fd","caml_unix_findclose","caml_unix_findfirst","caml_unix_findnext","caml_unix_getpwuid","caml_unix_gettimeofday","caml_unix_getuid","caml_unix_gmtime","caml_unix_has_symlink","caml_unix_inet_addr_of_string","caml_unix_isatty","caml_unix_localtime","caml_unix_lstat","caml_unix_lstat_64","caml_unix_mkdir","caml_unix_mktime","caml_unix_opendir","caml_unix_readdir","caml_unix_readlink","caml_unix_rewinddir","caml_unix_rmdir","caml_unix_startup","caml_unix_stat","caml_unix_stat_64","caml_unix_symlink","caml_unix_time","caml_unix_unlink","caml_unmount","caml_update_dummy","caml_utf16_of_utf8","caml_utf8_of_utf16","caml_weak_blit","caml_weak_check","caml_weak_create","caml_weak_get","caml_weak_get_copy","caml_weak_set","caml_wrap_exception","caml_xmlhttprequest_create","caml_zstd_initialize","compare_digits_nat","compare_nat","compare_nat_real","complement_nat","create_nat","decr_nat","deserialize_nat","div_digit_nat","div_helper","div_nat","fs_node_supported","incr_nat","initialize_nat","is_digit_int","is_digit_odd","is_digit_zero","jsoo_create_file","jsoo_create_file_extern","jsoo_effect_not_supported","jsoo_floor_log2","jsoo_is_ascii","jsoo_mount_point","jsoo_sys_getenv","land_digit_nat","length_nat","lor_digit_nat","lxor_digit_nat","make_unix_err_args","mult_digit_nat","mult_nat","nat_of_array","nth_digit_nat","nth_digit_nat_native","num_digits_nat","num_leading_zero_bits_in_digit","os_type","path_is_absolute","re_match","re_partial_match","re_replacement_text","re_search_backward","re_search_forward","re_string_match","resolve_fs_device","serialize_nat","set_digit_nat","set_digit_nat_native","set_to_zero_nat","shift_left_nat","shift_right_nat","square_nat","sub_nat","unix_closedir","unix_getpwuid","unix_gettimeofday","unix_getuid","unix_gmtime","unix_has_symlink","unix_inet_addr_of_string","unix_isatty","unix_localtime","unix_lstat","unix_lstat_64","unix_mkdir","unix_mktime","unix_opendir","unix_readdir","unix_readlink","unix_rewinddir","unix_rmdir","unix_stat","unix_stat_64","unix_symlink","unix_time","unix_unlink","win_cleanup","win_filedescr_of_channel","win_findclose","win_findfirst","win_findnext","win_handle_fd","win_startup","zstd_decompress"]),0];return}(globalThis));
//# 1 ".js/default/stdlib/stdlib.cma.js"
// Generated by js_of_ocaml
//# 3 ".js/default/stdlib/stdlib.cma.js"

//# 5 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
   function erase_rel(param){
    if(typeof param === "number") return 0;
    switch(param[0]){
      case 0:
       var rest = param[1]; return [0, erase_rel(rest)];
      case 1:
       var rest$0 = param[1]; return [1, erase_rel(rest$0)];
      case 2:
       var rest$1 = param[1]; return [2, erase_rel(rest$1)];
      case 3:
       var rest$2 = param[1]; return [3, erase_rel(rest$2)];
      case 4:
       var rest$3 = param[1]; return [4, erase_rel(rest$3)];
      case 5:
       var rest$4 = param[1]; return [5, erase_rel(rest$4)];
      case 6:
       var rest$5 = param[1]; return [6, erase_rel(rest$5)];
      case 7:
       var rest$6 = param[1]; return [7, erase_rel(rest$6)];
      case 8:
       var rest$7 = param[2], ty = param[1];
       return [8, ty, erase_rel(rest$7)];
      case 9:
       var rest$8 = param[3], ty1 = param[1];
       return [9, ty1, ty1, erase_rel(rest$8)];
      case 10:
       var rest$9 = param[1]; return [10, erase_rel(rest$9)];
      case 11:
       var rest$10 = param[1]; return [11, erase_rel(rest$10)];
      case 12:
       var rest$11 = param[1]; return [12, erase_rel(rest$11)];
      case 13:
       var rest$12 = param[1]; return [13, erase_rel(rest$12)];
      default: var rest$13 = param[1]; return [14, erase_rel(rest$13)];
    }
   }
   function concat_fmtty(fmtty1, fmtty2){
    if(typeof fmtty1 === "number") return fmtty2;
    switch(fmtty1[0]){
      case 0:
       var rest = fmtty1[1]; return [0, concat_fmtty(rest, fmtty2)];
      case 1:
       var rest$0 = fmtty1[1]; return [1, concat_fmtty(rest$0, fmtty2)];
      case 2:
       var rest$1 = fmtty1[1]; return [2, concat_fmtty(rest$1, fmtty2)];
      case 3:
       var rest$2 = fmtty1[1]; return [3, concat_fmtty(rest$2, fmtty2)];
      case 4:
       var rest$3 = fmtty1[1]; return [4, concat_fmtty(rest$3, fmtty2)];
      case 5:
       var rest$4 = fmtty1[1]; return [5, concat_fmtty(rest$4, fmtty2)];
      case 6:
       var rest$5 = fmtty1[1]; return [6, concat_fmtty(rest$5, fmtty2)];
      case 7:
       var rest$6 = fmtty1[1]; return [7, concat_fmtty(rest$6, fmtty2)];
      case 8:
       var rest$7 = fmtty1[2], ty = fmtty1[1];
       return [8, ty, concat_fmtty(rest$7, fmtty2)];
      case 9:
       var rest$8 = fmtty1[3], ty2 = fmtty1[2], ty1 = fmtty1[1];
       return [9, ty1, ty2, concat_fmtty(rest$8, fmtty2)];
      case 10:
       var rest$9 = fmtty1[1]; return [10, concat_fmtty(rest$9, fmtty2)];
      case 11:
       var rest$10 = fmtty1[1]; return [11, concat_fmtty(rest$10, fmtty2)];
      case 12:
       var rest$11 = fmtty1[1]; return [12, concat_fmtty(rest$11, fmtty2)];
      case 13:
       var rest$12 = fmtty1[1]; return [13, concat_fmtty(rest$12, fmtty2)];
      default:
       var rest$13 = fmtty1[1]; return [14, concat_fmtty(rest$13, fmtty2)];
    }
   }
   function concat_fmt(fmt1, fmt2){
    if(typeof fmt1 === "number") return fmt2;
    switch(fmt1[0]){
      case 0:
       var rest = fmt1[1]; return [0, concat_fmt(rest, fmt2)];
      case 1:
       var rest$0 = fmt1[1]; return [1, concat_fmt(rest$0, fmt2)];
      case 2:
       var rest$1 = fmt1[2], pad = fmt1[1];
       return [2, pad, concat_fmt(rest$1, fmt2)];
      case 3:
       var rest$2 = fmt1[2], pad$0 = fmt1[1];
       return [3, pad$0, concat_fmt(rest$2, fmt2)];
      case 4:
       var rest$3 = fmt1[4], prec = fmt1[3], pad$1 = fmt1[2], iconv = fmt1[1];
       return [4, iconv, pad$1, prec, concat_fmt(rest$3, fmt2)];
      case 5:
       var
        rest$4 = fmt1[4],
        prec$0 = fmt1[3],
        pad$2 = fmt1[2],
        iconv$0 = fmt1[1];
       return [5, iconv$0, pad$2, prec$0, concat_fmt(rest$4, fmt2)];
      case 6:
       var
        rest$5 = fmt1[4],
        prec$1 = fmt1[3],
        pad$3 = fmt1[2],
        iconv$1 = fmt1[1];
       return [6, iconv$1, pad$3, prec$1, concat_fmt(rest$5, fmt2)];
      case 7:
       var
        rest$6 = fmt1[4],
        prec$2 = fmt1[3],
        pad$4 = fmt1[2],
        iconv$2 = fmt1[1];
       return [7, iconv$2, pad$4, prec$2, concat_fmt(rest$6, fmt2)];
      case 8:
       var
        rest$7 = fmt1[4],
        prec$3 = fmt1[3],
        pad$5 = fmt1[2],
        fconv = fmt1[1];
       return [8, fconv, pad$5, prec$3, concat_fmt(rest$7, fmt2)];
      case 9:
       var rest$8 = fmt1[2], pad$6 = fmt1[1];
       return [9, pad$6, concat_fmt(rest$8, fmt2)];
      case 10:
       var rest$9 = fmt1[1]; return [10, concat_fmt(rest$9, fmt2)];
      case 11:
       var rest$10 = fmt1[2], str = fmt1[1];
       return [11, str, concat_fmt(rest$10, fmt2)];
      case 12:
       var rest$11 = fmt1[2], chr = fmt1[1];
       return [12, chr, concat_fmt(rest$11, fmt2)];
      case 13:
       var rest$12 = fmt1[3], fmtty = fmt1[2], pad$7 = fmt1[1];
       return [13, pad$7, fmtty, concat_fmt(rest$12, fmt2)];
      case 14:
       var rest$13 = fmt1[3], fmtty$0 = fmt1[2], pad$8 = fmt1[1];
       return [14, pad$8, fmtty$0, concat_fmt(rest$13, fmt2)];
      case 15:
       var rest$14 = fmt1[1]; return [15, concat_fmt(rest$14, fmt2)];
      case 16:
       var rest$15 = fmt1[1]; return [16, concat_fmt(rest$15, fmt2)];
      case 17:
       var rest$16 = fmt1[2], fmting_lit = fmt1[1];
       return [17, fmting_lit, concat_fmt(rest$16, fmt2)];
      case 18:
       var rest$17 = fmt1[2], fmting_gen = fmt1[1];
       return [18, fmting_gen, concat_fmt(rest$17, fmt2)];
      case 19:
       var rest$18 = fmt1[1]; return [19, concat_fmt(rest$18, fmt2)];
      case 20:
       var rest$19 = fmt1[3], char_set = fmt1[2], width_opt = fmt1[1];
       return [20, width_opt, char_set, concat_fmt(rest$19, fmt2)];
      case 21:
       var rest$20 = fmt1[2], counter = fmt1[1];
       return [21, counter, concat_fmt(rest$20, fmt2)];
      case 22:
       var rest$21 = fmt1[1]; return [22, concat_fmt(rest$21, fmt2)];
      case 23:
       var rest$22 = fmt1[2], ign = fmt1[1];
       return [23, ign, concat_fmt(rest$22, fmt2)];
      default:
       var rest$23 = fmt1[3], f = fmt1[2], arity = fmt1[1];
       return [24, arity, f, concat_fmt(rest$23, fmt2)];
    }
   }
   var CamlinternalFormatBasics = [0, concat_fmtty, erase_rel, concat_fmt];
   runtime.caml_register_global
    (0, CamlinternalFormatBasics, "CamlinternalFormatBasics");
   return;
  }
  (globalThis));

//# 180 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_false$0 = "false",
    cst_true$0 = "true",
    caml_atomic_cas = runtime.caml_atomic_cas,
    caml_atomic_load = runtime.caml_atomic_load,
    caml_blit_string = runtime.caml_blit_string,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_float_of_string = runtime.caml_float_of_string,
    caml_int64_float_of_bits = runtime.caml_int64_float_of_bits,
    caml_int_of_string = runtime.caml_int_of_string,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length,
    caml_ml_channel_size = runtime.caml_ml_channel_size,
    caml_ml_channel_size_64 = runtime.caml_ml_channel_size_64,
    caml_ml_close_channel = runtime.caml_ml_close_channel,
    caml_ml_flush = runtime.caml_ml_flush,
    caml_ml_input = runtime.caml_ml_input,
    caml_ml_input_char = runtime.caml_ml_input_char,
    caml_ml_open_descriptor_in = runtime.caml_ml_open_descriptor_in,
    caml_ml_open_descriptor_out = runtime.caml_ml_open_descriptor_out,
    caml_ml_output = runtime.caml_ml_output,
    caml_ml_output_bytes = runtime.caml_ml_output_bytes,
    caml_ml_output_char = runtime.caml_ml_output_char,
    caml_ml_set_binary_mode = runtime.caml_ml_set_binary_mode,
    caml_ml_set_channel_name = runtime.caml_ml_set_channel_name,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_notequal = runtime.caml_string_notequal,
    caml_string_of_bytes = runtime.caml_string_of_bytes,
    caml_sys_open = runtime.caml_sys_open,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst$0 = "%,",
    cst = ".",
    CamlinternalFormatBasics = global_data.CamlinternalFormatBasics,
    Invalid_argument = global_data.Invalid_argument,
    Failure = global_data.Failure,
    Match_failure = global_data.Match_failure,
    Assert_failure = global_data.Assert_failure,
    Not_found = global_data.Not_found,
    Out_of_memory = global_data.Out_of_memory,
    Stack_overflow = global_data.Stack_overflow,
    Sys_error = global_data.Sys_error,
    End_of_file = global_data.End_of_file,
    Division_by_zero = global_data.Division_by_zero,
    Sys_blocked_io = global_data.Sys_blocked_io,
    Undefined_recursive_module = global_data.Undefined_recursive_module;
   function failwith(s){
    throw caml_maybe_attach_backtrace([0, Failure, s], 1);
   }
   function invalid_arg(s){
    throw caml_maybe_attach_backtrace([0, Invalid_argument, s], 1);
   }
   var Exit = [248, "Stdlib.Exit", runtime.caml_fresh_oo_id(0)];
   function min(x, y){return runtime.caml_lessequal(x, y) ? x : y;}
   function max(x, y){return runtime.caml_greaterequal(x, y) ? x : y;}
   function abs(x){return 0 <= x ? x : - x | 0;}
   function lnot(x){return x ^ -1;}
   var
    infinity =
      caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(0, 0, 32752)),
    neg_infinity =
      caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(0, 0, 65520)),
    nan =
      caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(1, 0, 32760)),
    max_float =
      caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 32751)),
    min_float =
      caml_int64_float_of_bits(runtime.caml_int64_create_lo_mi_hi(0, 0, 16)),
    epsilon_float =
      caml_int64_float_of_bits
       (runtime.caml_int64_create_lo_mi_hi(0, 0, 15536)),
    cst_char_of_int = "char_of_int",
    cst_true = cst_true$0,
    cst_false = cst_false$0,
    cst_bool_of_string = "bool_of_string",
    _a_ = [0, 1],
    _b_ = [0, 0];
   function symbol(s1, s2){
    var
     l1 = caml_ml_string_length(s1),
     l2 = caml_ml_string_length(s2),
     s = caml_create_bytes(l1 + l2 | 0);
    caml_blit_string(s1, 0, s, 0, l1);
    caml_blit_string(s2, 0, s, l1, l2);
    return caml_string_of_bytes(s);
   }
   function char_of_int(n){
    if(0 <= n && 255 >= n) return n;
    return invalid_arg(cst_char_of_int);
   }
   function string_of_bool(b){return b ? cst_true : cst_false;}
   function bool_of_string(param){
    return caml_string_notequal(param, cst_false$0)
            ? caml_string_notequal
               (param, cst_true$0)
              ? invalid_arg(cst_bool_of_string)
              : 1
            : 0;
   }
   function bool_of_string_opt(param){
    return caml_string_notequal(param, cst_false$0)
            ? caml_string_notequal(param, cst_true$0) ? 0 : _a_
            : _b_;
   }
   function string_of_int(n){return "" + n;}
   function int_of_string_opt(s){
    try{var _x_ = [0, caml_int_of_string(s)]; return _x_;}
    catch(_y_){
     var _w_ = caml_wrap_exception(_y_);
     if(_w_[1] === Failure) return 0;
     throw caml_maybe_attach_backtrace(_w_, 0);
    }
   }
   function valid_float_lexem(s){
    var l = caml_ml_string_length(s), i = 0;
    for(;;){
     if(l <= i) return symbol(s, cst);
     var match = runtime.caml_string_get(s, i);
     a:
     {
      if(48 <= match){if(58 > match) break a;} else if(45 === match) break a;
      return s;
     }
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function string_of_float(f){
    return valid_float_lexem(runtime.caml_format_float("%.12g", f));
   }
   function float_of_string_opt(s){
    try{var _u_ = [0, caml_float_of_string(s)]; return _u_;}
    catch(_v_){
     var _t_ = caml_wrap_exception(_v_);
     if(_t_[1] === Failure) return 0;
     throw caml_maybe_attach_backtrace(_t_, 0);
    }
   }
   function symbol$0(l1, l2){
    if(! l1) return l2;
    var _r_ = l1[2], h1 = l1[1];
    if(! _r_) return [0, h1, l2];
    var match = _r_[2], h2 = _r_[1];
    if(! match) return [0, h1, [0, h2, l2]];
    var
     tl = match[2],
     h3 = match[1],
     block = [0, h3, 24029],
     dst = block,
     offset = 1,
     l1$0 = tl;
    for(;;){
     if(l1$0){
      var _s_ = l1$0[2], h1$0 = l1$0[1];
      if(_s_){
       var match$0 = _s_[2], h2$0 = _s_[1];
       if(match$0){
        var tl$0 = match$0[2], h3$0 = match$0[1], dst$0 = [0, h3$0, 24029];
        dst[1 + offset] = [0, h1$0, [0, h2$0, dst$0]];
        var dst = dst$0, offset = 1, l1$0 = tl$0;
        continue;
       }
       dst[1 + offset] = [0, h1$0, [0, h2$0, l2]];
      }
      else
       dst[1 + offset] = [0, h1$0, l2];
     }
     else
      dst[1 + offset] = l2;
     return [0, h1, [0, h2, block]];
    }
   }
   var
    stdin = caml_ml_open_descriptor_in(0),
    stdout = caml_ml_open_descriptor_out(1),
    stderr = caml_ml_open_descriptor_out(2),
    _c_ = [0, 1, [0, 3, [0, 4, [0, 7, 0]]]],
    _d_ = [0, 1, [0, 3, [0, 4, [0, 6, 0]]]],
    cst_output = "output",
    cst_output_substring = "output_substring",
    _e_ = [0, 0, [0, 7, 0]],
    _f_ = [0, 0, [0, 6, 0]],
    cst_input = "input",
    cst_really_input = "really_input";
   function open_out_gen(mode, perm, name){
    var c = caml_ml_open_descriptor_out(caml_sys_open(name, mode, perm));
    caml_ml_set_channel_name(c, name);
    return c;
   }
   function open_out(name){return open_out_gen(_c_, 438, name);}
   function open_out_bin(name){return open_out_gen(_d_, 438, name);}
   function flush_all(param){
    var param$0 = runtime.caml_ml_out_channels_list(0);
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], a = param$0[1];
     try{caml_ml_flush(a);}
     catch(_q_){
      var _p_ = caml_wrap_exception(_q_);
      if(_p_[1] !== Sys_error) throw caml_maybe_attach_backtrace(_p_, 0);
     }
     var param$0 = l;
    }
   }
   function output_bytes(oc, s){
    return caml_ml_output_bytes(oc, s, 0, caml_ml_bytes_length(s));
   }
   function output_string(oc, s){
    return caml_ml_output(oc, s, 0, caml_ml_string_length(s));
   }
   function output(oc, s, ofs, len){
    if(0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
     return caml_ml_output_bytes(oc, s, ofs, len);
    return invalid_arg(cst_output);
   }
   function output_substring(oc, s, ofs, len){
    if(0 <= ofs && 0 <= len && (caml_ml_string_length(s) - len | 0) >= ofs)
     return caml_ml_output(oc, s, ofs, len);
    return invalid_arg(cst_output_substring);
   }
   function output_value(chan, v){
    return runtime.caml_output_value(chan, v, 0);
   }
   function close_out(oc){
    caml_ml_flush(oc);
    return caml_ml_close_channel(oc);
   }
   function close_out_noerr(oc){
    try{caml_ml_flush(oc);}catch(_o_){}
    try{var _m_ = caml_ml_close_channel(oc); return _m_;}catch(_n_){return 0;}
   }
   function open_in_gen(mode, perm, name){
    var c = caml_ml_open_descriptor_in(caml_sys_open(name, mode, perm));
    caml_ml_set_channel_name(c, name);
    return c;
   }
   function open_in(name){return open_in_gen(_e_, 0, name);}
   function open_in_bin(name){return open_in_gen(_f_, 0, name);}
   function input(ic, s, ofs, len){
    if(0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
     return caml_ml_input(ic, s, ofs, len);
    return invalid_arg(cst_input);
   }
   function unsafe_really_input(ic, s, ofs, len){
    var ofs$0 = ofs, len$0 = len;
    for(;;){
     if(0 >= len$0) return 0;
     var r = caml_ml_input(ic, s, ofs$0, len$0);
     if(0 === r) throw caml_maybe_attach_backtrace(End_of_file, 1);
     var
      len$1 = len$0 - r | 0,
      ofs$1 = ofs$0 + r | 0,
      ofs$0 = ofs$1,
      len$0 = len$1;
    }
   }
   function really_input(ic, s, ofs, len){
    if(0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
     return unsafe_really_input(ic, s, ofs, len);
    return invalid_arg(cst_really_input);
   }
   function really_input_string(ic, len){
    var s = caml_create_bytes(len);
    really_input(ic, s, 0, len);
    return caml_string_of_bytes(s);
   }
   function input_line(chan){
    function build_result(buf, pos, param){
     var pos$0 = pos, param$0 = param;
     for(;;){
      if(! param$0) return buf;
      var tl = param$0[2], hd = param$0[1], len = caml_ml_bytes_length(hd);
      runtime.caml_blit_bytes(hd, 0, buf, pos$0 - len | 0, len);
      var pos$1 = pos$0 - len | 0, pos$0 = pos$1, param$0 = tl;
     }
    }
    var accu = 0, len = 0;
    for(;;){
     var n = runtime.caml_ml_input_scan_line(chan);
     if(0 === n){
      if(! accu) throw caml_maybe_attach_backtrace(End_of_file, 1);
      var _l_ = build_result(caml_create_bytes(len), len, accu);
     }
     else{
      if(0 >= n){
       var beg = caml_create_bytes(- n | 0);
       caml_ml_input(chan, beg, 0, - n | 0);
       var
        len$1 = len - n | 0,
        accu$0 = [0, beg, accu],
        accu = accu$0,
        len = len$1;
       continue;
      }
      var res = caml_create_bytes(n - 1 | 0);
      caml_ml_input(chan, res, 0, n - 1 | 0);
      caml_ml_input_char(chan);
      if(accu)
       var
        len$0 = (len + n | 0) - 1 | 0,
        _l_ = build_result(caml_create_bytes(len$0), len$0, [0, res, accu]);
      else
       var _l_ = res;
     }
     return caml_string_of_bytes(_l_);
    }
   }
   function close_in_noerr(ic){
    try{var _j_ = caml_ml_close_channel(ic); return _j_;}catch(_k_){return 0;}
   }
   function print_char(c){return caml_ml_output_char(stdout, c);}
   function print_string(s){return output_string(stdout, s);}
   function print_bytes(s){return output_bytes(stdout, s);}
   function print_int(i){return output_string(stdout, "" + i);}
   function print_float(f){return output_string(stdout, string_of_float(f));}
   function print_endline(s){
    output_string(stdout, s);
    caml_ml_output_char(stdout, 10);
    return caml_ml_flush(stdout);
   }
   function print_newline(param){
    caml_ml_output_char(stdout, 10);
    return caml_ml_flush(stdout);
   }
   function prerr_char(c){return caml_ml_output_char(stderr, c);}
   function prerr_string(s){return output_string(stderr, s);}
   function prerr_bytes(s){return output_bytes(stderr, s);}
   function prerr_int(i){return output_string(stderr, "" + i);}
   function prerr_float(f){return output_string(stderr, string_of_float(f));}
   function prerr_endline(s){
    output_string(stderr, s);
    caml_ml_output_char(stderr, 10);
    return caml_ml_flush(stderr);
   }
   function prerr_newline(param){
    caml_ml_output_char(stderr, 10);
    return caml_ml_flush(stderr);
   }
   function read_line(param){caml_ml_flush(stdout); return input_line(stdin);}
   function read_int(param){return caml_int_of_string(read_line(0));}
   function read_int_opt(param){return int_of_string_opt(read_line(0));}
   function read_float(param){return caml_float_of_string(read_line(0));}
   function read_float_opt(param){return float_of_string_opt(read_line(0));}
   function string_of_format(param){var str = param[2]; return str;}
   function symbol$1(param, _h_){
    var
     str2 = _h_[2],
     fmt2 = _h_[1],
     str1 = param[2],
     fmt1 = param[1],
     _i_ = symbol(str1, symbol(cst$0, str2));
    return [0, caml_call2(CamlinternalFormatBasics[3], fmt1, fmt2), _i_];
   }
   var exit_function = [0, flush_all];
   function at_exit(f){
    for(;;){
     var f_yet_to_run = [0, 1], old_exit = caml_atomic_load(exit_function);
     let f_yet_to_run$0 = f_yet_to_run, old_exit$0 = old_exit;
     var
      new_exit =
        function(param){
         if(caml_atomic_cas(f_yet_to_run$0, 1, 0)) caml_call1(f, 0);
         return caml_call1(old_exit$0, 0);
        },
      success = caml_atomic_cas(exit_function, old_exit, new_exit),
      _g_ = 1 - success;
     if(! _g_) return _g_;
    }
   }
   var do_domain_local_at_exit = [0, function(param){return 0;}];
   function do_at_exit(param){
    caml_call1(do_domain_local_at_exit[1], 0);
    return caml_call1(caml_atomic_load(exit_function), 0);
   }
   function exit(retcode){
    do_at_exit(0);
    return runtime.caml_sys_exit(retcode);
   }
   runtime.caml_register_named_value("Pervasives.do_at_exit", do_at_exit);
   var
    Stdlib =
      [0,
       invalid_arg,
       failwith,
       Exit,
       Match_failure,
       Assert_failure,
       Invalid_argument,
       Failure,
       Not_found,
       Out_of_memory,
       Stack_overflow,
       Sys_error,
       End_of_file,
       Division_by_zero,
       Sys_blocked_io,
       Undefined_recursive_module,
       min,
       max,
       abs,
       2147483647,
       -2147483648,
       lnot,
       infinity,
       neg_infinity,
       nan,
       max_float,
       min_float,
       epsilon_float,
       symbol,
       char_of_int,
       string_of_bool,
       bool_of_string_opt,
       bool_of_string,
       string_of_int,
       int_of_string_opt,
       string_of_float,
       float_of_string_opt,
       symbol$0,
       stdin,
       stdout,
       stderr,
       print_char,
       print_string,
       print_bytes,
       print_int,
       print_float,
       print_endline,
       print_newline,
       prerr_char,
       prerr_string,
       prerr_bytes,
       prerr_int,
       prerr_float,
       prerr_endline,
       prerr_newline,
       read_line,
       read_int_opt,
       read_int,
       read_float_opt,
       read_float,
       open_out,
       open_out_bin,
       open_out_gen,
       caml_ml_flush,
       flush_all,
       caml_ml_output_char,
       output_string,
       output_bytes,
       output,
       output_substring,
       caml_ml_output_char,
       runtime.caml_ml_output_int,
       output_value,
       runtime.caml_ml_seek_out,
       runtime.caml_ml_pos_out,
       caml_ml_channel_size,
       close_out,
       close_out_noerr,
       caml_ml_set_binary_mode,
       open_in,
       open_in_bin,
       open_in_gen,
       caml_ml_input_char,
       input_line,
       input,
       really_input,
       really_input_string,
       caml_ml_input_char,
       runtime.caml_ml_input_int,
       runtime.caml_input_value,
       runtime.caml_ml_seek_in,
       runtime.caml_ml_pos_in,
       caml_ml_channel_size,
       caml_ml_close_channel,
       close_in_noerr,
       caml_ml_set_binary_mode,
       [0,
        runtime.caml_ml_seek_out_64,
        runtime.caml_ml_pos_out_64,
        caml_ml_channel_size_64,
        runtime.caml_ml_seek_in_64,
        runtime.caml_ml_pos_in_64,
        caml_ml_channel_size_64],
       string_of_format,
       symbol$1,
       exit,
       at_exit,
       valid_float_lexem,
       unsafe_really_input,
       do_at_exit,
       do_domain_local_at_exit];
   runtime.caml_register_global(45, Stdlib, "Stdlib");
   return;
  }
  (globalThis));

//# 790 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    ocaml_version = "5.1.1",
    ocaml_release = [0, 5, 1, 1, 0],
    Stdlib = global_data.Stdlib,
    executable_name = runtime.caml_sys_executable_name(0),
    os_type = runtime.caml_sys_get_config(0)[1],
    backend_type = [0, "js_of_ocaml"],
    unix = runtime.caml_sys_const_ostype_unix(0),
    win32 = runtime.caml_sys_const_ostype_win32(0),
    cygwin = runtime.caml_sys_const_ostype_cygwin(0),
    max_array_length = runtime.caml_sys_const_max_wosize(0),
    max_floatarray_length = max_array_length / 2 | 0,
    max_string_length = (4 * max_array_length | 0) - 1 | 0;
   function getenv_opt(s){
    try{var _d_ = [0, runtime.caml_sys_getenv(s)]; return _d_;}
    catch(_e_){
     var _c_ = caml_wrap_exception(_e_);
     if(_c_ === Stdlib[8]) return 0;
     throw caml_maybe_attach_backtrace(_c_, 0);
    }
   }
   var interactive = [0, 0];
   function set_signal(sig_num, sig_beh){return 0;}
   var Break = [248, "Stdlib.Sys.Break", runtime.caml_fresh_oo_id(0)];
   function catch_break(on){return on ? 0 : 0;}
   function Make(_b_, _a_){return [0, 1];}
   var
    Immediate64 = [0, Make],
    Stdlib_Sys =
      [0,
       executable_name,
       getenv_opt,
       interactive,
       os_type,
       backend_type,
       unix,
       win32,
       cygwin,
       32,
       32,
       0,
       max_string_length,
       max_array_length,
       max_floatarray_length,
       set_signal,
       -1,
       -2,
       -3,
       -4,
       -5,
       -6,
       -7,
       -8,
       -9,
       -10,
       -11,
       -12,
       -13,
       -14,
       -15,
       -16,
       -17,
       -18,
       -19,
       -20,
       -21,
       -22,
       -23,
       -24,
       -25,
       -26,
       -27,
       -28,
       Break,
       catch_break,
       ocaml_version,
       0,
       ocaml_release,
       runtime.caml_ml_enable_runtime_warnings,
       runtime.caml_ml_runtime_warnings_enabled,
       Immediate64];
   runtime.caml_register_global(4, Stdlib_Sys, "Stdlib__Sys");
   return;
  }
  (globalThis));

//# 885 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Obj_extension_constructor$1 = "Obj.extension_constructor",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_obj_tag = runtime.caml_obj_tag;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Assert_failure = global_data.Assert_failure,
    Stdlib_Sys = global_data.Stdlib__Sys;
   function is_block(a){return 1 - (typeof a === "number" ? 1 : 0);}
   var
    double_field = runtime.caml_array_get,
    set_double_field = runtime.caml_array_set,
    _a_ = [0, "obj.ml", 94, 4],
    cst_Obj_extension_constructor = cst_Obj_extension_constructor$1,
    cst_Obj_extension_constructor$0 = cst_Obj_extension_constructor$1;
   function info(obj){
    if(caml_obj_tag(obj) !== 247)
     throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
    var
     info = runtime.caml_obj_raw_field(obj, 1),
     arity = 64 === Stdlib_Sys[9] ? info >> 56 : info >> 24,
     start_env = info << 8 >>> 9 | 0;
    return [0, arity, start_env];
   }
   function of_val(x){
    a:
    {
     if(is_block(x) && caml_obj_tag(x) !== 248 && 1 <= x.length - 1){var slot = x[1]; break a;}
     var slot = x;
    }
    a:
    {
     if(is_block(slot) && caml_obj_tag(slot) === 248){var name = slot[1]; break a;}
     var name = caml_call1(Stdlib[1], cst_Obj_extension_constructor$0);
    }
    return caml_obj_tag(name) === 252
            ? slot
            : caml_call1(Stdlib[1], cst_Obj_extension_constructor);
   }
   function name(slot){return slot[1];}
   function id(slot){return slot[2];}
   var
    Extension_constructor = [0, of_val, name, id],
    max_ephe_length = Stdlib_Sys[13] - 2 | 0,
    cst_Obj_Ephemeron_create = "Obj.Ephemeron.create",
    cst_Obj_Ephemeron_get_key = "Obj.Ephemeron.get_key",
    cst_Obj_Ephemeron_get_key_copy = "Obj.Ephemeron.get_key_copy",
    cst_Obj_Ephemeron_set_key = "Obj.Ephemeron.set_key",
    cst_Obj_Ephemeron_unset_key = "Obj.Ephemeron.unset_key",
    cst_Obj_Ephemeron_check_key = "Obj.Ephemeron.check_key",
    cst_Obj_Ephemeron_blit_key = "Obj.Ephemeron.blit_key";
   function create(l){
    var _g_ = 0 <= l ? 1 : 0, _h_ = _g_ ? l <= max_ephe_length ? 1 : 0 : _g_;
    if(1 - _h_) caml_call1(Stdlib[1], cst_Obj_Ephemeron_create);
    return runtime.caml_ephe_create(l);
   }
   function length(x){return x.length - 1 - 2 | 0;}
   function raise_if_invalid_offset(e, o, msg){
    var
     _d_ = 0 <= o ? 1 : 0,
     _e_ = _d_ ? o < length(e) ? 1 : 0 : _d_,
     _f_ = 1 - _e_;
    return _f_ ? caml_call1(Stdlib[1], msg) : _f_;
   }
   function get_key(e, o){
    raise_if_invalid_offset(e, o, cst_Obj_Ephemeron_get_key);
    return runtime.caml_ephe_get_key(e, o);
   }
   function get_key_copy(e, o){
    raise_if_invalid_offset(e, o, cst_Obj_Ephemeron_get_key_copy);
    return runtime.caml_ephe_get_key_copy(e, o);
   }
   function set_key(e, o, x){
    raise_if_invalid_offset(e, o, cst_Obj_Ephemeron_set_key);
    return runtime.caml_ephe_set_key(e, o, x);
   }
   function unset_key(e, o){
    raise_if_invalid_offset(e, o, cst_Obj_Ephemeron_unset_key);
    return runtime.caml_ephe_unset_key(e, o);
   }
   function check_key(e, o){
    raise_if_invalid_offset(e, o, cst_Obj_Ephemeron_check_key);
    return runtime.caml_ephe_check_key(e, o);
   }
   function blit_key(e1, o1, e2, o2, l){
    if
     (0 <= l
      &&
       0 <= o1
       && (length(e1) - l | 0) >= o1 && 0 <= o2 && (length(e2) - l | 0) >= o2){
     var
      _b_ = 0 !== l ? 1 : 0,
      _c_ = _b_ ? runtime.caml_ephe_blit_key(e1, o1, e2, o2, l) : _b_;
     return _c_;
    }
    return caml_call1(Stdlib[1], cst_Obj_Ephemeron_blit_key);
   }
   var
    Stdlib_Obj =
      [0,
       is_block,
       double_field,
       set_double_field,
       0,
       243,
       244,
       245,
       246,
       247,
       248,
       249,
       250,
       251,
       251,
       252,
       253,
       254,
       255,
       1000,
       1001,
       1002,
       [0, info],
       Extension_constructor,
       [0,
        create,
        length,
        get_key,
        get_key_copy,
        set_key,
        unset_key,
        check_key,
        blit_key,
        runtime.caml_ephe_get_data,
        runtime.caml_ephe_get_data_copy,
        runtime.caml_ephe_set_data,
        runtime.caml_ephe_unset_data,
        runtime.caml_ephe_check_data,
        runtime.caml_ephe_blit_data,
        max_ephe_length]];
   runtime.caml_register_global(13, Stdlib_Obj, "Stdlib__Obj");
   return;
  }
  (globalThis));

//# 1071 ".js/default/stdlib/stdlib.cma.js"
(function(globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_atomic_exchange = runtime.caml_atomic_exchange,
    caml_atomic_fetch_add = runtime.caml_atomic_fetch_add;
   function set(r, x){caml_atomic_exchange(r, x); return 0;}
   function incr(r){caml_atomic_fetch_add(r, 1); return 0;}
   function decr(r){caml_atomic_fetch_add(r, -1); return 0;}
   var
    Stdlib_Atomic =
      [0,
       function(_a_){return [0, _a_];},
       runtime.caml_atomic_load,
       set,
       caml_atomic_exchange,
       runtime.caml_atomic_cas,
       caml_atomic_fetch_add,
       incr,
       decr];
   runtime.caml_register_global(0, Stdlib_Atomic, "Stdlib__Atomic");
   return;
  }
  (globalThis));

//# 1098 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_lazy_update_to_forward = runtime.caml_lazy_update_to_forward,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Obj = global_data.Stdlib__Obj,
    Undefined =
      [248, "CamlinternalLazy.Undefined", runtime.caml_fresh_oo_id(0)];
   function force_gen_lazy_block(only_val, blk){
    if(0 !== runtime.caml_lazy_update_to_forcing(blk))
     throw caml_maybe_attach_backtrace(Undefined, 1);
    if(only_val){
     var closure$0 = blk[1];
     blk[1] = 0;
     var result$0 = caml_call1(closure$0, 0);
     blk[1] = result$0;
     caml_lazy_update_to_forward(blk);
     return result$0;
    }
    var closure = blk[1];
    blk[1] = 0;
    try{
     var result = caml_call1(closure, 0);
     blk[1] = result;
     caml_lazy_update_to_forward(blk);
     return result;
    }
    catch(e$0){
     var e = caml_wrap_exception(e$0);
     blk[1] = function(param){throw caml_maybe_attach_backtrace(e, 0);};
     runtime.caml_lazy_reset_to_lazy(blk);
     throw caml_maybe_attach_backtrace(e, 0);
    }
   }
   function force_lazy_block(blk){return force_gen_lazy_block(0, blk);}
   function force_gen(only_val, lzv){
    var t = runtime.caml_obj_tag(lzv);
    if(t === Stdlib_Obj[12]) return lzv[1];
    if(t === Stdlib_Obj[6]) throw caml_maybe_attach_backtrace(Undefined, 1);
    return t !== Stdlib_Obj[8] ? lzv : force_gen_lazy_block(only_val, lzv);
   }
   var CamlinternalLazy = [0, Undefined, force_lazy_block, force_gen];
   runtime.caml_register_global(2, CamlinternalLazy, "CamlinternalLazy");
   return;
  }
  (globalThis));

//# 1157 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime, caml_obj_tag = runtime.caml_obj_tag;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    CamlinternalLazy = global_data.CamlinternalLazy,
    Stdlib_Obj = global_data.Stdlib__Obj,
    Undefined = CamlinternalLazy[1];
   function force_val(l){return caml_call2(CamlinternalLazy[3], 1, l);}
   function from_fun(f){
    var x = runtime.caml_obj_block(Stdlib_Obj[8], 1);
    x[1] = f;
    return x;
   }
   function from_val(v){
    var t = caml_obj_tag(v);
    if
     (t !== Stdlib_Obj[12]
      && t !== Stdlib_Obj[8] && t !== Stdlib_Obj[6] && t !== Stdlib_Obj[16])
     return v;
    return runtime.caml_lazy_make_forward(v);
   }
   function is_val(l){
    var _i_ = Stdlib_Obj[8];
    return caml_obj_tag(l) !== _i_ ? 1 : 0;
   }
   function map(f, x){
    return [246,
            function(_f_){
             var _g_ = caml_obj_tag(x);
             a:
             if(250 === _g_)
              var _h_ = x[1];
             else{
              if(246 !== _g_ && 244 !== _g_){var _h_ = x; break a;}
              var _h_ = caml_call1(CamlinternalLazy[2], x);
             }
             return caml_call1(f, _h_);
            }];
   }
   function map_val(f, x){
    if(! is_val(x))
     return [246,
             function(_c_){
              var _d_ = caml_obj_tag(x);
              a:
              if(250 === _d_)
               var _e_ = x[1];
              else{
               if(246 !== _d_ && 244 !== _d_){var _e_ = x; break a;}
               var _e_ = caml_call1(CamlinternalLazy[2], x);
              }
              return caml_call1(f, _e_);
             }];
    var _a_ = caml_obj_tag(x);
    a:
    if(250 === _a_)
     var _b_ = x[1];
    else{
     if(246 !== _a_ && 244 !== _a_){var _b_ = x; break a;}
     var _b_ = caml_call1(CamlinternalLazy[2], x);
    }
    return from_val(caml_call1(f, _b_));
   }
   var
    Stdlib_Lazy =
      [0, Undefined, map, is_val, from_val, map_val, from_fun, force_val];
   runtime.caml_register_global(2, Stdlib_Lazy, "Stdlib__Lazy");
   return;
  }
  (globalThis));

//# 1242 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Assert_failure = global_data.Assert_failure,
    Stdlib_Atomic = global_data.Stdlib__Atomic,
    CamlinternalLazy = global_data.CamlinternalLazy,
    Stdlib = global_data.Stdlib,
    Stdlib_Lazy = global_data.Stdlib__Lazy,
    cst_Seq_init = "Seq.init",
    cst_Seq_take = "Seq.take",
    cst_Seq_drop = "Seq.drop";
   function empty(param){return 0;}
   function return$0(x, param){return [0, x, empty];}
   function cons(x, next, param){return [0, x, next];}
   function append(seq1, seq2, param){
    var match = caml_call1(seq1, 0);
    if(! match) return caml_call1(seq2, 0);
    var next = match[2], x = match[1];
    return [0, x, function(_ay_){return append(next, seq2, _ay_);}];
   }
   function map(f, seq, param){
    var match = caml_call1(seq, 0);
    if(! match) return 0;
    var next = match[2], x = match[1];
    return [0, caml_call1(f, x), function(_ax_){return map(f, next, _ax_);}];
   }
   function filter_map(f, seq, param){
    var seq$0 = seq;
    for(;;){
     var match = caml_call1(seq$0, 0);
     if(! match) return 0;
     var next = match[2], x = match[1], match$0 = caml_call1(f, x);
     if(match$0){
      var y = match$0[1];
      return [0, y, function(_aw_){return filter_map(f, next, _aw_);}];
     }
     var seq$0 = next;
    }
   }
   function filter(f, seq, param){
    var seq$0 = seq;
    for(;;){
     var match = caml_call1(seq$0, 0);
     if(! match) return 0;
     var next = match[2], x = match[1];
     if(caml_call1(f, x))
      return [0, x, function(_av_){return filter(f, next, _av_);}];
     var seq$0 = next;
    }
   }
   function concat(seq, param){
    var match = caml_call1(seq, 0);
    if(! match) return 0;
    var next = match[2], x = match[1];
    return append(x, function(_au_){return concat(next, _au_);}, 0);
   }
   function flat_map(f, seq, param){
    var match = caml_call1(seq, 0);
    if(! match) return 0;
    var next = match[2], x = match[1];
    return append
            (caml_call1(f, x),
             function(_at_){return flat_map(f, next, _at_);},
             0);
   }
   function fold_left(f, acc, seq){
    var acc$0 = acc, seq$0 = seq;
    for(;;){
     var match = caml_call1(seq$0, 0);
     if(! match) return acc$0;
     var
      next = match[2],
      x = match[1],
      acc$1 = caml_call2(f, acc$0, x),
      acc$0 = acc$1,
      seq$0 = next;
    }
   }
   function iter(f, seq){
    var seq$0 = seq;
    for(;;){
     var match = caml_call1(seq$0, 0);
     if(! match) return 0;
     var next = match[2], x = match[1];
     caml_call1(f, x);
     var seq$0 = next;
    }
   }
   function unfold(f, u, param){
    var match = caml_call1(f, u);
    if(! match) return 0;
    var match$0 = match[1], u$0 = match$0[2], x = match$0[1];
    return [0, x, function(_as_){return unfold(f, u$0, _as_);}];
   }
   function is_empty(xs){return caml_call1(xs, 0) ? 0 : 1;}
   function uncons(xs){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1];
    return [0, [0, x, xs$0]];
   }
   function length(xs$1){
    var accu = 0, xs = xs$1;
    for(;;){
     var match = caml_call1(xs, 0);
     if(! match) return accu;
     var xs$0 = match[2], accu$0 = accu + 1 | 0, accu = accu$0, xs = xs$0;
    }
   }
   function iteri(f, xs$1){
    var i = 0, xs = xs$1;
    for(;;){
     var match = caml_call1(xs, 0);
     if(! match) return 0;
     var xs$0 = match[2], x = match[1];
     caml_call2(f, i, x);
     var i$0 = i + 1 | 0, i = i$0, xs = xs$0;
    }
   }
   function fold_lefti(f, accu$1, xs$1){
    var accu = accu$1, i = 0, xs = xs$1;
    for(;;){
     var match = caml_call1(xs, 0);
     if(! match) return accu;
     var
      xs$0 = match[2],
      x = match[1],
      accu$0 = caml_call3(f, accu, i, x),
      i$0 = i + 1 | 0,
      accu = accu$0,
      i = i$0,
      xs = xs$0;
    }
   }
   function for_all(p, xs){
    var xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 1;
     var xs$1 = match[2], x = match[1], _ar_ = caml_call1(p, x);
     if(! _ar_) return _ar_;
     var xs$0 = xs$1;
    }
   }
   function exists(p, xs){
    var xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1], _aq_ = caml_call1(p, x);
     if(_aq_) return _aq_;
     var xs$0 = xs$1;
    }
   }
   function find(p, xs){
    var xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1];
     if(caml_call1(p, x)) return [0, x];
     var xs$0 = xs$1;
    }
   }
   function find_index(p, xs){
    var i = 0, xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1];
     if(caml_call1(p, x)) return [0, i];
     var i$0 = i + 1 | 0, i = i$0, xs$0 = xs$1;
    }
   }
   function find_map(f, xs){
    var xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1], result = caml_call1(f, x);
     if(result) return result;
     var xs$0 = xs$1;
    }
   }
   function find_mapi(f, xs){
    var i = 0, xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1], result = caml_call2(f, i, x);
     if(result) return result;
     var i$0 = i + 1 | 0, i = i$0, xs$0 = xs$1;
    }
   }
   function iter2(f, xs, ys){
    var xs$0 = xs, ys$0 = ys;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1], match$0 = caml_call1(ys$0, 0);
     if(! match$0) return 0;
     var ys$1 = match$0[2], y = match$0[1];
     caml_call2(f, x, y);
     var xs$0 = xs$1, ys$0 = ys$1;
    }
   }
   function fold_left2(f, accu, xs, ys){
    var accu$0 = accu, xs$0 = xs, ys$0 = ys;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return accu$0;
     var xs$1 = match[2], x = match[1], match$0 = caml_call1(ys$0, 0);
     if(! match$0) return accu$0;
     var
      ys$1 = match$0[2],
      y = match$0[1],
      accu$1 = caml_call3(f, accu$0, x, y),
      accu$0 = accu$1,
      xs$0 = xs$1,
      ys$0 = ys$1;
    }
   }
   function for_all2(f, xs, ys){
    var xs$0 = xs, ys$0 = ys;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 1;
     var xs$1 = match[2], x = match[1], match$0 = caml_call1(ys$0, 0);
     if(! match$0) return 1;
     var ys$1 = match$0[2], y = match$0[1], _ap_ = caml_call2(f, x, y);
     if(! _ap_) return _ap_;
     var xs$0 = xs$1, ys$0 = ys$1;
    }
   }
   function exists2(f, xs, ys){
    var xs$0 = xs, ys$0 = ys;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1], match$0 = caml_call1(ys$0, 0);
     if(! match$0) return 0;
     var ys$1 = match$0[2], y = match$0[1], _ao_ = caml_call2(f, x, y);
     if(_ao_) return _ao_;
     var xs$0 = xs$1, ys$0 = ys$1;
    }
   }
   function equal(eq, xs, ys){
    var xs$0 = xs, ys$0 = ys;
    for(;;){
     var match = caml_call1(xs$0, 0), match$0 = caml_call1(ys$0, 0);
     if(match){
      if(match$0){
       var
        ys$1 = match$0[2],
        y = match$0[1],
        xs$1 = match[2],
        x = match[1],
        _an_ = caml_call2(eq, x, y);
       if(! _an_) return _an_;
       var xs$0 = xs$1, ys$0 = ys$1;
       continue;
      }
     }
     else if(! match$0) return 1;
     return 0;
    }
   }
   function compare(cmp, xs, ys){
    var xs$0 = xs, ys$0 = ys;
    for(;;){
     var match = caml_call1(xs$0, 0), match$0 = caml_call1(ys$0, 0);
     if(! match) return match$0 ? -1 : 0;
     var xs$1 = match[2], x = match[1];
     if(! match$0) return 1;
     var ys$1 = match$0[2], y = match$0[1], c = caml_call2(cmp, x, y);
     if(0 !== c) return c;
     var xs$0 = xs$1, ys$0 = ys$1;
    }
   }
   function init_aux(f, i, j, param){
    if(i >= j) return 0;
    var _al_ = i + 1 | 0;
    return [0,
            caml_call1(f, i),
            function(_am_){return init_aux(f, _al_, j, _am_);}];
   }
   function init(n, f){
    if(0 > n) return caml_call1(Stdlib[1], cst_Seq_init);
    var _aj_ = 0;
    return function(_ak_){return init_aux(f, _aj_, n, _ak_);};
   }
   function repeat(x, param){
    return [0, x, function(_ai_){return repeat(x, _ai_);}];
   }
   function forever(f, param){
    return [0, caml_call1(f, 0), function(_ah_){return forever(f, _ah_);}];
   }
   function cycle_nonempty(xs, param){
    return append(xs, function(_ag_){return cycle_nonempty(xs, _ag_);}, 0);
   }
   function cycle(xs, param){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1];
    function _ad_(_af_){return cycle_nonempty(xs, _af_);}
    return [0, x, function(_ae_){return append(xs$0, _ad_, _ae_);}];
   }
   function iterate1(f, x, param){
    var y = caml_call1(f, x);
    return [0, y, function(_ac_){return iterate1(f, y, _ac_);}];
   }
   function iterate(f, x){
    function _$_(_ab_){return iterate1(f, x, _ab_);}
    return function(_aa_){return [0, x, _$_];};
   }
   function mapi_aux(f, i, xs, param){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1], _Z_ = i + 1 | 0;
    return [0,
            caml_call2(f, i, x),
            function(___){return mapi_aux(f, _Z_, xs$0, ___);}];
   }
   function mapi(f, xs){
    var _X_ = 0;
    return function(_Y_){return mapi_aux(f, _X_, xs, _Y_);};
   }
   function tail_scan(f, s, xs, param){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1], s$0 = caml_call2(f, s, x);
    return [0, s$0, function(_W_){return tail_scan(f, s$0, xs$0, _W_);}];
   }
   function scan(f, s, xs){
    function _T_(_V_){return tail_scan(f, s, xs, _V_);}
    return function(_U_){return [0, s, _T_];};
   }
   function take_aux(n, xs){
    return 0 === n
            ? empty
            : function
             (param){
              var match = caml_call1(xs, 0);
              if(! match) return 0;
              var xs$0 = match[2], x = match[1];
              return [0, x, take_aux(n - 1 | 0, xs$0)];
             };
   }
   function take(n, xs){
    if(n < 0) caml_call1(Stdlib[1], cst_Seq_take);
    return take_aux(n, xs);
   }
   function drop(n, xs){
    return 0 <= n
            ? 0
              === n
              ? xs
              : function
               (param){
                var n$0 = n, xs$0 = xs;
                for(;;){
                 var match = caml_call1(xs$0, 0);
                 if(! match) return 0;
                 var xs$1 = match[2], n$1 = n$0 - 1 | 0;
                 if(0 === n$1) return caml_call1(xs$1, 0);
                 var n$0 = n$1, xs$0 = xs$1;
                }
               }
            : caml_call1(Stdlib[1], cst_Seq_drop);
   }
   function take_while(p, xs, param){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1];
    return caml_call1(p, x)
            ? [0, x, function(_S_){return take_while(p, xs$0, _S_);}]
            : 0;
   }
   function drop_while(p, xs, param){
    var xs$0 = xs;
    for(;;){
     var node = caml_call1(xs$0, 0);
     if(! node) return 0;
     var xs$1 = node[2], x = node[1];
     if(! caml_call1(p, x)) return node;
     var xs$0 = xs$1;
    }
   }
   function group(eq, xs, param){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1], _K_ = caml_call1(eq, x);
    function _L_(_R_){return drop_while(_K_, xs$0, _R_);}
    var _M_ = caml_call1(eq, x);
    function _N_(_Q_){return take_while(_M_, xs$0, _Q_);}
    return [0,
            function(_P_){return [0, x, _N_];},
            function(_O_){return group(eq, _L_, _O_);}];
   }
   var
    Forced_twice =
      [248, "Stdlib.Seq.Forced_twice", runtime.caml_fresh_oo_id(0)],
    to_lazy = Stdlib_Lazy[6],
    _a_ = [0, "seq.ml", 616, 4];
   function failure(param){
    throw caml_maybe_attach_backtrace(Forced_twice, 1);
   }
   function memoize(xs){
    function s$0(param){
     var match = caml_call1(xs, 0);
     if(! match) return 0;
     var xs$0 = match[2], x = match[1];
     return [0, x, memoize(xs$0)];
    }
    var s = caml_call1(to_lazy, s$0);
    return function(_J_){
     var _I_ = runtime.caml_obj_tag(s);
     if(250 === _I_) return s[1];
     if(246 !== _I_ && 244 !== _I_) return s;
     return caml_call1(CamlinternalLazy[2], s);};
   }
   function once(xs){
    function f(param){
     var match = caml_call1(xs, 0);
     if(! match) return 0;
     var xs$0 = match[2], x = match[1];
     return [0, x, once(xs$0)];
    }
    var action = caml_call1(Stdlib_Atomic[1], f);
    return function(param){
     var f = caml_call2(Stdlib_Atomic[4], action, failure);
     return caml_call1(f, 0);};
   }
   function zip(xs, ys, param){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1], match$0 = caml_call1(ys, 0);
    if(! match$0) return 0;
    var ys$0 = match$0[2], y = match$0[1];
    return [0, [0, x, y], function(_H_){return zip(xs$0, ys$0, _H_);}];
   }
   function map2(f, xs, ys, param){
    var match = caml_call1(xs, 0);
    if(! match) return 0;
    var xs$0 = match[2], x = match[1], match$0 = caml_call1(ys, 0);
    if(! match$0) return 0;
    var ys$0 = match$0[2], y = match$0[1];
    return [0,
            caml_call2(f, x, y),
            function(_G_){return map2(f, xs$0, ys$0, _G_);}];
   }
   function interleave(xs, ys, param){
    var match = caml_call1(xs, 0);
    if(! match) return caml_call1(ys, 0);
    var xs$0 = match[2], x = match[1];
    return [0, x, function(_F_){return interleave(ys, xs$0, _F_);}];
   }
   function sorted_merge1(cmp, x, xs, y, ys){
    return 0 < caml_call2(cmp, x, y)
            ? [0,
              y,
              function(_D_){
               var match = caml_call1(ys, 0);
               if(! match) return [0, x, xs];
               var ys$0 = match[2], y = match[1];
               return sorted_merge1(cmp, x, xs, y, ys$0);
              }]
            : [0,
              x,
              function(_E_){
               var match = caml_call1(xs, 0);
               if(! match) return [0, y, ys];
               var xs$0 = match[2], x = match[1];
               return sorted_merge1(cmp, x, xs$0, y, ys);
              }];
   }
   function sorted_merge(cmp, xs, ys, param){
    var match = caml_call1(xs, 0), match$0 = caml_call1(ys, 0);
    if(match){
     if(match$0){
      var ys$0 = match$0[2], y = match$0[1], xs$0 = match[2], x = match[1];
      return sorted_merge1(cmp, x, xs$0, y, ys$0);
     }
     var c = match;
    }
    else{if(! match$0) return 0; var c = match$0;}
    return c;
   }
   function map_fst(xys, param){
    var match = caml_call1(xys, 0);
    if(! match) return 0;
    var xys$0 = match[2], x = match[1][1];
    return [0, x, function(_C_){return map_fst(xys$0, _C_);}];
   }
   function map_snd(xys, param){
    var match = caml_call1(xys, 0);
    if(! match) return 0;
    var xys$0 = match[2], y = match[1][2];
    return [0, y, function(_B_){return map_snd(xys$0, _B_);}];
   }
   function unzip(xys){
    return [0,
            function(_A_){return map_fst(xys, _A_);},
            function(_z_){return map_snd(xys, _z_);}];
   }
   function filter_map_find_left_map(f, xs, param){
    var xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1], match$0 = caml_call1(f, x);
     if(0 === match$0[0]){
      var y = match$0[1];
      return [0,
              y,
              function(_y_){return filter_map_find_left_map(f, xs$1, _y_);}];
     }
     var xs$0 = xs$1;
    }
   }
   function filter_map_find_right_map(f, xs, param){
    var xs$0 = xs;
    for(;;){
     var match = caml_call1(xs$0, 0);
     if(! match) return 0;
     var xs$1 = match[2], x = match[1], match$0 = caml_call1(f, x);
     if(0 !== match$0[0]){
      var z = match$0[1];
      return [0,
              z,
              function(_x_){return filter_map_find_right_map(f, xs$1, _x_);}];
     }
     var xs$0 = xs$1;
    }
   }
   function partition_map(f, xs){
    return [0,
            function(_w_){return filter_map_find_left_map(f, xs, _w_);},
            function(_v_){return filter_map_find_right_map(f, xs, _v_);}];
   }
   function partition(p, xs){
    function _s_(x){return 1 - caml_call1(p, x);}
    return [0,
            function(_u_){return filter(p, xs, _u_);},
            function(_t_){return filter(_s_, xs, _t_);}];
   }
   function peel(xss){
    return unzip(function(_r_){return filter_map(uncons, xss, _r_);});
   }
   function transpose(xss, param){
    var match = peel(xss), tails = match[2], heads = match[1];
    if(! is_empty(heads))
     return [0, heads, function(_q_){return transpose(tails, _q_);}];
    if(is_empty(tails)) return 0;
    throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
   }
   function _b_(remainders, xss, param){
    var match = caml_call1(xss, 0);
    if(! match) return transpose(remainders, 0);
    var xss$0 = match[2], xs = match[1], match$0 = caml_call1(xs, 0);
    if(match$0){
     var
      xs$0 = match$0[2],
      x = match$0[1],
      match$1 = peel(remainders),
      tails = match$1[2],
      heads = match$1[1],
      _l_ = function(_p_){return [0, xs$0, tails];};
     return [0,
             function(_o_){return [0, x, heads];},
             function(_n_){return _b_(_l_, xss$0, _n_);}];
    }
    var
     match$2 = peel(remainders),
     tails$0 = match$2[2],
     heads$0 = match$2[1];
    return [0, heads$0, function(_m_){return _b_(tails$0, xss$0, _m_);}];
   }
   function map_product(f, xs, ys){
    function _f_(x){
     function _j_(y){return caml_call2(f, x, y);}
     return function(_k_){return map(_j_, ys, _k_);};
    }
    function xss(_i_){return map(_f_, xs, _i_);}
    function _e_(_h_){return _b_(empty, xss, _h_);}
    return function(_g_){return concat(_e_, _g_);};
   }
   function product(xs, ys){
    return map_product(function(x, y){return [0, x, y];}, xs, ys);
   }
   function of_dispenser(it){
    function c(param){
     var match = caml_call1(it, 0);
     if(! match) return 0;
     var x = match[1];
     return [0, x, c];
    }
    return c;
   }
   function to_dispenser(xs){
    var s = [0, xs];
    return function(param){
     var match = caml_call1(s[1], 0);
     if(! match) return 0;
     var xs = match[2], x = match[1];
     s[1] = xs;
     return [0, x];};
   }
   function ints(i, param){
    var _c_ = i + 1 | 0;
    return [0, i, function(_d_){return ints(_c_, _d_);}];
   }
   var
    Stdlib_Seq =
      [0,
       is_empty,
       uncons,
       length,
       iter,
       fold_left,
       iteri,
       fold_lefti,
       for_all,
       exists,
       find,
       find_index,
       find_map,
       find_mapi,
       iter2,
       fold_left2,
       for_all2,
       exists2,
       equal,
       compare,
       empty,
       return$0,
       cons,
       init,
       unfold,
       repeat,
       forever,
       cycle,
       iterate,
       map,
       mapi,
       filter,
       filter_map,
       scan,
       take,
       drop,
       take_while,
       drop_while,
       group,
       memoize,
       Forced_twice,
       once,
       transpose,
       append,
       concat,
       flat_map,
       flat_map,
       zip,
       map2,
       interleave,
       sorted_merge,
       product,
       map_product,
       unzip,
       unzip,
       partition_map,
       partition,
       of_dispenser,
       to_dispenser,
       ints];
   runtime.caml_register_global(10, Stdlib_Seq, "Stdlib__Seq");
   return;
  }
  (globalThis));

//# 1943 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib = global_data.Stdlib,
    cst_option_is_None = "option is None";
   function some(v){return [0, v];}
   function value(o, default$0){
    if(! o) return default$0;
    var v = o[1];
    return v;
   }
   function get(param){
    if(! param) return caml_call1(Stdlib[1], cst_option_is_None);
    var v = param[1];
    return v;
   }
   function bind(o, f){
    if(! o) return 0;
    var v = o[1];
    return caml_call1(f, v);
   }
   function join(param){if(! param) return 0; var o = param[1]; return o;}
   function map(f, o){
    if(! o) return 0;
    var v = o[1];
    return [0, caml_call1(f, v)];
   }
   function fold(none, some, param){
    if(! param) return none;
    var v = param[1];
    return caml_call1(some, v);
   }
   function iter(f, param){
    if(! param) return 0;
    var v = param[1];
    return caml_call1(f, v);
   }
   function is_none(param){return param ? 0 : 1;}
   function is_some(param){return param ? 1 : 0;}
   function equal(eq, o0, o1){
    if(o0){
     if(o1){var v1 = o1[1], v0 = o0[1]; return caml_call2(eq, v0, v1);}
    }
    else if(! o1) return 1;
    return 0;
   }
   function compare(cmp, o0, o1){
    if(! o0) return o1 ? -1 : 0;
    var v0 = o0[1];
    if(! o1) return 1;
    var v1 = o1[1];
    return caml_call2(cmp, v0, v1);
   }
   function to_result(none, param){
    if(! param) return [1, none];
    var v = param[1];
    return [0, v];
   }
   function to_list(param){
    if(! param) return 0;
    var v = param[1];
    return [0, v, 0];
   }
   function to_seq(param){
    if(! param) return Stdlib_Seq[20];
    var v = param[1];
    return caml_call1(Stdlib_Seq[21], v);
   }
   var
    Stdlib_Option =
      [0,
       0,
       some,
       value,
       get,
       bind,
       join,
       map,
       fold,
       iter,
       is_none,
       is_some,
       equal,
       compare,
       to_result,
       to_list,
       to_seq];
   runtime.caml_register_global(3, Stdlib_Option, "Stdlib__Option");
   return;
  }
  (globalThis));

//# 2051 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib = global_data.Stdlib,
    cst_result_is_Error = "result is Error _",
    cst_result_is_Ok = "result is Ok _";
   function ok(v){return [0, v];}
   function error(e){return [1, e];}
   function value(r, default$0){
    if(0 !== r[0]) return default$0;
    var v = r[1];
    return v;
   }
   function get_ok(param){
    if(0 !== param[0]) return caml_call1(Stdlib[1], cst_result_is_Error);
    var v = param[1];
    return v;
   }
   function get_error(param){
    if(0 === param[0]) return caml_call1(Stdlib[1], cst_result_is_Ok);
    var e = param[1];
    return e;
   }
   function bind(r, f){
    if(0 !== r[0]) return r;
    var v = r[1];
    return caml_call1(f, v);
   }
   function join(e){if(0 !== e[0]) return e; var r = e[1]; return r;}
   function map(f, e){
    if(0 !== e[0]) return e;
    var v = e[1];
    return [0, caml_call1(f, v)];
   }
   function map_error(f, v){
    if(0 === v[0]) return v;
    var e = v[1];
    return [1, caml_call1(f, e)];
   }
   function fold(ok, error, param){
    if(0 === param[0]){var v = param[1]; return caml_call1(ok, v);}
    var e = param[1];
    return caml_call1(error, e);
   }
   function iter(f, param){
    if(0 !== param[0]) return 0;
    var v = param[1];
    return caml_call1(f, v);
   }
   function iter_error(f, param){
    if(0 === param[0]) return 0;
    var e = param[1];
    return caml_call1(f, e);
   }
   function is_ok(param){return 0 === param[0] ? 1 : 0;}
   function is_error(param){return 0 === param[0] ? 0 : 1;}
   function equal(ok, error, r0, r1){
    if(0 === r0[0]){
     var v0 = r0[1];
     if(0 === r1[0]){var v1 = r1[1]; return caml_call2(ok, v0, v1);}
    }
    else{
     var e0 = r0[1];
     if(0 !== r1[0]){var e1 = r1[1]; return caml_call2(error, e0, e1);}
    }
    return 0;
   }
   function compare(ok, error, r0, r1){
    if(0 === r0[0]){
     var v0 = r0[1];
     if(0 !== r1[0]) return -1;
     var v1 = r1[1];
     return caml_call2(ok, v0, v1);
    }
    var e0 = r0[1];
    if(0 === r1[0]) return 1;
    var e1 = r1[1];
    return caml_call2(error, e0, e1);
   }
   function to_option(param){
    if(0 !== param[0]) return 0;
    var v = param[1];
    return [0, v];
   }
   function to_list(param){
    if(0 !== param[0]) return 0;
    var v = param[1];
    return [0, v, 0];
   }
   function to_seq(param){
    if(0 !== param[0]) return Stdlib_Seq[20];
    var v = param[1];
    return caml_call1(Stdlib_Seq[21], v);
   }
   var
    Stdlib_Result =
      [0,
       ok,
       error,
       value,
       get_ok,
       get_error,
       bind,
       join,
       map,
       map_error,
       fold,
       iter,
       iter_error,
       is_ok,
       is_error,
       equal,
       compare,
       to_option,
       to_list,
       to_seq];
   runtime.caml_register_global(4, Stdlib_Result, "Stdlib__Result");
   return;
  }
  (globalThis));

//# 2217 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_bytes_unsafe_set = runtime.caml_bytes_unsafe_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_hash = runtime.caml_hash,
    caml_string_of_bytes = runtime.caml_string_of_bytes;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst = "\\\\",
    cst$0 = "\\'",
    Stdlib = global_data.Stdlib,
    cst_Char_chr = "Char.chr",
    cst_b = "\\b",
    cst_t = "\\t",
    cst_n = "\\n",
    cst_r = "\\r";
   function chr(n){
    if(0 <= n && 255 >= n) return n;
    return caml_call1(Stdlib[1], cst_Char_chr);
   }
   function escaped(c){
    a:
    {
     if(40 <= c){
      if(92 === c) return cst;
      if(127 > c) break a;
     }
     else{
      if(32 <= c){if(39 <= c) return cst$0; break a;}
      if(14 > c)
       switch(c){
         case 8:
          return cst_b;
         case 9:
          return cst_t;
         case 10:
          return cst_n;
         case 13:
          return cst_r;
       }
     }
     var s = caml_create_bytes(4);
     caml_bytes_unsafe_set(s, 0, 92);
     caml_bytes_unsafe_set(s, 1, 48 + (c / 100 | 0) | 0);
     caml_bytes_unsafe_set(s, 2, 48 + ((c / 10 | 0) % 10 | 0) | 0);
     caml_bytes_unsafe_set(s, 3, 48 + (c % 10 | 0) | 0);
     return caml_string_of_bytes(s);
    }
    var s$0 = caml_create_bytes(1);
    caml_bytes_unsafe_set(s$0, 0, c);
    return caml_string_of_bytes(s$0);
   }
   function lowercase_ascii(c){return 25 < c - 65 >>> 0 ? c : c + 32 | 0;}
   function uppercase_ascii(c){return 25 < c - 97 >>> 0 ? c : c - 32 | 0;}
   function compare(c1, c2){return c1 - c2 | 0;}
   function equal(c1, c2){return 0 === (c1 - c2 | 0) ? 1 : 0;}
   function seeded_hash(seed, x){return caml_hash(10, 100, seed, x);}
   function hash(x){return caml_hash(10, 100, 0, x);}
   var
    Stdlib_Char =
      [0,
       chr,
       escaped,
       lowercase_ascii,
       uppercase_ascii,
       compare,
       equal,
       seeded_hash,
       hash];
   runtime.caml_register_global(8, Stdlib_Char, "Stdlib__Char");
   return;
  }
  (globalThis));

//# 2301 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_uchar_ml = "uchar.ml",
    caml_format_int = runtime.caml_format_int,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    err_no_pred = "U+0000 has no predecessor",
    err_no_succ = "U+10FFFF has no successor",
    Assert_failure = global_data.Assert_failure,
    Stdlib = global_data.Stdlib,
    cst_is_not_an_Unicode_scalar_v = " is not an Unicode scalar value",
    cst_is_not_a_latin1_character = " is not a latin1 character",
    cst_U = "U+",
    lo_bound = 55295,
    hi_bound = 57344;
   function succ(u){
    return u === 55295
            ? hi_bound
            : u === 1114111 ? caml_call1(Stdlib[1], err_no_succ) : u + 1 | 0;
   }
   function pred(u){
    return u === 57344
            ? lo_bound
            : u === 0 ? caml_call1(Stdlib[1], err_no_pred) : u - 1 | 0;
   }
   function is_valid(i){
    var _n_ = 0 <= i ? 1 : 0, _o_ = _n_ ? i <= 55295 ? 1 : 0 : _n_;
    if(_o_)
     var _p_ = _o_;
    else
     var _q_ = 57344 <= i ? 1 : 0, _p_ = _q_ ? i <= 1114111 ? 1 : 0 : _q_;
    return _p_;
   }
   function of_int(i){
    if(is_valid(i)) return i;
    var
     _m_ =
       caml_call2
        (Stdlib[28], caml_format_int("%X", i), cst_is_not_an_Unicode_scalar_v);
    return caml_call1(Stdlib[1], _m_);
   }
   function is_char(u){return u < 256 ? 1 : 0;}
   function of_char(c){return c;}
   function to_char(u){
    if(255 >= u) return u;
    var
     _k_ =
       caml_call2
        (Stdlib[28],
         caml_format_int("%04X", u),
         cst_is_not_a_latin1_character),
     _l_ = caml_call2(Stdlib[28], cst_U, _k_);
    return caml_call1(Stdlib[1], _l_);
   }
   function unsafe_to_char(_j_){return _j_;}
   function equal(_i_, _h_){return _i_ === _h_ ? 1 : 0;}
   var
    compare = runtime.caml_int_compare,
    _a_ = [0, cst_uchar_ml, 85, 7],
    _b_ = [0, cst_uchar_ml, 80, 18],
    _c_ = [0, cst_uchar_ml, 91, 7],
    _d_ = [0, cst_uchar_ml, 88, 18];
   function hash(_g_){return _g_;}
   function utf_decode_is_valid(d){return 1 === (d >>> 27 | 0) ? 1 : 0;}
   function utf_decode_length(d){return (d >>> 24 | 0) & 7;}
   function utf_decode_uchar(d){return d & 16777215;}
   function utf_decode(n, u){return (8 | n) << 24 | u;}
   function utf_decode_invalid(n){return n << 24 | 65533;}
   function utf_8_byte_length(u){
    if(0 > u) throw caml_maybe_attach_backtrace([0, Assert_failure, _b_], 1);
    if(127 >= u) return 1;
    if(2047 >= u) return 2;
    if(65535 >= u) return 3;
    if(1114111 < u)
     throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
    return 4;
   }
   function utf_16_byte_length(u){
    if(0 > u) throw caml_maybe_attach_backtrace([0, Assert_failure, _d_], 1);
    if(65535 >= u) return 2;
    if(1114111 < u)
     throw caml_maybe_attach_backtrace([0, Assert_failure, _c_], 1);
    return 4;
   }
   var
    Stdlib_Uchar =
      [0,
       0,
       1114111,
       65279,
       65533,
       succ,
       pred,
       is_valid,
       of_int,
       function(_f_){return _f_;},
       function(_e_){return _e_;},
       is_char,
       of_char,
       to_char,
       unsafe_to_char,
       equal,
       compare,
       hash,
       utf_decode_is_valid,
       utf_decode_uchar,
       utf_decode_length,
       utf_decode,
       utf_decode_invalid,
       utf_8_byte_length,
       utf_16_byte_length];
   runtime.caml_register_global(13, Stdlib_Uchar, "Stdlib__Uchar");
   return;
  }
  (globalThis));

//# 2433 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_List_map2$1 = "List.map2",
    cst_List_nth$1 = "List.nth",
    caml_compare = runtime.caml_compare,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    cst_hd = "hd",
    cst_tl = "tl",
    cst_nth = "nth",
    cst_List_nth = cst_List_nth$1,
    cst_List_nth$0 = cst_List_nth$1;
   function length(l$0){
    var len = 0, param = l$0;
    for(;;){
     if(! param) return len;
     var l = param[2], len$0 = len + 1 | 0, len = len$0, param = l;
    }
   }
   function cons(a, l){return [0, a, l];}
   function hd(param){
    if(! param) return caml_call1(Stdlib[2], cst_hd);
    var a = param[1];
    return a;
   }
   function tl(param){
    if(! param) return caml_call1(Stdlib[2], cst_tl);
    var l = param[2];
    return l;
   }
   function nth(l, n){
    if(0 > n) return caml_call1(Stdlib[1], cst_List_nth);
    var l$0 = l, n$0 = n;
    for(;;){
     if(! l$0) return caml_call1(Stdlib[2], cst_nth);
     var l$1 = l$0[2], a = l$0[1];
     if(0 === n$0) return a;
     var n$1 = n$0 - 1 | 0, l$0 = l$1, n$0 = n$1;
    }
   }
   function nth_opt(l, n){
    if(0 > n) return caml_call1(Stdlib[1], cst_List_nth$0);
    var l$0 = l, n$0 = n;
    for(;;){
     if(! l$0) return 0;
     var l$1 = l$0[2], a = l$0[1];
     if(0 === n$0) return [0, a];
     var n$1 = n$0 - 1 | 0, l$0 = l$1, n$0 = n$1;
    }
   }
   var
    append = Stdlib[37],
    cst_List_init = "List.init",
    cst_List_map2 = cst_List_map2$1,
    cst_List_map2$0 = cst_List_map2$1,
    cst_List_rev_map2 = "List.rev_map2",
    cst_List_iter2 = "List.iter2",
    cst_List_fold_left2 = "List.fold_left2",
    cst_List_fold_right2 = "List.fold_right2",
    cst_List_for_all2 = "List.for_all2",
    cst_List_exists2 = "List.exists2",
    _a_ = [0, 0, 0],
    cst_List_combine = "List.combine";
   function rev_append(l1, l2){
    var l1$0 = l1, l2$0 = l2;
    for(;;){
     if(! l1$0) return l2$0;
     var
      l1$1 = l1$0[2],
      a = l1$0[1],
      l2$1 = [0, a, l2$0],
      l1$0 = l1$1,
      l2$0 = l2$1;
    }
   }
   function rev(l){return rev_append(l, 0);}
   function init(len, f){
    if(0 > len) return caml_call1(Stdlib[1], cst_List_init);
    var last = len - 1 | 0, i$1 = 0;
    if(last < 0) return 0;
    if(0 === last) return [0, caml_call1(f, i$1), 0];
    var
     r1 = caml_call1(f, i$1),
     r2 = caml_call1(f, 1),
     block = [0, r2, 24029],
     dst = block,
     offset = 1,
     i = 2;
    for(;;){
     if(last < i)
      dst[1 + offset] = 0;
     else{
      if(i !== last){
       var
        r1$0 = caml_call1(f, i),
        r2$0 = caml_call1(f, i + 1 | 0),
        dst$0 = [0, r2$0, 24029];
       dst[1 + offset] = [0, r1$0, dst$0];
       var i$0 = i + 2 | 0, dst = dst$0, offset = 1, i = i$0;
       continue;
      }
      dst[1 + offset] = [0, caml_call1(f, i), 0];
     }
     return [0, r1, block];
    }
   }
   function flatten(param){
    if(! param) return 0;
    var r = param[2], l = param[1], _I_ = flatten(r);
    return caml_call2(Stdlib[37], l, _I_);
   }
   function map(f, param){
    if(! param) return 0;
    var match = param[2], a1 = param[1];
    if(! match){var r1$0 = caml_call1(f, a1); return [0, r1$0, 0];}
    var
     l = match[2],
     a2 = match[1],
     r1 = caml_call1(f, a1),
     r2 = caml_call1(f, a2),
     block = [0, r2, 24029],
     dst = block,
     offset = 1,
     param$0 = l;
    for(;;){
     if(param$0){
      var match$0 = param$0[2], a1$0 = param$0[1];
      if(match$0){
       var
        l$0 = match$0[2],
        a2$0 = match$0[1],
        r1$1 = caml_call1(f, a1$0),
        r2$0 = caml_call1(f, a2$0),
        dst$0 = [0, r2$0, 24029];
       dst[1 + offset] = [0, r1$1, dst$0];
       var dst = dst$0, offset = 1, param$0 = l$0;
       continue;
      }
      var r1$2 = caml_call1(f, a1$0);
      dst[1 + offset] = [0, r1$2, 0];
     }
     else
      dst[1 + offset] = 0;
     return [0, r1, block];
    }
   }
   function mapi(f, l$1){
    var i$1 = 0;
    if(! l$1) return 0;
    var match = l$1[2], a1 = l$1[1];
    if(! match){var r1$0 = caml_call2(f, i$1, a1); return [0, r1$0, 0];}
    var
     l = match[2],
     a2 = match[1],
     r1 = caml_call2(f, i$1, a1),
     r2 = caml_call2(f, 1, a2),
     block = [0, r2, 24029],
     dst = block,
     offset = 1,
     i = 2,
     param = l;
    for(;;){
     if(param){
      var match$0 = param[2], a1$0 = param[1];
      if(match$0){
       var
        l$0 = match$0[2],
        a2$0 = match$0[1],
        r1$1 = caml_call2(f, i, a1$0),
        r2$0 = caml_call2(f, i + 1 | 0, a2$0),
        dst$0 = [0, r2$0, 24029];
       dst[1 + offset] = [0, r1$1, dst$0];
       var i$0 = i + 2 | 0, dst = dst$0, offset = 1, i = i$0, param = l$0;
       continue;
      }
      var r1$2 = caml_call2(f, i, a1$0);
      dst[1 + offset] = [0, r1$2, 0];
     }
     else
      dst[1 + offset] = 0;
     return [0, r1, block];
    }
   }
   function rev_map(f, l){
    var accu = 0, param = l;
    for(;;){
     if(! param) return accu;
     var
      l$0 = param[2],
      a = param[1],
      accu$0 = [0, caml_call1(f, a), accu],
      accu = accu$0,
      param = l$0;
    }
   }
   function iter(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], a = param$0[1];
     caml_call1(f, a);
     var param$0 = l;
    }
   }
   function iteri(f, l$0){
    var i = 0, param = l$0;
    for(;;){
     if(! param) return 0;
     var l = param[2], a = param[1];
     caml_call2(f, i, a);
     var i$0 = i + 1 | 0, i = i$0, param = l;
    }
   }
   function fold_left(f, accu, l){
    var accu$0 = accu, l$0 = l;
    for(;;){
     if(! l$0) return accu$0;
     var
      l$1 = l$0[2],
      a = l$0[1],
      accu$1 = caml_call2(f, accu$0, a),
      accu$0 = accu$1,
      l$0 = l$1;
    }
   }
   function fold_right(f, l, accu){
    if(! l) return accu;
    var l$0 = l[2], a = l[1];
    return caml_call2(f, a, fold_right(f, l$0, accu));
   }
   function map2(f, l1, l2){
    if(l1){
     var _G_ = l1[2], a1 = l1[1];
     if(_G_){
      if(l2){
       var match = l2[2];
       if(match){
        var
         l2$0 = match[2],
         b2 = match[1],
         b1 = l2[1],
         l1$0 = _G_[2],
         a2 = _G_[1],
         r1 = caml_call2(f, a1, b1),
         r2 = caml_call2(f, a2, b2),
         block = [0, r2, 24029],
         dst = block,
         offset = 1,
         l1$1 = l1$0,
         l2$1 = l2$0;
        for(;;){
         a:
         {
          if(l1$1){
           var _H_ = l1$1[2], a1$0 = l1$1[1];
           if(_H_){
            if(l2$1){
             var match$0 = l2$1[2];
             if(match$0){
              var
               l2$2 = match$0[2],
               b2$0 = match$0[1],
               b1$1 = l2$1[1],
               l1$2 = _H_[2],
               a2$0 = _H_[1],
               r1$1 = caml_call2(f, a1$0, b1$1),
               r2$0 = caml_call2(f, a2$0, b2$0),
               dst$0 = [0, r2$0, 24029];
              dst[1 + offset] = [0, r1$1, dst$0];
              var dst = dst$0, offset = 1, l1$1 = l1$2, l2$1 = l2$2;
              continue;
             }
            }
           }
           else if(l2$1 && ! l2$1[2]){
            var b1$2 = l2$1[1], r1$2 = caml_call2(f, a1$0, b1$2);
            dst[1 + offset] = [0, r1$2, 0];
            break a;
           }
          }
          else if(! l2$1){dst[1 + offset] = 0; break a;}
          dst[1 + offset] = caml_call1(Stdlib[1], cst_List_map2$0);
         }
         return [0, r1, block];
        }
       }
      }
     }
     else if(l2 && ! l2[2]){
      var b1$0 = l2[1], r1$0 = caml_call2(f, a1, b1$0);
      return [0, r1$0, 0];
     }
    }
    else if(! l2) return 0;
    return caml_call1(Stdlib[1], cst_List_map2);
   }
   function rev_map2(f, l1, l2){
    var accu = 0, l1$0 = l1, l2$0 = l2;
    for(;;){
     if(l1$0){
      if(l2$0){
       var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
        accu$0 = [0, caml_call2(f, a1, a2), accu],
        accu = accu$0,
        l1$0 = l1$1,
        l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0) return accu;
     return caml_call1(Stdlib[1], cst_List_rev_map2);
    }
   }
   function iter2(f, l1, l2){
    var l1$0 = l1, l2$0 = l2;
    for(;;){
     if(l1$0){
      if(l2$0){
       var l2$1 = l2$0[2], a2 = l2$0[1], l1$1 = l1$0[2], a1 = l1$0[1];
       caml_call2(f, a1, a2);
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0) return 0;
     return caml_call1(Stdlib[1], cst_List_iter2);
    }
   }
   function fold_left2(f, accu, l1, l2){
    var accu$0 = accu, l1$0 = l1, l2$0 = l2;
    for(;;){
     if(l1$0){
      if(l2$0){
       var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
        accu$1 = caml_call3(f, accu$0, a1, a2),
        accu$0 = accu$1,
        l1$0 = l1$1,
        l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0) return accu$0;
     return caml_call1(Stdlib[1], cst_List_fold_left2);
    }
   }
   function fold_right2(f, l1, l2, accu){
    if(l1){
     if(l2){
      var l2$0 = l2[2], a2 = l2[1], l1$0 = l1[2], a1 = l1[1];
      return caml_call3(f, a1, a2, fold_right2(f, l1$0, l2$0, accu));
     }
    }
    else if(! l2) return accu;
    return caml_call1(Stdlib[1], cst_List_fold_right2);
   }
   function for_all(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 1;
     var l = param$0[2], a = param$0[1], _F_ = caml_call1(p, a);
     if(! _F_) return _F_;
     var param$0 = l;
    }
   }
   function exists(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], a = param$0[1], _E_ = caml_call1(p, a);
     if(_E_) return _E_;
     var param$0 = l;
    }
   }
   function for_all2(p, l1, l2){
    var l1$0 = l1, l2$0 = l2;
    for(;;){
     if(l1$0){
      if(l2$0){
       var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
        _D_ = caml_call2(p, a1, a2);
       if(! _D_) return _D_;
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0) return 1;
     return caml_call1(Stdlib[1], cst_List_for_all2);
    }
   }
   function exists2(p, l1, l2){
    var l1$0 = l1, l2$0 = l2;
    for(;;){
     if(l1$0){
      if(l2$0){
       var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
        _C_ = caml_call2(p, a1, a2);
       if(_C_) return _C_;
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0) return 0;
     return caml_call1(Stdlib[1], cst_List_exists2);
    }
   }
   function mem(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var
      l = param$0[2],
      a = param$0[1],
      _B_ = 0 === caml_compare(a, x) ? 1 : 0;
     if(_B_) return _B_;
     var param$0 = l;
    }
   }
   function memq(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], a = param$0[1], _A_ = a === x ? 1 : 0;
     if(_A_) return _A_;
     var param$0 = l;
    }
   }
   function assoc(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
     if(0 === caml_compare(a, x)) return b;
     var param$0 = l;
    }
   }
   function assoc_opt(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
     if(0 === caml_compare(a, x)) return [0, b];
     var param$0 = l;
    }
   }
   function assq(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
     if(a === x) return b;
     var param$0 = l;
    }
   }
   function assq_opt(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], match = param$0[1], b = match[2], a = match[1];
     if(a === x) return [0, b];
     var param$0 = l;
    }
   }
   function mem_assoc(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var
      l = param$0[2],
      a = param$0[1][1],
      _z_ = 0 === caml_compare(a, x) ? 1 : 0;
     if(_z_) return _z_;
     var param$0 = l;
    }
   }
   function mem_assq(x, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], a = param$0[1][1], _y_ = a === x ? 1 : 0;
     if(_y_) return _y_;
     var param$0 = l;
    }
   }
   function remove_assoc(x, param){
    if(! param) return 0;
    var l = param[2], pair = param[1], a = pair[1];
    return 0 === caml_compare(a, x) ? l : [0, pair, remove_assoc(x, l)];
   }
   function remove_assq(x, param){
    if(! param) return 0;
    var l = param[2], pair = param[1], a = pair[1];
    return a === x ? l : [0, pair, remove_assq(x, l)];
   }
   function find(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     var l = param$0[2], x = param$0[1];
     if(caml_call1(p, x)) return x;
     var param$0 = l;
    }
   }
   function find_opt(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], x = param$0[1];
     if(caml_call1(p, x)) return [0, x];
     var param$0 = l;
    }
   }
   function find_index(p){
    var i = 0;
    return function(param$0){
     var i$0 = i, param = param$0;
     for(;;){
      if(! param) return 0;
      var l = param[2], a = param[1];
      if(caml_call1(p, a)) return [0, i$0];
      var i$1 = i$0 + 1 | 0, i$0 = i$1, param = l;
     }};
   }
   function find_map(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], x = param$0[1], result = caml_call1(f, x);
     if(result) return result;
     var param$0 = l;
    }
   }
   function find_mapi(f){
    var i = 0;
    return function(param$0){
     var i$0 = i, param = param$0;
     for(;;){
      if(! param) return 0;
      var l = param[2], x = param[1], result = caml_call2(f, i$0, x);
      if(result) return result;
      var i$1 = i$0 + 1 | 0, i$0 = i$1, param = l;
     }};
   }
   function find_all(p, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], x = param$0[1];
     if(caml_call1(p, x)){
      var block = [0, x, 24029], dst = block, offset = 1, param$1 = l;
      for(;;){
       if(! param$1){dst[1 + offset] = 0; return block;}
       var l$0 = param$1[2], x$0 = param$1[1];
       if(caml_call1(p, x$0)){
        var dst$0 = [0, x$0, 24029];
        dst[1 + offset] = dst$0;
        var dst = dst$0, offset = 1, param$1 = l$0;
       }
       else
        var param$1 = l$0;
      }
     }
     else
      var param$0 = l;
    }
   }
   function filteri(p, l$1){
    var i = 0, param = l$1;
    for(;;){
     if(! param) return 0;
     var l = param[2], x = param[1], i$0 = i + 1 | 0;
     if(caml_call2(p, i, x)) break;
     var i = i$0, param = l;
    }
    var
     block = [0, x, 24029],
     dst = block,
     offset = 1,
     i$1 = i$0,
     param$0 = l;
    for(;;){
     if(! param$0){dst[1 + offset] = 0; return block;}
     var l$0 = param$0[2], x$0 = param$0[1], i$2 = i$1 + 1 | 0;
     if(caml_call2(p, i$1, x$0)){
      var dst$0 = [0, x$0, 24029];
      dst[1 + offset] = dst$0;
      var dst = dst$0, offset = 1, i$1 = i$2, param$0 = l$0;
     }
     else
      var i$1 = i$2, param$0 = l$0;
    }
   }
   function filter_map(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var l = param$0[2], x = param$0[1], match = caml_call1(f, x);
     if(match){
      var
       v = match[1],
       block = [0, v, 24029],
       dst = block,
       offset = 1,
       param$1 = l;
      for(;;){
       if(! param$1){dst[1 + offset] = 0; return block;}
       var l$0 = param$1[2], x$0 = param$1[1], match$0 = caml_call1(f, x$0);
       if(match$0){
        var v$0 = match$0[1], dst$0 = [0, v$0, 24029];
        dst[1 + offset] = dst$0;
        var dst = dst$0, offset = 1, param$1 = l$0;
       }
       else
        var param$1 = l$0;
      }
     }
     else
      var param$0 = l;
    }
   }
   function concat_map(f, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return 0;
     var xs = param$0[2], x = param$0[1], ys = caml_call1(f, x);
     if(ys){
      var
       ys$1 = ys[2],
       y = ys[1],
       block = [0, y, 24029],
       dst = block,
       offset = 1,
       ys$2 = ys$1,
       xs$1 = xs;
      for(;;)
       if(ys$2){
        var ys$3 = ys$2[2], y$0 = ys$2[1], dst$0 = [0, y$0, 24029];
        dst[1 + offset] = dst$0;
        var dst = dst$0, offset = 1, ys$2 = ys$3;
       }
       else{
        if(! xs$1){dst[1 + offset] = 0; return block;}
        var
         xs$0 = xs$1[2],
         x$0 = xs$1[1],
         ys$0 = caml_call1(f, x$0),
         ys$2 = ys$0,
         xs$1 = xs$0;
       }
     }
     else
      var param$0 = xs;
    }
   }
   function fold_left_map(f, accu, l){
    var accu$0 = accu, l_accu = 0, param = l;
    for(;;){
     if(! param) return [0, accu$0, rev(l_accu)];
     var
      l$0 = param[2],
      x = param[1],
      match = caml_call2(f, accu$0, x),
      x$0 = match[2],
      accu$1 = match[1],
      l_accu$0 = [0, x$0, l_accu],
      accu$0 = accu$1,
      l_accu = l_accu$0,
      param = l$0;
    }
   }
   function partition(p, l){
    var yes = 0, no = 0, param = l;
    for(;;){
     if(! param){var _x_ = rev(no); return [0, rev(yes), _x_];}
     var l$0 = param[2], x = param[1];
     if(caml_call1(p, x))
      var yes$0 = [0, x, yes], yes = yes$0, param = l$0;
     else
      var no$0 = [0, x, no], no = no$0, param = l$0;
    }
   }
   function partition_map(p, l){
    var left = 0, right = 0, param = l;
    for(;;){
     if(! param){var _w_ = rev(right); return [0, rev(left), _w_];}
     var l$0 = param[2], x = param[1], match = caml_call1(p, x);
     if(0 === match[0])
      var v = match[1], left$0 = [0, v, left], left = left$0, param = l$0;
     else
      var
       v$0 = match[1],
       right$0 = [0, v$0, right],
       right = right$0,
       param = l$0;
    }
   }
   function split(param){
    if(! param) return _a_;
    var
     l = param[2],
     match = param[1],
     y = match[2],
     x = match[1],
     match$0 = split(l),
     ry = match$0[2],
     rx = match$0[1];
    return [0, [0, x, rx], [0, y, ry]];
   }
   function combine(l1, l2){
    if(l1){
     if(l2){
      var l2$0 = l2[2], a2 = l2[1], l1$0 = l1[2], a1 = l1[1];
      return [0, [0, a1, a2], combine(l1$0, l2$0)];
     }
    }
    else if(! l2) return 0;
    return caml_call1(Stdlib[1], cst_List_combine);
   }
   function merge(cmp, l1, l2){
    if(! l1) return l2;
    if(! l2) return l1;
    var t2 = l2[2], h2 = l2[1], t1 = l1[2], h1 = l1[1];
    return 0 < caml_call2(cmp, h1, h2)
            ? [0, h2, merge(cmp, l1, t2)]
            : [0, h1, merge(cmp, t1, l2)];
   }
   function stable_sort(cmp, l){
    function sort(n, l){
     if(2 === n){
      if(l){
       var match = l[2];
       if(match){
        var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
         s =
           0 < caml_call2(cmp, x1, x2)
            ? [0, x2, [0, x1, 0]]
            : [0, x1, [0, x2, 0]];
        return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _v_ = l[2];
      if(_v_){
       var match$2 = _v_[2];
       if(match$2){
        var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _v_[1],
         x1$0 = l[1],
         s$0 =
           0 < caml_call2(cmp, x1$0, x2$0)
            ? 0
              < caml_call2(cmp, x1$0, x3)
              ? 0
                < caml_call2(cmp, x2$0, x3)
                ? [0, x3, [0, x2$0, [0, x1$0, 0]]]
                : [0, x2$0, [0, x3, [0, x1$0, 0]]]
              : [0, x2$0, [0, x1$0, [0, x3, 0]]]
            : 0
              < caml_call2(cmp, x2$0, x3)
              ? 0
                < caml_call2(cmp, x1$0, x3)
                ? [0, x3, [0, x1$0, [0, x2$0, 0]]]
                : [0, x1$0, [0, x3, [0, x2$0, 0]]]
              : [0, x1$0, [0, x2$0, [0, x3, 0]]];
        return [0, s$0, tl$1];
       }
      }
     }
     var
      n1 = n >> 1,
      n2 = n - n1 | 0,
      match$0 = rev_sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
      match$1 = rev_sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
     for(;;){
      if(l1){
       if(l2){
        var t2 = l2[2], h2 = l2[1], t1 = l1[2], h1 = l1[1];
        if(0 < caml_call2(cmp, h1, h2)){
         var accu$0 = [0, h1, accu], l1 = t1, accu = accu$0;
         continue;
        }
        var accu$1 = [0, h2, accu], l2 = t2, accu = accu$1;
        continue;
       }
       var _u_ = rev_append(l1, accu);
      }
      else
       var _u_ = rev_append(l2, accu);
      return [0, _u_, tl$0];
     }
    }
    function rev_sort(n, l){
     if(2 === n){
      if(l){
       var match = l[2];
       if(match){
        var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
         s =
           0 < caml_call2(cmp, x1, x2)
            ? [0, x1, [0, x2, 0]]
            : [0, x2, [0, x1, 0]];
        return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _t_ = l[2];
      if(_t_){
       var match$2 = _t_[2];
       if(match$2){
        var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _t_[1],
         x1$0 = l[1],
         s$0 =
           0 < caml_call2(cmp, x1$0, x2$0)
            ? 0
              < caml_call2(cmp, x2$0, x3)
              ? [0, x1$0, [0, x2$0, [0, x3, 0]]]
              : 0
                < caml_call2(cmp, x1$0, x3)
                ? [0, x1$0, [0, x3, [0, x2$0, 0]]]
                : [0, x3, [0, x1$0, [0, x2$0, 0]]]
            : 0
              < caml_call2(cmp, x1$0, x3)
              ? [0, x2$0, [0, x1$0, [0, x3, 0]]]
              : 0
                < caml_call2(cmp, x2$0, x3)
                ? [0, x2$0, [0, x3, [0, x1$0, 0]]]
                : [0, x3, [0, x2$0, [0, x1$0, 0]]];
        return [0, s$0, tl$1];
       }
      }
     }
     var
      n1 = n >> 1,
      n2 = n - n1 | 0,
      match$0 = sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
      match$1 = sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
     for(;;){
      if(l1){
       if(l2){
        var t2 = l2[2], h2 = l2[1], t1 = l1[2], h1 = l1[1];
        if(0 < caml_call2(cmp, h1, h2)){
         var accu$0 = [0, h2, accu], l2 = t2, accu = accu$0;
         continue;
        }
        var accu$1 = [0, h1, accu], l1 = t1, accu = accu$1;
        continue;
       }
       var _s_ = rev_append(l1, accu);
      }
      else
       var _s_ = rev_append(l2, accu);
      return [0, _s_, tl$0];
     }
    }
    var len = length(l);
    return 2 <= len ? sort(len, l)[1] : l;
   }
   function sort_uniq(cmp, l){
    function sort(n, l){
     if(2 === n){
      if(l){
       var match = l[2];
       if(match){
        var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
         c$0 = caml_call2(cmp, x1, x2),
         s =
           0 === c$0
            ? [0, x1, 0]
            : 0 <= c$0 ? [0, x2, [0, x1, 0]] : [0, x1, [0, x2, 0]];
        return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _m_ = l[2];
      if(_m_){
       var match$2 = _m_[2];
       if(match$2){
        var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _m_[1],
         x1$0 = l[1],
         c$1 = caml_call2(cmp, x1$0, x2$0);
        if(0 === c$1)
         var
          c$2 = caml_call2(cmp, x2$0, x3),
          _n_ =
            0 === c$2
             ? [0, x2$0, 0]
             : 0 <= c$2 ? [0, x3, [0, x2$0, 0]] : [0, x2$0, [0, x3, 0]],
          s$0 = _n_;
        else if(0 <= c$1){
         var c$3 = caml_call2(cmp, x1$0, x3);
         if(0 === c$3)
          var _o_ = [0, x2$0, [0, x1$0, 0]];
         else if(0 <= c$3)
          var
           c$4 = caml_call2(cmp, x2$0, x3),
           _p_ =
             0 === c$4
              ? [0, x2$0, [0, x1$0, 0]]
              : 0
                <= c$4
                ? [0, x3, [0, x2$0, [0, x1$0, 0]]]
                : [0, x2$0, [0, x3, [0, x1$0, 0]]],
           _o_ = _p_;
         else
          var _o_ = [0, x2$0, [0, x1$0, [0, x3, 0]]];
         var s$0 = _o_;
        }
        else{
         var c$5 = caml_call2(cmp, x2$0, x3);
         if(0 === c$5)
          var _q_ = [0, x1$0, [0, x2$0, 0]];
         else if(0 <= c$5)
          var
           c$6 = caml_call2(cmp, x1$0, x3),
           _r_ =
             0 === c$6
              ? [0, x1$0, [0, x2$0, 0]]
              : 0
                <= c$6
                ? [0, x3, [0, x1$0, [0, x2$0, 0]]]
                : [0, x1$0, [0, x3, [0, x2$0, 0]]],
           _q_ = _r_;
         else
          var _q_ = [0, x1$0, [0, x2$0, [0, x3, 0]]];
         var s$0 = _q_;
        }
        return [0, s$0, tl$1];
       }
      }
     }
     var
      n1 = n >> 1,
      n2 = n - n1 | 0,
      match$0 = rev_sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
      match$1 = rev_sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
     for(;;){
      if(l1){
       if(l2){
        var
         t2 = l2[2],
         h2 = l2[1],
         t1 = l1[2],
         h1 = l1[1],
         c = caml_call2(cmp, h1, h2);
        if(0 === c){
         var accu$0 = [0, h1, accu], l1 = t1, l2 = t2, accu = accu$0;
         continue;
        }
        if(0 < c){
         var accu$1 = [0, h1, accu], l1 = t1, accu = accu$1;
         continue;
        }
        var accu$2 = [0, h2, accu], l2 = t2, accu = accu$2;
        continue;
       }
       var _l_ = rev_append(l1, accu);
      }
      else
       var _l_ = rev_append(l2, accu);
      return [0, _l_, tl$0];
     }
    }
    function rev_sort(n, l){
     if(2 === n){
      if(l){
       var match = l[2];
       if(match){
        var
         tl = match[2],
         x2 = match[1],
         x1 = l[1],
         c$0 = caml_call2(cmp, x1, x2),
         s =
           0 === c$0
            ? [0, x1, 0]
            : 0 < c$0 ? [0, x1, [0, x2, 0]] : [0, x2, [0, x1, 0]];
        return [0, s, tl];
       }
      }
     }
     else if(3 === n && l){
      var _f_ = l[2];
      if(_f_){
       var match$2 = _f_[2];
       if(match$2){
        var
         tl$1 = match$2[2],
         x3 = match$2[1],
         x2$0 = _f_[1],
         x1$0 = l[1],
         c$1 = caml_call2(cmp, x1$0, x2$0);
        if(0 === c$1)
         var
          c$2 = caml_call2(cmp, x2$0, x3),
          _g_ =
            0 === c$2
             ? [0, x2$0, 0]
             : 0 < c$2 ? [0, x2$0, [0, x3, 0]] : [0, x3, [0, x2$0, 0]],
          s$0 = _g_;
        else if(0 < c$1){
         var c$3 = caml_call2(cmp, x2$0, x3);
         if(0 === c$3)
          var _h_ = [0, x1$0, [0, x2$0, 0]];
         else if(0 < c$3)
          var _h_ = [0, x1$0, [0, x2$0, [0, x3, 0]]];
         else
          var
           c$4 = caml_call2(cmp, x1$0, x3),
           _i_ =
             0 === c$4
              ? [0, x1$0, [0, x2$0, 0]]
              : 0
                < c$4
                ? [0, x1$0, [0, x3, [0, x2$0, 0]]]
                : [0, x3, [0, x1$0, [0, x2$0, 0]]],
           _h_ = _i_;
         var s$0 = _h_;
        }
        else{
         var c$5 = caml_call2(cmp, x1$0, x3);
         if(0 === c$5)
          var _j_ = [0, x2$0, [0, x1$0, 0]];
         else if(0 < c$5)
          var _j_ = [0, x2$0, [0, x1$0, [0, x3, 0]]];
         else
          var
           c$6 = caml_call2(cmp, x2$0, x3),
           _k_ =
             0 === c$6
              ? [0, x2$0, [0, x1$0, 0]]
              : 0
                < c$6
                ? [0, x2$0, [0, x3, [0, x1$0, 0]]]
                : [0, x3, [0, x2$0, [0, x1$0, 0]]],
           _j_ = _k_;
         var s$0 = _j_;
        }
        return [0, s$0, tl$1];
       }
      }
     }
     var
      n1 = n >> 1,
      n2 = n - n1 | 0,
      match$0 = sort(n1, l),
      l2$0 = match$0[2],
      s1 = match$0[1],
      match$1 = sort(n2, l2$0),
      tl$0 = match$1[2],
      s2 = match$1[1],
      l1 = s1,
      l2 = s2,
      accu = 0;
     for(;;){
      if(l1){
       if(l2){
        var
         t2 = l2[2],
         h2 = l2[1],
         t1 = l1[2],
         h1 = l1[1],
         c = caml_call2(cmp, h1, h2);
        if(0 === c){
         var accu$0 = [0, h1, accu], l1 = t1, l2 = t2, accu = accu$0;
         continue;
        }
        if(0 <= c){
         var accu$1 = [0, h2, accu], l2 = t2, accu = accu$1;
         continue;
        }
        var accu$2 = [0, h1, accu], l1 = t1, accu = accu$2;
        continue;
       }
       var _e_ = rev_append(l1, accu);
      }
      else
       var _e_ = rev_append(l2, accu);
      return [0, _e_, tl$0];
     }
    }
    var len = length(l);
    return 2 <= len ? sort(len, l)[1] : l;
   }
   function compare_lengths(l1, l2){
    var l1$0 = l1, l2$0 = l2;
    for(;;){
     if(! l1$0) return l2$0 ? -1 : 0;
     if(! l2$0) return 1;
     var l2$1 = l2$0[2], l1$1 = l1$0[2], l1$0 = l1$1, l2$0 = l2$1;
    }
   }
   function compare_length_with(l, n){
    var l$0 = l, n$0 = n;
    for(;;){
     if(! l$0) return 0 === n$0 ? 0 : 0 < n$0 ? -1 : 1;
     var l$1 = l$0[2];
     if(0 >= n$0) return 1;
     var n$1 = n$0 - 1 | 0, l$0 = l$1, n$0 = n$1;
    }
   }
   function is_empty(param){return param ? 0 : 1;}
   function equal(eq, l1, l2){
    var l1$0 = l1, l2$0 = l2;
    for(;;){
     if(l1$0){
      if(l2$0){
       var
        l2$1 = l2$0[2],
        a2 = l2$0[1],
        l1$1 = l1$0[2],
        a1 = l1$0[1],
        _d_ = caml_call2(eq, a1, a2);
       if(! _d_) return _d_;
       var l1$0 = l1$1, l2$0 = l2$1;
       continue;
      }
     }
     else if(! l2$0) return 1;
     return 0;
    }
   }
   function compare(cmp, l1, l2){
    var l1$0 = l1, l2$0 = l2;
    for(;;){
     if(! l1$0) return l2$0 ? -1 : 0;
     var l1$1 = l1$0[2], a1 = l1$0[1];
     if(! l2$0) return 1;
     var l2$1 = l2$0[2], a2 = l2$0[1], c = caml_call2(cmp, a1, a2);
     if(0 !== c) return c;
     var l1$0 = l1$1, l2$0 = l2$1;
    }
   }
   function to_seq(l){
    function aux(l, param){
     if(! l) return 0;
     var tail = l[2], x = l[1];
     return [0, x, function(_c_){return aux(tail, _c_);}];
    }
    return function(_b_){return aux(l, _b_);};
   }
   function of_seq(seq){
    var match = caml_call1(seq, 0);
    if(! match) return 0;
    var seq$0 = match[2], x1 = match[1], match$0 = caml_call1(seq$0, 0);
    if(! match$0) return [0, x1, 0];
    var
     seq$1 = match$0[2],
     x2 = match$0[1],
     block = [0, x2, 24029],
     dst = block,
     offset = 1,
     seq$2 = seq$1;
    for(;;){
     var match$1 = caml_call1(seq$2, 0);
     if(match$1){
      var
       seq$3 = match$1[2],
       x1$0 = match$1[1],
       match$2 = caml_call1(seq$3, 0);
      if(match$2){
       var seq$4 = match$2[2], x2$0 = match$2[1], dst$0 = [0, x2$0, 24029];
       dst[1 + offset] = [0, x1$0, dst$0];
       var dst = dst$0, offset = 1, seq$2 = seq$4;
       continue;
      }
      dst[1 + offset] = [0, x1$0, 0];
     }
     else
      dst[1 + offset] = 0;
     return [0, x1, block];
    }
   }
   var
    Stdlib_List =
      [0,
       length,
       compare_lengths,
       compare_length_with,
       is_empty,
       cons,
       hd,
       tl,
       nth,
       nth_opt,
       rev,
       init,
       append,
       rev_append,
       flatten,
       flatten,
       equal,
       compare,
       iter,
       iteri,
       map,
       mapi,
       rev_map,
       filter_map,
       concat_map,
       fold_left_map,
       fold_left,
       fold_right,
       iter2,
       map2,
       rev_map2,
       fold_left2,
       fold_right2,
       for_all,
       exists,
       for_all2,
       exists2,
       mem,
       memq,
       find,
       find_opt,
       find_index,
       find_map,
       find_mapi,
       find_all,
       find_all,
       filteri,
       partition,
       partition_map,
       assoc,
       assoc_opt,
       assq,
       assq_opt,
       mem_assoc,
       mem_assq,
       remove_assoc,
       remove_assq,
       split,
       combine,
       stable_sort,
       stable_sort,
       stable_sort,
       sort_uniq,
       merge,
       to_seq,
       of_seq];
   runtime.caml_register_global(17, Stdlib_List, "Stdlib__List");
   return;
  }
  (globalThis));

//# 3755 ".js/default/stdlib/stdlib.cma.js"
(function(globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime, caml_hash = runtime.caml_hash;
   function abs(x){return 0 <= x ? x : - x | 0;}
   function lognot(x){return x ^ -1;}
   function equal(_b_, _a_){return _b_ === _a_ ? 1 : 0;}
   var compare = runtime.caml_int_compare;
   function min(x, y){return x <= y ? x : y;}
   function max(x, y){return y <= x ? x : y;}
   function to_string(x){return "" + x;}
   function seeded_hash(seed, x){return caml_hash(10, 100, seed, x);}
   function hash(x){return caml_hash(10, 100, 0, x);}
   var
    Stdlib_Int =
      [0,
       0,
       1,
       -1,
       abs,
       2147483647,
       -2147483648,
       lognot,
       equal,
       compare,
       min,
       max,
       to_string,
       seeded_hash,
       hash];
   runtime.caml_register_global(1, Stdlib_Int, "Stdlib__Int");
   return;
  }
  (globalThis));

//# 3791 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_bytes_ml = "bytes.ml",
    cst_index_out_of_bounds$3 = "index out of bounds",
    caml_blit_bytes = runtime.caml_blit_bytes,
    caml_bswap16 = runtime.caml_bswap16,
    caml_bytes_get = runtime.caml_bytes_get,
    caml_bytes_get16 = runtime.caml_bytes_get16,
    caml_bytes_get32 = runtime.caml_bytes_get32,
    caml_bytes_get64 = runtime.caml_bytes_get64,
    caml_bytes_of_string = runtime.caml_bytes_of_string,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_bytes_set16 = runtime.caml_bytes_set16,
    caml_bytes_set32 = runtime.caml_bytes_set32,
    caml_bytes_set64 = runtime.caml_bytes_set64,
    caml_bytes_unsafe_get = runtime.caml_bytes_unsafe_get,
    caml_bytes_unsafe_set = runtime.caml_bytes_unsafe_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_fill_bytes = runtime.caml_fill_bytes,
    caml_int32_bswap = runtime.caml_int32_bswap,
    caml_int64_bswap = runtime.caml_int64_bswap,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length,
    caml_string_of_bytes = runtime.caml_string_of_bytes,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Uchar = global_data.Stdlib__Uchar,
    Assert_failure = global_data.Assert_failure,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Int = global_data.Stdlib__Int,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_Char = global_data.Stdlib__Char;
   function make(n, c){
    var s = caml_create_bytes(n);
    caml_fill_bytes(s, 0, n, c);
    return s;
   }
   function init(n, f){
    var s = caml_create_bytes(n), _ap_ = n - 1 | 0, _ao_ = 0;
    if(_ap_ >= 0){
     var i = _ao_;
     for(;;){
      caml_bytes_unsafe_set(s, i, caml_call1(f, i));
      var _aq_ = i + 1 | 0;
      if(_ap_ === i) break;
      var i = _aq_;
     }
    }
    return s;
   }
   var
    empty = caml_create_bytes(0),
    cst_String_sub_Bytes_sub = "String.sub / Bytes.sub",
    cst_Bytes_extend = "Bytes.extend",
    cst_String_fill_Bytes_fill = "String.fill / Bytes.fill",
    cst_Bytes_blit = "Bytes.blit",
    cst_String_blit_Bytes_blit_str = "String.blit / Bytes.blit_string",
    cst_Bytes_concat = "Bytes.concat",
    cst_String_index_from_Bytes_in = "String.index_from / Bytes.index_from",
    cst_String_index_from_opt_Byte =
      "String.index_from_opt / Bytes.index_from_opt",
    cst_String_rindex_from_Bytes_r = "String.rindex_from / Bytes.rindex_from",
    cst_String_rindex_from_opt_Byt =
      "String.rindex_from_opt / Bytes.rindex_from_opt",
    cst_String_contains_from_Bytes =
      "String.contains_from / Bytes.contains_from",
    cst_String_rcontains_from_Byte =
      "String.rcontains_from / Bytes.rcontains_from";
   function copy(s){
    var len = caml_ml_bytes_length(s), r = caml_create_bytes(len);
    caml_blit_bytes(s, 0, r, 0, len);
    return r;
   }
   function to_string(b){return caml_string_of_bytes(copy(b));}
   function of_string(s){return copy(caml_bytes_of_string(s));}
   function sub(s, ofs, len){
    if(0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs){
     var r = caml_create_bytes(len);
     caml_blit_bytes(s, ofs, r, 0, len);
     return r;
    }
    return caml_call1(Stdlib[1], cst_String_sub_Bytes_sub);
   }
   function sub_string(b, ofs, len){
    return caml_string_of_bytes(sub(b, ofs, len));
   }
   function symbol(a, b){
    var c = a + b | 0, _an_ = b < 0 ? 1 : 0, match = c < 0 ? 1 : 0;
    a:
    {
     if(a < 0){if(_an_ && ! match) break a;} else if(! _an_ && match) break a;
     return c;
    }
    return caml_call1(Stdlib[1], cst_Bytes_extend);
   }
   function extend(s, left, right){
    var
     len = symbol(symbol(caml_ml_bytes_length(s), left), right),
     r = caml_create_bytes(len);
    if(0 <= left)
     var dstoff = left, srcoff = 0;
    else
     var dstoff = 0, srcoff = - left | 0;
    var
     cpylen =
       caml_call2
        (Stdlib_Int[10],
         caml_ml_bytes_length(s) - srcoff | 0,
         len - dstoff | 0);
    if(0 < cpylen) caml_blit_bytes(s, srcoff, r, dstoff, cpylen);
    return r;
   }
   function fill(s, ofs, len, c){
    if(0 <= ofs && 0 <= len && (caml_ml_bytes_length(s) - len | 0) >= ofs)
     return caml_fill_bytes(s, ofs, len, c);
    return caml_call1(Stdlib[1], cst_String_fill_Bytes_fill);
   }
   function blit(s1, ofs1, s2, ofs2, len){
    if
     (0 <= len
      &&
       0 <= ofs1
       &&
        (caml_ml_bytes_length(s1) - len | 0) >= ofs1
        && 0 <= ofs2 && (caml_ml_bytes_length(s2) - len | 0) >= ofs2)
     return caml_blit_bytes(s1, ofs1, s2, ofs2, len);
    return caml_call1(Stdlib[1], cst_Bytes_blit);
   }
   function blit_string(s1, ofs1, s2, ofs2, len){
    if
     (0 <= len
      &&
       0 <= ofs1
       &&
        (runtime.caml_ml_string_length(s1) - len | 0) >= ofs1
        && 0 <= ofs2 && (caml_ml_bytes_length(s2) - len | 0) >= ofs2)
     return runtime.caml_blit_string(s1, ofs1, s2, ofs2, len);
    return caml_call1(Stdlib[1], cst_String_blit_Bytes_blit_str);
   }
   function iter(f, a){
    var _al_ = caml_ml_bytes_length(a) - 1 | 0, _ak_ = 0;
    if(_al_ >= 0){
     var i = _ak_;
     for(;;){
      caml_call1(f, caml_bytes_unsafe_get(a, i));
      var _am_ = i + 1 | 0;
      if(_al_ === i) break;
      var i = _am_;
     }
    }
    return 0;
   }
   function iteri(f, a){
    var _ai_ = caml_ml_bytes_length(a) - 1 | 0, _ah_ = 0;
    if(_ai_ >= 0){
     var i = _ah_;
     for(;;){
      caml_call2(f, i, caml_bytes_unsafe_get(a, i));
      var _aj_ = i + 1 | 0;
      if(_ai_ === i) break;
      var i = _aj_;
     }
    }
    return 0;
   }
   function concat(sep, l){
    if(! l) return empty;
    var seplen = caml_ml_bytes_length(sep);
    a:
    {
     b:
     {
      var acc = 0, param = l, pos$1 = 0;
      for(;;){
       if(! param) break;
       var hd = param[1];
       if(! param[2]) break b;
       var
        tl = param[2],
        x = (caml_ml_bytes_length(hd) + seplen | 0) + acc | 0,
        acc$0 = acc <= x ? x : caml_call1(Stdlib[1], cst_Bytes_concat),
        acc = acc$0,
        param = tl;
      }
      var _ag_ = acc;
      break a;
     }
     var _ag_ = caml_ml_bytes_length(hd) + acc | 0;
    }
    var dst = caml_create_bytes(_ag_), pos = pos$1, param$0 = l;
    for(;;){
     if(! param$0) return dst;
     var hd$0 = param$0[1];
     if(! param$0[2]){
      caml_blit_bytes(hd$0, 0, dst, pos, caml_ml_bytes_length(hd$0));
      return dst;
     }
     var tl$0 = param$0[2];
     caml_blit_bytes(hd$0, 0, dst, pos, caml_ml_bytes_length(hd$0));
     caml_blit_bytes
      (sep, 0, dst, pos + caml_ml_bytes_length(hd$0) | 0, seplen);
     var
      pos$0 = (pos + caml_ml_bytes_length(hd$0) | 0) + seplen | 0,
      pos = pos$0,
      param$0 = tl$0;
    }
   }
   function cat(s1, s2){
    var
     l1 = caml_ml_bytes_length(s1),
     l2 = caml_ml_bytes_length(s2),
     r = caml_create_bytes(l1 + l2 | 0);
    caml_blit_bytes(s1, 0, r, 0, l1);
    caml_blit_bytes(s2, 0, r, l1, l2);
    return r;
   }
   function is_space(param){
    var _af_ = param - 9 | 0;
    a:
    {
     if(4 < _af_ >>> 0){if(23 !== _af_) break a;} else if(2 === _af_) break a;
     return 1;
    }
    return 0;
   }
   function trim(s){
    var len = caml_ml_bytes_length(s), i = [0, 0];
    for(;;){
     if(i[1] >= len) break;
     if(! is_space(caml_bytes_unsafe_get(s, i[1]))) break;
     i[1]++;
    }
    var j = [0, len - 1 | 0];
    for(;;){
     if(i[1] <= j[1] && is_space(caml_bytes_unsafe_get(s, j[1]))){j[1] += -1; continue;}
     return i[1] <= j[1] ? sub(s, i[1], (j[1] - i[1] | 0) + 1 | 0) : empty;
    }
   }
   function unsafe_escape(s){
    var n = [0, 0], ___ = caml_ml_bytes_length(s) - 1 | 0, _Z_ = 0;
    if(___ >= 0){
     var i$0 = _Z_;
     for(;;){
      var match = caml_bytes_unsafe_get(s, i$0);
      a:
      {
       b:
       {
        c:
        {
         if(32 <= match){
          var _ac_ = match - 34 | 0;
          if(58 < _ac_ >>> 0){
           if(93 <= _ac_) break c;
          }
          else if(56 < _ac_ - 1 >>> 0) break b;
          var _ad_ = 1;
          break a;
         }
         if(11 <= match){
          if(13 === match) break b;
         }
         else if(8 <= match) break b;
        }
        var _ad_ = 4;
        break a;
       }
       var _ad_ = 2;
      }
      n[1] = n[1] + _ad_ | 0;
      var _ae_ = i$0 + 1 | 0;
      if(___ === i$0) break;
      var i$0 = _ae_;
     }
    }
    if(n[1] === caml_ml_bytes_length(s)) return s;
    var s$0 = caml_create_bytes(n[1]);
    n[1] = 0;
    var _aa_ = caml_ml_bytes_length(s) - 1 | 0, _$_ = 0;
    if(_aa_ >= 0){
     var i = _$_;
     for(;;){
      var c = caml_bytes_unsafe_get(s, i);
      a:
      {
       b:
       {
        c:
        {
         if(35 <= c){
          if(92 !== c){if(127 <= c) break c; break b;}
         }
         else{
          if(32 > c){
           if(14 <= c) break c;
           switch(c){
             case 8:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 98);
              break a;
             case 9:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 116);
              break a;
             case 10:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 110);
              break a;
             case 13:
              caml_bytes_unsafe_set(s$0, n[1], 92);
              n[1]++;
              caml_bytes_unsafe_set(s$0, n[1], 114);
              break a;
             default: break c;
           }
          }
          if(34 > c) break b;
         }
         caml_bytes_unsafe_set(s$0, n[1], 92);
         n[1]++;
         caml_bytes_unsafe_set(s$0, n[1], c);
         break a;
        }
        caml_bytes_unsafe_set(s$0, n[1], 92);
        n[1]++;
        caml_bytes_unsafe_set(s$0, n[1], 48 + (c / 100 | 0) | 0);
        n[1]++;
        caml_bytes_unsafe_set(s$0, n[1], 48 + ((c / 10 | 0) % 10 | 0) | 0);
        n[1]++;
        caml_bytes_unsafe_set(s$0, n[1], 48 + (c % 10 | 0) | 0);
        break a;
       }
       caml_bytes_unsafe_set(s$0, n[1], c);
      }
      n[1]++;
      var _ab_ = i + 1 | 0;
      if(_aa_ === i) break;
      var i = _ab_;
     }
    }
    return s$0;
   }
   function escaped(b){var b$0 = copy(b); return unsafe_escape(b$0);}
   function map(f, s){
    var l = caml_ml_bytes_length(s);
    if(0 === l) return s;
    var r = caml_create_bytes(l), _X_ = l - 1 | 0, _W_ = 0;
    if(_X_ >= 0){
     var i = _W_;
     for(;;){
      caml_bytes_unsafe_set(r, i, caml_call1(f, caml_bytes_unsafe_get(s, i)));
      var _Y_ = i + 1 | 0;
      if(_X_ === i) break;
      var i = _Y_;
     }
    }
    return r;
   }
   function mapi(f, s){
    var l = caml_ml_bytes_length(s);
    if(0 === l) return s;
    var r = caml_create_bytes(l), _U_ = l - 1 | 0, _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
      caml_bytes_unsafe_set
       (r, i, caml_call2(f, i, caml_bytes_unsafe_get(s, i)));
      var _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
    return r;
   }
   function fold_left(f, x, a){
    var r = [0, x], _R_ = caml_ml_bytes_length(a) - 1 | 0, _Q_ = 0;
    if(_R_ >= 0){
     var i = _Q_;
     for(;;){
      r[1] = caml_call2(f, r[1], caml_bytes_unsafe_get(a, i));
      var _S_ = i + 1 | 0;
      if(_R_ === i) break;
      var i = _S_;
     }
    }
    return r[1];
   }
   function fold_right(f, a, x){
    var r = [0, x], _O_ = caml_ml_bytes_length(a) - 1 | 0;
    if(_O_ >= 0){
     var i = _O_;
     for(;;){
      r[1] = caml_call2(f, caml_bytes_unsafe_get(a, i), r[1]);
      var _P_ = i - 1 | 0;
      if(0 === i) break;
      var i = _P_;
     }
    }
    return r[1];
   }
   function exists(p, s){
    var n = caml_ml_bytes_length(s), i = 0;
    for(;;){
     if(i === n) return 0;
     if(caml_call1(p, caml_bytes_unsafe_get(s, i))) return 1;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function for_all(p, s){
    var n = caml_ml_bytes_length(s), i = 0;
    for(;;){
     if(i === n) return 1;
     if(! caml_call1(p, caml_bytes_unsafe_get(s, i))) return 0;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function uppercase_ascii(s){return map(Stdlib_Char[4], s);}
   function lowercase_ascii(s){return map(Stdlib_Char[3], s);}
   function apply1(f, s){
    if(0 === caml_ml_bytes_length(s)) return s;
    var r = copy(s);
    caml_bytes_unsafe_set(r, 0, caml_call1(f, caml_bytes_unsafe_get(s, 0)));
    return r;
   }
   function capitalize_ascii(s){return apply1(Stdlib_Char[4], s);}
   function uncapitalize_ascii(s){return apply1(Stdlib_Char[3], s);}
   function starts_with(prefix, s){
    var
     len_s = caml_ml_bytes_length(s),
     len_pre = caml_ml_bytes_length(prefix),
     _N_ = len_pre <= len_s ? 1 : 0;
    if(! _N_) return _N_;
    var i = 0;
    for(;;){
     if(i === len_pre) return 1;
     if(caml_bytes_unsafe_get(s, i) !== caml_bytes_unsafe_get(prefix, i))
      return 0;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function ends_with(suffix, s){
    var
     len_s = caml_ml_bytes_length(s),
     len_suf = caml_ml_bytes_length(suffix),
     diff = len_s - len_suf | 0,
     _M_ = 0 <= diff ? 1 : 0;
    if(! _M_) return _M_;
    var i = 0;
    for(;;){
     if(i === len_suf) return 1;
     if
      (caml_bytes_unsafe_get(s, diff + i | 0)
       !== caml_bytes_unsafe_get(suffix, i))
      return 0;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function index_rec(s, lim, i, c){
    var i$0 = i;
    for(;;){
     if(lim <= i$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     if(caml_bytes_unsafe_get(s, i$0) === c) return i$0;
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
   }
   function index(s, c){return index_rec(s, caml_ml_bytes_length(s), 0, c);}
   function index_rec_opt(s, lim, i, c){
    var i$0 = i;
    for(;;){
     if(lim <= i$0) return 0;
     if(caml_bytes_unsafe_get(s, i$0) === c) return [0, i$0];
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
   }
   function index_opt(s, c){
    return index_rec_opt(s, caml_ml_bytes_length(s), 0, c);
   }
   function index_from(s, i, c){
    var l = caml_ml_bytes_length(s);
    if(0 <= i && l >= i) return index_rec(s, l, i, c);
    return caml_call1(Stdlib[1], cst_String_index_from_Bytes_in);
   }
   function index_from_opt(s, i, c){
    var l = caml_ml_bytes_length(s);
    if(0 <= i && l >= i) return index_rec_opt(s, l, i, c);
    return caml_call1(Stdlib[1], cst_String_index_from_opt_Byte);
   }
   function rindex_rec(s, i, c){
    var i$0 = i;
    for(;;){
     if(0 > i$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     if(caml_bytes_unsafe_get(s, i$0) === c) return i$0;
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
   }
   function rindex(s, c){
    return rindex_rec(s, caml_ml_bytes_length(s) - 1 | 0, c);
   }
   function rindex_from(s, i, c){
    if(-1 <= i && caml_ml_bytes_length(s) > i) return rindex_rec(s, i, c);
    return caml_call1(Stdlib[1], cst_String_rindex_from_Bytes_r);
   }
   function rindex_rec_opt(s, i, c){
    var i$0 = i;
    for(;;){
     if(0 > i$0) return 0;
     if(caml_bytes_unsafe_get(s, i$0) === c) return [0, i$0];
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
   }
   function rindex_opt(s, c){
    return rindex_rec_opt(s, caml_ml_bytes_length(s) - 1 | 0, c);
   }
   function rindex_from_opt(s, i, c){
    if(-1 <= i && caml_ml_bytes_length(s) > i) return rindex_rec_opt(s, i, c);
    return caml_call1(Stdlib[1], cst_String_rindex_from_opt_Byt);
   }
   function contains_from(s, i, c){
    var l = caml_ml_bytes_length(s);
    if(0 <= i && l >= i)
     try{index_rec(s, l, i, c); var _K_ = 1; return _K_;}
     catch(_L_){
      var _J_ = caml_wrap_exception(_L_);
      if(_J_ === Stdlib[8]) return 0;
      throw caml_maybe_attach_backtrace(_J_, 0);
     }
    return caml_call1(Stdlib[1], cst_String_contains_from_Bytes);
   }
   function contains(s, c){return contains_from(s, 0, c);}
   function rcontains_from(s, i, c){
    if(0 <= i && caml_ml_bytes_length(s) > i)
     try{rindex_rec(s, i, c); var _H_ = 1; return _H_;}
     catch(_I_){
      var _G_ = caml_wrap_exception(_I_);
      if(_G_ === Stdlib[8]) return 0;
      throw caml_maybe_attach_backtrace(_G_, 0);
     }
    return caml_call1(Stdlib[1], cst_String_rcontains_from_Byte);
   }
   var
    compare = runtime.caml_bytes_compare,
    cst_Bytes_of_seq_cannot_grow_b = "Bytes.of_seq: cannot grow bytes";
   function split_on_char(sep, s){
    var
     r = [0, 0],
     j = [0, caml_ml_bytes_length(s)],
     _C_ = caml_ml_bytes_length(s) - 1 | 0;
    if(_C_ >= 0){
     var i = _C_;
     for(;;){
      if(caml_bytes_unsafe_get(s, i) === sep){
       var _E_ = r[1];
       r[1] = [0, sub(s, i + 1 | 0, (j[1] - i | 0) - 1 | 0), _E_];
       j[1] = i;
      }
      var _F_ = i - 1 | 0;
      if(0 === i) break;
      var i = _F_;
     }
    }
    var _D_ = r[1];
    return [0, sub(s, 0, j[1]), _D_];
   }
   function to_seq(s){
    function aux(i, param){
     if(i === caml_ml_bytes_length(s)) return 0;
     var x = caml_bytes_get(s, i), _A_ = i + 1 | 0;
     return [0, x, function(_B_){return aux(_A_, _B_);}];
    }
    var _y_ = 0;
    return function(_z_){return aux(_y_, _z_);};
   }
   function to_seqi(s){
    function aux(i, param){
     if(i === caml_ml_bytes_length(s)) return 0;
     var x = caml_bytes_get(s, i), _w_ = i + 1 | 0;
     return [0, [0, i, x], function(_x_){return aux(_w_, _x_);}];
    }
    var _u_ = 0;
    return function(_v_){return aux(_u_, _v_);};
   }
   function of_seq(i){
    var n = [0, 0], buf = [0, make(256, 0)];
    caml_call2
     (Stdlib_Seq[4],
      function(c){
       if(n[1] === caml_ml_bytes_length(buf[1])){
        var
         new_len =
           caml_call2
            (Stdlib_Int[10],
             2 * caml_ml_bytes_length(buf[1]) | 0,
             Stdlib_Sys[12]);
        if(caml_ml_bytes_length(buf[1]) === new_len)
         caml_call1(Stdlib[2], cst_Bytes_of_seq_cannot_grow_b);
        var new_buf = make(new_len, 0);
        blit(buf[1], 0, new_buf, 0, n[1]);
        buf[1] = new_buf;
       }
       caml_bytes_set(buf[1], n[1], c);
       n[1]++;
       return 0;
      },
      i);
    return sub(buf[1], 0, n[1]);
   }
   function unsafe_get_uint16_le(b, i){
    return Stdlib_Sys[11]
            ? caml_bswap16(caml_bytes_get16(b, i))
            : caml_bytes_get16(b, i);
   }
   function unsafe_get_uint16_be(b, i){
    return Stdlib_Sys[11]
            ? caml_bytes_get16(b, i)
            : caml_bswap16(caml_bytes_get16(b, i));
   }
   function get_int8(b, i){
    var _s_ = Stdlib_Sys[10] - 8 | 0, _t_ = Stdlib_Sys[10] - 8 | 0;
    return caml_bytes_get(b, i) << _t_ >> _s_;
   }
   function get_uint16_le(b, i){
    return Stdlib_Sys[11]
            ? caml_bswap16(caml_bytes_get16(b, i))
            : caml_bytes_get16(b, i);
   }
   function get_uint16_be(b, i){
    return Stdlib_Sys[11]
            ? caml_bytes_get16(b, i)
            : caml_bswap16(caml_bytes_get16(b, i));
   }
   function get_int16_ne(b, i){
    var _q_ = Stdlib_Sys[10] - 16 | 0, _r_ = Stdlib_Sys[10] - 16 | 0;
    return caml_bytes_get16(b, i) << _r_ >> _q_;
   }
   function get_int16_le(b, i){
    var _o_ = Stdlib_Sys[10] - 16 | 0, _p_ = Stdlib_Sys[10] - 16 | 0;
    return get_uint16_le(b, i) << _p_ >> _o_;
   }
   function get_int16_be(b, i){
    var _m_ = Stdlib_Sys[10] - 16 | 0, _n_ = Stdlib_Sys[10] - 16 | 0;
    return get_uint16_be(b, i) << _n_ >> _m_;
   }
   function get_int32_le(b, i){
    return Stdlib_Sys[11]
            ? caml_int32_bswap(caml_bytes_get32(b, i))
            : caml_bytes_get32(b, i);
   }
   function get_int32_be(b, i){
    return Stdlib_Sys[11]
            ? caml_bytes_get32(b, i)
            : caml_int32_bswap(caml_bytes_get32(b, i));
   }
   function get_int64_le(b, i){
    return Stdlib_Sys[11]
            ? caml_int64_bswap(caml_bytes_get64(b, i))
            : caml_bytes_get64(b, i);
   }
   function get_int64_be(b, i){
    return Stdlib_Sys[11]
            ? caml_bytes_get64(b, i)
            : caml_int64_bswap(caml_bytes_get64(b, i));
   }
   function unsafe_set_uint16_le(b, i, x){
    if(Stdlib_Sys[11]){caml_bytes_set16(b, i, caml_bswap16(x)); return;}
    caml_bytes_set16(b, i, x);
    return;
   }
   function unsafe_set_uint16_be(b, i, x){
    if(Stdlib_Sys[11]){caml_bytes_set16(b, i, x); return;}
    caml_bytes_set16(b, i, caml_bswap16(x));
    return;
   }
   function set_int16_le(b, i, x){
    return Stdlib_Sys[11]
            ? caml_bytes_set16(b, i, caml_bswap16(x))
            : caml_bytes_set16(b, i, x);
   }
   function set_int16_be(b, i, x){
    return Stdlib_Sys[11]
            ? caml_bytes_set16(b, i, x)
            : caml_bytes_set16(b, i, caml_bswap16(x));
   }
   function set_int32_le(b, i, x){
    return Stdlib_Sys[11]
            ? caml_bytes_set32(b, i, caml_int32_bswap(x))
            : caml_bytes_set32(b, i, x);
   }
   function set_int32_be(b, i, x){
    return Stdlib_Sys[11]
            ? caml_bytes_set32(b, i, x)
            : caml_bytes_set32(b, i, caml_int32_bswap(x));
   }
   function set_int64_le(b, i, x){
    return Stdlib_Sys[11]
            ? caml_bytes_set64(b, i, caml_int64_bswap(x))
            : caml_bytes_set64(b, i, x);
   }
   function set_int64_be(b, i, x){
    return Stdlib_Sys[11]
            ? caml_bytes_set64(b, i, x)
            : caml_bytes_set64(b, i, caml_int64_bswap(x));
   }
   var
    set_uint8 = caml_bytes_set,
    set_uint16_ne = caml_bytes_set16,
    dec_invalid = Stdlib_Uchar[22],
    _a_ = [0, cst_bytes_ml, 679, 9],
    _b_ = [0, cst_bytes_ml, 654, 20],
    cst_index_out_of_bounds = cst_index_out_of_bounds$3,
    cst_index_out_of_bounds$0 = cst_index_out_of_bounds$3,
    _c_ = [0, cst_bytes_ml, 777, 9],
    _d_ = [0, cst_bytes_ml, 766, 20],
    cst_index_out_of_bounds$1 = cst_index_out_of_bounds$3,
    cst_index_out_of_bounds$2 = cst_index_out_of_bounds$3,
    _e_ = [0, cst_bytes_ml, 831, 9],
    _f_ = [0, cst_bytes_ml, 820, 20];
   function dec_ret(n, u){
    var _l_ = caml_call1(Stdlib_Uchar[9], u);
    return caml_call2(Stdlib_Uchar[21], n, _l_);
   }
   function not_in_x80_to_xBF(b){return 2 !== (b >>> 6 | 0) ? 1 : 0;}
   function not_in_xA0_to_xBF(b){return 5 !== (b >>> 5 | 0) ? 1 : 0;}
   function not_in_x80_to_x9F(b){return 4 !== (b >>> 5 | 0) ? 1 : 0;}
   function not_in_x90_to_xBF(b){
    var _j_ = b < 144 ? 1 : 0, _k_ = _j_ || (191 < b ? 1 : 0);
    return _k_;
   }
   function not_in_x80_to_x8F(b){return 8 !== (b >>> 4 | 0) ? 1 : 0;}
   function utf_8_uchar_3(b0, b1, b2){
    return (b0 & 15) << 12 | (b1 & 63) << 6 | b2 & 63;
   }
   function utf_8_uchar_4(b0, b1, b2, b3){
    return (b0 & 7) << 18 | (b1 & 63) << 12 | (b2 & 63) << 6 | b3 & 63;
   }
   function get_utf_8_uchar(b, i){
    var b0 = caml_bytes_get(b, i), max = caml_ml_bytes_length(b) - 1 | 0;
    a:
    {
     if(224 <= b0){
      if(237 <= b0){
       if(245 <= b0) break a;
       switch(b0 - 237 | 0){
         case 0:
          var i$0 = i + 1 | 0;
          if(max < i$0) return caml_call1(dec_invalid, 1);
          var b1 = caml_bytes_unsafe_get(b, i$0);
          if(not_in_x80_to_x9F(b1)) return caml_call1(dec_invalid, 1);
          var i$1 = i$0 + 1 | 0;
          if(max < i$1) return caml_call1(dec_invalid, 2);
          var b2 = caml_bytes_unsafe_get(b, i$1);
          return not_in_x80_to_xBF(b2)
                  ? caml_call1(dec_invalid, 2)
                  : dec_ret(3, utf_8_uchar_3(b0, b1, b2));
         case 3:
          var i$4 = i + 1 | 0;
          if(max < i$4) return caml_call1(dec_invalid, 1);
          var b1$1 = caml_bytes_unsafe_get(b, i$4);
          if(not_in_x90_to_xBF(b1$1)) return caml_call1(dec_invalid, 1);
          var i$5 = i$4 + 1 | 0;
          if(max < i$5) return caml_call1(dec_invalid, 2);
          var b2$1 = caml_bytes_unsafe_get(b, i$5);
          if(not_in_x80_to_xBF(b2$1)) return caml_call1(dec_invalid, 2);
          var i$6 = i$5 + 1 | 0;
          if(max < i$6) return caml_call1(dec_invalid, 3);
          var b3 = caml_bytes_unsafe_get(b, i$6);
          return not_in_x80_to_xBF(b3)
                  ? caml_call1(dec_invalid, 3)
                  : dec_ret(4, utf_8_uchar_4(b0, b1$1, b2$1, b3));
         case 7:
          var i$10 = i + 1 | 0;
          if(max < i$10) return caml_call1(dec_invalid, 1);
          var b1$3 = caml_bytes_unsafe_get(b, i$10);
          if(not_in_x80_to_x8F(b1$3)) return caml_call1(dec_invalid, 1);
          var i$11 = i$10 + 1 | 0;
          if(max < i$11) return caml_call1(dec_invalid, 2);
          var b2$3 = caml_bytes_unsafe_get(b, i$11);
          if(not_in_x80_to_xBF(b2$3)) return caml_call1(dec_invalid, 2);
          var i$12 = i$11 + 1 | 0;
          if(max < i$12) return caml_call1(dec_invalid, 3);
          var b3$1 = caml_bytes_unsafe_get(b, i$12);
          return not_in_x80_to_xBF(b3$1)
                  ? caml_call1(dec_invalid, 3)
                  : dec_ret(4, utf_8_uchar_4(b0, b1$3, b2$3, b3$1));
         case 1:
         case 2: break;
         default:
          var i$7 = i + 1 | 0;
          if(max < i$7) return caml_call1(dec_invalid, 1);
          var b1$2 = caml_bytes_unsafe_get(b, i$7);
          if(not_in_x80_to_xBF(b1$2)) return caml_call1(dec_invalid, 1);
          var i$8 = i$7 + 1 | 0;
          if(max < i$8) return caml_call1(dec_invalid, 2);
          var b2$2 = caml_bytes_unsafe_get(b, i$8);
          if(not_in_x80_to_xBF(b2$2)) return caml_call1(dec_invalid, 2);
          var i$9 = i$8 + 1 | 0;
          if(max < i$9) return caml_call1(dec_invalid, 3);
          var b3$0 = caml_bytes_unsafe_get(b, i$9);
          return not_in_x80_to_xBF(b3$0)
                  ? caml_call1(dec_invalid, 3)
                  : dec_ret(4, utf_8_uchar_4(b0, b1$2, b2$2, b3$0));
       }
      }
      else if(225 > b0){
       var i$13 = i + 1 | 0;
       if(max < i$13) return caml_call1(dec_invalid, 1);
       var b1$4 = caml_bytes_unsafe_get(b, i$13);
       if(not_in_xA0_to_xBF(b1$4)) return caml_call1(dec_invalid, 1);
       var i$14 = i$13 + 1 | 0;
       if(max < i$14) return caml_call1(dec_invalid, 2);
       var b2$4 = caml_bytes_unsafe_get(b, i$14);
       return not_in_x80_to_xBF(b2$4)
               ? caml_call1(dec_invalid, 2)
               : dec_ret(3, utf_8_uchar_3(b0, b1$4, b2$4));
      }
      var i$2 = i + 1 | 0;
      if(max < i$2) return caml_call1(dec_invalid, 1);
      var b1$0 = caml_bytes_unsafe_get(b, i$2);
      if(not_in_x80_to_xBF(b1$0)) return caml_call1(dec_invalid, 1);
      var i$3 = i$2 + 1 | 0;
      if(max < i$3) return caml_call1(dec_invalid, 2);
      var b2$0 = caml_bytes_unsafe_get(b, i$3);
      return not_in_x80_to_xBF(b2$0)
              ? caml_call1(dec_invalid, 2)
              : dec_ret(3, utf_8_uchar_3(b0, b1$0, b2$0));
     }
     if(128 > b0) return dec_ret(1, b0);
     if(194 <= b0){
      var i$15 = i + 1 | 0;
      if(max < i$15) return caml_call1(dec_invalid, 1);
      var b1$5 = caml_bytes_unsafe_get(b, i$15);
      return not_in_x80_to_xBF(b1$5)
              ? caml_call1(dec_invalid, 1)
              : dec_ret(2, (b0 & 31) << 6 | b1$5 & 63);
     }
    }
    return caml_call1(dec_invalid, 1);
   }
   function set_utf_8_uchar(b, i, u){
    function set(_i_, _h_, _g_){caml_bytes_unsafe_set(_i_, _h_, _g_); return;}
    var
     max = caml_ml_bytes_length(b) - 1 | 0,
     u$0 = caml_call1(Stdlib_Uchar[10], u);
    if(0 > u$0)
     throw caml_maybe_attach_backtrace([0, Assert_failure, _b_], 1);
    if(127 >= u$0){caml_bytes_set(b, i, u$0); return 1;}
    if(2047 >= u$0){
     var last$1 = i + 1 | 0;
     return max < last$1
             ? 0
             : (caml_bytes_set
                (b, i, 192 | u$0 >>> 6 | 0),
               set(b, last$1, 128 | u$0 & 63),
               2);
    }
    if(65535 >= u$0){
     var last$0 = i + 2 | 0;
     return max < last$0
             ? 0
             : (caml_bytes_set
                (b, i, 224 | u$0 >>> 12 | 0),
               set(b, i + 1 | 0, 128 | (u$0 >>> 6 | 0) & 63),
               set(b, last$0, 128 | u$0 & 63),
               3);
    }
    if(1114111 < u$0)
     throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
    var last = i + 3 | 0;
    return max < last
            ? 0
            : (caml_bytes_set
               (b, i, 240 | u$0 >>> 18 | 0),
              set(b, i + 1 | 0, 128 | (u$0 >>> 12 | 0) & 63),
              set(b, i + 2 | 0, 128 | (u$0 >>> 6 | 0) & 63),
              set(b, last, 128 | u$0 & 63),
              4);
   }
   function is_valid_utf_8(b){
    var max = caml_ml_bytes_length(b) - 1 | 0, i = 0;
    for(;;){
     if(max < i) return 1;
     var match = caml_bytes_unsafe_get(b, i);
     a:
     {
      if(224 <= match){
       if(237 <= match){
        if(245 <= match) break a;
        switch(match - 237 | 0){
          case 0:
           var last = i + 2 | 0;
           if
            (max >= last
             &&
              !
              not_in_x80_to_x9F(caml_bytes_unsafe_get(b, i + 1 | 0))
              && ! not_in_x80_to_xBF(caml_bytes_unsafe_get(b, last))){var i$0 = last + 1 | 0, i = i$0; continue;}
           return 0;
          case 3:
           var last$1 = i + 3 | 0;
           if
            (max >= last$1
             &&
              !
              not_in_x90_to_xBF(caml_bytes_unsafe_get(b, i + 1 | 0))
              &&
               !
               not_in_x80_to_xBF(caml_bytes_unsafe_get(b, i + 2 | 0))
               && ! not_in_x80_to_xBF(caml_bytes_unsafe_get(b, last$1))){var i$2 = last$1 + 1 | 0, i = i$2; continue;}
           return 0;
          case 7:
           var last$3 = i + 3 | 0;
           if
            (max >= last$3
             &&
              !
              not_in_x80_to_x8F(caml_bytes_unsafe_get(b, i + 1 | 0))
              &&
               !
               not_in_x80_to_xBF(caml_bytes_unsafe_get(b, i + 2 | 0))
               && ! not_in_x80_to_xBF(caml_bytes_unsafe_get(b, last$3))){var i$4 = last$3 + 1 | 0, i = i$4; continue;}
           return 0;
          case 1:
          case 2: break;
          default:
           var last$2 = i + 3 | 0;
           if
            (max >= last$2
             &&
              !
              not_in_x80_to_xBF(caml_bytes_unsafe_get(b, i + 1 | 0))
              &&
               !
               not_in_x80_to_xBF(caml_bytes_unsafe_get(b, i + 2 | 0))
               && ! not_in_x80_to_xBF(caml_bytes_unsafe_get(b, last$2))){var i$3 = last$2 + 1 | 0, i = i$3; continue;}
           return 0;
        }
       }
       else if(225 > match){
        var last$4 = i + 2 | 0;
        if
         (max >= last$4
          &&
           !
           not_in_xA0_to_xBF(caml_bytes_unsafe_get(b, i + 1 | 0))
           && ! not_in_x80_to_xBF(caml_bytes_unsafe_get(b, last$4))){var i$5 = last$4 + 1 | 0, i = i$5; continue;}
        return 0;
       }
       var last$0 = i + 2 | 0;
       if
        (max >= last$0
         &&
          !
          not_in_x80_to_xBF(caml_bytes_unsafe_get(b, i + 1 | 0))
          && ! not_in_x80_to_xBF(caml_bytes_unsafe_get(b, last$0))){var i$1 = last$0 + 1 | 0, i = i$1; continue;}
       return 0;
      }
      if(128 > match){var i$7 = i + 1 | 0, i = i$7; continue;}
      if(194 <= match){
       var last$5 = i + 1 | 0;
       if
        (max >= last$5
         && ! not_in_x80_to_xBF(caml_bytes_unsafe_get(b, last$5))){var i$6 = last$5 + 1 | 0, i = i$6; continue;}
       return 0;
      }
     }
     return 0;
    }
   }
   function get_utf_16be_uchar(b, i){
    var max = caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
     if(i === max) return caml_call1(dec_invalid, 1);
     var hi = unsafe_get_uint16_be(b, i);
     if(55296 <= hi && 57343 >= hi){
      if(56319 < hi) return caml_call1(dec_invalid, 2);
      var last = i + 3 | 0;
      if(max < last) return caml_call1(dec_invalid, (max - i | 0) + 1 | 0);
      var lo = unsafe_get_uint16_be(b, i + 2 | 0);
      if(56320 <= lo && 57343 >= lo){
       var u = ((hi & 1023) << 10 | lo & 1023) + 65536 | 0;
       return dec_ret(4, u);
      }
      return caml_call1(dec_invalid, 2);
     }
     return dec_ret(2, hi);
    }
    return caml_call1(Stdlib[1], cst_index_out_of_bounds);
   }
   function set_utf_16be_uchar(b, i, u){
    var max = caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
     var u$0 = caml_call1(Stdlib_Uchar[10], u);
     if(0 > u$0)
      throw caml_maybe_attach_backtrace([0, Assert_failure, _d_], 1);
     if(65535 >= u$0){
      var last$0 = i + 1 | 0;
      return max < last$0 ? 0 : (unsafe_set_uint16_be(b, i, u$0), 2);
     }
     if(1114111 < u$0)
      throw caml_maybe_attach_backtrace([0, Assert_failure, _c_], 1);
     var last = i + 3 | 0;
     if(max < last) return 0;
     var
      u$1 = u$0 - 65536 | 0,
      hi = 55296 | u$1 >>> 10 | 0,
      lo = 56320 | u$1 & 1023;
     unsafe_set_uint16_be(b, i, hi);
     unsafe_set_uint16_be(b, i + 2 | 0, lo);
     return 4;
    }
    return caml_call1(Stdlib[1], cst_index_out_of_bounds$0);
   }
   function is_valid_utf_16be(b){
    var max = caml_ml_bytes_length(b) - 1 | 0, i = 0;
    for(;;){
     if(max < i) return 1;
     if(i === max) return 0;
     var u = unsafe_get_uint16_be(b, i);
     if(55296 <= u && 57343 >= u){
      if(56319 < u) return 0;
      var last = i + 3 | 0;
      if(max < last) return 0;
      var u$0 = unsafe_get_uint16_be(b, i + 2 | 0);
      if(56320 <= u$0 && 57343 >= u$0){
       var i$1 = i + 4 | 0, i = i$1;
       continue;
      }
      return 0;
     }
     var i$0 = i + 2 | 0, i = i$0;
    }
   }
   function get_utf_16le_uchar(b, i){
    var max = caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
     if(i === max) return caml_call1(dec_invalid, 1);
     var hi = unsafe_get_uint16_le(b, i);
     if(55296 <= hi && 57343 >= hi){
      if(56319 < hi) return caml_call1(dec_invalid, 2);
      var last = i + 3 | 0;
      if(max < last) return caml_call1(dec_invalid, (max - i | 0) + 1 | 0);
      var lo = unsafe_get_uint16_le(b, i + 2 | 0);
      if(56320 <= lo && 57343 >= lo){
       var u = ((hi & 1023) << 10 | lo & 1023) + 65536 | 0;
       return dec_ret(4, u);
      }
      return caml_call1(dec_invalid, 2);
     }
     return dec_ret(2, hi);
    }
    return caml_call1(Stdlib[1], cst_index_out_of_bounds$1);
   }
   function set_utf_16le_uchar(b, i, u){
    var max = caml_ml_bytes_length(b) - 1 | 0;
    if(0 <= i && max >= i){
     var u$0 = caml_call1(Stdlib_Uchar[10], u);
     if(0 > u$0)
      throw caml_maybe_attach_backtrace([0, Assert_failure, _f_], 1);
     if(65535 >= u$0){
      var last$0 = i + 1 | 0;
      return max < last$0 ? 0 : (unsafe_set_uint16_le(b, i, u$0), 2);
     }
     if(1114111 < u$0)
      throw caml_maybe_attach_backtrace([0, Assert_failure, _e_], 1);
     var last = i + 3 | 0;
     if(max < last) return 0;
     var
      u$1 = u$0 - 65536 | 0,
      hi = 55296 | u$1 >>> 10 | 0,
      lo = 56320 | u$1 & 1023;
     unsafe_set_uint16_le(b, i, hi);
     unsafe_set_uint16_le(b, i + 2 | 0, lo);
     return 4;
    }
    return caml_call1(Stdlib[1], cst_index_out_of_bounds$2);
   }
   function is_valid_utf_16le(b){
    var max = caml_ml_bytes_length(b) - 1 | 0, i = 0;
    for(;;){
     if(max < i) return 1;
     if(i === max) return 0;
     var u = unsafe_get_uint16_le(b, i);
     if(55296 <= u && 57343 >= u){
      if(56319 < u) return 0;
      var last = i + 3 | 0;
      if(max < last) return 0;
      var u$0 = unsafe_get_uint16_le(b, i + 2 | 0);
      if(56320 <= u$0 && 57343 >= u$0){
       var i$1 = i + 4 | 0, i = i$1;
       continue;
      }
      return 0;
     }
     var i$0 = i + 2 | 0, i = i$0;
    }
   }
   var
    Stdlib_Bytes =
      [0,
       make,
       init,
       empty,
       copy,
       of_string,
       to_string,
       sub,
       sub_string,
       extend,
       fill,
       blit,
       blit_string,
       concat,
       cat,
       iter,
       iteri,
       map,
       mapi,
       fold_left,
       fold_right,
       for_all,
       exists,
       trim,
       escaped,
       index,
       index_opt,
       rindex,
       rindex_opt,
       index_from,
       index_from_opt,
       rindex_from,
       rindex_from_opt,
       contains,
       contains_from,
       rcontains_from,
       uppercase_ascii,
       lowercase_ascii,
       capitalize_ascii,
       uncapitalize_ascii,
       compare,
       runtime.caml_bytes_equal,
       starts_with,
       ends_with,
       caml_string_of_bytes,
       caml_bytes_of_string,
       split_on_char,
       to_seq,
       to_seqi,
       of_seq,
       get_utf_8_uchar,
       set_utf_8_uchar,
       is_valid_utf_8,
       get_utf_16be_uchar,
       set_utf_16be_uchar,
       is_valid_utf_16be,
       get_utf_16le_uchar,
       set_utf_16le_uchar,
       is_valid_utf_16le,
       caml_bytes_get,
       get_int8,
       caml_bytes_get16,
       get_uint16_be,
       get_uint16_le,
       get_int16_ne,
       get_int16_be,
       get_int16_le,
       caml_bytes_get32,
       get_int32_be,
       get_int32_le,
       caml_bytes_get64,
       get_int64_be,
       get_int64_le,
       set_uint8,
       caml_bytes_set,
       set_uint16_ne,
       set_int16_be,
       set_int16_le,
       caml_bytes_set16,
       set_int16_be,
       set_int16_le,
       caml_bytes_set32,
       set_int32_be,
       set_int32_le,
       caml_bytes_set64,
       set_int64_be,
       set_int64_le,
       unsafe_escape];
   runtime.caml_register_global(30, Stdlib_Bytes, "Stdlib__Bytes");
   return;
  }
  (globalThis));

//# 5002 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$0 = "",
    caml_blit_string = runtime.caml_blit_string,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_equal = runtime.caml_string_equal,
    caml_string_hash = runtime.caml_string_hash,
    caml_string_unsafe_get = runtime.caml_string_unsafe_get,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst = cst$0,
    empty = cst$0,
    Stdlib = global_data.Stdlib,
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    bts = Stdlib_Bytes[44],
    bos = Stdlib_Bytes[45];
   function make(n, c){
    return caml_call1(bts, caml_call2(Stdlib_Bytes[1], n, c));
   }
   function init(n, f){
    return caml_call1(bts, caml_call2(Stdlib_Bytes[2], n, f));
   }
   var of_bytes = Stdlib_Bytes[6], to_bytes = Stdlib_Bytes[5];
   function sub(s, ofs, len){
    var _X_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call3(Stdlib_Bytes[7], _X_, ofs, len));
   }
   var blit = Stdlib_Bytes[12], cst_String_concat = "String.concat";
   function concat(sep, l){
    if(! l) return cst;
    var seplen = caml_ml_string_length(sep);
    a:
    {
     b:
     {
      var acc = 0, param = l, pos$1 = 0;
      for(;;){
       if(! param) break;
       var hd = param[1];
       if(! param[2]) break b;
       var
        tl = param[2],
        x = (caml_ml_string_length(hd) + seplen | 0) + acc | 0,
        acc$0 = acc <= x ? x : caml_call1(Stdlib[1], cst_String_concat),
        acc = acc$0,
        param = tl;
      }
      var _W_ = acc;
      break a;
     }
     var _W_ = caml_ml_string_length(hd) + acc | 0;
    }
    var dst = runtime.caml_create_bytes(_W_), pos = pos$1, param$0 = l;
    for(;;){
     if(param$0){
      var hd$0 = param$0[1];
      if(param$0[2]){
       var tl$0 = param$0[2];
       caml_blit_string(hd$0, 0, dst, pos, caml_ml_string_length(hd$0));
       caml_blit_string
        (sep, 0, dst, pos + caml_ml_string_length(hd$0) | 0, seplen);
       var
        pos$0 = (pos + caml_ml_string_length(hd$0) | 0) + seplen | 0,
        pos = pos$0,
        param$0 = tl$0;
       continue;
      }
      caml_blit_string(hd$0, 0, dst, pos, caml_ml_string_length(hd$0));
     }
     return caml_call1(bts, dst);
    }
   }
   var
    cat = Stdlib[28],
    cst_String_index_from_Bytes_in = "String.index_from / Bytes.index_from",
    cst_String_index_from_opt_Byte =
      "String.index_from_opt / Bytes.index_from_opt",
    cst_String_rindex_from_Bytes_r = "String.rindex_from / Bytes.rindex_from",
    cst_String_rindex_from_opt_Byt =
      "String.rindex_from_opt / Bytes.rindex_from_opt",
    cst_String_contains_from_Bytes =
      "String.contains_from / Bytes.contains_from",
    cst_String_rcontains_from_Byte =
      "String.rcontains_from / Bytes.rcontains_from";
   function iter(f, s){
    var _U_ = caml_ml_string_length(s) - 1 | 0, _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
      caml_call1(f, caml_string_unsafe_get(s, i));
      var _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
    return 0;
   }
   function iteri(f, s){
    var _R_ = caml_ml_string_length(s) - 1 | 0, _Q_ = 0;
    if(_R_ >= 0){
     var i = _Q_;
     for(;;){
      caml_call2(f, i, caml_string_unsafe_get(s, i));
      var _S_ = i + 1 | 0;
      if(_R_ === i) break;
      var i = _S_;
     }
    }
    return 0;
   }
   function map(f, s){
    var _P_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call2(Stdlib_Bytes[17], f, _P_));
   }
   function mapi(f, s){
    var _O_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call2(Stdlib_Bytes[18], f, _O_));
   }
   function fold_right(f, x, a){
    var _N_ = caml_call1(bos, x);
    return caml_call3(Stdlib_Bytes[20], f, _N_, a);
   }
   function fold_left(f, a, x){
    var _M_ = caml_call1(bos, x);
    return caml_call3(Stdlib_Bytes[19], f, a, _M_);
   }
   function exists(f, s){
    var _L_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[22], f, _L_);
   }
   function for_all(f, s){
    var _K_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[21], f, _K_);
   }
   function is_space(param){
    var _J_ = param - 9 | 0;
    a:
    {
     if(4 < _J_ >>> 0){if(23 !== _J_) break a;} else if(2 === _J_) break a;
     return 1;
    }
    return 0;
   }
   function trim(s){
    if(caml_string_equal(s, cst$0)) return s;
    if
     (!
      is_space(caml_string_unsafe_get(s, 0))
      &&
       !
       is_space(caml_string_unsafe_get(s, caml_ml_string_length(s) - 1 | 0)))
     return s;
    var _I_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call1(Stdlib_Bytes[23], _I_));
   }
   function escaped(s){
    var b = caml_call1(bos, s);
    return caml_call1(bts, caml_call1(Stdlib_Bytes[87], b));
   }
   function index_rec(s, lim, i, c){
    var i$0 = i;
    for(;;){
     if(lim <= i$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     if(caml_string_unsafe_get(s, i$0) === c) return i$0;
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
   }
   function index(s, c){return index_rec(s, caml_ml_string_length(s), 0, c);}
   function index_rec_opt(s, lim, i, c){
    var i$0 = i;
    for(;;){
     if(lim <= i$0) return 0;
     if(caml_string_unsafe_get(s, i$0) === c) return [0, i$0];
     var i$1 = i$0 + 1 | 0, i$0 = i$1;
    }
   }
   function index_opt(s, c){
    return index_rec_opt(s, caml_ml_string_length(s), 0, c);
   }
   function index_from(s, i, c){
    var l = caml_ml_string_length(s);
    if(0 <= i && l >= i) return index_rec(s, l, i, c);
    return caml_call1(Stdlib[1], cst_String_index_from_Bytes_in);
   }
   function index_from_opt(s, i, c){
    var l = caml_ml_string_length(s);
    if(0 <= i && l >= i) return index_rec_opt(s, l, i, c);
    return caml_call1(Stdlib[1], cst_String_index_from_opt_Byte);
   }
   function rindex_rec(s, i, c){
    var i$0 = i;
    for(;;){
     if(0 > i$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     if(caml_string_unsafe_get(s, i$0) === c) return i$0;
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
   }
   function rindex(s, c){
    return rindex_rec(s, caml_ml_string_length(s) - 1 | 0, c);
   }
   function rindex_from(s, i, c){
    if(-1 <= i && caml_ml_string_length(s) > i) return rindex_rec(s, i, c);
    return caml_call1(Stdlib[1], cst_String_rindex_from_Bytes_r);
   }
   function rindex_rec_opt(s, i, c){
    var i$0 = i;
    for(;;){
     if(0 > i$0) return 0;
     if(caml_string_unsafe_get(s, i$0) === c) return [0, i$0];
     var i$1 = i$0 - 1 | 0, i$0 = i$1;
    }
   }
   function rindex_opt(s, c){
    return rindex_rec_opt(s, caml_ml_string_length(s) - 1 | 0, c);
   }
   function rindex_from_opt(s, i, c){
    if(-1 <= i && caml_ml_string_length(s) > i)
     return rindex_rec_opt(s, i, c);
    return caml_call1(Stdlib[1], cst_String_rindex_from_opt_Byt);
   }
   function contains_from(s, i, c){
    var l = caml_ml_string_length(s);
    if(0 <= i && l >= i)
     try{index_rec(s, l, i, c); var _G_ = 1; return _G_;}
     catch(_H_){
      var _F_ = caml_wrap_exception(_H_);
      if(_F_ === Stdlib[8]) return 0;
      throw caml_maybe_attach_backtrace(_F_, 0);
     }
    return caml_call1(Stdlib[1], cst_String_contains_from_Bytes);
   }
   function contains(s, c){return contains_from(s, 0, c);}
   function rcontains_from(s, i, c){
    if(0 <= i && caml_ml_string_length(s) > i)
     try{rindex_rec(s, i, c); var _D_ = 1; return _D_;}
     catch(_E_){
      var _C_ = caml_wrap_exception(_E_);
      if(_C_ === Stdlib[8]) return 0;
      throw caml_maybe_attach_backtrace(_C_, 0);
     }
    return caml_call1(Stdlib[1], cst_String_rcontains_from_Byte);
   }
   function uppercase_ascii(s){
    var _B_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call1(Stdlib_Bytes[36], _B_));
   }
   function lowercase_ascii(s){
    var _A_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call1(Stdlib_Bytes[37], _A_));
   }
   function capitalize_ascii(s){
    var _z_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call1(Stdlib_Bytes[38], _z_));
   }
   function uncapitalize_ascii(s){
    var _y_ = caml_call1(bos, s);
    return caml_call1(bts, caml_call1(Stdlib_Bytes[39], _y_));
   }
   function starts_with(prefix, s){
    var
     len_s = caml_ml_string_length(s),
     len_pre = caml_ml_string_length(prefix),
     _x_ = len_pre <= len_s ? 1 : 0;
    if(! _x_) return _x_;
    var i = 0;
    for(;;){
     if(i === len_pre) return 1;
     if(caml_string_unsafe_get(s, i) !== caml_string_unsafe_get(prefix, i))
      return 0;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function ends_with(suffix, s){
    var
     len_s = caml_ml_string_length(s),
     len_suf = caml_ml_string_length(suffix),
     diff = len_s - len_suf | 0,
     _w_ = 0 <= diff ? 1 : 0;
    if(! _w_) return _w_;
    var i = 0;
    for(;;){
     if(i === len_suf) return 1;
     if
      (caml_string_unsafe_get(s, diff + i | 0)
       !== caml_string_unsafe_get(suffix, i))
      return 0;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function hash(x){return caml_string_hash(0, x);}
   function split_on_char(sep, s){
    var
     r = [0, 0],
     j = [0, caml_ml_string_length(s)],
     _s_ = caml_ml_string_length(s) - 1 | 0;
    if(_s_ >= 0){
     var i = _s_;
     for(;;){
      if(caml_string_unsafe_get(s, i) === sep){
       var _u_ = r[1];
       r[1] = [0, sub(s, i + 1 | 0, (j[1] - i | 0) - 1 | 0), _u_];
       j[1] = i;
      }
      var _v_ = i - 1 | 0;
      if(0 === i) break;
      var i = _v_;
     }
    }
    var _t_ = r[1];
    return [0, sub(s, 0, j[1]), _t_];
   }
   var compare = runtime.caml_string_compare;
   function to_seq(s){
    var _r_ = caml_call1(bos, s);
    return caml_call1(Stdlib_Bytes[47], _r_);
   }
   function to_seqi(s){
    var _q_ = caml_call1(bos, s);
    return caml_call1(Stdlib_Bytes[48], _q_);
   }
   function of_seq(g){
    return caml_call1(bts, caml_call1(Stdlib_Bytes[49], g));
   }
   function get_utf_8_uchar(s, i){
    var _p_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[50], _p_, i);
   }
   function is_valid_utf_8(s){
    var _o_ = caml_call1(bos, s);
    return caml_call1(Stdlib_Bytes[52], _o_);
   }
   function get_utf_16be_uchar(s, i){
    var _n_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[53], _n_, i);
   }
   function is_valid_utf_16be(s){
    var _m_ = caml_call1(bos, s);
    return caml_call1(Stdlib_Bytes[55], _m_);
   }
   function get_utf_16le_uchar(s, i){
    var _l_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[56], _l_, i);
   }
   function is_valid_utf_16le(s){
    var _k_ = caml_call1(bos, s);
    return caml_call1(Stdlib_Bytes[58], _k_);
   }
   function get_int8(s, i){
    var _j_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[60], _j_, i);
   }
   function get_uint16_le(s, i){
    var _i_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[63], _i_, i);
   }
   function get_uint16_be(s, i){
    var _h_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[62], _h_, i);
   }
   function get_int16_ne(s, i){
    var _g_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[64], _g_, i);
   }
   function get_int16_le(s, i){
    var _f_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[66], _f_, i);
   }
   function get_int16_be(s, i){
    var _e_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[65], _e_, i);
   }
   function get_int32_le(s, i){
    var _d_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[69], _d_, i);
   }
   function get_int32_be(s, i){
    var _c_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[68], _c_, i);
   }
   function get_int64_le(s, i){
    var _b_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[72], _b_, i);
   }
   function get_int64_be(s, i){
    var _a_ = caml_call1(bos, s);
    return caml_call2(Stdlib_Bytes[71], _a_, i);
   }
   var
    Stdlib_String =
      [0,
       make,
       init,
       empty,
       of_bytes,
       to_bytes,
       blit,
       concat,
       cat,
       caml_string_equal,
       compare,
       starts_with,
       ends_with,
       contains_from,
       rcontains_from,
       contains,
       sub,
       split_on_char,
       map,
       mapi,
       fold_left,
       fold_right,
       for_all,
       exists,
       trim,
       escaped,
       uppercase_ascii,
       lowercase_ascii,
       capitalize_ascii,
       uncapitalize_ascii,
       iter,
       iteri,
       index_from,
       index_from_opt,
       rindex_from,
       rindex_from_opt,
       index,
       index_opt,
       rindex,
       rindex_opt,
       to_seq,
       to_seqi,
       of_seq,
       get_utf_8_uchar,
       is_valid_utf_8,
       get_utf_16be_uchar,
       is_valid_utf_16be,
       get_utf_16le_uchar,
       is_valid_utf_16le,
       runtime.caml_string_get,
       get_int8,
       runtime.caml_string_get16,
       get_uint16_be,
       get_uint16_le,
       get_int16_ne,
       get_int16_be,
       get_int16_le,
       runtime.caml_string_get32,
       hash,
       caml_string_hash,
       get_int32_be,
       get_int32_le,
       runtime.caml_string_get64,
       get_int64_be,
       get_int64_le];
   runtime.caml_register_global(12, Stdlib_String, "Stdlib__String");
   return;
  }
  (globalThis));

//# 5560 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_array_sub = runtime.caml_array_sub,
    caml_check_bound = runtime.caml_check_bound,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Assert_failure = global_data.Assert_failure,
    Stdlib = global_data.Stdlib,
    Floatarray = [0],
    cst_Array_init = "Array.init",
    cst_Array_sub = "Array.sub",
    cst_Array_fill = "Array.fill",
    cst_Array_blit = "Array.blit",
    cst_Array_iter2_arrays_must_ha =
      "Array.iter2: arrays must have the same length",
    cst_Array_map2_arrays_must_hav =
      "Array.map2: arrays must have the same length",
    cst_Array_for_all2 = "Array.for_all2",
    cst_Array_exists2 = "Array.exists2",
    cst_Array_combine = "Array.combine";
   function init(l, f){
    if(0 === l) return [0];
    if(0 > l) return caml_call1(Stdlib[1], cst_Array_init);
    var res = caml_make_vect(l, caml_call1(f, 0)), _aw_ = l - 1 | 0, _av_ = 1;
    if(_aw_ >= 1){
     var i = _av_;
     for(;;){
      res[1 + i] = caml_call1(f, i);
      var _ax_ = i + 1 | 0;
      if(_aw_ === i) break;
      var i = _ax_;
     }
    }
    return res;
   }
   function make_matrix(sx, sy, init){
    var res = caml_make_vect(sx, [0]), _at_ = sx - 1 | 0, _as_ = 0;
    if(_at_ >= 0){
     var x = _as_;
     for(;;){
      res[1 + x] = caml_make_vect(sy, init);
      var _au_ = x + 1 | 0;
      if(_at_ === x) break;
      var x = _au_;
     }
    }
    return res;
   }
   function copy(a){
    var l = a.length - 1;
    return 0 === l ? [0] : caml_array_sub(a, 0, l);
   }
   function append(a1, a2){
    var l1 = a1.length - 1;
    return 0 === l1
            ? copy(a2)
            : 0
              === a2.length - 1
              ? caml_array_sub(a1, 0, l1)
              : runtime.caml_array_append(a1, a2);
   }
   function sub(a, ofs, len){
    if(0 <= ofs && 0 <= len && (a.length - 1 - len | 0) >= ofs)
     return caml_array_sub(a, ofs, len);
    return caml_call1(Stdlib[1], cst_Array_sub);
   }
   function fill(a, ofs, len, v){
    if(0 <= ofs && 0 <= len && (a.length - 1 - len | 0) >= ofs)
     return runtime.caml_array_fill(a, ofs, len, v);
    return caml_call1(Stdlib[1], cst_Array_fill);
   }
   function blit(a1, ofs1, a2, ofs2, len){
    if
     (0 <= len
      &&
       0 <= ofs1
       &&
        (a1.length - 1 - len | 0) >= ofs1
        && 0 <= ofs2 && (a2.length - 1 - len | 0) >= ofs2)
     return runtime.caml_array_blit(a1, ofs1, a2, ofs2, len);
    return caml_call1(Stdlib[1], cst_Array_blit);
   }
   function iter(f, a){
    var _aq_ = a.length - 1 - 1 | 0, _ap_ = 0;
    if(_aq_ >= 0){
     var i = _ap_;
     for(;;){
      caml_call1(f, a[1 + i]);
      var _ar_ = i + 1 | 0;
      if(_aq_ === i) break;
      var i = _ar_;
     }
    }
    return 0;
   }
   function iter2(f, a, b){
    if(a.length - 1 !== b.length - 1)
     return caml_call1(Stdlib[1], cst_Array_iter2_arrays_must_ha);
    var _an_ = a.length - 1 - 1 | 0, _am_ = 0;
    if(_an_ >= 0){
     var i = _am_;
     for(;;){
      caml_call2(f, a[1 + i], b[1 + i]);
      var _ao_ = i + 1 | 0;
      if(_an_ === i) break;
      var i = _ao_;
     }
    }
    return 0;
   }
   function map(f, a){
    var l = a.length - 1;
    if(0 === l) return [0];
    var
     r = caml_make_vect(l, caml_call1(f, a[1])),
     _ak_ = l - 1 | 0,
     _aj_ = 1;
    if(_ak_ >= 1){
     var i = _aj_;
     for(;;){
      r[1 + i] = caml_call1(f, a[1 + i]);
      var _al_ = i + 1 | 0;
      if(_ak_ === i) break;
      var i = _al_;
     }
    }
    return r;
   }
   function map_inplace(f, a){
    var _ah_ = a.length - 1 - 1 | 0, _ag_ = 0;
    if(_ah_ >= 0){
     var i = _ag_;
     for(;;){
      a[1 + i] = caml_call1(f, a[1 + i]);
      var _ai_ = i + 1 | 0;
      if(_ah_ === i) break;
      var i = _ai_;
     }
    }
    return 0;
   }
   function mapi_inplace(f, a){
    var _ae_ = a.length - 1 - 1 | 0, _ad_ = 0;
    if(_ae_ >= 0){
     var i = _ad_;
     for(;;){
      a[1 + i] = caml_call2(f, i, a[1 + i]);
      var _af_ = i + 1 | 0;
      if(_ae_ === i) break;
      var i = _af_;
     }
    }
    return 0;
   }
   function map2(f, a, b){
    var la = a.length - 1, lb = b.length - 1;
    if(la !== lb)
     return caml_call1(Stdlib[1], cst_Array_map2_arrays_must_hav);
    if(0 === la) return [0];
    var
     r = caml_make_vect(la, caml_call2(f, a[1], b[1])),
     _ab_ = la - 1 | 0,
     _aa_ = 1;
    if(_ab_ >= 1){
     var i = _aa_;
     for(;;){
      r[1 + i] = caml_call2(f, a[1 + i], b[1 + i]);
      var _ac_ = i + 1 | 0;
      if(_ab_ === i) break;
      var i = _ac_;
     }
    }
    return r;
   }
   function iteri(f, a){
    var ___ = a.length - 1 - 1 | 0, _Z_ = 0;
    if(___ >= 0){
     var i = _Z_;
     for(;;){
      caml_call2(f, i, a[1 + i]);
      var _$_ = i + 1 | 0;
      if(___ === i) break;
      var i = _$_;
     }
    }
    return 0;
   }
   function mapi(f, a){
    var l = a.length - 1;
    if(0 === l) return [0];
    var
     r = caml_make_vect(l, caml_call2(f, 0, a[1])),
     _X_ = l - 1 | 0,
     _W_ = 1;
    if(_X_ >= 1){
     var i = _W_;
     for(;;){
      r[1 + i] = caml_call2(f, i, a[1 + i]);
      var _Y_ = i + 1 | 0;
      if(_X_ === i) break;
      var i = _Y_;
     }
    }
    return r;
   }
   function to_list(a){
    var i$1 = a.length - 1 - 1 | 0, i = i$1, res = 0;
    for(;;){
     if(0 > i) return res;
     var res$0 = [0, a[1 + i], res], i$0 = i - 1 | 0, i = i$0, res = res$0;
    }
   }
   function list_length(accu, param){
    var accu$0 = accu, param$0 = param;
    for(;;){
     if(! param$0) return accu$0;
     var
      t = param$0[2],
      accu$1 = accu$0 + 1 | 0,
      accu$0 = accu$1,
      param$0 = t;
    }
   }
   function of_list(l){
    if(! l) return [0];
    var
     tl = l[2],
     hd = l[1],
     a = caml_make_vect(list_length(0, l), hd),
     i = 1,
     param = tl;
    for(;;){
     if(! param) return a;
     var tl$0 = param[2], hd$0 = param[1];
     a[1 + i] = hd$0;
     var i$0 = i + 1 | 0, i = i$0, param = tl$0;
    }
   }
   function fold_left(f, x, a){
    var r = [0, x], _U_ = a.length - 1 - 1 | 0, _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
      r[1] = caml_call2(f, r[1], a[1 + i]);
      var _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
    return r[1];
   }
   function fold_left_map(f, acc, input_array){
    var len = input_array.length - 1;
    if(0 === len) return [0, acc, [0]];
    var
     match = caml_call2(f, acc, input_array[1]),
     elt = match[2],
     acc$0 = match[1],
     output_array = caml_make_vect(len, elt),
     acc$1 = [0, acc$0],
     _R_ = len - 1 | 0,
     _Q_ = 1;
    if(_R_ >= 1){
     var i = _Q_;
     for(;;){
      var
       match$0 = caml_call2(f, acc$1[1], input_array[1 + i]),
       elt$0 = match$0[2],
       acc$2 = match$0[1];
      acc$1[1] = acc$2;
      output_array[1 + i] = elt$0;
      var _S_ = i + 1 | 0;
      if(_R_ === i) break;
      var i = _S_;
     }
    }
    return [0, acc$1[1], output_array];
   }
   function fold_right(f, a, x){
    var r = [0, x], _O_ = a.length - 1 - 1 | 0;
    if(_O_ >= 0){
     var i = _O_;
     for(;;){
      r[1] = caml_call2(f, a[1 + i], r[1]);
      var _P_ = i - 1 | 0;
      if(0 === i) break;
      var i = _P_;
     }
    }
    return r[1];
   }
   function exists(p, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 0;
     if(caml_call1(p, a[1 + i])) return 1;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function for_all(p, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 1;
     if(! caml_call1(p, a[1 + i])) return 0;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function for_all2(p, l1, l2){
    var n1 = l1.length - 1, n2 = l2.length - 1;
    if(n1 !== n2) return caml_call1(Stdlib[1], cst_Array_for_all2);
    var i = 0;
    for(;;){
     if(i === n1) return 1;
     if(! caml_call2(p, l1[1 + i], l2[1 + i])) return 0;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function exists2(p, l1, l2){
    var n1 = l1.length - 1, n2 = l2.length - 1;
    if(n1 !== n2) return caml_call1(Stdlib[1], cst_Array_exists2);
    var i = 0;
    for(;;){
     if(i === n1) return 0;
     if(caml_call2(p, l1[1 + i], l2[1 + i])) return 1;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function mem(x, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 0;
     if(0 === runtime.caml_compare(a[1 + i], x)) return 1;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function memq(x, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 0;
     if(x === a[1 + i]) return 1;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function find_opt(p, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 0;
     var x = a[1 + i];
     if(caml_call1(p, x)) return [0, x];
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function find_index(p, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 0;
     if(caml_call1(p, a[1 + i])) return [0, i];
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function find_map(f, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 0;
     var r = caml_call1(f, a[1 + i]);
     if(r) return r;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function find_mapi(f, a){
    var n = a.length - 1, i = 0;
    for(;;){
     if(i === n) return 0;
     var r = caml_call2(f, i, a[1 + i]);
     if(r) return r;
     var i$0 = i + 1 | 0, i = i$0;
    }
   }
   function split(x){
    if(runtime.caml_equal(x, [0])) return [0, [0], [0]];
    var
     match = x[1],
     b0 = match[2],
     a0 = match[1],
     n = x.length - 1,
     a = caml_make_vect(n, a0),
     b = caml_make_vect(n, b0),
     _M_ = n - 1 | 0,
     _L_ = 1;
    if(_M_ >= 1){
     var i = _L_;
     for(;;){
      var match$0 = x[1 + i], bi = match$0[2], ai = match$0[1];
      a[1 + i] = ai;
      b[1 + i] = bi;
      var _N_ = i + 1 | 0;
      if(_M_ === i) break;
      var i = _N_;
     }
    }
    return [0, a, b];
   }
   function combine(a, b){
    var na = a.length - 1, nb = b.length - 1;
    if(na !== nb) caml_call1(Stdlib[1], cst_Array_combine);
    if(0 === na) return [0];
    var x = caml_make_vect(na, [0, a[1], b[1]]), _J_ = na - 1 | 0, _I_ = 1;
    if(_J_ >= 1){
     var i = _I_;
     for(;;){
      x[1 + i] = [0, a[1 + i], b[1 + i]];
      var _K_ = i + 1 | 0;
      if(_J_ === i) break;
      var i = _K_;
     }
    }
    return x;
   }
   var
    Bottom = [248, "Stdlib.Array.Bottom", runtime.caml_fresh_oo_id(0)],
    _a_ = [0, "array.ml", 348, 4];
   function sort(cmp, a){
    function maxson(l, i){
     var i31 = ((i + i | 0) + i | 0) + 1 | 0, x = [0, i31];
     if((i31 + 2 | 0) < l){
      var _B_ = i31 + 1 | 0, _C_ = caml_check_bound(a, _B_)[1 + _B_];
      if(caml_call2(cmp, caml_check_bound(a, i31)[1 + i31], _C_) < 0)
       x[1] = i31 + 1 | 0;
      var
       _D_ = i31 + 2 | 0,
       _E_ = caml_check_bound(a, _D_)[1 + _D_],
       _F_ = x[1];
      if(caml_call2(cmp, caml_check_bound(a, _F_)[1 + _F_], _E_) < 0)
       x[1] = i31 + 2 | 0;
      return x[1];
     }
     if((i31 + 1 | 0) < l){
      var _G_ = i31 + 1 | 0, _H_ = caml_check_bound(a, _G_)[1 + _G_];
      if(0 > caml_call2(cmp, caml_check_bound(a, i31)[1 + i31], _H_))
       return i31 + 1 | 0;
     }
     if(i31 < l) return i31;
     throw caml_maybe_attach_backtrace([0, Bottom, i], 1);
    }
    var l = a.length - 1, _v_ = ((l + 1 | 0) / 3 | 0) - 1 | 0;
    if(_v_ >= 0){
     var i$6 = _v_;
     for(;;){
      var e$1 = caml_check_bound(a, i$6)[1 + i$6];
      try{
       var i = i$6;
       for(;;){
        var j = maxson(l, i);
        if(0 >= caml_call2(cmp, caml_check_bound(a, j)[1 + j], e$1)) break;
        var _s_ = caml_check_bound(a, j)[1 + j];
        caml_check_bound(a, i)[1 + i] = _s_;
        var i = j;
       }
       caml_check_bound(a, i)[1 + i] = e$1;
      }
      catch(exn$0){
       var exn = caml_wrap_exception(exn$0);
       if(exn[1] !== Bottom) throw caml_maybe_attach_backtrace(exn, 0);
       var i$0 = exn[2];
       caml_check_bound(a, i$0)[1 + i$0] = e$1;
      }
      var _A_ = i$6 - 1 | 0;
      if(0 === i$6) break;
      var i$6 = _A_;
     }
    }
    var _w_ = l - 1 | 0;
    if(_w_ >= 2){
     var i$4 = _w_;
     for(;;){
      var e$0 = caml_check_bound(a, i$4)[1 + i$4];
      a[1 + i$4] = caml_check_bound(a, 0)[1];
      var i$5 = 0;
      try{
       var i$1 = i$5;
       for(;;){
        var j$0 = maxson(i$4, i$1), _t_ = caml_check_bound(a, j$0)[1 + j$0];
        caml_check_bound(a, i$1)[1 + i$1] = _t_;
        var i$1 = j$0;
       }
      }
      catch(exn){
       var exn$0 = caml_wrap_exception(exn);
       if(exn$0[1] !== Bottom) throw caml_maybe_attach_backtrace(exn$0, 0);
       var i$2 = exn$0[2];
       a:
       {
        b:
        {
         var i$3 = i$2;
         for(;;){
          var father = (i$3 - 1 | 0) / 3 | 0;
          if(i$3 === father)
           throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
          if
           (0 <= caml_call2(cmp, caml_check_bound(a, father)[1 + father], e$0))
           break;
          var _u_ = caml_check_bound(a, father)[1 + father];
          caml_check_bound(a, i$3)[1 + i$3] = _u_;
          if(0 >= father) break b;
          var i$3 = father;
         }
         caml_check_bound(a, i$3)[1 + i$3] = e$0;
         break a;
        }
        caml_check_bound(a, 0)[1] = e$0;
       }
       var _z_ = i$4 - 1 | 0;
       if(2 === i$4) break;
       var i$4 = _z_;
      }
     }
    }
    var _x_ = 1 < l ? 1 : 0;
    if(_x_){
     var e = caml_check_bound(a, 1)[2];
     a[2] = caml_check_bound(a, 0)[1];
     a[1] = e;
     var _y_ = 0;
    }
    else
     var _y_ = _x_;
    return _y_;
   }
   function stable_sort(cmp, a){
    function merge(src1ofs, src1len, src2, src2ofs, src2len, dst, dstofs){
     var
      src1r = src1ofs + src1len | 0,
      src2r = src2ofs + src2len | 0,
      s2$1 = caml_check_bound(src2, src2ofs)[1 + src2ofs],
      s1$1 = caml_check_bound(a, src1ofs)[1 + src1ofs],
      i1 = src1ofs,
      s1 = s1$1,
      i2 = src2ofs,
      s2 = s2$1,
      d = dstofs;
     for(;;)
      if(0 < caml_call2(cmp, s1, s2)){
       caml_check_bound(dst, d)[1 + d] = s2;
       var i2$0 = i2 + 1 | 0;
       if(i2$0 >= src2r) return blit(a, i1, dst, d + 1 | 0, src1r - i1 | 0);
       var
        d$0 = d + 1 | 0,
        s2$0 = caml_check_bound(src2, i2$0)[1 + i2$0],
        i2 = i2$0,
        s2 = s2$0,
        d = d$0;
      }
      else{
       caml_check_bound(dst, d)[1 + d] = s1;
       var i1$0 = i1 + 1 | 0;
       if(i1$0 >= src1r)
        return blit(src2, i2, dst, d + 1 | 0, src2r - i2 | 0);
       var
        d$1 = d + 1 | 0,
        s1$0 = caml_check_bound(a, i1$0)[1 + i1$0],
        i1 = i1$0,
        s1 = s1$0,
        d = d$1;
      }
    }
    function isortto(srcofs, dst, dstofs, len){
     var _k_ = len - 1 | 0, _j_ = 0;
     if(_k_ >= 0){
      var i = _j_;
      for(;;){
       var
        _l_ = srcofs + i | 0,
        e = caml_check_bound(a, _l_)[1 + _l_],
        j = [0, (dstofs + i | 0) - 1 | 0];
       for(;;){
        if(dstofs > j[1]) break;
        var _m_ = j[1];
        if(0 >= caml_call2(cmp, caml_check_bound(dst, _m_)[1 + _m_], e))
         break;
        var
         _n_ = j[1],
         _o_ = caml_check_bound(dst, _n_)[1 + _n_],
         _p_ = j[1] + 1 | 0;
        caml_check_bound(dst, _p_)[1 + _p_] = _o_;
        j[1] += -1;
       }
       var _q_ = j[1] + 1 | 0;
       caml_check_bound(dst, _q_)[1 + _q_] = e;
       var _r_ = i + 1 | 0;
       if(_k_ === i) break;
       var i = _r_;
      }
     }
     return 0;
    }
    function sortto(srcofs, dst, dstofs, len){
     if(len <= 5) return isortto(srcofs, dst, dstofs, len);
     var l1 = len / 2 | 0, l2 = len - l1 | 0;
     sortto(srcofs + l1 | 0, dst, dstofs + l1 | 0, l2);
     sortto(srcofs, a, srcofs + l2 | 0, l1);
     return merge(srcofs + l2 | 0, l1, dst, dstofs + l1 | 0, l2, dst, dstofs);
    }
    var l = a.length - 1;
    if(l <= 5) return isortto(0, a, 0, l);
    var
     l1 = l / 2 | 0,
     l2 = l - l1 | 0,
     t = caml_make_vect(l2, caml_check_bound(a, 0)[1]);
    sortto(l1, t, 0, l2);
    sortto(0, a, l2, l1);
    return merge(l2, l1, t, 0, l2, a, 0);
   }
   function to_seq(a){
    function aux(i, param){
     if(i >= a.length - 1) return 0;
     var x = a[1 + i], _h_ = i + 1 | 0;
     return [0, x, function(_i_){return aux(_h_, _i_);}];
    }
    var _f_ = 0;
    return function(_g_){return aux(_f_, _g_);};
   }
   function to_seqi(a){
    function aux(i, param){
     if(i >= a.length - 1) return 0;
     var x = a[1 + i], _d_ = i + 1 | 0;
     return [0, [0, i, x], function(_e_){return aux(_d_, _e_);}];
    }
    var _b_ = 0;
    return function(_c_){return aux(_b_, _c_);};
   }
   function of_seq(i$2){
    var
     l =
       caml_call3
        (Stdlib_Seq[5], function(acc, x){return [0, x, acc];}, 0, i$2);
    if(! l) return [0];
    var
     tl = l[2],
     hd = l[1],
     len = list_length(0, l),
     a = caml_make_vect(len, hd),
     i$1 = len - 2 | 0,
     i = i$1,
     param = tl;
    for(;;){
     if(! param) return a;
     var tl$0 = param[2], hd$0 = param[1];
     a[1 + i] = hd$0;
     var i$0 = i - 1 | 0, i = i$0, param = tl$0;
    }
   }
   var
    Stdlib_Array =
      [0,
       init,
       make_matrix,
       append,
       runtime.caml_array_concat,
       sub,
       copy,
       fill,
       blit,
       to_list,
       of_list,
       iter,
       iteri,
       map,
       map_inplace,
       mapi,
       mapi_inplace,
       fold_left,
       fold_left_map,
       fold_right,
       iter2,
       map2,
       for_all,
       exists,
       for_all2,
       exists2,
       mem,
       memq,
       find_opt,
       find_index,
       find_map,
       find_mapi,
       split,
       combine,
       sort,
       stable_sort,
       stable_sort,
       to_seq,
       to_seqi,
       of_seq,
       Floatarray];
   runtime.caml_register_global(14, Stdlib_Array, "Stdlib__Array");
   return;
  }
  (globalThis));

//# 7112 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_greaterequal = runtime.caml_greaterequal,
    caml_hash = runtime.caml_hash,
    caml_int_compare = runtime.caml_int_compare,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_mul = runtime.caml_mul,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Assert_failure = global_data.Assert_failure,
    zero = 0,
    one = 1;
   function succ(n){return n + 1 | 0;}
   function pred(n){return n - 1 | 0;}
   function abs(n){return caml_greaterequal(n, 0) ? n : - n | 0;}
   function lognot(n){return n ^ -1;}
   var
    _a_ = Stdlib_Sys[9],
    _b_ = [0, "int32.ml", 69, 6],
    minus_one = -1,
    min_int = -2147483648,
    max_int = 2147483647;
   if(32 === _a_)
    var
     max_int$0 = Stdlib[19],
     unsigned_to_int =
       function(n){
        if(0 >= caml_int_compare(0, n) && 0 >= caml_int_compare(n, max_int$0))
         return [0, n];
        return 0;
       };
   else{
    if(64 !== _a_)
     throw caml_maybe_attach_backtrace([0, Assert_failure, _b_], 1);
    var unsigned_to_int = function(n){return [0, n & -1];};
   }
   function to_string(n){return runtime.caml_format_int("%d", n);}
   function of_string_opt(s){
    try{var _d_ = [0, runtime.caml_int_of_string(s)]; return _d_;}
    catch(_e_){
     var _c_ = caml_wrap_exception(_e_);
     if(_c_[1] === Stdlib[7]) return 0;
     throw caml_maybe_attach_backtrace(_c_, 0);
    }
   }
   var compare = caml_int_compare;
   function equal(x, y){return 0 === caml_int_compare(x, y) ? 1 : 0;}
   function unsigned_compare(n, m){
    return caml_int_compare(n + 2147483648 | 0, m + 2147483648 | 0);
   }
   function min(x, y){return runtime.caml_lessequal(x, y) ? x : y;}
   function max(x, y){return caml_greaterequal(x, y) ? x : y;}
   function unsigned_div(n, d){
    if(runtime.caml_lessthan(d, 0))
     return 0 <= unsigned_compare(n, d) ? one : zero;
    var q = runtime.caml_div(n >>> 1 | 0, d) << 1, r = n - caml_mul(q, d) | 0;
    return 0 <= unsigned_compare(r, d) ? q + 1 | 0 : q;
   }
   function unsigned_rem(n, d){
    return n - caml_mul(unsigned_div(n, d), d) | 0;
   }
   function seeded_hash(seed, x){return caml_hash(10, 100, seed, x);}
   function hash(x){return caml_hash(10, 100, 0, x);}
   var
    Stdlib_Int32 =
      [0,
       zero,
       one,
       minus_one,
       unsigned_div,
       unsigned_rem,
       succ,
       pred,
       abs,
       max_int,
       min_int,
       lognot,
       unsigned_to_int,
       of_string_opt,
       to_string,
       compare,
       unsigned_compare,
       equal,
       min,
       max,
       seeded_hash,
       hash];
   runtime.caml_register_global(14, Stdlib_Int32, "Stdlib__Int32");
   return;
  }
  (globalThis));

//# 7211 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_greaterequal = runtime.caml_greaterequal,
    caml_hash = runtime.caml_hash,
    caml_int64_compare = runtime.caml_int64_compare,
    caml_int64_mul = runtime.caml_int64_mul,
    caml_int64_sub = runtime.caml_int64_sub,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    zero = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    one = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    minus_one = runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 65535),
    min_int = runtime.caml_int64_create_lo_mi_hi(0, 0, 32768),
    max_int = runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 32767),
    Stdlib = global_data.Stdlib,
    _a_ = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    _b_ = runtime.caml_int64_create_lo_mi_hi(1, 0, 0),
    _c_ = runtime.caml_int64_create_lo_mi_hi(0, 0, 0),
    _d_ = runtime.caml_int64_create_lo_mi_hi(16777215, 16777215, 65535);
   function succ(n){return runtime.caml_int64_add(n, _a_);}
   function pred(n){return caml_int64_sub(n, _b_);}
   function abs(n){
    return caml_greaterequal(n, _c_) ? n : runtime.caml_int64_neg(n);
   }
   function lognot(n){return runtime.caml_int64_xor(n, _d_);}
   var max_int$0 = runtime.caml_int64_of_int32(Stdlib[19]);
   function unsigned_to_int(n){
    if
     (0 >= caml_int64_compare(zero, n)
      && 0 >= caml_int64_compare(n, max_int$0))
     return [0, runtime.caml_int64_to_int32(n)];
    return 0;
   }
   function to_string(n){return runtime.caml_int64_format("%d", n);}
   function of_string_opt(s){
    try{var _f_ = [0, runtime.caml_int64_of_string(s)]; return _f_;}
    catch(_g_){
     var _e_ = caml_wrap_exception(_g_);
     if(_e_[1] === Stdlib[7]) return 0;
     throw caml_maybe_attach_backtrace(_e_, 0);
    }
   }
   function compare(x, y){return caml_int64_compare(x, y);}
   function equal(x, y){return 0 === caml_int64_compare(x, y) ? 1 : 0;}
   function unsigned_compare(n, m){
    return caml_int64_compare
            (caml_int64_sub(n, min_int), caml_int64_sub(m, min_int));
   }
   function min(x, y){return runtime.caml_lessequal(x, y) ? x : y;}
   function max(x, y){return caml_greaterequal(x, y) ? x : y;}
   function unsigned_div(n, d){
    if(runtime.caml_lessthan(d, zero))
     return 0 <= unsigned_compare(n, d) ? one : zero;
    var
     q =
       runtime.caml_int64_shift_left
        (runtime.caml_int64_div
          (runtime.caml_int64_shift_right_unsigned(n, 1), d),
         1),
     r = caml_int64_sub(n, caml_int64_mul(q, d));
    return 0 <= unsigned_compare(r, d) ? succ(q) : q;
   }
   function unsigned_rem(n, d){
    return caml_int64_sub(n, caml_int64_mul(unsigned_div(n, d), d));
   }
   function seeded_hash(seed, x){return caml_hash(10, 100, seed, x);}
   function hash(x){return caml_hash(10, 100, 0, x);}
   var
    Stdlib_Int64 =
      [0,
       zero,
       one,
       minus_one,
       unsigned_div,
       unsigned_rem,
       succ,
       pred,
       abs,
       max_int,
       min_int,
       lognot,
       unsigned_to_int,
       of_string_opt,
       to_string,
       compare,
       unsigned_compare,
       equal,
       min,
       max,
       seeded_hash,
       hash];
   runtime.caml_register_global(11, Stdlib_Int64, "Stdlib__Int64");
   return;
  }
  (globalThis));

//# 7313 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_greaterequal = runtime.caml_greaterequal,
    caml_hash = runtime.caml_hash,
    caml_int_compare = runtime.caml_int_compare,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_mul = runtime.caml_mul,
    caml_wrap_exception = runtime.caml_wrap_exception,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    zero = 0,
    one = 1;
   function succ(n){return n + 1 | 0;}
   function pred(n){return n - 1 | 0;}
   function abs(n){return caml_greaterequal(n, 0) ? n : - n | 0;}
   var
    size = Stdlib_Sys[9],
    min_int = 1 << (size - 1 | 0),
    max_int = min_int - 1 | 0;
   function lognot(n){return n ^ -1;}
   var max_int$0 = Stdlib[19];
   function unsigned_to_int(n){
    if(0 >= caml_int_compare(0, n) && 0 >= caml_int_compare(n, max_int$0))
     return [0, n];
    return 0;
   }
   function to_string(n){return runtime.caml_format_int("%d", n);}
   function of_string_opt(s){
    try{var _b_ = [0, runtime.caml_int_of_string(s)]; return _b_;}
    catch(_c_){
     var _a_ = caml_wrap_exception(_c_);
     if(_a_[1] === Stdlib[7]) return 0;
     throw caml_maybe_attach_backtrace(_a_, 0);
    }
   }
   var compare = caml_int_compare;
   function equal(x, y){return 0 === caml_int_compare(x, y) ? 1 : 0;}
   function unsigned_compare(n, m){
    return caml_int_compare(n - min_int | 0, m - min_int | 0);
   }
   function min(x, y){return runtime.caml_lessequal(x, y) ? x : y;}
   function max(x, y){return caml_greaterequal(x, y) ? x : y;}
   function unsigned_div(n, d){
    if(runtime.caml_lessthan(d, 0))
     return 0 <= unsigned_compare(n, d) ? one : zero;
    var q = runtime.caml_div(n >>> 1 | 0, d) << 1, r = n - caml_mul(q, d) | 0;
    return 0 <= unsigned_compare(r, d) ? q + 1 | 0 : q;
   }
   function unsigned_rem(n, d){
    return n - caml_mul(unsigned_div(n, d), d) | 0;
   }
   function seeded_hash(seed, x){return caml_hash(10, 100, seed, x);}
   function hash(x){return caml_hash(10, 100, 0, x);}
   var
    Stdlib_Nativeint =
      [0,
       zero,
       one,
       -1,
       unsigned_div,
       unsigned_rem,
       succ,
       pred,
       abs,
       size,
       max_int,
       min_int,
       lognot,
       unsigned_to_int,
       of_string_opt,
       to_string,
       compare,
       unsigned_compare,
       equal,
       min,
       max,
       seeded_hash,
       hash];
   runtime.caml_register_global(12, Stdlib_Nativeint, "Stdlib__Nativeint");
   return;
  }
  (globalThis));

//# 7402 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst = "",
    caml_bytes_get = runtime.caml_bytes_get,
    caml_check_bound = runtime.caml_check_bound,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
   function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    dummy_pos = [0, cst, 0, 0, -1],
    zero_pos = [0, cst, 1, 0, 0],
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib = global_data.Stdlib,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Int = global_data.Stdlib__Int,
    cst_Lexing_lex_refill_cannot_g = "Lexing.lex_refill: cannot grow buffer";
   function engine(tbl, state, buf){
    var
     result = runtime.caml_lex_engine(tbl, state, buf),
     _n_ = 0 <= result ? 1 : 0,
     _o_ = _n_ ? buf[12] !== dummy_pos ? 1 : 0 : _n_;
    if(_o_){
     buf[11] = buf[12];
     var _p_ = buf[12];
     buf[12] = [0, _p_[1], _p_[2], _p_[3], buf[4] + buf[6] | 0];
    }
    return result;
   }
   function new_engine(tbl, state, buf){
    var
     result = runtime.caml_new_lex_engine(tbl, state, buf),
     _k_ = 0 <= result ? 1 : 0,
     _l_ = _k_ ? buf[12] !== dummy_pos ? 1 : 0 : _k_;
    if(_l_){
     buf[11] = buf[12];
     var _m_ = buf[12];
     buf[12] = [0, _m_[1], _m_[2], _m_[3], buf[4] + buf[6] | 0];
    }
    return result;
   }
   function from_function(opt, read_fun){
    if(opt)
     var sth = opt[1], with_positions = sth;
    else
     var with_positions = 1;
    var
     _f_ = with_positions ? zero_pos : dummy_pos,
     _g_ = with_positions ? zero_pos : dummy_pos,
     aux_buffer = caml_create_bytes(512);
    return [0,
            function(lexbuf){
             var
              read =
                caml_call2
                 (read_fun, aux_buffer, caml_ml_bytes_length(aux_buffer)),
              n = 0 < read ? read : (lexbuf[9] = 1, 0);
             if(caml_ml_bytes_length(lexbuf[2]) < (lexbuf[3] + n | 0)){
              if
               (((lexbuf[3] - lexbuf[5] | 0) + n | 0)
                <= caml_ml_bytes_length(lexbuf[2]))
               caml_call5
                (Stdlib_Bytes[11],
                 lexbuf[2],
                 lexbuf[5],
                 lexbuf[2],
                 0,
                 lexbuf[3] - lexbuf[5] | 0);
              else{
               var
                newlen =
                  caml_call2
                   (Stdlib_Int[10],
                    2 * caml_ml_bytes_length(lexbuf[2]) | 0,
                    Stdlib_Sys[12]);
               if(newlen < ((lexbuf[3] - lexbuf[5] | 0) + n | 0))
                caml_call1(Stdlib[2], cst_Lexing_lex_refill_cannot_g);
               var newbuf = caml_create_bytes(newlen);
               caml_call5
                (Stdlib_Bytes[11],
                 lexbuf[2],
                 lexbuf[5],
                 newbuf,
                 0,
                 lexbuf[3] - lexbuf[5] | 0);
               lexbuf[2] = newbuf;
              }
              var s = lexbuf[5];
              lexbuf[4] = lexbuf[4] + s | 0;
              lexbuf[6] = lexbuf[6] - s | 0;
              lexbuf[5] = 0;
              lexbuf[7] = lexbuf[7] - s | 0;
              lexbuf[3] = lexbuf[3] - s | 0;
              var t = lexbuf[10], _i_ = t.length - 1 - 1 | 0, _h_ = 0;
              if(_i_ >= 0){
               var i = _h_;
               for(;;){
                var v = caml_check_bound(t, i)[1 + i];
                if(0 <= v) caml_check_bound(t, i)[1 + i] = v - s | 0;
                var _j_ = i + 1 | 0;
                if(_i_ === i) break;
                var i = _j_;
               }
              }
             }
             caml_call5
              (Stdlib_Bytes[11], aux_buffer, 0, lexbuf[2], lexbuf[3], n);
             lexbuf[3] = lexbuf[3] + n | 0;
             return 0;
            },
            caml_create_bytes(1024),
            0,
            0,
            0,
            0,
            0,
            0,
            0,
            [0],
            _g_,
            _f_];
   }
   function from_channel(with_positions, ic){
    return from_function
            (with_positions,
             function(buf, n){return caml_call4(Stdlib[84], ic, buf, 0, n);});
   }
   function from_string(opt, s){
    if(opt)
     var sth = opt[1], with_positions = sth;
    else
     var with_positions = 1;
    var
     _d_ = with_positions ? zero_pos : dummy_pos,
     _e_ = with_positions ? zero_pos : dummy_pos;
    return [0,
            function(lexbuf){lexbuf[9] = 1; return 0;},
            caml_call1(Stdlib_Bytes[5], s),
            runtime.caml_ml_string_length(s),
            0,
            0,
            0,
            0,
            0,
            1,
            [0],
            _e_,
            _d_];
   }
   function set_position(lexbuf, position){
    lexbuf[12] = [0, lexbuf[12][1], position[2], position[3], position[4]];
    lexbuf[4] = position[4];
    return 0;
   }
   function set_filename(lexbuf, fname){
    var _c_ = lexbuf[12];
    lexbuf[12] = [0, fname, _c_[2], _c_[3], _c_[4]];
    return 0;
   }
   function with_positions(lexbuf){return lexbuf[12] !== dummy_pos ? 1 : 0;}
   function lexeme(lexbuf){
    var len = lexbuf[6] - lexbuf[5] | 0;
    return caml_call3(Stdlib_Bytes[8], lexbuf[2], lexbuf[5], len);
   }
   function sub_lexeme(lexbuf, i1, i2){
    var len = i2 - i1 | 0;
    return caml_call3(Stdlib_Bytes[8], lexbuf[2], i1, len);
   }
   function sub_lexeme_opt(lexbuf, i1, i2){
    if(0 > i1) return 0;
    var len = i2 - i1 | 0;
    return [0, caml_call3(Stdlib_Bytes[8], lexbuf[2], i1, len)];
   }
   function sub_lexeme_char(lexbuf, i){return caml_bytes_get(lexbuf[2], i);}
   function sub_lexeme_char_opt(lexbuf, i){
    return 0 <= i ? [0, caml_bytes_get(lexbuf[2], i)] : 0;
   }
   function lexeme_char(lexbuf, i){
    return caml_bytes_get(lexbuf[2], lexbuf[5] + i | 0);
   }
   function lexeme_start(lexbuf){return lexbuf[11][4];}
   function lexeme_end(lexbuf){return lexbuf[12][4];}
   function lexeme_start_p(lexbuf){return lexbuf[11];}
   function lexeme_end_p(lexbuf){return lexbuf[12];}
   function new_line(lexbuf){
    var
     lcp = lexbuf[12],
     _a_ = lcp !== dummy_pos ? 1 : 0,
     _b_ =
       _a_
        ? (lexbuf[12] = [0, lcp[1], lcp[2] + 1 | 0, lcp[4], lcp[4]], 0)
        : _a_;
    return _b_;
   }
   function flush_input(lb){
    lb[6] = 0;
    lb[4] = 0;
    var lcp = lb[12];
    if(lcp !== dummy_pos)
     lb[12] = [0, lcp[1], zero_pos[2], zero_pos[3], zero_pos[4]];
    lb[3] = 0;
    return 0;
   }
   var
    Stdlib_Lexing =
      [0,
       dummy_pos,
       from_channel,
       from_string,
       from_function,
       set_position,
       set_filename,
       with_positions,
       lexeme,
       lexeme_char,
       lexeme_start,
       lexeme_end,
       lexeme_start_p,
       lexeme_end_p,
       new_line,
       flush_input,
       sub_lexeme,
       sub_lexeme_opt,
       sub_lexeme_char,
       sub_lexeme_char_opt,
       engine,
       new_engine];
   runtime.caml_register_global(7, Stdlib_Lexing, "Stdlib__Lexing");
   return;
  }
  (globalThis));

//# 7875 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Set_bal$3 = "Set.bal",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_List = global_data.Stdlib__List,
    Assert_failure = global_data.Assert_failure,
    cst_Set_bal = cst_Set_bal$3,
    cst_Set_bal$0 = cst_Set_bal$3,
    cst_Set_bal$1 = cst_Set_bal$3,
    cst_Set_bal$2 = cst_Set_bal$3,
    cst_Set_remove_min_elt = "Set.remove_min_elt",
    _a_ = [0, 0, 0, 0],
    _b_ = [0, 0, 0],
    _c_ = [0, "set.ml", 571, 18],
    Stdlib_Set =
      [0,
       function(Ord){
        function height(param){
         if(! param) return 0;
         var h = param[4];
         return h;
        }
        function create(l, v, r){
         if(l) var h = l[4], hl = h; else var hl = 0;
         if(r) var h$0 = r[4], hr = h$0; else var hr = 0;
         var _Y_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
         return [0, l, v, r, _Y_];
        }
        function bal(l, v, r){
         if(l) var h = l[4], hl = h; else var hl = 0;
         if(r) var h$0 = r[4], hr = h$0; else var hr = 0;
         if((hr + 2 | 0) < hl){
          if(! l) return caml_call1(Stdlib[1], cst_Set_bal$0);
          var lr = l[3], lv = l[2], ll = l[1], _T_ = height(lr);
          if(_T_ <= height(ll)) return create(ll, lv, create(lr, v, r));
          if(! lr) return caml_call1(Stdlib[1], cst_Set_bal);
          var lrr = lr[3], lrv = lr[2], lrl = lr[1], _U_ = create(lrr, v, r);
          return create(create(ll, lv, lrl), lrv, _U_);
         }
         if((hl + 2 | 0) >= hr){
          var _X_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
          return [0, l, v, r, _X_];
         }
         if(! r) return caml_call1(Stdlib[1], cst_Set_bal$2);
         var rr = r[3], rv = r[2], rl = r[1], _V_ = height(rl);
         if(_V_ <= height(rr)) return create(create(l, v, rl), rv, rr);
         if(! rl) return caml_call1(Stdlib[1], cst_Set_bal$1);
         var rlr = rl[3], rlv = rl[2], rll = rl[1], _W_ = create(rlr, rv, rr);
         return create(create(l, v, rll), rlv, _W_);
        }
        function add(x, t){
         if(! t) return [0, 0, x, 0, 1];
         var r = t[3], v = t[2], l = t[1], c = caml_call2(Ord[1], x, v);
         if(0 === c) return t;
         if(0 <= c){var rr = add(x, r); return r === rr ? t : bal(l, v, rr);}
         var ll = add(x, l);
         return l === ll ? t : bal(ll, v, r);
        }
        function singleton(x){return [0, 0, x, 0, 1];}
        function add_min_element(x, param){
         if(! param) return singleton(x);
         var r = param[3], v = param[2], l = param[1];
         return bal(add_min_element(x, l), v, r);
        }
        function add_max_element(x, param){
         if(! param) return singleton(x);
         var r = param[3], v = param[2], l = param[1];
         return bal(l, v, add_max_element(x, r));
        }
        function join(l, v, r){
         if(! l) return add_min_element(v, r);
         if(! r) return add_max_element(v, l);
         var
          rh = r[4],
          rr = r[3],
          rv = r[2],
          rl = r[1],
          lh = l[4],
          lr = l[3],
          lv = l[2],
          ll = l[1];
         return (rh + 2 | 0) < lh
                 ? bal(ll, lv, join(lr, v, r))
                 : (lh
                   + 2
                   | 0)
                   < rh
                   ? bal(join(l, v, rl), rv, rr)
                   : create(l, v, r);
        }
        function min_elt(param){
         var param$0 = param;
         for(;;){
          if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var l = param$0[1];
          if(! l){var v = param$0[2]; return v;}
          var param$0 = l;
         }
        }
        function min_elt_opt(param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var l = param$0[1];
          if(! l){var v = param$0[2]; return [0, v];}
          var param$0 = l;
         }
        }
        function max_elt(param){
         var param$0 = param;
         for(;;){
          if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          if(! param$0[3]){var v = param$0[2]; return v;}
          var r = param$0[3], param$0 = r;
         }
        }
        function max_elt_opt(param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          if(! param$0[3]){var v = param$0[2]; return [0, v];}
          var r = param$0[3], param$0 = r;
         }
        }
        function remove_min_elt(param){
         if(! param) return caml_call1(Stdlib[1], cst_Set_remove_min_elt);
         var l = param[1];
         if(l){
          var r = param[3], v = param[2];
          return bal(remove_min_elt(l), v, r);
         }
         var r$0 = param[3];
         return r$0;
        }
        function concat(t1, t2){
         if(! t1) return t2;
         if(! t2) return t1;
         var _S_ = remove_min_elt(t2);
         return join(t1, min_elt(t2), _S_);
        }
        function split(x, param){
         if(! param) return _a_;
         var
          r = param[3],
          v = param[2],
          l = param[1],
          c = caml_call2(Ord[1], x, v);
         if(0 === c) return [0, l, 1, r];
         if(0 <= c){
          var
           match = split(x, r),
           rr = match[3],
           pres = match[2],
           lr = match[1];
          return [0, join(l, v, lr), pres, rr];
         }
         var
          match$0 = split(x, l),
          rl = match$0[3],
          pres$0 = match$0[2],
          ll = match$0[1];
         return [0, ll, pres$0, join(rl, v, r)];
        }
        var empty = 0;
        function is_empty(param){return param ? 0 : 1;}
        function mem(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
           c = caml_call2(Ord[1], x, v),
           _R_ = 0 === c ? 1 : 0;
          if(_R_) return _R_;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function remove(x, t){
         if(! t) return 0;
         var t2 = t[3], v = t[2], t1 = t[1], c = caml_call2(Ord[1], x, v);
         if(0 === c){
          if(! t1) return t2;
          if(! t2) return t1;
          var _Q_ = remove_min_elt(t2);
          return bal(t1, min_elt(t2), _Q_);
         }
         if(0 <= c){
          var rr = remove(x, t2);
          return t2 === rr ? t : bal(t1, v, rr);
         }
         var ll = remove(x, t1);
         return t1 === ll ? t : bal(ll, v, t2);
        }
        function union(s1, s2){
         if(! s1) return s2;
         if(! s2) return s1;
         var
          h2 = s2[4],
          r2 = s2[3],
          v2 = s2[2],
          l2 = s2[1],
          h1 = s1[4],
          r1 = s1[3],
          v1 = s1[2],
          l1 = s1[1];
         if(h2 <= h1){
          if(1 === h2) return add(v2, s1);
          var
           match = split(v1, s2),
           r2$0 = match[3],
           l2$0 = match[1],
           _O_ = union(r1, r2$0);
          return join(union(l1, l2$0), v1, _O_);
         }
         if(1 === h1) return add(v1, s2);
         var
          match$0 = split(v2, s1),
          r1$0 = match$0[3],
          l1$0 = match$0[1],
          _P_ = union(r1$0, r2);
         return join(union(l1$0, l2), v2, _P_);
        }
        function inter(s1, s2){
         if(! s1) return 0;
         if(! s2) return 0;
         var
          r1 = s1[3],
          v1 = s1[2],
          l1 = s1[1],
          _L_ = split(v1, s2),
          l2 = _L_[1];
         if(_L_[2]){
          var r2 = _L_[3], _M_ = inter(r1, r2);
          return join(inter(l1, l2), v1, _M_);
         }
         var r2$0 = _L_[3], _N_ = inter(r1, r2$0);
         return concat(inter(l1, l2), _N_);
        }
        function split_bis(x, param){
         if(! param) return [0, 0, function(param){return 0;}];
         var
          r = param[3],
          v = param[2],
          l = param[1],
          c = caml_call2(Ord[1], x, v);
         if(0 === c) return 0;
         if(0 <= c){
          var match = split_bis(x, r);
          if(! match) return 0;
          var rr = match[2], lr = match[1];
          return [0, join(l, v, lr), rr];
         }
         var match$0 = split_bis(x, l);
         if(! match$0) return 0;
         var rl = match$0[2], ll = match$0[1];
         return [0, ll, function(param){return join(rl(0), v, r);}];
        }
        function disjoint(s1, s2){
         var s1$0 = s1, s2$0 = s2;
         for(;;){
          if(s1$0 && s2$0){
           var r1 = s1$0[3], v1 = s1$0[2], l1 = s1$0[1];
           if(s1$0 === s2$0) return 0;
           var match = split_bis(v1, s2$0);
           if(! match) return 0;
           var r2 = match[2], l2 = match[1], _K_ = disjoint(l1, l2);
           if(! _K_) return _K_;
           var s2$1 = r2(0), s1$0 = r1, s2$0 = s2$1;
           continue;
          }
          return 1;
         }
        }
        function diff(s1, s2){
         if(! s1) return 0;
         if(! s2) return s1;
         var
          r1 = s1[3],
          v1 = s1[2],
          l1 = s1[1],
          _H_ = split(v1, s2),
          l2 = _H_[1];
         if(_H_[2]){
          var r2 = _H_[3], _I_ = diff(r1, r2);
          return concat(diff(l1, l2), _I_);
         }
         var r2$0 = _H_[3], _J_ = diff(r1, r2$0);
         return join(diff(l1, l2), v1, _J_);
        }
        function cons_enum(s, e){
         var s$0 = s, e$0 = e;
         for(;;){
          if(! s$0) return e$0;
          var
           r = s$0[3],
           v = s$0[2],
           l = s$0[1],
           e$1 = [0, v, r, e$0],
           s$0 = l,
           e$0 = e$1;
         }
        }
        function compare(s1, s2){
         var
          e2$2 = cons_enum(s2, 0),
          e1$2 = cons_enum(s1, 0),
          e1 = e1$2,
          e2 = e2$2;
         for(;;){
          if(! e1) return e2 ? -1 : 0;
          if(! e2) return 1;
          var
           e2$0 = e2[3],
           r2 = e2[2],
           v2 = e2[1],
           e1$0 = e1[3],
           r1 = e1[2],
           v1 = e1[1],
           c = caml_call2(Ord[1], v1, v2);
          if(0 !== c) return c;
          var
           e2$1 = cons_enum(r2, e2$0),
           e1$1 = cons_enum(r1, e1$0),
           e1 = e1$1,
           e2 = e2$1;
         }
        }
        function equal(s1, s2){return 0 === compare(s1, s2) ? 1 : 0;}
        function subset(s1, s2){
         var s1$0 = s1, s2$0 = s2;
         for(;;){
          if(! s1$0) return 1;
          if(! s2$0) return 0;
          var
           r2 = s2$0[3],
           v2 = s2$0[2],
           l2 = s2$0[1],
           r1 = s1$0[3],
           v1 = s1$0[2],
           l1 = s1$0[1],
           c = caml_call2(Ord[1], v1, v2);
          if(0 === c){
           var _E_ = subset(l1, l2);
           if(! _E_) return _E_;
           var s1$0 = r1, s2$0 = r2;
          }
          else if(0 <= c){
           var _F_ = subset([0, 0, v1, r1, 0], r2);
           if(! _F_) return _F_;
           var s1$0 = l1;
          }
          else{
           var _G_ = subset([0, l1, v1, 0, 0], l2);
           if(! _G_) return _G_;
           var s1$0 = r1;
          }
         }
        }
        function iter(f, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var r = param$0[3], v = param$0[2], l = param$0[1];
          iter(f, l);
          caml_call1(f, v);
          var param$0 = r;
         }
        }
        function fold(f, s, accu){
         var s$0 = s, accu$0 = accu;
         for(;;){
          if(! s$0) return accu$0;
          var
           r = s$0[3],
           v = s$0[2],
           l = s$0[1],
           accu$1 = caml_call2(f, v, fold(f, l, accu$0)),
           s$0 = r,
           accu$0 = accu$1;
         }
        }
        function for_all(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 1;
          var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
           _B_ = caml_call1(p, v);
          if(_B_){
           var _C_ = for_all(p, l);
           if(_C_){var param$0 = r; continue;}
           var _D_ = _C_;
          }
          else
           var _D_ = _B_;
          return _D_;
         }
        }
        function exists(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
           _y_ = caml_call1(p, v);
          if(_y_)
           var _z_ = _y_;
          else{
           var _A_ = exists(p, l);
           if(! _A_){var param$0 = r; continue;}
           var _z_ = _A_;
          }
          return _z_;
         }
        }
        function filter(p, t){
         if(! t) return 0;
         var
          r = t[3],
          v = t[2],
          l = t[1],
          l$0 = filter(p, l),
          pv = caml_call1(p, v),
          r$0 = filter(p, r);
         if(! pv) return concat(l$0, r$0);
         if(l === l$0 && r === r$0) return t;
         return join(l$0, v, r$0);
        }
        function partition(p, param){
         if(! param) return _b_;
         var
          r = param[3],
          v = param[2],
          l = param[1],
          match = partition(p, l),
          lf = match[2],
          lt = match[1],
          pv = caml_call1(p, v),
          match$0 = partition(p, r),
          rf = match$0[2],
          rt = match$0[1];
         if(pv){var _w_ = concat(lf, rf); return [0, join(lt, v, rt), _w_];}
         var _x_ = join(lf, v, rf);
         return [0, concat(lt, rt), _x_];
        }
        function cardinal(param){
         if(! param) return 0;
         var r = param[3], l = param[1], _v_ = cardinal(r);
         return (cardinal(l) + 1 | 0) + _v_ | 0;
        }
        function elements_aux(accu, param){
         var accu$0 = accu, param$0 = param;
         for(;;){
          if(! param$0) return accu$0;
          var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
           accu$1 = [0, v, elements_aux(accu$0, r)],
           accu$0 = accu$1,
           param$0 = l;
         }
        }
        function elements(s){return elements_aux(0, s);}
        function find(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
           c = caml_call2(Ord[1], x, v);
          if(0 === c) return v;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function find_first(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, param = l$0;
           for(;;){
            if(! param) return v0;
            var r = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_first_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) return 0;
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, param = l$0;
           for(;;){
            if(! param) return [0, v0];
            var r = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_last(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, param = r$0;
           for(;;){
            if(! param) return v0;
            var r = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_last_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) return 0;
          var r$0 = param$1[3], v0$1 = param$1[2], l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, param = r$0;
           for(;;){
            if(! param) return [0, v0];
            var r = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_opt(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var
           r = param$0[3],
           v = param$0[2],
           l = param$0[1],
           c = caml_call2(Ord[1], x, v);
          if(0 === c) return [0, v];
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function try_join(l, v, r){
         a:
         {
          if(0 !== l){
           var _u_ = max_elt(l);
           if(0 <= caml_call2(Ord[1], _u_, v)) break a;
          }
          if(0 !== r){
           var _t_ = min_elt(r);
           if(0 <= caml_call2(Ord[1], v, _t_)) break a;
          }
          return join(l, v, r);
         }
         return union(l, add(v, r));
        }
        function map(f, t){
         if(! t) return 0;
         var
          r = t[3],
          v = t[2],
          l = t[1],
          l$0 = map(f, l),
          v$0 = caml_call1(f, v),
          r$0 = map(f, r);
         if(l === l$0 && v === v$0 && r === r$0) return t;
         return try_join(l$0, v$0, r$0);
        }
        function filter_map(f, t){
         if(! t) return 0;
         var
          r = t[3],
          v = t[2],
          l = t[1],
          t1 = filter_map(f, l),
          v$0 = caml_call1(f, v),
          t2 = filter_map(f, r);
         if(v$0){
          var v$1 = v$0[1];
          if(l === t1 && v === v$1 && r === t2) return t;
          return try_join(t1, v$1, t2);
         }
         if(! t1) return t2;
         if(! t2) return t1;
         var _s_ = remove_min_elt(t2);
         return try_join(t1, min_elt(t2), _s_);
        }
        function of_list(l){
         if(! l) return empty;
         var _n_ = l[2], x0 = l[1];
         if(! _n_) return singleton(x0);
         var _o_ = _n_[2], x1 = _n_[1];
         if(! _o_) return add(x1, singleton(x0));
         var _p_ = _o_[2], x2 = _o_[1];
         if(! _p_) return add(x2, add(x1, singleton(x0)));
         var _q_ = _p_[2], x3 = _p_[1];
         if(! _q_) return add(x3, add(x2, add(x1, singleton(x0))));
         if(_q_[2]){
          var
           l$0 = caml_call2(Stdlib_List[62], Ord[1], l),
           sub =
             function(n, l){
              if(3 >= n >>> 0)
               switch(n){
                 case 0:
                  return [0, 0, l];
                 case 1:
                  if(l){
                   var l$3 = l[2], x0 = l[1];
                   return [0, [0, 0, x0, 0, 1], l$3];
                  }
                  break;
                 case 2:
                  if(l){
                   var match$1 = l[2];
                   if(match$1){
                    var l$4 = match$1[2], x1 = match$1[1], x0$0 = l[1];
                    return [0, [0, [0, 0, x0$0, 0, 1], x1, 0, 2], l$4];
                   }
                  }
                  break;
                 default:
                  if(l){
                   var _r_ = l[2];
                   if(_r_){
                    var match$2 = _r_[2];
                    if(match$2){
                     var
                      l$5 = match$2[2],
                      x2 = match$2[1],
                      x1$0 = _r_[1],
                      x0$1 = l[1];
                     return [0,
                             [0, [0, 0, x0$1, 0, 1], x1$0, [0, 0, x2, 0, 1], 2],
                             l$5];
                    }
                   }
                  }
               }
              var
               nl = n / 2 | 0,
               match = sub(nl, l),
               l$0 = match[2],
               left = match[1];
              if(! l$0)
               throw caml_maybe_attach_backtrace([0, Assert_failure, _c_], 1);
              var
               l$1 = l$0[2],
               mid = l$0[1],
               match$0 = sub((n - nl | 0) - 1 | 0, l$1),
               l$2 = match$0[2],
               right = match$0[1];
              return [0, create(left, mid, right), l$2];
             };
          return sub(caml_call1(Stdlib_List[1], l$0), l$0)[1];
         }
         var x4 = _q_[1];
         return add(x4, add(x3, add(x2, add(x1, singleton(x0)))));
        }
        function add_seq(i, m){
         return caml_call3
                 (Stdlib_Seq[5], function(s, x){return add(x, s);}, m, i);
        }
        function of_seq(i){return add_seq(i, empty);}
        function seq_of_enum(c, param){
         if(! c) return 0;
         var rest = c[3], t = c[2], x = c[1], _l_ = cons_enum(t, rest);
         return [0, x, function(_m_){return seq_of_enum(_l_, _m_);}];
        }
        function to_seq(c){
         var _j_ = cons_enum(c, 0);
         return function(_k_){return seq_of_enum(_j_, _k_);};
        }
        function snoc_enum(s, e){
         var s$0 = s, e$0 = e;
         for(;;){
          if(! s$0) return e$0;
          var
           r = s$0[3],
           v = s$0[2],
           l = s$0[1],
           e$1 = [0, v, l, e$0],
           s$0 = r,
           e$0 = e$1;
         }
        }
        function rev_seq_of_enum(c, param){
         if(! c) return 0;
         var rest = c[3], t = c[2], x = c[1], _h_ = snoc_enum(t, rest);
         return [0, x, function(_i_){return rev_seq_of_enum(_h_, _i_);}];
        }
        function to_rev_seq(c){
         var _f_ = snoc_enum(c, 0);
         return function(_g_){return rev_seq_of_enum(_f_, _g_);};
        }
        function to_seq_from(low, s){
         a:
         {
          b:
          {
           var s$0 = s, c = 0;
           for(;;){
            if(! s$0) break;
            var
             r = s$0[3],
             v = s$0[2],
             l = s$0[1],
             n = caml_call2(Ord[1], v, low);
            if(0 === n) break b;
            if(0 <= n)
             var c$0 = [0, v, r, c], s$0 = l, c = c$0;
            else
             var s$0 = r;
           }
           var _d_ = c;
           break a;
          }
          var _d_ = [0, v, r, c];
         }
         return function(_e_){return seq_of_enum(_d_, _e_);};
        }
        return [0,
                empty,
                add,
                singleton,
                remove,
                union,
                inter,
                disjoint,
                diff,
                cardinal,
                elements,
                min_elt,
                min_elt_opt,
                max_elt,
                max_elt_opt,
                min_elt,
                min_elt_opt,
                find,
                find_opt,
                find_first,
                find_first_opt,
                find_last,
                find_last_opt,
                iter,
                fold,
                map,
                filter,
                filter_map,
                partition,
                split,
                is_empty,
                mem,
                equal,
                compare,
                subset,
                for_all,
                exists,
                elements,
                of_list,
                to_seq_from,
                to_seq,
                to_rev_seq,
                add_seq,
                of_seq];
       }];
   runtime.caml_register_global(12, Stdlib_Set, "Stdlib__Set");
   return;
  }
  (globalThis));

//# 8705 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Map_bal$3 = "Map.bal",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Assert_failure = global_data.Assert_failure,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_List = global_data.Stdlib__List,
    cst_Map_bal = cst_Map_bal$3,
    cst_Map_bal$0 = cst_Map_bal$3,
    cst_Map_bal$1 = cst_Map_bal$3,
    cst_Map_bal$2 = cst_Map_bal$3,
    cst_Map_remove_min_elt = "Map.remove_min_elt",
    _a_ = [0, 0, 0, 0],
    _b_ = [0, "map.ml", 408, 10],
    _c_ = [0, 0, 0],
    Stdlib_Map =
      [0,
       function(Ord){
        function height(param){
         if(! param) return 0;
         var h = param[5];
         return h;
        }
        function create(l, x, d, r){
         var
          hl = height(l),
          hr = height(r),
          _K_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
         return [0, l, x, d, r, _K_];
        }
        function singleton(x, d){return [0, 0, x, d, 0, 1];}
        function bal(l, x, d, r){
         if(l) var h = l[5], hl = h; else var hl = 0;
         if(r) var h$0 = r[5], hr = h$0; else var hr = 0;
         if((hr + 2 | 0) < hl){
          if(! l) return caml_call1(Stdlib[1], cst_Map_bal$0);
          var lr = l[4], ld = l[3], lv = l[2], ll = l[1], _F_ = height(lr);
          if(_F_ <= height(ll))
           return create(ll, lv, ld, create(lr, x, d, r));
          if(! lr) return caml_call1(Stdlib[1], cst_Map_bal);
          var
           lrr = lr[4],
           lrd = lr[3],
           lrv = lr[2],
           lrl = lr[1],
           _G_ = create(lrr, x, d, r);
          return create(create(ll, lv, ld, lrl), lrv, lrd, _G_);
         }
         if((hl + 2 | 0) >= hr){
          var _J_ = hr <= hl ? hl + 1 | 0 : hr + 1 | 0;
          return [0, l, x, d, r, _J_];
         }
         if(! r) return caml_call1(Stdlib[1], cst_Map_bal$2);
         var rr = r[4], rd = r[3], rv = r[2], rl = r[1], _H_ = height(rl);
         if(_H_ <= height(rr)) return create(create(l, x, d, rl), rv, rd, rr);
         if(! rl) return caml_call1(Stdlib[1], cst_Map_bal$1);
         var
          rlr = rl[4],
          rld = rl[3],
          rlv = rl[2],
          rll = rl[1],
          _I_ = create(rlr, rv, rd, rr);
         return create(create(l, x, d, rll), rlv, rld, _I_);
        }
        var empty = 0;
        function is_empty(param){return param ? 0 : 1;}
        function add(x, data, m){
         if(! m) return [0, 0, x, data, 0, 1];
         var
          h = m[5],
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
          c = caml_call2(Ord[1], x, v);
         if(0 === c) return d === data ? m : [0, l, x, data, r, h];
         if(0 <= c){
          var rr = add(x, data, r);
          return r === rr ? m : bal(l, v, d, rr);
         }
         var ll = add(x, data, l);
         return l === ll ? m : bal(ll, v, d, r);
        }
        function find(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
           c = caml_call2(Ord[1], x, v);
          if(0 === c) return d;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function find_first(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = l$0;
           for(;;){
            if(! param) return [0, v0, d0];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_first_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) return 0;
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = l$0;
           for(;;){
            if(! param) return [0, [0, v0, d0]];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = l;
            else
             var param = r;
           }
          }
          else
           var param$1 = r$0;
         }
        }
        function find_last(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = r$0;
           for(;;){
            if(! param) return [0, v0, d0];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_last_opt(f, param$0){
         var param$1 = param$0;
         for(;;){
          if(! param$1) return 0;
          var
           r$0 = param$1[4],
           d0$1 = param$1[3],
           v0$1 = param$1[2],
           l$0 = param$1[1];
          if(caml_call1(f, v0$1)){
           var v0 = v0$1, d0 = d0$1, param = r$0;
           for(;;){
            if(! param) return [0, [0, v0, d0]];
            var r = param[4], d0$0 = param[3], v0$0 = param[2], l = param[1];
            if(caml_call1(f, v0$0))
             var v0 = v0$0, d0 = d0$0, param = r;
            else
             var param = l;
           }
          }
          else
           var param$1 = l$0;
         }
        }
        function find_opt(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
           c = caml_call2(Ord[1], x, v);
          if(0 === c) return [0, d];
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function mem(x, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var
           r = param$0[4],
           v = param$0[2],
           l = param$0[1],
           c = caml_call2(Ord[1], x, v),
           _E_ = 0 === c ? 1 : 0;
          if(_E_) return _E_;
          var r$0 = 0 <= c ? r : l, param$0 = r$0;
         }
        }
        function min_binding(param){
         var param$0 = param;
         for(;;){
          if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          var l = param$0[1];
          if(! l){var d = param$0[3], v = param$0[2]; return [0, v, d];}
          var param$0 = l;
         }
        }
        function min_binding_opt(param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var l = param$0[1];
          if(! l){var d = param$0[3], v = param$0[2]; return [0, [0, v, d]];}
          var param$0 = l;
         }
        }
        function max_binding(param){
         var param$0 = param;
         for(;;){
          if(! param$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
          if(! param$0[4]){
           var d = param$0[3], v = param$0[2];
           return [0, v, d];
          }
          var r = param$0[4], param$0 = r;
         }
        }
        function max_binding_opt(param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          if(! param$0[4]){
           var d = param$0[3], v = param$0[2];
           return [0, [0, v, d]];
          }
          var r = param$0[4], param$0 = r;
         }
        }
        function remove_min_binding(param){
         if(! param) return caml_call1(Stdlib[1], cst_Map_remove_min_elt);
         var l = param[1];
         if(l){
          var r = param[4], d = param[3], v = param[2];
          return bal(remove_min_binding(l), v, d, r);
         }
         var r$0 = param[4];
         return r$0;
        }
        function _d_(t1, t2){
         if(! t1) return t2;
         if(! t2) return t1;
         var match = min_binding(t2), d = match[2], x = match[1];
         return bal(t1, x, d, remove_min_binding(t2));
        }
        function remove(x, m){
         if(! m) return 0;
         var
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
          c = caml_call2(Ord[1], x, v);
         if(0 === c) return _d_(l, r);
         if(0 <= c){
          var rr = remove(x, r);
          return r === rr ? m : bal(l, v, d, rr);
         }
         var ll = remove(x, l);
         return l === ll ? m : bal(ll, v, d, r);
        }
        function update(x, f, m){
         if(! m){
          var match$0 = caml_call1(f, 0);
          if(! match$0) return 0;
          var data$0 = match$0[1];
          return [0, 0, x, data$0, 0, 1];
         }
         var
          h = m[5],
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
          c = caml_call2(Ord[1], x, v);
         if(0 === c){
          var match = caml_call1(f, [0, d]);
          if(! match) return _d_(l, r);
          var data = match[1];
          return d === data ? m : [0, l, x, data, r, h];
         }
         if(0 <= c){
          var rr = update(x, f, r);
          return r === rr ? m : bal(l, v, d, rr);
         }
         var ll = update(x, f, l);
         return l === ll ? m : bal(ll, v, d, r);
        }
        function add_to_list(x, data, m){
         function add(param){
          if(! param) return [0, [0, data, 0]];
          var l = param[1];
          return [0, [0, data, l]];
         }
         return update(x, add, m);
        }
        function iter(f, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var r = param$0[4], d = param$0[3], v = param$0[2], l = param$0[1];
          iter(f, l);
          caml_call2(f, v, d);
          var param$0 = r;
         }
        }
        function map(f, param){
         if(! param) return 0;
         var
          h = param[5],
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
          l$0 = map(f, l),
          d$0 = caml_call1(f, d),
          r$0 = map(f, r);
         return [0, l$0, v, d$0, r$0, h];
        }
        function mapi(f, param){
         if(! param) return 0;
         var
          h = param[5],
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
          l$0 = mapi(f, l),
          d$0 = caml_call2(f, v, d),
          r$0 = mapi(f, r);
         return [0, l$0, v, d$0, r$0, h];
        }
        function fold(f, m, accu){
         var m$0 = m, accu$0 = accu;
         for(;;){
          if(! m$0) return accu$0;
          var
           r = m$0[4],
           d = m$0[3],
           v = m$0[2],
           l = m$0[1],
           accu$1 = caml_call3(f, v, d, fold(f, l, accu$0)),
           m$0 = r,
           accu$0 = accu$1;
         }
        }
        function for_all(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 1;
          var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
           _B_ = caml_call2(p, v, d);
          if(_B_){
           var _C_ = for_all(p, l);
           if(_C_){var param$0 = r; continue;}
           var _D_ = _C_;
          }
          else
           var _D_ = _B_;
          return _D_;
         }
        }
        function exists(p, param){
         var param$0 = param;
         for(;;){
          if(! param$0) return 0;
          var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
           _y_ = caml_call2(p, v, d);
          if(_y_)
           var _z_ = _y_;
          else{
           var _A_ = exists(p, l);
           if(! _A_){var param$0 = r; continue;}
           var _z_ = _A_;
          }
          return _z_;
         }
        }
        function add_min_binding(k, x, param){
         if(! param) return singleton(k, x);
         var r = param[4], d = param[3], v = param[2], l = param[1];
         return bal(add_min_binding(k, x, l), v, d, r);
        }
        function add_max_binding(k, x, param){
         if(! param) return singleton(k, x);
         var r = param[4], d = param[3], v = param[2], l = param[1];
         return bal(l, v, d, add_max_binding(k, x, r));
        }
        function join(l, v, d, r){
         if(! l) return add_min_binding(v, d, r);
         if(! r) return add_max_binding(v, d, l);
         var
          rh = r[5],
          rr = r[4],
          rd = r[3],
          rv = r[2],
          rl = r[1],
          lh = l[5],
          lr = l[4],
          ld = l[3],
          lv = l[2],
          ll = l[1];
         return (rh + 2 | 0) < lh
                 ? bal(ll, lv, ld, join(lr, v, d, r))
                 : (lh
                   + 2
                   | 0)
                   < rh
                   ? bal(join(l, v, d, rl), rv, rd, rr)
                   : create(l, v, d, r);
        }
        function concat(t1, t2){
         if(! t1) return t2;
         if(! t2) return t1;
         var match = min_binding(t2), d = match[2], x = match[1];
         return join(t1, x, d, remove_min_binding(t2));
        }
        function concat_or_join(t1, v, d, t2){
         if(! d) return concat(t1, t2);
         var d$0 = d[1];
         return join(t1, v, d$0, t2);
        }
        function split(x, param){
         if(! param) return _a_;
         var
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
          c = caml_call2(Ord[1], x, v);
         if(0 === c) return [0, l, [0, d], r];
         if(0 <= c){
          var
           match = split(x, r),
           rr = match[3],
           pres = match[2],
           lr = match[1];
          return [0, join(l, v, d, lr), pres, rr];
         }
         var
          match$0 = split(x, l),
          rl = match$0[3],
          pres$0 = match$0[2],
          ll = match$0[1];
         return [0, ll, pres$0, join(rl, v, d, r)];
        }
        function merge(f, s1, s2){
         if(s1){
          var h1 = s1[5], r1 = s1[4], d1 = s1[3], v1 = s1[2], l1 = s1[1];
          if(height(s2) <= h1){
           var
            match = split(v1, s2),
            r2 = match[3],
            d2 = match[2],
            l2 = match[1],
            _u_ = merge(f, r1, r2),
            _v_ = caml_call3(f, v1, [0, d1], d2);
           return concat_or_join(merge(f, l1, l2), v1, _v_, _u_);
          }
         }
         else if(! s2) return 0;
         if(! s2)
          throw caml_maybe_attach_backtrace([0, Assert_failure, _b_], 1);
         var
          r2$0 = s2[4],
          d2$0 = s2[3],
          v2 = s2[2],
          l2$0 = s2[1],
          match$0 = split(v2, s1),
          r1$0 = match$0[3],
          d1$0 = match$0[2],
          l1$0 = match$0[1],
          _w_ = merge(f, r1$0, r2$0),
          _x_ = caml_call3(f, v2, d1$0, [0, d2$0]);
         return concat_or_join(merge(f, l1$0, l2$0), v2, _x_, _w_);
        }
        function union(f, s1, s2){
         if(s1){
          if(s2){
           var
            h2 = s2[5],
            r2 = s2[4],
            d2 = s2[3],
            v2 = s2[2],
            l2 = s2[1],
            h1 = s1[5],
            r1 = s1[4],
            d1 = s1[3],
            v1 = s1[2],
            l1 = s1[1];
           if(h2 <= h1){
            var
             match = split(v1, s2),
             r2$0 = match[3],
             d2$0 = match[2],
             l2$0 = match[1],
             l = union(f, l1, l2$0),
             r = union(f, r1, r2$0);
            if(! d2$0) return join(l, v1, d1, r);
            var d2$1 = d2$0[1];
            return concat_or_join(l, v1, caml_call3(f, v1, d1, d2$1), r);
           }
           var
            match$0 = split(v2, s1),
            r1$0 = match$0[3],
            d1$0 = match$0[2],
            l1$0 = match$0[1],
            l$0 = union(f, l1$0, l2),
            r$0 = union(f, r1$0, r2);
           if(! d1$0) return join(l$0, v2, d2, r$0);
           var d1$1 = d1$0[1];
           return concat_or_join(l$0, v2, caml_call3(f, v2, d1$1, d2), r$0);
          }
          var s = s1;
         }
         else
          var s = s2;
         return s;
        }
        function filter(p, m){
         if(! m) return 0;
         var
          r = m[4],
          d = m[3],
          v = m[2],
          l = m[1],
          l$0 = filter(p, l),
          pvd = caml_call2(p, v, d),
          r$0 = filter(p, r);
         if(! pvd) return concat(l$0, r$0);
         if(l === l$0 && r === r$0) return m;
         return join(l$0, v, d, r$0);
        }
        function filter_map(f, param){
         if(! param) return 0;
         var
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
          l$0 = filter_map(f, l),
          fvd = caml_call2(f, v, d),
          r$0 = filter_map(f, r);
         if(! fvd) return concat(l$0, r$0);
         var d$0 = fvd[1];
         return join(l$0, v, d$0, r$0);
        }
        function partition(p, param){
         if(! param) return _c_;
         var
          r = param[4],
          d = param[3],
          v = param[2],
          l = param[1],
          match = partition(p, l),
          lf = match[2],
          lt = match[1],
          pvd = caml_call2(p, v, d),
          match$0 = partition(p, r),
          rf = match$0[2],
          rt = match$0[1];
         if(pvd){
          var _s_ = concat(lf, rf);
          return [0, join(lt, v, d, rt), _s_];
         }
         var _t_ = join(lf, v, d, rf);
         return [0, concat(lt, rt), _t_];
        }
        function cons_enum(m, e){
         var m$0 = m, e$0 = e;
         for(;;){
          if(! m$0) return e$0;
          var
           r = m$0[4],
           d = m$0[3],
           v = m$0[2],
           l = m$0[1],
           e$1 = [0, v, d, r, e$0],
           m$0 = l,
           e$0 = e$1;
         }
        }
        function compare(cmp, m1, m2){
         var
          e2$2 = cons_enum(m2, 0),
          e1$2 = cons_enum(m1, 0),
          e1 = e1$2,
          e2 = e2$2;
         for(;;){
          if(! e1) return e2 ? -1 : 0;
          if(! e2) return 1;
          var
           e2$0 = e2[4],
           r2 = e2[3],
           d2 = e2[2],
           v2 = e2[1],
           e1$0 = e1[4],
           r1 = e1[3],
           d1 = e1[2],
           v1 = e1[1],
           c = caml_call2(Ord[1], v1, v2);
          if(0 !== c) return c;
          var c$0 = caml_call2(cmp, d1, d2);
          if(0 !== c$0) return c$0;
          var
           e2$1 = cons_enum(r2, e2$0),
           e1$1 = cons_enum(r1, e1$0),
           e1 = e1$1,
           e2 = e2$1;
         }
        }
        function equal(cmp, m1, m2){
         var
          e2$2 = cons_enum(m2, 0),
          e1$2 = cons_enum(m1, 0),
          e1 = e1$2,
          e2 = e2$2;
         for(;;){
          if(! e1) return e2 ? 0 : 1;
          if(! e2) return 0;
          var
           e2$0 = e2[4],
           r2 = e2[3],
           d2 = e2[2],
           v2 = e2[1],
           e1$0 = e1[4],
           r1 = e1[3],
           d1 = e1[2],
           v1 = e1[1],
           _p_ = 0 === caml_call2(Ord[1], v1, v2) ? 1 : 0;
          if(_p_){
           var _q_ = caml_call2(cmp, d1, d2);
           if(_q_){
            var
             e2$1 = cons_enum(r2, e2$0),
             e1$1 = cons_enum(r1, e1$0),
             e1 = e1$1,
             e2 = e2$1;
            continue;
           }
           var _r_ = _q_;
          }
          else
           var _r_ = _p_;
          return _r_;
         }
        }
        function cardinal(param){
         if(! param) return 0;
         var r = param[4], l = param[1], _o_ = cardinal(r);
         return (cardinal(l) + 1 | 0) + _o_ | 0;
        }
        function bindings_aux(accu, param){
         var accu$0 = accu, param$0 = param;
         for(;;){
          if(! param$0) return accu$0;
          var
           r = param$0[4],
           d = param$0[3],
           v = param$0[2],
           l = param$0[1],
           accu$1 = [0, [0, v, d], bindings_aux(accu$0, r)],
           accu$0 = accu$1,
           param$0 = l;
         }
        }
        function bindings(s){return bindings_aux(0, s);}
        function of_list(bs){
         return caml_call3
                 (Stdlib_List[26],
                  function(m, param){
                   var v = param[2], k = param[1];
                   return add(k, v, m);
                  },
                  empty,
                  bs);
        }
        function add_seq(i, m){
         return caml_call3
                 (Stdlib_Seq[5],
                  function(m, param){
                   var v = param[2], k = param[1];
                   return add(k, v, m);
                  },
                  m,
                  i);
        }
        function of_seq(i){return add_seq(i, empty);}
        function seq_of_enum(c, param){
         if(! c) return 0;
         var
          rest = c[4],
          t = c[3],
          v = c[2],
          k = c[1],
          _m_ = cons_enum(t, rest);
         return [0, [0, k, v], function(_n_){return seq_of_enum(_m_, _n_);}];
        }
        function to_seq(m){
         var _k_ = cons_enum(m, 0);
         return function(_l_){return seq_of_enum(_k_, _l_);};
        }
        function snoc_enum(s, e){
         var s$0 = s, e$0 = e;
         for(;;){
          if(! s$0) return e$0;
          var
           r = s$0[4],
           d = s$0[3],
           v = s$0[2],
           l = s$0[1],
           e$1 = [0, v, d, l, e$0],
           s$0 = r,
           e$0 = e$1;
         }
        }
        function rev_seq_of_enum(c, param){
         if(! c) return 0;
         var
          rest = c[4],
          t = c[3],
          v = c[2],
          k = c[1],
          _i_ = snoc_enum(t, rest);
         return [0,
                 [0, k, v],
                 function(_j_){return rev_seq_of_enum(_i_, _j_);}];
        }
        function to_rev_seq(c){
         var _g_ = snoc_enum(c, 0);
         return function(_h_){return rev_seq_of_enum(_g_, _h_);};
        }
        function to_seq_from(low, m){
         a:
         {
          b:
          {
           var m$0 = m, c = 0;
           for(;;){
            if(! m$0) break;
            var
             r = m$0[4],
             d = m$0[3],
             v = m$0[2],
             l = m$0[1],
             n = caml_call2(Ord[1], v, low);
            if(0 === n) break b;
            if(0 <= n)
             var c$0 = [0, v, d, r, c], m$0 = l, c = c$0;
            else
             var m$0 = r;
           }
           var _e_ = c;
           break a;
          }
          var _e_ = [0, v, d, r, c];
         }
         return function(_f_){return seq_of_enum(_e_, _f_);};
        }
        return [0,
                empty,
                add,
                add_to_list,
                update,
                singleton,
                remove,
                merge,
                union,
                cardinal,
                bindings,
                min_binding,
                min_binding_opt,
                max_binding,
                max_binding_opt,
                min_binding,
                min_binding_opt,
                find,
                find_opt,
                find_first,
                find_first_opt,
                find_last,
                find_last_opt,
                iter,
                fold,
                map,
                mapi,
                filter,
                filter_map,
                partition,
                split,
                is_empty,
                mem,
                equal,
                compare,
                for_all,
                exists,
                bindings,
                of_list,
                to_seq,
                to_rev_seq,
                to_seq_from,
                add_seq,
                of_seq];
       }];
   runtime.caml_register_global(12, Stdlib_Map, "Stdlib__Map");
   return;
  }
  (globalThis));

//# 9577 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_List = global_data.Stdlib__List,
    Empty = [248, "Stdlib.Stack.Empty", runtime.caml_fresh_oo_id(0)];
   function create(param){return [0, 0, 0];}
   function clear(s){s[1] = 0; s[2] = 0; return 0;}
   function copy(s){return [0, s[1], s[2]];}
   function push(x, s){s[1] = [0, x, s[1]]; s[2] = s[2] + 1 | 0; return 0;}
   function pop(s){
    var match = s[1];
    if(! match) throw caml_maybe_attach_backtrace(Empty, 1);
    var tl = match[2], hd = match[1];
    s[1] = tl;
    s[2] = s[2] - 1 | 0;
    return hd;
   }
   function pop_opt(s){
    var match = s[1];
    if(! match) return 0;
    var tl = match[2], hd = match[1];
    s[1] = tl;
    s[2] = s[2] - 1 | 0;
    return [0, hd];
   }
   function drop(s){
    var match = s[1];
    if(! match) throw caml_maybe_attach_backtrace(Empty, 1);
    var tl = match[2];
    s[1] = tl;
    s[2] = s[2] - 1 | 0;
    return 0;
   }
   function top(s){
    var match = s[1];
    if(! match) throw caml_maybe_attach_backtrace(Empty, 1);
    var hd = match[1];
    return hd;
   }
   function top_opt(s){
    var match = s[1];
    if(! match) return 0;
    var hd = match[1];
    return [0, hd];
   }
   function is_empty(s){return 0 === s[1] ? 1 : 0;}
   function length(s){return s[2];}
   function iter(f, s){return caml_call2(Stdlib_List[18], f, s[1]);}
   function fold(f, acc, s){return caml_call3(Stdlib_List[26], f, acc, s[1]);}
   function to_seq(s){return caml_call1(Stdlib_List[64], s[1]);}
   function add_seq(q, i){
    return caml_call2(Stdlib_Seq[4], function(x){return push(x, q);}, i);
   }
   function of_seq(g){var s = create(0); add_seq(s, g); return s;}
   var
    Stdlib_Stack =
      [0,
       Empty,
       create,
       push,
       pop,
       pop_opt,
       drop,
       top,
       top_opt,
       clear,
       copy,
       is_empty,
       length,
       iter,
       fold,
       to_seq,
       add_seq,
       of_seq];
   runtime.caml_register_global(3, Stdlib_Stack, "Stdlib__Stack");
   return;
  }
  (globalThis));

//# 9679 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Seq = global_data.Stdlib__Seq,
    Empty = [248, "Stdlib.Queue.Empty", runtime.caml_fresh_oo_id(0)];
   function create(param){return [0, 0, 0, 0];}
   function clear(q){q[1] = 0; q[2] = 0; q[3] = 0; return 0;}
   function add(x, q){
    var cell = [0, x, 0], match = q[3];
    return match
            ? (q[1] = q[1] + 1 | 0, match[2] = cell, q[3] = cell, 0)
            : (q[1] = 1, q[2] = cell, q[3] = cell, 0);
   }
   function peek(q){
    var match = q[2];
    if(! match) throw caml_maybe_attach_backtrace(Empty, 1);
    var content = match[1];
    return content;
   }
   function peek_opt(q){
    var match = q[2];
    if(! match) return 0;
    var content = match[1];
    return [0, content];
   }
   function take(q){
    var _f_ = q[2];
    if(! _f_) throw caml_maybe_attach_backtrace(Empty, 1);
    var content = _f_[1];
    if(_f_[2]){
     var next = _f_[2];
     q[1] = q[1] - 1 | 0;
     q[2] = next;
     return content;
    }
    clear(q);
    return content;
   }
   function take_opt(q){
    var _e_ = q[2];
    if(! _e_) return 0;
    var content = _e_[1];
    if(_e_[2]){
     var next = _e_[2];
     q[1] = q[1] - 1 | 0;
     q[2] = next;
     return [0, content];
    }
    clear(q);
    return [0, content];
   }
   function copy(q){
    var cell$0 = q[2], q_res = [0, q[1], 0, 0], prev = 0, cell = cell$0;
    for(;;){
     if(! cell){q_res[3] = prev; return q_res;}
     var content = cell[1], next = cell[2], prev$0 = [0, content, 0];
     if(prev) prev[2] = prev$0; else q_res[2] = prev$0;
     var prev = prev$0, cell = next;
    }
   }
   function is_empty(q){return 0 === q[1] ? 1 : 0;}
   function length(q){return q[1];}
   function iter(f, q){
    var cell$0 = q[2], cell = cell$0;
    for(;;){
     if(! cell) return 0;
     var content = cell[1], next = cell[2];
     caml_call1(f, content);
     var cell = next;
    }
   }
   function fold(f, accu$1, q){
    var cell$0 = q[2], accu = accu$1, cell = cell$0;
    for(;;){
     if(! cell) return accu;
     var
      content = cell[1],
      next = cell[2],
      accu$0 = caml_call2(f, accu, content),
      accu = accu$0,
      cell = next;
    }
   }
   function transfer(q1, q2){
    var _d_ = 0 < q1[1] ? 1 : 0;
    if(! _d_) return _d_;
    var match = q2[3];
    return match
            ? (q2
               [1]
              = q2[1] + q1[1] | 0,
              match[2] = q1[2],
              q2[3] = q1[3],
              clear(q1))
            : (q2[1] = q1[1], q2[2] = q1[2], q2[3] = q1[3], clear(q1));
   }
   function to_seq(q){
    function aux(c, param){
     if(! c) return 0;
     var x = c[1], next = c[2];
     return [0, x, function(_c_){return aux(next, _c_);}];
    }
    var _a_ = q[2];
    return function(_b_){return aux(_a_, _b_);};
   }
   function add_seq(q, i){
    return caml_call2(Stdlib_Seq[4], function(x){return add(x, q);}, i);
   }
   function of_seq(g){var q = create(0); add_seq(q, g); return q;}
   var
    Stdlib_Queue =
      [0,
       Empty,
       create,
       add,
       add,
       take,
       take_opt,
       take,
       peek,
       peek_opt,
       peek,
       clear,
       copy,
       is_empty,
       length,
       iter,
       fold,
       transfer,
       to_seq,
       add_seq,
       of_seq];
   runtime.caml_register_global(2, Stdlib_Queue, "Stdlib__Queue");
   return;
  }
  (globalThis));

//# 9833 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_blit_string = runtime.caml_blit_string,
    caml_bswap16 = runtime.caml_bswap16,
    caml_bytes_get = runtime.caml_bytes_get,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_bytes_set16 = runtime.caml_bytes_set16,
    caml_bytes_set32 = runtime.caml_bytes_set32,
    caml_bytes_set64 = runtime.caml_bytes_set64,
    caml_bytes_unsafe_set = runtime.caml_bytes_unsafe_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_int32_bswap = runtime.caml_int32_bswap,
    caml_int64_bswap = runtime.caml_int64_bswap,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_bytes_length = runtime.caml_ml_bytes_length,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_get = runtime.caml_string_get;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
   function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib = global_data.Stdlib,
    Stdlib_String = global_data.Stdlib__String,
    Assert_failure = global_data.Assert_failure,
    cst_Buffer_sub = "Buffer.sub",
    cst_Buffer_blit = "Buffer.blit",
    cst_Buffer_nth = "Buffer.nth",
    cst_Buffer_add_cannot_grow_buf = "Buffer.add: cannot grow buffer";
   function create(n){
    var
     n$0 = 1 <= n ? n : 1,
     n$1 = Stdlib_Sys[12] < n$0 ? Stdlib_Sys[12] : n$0,
     s = caml_create_bytes(n$1);
    return [0, [0, s, n$1], 0, s];
   }
   function contents(b){return caml_call3(Stdlib_Bytes[8], b[1][1], 0, b[2]);}
   function to_bytes(b){return caml_call3(Stdlib_Bytes[7], b[1][1], 0, b[2]);}
   function sub(b, ofs, len){
    if(0 <= ofs && 0 <= len && (b[2] - len | 0) >= ofs)
     return caml_call3(Stdlib_Bytes[8], b[1][1], ofs, len);
    return caml_call1(Stdlib[1], cst_Buffer_sub);
   }
   function blit(src, srcoff, dst, dstoff, len){
    if
     (0 <= len
      &&
       0 <= srcoff
       &&
        (src[2] - len | 0) >= srcoff
        && 0 <= dstoff && (caml_ml_bytes_length(dst) - len | 0) >= dstoff)
     return caml_call5(Stdlib_Bytes[11], src[1][1], srcoff, dst, dstoff, len);
    return caml_call1(Stdlib[1], cst_Buffer_blit);
   }
   function nth(b, ofs){
    var position = b[2], match = b[1], length = match[2], buffer = match[1];
    if(0 <= ofs && position > ofs && length >= position)
     return runtime.caml_bytes_unsafe_get(buffer, ofs);
    return caml_call1(Stdlib[1], cst_Buffer_nth);
   }
   function length(b){return b[2];}
   function clear(b){b[2] = 0; return 0;}
   function reset(b){
    b[2] = 0;
    var inner = [0, b[3], caml_ml_bytes_length(b[3])];
    b[1] = inner;
    return 0;
   }
   function resize(b, more){
    var old_pos = b[2], old_len = b[1][2], new_len = [0, old_len];
    for(;;){
     if(new_len[1] >= (old_pos + more | 0)) break;
     new_len[1] = 2 * new_len[1] | 0;
    }
    if(Stdlib_Sys[12] < new_len[1])
     if((old_pos + more | 0) <= Stdlib_Sys[12])
      new_len[1] = Stdlib_Sys[12];
     else
      caml_call1(Stdlib[2], cst_Buffer_add_cannot_grow_buf);
    var new_buffer = caml_create_bytes(new_len[1]);
    caml_call5(Stdlib_Bytes[11], b[1][1], 0, new_buffer, 0, b[2]);
    b[1] = [0, new_buffer, new_len[1]];
    return;
   }
   function add_char(b, c){
    var pos = b[2], match = b[1], length = match[2], buffer = match[1];
    if(length <= pos){
     resize(b, 1);
     caml_bytes_set(b[1][1], b[2], c);
    }
    else
     caml_bytes_unsafe_set(buffer, pos, c);
    b[2] = pos + 1 | 0;
    return 0;
   }
   var
    uchar_utf_8_byte_length_max = 4,
    uchar_utf_16_byte_length_max = 4,
    cst_Buffer_add_substring_add_s = "Buffer.add_substring/add_subbytes",
    cst_Buffer_add_channel = "Buffer.add_channel",
    _a_ = [0, "buffer.ml", 220, 9],
    cst_Buffer_truncate = "Buffer.truncate";
   function add_utf_8_uchar(b, u){
    for(;;){
     var pos = b[2];
     if(b[1][2] <= pos) resize(b, uchar_utf_8_byte_length_max);
     var n = caml_call3(Stdlib_Bytes[51], b[1][1], pos, u);
     if(0 !== n){b[2] = pos + n | 0; return 0;}
     resize(b, uchar_utf_8_byte_length_max);
    }
   }
   function add_utf_16be_uchar(b, u){
    for(;;){
     var pos = b[2];
     if(b[1][2] <= pos) resize(b, uchar_utf_16_byte_length_max);
     var n = caml_call3(Stdlib_Bytes[54], b[1][1], pos, u);
     if(0 !== n){b[2] = pos + n | 0; return 0;}
     resize(b, uchar_utf_16_byte_length_max);
    }
   }
   function add_utf_16le_uchar(b, u){
    for(;;){
     var pos = b[2];
     if(b[1][2] <= pos) resize(b, uchar_utf_16_byte_length_max);
     var n = caml_call3(Stdlib_Bytes[57], b[1][1], pos, u);
     if(0 !== n){b[2] = pos + n | 0; return 0;}
     resize(b, uchar_utf_16_byte_length_max);
    }
   }
   function add_substring(b, s, offset, len){
    var _q_ = offset < 0 ? 1 : 0;
    if(_q_)
     var _r_ = _q_;
    else
     var
      _s_ = len < 0 ? 1 : 0,
      _r_ = _s_ || ((caml_ml_string_length(s) - len | 0) < offset ? 1 : 0);
    if(_r_) caml_call1(Stdlib[1], cst_Buffer_add_substring_add_s);
    var
     position = b[2],
     match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + len | 0;
    if(length < new_position){
     resize(b, len);
     caml_call5(Stdlib_Bytes[12], s, offset, b[1][1], b[2], len);
    }
    else
     caml_blit_string(s, offset, buffer, position, len);
    b[2] = new_position;
    return 0;
   }
   function add_subbytes(b, s, offset, len){
    return add_substring(b, caml_call1(Stdlib_Bytes[44], s), offset, len);
   }
   function add_string(b, s){
    var
     len = caml_ml_string_length(s),
     position = b[2],
     match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + len | 0;
    if(length < new_position){
     resize(b, len);
     caml_call5(Stdlib_Bytes[12], s, 0, b[1][1], b[2], len);
    }
    else
     caml_blit_string(s, 0, buffer, position, len);
    b[2] = new_position;
    return 0;
   }
   function add_bytes(b, s){
    return add_string(b, caml_call1(Stdlib_Bytes[44], s));
   }
   function add_buffer(b, bs){return add_subbytes(b, bs[1][1], 0, bs[2]);}
   function add_channel(b, ic, to_read$1){
    var
     _o_ = to_read$1 < 0 ? 1 : 0,
     _p_ = _o_ || (Stdlib_Sys[12] < to_read$1 ? 1 : 0);
    if(_p_) caml_call1(Stdlib[1], cst_Buffer_add_channel);
    if(b[1][2] < (b[2] + to_read$1 | 0)) resize(b, to_read$1);
    var
     ofs$1 = b[2],
     buf = b[1][1],
     already_read = 0,
     ofs = ofs$1,
     to_read = to_read$1;
    for(;;){
     if(0 !== to_read){
      var r = caml_call4(Stdlib[84], ic, buf, ofs, to_read);
      if(0 !== r){
       var
        already_read$0 = already_read + r | 0,
        ofs$0 = ofs + r | 0,
        to_read$0 = to_read - r | 0,
        already_read = already_read$0,
        ofs = ofs$0,
        to_read = to_read$0;
       continue;
      }
     }
     b[2] = b[2] + already_read | 0;
     if(already_read < to_read$1)
      throw caml_maybe_attach_backtrace(Stdlib[12], 1);
     return 0;
    }
   }
   function output_buffer(oc, b){
    return caml_call4(Stdlib[68], oc, b[1][1], 0, b[2]);
   }
   function add_substitute(b, f, s){
    var lim$1 = caml_ml_string_length(s), previous = 32, i$4 = 0;
    for(;;){
     if(i$4 >= lim$1){
      var _n_ = 92 === previous ? 1 : 0;
      return _n_ ? add_char(b, previous) : _n_;
     }
     var previous$0 = caml_string_get(s, i$4);
     if(36 === previous$0)
      if(92 === previous){
       add_char(b, previous$0);
       var i$5 = i$4 + 1 | 0, previous = 32, i$4 = i$5;
      }
      else{
       var start$0 = i$4 + 1 | 0;
       if(lim$1 <= start$0) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
       var opening = caml_string_get(s, start$0);
       a:
       {
        if(40 !== opening && 123 !== opening){
         var start = start$0 + 1 | 0, lim$0 = caml_ml_string_length(s);
         b:
         {
          c:
          {
           d:
           {
            var i$2 = start;
            for(;;){
             if(lim$0 <= i$2) break c;
             var match = caml_string_get(s, i$2);
             if(91 <= match){
              if(97 <= match){
               if(123 <= match) break d;
              }
              else if(95 !== match) break d;
             }
             else
              if(58 <= match){
               if(65 > match) break;
              }
              else if(48 > match) break d;
             var i$3 = i$2 + 1 | 0, i$2 = i$3;
            }
           }
           var stop$0 = i$2;
           break b;
          }
          var stop$0 = lim$0;
         }
         var
          match$0 =
            [0,
             caml_call3(Stdlib_String[16], s, start$0, stop$0 - start$0 | 0),
             stop$0];
         break a;
        }
        var new_start = start$0 + 1 | 0, k$2 = 0;
        if(40 === opening)
         var closing = 41;
        else{
         if(123 !== opening)
          throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
         var closing = 125;
        }
        var lim = caml_ml_string_length(s), k = k$2, stop = new_start;
        for(;;){
         if(lim <= stop) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
         if(caml_string_get(s, stop) === opening)
          var i = stop + 1 | 0, k$0 = k + 1 | 0, k = k$0, stop = i;
         else if(caml_string_get(s, stop) === closing){
          if(0 === k) break;
          var i$0 = stop + 1 | 0, k$1 = k - 1 | 0, k = k$1, stop = i$0;
         }
         else
          var i$1 = stop + 1 | 0, stop = i$1;
        }
        var
         match$0 =
           [0,
            caml_call3
             (Stdlib_String[16], s, new_start, (stop - start$0 | 0) - 1 | 0),
            stop + 1 | 0];
       }
       var next_i = match$0[2], ident = match$0[1];
       add_string(b, caml_call1(f, ident));
       var previous = 32, i$4 = next_i;
      }
     else if(92 === previous){
      add_char(b, 92);
      add_char(b, previous$0);
      var i$6 = i$4 + 1 | 0, previous = 32, i$4 = i$6;
     }
     else if(92 === previous$0)
      var i$7 = i$4 + 1 | 0, previous = previous$0, i$4 = i$7;
     else{
      add_char(b, previous$0);
      var i$8 = i$4 + 1 | 0, previous = previous$0, i$4 = i$8;
     }
    }
   }
   function truncate(b, len){
    if(0 <= len && b[2] >= len){b[2] = len; return 0;}
    return caml_call1(Stdlib[1], cst_Buffer_truncate);
   }
   function to_seq(b){
    function aux(i, param){
     if(b[2] <= i) return 0;
     var x = caml_bytes_get(b[1][1], i), _l_ = i + 1 | 0;
     return [0, x, function(_m_){return aux(_l_, _m_);}];
    }
    var _j_ = 0;
    return function(_k_){return aux(_j_, _k_);};
   }
   function to_seqi(b){
    function aux(i, param){
     if(b[2] <= i) return 0;
     var x = caml_bytes_get(b[1][1], i), _h_ = i + 1 | 0;
     return [0, [0, i, x], function(_i_){return aux(_h_, _i_);}];
    }
    var _f_ = 0;
    return function(_g_){return aux(_f_, _g_);};
   }
   function add_seq(b, seq){
    return caml_call2
            (Stdlib_Seq[4], function(_e_){return add_char(b, _e_);}, seq);
   }
   function of_seq(i){var b = create(32); add_seq(b, i); return b;}
   function add_int8(b, x){
    var
     position = b[2],
     match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + 1 | 0;
    if(length < new_position){
     resize(b, 1);
     caml_bytes_set(b[1][1], b[2], x);
    }
    else
     caml_bytes_unsafe_set(buffer, position, x);
    b[2] = new_position;
    return 0;
   }
   function add_int16_ne(b, x){
    var
     position = b[2],
     match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + 2 | 0;
    if(length < new_position){
     resize(b, 2);
     caml_bytes_set16(b[1][1], b[2], x);
    }
    else
     caml_bytes_set16(buffer, position, x);
    b[2] = new_position;
    return 0;
   }
   function add_int32_ne(b, x){
    var
     position = b[2],
     match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + 4 | 0;
    if(length < new_position){
     resize(b, 4);
     caml_bytes_set32(b[1][1], b[2], x);
    }
    else
     caml_bytes_set32(buffer, position, x);
    b[2] = new_position;
    return 0;
   }
   function add_int64_ne(b, x){
    var
     position = b[2],
     match = b[1],
     length = match[2],
     buffer = match[1],
     new_position = position + 8 | 0;
    if(length < new_position){
     resize(b, 8);
     caml_bytes_set64(b[1][1], b[2], x);
    }
    else
     caml_bytes_set64(buffer, position, x);
    b[2] = new_position;
    return 0;
   }
   function add_int16_le(b, x){
    var _d_ = Stdlib_Sys[11] ? caml_bswap16(x) : x;
    return add_int16_ne(b, _d_);
   }
   function add_int16_be(b, x){
    var x$0 = Stdlib_Sys[11] ? x : caml_bswap16(x);
    return add_int16_ne(b, x$0);
   }
   function add_int32_le(b, x){
    var _c_ = Stdlib_Sys[11] ? caml_int32_bswap(x) : x;
    return add_int32_ne(b, _c_);
   }
   function add_int32_be(b, x){
    var x$0 = Stdlib_Sys[11] ? x : caml_int32_bswap(x);
    return add_int32_ne(b, x$0);
   }
   function add_int64_le(b, x){
    var _b_ = Stdlib_Sys[11] ? caml_int64_bswap(x) : x;
    return add_int64_ne(b, _b_);
   }
   function add_int64_be(b, x){
    var x$0 = Stdlib_Sys[11] ? x : caml_int64_bswap(x);
    return add_int64_ne(b, x$0);
   }
   var
    Stdlib_Buffer =
      [0,
       create,
       contents,
       to_bytes,
       sub,
       blit,
       nth,
       length,
       clear,
       reset,
       output_buffer,
       truncate,
       add_char,
       add_utf_8_uchar,
       add_utf_16le_uchar,
       add_utf_16be_uchar,
       add_string,
       add_bytes,
       add_substring,
       add_subbytes,
       add_substitute,
       add_buffer,
       add_channel,
       to_seq,
       to_seqi,
       add_seq,
       of_seq,
       add_int8,
       add_int8,
       add_int16_ne,
       add_int16_be,
       add_int16_le,
       add_int16_ne,
       add_int16_be,
       add_int16_le,
       add_int32_ne,
       add_int32_be,
       add_int32_le,
       add_int64_ne,
       add_int64_be,
       add_int64_le];
   runtime.caml_register_global(14, Stdlib_Buffer, "Stdlib__Buffer");
   return;
  }
  (globalThis));

//# 10339 ".js/default/stdlib/stdlib.cma.js"
(function(globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_mutex_lock = runtime.caml_ml_mutex_lock,
    caml_ml_mutex_unlock = runtime.caml_ml_mutex_unlock,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function protect(m, f){
    caml_ml_mutex_lock(m);
    try{var x = caml_call1(f, 0);}
    catch(e$0){
     var e = caml_wrap_exception(e$0);
     caml_ml_mutex_unlock(m);
     throw caml_maybe_attach_backtrace(e, 0);
    }
    caml_ml_mutex_unlock(m);
    return x;
   }
   var
    Stdlib_Mutex =
      [0,
       runtime.caml_ml_mutex_new,
       caml_ml_mutex_lock,
       runtime.caml_ml_mutex_try_lock,
       caml_ml_mutex_unlock,
       protect];
   runtime.caml_register_global(0, Stdlib_Mutex, "Stdlib__Mutex");
   return;
  }
  (globalThis));

//# 10377 ".js/default/stdlib/stdlib.cma.js"
(function(globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    Stdlib_Condition =
      [0,
       runtime.caml_ml_condition_new,
       runtime.caml_ml_condition_wait,
       runtime.caml_ml_condition_signal,
       runtime.caml_ml_condition_broadcast];
   runtime.caml_register_global(0, Stdlib_Condition, "Stdlib__Condition");
   return;
  }
  (globalThis));

//# 10485 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_check_bound = runtime.caml_check_bound,
    caml_domain_dls_set = runtime.caml_domain_dls_set,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_domain_id = runtime.caml_ml_domain_id,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Mutex = global_data.Stdlib__Mutex,
    Stdlib_Condition = global_data.Stdlib__Condition,
    Stdlib = global_data.Stdlib,
    Stdlib_Atomic = global_data.Stdlib__Atomic,
    Stdlib_List = global_data.Stdlib__List,
    Stdlib_Array = global_data.Stdlib__Array;
   function cpu_relax(param){return runtime.caml_ml_domain_cpu_relax(0);}
   var unique_value = [0, 0];
   function create_dls(param){
    var st = caml_make_vect(8, unique_value);
    caml_domain_dls_set(st);
    return;
   }
   create_dls(0);
   var
    key_counter = caml_call1(Stdlib_Atomic[1], 0),
    parent_keys = caml_call1(Stdlib_Atomic[1], 0);
   function new_key(split_from_parent, init_orphan){
    var
     idx = caml_call2(Stdlib_Atomic[6], key_counter, 1),
     k = [0, idx, init_orphan];
    if(split_from_parent){
     var split = split_from_parent[1], ki = [0, k, split];
     for(;;){
      var l = caml_call1(Stdlib_Atomic[2], parent_keys);
      if(! (1 - caml_call3(Stdlib_Atomic[5], parent_keys, l, [0, ki, l])))
       break;
     }
    }
    return k;
   }
   function maybe_grow(idx){
    var st = runtime.caml_domain_dls_get(0), sz = st.length - 1;
    if(idx < sz) return st;
    var new_sz = sz;
    for(;;){
     if(idx < new_sz){
      var new_st = caml_make_vect(new_sz, unique_value);
      caml_call5(Stdlib_Array[8], st, 0, new_st, 0, sz);
      caml_domain_dls_set(new_st);
      return new_st;
     }
     var s = 2 * new_sz | 0, new_sz = s;
    }
   }
   function set(param, x){
    var idx = param[1], st = maybe_grow(idx);
    caml_check_bound(st, idx)[1 + idx] = x;
    return 0;
   }
   function get(param){
    var
     init = param[2],
     idx = param[1],
     st = maybe_grow(idx),
     v = caml_check_bound(st, idx)[1 + idx];
    if(v !== unique_value) return v;
    var v$0 = caml_call1(init, 0);
    caml_check_bound(st, idx)[1 + idx] = v$0;
    return v$0;
   }
   function get_id(param){var domain = param[1]; return domain;}
   function self(param){return caml_ml_domain_id(0);}
   function is_main_domain(param){return 0 === caml_ml_domain_id(0) ? 1 : 0;}
   var
    first_domain_spawned = caml_call1(Stdlib_Atomic[1], 0),
    first_spawn_function = [0, function(param){return;}],
    cst_first_domain_already_spawn = "first domain already spawned";
   function before_first_spawn(f){
    if(caml_call1(Stdlib_Atomic[2], first_domain_spawned))
     throw caml_maybe_attach_backtrace
            ([0, Stdlib[6], cst_first_domain_already_spawn], 1);
    var old_f = first_spawn_function[1];
    function new_f(param){caml_call1(old_f, 0); return caml_call1(f, 0);}
    first_spawn_function[1] = new_f;
    return 0;
   }
   var at_exit_key = new_key(0, function(param, _c_){return 0;});
   function at_exit(f){
    var old_exit = get(at_exit_key);
    function new_exit(param){
     caml_call1(f, 0);
     return caml_call1(old_exit, 0);
    }
    return set(at_exit_key, new_exit);
   }
   function do_at_exit(param){
    var f = get(at_exit_key);
    return caml_call1(f, 0);
   }
   Stdlib[104][1] = do_at_exit;
   var
    cst_internal_error_Am_I_alread = "internal error: Am I already finished?";
   function spawn(f){
    if(1 - caml_call1(Stdlib_Atomic[2], first_domain_spawned)){
     caml_call2(Stdlib_Atomic[3], first_domain_spawned, 1);
     caml_call1(first_spawn_function[1], 0);
     first_spawn_function[1] = function(param){return 0;};
    }
    var
     _a_ = caml_call1(Stdlib_Atomic[2], parent_keys),
     pk =
       caml_call2
        (Stdlib_List[20],
         function(param){
          var split = param[2], k = param[1], idx = k[1];
          return [0, idx, caml_call1(split, get(k))];
         },
         _a_),
     term_mutex = caml_call1(Stdlib_Mutex[1], 0),
     term_condition = caml_call1(Stdlib_Condition[1], 0),
     term_state = [0, 0];
    function body(param){
     a:
     {
      try{
       create_dls(0);
       caml_call2
        (Stdlib_List[18],
         function(param){
          var v = param[2], idx = param[1], st = maybe_grow(idx);
          caml_check_bound(st, idx)[1 + idx] = v;
          return 0;
         },
         pk);
       var res = caml_call1(f, 0);
      }
      catch(ex$0){
       var ex = caml_wrap_exception(ex$0), result = [1, ex];
       break a;
      }
      var result = [0, res];
     }
     try{do_at_exit(0); var result$0 = result;}
     catch(ex){
      var
       ex$0 = caml_wrap_exception(ex),
       _b_ = 0 === result[0] ? [1, ex$0] : result,
       result$0 = _b_;
     }
     caml_call1(Stdlib_Mutex[2], term_mutex);
     return term_state[1]
             ? caml_call1(Stdlib[2], cst_internal_error_Am_I_alread)
             : (term_state
                [1]
               = [0, result$0],
               caml_call1(Stdlib_Condition[4], term_condition));
    }
    return [0,
            runtime.caml_domain_spawn(body, term_mutex),
            term_mutex,
            term_condition,
            term_state];
   }
   function join(param){
    var
     term_state = param[4],
     term_condition = param[3],
     term_mutex = param[2];
    caml_call1(Stdlib_Mutex[2], term_mutex);
    for(;;){
     var match = term_state[1];
     if(match){
      var res = match[1];
      caml_call1(Stdlib_Mutex[4], term_mutex);
      if(0 === res[0]){var x = res[1]; return x;}
      var ex = res[1];
      throw caml_maybe_attach_backtrace(ex, 1);
     }
     caml_call2(Stdlib_Condition[2], term_condition, term_mutex);
    }
   }
   var
    recommended_domain_count = runtime.caml_recommended_domain_count,
    Stdlib_Domain =
      [0,
       spawn,
       join,
       get_id,
       self,
       before_first_spawn,
       at_exit,
       cpu_relax,
       is_main_domain,
       recommended_domain_count,
       [0, new_key, get, set]];
   runtime.caml_register_global(8, Stdlib_Domain, "Stdlib__Domain");
   return;
  }
  (globalThis));

//# 10712 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$43 = "",
    cst_and = " and ",
    cst_Li$3 = "%Li",
    cst_i$3 = "%i",
    cst_li$3 = "%li",
    cst_ni$3 = "%ni",
    cst_u$0 = "%u",
    cst$42 = "' '",
    cst$41 = "'#'",
    cst$39 = "'*'",
    cst$40 = "'+'",
    cst$44 = ", ",
    cst_0$3 = "0",
    cst_at_character_number = ": at character number ",
    cst$38 = "@[",
    cst$37 = "@{",
    cst_bad_input_format_type_mism =
      "bad input: format type mismatch between ",
    cst_bad_input_format_type_mism$0 =
      "bad input: format type mismatch between %S and %S",
    cst_camlinternalFormat_ml = "camlinternalFormat.ml",
    cst_invalid_format = "invalid format ",
    cst_precision$3 = "precision",
    caml_blit_string = runtime.caml_blit_string,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_format_float = runtime.caml_format_float,
    caml_format_int = runtime.caml_format_int,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_notequal = runtime.caml_notequal,
    caml_string_get = runtime.caml_string_get,
    caml_string_notequal = runtime.caml_string_notequal,
    caml_string_unsafe_get = runtime.caml_string_unsafe_get,
    caml_trampoline = runtime.caml_trampoline,
    caml_trampoline_return = runtime.caml_trampoline_return,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
   function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    cst$9 = "%{",
    cst$10 = "%}",
    cst$11 = "%(",
    cst$12 = "%)",
    cst$13 = "%?",
    cst$18 = cst$37,
    cst$19 = cst$38,
    cst$20 = cst$37,
    cst$21 = cst$38,
    cst$22 = cst$37,
    cst$23 = cst$38,
    cst$26 = cst$39,
    cst$24 = "'-'",
    cst$25 = cst$39,
    cst$27 = cst$40,
    cst$28 = cst$41,
    cst$29 = cst$42,
    cst$30 = cst$40,
    cst$31 = "'_'",
    sub_format = [0, 0, cst$43],
    formatting_lit = [0, "@;", 1, 0],
    cst$35 = cst$41,
    cst$32 = cst$40,
    cst$33 = cst$40,
    cst$34 = cst$42,
    cst$36 = cst$40,
    cst$17 = ".",
    cst$14 = "%!",
    cst$15 = cst$37,
    cst$16 = cst$38,
    cst$8 = "%%",
    cst$0 = "@]",
    cst$1 = "@}",
    cst$2 = "@?",
    cst$3 = "@\n",
    cst$4 = "@.",
    cst$5 = "@@",
    cst$6 = "@%",
    cst$7 = "@",
    cst = ".*",
    Assert_failure = global_data.Assert_failure,
    CamlinternalFormatBasics = global_data.CamlinternalFormatBasics,
    Stdlib = global_data.Stdlib,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_String = global_data.Stdlib__String,
    Stdlib_Sys = global_data.Stdlib__Sys,
    Stdlib_Char = global_data.Stdlib__Char,
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Stdlib_Int = global_data.Stdlib__Int,
    _a_ = [0, 0, 0],
    cst_c = "%c",
    cst_s = "%s",
    cst_i = cst_i$3,
    cst_li = cst_li$3,
    cst_ni = cst_ni$3,
    cst_Li = cst_Li$3,
    cst_f = "%f",
    cst_B = "%B",
    cst_a = "%a",
    cst_t = "%t",
    cst_r = "%r",
    cst_r$0 = "%_r",
    cst_0c = "0c",
    _b_ = [0, cst_camlinternalFormat_ml, 850, 23],
    _c_ = [0, cst_camlinternalFormat_ml, 837, 26],
    _d_ = [0, cst_camlinternalFormat_ml, 847, 28],
    _e_ = [0, cst_camlinternalFormat_ml, 815, 21],
    _f_ = [0, cst_camlinternalFormat_ml, 819, 21],
    _g_ = [0, cst_camlinternalFormat_ml, 823, 19],
    _h_ = [0, cst_camlinternalFormat_ml, 827, 22],
    _i_ = [0, cst_camlinternalFormat_ml, 832, 30],
    _j_ = [0, cst_camlinternalFormat_ml, 851, 23],
    _k_ = [0, cst_camlinternalFormat_ml, 836, 26],
    _l_ = [0, cst_camlinternalFormat_ml, 846, 28],
    _m_ = [0, cst_camlinternalFormat_ml, 814, 21],
    _n_ = [0, cst_camlinternalFormat_ml, 818, 21],
    _o_ = [0, cst_camlinternalFormat_ml, 822, 19],
    _p_ = [0, cst_camlinternalFormat_ml, 826, 22],
    _q_ = [0, cst_camlinternalFormat_ml, 831, 30];
   function create_char_set(param){return caml_call2(Stdlib_Bytes[1], 32, 0);}
   function add_in_char_set(char_set, c){
    var
     str_ind = c >>> 3 | 0,
     mask = 1 << (c & 7),
     _dt_ = runtime.caml_bytes_get(char_set, str_ind) | mask;
    return caml_bytes_set(char_set, str_ind, caml_call1(Stdlib[29], _dt_));
   }
   function freeze_char_set(char_set){
    return caml_call1(Stdlib_Bytes[6], char_set);
   }
   function rev_char_set(char_set){
    var char_set$0 = create_char_set(0), i = 0;
    for(;;){
     var _dr_ = caml_string_get(char_set, i) ^ 255;
     caml_bytes_set(char_set$0, i, caml_call1(Stdlib[29], _dr_));
     var _ds_ = i + 1 | 0;
     if(31 === i) return caml_call1(Stdlib_Bytes[44], char_set$0);
     var i = _ds_;
    }
   }
   function is_in_char_set(char_set, c){
    var str_ind = c >>> 3 | 0, mask = 1 << (c & 7);
    return 0 !== (caml_string_get(char_set, str_ind) & mask) ? 1 : 0;
   }
   function pad_of_pad_opt(pad_opt){
    if(! pad_opt) return 0;
    var width = pad_opt[1];
    return [0, 1, width];
   }
   function param_format_of_ignored_format(ign, fmt){
    if(typeof ign === "number")
     switch(ign){
       case 0:
        return [0, [0, fmt]];
       case 1:
        return [0, [1, fmt]];
       case 2:
        return [0, [19, fmt]];
       default: return [0, [22, fmt]];
     }
    switch(ign[0]){
      case 0:
       var pad_opt = ign[1]; return [0, [2, pad_of_pad_opt(pad_opt), fmt]];
      case 1:
       var pad_opt$0 = ign[1];
       return [0, [3, pad_of_pad_opt(pad_opt$0), fmt]];
      case 2:
       var pad_opt$1 = ign[2], iconv = ign[1];
       return [0, [4, iconv, pad_of_pad_opt(pad_opt$1), 0, fmt]];
      case 3:
       var pad_opt$2 = ign[2], iconv$0 = ign[1];
       return [0, [5, iconv$0, pad_of_pad_opt(pad_opt$2), 0, fmt]];
      case 4:
       var pad_opt$3 = ign[2], iconv$1 = ign[1];
       return [0, [6, iconv$1, pad_of_pad_opt(pad_opt$3), 0, fmt]];
      case 5:
       var pad_opt$4 = ign[2], iconv$2 = ign[1];
       return [0, [7, iconv$2, pad_of_pad_opt(pad_opt$4), 0, fmt]];
      case 6:
       var prec_opt = ign[2], pad_opt$5 = ign[1];
       if(prec_opt)
        var ndec = prec_opt[1], _dq_ = [0, ndec];
       else
        var _dq_ = 0;
       return [0, [8, _a_, pad_of_pad_opt(pad_opt$5), _dq_, fmt]];
      case 7:
       var pad_opt$6 = ign[1];
       return [0, [9, pad_of_pad_opt(pad_opt$6), fmt]];
      case 8:
       var fmtty = ign[2], pad_opt$7 = ign[1];
       return [0, [13, pad_opt$7, fmtty, fmt]];
      case 9:
       var fmtty$0 = ign[2], pad_opt$8 = ign[1];
       return [0, [14, pad_opt$8, fmtty$0, fmt]];
      case 10:
       var char_set = ign[2], width_opt = ign[1];
       return [0, [20, width_opt, char_set, fmt]];
      default: var counter = ign[1]; return [0, [21, counter, fmt]];
    }
   }
   function default_float_precision(fconv){return 5 === fconv[2] ? 12 : -6;}
   function buffer_create(init_size){
    return [0, 0, caml_create_bytes(init_size)];
   }
   function buffer_check_size(buf, overhead){
    var
     len = runtime.caml_ml_bytes_length(buf[2]),
     min_len = buf[1] + overhead | 0;
    if(len < min_len){
     var
      new_len = caml_call2(Stdlib_Int[11], len * 2 | 0, min_len),
      new_str = caml_create_bytes(new_len);
     caml_call5(Stdlib_Bytes[11], buf[2], 0, new_str, 0, len);
     buf[2] = new_str;
    }
    return;
   }
   function buffer_add_char(buf, c){
    buffer_check_size(buf, 1);
    caml_bytes_set(buf[2], buf[1], c);
    buf[1] = buf[1] + 1 | 0;
    return;
   }
   function buffer_add_string(buf, s){
    var str_len = caml_ml_string_length(s);
    buffer_check_size(buf, str_len);
    caml_call5(Stdlib_String[6], s, 0, buf[2], buf[1], str_len);
    buf[1] = buf[1] + str_len | 0;
    return;
   }
   function buffer_contents(buf){
    return caml_call3(Stdlib_Bytes[8], buf[2], 0, buf[1]);
   }
   function char_of_iconv(iconv){
    switch(iconv){
      case 6:
      case 7:
       return 120;
      case 8:
      case 9:
       return 88;
      case 10:
      case 11:
       return 111;
      case 12:
      case 15:
       return 117;
      case 0:
      case 1:
      case 2:
      case 13:
       return 100;
      default: return 105;
    }
   }
   function char_of_fconv(opt, fconv){
    if(opt) var sth = opt[1], cF = sth; else var cF = 70;
    switch(fconv[2]){
      case 0:
       return 102;
      case 1:
       return 101;
      case 2:
       return 69;
      case 3:
       return 103;
      case 4:
       return 71;
      case 5:
       return cF;
      case 6:
       return 104;
      case 7:
       return 72;
      default: return 70;
    }
   }
   function bprint_padty(buf, padty){
    switch(padty){
      case 0:
       return buffer_add_char(buf, 45);
      case 1:
       return;
      default: return buffer_add_char(buf, 48);
    }
   }
   function bprint_ignored_flag(buf, ign_flag){
    return ign_flag ? buffer_add_char(buf, 95) : ign_flag;
   }
   function bprint_pad_opt(buf, pad_opt){
    if(! pad_opt) return;
    var width = pad_opt[1];
    return buffer_add_string(buf, caml_call1(Stdlib_Int[12], width));
   }
   function bprint_padding(buf, pad){
    if(typeof pad === "number") return;
    if(0 === pad[0]){
     var n = pad[2], padty = pad[1];
     bprint_padty(buf, padty);
     return buffer_add_string(buf, caml_call1(Stdlib_Int[12], n));
    }
    var padty$0 = pad[1];
    bprint_padty(buf, padty$0);
    return buffer_add_char(buf, 42);
   }
   function bprint_precision(buf, prec){
    if(typeof prec !== "number"){
     var n = prec[1];
     buffer_add_char(buf, 46);
     return buffer_add_string(buf, caml_call1(Stdlib_Int[12], n));
    }
    if(prec) return buffer_add_string(buf, cst);
    return;
   }
   function bprint_iconv_flag(buf, iconv){
    switch(iconv){
      case 1:
      case 4:
       return buffer_add_char(buf, 43);
      case 2:
      case 5:
       return buffer_add_char(buf, 32);
      case 7:
      case 9:
      case 11:
      case 13:
      case 14:
      case 15:
       return buffer_add_char(buf, 35);
      default: return;
    }
   }
   function bprint_altint_fmt(buf, ign_flag, iconv, pad, prec, c){
    buffer_add_char(buf, 37);
    bprint_ignored_flag(buf, ign_flag);
    bprint_iconv_flag(buf, iconv);
    bprint_padding(buf, pad);
    bprint_precision(buf, prec);
    buffer_add_char(buf, c);
    return buffer_add_char(buf, char_of_iconv(iconv));
   }
   function bprint_fconv_flag(buf, fconv){
    switch(fconv[1]){
      case 0: break;
      case 1:
       buffer_add_char(buf, 43); break;
      default: buffer_add_char(buf, 32);
    }
    if(8 <= fconv[2]) return buffer_add_char(buf, 35);
    return;
   }
   function string_of_formatting_lit(formatting_lit){
    if(typeof formatting_lit === "number")
     switch(formatting_lit){
       case 0:
        return cst$0;
       case 1:
        return cst$1;
       case 2:
        return cst$2;
       case 3:
        return cst$3;
       case 4:
        return cst$4;
       case 5:
        return cst$5;
       default: return cst$6;
     }
    switch(formatting_lit[0]){
      case 0:
       var str = formatting_lit[1]; return str;
      case 1:
       var str$0 = formatting_lit[1]; return str$0;
      default:
       var c = formatting_lit[1], _dp_ = caml_call2(Stdlib_String[1], 1, c);
       return caml_call2(Stdlib[28], cst$7, _dp_);
    }
   }
   function bprint_char_literal(buf, chr){
    return 37 === chr
            ? buffer_add_string(buf, cst$8)
            : buffer_add_char(buf, chr);
   }
   function bprint_string_literal(buf, str){
    var _dn_ = caml_ml_string_length(str) - 1 | 0, _dm_ = 0;
    if(_dn_ >= 0){
     var i = _dm_;
     for(;;){
      bprint_char_literal(buf, caml_string_get(str, i));
      var _do_ = i + 1 | 0;
      if(_dn_ === i) break;
      var i = _do_;
     }
    }
    return;
   }
   function bprint_fmtty(buf, fmtty){
    var fmtty$0 = fmtty;
    for(;;){
     if(typeof fmtty$0 === "number") return;
     switch(fmtty$0[0]){
       case 0:
        var fmtty$1 = fmtty$0[1];
        buffer_add_string(buf, cst_c);
        var fmtty$0 = fmtty$1;
        break;
       case 1:
        var fmtty$2 = fmtty$0[1];
        buffer_add_string(buf, cst_s);
        var fmtty$0 = fmtty$2;
        break;
       case 2:
        var fmtty$3 = fmtty$0[1];
        buffer_add_string(buf, cst_i);
        var fmtty$0 = fmtty$3;
        break;
       case 3:
        var fmtty$4 = fmtty$0[1];
        buffer_add_string(buf, cst_li);
        var fmtty$0 = fmtty$4;
        break;
       case 4:
        var fmtty$5 = fmtty$0[1];
        buffer_add_string(buf, cst_ni);
        var fmtty$0 = fmtty$5;
        break;
       case 5:
        var fmtty$6 = fmtty$0[1];
        buffer_add_string(buf, cst_Li);
        var fmtty$0 = fmtty$6;
        break;
       case 6:
        var fmtty$7 = fmtty$0[1];
        buffer_add_string(buf, cst_f);
        var fmtty$0 = fmtty$7;
        break;
       case 7:
        var fmtty$8 = fmtty$0[1];
        buffer_add_string(buf, cst_B);
        var fmtty$0 = fmtty$8;
        break;
       case 8:
        var fmtty$9 = fmtty$0[2], sub_fmtty = fmtty$0[1];
        buffer_add_string(buf, cst$9);
        bprint_fmtty(buf, sub_fmtty);
        buffer_add_string(buf, cst$10);
        var fmtty$0 = fmtty$9;
        break;
       case 9:
        var fmtty$10 = fmtty$0[3], sub_fmtty$0 = fmtty$0[1];
        buffer_add_string(buf, cst$11);
        bprint_fmtty(buf, sub_fmtty$0);
        buffer_add_string(buf, cst$12);
        var fmtty$0 = fmtty$10;
        break;
       case 10:
        var fmtty$11 = fmtty$0[1];
        buffer_add_string(buf, cst_a);
        var fmtty$0 = fmtty$11;
        break;
       case 11:
        var fmtty$12 = fmtty$0[1];
        buffer_add_string(buf, cst_t);
        var fmtty$0 = fmtty$12;
        break;
       case 12:
        var fmtty$13 = fmtty$0[1];
        buffer_add_string(buf, cst$13);
        var fmtty$0 = fmtty$13;
        break;
       case 13:
        var fmtty$14 = fmtty$0[1];
        buffer_add_string(buf, cst_r);
        var fmtty$0 = fmtty$14;
        break;
       default:
        var fmtty$15 = fmtty$0[1];
        buffer_add_string(buf, cst_r$0);
        var fmtty$0 = fmtty$15;
     }
    }
   }
   function int_of_custom_arity(param){
    if(! param) return 0;
    var x = param[1];
    return 1 + int_of_custom_arity(x) | 0;
   }
   function string_of_fmt(fmt){
    var buf = buffer_create(16);
    function fmtiter(fmt, ign_flag){
     var fmt$0 = fmt, ign_flag$0 = ign_flag;
     for(;;){
      if(typeof fmt$0 === "number") return;
      switch(fmt$0[0]){
        case 0:
         var rest = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         buffer_add_char(buf, 99);
         var fmt$0 = rest, ign_flag$0 = 0;
         break;
        case 1:
         var rest$0 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         buffer_add_char(buf, 67);
         var fmt$0 = rest$0, ign_flag$0 = 0;
         break;
        case 2:
         var rest$1 = fmt$0[2], pad = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_padding(buf, pad);
         buffer_add_char(buf, 115);
         var fmt$0 = rest$1, ign_flag$0 = 0;
         break;
        case 3:
         var rest$2 = fmt$0[2], pad$0 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_padding(buf, pad$0);
         buffer_add_char(buf, 83);
         var fmt$0 = rest$2, ign_flag$0 = 0;
         break;
        case 4:
         var
          rest$3 = fmt$0[4],
          prec = fmt$0[3],
          pad$1 = fmt$0[2],
          iconv = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_iconv_flag(buf, iconv);
         bprint_padding(buf, pad$1);
         bprint_precision(buf, prec);
         buffer_add_char(buf, char_of_iconv(iconv));
         var fmt$0 = rest$3, ign_flag$0 = 0;
         break;
        case 5:
         var
          rest$4 = fmt$0[4],
          prec$0 = fmt$0[3],
          pad$2 = fmt$0[2],
          iconv$0 = fmt$0[1];
         bprint_altint_fmt(buf, ign_flag$0, iconv$0, pad$2, prec$0, 108);
         var fmt$0 = rest$4, ign_flag$0 = 0;
         break;
        case 6:
         var
          rest$5 = fmt$0[4],
          prec$1 = fmt$0[3],
          pad$3 = fmt$0[2],
          iconv$1 = fmt$0[1];
         bprint_altint_fmt(buf, ign_flag$0, iconv$1, pad$3, prec$1, 110);
         var fmt$0 = rest$5, ign_flag$0 = 0;
         break;
        case 7:
         var
          rest$6 = fmt$0[4],
          prec$2 = fmt$0[3],
          pad$4 = fmt$0[2],
          iconv$2 = fmt$0[1];
         bprint_altint_fmt(buf, ign_flag$0, iconv$2, pad$4, prec$2, 76);
         var fmt$0 = rest$6, ign_flag$0 = 0;
         break;
        case 8:
         var
          rest$7 = fmt$0[4],
          prec$3 = fmt$0[3],
          pad$5 = fmt$0[2],
          fconv = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_fconv_flag(buf, fconv);
         bprint_padding(buf, pad$5);
         bprint_precision(buf, prec$3);
         buffer_add_char(buf, char_of_fconv(0, fconv));
         var fmt$0 = rest$7, ign_flag$0 = 0;
         break;
        case 9:
         var rest$8 = fmt$0[2], pad$6 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_padding(buf, pad$6);
         buffer_add_char(buf, 66);
         var fmt$0 = rest$8, ign_flag$0 = 0;
         break;
        case 10:
         var rest$9 = fmt$0[1];
         buffer_add_string(buf, cst$14);
         var fmt$0 = rest$9;
         break;
        case 11:
         var rest$10 = fmt$0[2], str = fmt$0[1];
         bprint_string_literal(buf, str);
         var fmt$0 = rest$10;
         break;
        case 12:
         var rest$11 = fmt$0[2], chr = fmt$0[1];
         bprint_char_literal(buf, chr);
         var fmt$0 = rest$11;
         break;
        case 13:
         var rest$12 = fmt$0[3], fmtty = fmt$0[2], pad_opt = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_pad_opt(buf, pad_opt);
         buffer_add_char(buf, 123);
         bprint_fmtty(buf, fmtty);
         buffer_add_char(buf, 37);
         buffer_add_char(buf, 125);
         var fmt$0 = rest$12, ign_flag$0 = 0;
         break;
        case 14:
         var rest$13 = fmt$0[3], fmtty$0 = fmt$0[2], pad_opt$0 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_pad_opt(buf, pad_opt$0);
         buffer_add_char(buf, 40);
         bprint_fmtty(buf, fmtty$0);
         buffer_add_char(buf, 37);
         buffer_add_char(buf, 41);
         var fmt$0 = rest$13, ign_flag$0 = 0;
         break;
        case 15:
         var rest$14 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         buffer_add_char(buf, 97);
         var fmt$0 = rest$14, ign_flag$0 = 0;
         break;
        case 16:
         var rest$15 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         buffer_add_char(buf, 116);
         var fmt$0 = rest$15, ign_flag$0 = 0;
         break;
        case 17:
         var rest$16 = fmt$0[2], fmting_lit = fmt$0[1];
         bprint_string_literal(buf, string_of_formatting_lit(fmting_lit));
         var fmt$0 = rest$16;
         break;
        case 18:
         var rest$17 = fmt$0[2], fmting_gen = fmt$0[1];
         if(0 === fmting_gen[0]){
          var str$0 = fmting_gen[1][2];
          buffer_add_string(buf, cst$15);
          buffer_add_string(buf, str$0);
         }
         else{
          var str$1 = fmting_gen[1][2];
          buffer_add_string(buf, cst$16);
          buffer_add_string(buf, str$1);
         }
         var fmt$0 = rest$17;
         break;
        case 19:
         var rest$18 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         buffer_add_char(buf, 114);
         var fmt$0 = rest$18, ign_flag$0 = 0;
         break;
        case 20:
         var rest$19 = fmt$0[3], char_set = fmt$0[2], width_opt = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_pad_opt(buf, width_opt);
         var
          print_char =
            function(buf, i){
             var c = caml_call1(Stdlib[29], i);
             return 37 === c
                     ? (buffer_add_char(buf, 37), buffer_add_char(buf, 37))
                     : 64
                       === c
                       ? (buffer_add_char(buf, 37), buffer_add_char(buf, 64))
                       : buffer_add_char(buf, c);
            };
         buffer_add_char(buf, 91);
         var
          set =
            is_in_char_set(char_set, 0)
             ? (buffer_add_char(buf, 94), rev_char_set(char_set))
             : char_set;
         let set$0 = set;
         var
          is_alone =
            function(c){
             var
              after = caml_call1(Stdlib_Char[1], c + 1 | 0),
              before = caml_call1(Stdlib_Char[1], c - 1 | 0),
              _di_ = is_in_char_set(set$0, c);
             if(_di_)
              var
               _dj_ = is_in_char_set(set$0, before),
               _dk_ = _dj_ ? is_in_char_set(set$0, after) : _dj_,
               _dl_ = 1 - _dk_;
             else
              var _dl_ = _di_;
             return _dl_;
            };
         if(is_alone(93)) buffer_add_char(buf, 93);
         a:
         b:
         {
          c:
          {
           d:
           {
            var i = 1;
            for(;;){
             if(i >= 256) break;
             if(is_in_char_set(set, caml_call1(Stdlib[29], i))){
              var switcher = caml_call1(Stdlib[29], i) - 45 | 0;
              if(48 < switcher >>> 0){
               if(210 <= switcher) break d;
              }
              else if(46 < switcher - 1 >>> 0){
               var i$2 = i + 1 | 0, i = i$2;
               continue;
              }
              var i$1 = i + 1 | 0;
              if(is_in_char_set(set, caml_call1(Stdlib[29], i$1))){
               var switcher$0 = caml_call1(Stdlib[29], i$1) - 45 | 0;
               if(48 < switcher$0 >>> 0){
                if(210 <= switcher$0) break c;
               }
               else if
                (46 < switcher$0 - 1 >>> 0
                 && ! is_in_char_set(set, caml_call1(Stdlib[29], i$1 + 1 | 0))){
                print_char(buf, i$1 - 1 | 0);
                var i$5 = i$1 + 1 | 0, i = i$5;
                continue;
               }
               if(is_in_char_set(set, caml_call1(Stdlib[29], i$1 + 1 | 0))){
                var j = i$1 + 2 | 0, i$3 = i$1 - 1 | 0, j$0 = j;
                for(;;){
                 if(256 === j$0) break;
                 if(! is_in_char_set(set, caml_call1(Stdlib[29], j$0))) break;
                 var j$1 = j$0 + 1 | 0, j$0 = j$1;
                }
                print_char(buf, i$3);
                print_char(buf, 45);
                print_char(buf, j$0 - 1 | 0);
                if(j$0 >= 256) break b;
                var i$7 = j$0 + 1 | 0, i = i$7;
               }
               else{
                print_char(buf, i$1 - 1 | 0);
                print_char(buf, i$1);
                var i$4 = i$1 + 2 | 0, i = i$4;
               }
              }
              else{
               print_char(buf, i$1 - 1 | 0);
               var i$6 = i$1 + 1 | 0, i = i$6;
              }
             }
             else
              var i$0 = i + 1 | 0, i = i$0;
            }
            break a;
           }
           print_char(buf, 255);
           break a;
          }
          print_char(buf, 254);
          print_char(buf, 255);
          break a;
         }
         if(is_alone(45)) buffer_add_char(buf, 45);
         buffer_add_char(buf, 93);
         var fmt$0 = rest$19, ign_flag$0 = 0;
         break;
        case 21:
         var rest$20 = fmt$0[2], counter = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         switch(counter){
           case 0:
            var _de_ = 108; break;
           case 1:
            var _de_ = 110; break;
           default: var _de_ = 78;
         }
         buffer_add_char(buf, _de_);
         var fmt$0 = rest$20, ign_flag$0 = 0;
         break;
        case 22:
         var rest$21 = fmt$0[1];
         buffer_add_char(buf, 37);
         bprint_ignored_flag(buf, ign_flag$0);
         bprint_string_literal(buf, cst_0c);
         var fmt$0 = rest$21, ign_flag$0 = 0;
         break;
        case 23:
         var
          rest$22 = fmt$0[2],
          ign = fmt$0[1],
          fmt$1 = param_format_of_ignored_format(ign, rest$22)[1],
          fmt$0 = fmt$1,
          ign_flag$0 = 1;
         break;
        default:
         var
          rest$23 = fmt$0[3],
          arity = fmt$0[1],
          _dg_ = int_of_custom_arity(arity),
          _df_ = 1;
         if(_dg_ >= 1){
          var i$8 = _df_;
          for(;;){
           buffer_add_char(buf, 37);
           bprint_ignored_flag(buf, ign_flag$0);
           buffer_add_char(buf, 63);
           var _dh_ = i$8 + 1 | 0;
           if(_dg_ === i$8) break;
           var i$8 = _dh_;
          }
         }
         var fmt$0 = rest$23, ign_flag$0 = 0;
      }
     }
    }
    fmtiter(fmt, 0);
    return buffer_contents(buf);
   }
   function symm(param){
    if(typeof param === "number") return 0;
    switch(param[0]){
      case 0:
       var rest = param[1]; return [0, symm(rest)];
      case 1:
       var rest$0 = param[1]; return [1, symm(rest$0)];
      case 2:
       var rest$1 = param[1]; return [2, symm(rest$1)];
      case 3:
       var rest$2 = param[1]; return [3, symm(rest$2)];
      case 4:
       var rest$3 = param[1]; return [4, symm(rest$3)];
      case 5:
       var rest$4 = param[1]; return [5, symm(rest$4)];
      case 6:
       var rest$5 = param[1]; return [6, symm(rest$5)];
      case 7:
       var rest$6 = param[1]; return [7, symm(rest$6)];
      case 8:
       var rest$7 = param[2], ty = param[1]; return [8, ty, symm(rest$7)];
      case 9:
       var rest$8 = param[3], ty2 = param[2], ty1 = param[1];
       return [9, ty2, ty1, symm(rest$8)];
      case 10:
       var rest$9 = param[1]; return [10, symm(rest$9)];
      case 11:
       var rest$10 = param[1]; return [11, symm(rest$10)];
      case 12:
       var rest$11 = param[1]; return [12, symm(rest$11)];
      case 13:
       var rest$12 = param[1]; return [13, symm(rest$12)];
      default: var rest$13 = param[1]; return [14, symm(rest$13)];
    }
   }
   function fmtty_rel_det(param){
    if(typeof param === "number")
     return [0,
             function(param){return;},
             function(param){return;},
             function(param){return;},
             function(param){return;}];
    switch(param[0]){
      case 0:
       var
        rest = param[1],
        match = fmtty_rel_det(rest),
        de = match[4],
        ed = match[3],
        af = match[2],
        fa = match[1];
       return [0,
               function(param){fa(0); return;},
               function(param){af(0); return;},
               ed,
               de];
      case 1:
       var
        rest$0 = param[1],
        match$0 = fmtty_rel_det(rest$0),
        de$0 = match$0[4],
        ed$0 = match$0[3],
        af$0 = match$0[2],
        fa$0 = match$0[1];
       return [0,
               function(param){fa$0(0); return;},
               function(param){af$0(0); return;},
               ed$0,
               de$0];
      case 2:
       var
        rest$1 = param[1],
        match$1 = fmtty_rel_det(rest$1),
        de$1 = match$1[4],
        ed$1 = match$1[3],
        af$1 = match$1[2],
        fa$1 = match$1[1];
       return [0,
               function(param){fa$1(0); return;},
               function(param){af$1(0); return;},
               ed$1,
               de$1];
      case 3:
       var
        rest$2 = param[1],
        match$2 = fmtty_rel_det(rest$2),
        de$2 = match$2[4],
        ed$2 = match$2[3],
        af$2 = match$2[2],
        fa$2 = match$2[1];
       return [0,
               function(param){fa$2(0); return;},
               function(param){af$2(0); return;},
               ed$2,
               de$2];
      case 4:
       var
        rest$3 = param[1],
        match$3 = fmtty_rel_det(rest$3),
        de$3 = match$3[4],
        ed$3 = match$3[3],
        af$3 = match$3[2],
        fa$3 = match$3[1];
       return [0,
               function(param){fa$3(0); return;},
               function(param){af$3(0); return;},
               ed$3,
               de$3];
      case 5:
       var
        rest$4 = param[1],
        match$4 = fmtty_rel_det(rest$4),
        de$4 = match$4[4],
        ed$4 = match$4[3],
        af$4 = match$4[2],
        fa$4 = match$4[1];
       return [0,
               function(param){fa$4(0); return;},
               function(param){af$4(0); return;},
               ed$4,
               de$4];
      case 6:
       var
        rest$5 = param[1],
        match$5 = fmtty_rel_det(rest$5),
        de$5 = match$5[4],
        ed$5 = match$5[3],
        af$5 = match$5[2],
        fa$5 = match$5[1];
       return [0,
               function(param){fa$5(0); return;},
               function(param){af$5(0); return;},
               ed$5,
               de$5];
      case 7:
       var
        rest$6 = param[1],
        match$6 = fmtty_rel_det(rest$6),
        de$6 = match$6[4],
        ed$6 = match$6[3],
        af$6 = match$6[2],
        fa$6 = match$6[1];
       return [0,
               function(param){fa$6(0); return;},
               function(param){af$6(0); return;},
               ed$6,
               de$6];
      case 8:
       var
        rest$7 = param[2],
        match$7 = fmtty_rel_det(rest$7),
        de$7 = match$7[4],
        ed$7 = match$7[3],
        af$7 = match$7[2],
        fa$7 = match$7[1];
       return [0,
               function(param){fa$7(0); return;},
               function(param){af$7(0); return;},
               ed$7,
               de$7];
      case 9:
       var
        rest$8 = param[3],
        ty2 = param[2],
        ty1 = param[1],
        match$8 = fmtty_rel_det(rest$8),
        de$8 = match$8[4],
        ed$8 = match$8[3],
        af$8 = match$8[2],
        fa$8 = match$8[1],
        ty = trans(symm(ty1), ty2),
        match$9 = fmtty_rel_det(ty),
        jd = match$9[4],
        dj = match$9[3],
        ga = match$9[2],
        ag = match$9[1];
       return [0,
               function(param){fa$8(0); ag(0); return;},
               function(param){ga(0); af$8(0); return;},
               function(param){ed$8(0); dj(0); return;},
               function(param){jd(0); de$8(0); return;}];
      case 10:
       var
        rest$9 = param[1],
        match$10 = fmtty_rel_det(rest$9),
        de$9 = match$10[4],
        ed$9 = match$10[3],
        af$9 = match$10[2],
        fa$9 = match$10[1];
       return [0,
               function(param){fa$9(0); return;},
               function(param){af$9(0); return;},
               ed$9,
               de$9];
      case 11:
       var
        rest$10 = param[1],
        match$11 = fmtty_rel_det(rest$10),
        de$10 = match$11[4],
        ed$10 = match$11[3],
        af$10 = match$11[2],
        fa$10 = match$11[1];
       return [0,
               function(param){fa$10(0); return;},
               function(param){af$10(0); return;},
               ed$10,
               de$10];
      case 12:
       var
        rest$11 = param[1],
        match$12 = fmtty_rel_det(rest$11),
        de$11 = match$12[4],
        ed$11 = match$12[3],
        af$11 = match$12[2],
        fa$11 = match$12[1];
       return [0,
               function(param){fa$11(0); return;},
               function(param){af$11(0); return;},
               ed$11,
               de$11];
      case 13:
       var
        rest$12 = param[1],
        match$13 = fmtty_rel_det(rest$12),
        de$12 = match$13[4],
        ed$12 = match$13[3],
        af$12 = match$13[2],
        fa$12 = match$13[1];
       return [0,
               function(param){fa$12(0); return;},
               function(param){af$12(0); return;},
               function(param){ed$12(0); return;},
               function(param){de$12(0); return;}];
      default:
       var
        rest$13 = param[1],
        match$14 = fmtty_rel_det(rest$13),
        de$13 = match$14[4],
        ed$13 = match$14[3],
        af$13 = match$14[2],
        fa$13 = match$14[1];
       return [0,
               function(param){fa$13(0); return;},
               function(param){af$13(0); return;},
               function(param){ed$13(0); return;},
               function(param){de$13(0); return;}];
    }
   }
   function trans(ty1, ty2){
    a:
    {
     b:
     {
      c:
      {
       d:
       {
        e:
        {
         f:
         {
          g:
          {
           if(typeof ty1 !== "number"){
            switch(ty1[0]){
              case 0:
               var rest1 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 0:
                   var rest2 = ty2[1]; return [0, trans(rest1, rest2)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 1:
               var rest1$0 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 1:
                   var rest2$0 = ty2[1]; return [1, trans(rest1$0, rest2$0)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 2:
               var rest1$1 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 2:
                   var rest2$1 = ty2[1]; return [2, trans(rest1$1, rest2$1)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 3:
               var rest1$2 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 3:
                   var rest2$2 = ty2[1]; return [3, trans(rest1$2, rest2$2)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 4:
               var rest1$3 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 4:
                   var rest2$3 = ty2[1]; return [4, trans(rest1$3, rest2$3)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 5:
               var rest1$4 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 5:
                   var rest2$4 = ty2[1]; return [5, trans(rest1$4, rest2$4)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 6:
               var rest1$5 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 6:
                   var rest2$5 = ty2[1]; return [6, trans(rest1$5, rest2$5)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 7:
               var rest1$6 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 7:
                   var rest2$6 = ty2[1]; return [7, trans(rest1$6, rest2$6)];
                  case 8:
                   break f;
                  case 9:
                   break g;
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               break;
              case 8:
               var rest1$7 = ty1[2], ty1$0 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 8:
                   var
                    rest2$7 = ty2[2],
                    ty2$0 = ty2[1],
                    _dd_ = trans(rest1$7, rest2$7);
                   return [8, trans(ty1$0, ty2$0), _dd_];
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _k_], 1);
              case 9:
               var rest1$8 = ty1[3], ty12 = ty1[2], ty11 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 8:
                   break f;
                  case 9:
                   var
                    rest2$8 = ty2[3],
                    ty22 = ty2[2],
                    ty21 = ty2[1],
                    ty = trans(symm(ty12), ty21),
                    match = fmtty_rel_det(ty),
                    f4 = match[4],
                    f2 = match[2];
                   f2(0);
                   f4(0);
                   return [9, ty11, ty22, trans(rest1$8, rest2$8)];
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   break e;
                }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _l_], 1);
              case 10:
               var rest1$9 = ty1[1];
               if(typeof ty2 !== "number" && 10 === ty2[0]){
                var rest2$9 = ty2[1];
                return [10, trans(rest1$9, rest2$9)];
               }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _m_], 1);
              case 11:
               var rest1$10 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   var rest2$10 = ty2[1];
                   return [11, trans(rest1$10, rest2$10)];
                }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _n_], 1);
              case 12:
               var rest1$11 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   var rest2$11 = ty2[1];
                   return [12, trans(rest1$11, rest2$11)];
                }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _o_], 1);
              case 13:
               var rest1$12 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   var rest2$12 = ty2[1];
                   return [13, trans(rest1$12, rest2$12)];
                }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _p_], 1);
              default:
               var rest1$13 = ty1[1];
               if(typeof ty2 !== "number")
                switch(ty2[0]){
                  case 10:
                   break a;
                  case 11:
                   break b;
                  case 12:
                   break c;
                  case 13:
                   break d;
                  case 14:
                   var rest2$13 = ty2[1];
                   return [14, trans(rest1$13, rest2$13)];
                }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _q_], 1);
            }
            throw caml_maybe_attach_backtrace([0, Assert_failure, _j_], 1);
           }
           if(typeof ty2 === "number") return 0;
           switch(ty2[0]){
             case 10:
              break a;
             case 11:
              break b;
             case 12:
              break c;
             case 13:
              break d;
             case 14:
              break e;
             case 8:
              break f;
             case 9: break;
             default:
              throw caml_maybe_attach_backtrace([0, Assert_failure, _b_], 1);
           }
          }
          throw caml_maybe_attach_backtrace([0, Assert_failure, _d_], 1);
         }
         throw caml_maybe_attach_backtrace([0, Assert_failure, _c_], 1);
        }
        throw caml_maybe_attach_backtrace([0, Assert_failure, _i_], 1);
       }
       throw caml_maybe_attach_backtrace([0, Assert_failure, _h_], 1);
      }
      throw caml_maybe_attach_backtrace([0, Assert_failure, _g_], 1);
     }
     throw caml_maybe_attach_backtrace([0, Assert_failure, _f_], 1);
    }
    throw caml_maybe_attach_backtrace([0, Assert_failure, _e_], 1);
   }
   function fmtty_of_fmt(fmtty){
    var fmtty$0 = fmtty;
    for(;;){
     if(typeof fmtty$0 === "number") return 0;
     switch(fmtty$0[0]){
       case 0:
        var rest = fmtty$0[1]; return [0, fmtty_of_fmt(rest)];
       case 1:
        var rest$0 = fmtty$0[1]; return [0, fmtty_of_fmt(rest$0)];
       case 2:
        var rest$1 = fmtty$0[2], pad = fmtty$0[1];
        return fmtty_of_padding_fmtty(pad, [1, fmtty_of_fmt(rest$1)]);
       case 3:
        var rest$2 = fmtty$0[2], pad$0 = fmtty$0[1];
        return fmtty_of_padding_fmtty(pad$0, [1, fmtty_of_fmt(rest$2)]);
       case 4:
        var
         rest$3 = fmtty$0[4],
         prec = fmtty$0[3],
         pad$1 = fmtty$0[2],
         ty_rest = fmtty_of_fmt(rest$3),
         prec_ty = fmtty_of_precision_fmtty(prec, [2, ty_rest]);
        return fmtty_of_padding_fmtty(pad$1, prec_ty);
       case 5:
        var
         rest$4 = fmtty$0[4],
         prec$0 = fmtty$0[3],
         pad$2 = fmtty$0[2],
         ty_rest$0 = fmtty_of_fmt(rest$4),
         prec_ty$0 = fmtty_of_precision_fmtty(prec$0, [3, ty_rest$0]);
        return fmtty_of_padding_fmtty(pad$2, prec_ty$0);
       case 6:
        var
         rest$5 = fmtty$0[4],
         prec$1 = fmtty$0[3],
         pad$3 = fmtty$0[2],
         ty_rest$1 = fmtty_of_fmt(rest$5),
         prec_ty$1 = fmtty_of_precision_fmtty(prec$1, [4, ty_rest$1]);
        return fmtty_of_padding_fmtty(pad$3, prec_ty$1);
       case 7:
        var
         rest$6 = fmtty$0[4],
         prec$2 = fmtty$0[3],
         pad$4 = fmtty$0[2],
         ty_rest$2 = fmtty_of_fmt(rest$6),
         prec_ty$2 = fmtty_of_precision_fmtty(prec$2, [5, ty_rest$2]);
        return fmtty_of_padding_fmtty(pad$4, prec_ty$2);
       case 8:
        var
         rest$7 = fmtty$0[4],
         prec$3 = fmtty$0[3],
         pad$5 = fmtty$0[2],
         ty_rest$3 = fmtty_of_fmt(rest$7),
         prec_ty$3 = fmtty_of_precision_fmtty(prec$3, [6, ty_rest$3]);
        return fmtty_of_padding_fmtty(pad$5, prec_ty$3);
       case 9:
        var rest$8 = fmtty$0[2], pad$6 = fmtty$0[1];
        return fmtty_of_padding_fmtty(pad$6, [7, fmtty_of_fmt(rest$8)]);
       case 10:
        var fmtty$1 = fmtty$0[1], fmtty$0 = fmtty$1; break;
       case 11:
        var fmtty$2 = fmtty$0[2], fmtty$0 = fmtty$2; break;
       case 12:
        var fmtty$3 = fmtty$0[2], fmtty$0 = fmtty$3; break;
       case 13:
        var rest$9 = fmtty$0[3], ty = fmtty$0[2];
        return [8, ty, fmtty_of_fmt(rest$9)];
       case 14:
        var rest$10 = fmtty$0[3], ty$0 = fmtty$0[2];
        return [9, ty$0, ty$0, fmtty_of_fmt(rest$10)];
       case 15:
        var rest$11 = fmtty$0[1]; return [10, fmtty_of_fmt(rest$11)];
       case 16:
        var rest$12 = fmtty$0[1]; return [11, fmtty_of_fmt(rest$12)];
       case 17:
        var fmtty$4 = fmtty$0[2], fmtty$0 = fmtty$4; break;
       case 18:
        var
         rest$13 = fmtty$0[2],
         formatting_gen = fmtty$0[1],
         _da_ = fmtty_of_fmt(rest$13);
        if(0 === formatting_gen[0])
         var fmt = formatting_gen[1][1], _db_ = fmtty_of_fmt(fmt);
        else
         var fmt$0 = formatting_gen[1][1], _db_ = fmtty_of_fmt(fmt$0);
        return caml_call2(CamlinternalFormatBasics[1], _db_, _da_);
       case 19:
        var rest$14 = fmtty$0[1]; return [13, fmtty_of_fmt(rest$14)];
       case 20:
        var rest$15 = fmtty$0[3]; return [1, fmtty_of_fmt(rest$15)];
       case 21:
        var rest$16 = fmtty$0[2]; return [2, fmtty_of_fmt(rest$16)];
       case 22:
        var rest$17 = fmtty$0[1]; return [0, fmtty_of_fmt(rest$17)];
       case 23:
        var fmtty$5 = fmtty$0[2], ign = fmtty$0[1];
        if(typeof ign === "number")
         switch(ign){
           case 0:
            var fmtty$0 = fmtty$5; break;
           case 1:
            var fmtty$0 = fmtty$5; break;
           case 2:
            return [14, fmtty_of_fmt(fmtty$5)];
           default: var fmtty$0 = fmtty$5;
         }
        else
         switch(ign[0]){
           case 0:
            var fmtty$0 = fmtty$5; break;
           case 1:
            var fmtty$0 = fmtty$5; break;
           case 2:
            var fmtty$0 = fmtty$5; break;
           case 3:
            var fmtty$0 = fmtty$5; break;
           case 4:
            var fmtty$0 = fmtty$5; break;
           case 5:
            var fmtty$0 = fmtty$5; break;
           case 6:
            var fmtty$0 = fmtty$5; break;
           case 7:
            var fmtty$0 = fmtty$5; break;
           case 8:
            var fmtty$0 = fmtty$5; break;
           case 9:
            var fmtty$6 = ign[2], _dc_ = fmtty_of_fmt(fmtty$5);
            return caml_call2(CamlinternalFormatBasics[1], fmtty$6, _dc_);
           case 10:
            var fmtty$0 = fmtty$5; break;
           default: var fmtty$0 = fmtty$5;
         }
        break;
       default:
        var rest$18 = fmtty$0[3], arity = fmtty$0[1];
        return fmtty_of_custom(arity, fmtty_of_fmt(rest$18));
     }
    }
   }
   function fmtty_of_custom(arity, fmtty){
    if(! arity) return fmtty;
    var arity$0 = arity[1];
    return [12, fmtty_of_custom(arity$0, fmtty)];
   }
   function fmtty_of_padding_fmtty(pad, fmtty){
    return typeof pad === "number" ? fmtty : 0 === pad[0] ? fmtty : [2, fmtty];
   }
   function fmtty_of_precision_fmtty(prec, fmtty){
    return typeof prec === "number" ? prec ? [2, fmtty] : fmtty : fmtty;
   }
   var
    Type_mismatch =
      [248, "CamlinternalFormat.Type_mismatch", runtime.caml_fresh_oo_id(0)],
    cst_d = "%d",
    cst_d$0 = "%+d",
    cst_d$1 = "% d",
    cst_i$0 = cst_i$3,
    cst_i$1 = "%+i",
    cst_i$2 = "% i",
    cst_x = "%x",
    cst_x$0 = "%#x",
    cst_X = "%X",
    cst_X$0 = "%#X",
    cst_o = "%o",
    cst_o$0 = "%#o",
    cst_u = cst_u$0,
    cst_Ld = "%Ld",
    cst_Ld$0 = "%+Ld",
    cst_Ld$1 = "% Ld",
    cst_Li$0 = cst_Li$3,
    cst_Li$1 = "%+Li",
    cst_Li$2 = "% Li",
    cst_Lx = "%Lx",
    cst_Lx$0 = "%#Lx",
    cst_LX = "%LX",
    cst_LX$0 = "%#LX",
    cst_Lo = "%Lo",
    cst_Lo$0 = "%#Lo",
    cst_Lu = "%Lu",
    cst_ld = "%ld",
    cst_ld$0 = "%+ld",
    cst_ld$1 = "% ld",
    cst_li$0 = cst_li$3,
    cst_li$1 = "%+li",
    cst_li$2 = "% li",
    cst_lx = "%lx",
    cst_lx$0 = "%#lx",
    cst_lX = "%lX",
    cst_lX$0 = "%#lX",
    cst_lo = "%lo",
    cst_lo$0 = "%#lo",
    cst_lu = "%lu",
    cst_nd = "%nd",
    cst_nd$0 = "%+nd",
    cst_nd$1 = "% nd",
    cst_ni$0 = cst_ni$3,
    cst_ni$1 = "%+ni",
    cst_ni$2 = "% ni",
    cst_nx = "%nx",
    cst_nx$0 = "%#nx",
    cst_nX = "%nX",
    cst_nX$0 = "%#nX",
    cst_no = "%no",
    cst_no$0 = "%#no",
    cst_nu = "%nu",
    _r_ = [0, 103],
    cst_neg_infinity = "neg_infinity",
    cst_infinity = "infinity",
    cst_nan = "nan",
    _s_ = [0, cst_camlinternalFormat_ml, 1558, 4],
    cst_Printf_bad_conversion = "Printf: bad conversion %[",
    _t_ = [0, cst_camlinternalFormat_ml, 1626, 39],
    _u_ = [0, cst_camlinternalFormat_ml, 1649, 31],
    _v_ = [0, cst_camlinternalFormat_ml, 1650, 31],
    cst_Printf_bad_conversion$0 = "Printf: bad conversion %_",
    _w_ = [0, cst_camlinternalFormat_ml, 1830, 8],
    _x_ = [0, 0, 4],
    _y_ =
      [0,
       [11, "invalid box description ", [3, 0, 0]],
       "invalid box description %S"],
    _z_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11, cst_at_character_number, [4, 0, 0, 0, [11, cst$44, [2, 0, 0]]]]]],
       "invalid format %S: at character number %d, %s"],
    cst_unexpected_end_of_format = "unexpected end of format",
    cst_non_zero_widths_are_unsupp =
      "non-zero widths are unsupported for %c conversions",
    _A_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4, 0, 0, 0, [11, ", '", [0, [11, "' without ", [2, 0, 0]]]]]]]],
       "invalid format %S: at character number %d, '%c' without %s"],
    _B_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4, 0, 0, 0, [11, cst$44, [2, 0, [11, " expected, read ", [1, 0]]]]]]]],
       "invalid format %S: at character number %d, %s expected, read %C"],
    _C_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4, 0, 0, 0, [11, ", duplicate flag ", [1, 0]]]]]],
       "invalid format %S: at character number %d, duplicate flag %C"],
    cst_padding = "padding",
    _D_ = [0, 1, 0],
    cst_0 = cst_0$3,
    _E_ = [0, 0],
    cst_precision = cst_precision$3,
    _F_ = [1, 0],
    _G_ = [1, 1],
    cst_precision$0 = cst_precision$3,
    _H_ = [1, 1],
    cst_precision$1 = cst_precision$3,
    cst_0$0 = cst_0$3,
    _I_ = [1, 1],
    cst_0$1 = cst_0$3,
    cst_0$2 = "'0'",
    _J_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4,
           0,
           0,
           0,
           [11, ', invalid conversion "', [12, 37, [0, [12, 34, 0]]]]]]]],
       'invalid format %S: at character number %d, invalid conversion "%%%c"'],
    _K_ = [0, 0],
    cst_padding$0 = "`padding'",
    _L_ = [0, 0],
    cst_precision$2 = "`precision'",
    _M_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4,
           0,
           0,
           0,
           [11,
            ", flag ",
            [1,
             [11,
              " is only allowed after the '",
              [12, 37, [11, "', before padding and precision", 0]]]]]]]]],
       "invalid format %S: at character number %d, flag %C is only allowed after the '%%', before padding and precision"],
    _N_ = [0, [12, 64, 0]],
    _O_ = [0, "@ ", 1, 0],
    _P_ = [0, "@,", 0, 0],
    _Q_ = [2, 60],
    _R_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          ": '",
          [12,
           37,
           [11,
            "' alone is not accepted in character sets, use ",
            [12,
             37,
             [12,
              37,
              [11, " instead at position ", [4, 0, 0, 0, [12, 46, 0]]]]]]]]]],
       "invalid format %S: '%%' alone is not accepted in character sets, use %%%% instead at position %d."],
    _S_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          ": integer ",
          [4, 0, 0, 0, [11, " is greater than the limit ", [4, 0, 0, 0, 0]]]]]],
       "invalid format %S: integer %d is greater than the limit %d"],
    _T_ = [0, cst_camlinternalFormat_ml, 2837, 11],
    cst_digit = "digit",
    _U_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          ': unclosed sub-format, expected "',
          [12, 37, [0, [11, '" at character number ', [4, 0, 0, 0, 0]]]]]]],
       'invalid format %S: unclosed sub-format, expected "%%%c" at character number %d'],
    cst_character = "character ')'",
    cst_character$0 = "character '}'",
    _V_ = [0, cst_camlinternalFormat_ml, 2899, 34],
    _W_ = [0, cst_camlinternalFormat_ml, 2935, 28],
    _X_ = [0, cst_camlinternalFormat_ml, 2957, 11],
    _Y_ =
      [0,
       [11,
        cst_invalid_format,
        [3,
         0,
         [11,
          cst_at_character_number,
          [4,
           0,
           0,
           0,
           [11,
            cst$44,
            [2,
             0,
             [11,
              " is incompatible with '",
              [0, [11, "' in sub-format ", [3, 0, 0]]]]]]]]]],
       "invalid format %S: at character number %d, %s is incompatible with '%c' in sub-format %S"],
    _Z_ =
      [0,
       [11, cst_bad_input_format_type_mism, [3, 0, [11, cst_and, [3, 0, 0]]]],
       cst_bad_input_format_type_mism$0],
    ___ =
      [0,
       [11, cst_bad_input_format_type_mism, [3, 0, [11, cst_and, [3, 0, 0]]]],
       cst_bad_input_format_type_mism$0];
   function type_padding(pad, fmtty){
    if(typeof pad === "number") return [0, 0, fmtty];
    if(0 === pad[0]){
     var w = pad[2], padty = pad[1];
     return [0, [0, padty, w], fmtty];
    }
    if(typeof fmtty !== "number" && 2 === fmtty[0]){
     var rest = fmtty[1], padty$0 = pad[1];
     return [0, [1, padty$0], rest];
    }
    throw caml_maybe_attach_backtrace(Type_mismatch, 1);
   }
   function type_padprec(pad, prec, fmtty){
    var match = type_padding(pad, fmtty);
    if(typeof prec !== "number"){
     var rest$1 = match[2], pad$2 = match[1], p = prec[1];
     return [0, pad$2, [0, p], rest$1];
    }
    if(! prec){
     var rest$0 = match[2], pad$1 = match[1];
     return [0, pad$1, 0, rest$0];
    }
    var match$0 = match[2];
    if(typeof match$0 !== "number" && 2 === match$0[0]){
     var rest = match$0[1], pad$0 = match[1];
     return [0, pad$0, 1, rest];
    }
    throw caml_maybe_attach_backtrace(Type_mismatch, 1);
   }
   function type_format(fmt, fmtty){
    var _c$_ = type_format_gen(fmt, fmtty);
    if(typeof _c$_[2] !== "number")
     throw caml_maybe_attach_backtrace(Type_mismatch, 1);
    var fmt$0 = _c$_[1];
    return fmt$0;
   }
   function type_format_gen(fmt, fmtty0){
    if(typeof fmt === "number") return [0, 0, fmtty0];
    switch(fmt[0]){
      case 0:
       if(typeof fmtty0 !== "number" && 0 === fmtty0[0]){
        var
         fmtty_rest = fmtty0[1],
         fmt_rest = fmt[1],
         match = type_format_gen(fmt_rest, fmtty_rest),
         fmtty = match[2],
         fmt$0 = match[1];
        return [0, [0, fmt$0], fmtty];
       }
       break;
      case 1:
       if(typeof fmtty0 !== "number" && 0 === fmtty0[0]){
        var
         fmtty_rest$0 = fmtty0[1],
         fmt_rest$0 = fmt[1],
         match$0 = type_format_gen(fmt_rest$0, fmtty_rest$0),
         fmtty$0 = match$0[2],
         fmt$1 = match$0[1];
        return [0, [1, fmt$1], fmtty$0];
       }
       break;
      case 2:
       var
        fmt_rest$1 = fmt[2],
        pad = fmt[1],
        match$1 = type_padding(pad, fmtty0),
        pad$0 = match$1[1],
        match$2 = match$1[2];
       if(typeof match$2 !== "number" && 1 === match$2[0]){
        var
         fmtty_rest$1 = match$2[1],
         match$3 = type_format_gen(fmt_rest$1, fmtty_rest$1),
         fmtty$1 = match$3[2],
         fmt$2 = match$3[1];
        return [0, [2, pad$0, fmt$2], fmtty$1];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 3:
       var
        fmt_rest$2 = fmt[2],
        pad$1 = fmt[1],
        match$4 = type_padding(pad$1, fmtty0),
        pad$2 = match$4[1],
        match$5 = match$4[2];
       if(typeof match$5 !== "number" && 1 === match$5[0]){
        var
         fmtty_rest$2 = match$5[1],
         match$6 = type_format_gen(fmt_rest$2, fmtty_rest$2),
         fmtty$2 = match$6[2],
         fmt$3 = match$6[1];
        return [0, [3, pad$2, fmt$3], fmtty$2];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 4:
       var
        fmt_rest$3 = fmt[4],
        prec = fmt[3],
        pad$3 = fmt[2],
        iconv = fmt[1],
        match$7 = type_padprec(pad$3, prec, fmtty0),
        pad$4 = match$7[1],
        match$8 = match$7[3];
       if(typeof match$8 !== "number" && 2 === match$8[0]){
        var
         fmtty_rest$3 = match$8[1],
         prec$0 = match$7[2],
         match$9 = type_format_gen(fmt_rest$3, fmtty_rest$3),
         fmtty$3 = match$9[2],
         fmt$4 = match$9[1];
        return [0, [4, iconv, pad$4, prec$0, fmt$4], fmtty$3];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 5:
       var
        fmt_rest$4 = fmt[4],
        prec$1 = fmt[3],
        pad$5 = fmt[2],
        iconv$0 = fmt[1],
        match$10 = type_padprec(pad$5, prec$1, fmtty0),
        pad$6 = match$10[1],
        match$11 = match$10[3];
       if(typeof match$11 !== "number" && 3 === match$11[0]){
        var
         fmtty_rest$4 = match$11[1],
         prec$2 = match$10[2],
         match$12 = type_format_gen(fmt_rest$4, fmtty_rest$4),
         fmtty$4 = match$12[2],
         fmt$5 = match$12[1];
        return [0, [5, iconv$0, pad$6, prec$2, fmt$5], fmtty$4];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 6:
       var
        fmt_rest$5 = fmt[4],
        prec$3 = fmt[3],
        pad$7 = fmt[2],
        iconv$1 = fmt[1],
        match$13 = type_padprec(pad$7, prec$3, fmtty0),
        pad$8 = match$13[1],
        match$14 = match$13[3];
       if(typeof match$14 !== "number" && 4 === match$14[0]){
        var
         fmtty_rest$5 = match$14[1],
         prec$4 = match$13[2],
         match$15 = type_format_gen(fmt_rest$5, fmtty_rest$5),
         fmtty$5 = match$15[2],
         fmt$6 = match$15[1];
        return [0, [6, iconv$1, pad$8, prec$4, fmt$6], fmtty$5];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 7:
       var
        fmt_rest$6 = fmt[4],
        prec$5 = fmt[3],
        pad$9 = fmt[2],
        iconv$2 = fmt[1],
        match$16 = type_padprec(pad$9, prec$5, fmtty0),
        pad$10 = match$16[1],
        match$17 = match$16[3];
       if(typeof match$17 !== "number" && 5 === match$17[0]){
        var
         fmtty_rest$6 = match$17[1],
         prec$6 = match$16[2],
         match$18 = type_format_gen(fmt_rest$6, fmtty_rest$6),
         fmtty$6 = match$18[2],
         fmt$7 = match$18[1];
        return [0, [7, iconv$2, pad$10, prec$6, fmt$7], fmtty$6];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 8:
       var
        fmt_rest$7 = fmt[4],
        prec$7 = fmt[3],
        pad$11 = fmt[2],
        fconv = fmt[1],
        match$19 = type_padprec(pad$11, prec$7, fmtty0),
        pad$12 = match$19[1],
        match$20 = match$19[3];
       if(typeof match$20 !== "number" && 6 === match$20[0]){
        var
         fmtty_rest$7 = match$20[1],
         prec$8 = match$19[2],
         match$21 = type_format_gen(fmt_rest$7, fmtty_rest$7),
         fmtty$7 = match$21[2],
         fmt$8 = match$21[1];
        return [0, [8, fconv, pad$12, prec$8, fmt$8], fmtty$7];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 9:
       var
        fmt_rest$8 = fmt[2],
        pad$13 = fmt[1],
        match$22 = type_padding(pad$13, fmtty0),
        pad$14 = match$22[1],
        match$23 = match$22[2];
       if(typeof match$23 !== "number" && 7 === match$23[0]){
        var
         fmtty_rest$8 = match$23[1],
         match$24 = type_format_gen(fmt_rest$8, fmtty_rest$8),
         fmtty$8 = match$24[2],
         fmt$9 = match$24[1];
        return [0, [9, pad$14, fmt$9], fmtty$8];
       }
       throw caml_maybe_attach_backtrace(Type_mismatch, 1);
      case 10:
       var
        fmt_rest$9 = fmt[1],
        match$25 = type_format_gen(fmt_rest$9, fmtty0),
        fmtty$9 = match$25[2],
        fmt$10 = match$25[1];
       return [0, [10, fmt$10], fmtty$9];
      case 11:
       var
        fmt_rest$10 = fmt[2],
        str = fmt[1],
        match$26 = type_format_gen(fmt_rest$10, fmtty0),
        fmtty$10 = match$26[2],
        fmt$11 = match$26[1];
       return [0, [11, str, fmt$11], fmtty$10];
      case 12:
       var
        fmt_rest$11 = fmt[2],
        chr = fmt[1],
        match$27 = type_format_gen(fmt_rest$11, fmtty0),
        fmtty$11 = match$27[2],
        fmt$12 = match$27[1];
       return [0, [12, chr, fmt$12], fmtty$11];
      case 13:
       if(typeof fmtty0 !== "number" && 8 === fmtty0[0]){
        var
         fmtty_rest$9 = fmtty0[2],
         sub_fmtty = fmtty0[1],
         fmt_rest$12 = fmt[3],
         sub_fmtty$0 = fmt[2],
         pad_opt = fmt[1];
        if(caml_notequal([0, sub_fmtty$0], [0, sub_fmtty]))
         throw caml_maybe_attach_backtrace(Type_mismatch, 1);
        var
         match$28 = type_format_gen(fmt_rest$12, fmtty_rest$9),
         fmtty$12 = match$28[2],
         fmt$13 = match$28[1];
        return [0, [13, pad_opt, sub_fmtty, fmt$13], fmtty$12];
       }
       break;
      case 14:
       if(typeof fmtty0 !== "number" && 9 === fmtty0[0]){
        var
         fmtty_rest$10 = fmtty0[3],
         sub_fmtty1 = fmtty0[1],
         fmt_rest$13 = fmt[3],
         sub_fmtty$1 = fmt[2],
         pad_opt$0 = fmt[1],
         _c9_ = [0, caml_call1(CamlinternalFormatBasics[2], sub_fmtty1)];
        if
         (caml_notequal
           ([0, caml_call1(CamlinternalFormatBasics[2], sub_fmtty$1)], _c9_))
         throw caml_maybe_attach_backtrace(Type_mismatch, 1);
        var
         match$29 =
           type_format_gen
            (fmt_rest$13,
             caml_call1(CamlinternalFormatBasics[2], fmtty_rest$10)),
         fmtty$13 = match$29[2],
         fmt$14 = match$29[1];
        return [0, [14, pad_opt$0, sub_fmtty1, fmt$14], fmtty$13];
       }
       break;
      case 15:
       if(typeof fmtty0 !== "number" && 10 === fmtty0[0]){
        var
         fmtty_rest$11 = fmtty0[1],
         fmt_rest$14 = fmt[1],
         match$30 = type_format_gen(fmt_rest$14, fmtty_rest$11),
         fmtty$14 = match$30[2],
         fmt$15 = match$30[1];
        return [0, [15, fmt$15], fmtty$14];
       }
       break;
      case 16:
       if(typeof fmtty0 !== "number" && 11 === fmtty0[0]){
        var
         fmtty_rest$12 = fmtty0[1],
         fmt_rest$15 = fmt[1],
         match$31 = type_format_gen(fmt_rest$15, fmtty_rest$12),
         fmtty$15 = match$31[2],
         fmt$16 = match$31[1];
        return [0, [16, fmt$16], fmtty$15];
       }
       break;
      case 17:
       var
        fmt_rest$16 = fmt[2],
        formatting_lit = fmt[1],
        match$32 = type_format_gen(fmt_rest$16, fmtty0),
        fmtty$16 = match$32[2],
        fmt$17 = match$32[1];
       return [0, [17, formatting_lit, fmt$17], fmtty$16];
      case 18:
       var fmt_rest$17 = fmt[2], formatting_gen = fmt[1];
       if(0 === formatting_gen[0]){
        var
         match$36 = formatting_gen[1],
         str$0 = match$36[2],
         fmt1 = match$36[1],
         match$37 = type_format_gen(fmt1, fmtty0),
         fmtty2 = match$37[2],
         fmt2 = match$37[1],
         match$38 = type_format_gen(fmt_rest$17, fmtty2),
         fmtty3 = match$38[2],
         fmt3 = match$38[1];
        return [0, [18, [0, [0, fmt2, str$0]], fmt3], fmtty3];
       }
       var
        match$39 = formatting_gen[1],
        str$1 = match$39[2],
        fmt1$0 = match$39[1],
        match$40 = type_format_gen(fmt1$0, fmtty0),
        fmtty2$0 = match$40[2],
        fmt2$0 = match$40[1],
        match$41 = type_format_gen(fmt_rest$17, fmtty2$0),
        fmtty3$0 = match$41[2],
        fmt3$0 = match$41[1];
       return [0, [18, [1, [0, fmt2$0, str$1]], fmt3$0], fmtty3$0];
      case 19:
       if(typeof fmtty0 !== "number" && 13 === fmtty0[0]){
        var
         fmtty_rest$13 = fmtty0[1],
         fmt_rest$18 = fmt[1],
         match$33 = type_format_gen(fmt_rest$18, fmtty_rest$13),
         fmtty$17 = match$33[2],
         fmt$18 = match$33[1];
        return [0, [19, fmt$18], fmtty$17];
       }
       break;
      case 20:
       if(typeof fmtty0 !== "number" && 1 === fmtty0[0]){
        var
         fmtty_rest$14 = fmtty0[1],
         fmt_rest$19 = fmt[3],
         char_set = fmt[2],
         width_opt = fmt[1],
         match$34 = type_format_gen(fmt_rest$19, fmtty_rest$14),
         fmtty$18 = match$34[2],
         fmt$19 = match$34[1];
        return [0, [20, width_opt, char_set, fmt$19], fmtty$18];
       }
       break;
      case 21:
       if(typeof fmtty0 !== "number" && 2 === fmtty0[0]){
        var
         fmtty_rest$15 = fmtty0[1],
         fmt_rest$20 = fmt[2],
         counter = fmt[1],
         match$35 = type_format_gen(fmt_rest$20, fmtty_rest$15),
         fmtty$19 = match$35[2],
         fmt$20 = match$35[1];
        return [0, [21, counter, fmt$20], fmtty$19];
       }
       break;
      case 23:
       var rest = fmt[2], ign = fmt[1];
       if(typeof ign !== "number")
        switch(ign[0]){
          case 0:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 1:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 2:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 3:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 4:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 5:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 6:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 7:
           return type_ignored_param_one(ign, rest, fmtty0);
          case 8:
           var sub_fmtty$2 = ign[2], pad_opt$1 = ign[1];
           return type_ignored_param_one
                   ([8, pad_opt$1, sub_fmtty$2], rest, fmtty0);
          case 9:
           var
            sub_fmtty$3 = ign[2],
            pad_opt$2 = ign[1],
            _c__ = type_ignored_format_substituti(sub_fmtty$3, rest, fmtty0),
            match$43 = _c__[2],
            fmtty$21 = match$43[2],
            fmt$22 = match$43[1],
            sub_fmtty$4 = _c__[1];
           return [0, [23, [9, pad_opt$2, sub_fmtty$4], fmt$22], fmtty$21];
          case 10:
           return type_ignored_param_one(ign, rest, fmtty0);
          default: return type_ignored_param_one(ign, rest, fmtty0);
        }
       switch(ign){
         case 0:
          return type_ignored_param_one(ign, rest, fmtty0);
         case 1:
          return type_ignored_param_one(ign, rest, fmtty0);
         case 2:
          if(typeof fmtty0 !== "number" && 14 === fmtty0[0]){
           var
            fmtty_rest$16 = fmtty0[1],
            match$42 = type_format_gen(rest, fmtty_rest$16),
            fmtty$20 = match$42[2],
            fmt$21 = match$42[1];
           return [0, [23, 2, fmt$21], fmtty$20];
          }
          throw caml_maybe_attach_backtrace(Type_mismatch, 1);
         default: return type_ignored_param_one(ign, rest, fmtty0);
       }
    }
    throw caml_maybe_attach_backtrace(Type_mismatch, 1);
   }
   function type_ignored_param_one(ign, fmt, fmtty){
    var
     match = type_format_gen(fmt, fmtty),
     fmtty$0 = match[2],
     fmt$0 = match[1];
    return [0, [23, ign, fmt$0], fmtty$0];
   }
   function type_ignored_format_substituti(sub_fmtty, fmt, fmtty){
    if(typeof sub_fmtty === "number")
     return [0, 0, type_format_gen(fmt, fmtty)];
    switch(sub_fmtty[0]){
      case 0:
       if(typeof fmtty !== "number" && 0 === fmtty[0]){
        var
         fmtty_rest = fmtty[1],
         sub_fmtty_rest = sub_fmtty[1],
         match =
           type_ignored_format_substituti(sub_fmtty_rest, fmt, fmtty_rest),
         fmt$0 = match[2],
         sub_fmtty_rest$0 = match[1];
        return [0, [0, sub_fmtty_rest$0], fmt$0];
       }
       break;
      case 1:
       if(typeof fmtty !== "number" && 1 === fmtty[0]){
        var
         fmtty_rest$0 = fmtty[1],
         sub_fmtty_rest$1 = sub_fmtty[1],
         match$0 =
           type_ignored_format_substituti(sub_fmtty_rest$1, fmt, fmtty_rest$0),
         fmt$1 = match$0[2],
         sub_fmtty_rest$2 = match$0[1];
        return [0, [1, sub_fmtty_rest$2], fmt$1];
       }
       break;
      case 2:
       if(typeof fmtty !== "number" && 2 === fmtty[0]){
        var
         fmtty_rest$1 = fmtty[1],
         sub_fmtty_rest$3 = sub_fmtty[1],
         match$1 =
           type_ignored_format_substituti(sub_fmtty_rest$3, fmt, fmtty_rest$1),
         fmt$2 = match$1[2],
         sub_fmtty_rest$4 = match$1[1];
        return [0, [2, sub_fmtty_rest$4], fmt$2];
       }
       break;
      case 3:
       if(typeof fmtty !== "number" && 3 === fmtty[0]){
        var
         fmtty_rest$2 = fmtty[1],
         sub_fmtty_rest$5 = sub_fmtty[1],
         match$2 =
           type_ignored_format_substituti(sub_fmtty_rest$5, fmt, fmtty_rest$2),
         fmt$3 = match$2[2],
         sub_fmtty_rest$6 = match$2[1];
        return [0, [3, sub_fmtty_rest$6], fmt$3];
       }
       break;
      case 4:
       if(typeof fmtty !== "number" && 4 === fmtty[0]){
        var
         fmtty_rest$3 = fmtty[1],
         sub_fmtty_rest$7 = sub_fmtty[1],
         match$3 =
           type_ignored_format_substituti(sub_fmtty_rest$7, fmt, fmtty_rest$3),
         fmt$4 = match$3[2],
         sub_fmtty_rest$8 = match$3[1];
        return [0, [4, sub_fmtty_rest$8], fmt$4];
       }
       break;
      case 5:
       if(typeof fmtty !== "number" && 5 === fmtty[0]){
        var
         fmtty_rest$4 = fmtty[1],
         sub_fmtty_rest$9 = sub_fmtty[1],
         match$4 =
           type_ignored_format_substituti(sub_fmtty_rest$9, fmt, fmtty_rest$4),
         fmt$5 = match$4[2],
         sub_fmtty_rest$10 = match$4[1];
        return [0, [5, sub_fmtty_rest$10], fmt$5];
       }
       break;
      case 6:
       if(typeof fmtty !== "number" && 6 === fmtty[0]){
        var
         fmtty_rest$5 = fmtty[1],
         sub_fmtty_rest$11 = sub_fmtty[1],
         match$5 =
           type_ignored_format_substituti
            (sub_fmtty_rest$11, fmt, fmtty_rest$5),
         fmt$6 = match$5[2],
         sub_fmtty_rest$12 = match$5[1];
        return [0, [6, sub_fmtty_rest$12], fmt$6];
       }
       break;
      case 7:
       if(typeof fmtty !== "number" && 7 === fmtty[0]){
        var
         fmtty_rest$6 = fmtty[1],
         sub_fmtty_rest$13 = sub_fmtty[1],
         match$6 =
           type_ignored_format_substituti
            (sub_fmtty_rest$13, fmt, fmtty_rest$6),
         fmt$7 = match$6[2],
         sub_fmtty_rest$14 = match$6[1];
        return [0, [7, sub_fmtty_rest$14], fmt$7];
       }
       break;
      case 8:
       if(typeof fmtty !== "number" && 8 === fmtty[0]){
        var
         fmtty_rest$7 = fmtty[2],
         sub2_fmtty = fmtty[1],
         sub_fmtty_rest$15 = sub_fmtty[2],
         sub2_fmtty$0 = sub_fmtty[1];
        if(caml_notequal([0, sub2_fmtty$0], [0, sub2_fmtty]))
         throw caml_maybe_attach_backtrace(Type_mismatch, 1);
        var
         match$7 =
           type_ignored_format_substituti
            (sub_fmtty_rest$15, fmt, fmtty_rest$7),
         fmt$8 = match$7[2],
         sub_fmtty_rest$16 = match$7[1];
        return [0, [8, sub2_fmtty, sub_fmtty_rest$16], fmt$8];
       }
       break;
      case 9:
       if(typeof fmtty !== "number" && 9 === fmtty[0]){
        var
         fmtty_rest$8 = fmtty[3],
         sub2_fmtty$1 = fmtty[2],
         sub1_fmtty = fmtty[1],
         sub_fmtty_rest$17 = sub_fmtty[3],
         sub2_fmtty$2 = sub_fmtty[2],
         sub1_fmtty$0 = sub_fmtty[1],
         _c7_ = [0, caml_call1(CamlinternalFormatBasics[2], sub1_fmtty)];
        if
         (caml_notequal
           ([0, caml_call1(CamlinternalFormatBasics[2], sub1_fmtty$0)], _c7_))
         throw caml_maybe_attach_backtrace(Type_mismatch, 1);
        var _c8_ = [0, caml_call1(CamlinternalFormatBasics[2], sub2_fmtty$1)];
        if
         (caml_notequal
           ([0, caml_call1(CamlinternalFormatBasics[2], sub2_fmtty$2)], _c8_))
         throw caml_maybe_attach_backtrace(Type_mismatch, 1);
        var
         sub_fmtty$0 = trans(symm(sub1_fmtty), sub2_fmtty$1),
         match$8 = fmtty_rel_det(sub_fmtty$0),
         f4 = match$8[4],
         f2 = match$8[2];
        f2(0);
        f4(0);
        var
         match$9 =
           type_ignored_format_substituti
            (caml_call1(CamlinternalFormatBasics[2], sub_fmtty_rest$17),
             fmt,
             fmtty_rest$8),
         fmt$9 = match$9[2],
         sub_fmtty_rest$18 = match$9[1];
        return [0,
                [9, sub1_fmtty, sub2_fmtty$1, symm(sub_fmtty_rest$18)],
                fmt$9];
       }
       break;
      case 10:
       if(typeof fmtty !== "number" && 10 === fmtty[0]){
        var
         fmtty_rest$9 = fmtty[1],
         sub_fmtty_rest$19 = sub_fmtty[1],
         match$10 =
           type_ignored_format_substituti
            (sub_fmtty_rest$19, fmt, fmtty_rest$9),
         fmt$10 = match$10[2],
         sub_fmtty_rest$20 = match$10[1];
        return [0, [10, sub_fmtty_rest$20], fmt$10];
       }
       break;
      case 11:
       if(typeof fmtty !== "number" && 11 === fmtty[0]){
        var
         fmtty_rest$10 = fmtty[1],
         sub_fmtty_rest$21 = sub_fmtty[1],
         match$11 =
           type_ignored_format_substituti
            (sub_fmtty_rest$21, fmt, fmtty_rest$10),
         fmt$11 = match$11[2],
         sub_fmtty_rest$22 = match$11[1];
        return [0, [11, sub_fmtty_rest$22], fmt$11];
       }
       break;
      case 13:
       if(typeof fmtty !== "number" && 13 === fmtty[0]){
        var
         fmtty_rest$11 = fmtty[1],
         sub_fmtty_rest$23 = sub_fmtty[1],
         match$12 =
           type_ignored_format_substituti
            (sub_fmtty_rest$23, fmt, fmtty_rest$11),
         fmt$12 = match$12[2],
         sub_fmtty_rest$24 = match$12[1];
        return [0, [13, sub_fmtty_rest$24], fmt$12];
       }
       break;
      case 14:
       if(typeof fmtty !== "number" && 14 === fmtty[0]){
        var
         fmtty_rest$12 = fmtty[1],
         sub_fmtty_rest$25 = sub_fmtty[1],
         match$13 =
           type_ignored_format_substituti
            (sub_fmtty_rest$25, fmt, fmtty_rest$12),
         fmt$13 = match$13[2],
         sub_fmtty_rest$26 = match$13[1];
        return [0, [14, sub_fmtty_rest$26], fmt$13];
       }
       break;
    }
    throw caml_maybe_attach_backtrace(Type_mismatch, 1);
   }
   function recast(fmt, fmtty){
    var _c6_ = symm(fmtty);
    return type_format(fmt, caml_call1(CamlinternalFormatBasics[2], _c6_));
   }
   function fix_padding(padty, width, str){
    var
     len = caml_ml_string_length(str),
     padty$0 = 0 <= width ? padty : 0,
     width$0 = caml_call1(Stdlib[18], width);
    if(width$0 <= len) return str;
    var
     _c5_ = 2 === padty$0 ? 48 : 32,
     res = caml_call2(Stdlib_Bytes[1], width$0, _c5_);
    switch(padty$0){
      case 0:
       caml_call5(Stdlib_String[6], str, 0, res, 0, len); break;
      case 1:
       caml_call5(Stdlib_String[6], str, 0, res, width$0 - len | 0, len);
       break;
      default:
       a:
       if(0 < len){
        if
         (43 !== caml_string_get(str, 0)
          && 45 !== caml_string_get(str, 0) && 32 !== caml_string_get(str, 0))
         break a;
        caml_bytes_set(res, 0, caml_string_get(str, 0));
        caml_call5
         (Stdlib_String[6],
          str,
          1,
          res,
          (width$0 - len | 0) + 1 | 0,
          len - 1 | 0);
        break;
       }
       a:
       if(1 < len && 48 === caml_string_get(str, 0)){
        if(120 !== caml_string_get(str, 1) && 88 !== caml_string_get(str, 1))
         break a;
        caml_bytes_set(res, 1, caml_string_get(str, 1));
        caml_call5
         (Stdlib_String[6],
          str,
          2,
          res,
          (width$0 - len | 0) + 2 | 0,
          len - 2 | 0);
        break;
       }
       caml_call5(Stdlib_String[6], str, 0, res, width$0 - len | 0, len);
    }
    return caml_call1(Stdlib_Bytes[44], res);
   }
   function fix_int_precision(prec, str){
    var
     prec$0 = caml_call1(Stdlib[18], prec),
     len = caml_ml_string_length(str),
     c = caml_string_get(str, 0);
    a:
    {
     b:
     {
      if(58 > c){
       if(32 !== c){
        if(43 > c) break a;
        switch(c - 43 | 0){
          case 5:
           c:
           if(len < (prec$0 + 2 | 0) && 1 < len){
            if
             (120 !== caml_string_get(str, 1)
              && 88 !== caml_string_get(str, 1))
             break c;
            var res$1 = caml_call2(Stdlib_Bytes[1], prec$0 + 2 | 0, 48);
            caml_bytes_set(res$1, 1, caml_string_get(str, 1));
            caml_call5
             (Stdlib_String[6],
              str,
              2,
              res$1,
              (prec$0 - len | 0) + 4 | 0,
              len - 2 | 0);
            return caml_call1(Stdlib_Bytes[44], res$1);
           }
           break b;
          case 0:
          case 2: break;
          case 1:
          case 3:
          case 4:
           break a;
          default: break b;
        }
       }
       if(len >= (prec$0 + 1 | 0)) break a;
       var res$0 = caml_call2(Stdlib_Bytes[1], prec$0 + 1 | 0, 48);
       caml_bytes_set(res$0, 0, c);
       caml_call5
        (Stdlib_String[6],
         str,
         1,
         res$0,
         (prec$0 - len | 0) + 2 | 0,
         len - 1 | 0);
       return caml_call1(Stdlib_Bytes[44], res$0);
      }
      if(71 <= c){if(5 < c - 97 >>> 0) break a;} else if(65 > c) break a;
     }
     if(len < prec$0){
      var res = caml_call2(Stdlib_Bytes[1], prec$0, 48);
      caml_call5(Stdlib_String[6], str, 0, res, prec$0 - len | 0, len);
      return caml_call1(Stdlib_Bytes[44], res);
     }
    }
    return str;
   }
   function string_to_caml_string(str){
    var
     str$0 = caml_call1(Stdlib_String[25], str),
     l = caml_ml_string_length(str$0),
     res = caml_call2(Stdlib_Bytes[1], l + 2 | 0, 34);
    caml_blit_string(str$0, 0, res, 1, l);
    return caml_call1(Stdlib_Bytes[44], res);
   }
   function format_of_fconv(fconv, prec){
    var
     prec$0 = caml_call1(Stdlib[18], prec),
     symb = char_of_fconv(_r_, fconv),
     buf = buffer_create(16);
    buffer_add_char(buf, 37);
    bprint_fconv_flag(buf, fconv);
    buffer_add_char(buf, 46);
    buffer_add_string(buf, caml_call1(Stdlib_Int[12], prec$0));
    buffer_add_char(buf, symb);
    return buffer_contents(buf);
   }
   function transform_int_alt(iconv, s){
    if(13 > iconv) return s;
    var n = [0, 0], _c0_ = caml_ml_string_length(s) - 1 | 0, _cZ_ = 0;
    if(_c0_ >= 0){
     var i$0 = _cZ_;
     for(;;){
      if(9 >= caml_string_unsafe_get(s, i$0) - 48 >>> 0) n[1]++;
      var _c4_ = i$0 + 1 | 0;
      if(_c0_ === i$0) break;
      var i$0 = _c4_;
     }
    }
    var
     digits = n[1],
     buf =
       caml_create_bytes
        (caml_ml_string_length(s) + ((digits - 1 | 0) / 3 | 0) | 0),
     pos = [0, 0];
    function put(c){caml_bytes_set(buf, pos[1], c); pos[1]++; return;}
    var
     left = [0, ((digits - 1 | 0) % 3 | 0) + 1 | 0],
     _c2_ = caml_ml_string_length(s) - 1 | 0,
     _c1_ = 0;
    if(_c2_ >= 0){
     var i = _c1_;
     for(;;){
      var c = caml_string_unsafe_get(s, i);
      if(9 < c - 48 >>> 0)
       put(c);
      else{if(0 === left[1]){put(95); left[1] = 3;} left[1] += -1; put(c);}
      var _c3_ = i + 1 | 0;
      if(_c2_ === i) break;
      var i = _c3_;
     }
    }
    return caml_call1(Stdlib_Bytes[44], buf);
   }
   function convert_int(iconv, n){
    switch(iconv){
      case 1:
       var _cY_ = cst_d$0; break;
      case 2:
       var _cY_ = cst_d$1; break;
      case 4:
       var _cY_ = cst_i$1; break;
      case 5:
       var _cY_ = cst_i$2; break;
      case 6:
       var _cY_ = cst_x; break;
      case 7:
       var _cY_ = cst_x$0; break;
      case 8:
       var _cY_ = cst_X; break;
      case 9:
       var _cY_ = cst_X$0; break;
      case 10:
       var _cY_ = cst_o; break;
      case 11:
       var _cY_ = cst_o$0; break;
      case 0:
      case 13:
       var _cY_ = cst_d; break;
      case 3:
      case 14:
       var _cY_ = cst_i$0; break;
      default: var _cY_ = cst_u;
    }
    return transform_int_alt(iconv, caml_format_int(_cY_, n));
   }
   function convert_int32(iconv, n){
    switch(iconv){
      case 1:
       var _cX_ = cst_ld$0; break;
      case 2:
       var _cX_ = cst_ld$1; break;
      case 4:
       var _cX_ = cst_li$1; break;
      case 5:
       var _cX_ = cst_li$2; break;
      case 6:
       var _cX_ = cst_lx; break;
      case 7:
       var _cX_ = cst_lx$0; break;
      case 8:
       var _cX_ = cst_lX; break;
      case 9:
       var _cX_ = cst_lX$0; break;
      case 10:
       var _cX_ = cst_lo; break;
      case 11:
       var _cX_ = cst_lo$0; break;
      case 0:
      case 13:
       var _cX_ = cst_ld; break;
      case 3:
      case 14:
       var _cX_ = cst_li$0; break;
      default: var _cX_ = cst_lu;
    }
    return transform_int_alt(iconv, caml_format_int(_cX_, n));
   }
   function convert_nativeint(iconv, n){
    switch(iconv){
      case 1:
       var _cW_ = cst_nd$0; break;
      case 2:
       var _cW_ = cst_nd$1; break;
      case 4:
       var _cW_ = cst_ni$1; break;
      case 5:
       var _cW_ = cst_ni$2; break;
      case 6:
       var _cW_ = cst_nx; break;
      case 7:
       var _cW_ = cst_nx$0; break;
      case 8:
       var _cW_ = cst_nX; break;
      case 9:
       var _cW_ = cst_nX$0; break;
      case 10:
       var _cW_ = cst_no; break;
      case 11:
       var _cW_ = cst_no$0; break;
      case 0:
      case 13:
       var _cW_ = cst_nd; break;
      case 3:
      case 14:
       var _cW_ = cst_ni$0; break;
      default: var _cW_ = cst_nu;
    }
    return transform_int_alt(iconv, caml_format_int(_cW_, n));
   }
   function convert_int64(iconv, n){
    switch(iconv){
      case 1:
       var _cV_ = cst_Ld$0; break;
      case 2:
       var _cV_ = cst_Ld$1; break;
      case 4:
       var _cV_ = cst_Li$1; break;
      case 5:
       var _cV_ = cst_Li$2; break;
      case 6:
       var _cV_ = cst_Lx; break;
      case 7:
       var _cV_ = cst_Lx$0; break;
      case 8:
       var _cV_ = cst_LX; break;
      case 9:
       var _cV_ = cst_LX$0; break;
      case 10:
       var _cV_ = cst_Lo; break;
      case 11:
       var _cV_ = cst_Lo$0; break;
      case 0:
      case 13:
       var _cV_ = cst_Ld; break;
      case 3:
      case 14:
       var _cV_ = cst_Li$0; break;
      default: var _cV_ = cst_Lu;
    }
    return transform_int_alt(iconv, runtime.caml_int64_format(_cV_, n));
   }
   function convert_float(fconv, prec, x){
    function hex(param){
     switch(fconv[1]){
       case 0:
        var sign = 45; break;
       case 1:
        var sign = 43; break;
       default: var sign = 32;
     }
     return runtime.caml_hexstring_of_float(x, prec, sign);
    }
    function caml_special_val(str){
     var match = runtime.caml_classify_float(x);
     return 3 === match
             ? x < 0. ? cst_neg_infinity : cst_infinity
             : 4 <= match ? cst_nan : str;
    }
    switch(fconv[2]){
      case 5:
       var
        str = caml_format_float(format_of_fconv(fconv, prec), x),
        len = caml_ml_string_length(str),
        i = 0;
       for(;;){
        if(i === len)
         var _cS_ = 0;
        else{
         var _cR_ = caml_string_get(str, i) - 46 | 0;
         a:
         {
          if(23 < _cR_ >>> 0){
           if(55 === _cR_) break a;
          }
          else if(21 < _cR_ - 1 >>> 0) break a;
          var i$0 = i + 1 | 0, i = i$0;
          continue;
         }
         var _cS_ = 1;
        }
        var _cT_ = _cS_ ? str : caml_call2(Stdlib[28], str, cst$17);
        return caml_special_val(_cT_);
       }
      case 6:
       return hex(0);
      case 7:
       var _cU_ = hex(0); return caml_call1(Stdlib_String[26], _cU_);
      case 8:
       return caml_special_val(hex(0));
      default: return caml_format_float(format_of_fconv(fconv, prec), x);
    }
   }
   function string_of_fmtty(fmtty){
    var buf = buffer_create(16);
    bprint_fmtty(buf, fmtty);
    return buffer_contents(buf);
   }
   function make_printf$0(counter, k, acc, fmt){
    var k$0 = k, acc$0 = acc, fmt$0 = fmt;
    for(;;){
     if(typeof fmt$0 === "number") return caml_call1(k$0, acc$0);
     switch(fmt$0[0]){
       case 0:
        var rest = fmt$0[1];
        return function(c){
         var new_acc = [5, acc$0, c];
         return make_printf(k$0, new_acc, rest);};
       case 1:
        var rest$0 = fmt$0[1];
        return function(c){
         var
          str = caml_call1(Stdlib_Char[2], c),
          l = caml_ml_string_length(str),
          res = caml_call2(Stdlib_Bytes[1], l + 2 | 0, 39);
         caml_blit_string(str, 0, res, 1, l);
         var new_acc = [4, acc$0, caml_call1(Stdlib_Bytes[44], res)];
         return make_printf(k$0, new_acc, rest$0);};
       case 2:
        var rest$1 = fmt$0[2], pad = fmt$0[1];
        return make_padding
                (k$0, acc$0, rest$1, pad, function(str){return str;});
       case 3:
        var rest$2 = fmt$0[2], pad$0 = fmt$0[1];
        return make_padding(k$0, acc$0, rest$2, pad$0, string_to_caml_string);
       case 4:
        var
         rest$3 = fmt$0[4],
         prec = fmt$0[3],
         pad$1 = fmt$0[2],
         iconv = fmt$0[1];
        return make_int_padding_precision
                (k$0, acc$0, rest$3, pad$1, prec, convert_int, iconv);
       case 5:
        var
         rest$4 = fmt$0[4],
         prec$0 = fmt$0[3],
         pad$2 = fmt$0[2],
         iconv$0 = fmt$0[1];
        return make_int_padding_precision
                (k$0, acc$0, rest$4, pad$2, prec$0, convert_int32, iconv$0);
       case 6:
        var
         rest$5 = fmt$0[4],
         prec$1 = fmt$0[3],
         pad$3 = fmt$0[2],
         iconv$1 = fmt$0[1];
        return make_int_padding_precision
                (k$0,
                 acc$0,
                 rest$5,
                 pad$3,
                 prec$1,
                 convert_nativeint,
                 iconv$1);
       case 7:
        var
         rest$6 = fmt$0[4],
         prec$2 = fmt$0[3],
         pad$4 = fmt$0[2],
         iconv$2 = fmt$0[1];
        return make_int_padding_precision
                (k$0, acc$0, rest$6, pad$4, prec$2, convert_int64, iconv$2);
       case 8:
        var
         rest$7 = fmt$0[4],
         prec$3 = fmt$0[3],
         pad$5 = fmt$0[2],
         fconv = fmt$0[1];
        if(typeof pad$5 === "number"){
         if(typeof prec$3 === "number")
          return prec$3
                  ? function
                   (p, x){
                    var str = convert_float(fconv, p, x);
                    return make_printf(k$0, [4, acc$0, str], rest$7);
                   }
                  : function
                   (x){
                    var
                     str =
                       convert_float(fconv, default_float_precision(fconv), x);
                    return make_printf(k$0, [4, acc$0, str], rest$7);
                   };
         var p = prec$3[1];
         return function(x){
          var str = convert_float(fconv, p, x);
          return make_printf(k$0, [4, acc$0, str], rest$7);};
        }
        if(0 === pad$5[0]){
         var w = pad$5[2], padty = pad$5[1];
         if(typeof prec$3 === "number")
          return prec$3
                  ? function
                   (p, x){
                    var str = fix_padding(padty, w, convert_float(fconv, p, x));
                    return make_printf(k$0, [4, acc$0, str], rest$7);
                   }
                  : function
                   (x){
                    var
                     str =
                       convert_float(fconv, default_float_precision(fconv), x),
                     str$0 = fix_padding(padty, w, str);
                    return make_printf(k$0, [4, acc$0, str$0], rest$7);
                   };
         var p$0 = prec$3[1];
         return function(x){
          var str = fix_padding(padty, w, convert_float(fconv, p$0, x));
          return make_printf(k$0, [4, acc$0, str], rest$7);};
        }
        var padty$0 = pad$5[1];
        if(typeof prec$3 === "number")
         return prec$3
                 ? function
                  (w, p, x){
                   var
                    str = fix_padding(padty$0, w, convert_float(fconv, p, x));
                   return make_printf(k$0, [4, acc$0, str], rest$7);
                  }
                 : function
                  (w, x){
                   var
                    str =
                      convert_float(fconv, default_float_precision(fconv), x),
                    str$0 = fix_padding(padty$0, w, str);
                   return make_printf(k$0, [4, acc$0, str$0], rest$7);
                  };
        var p$1 = prec$3[1];
        return function(w, x){
         var str = fix_padding(padty$0, w, convert_float(fconv, p$1, x));
         return make_printf(k$0, [4, acc$0, str], rest$7);};
       case 9:
        var rest$8 = fmt$0[2], pad$6 = fmt$0[1];
        return make_padding(k$0, acc$0, rest$8, pad$6, Stdlib[30]);
       case 10:
        var
         rest$9 = fmt$0[1],
         acc$1 = [7, acc$0],
         acc$0 = acc$1,
         fmt$0 = rest$9;
        break;
       case 11:
        var
         rest$10 = fmt$0[2],
         str = fmt$0[1],
         acc$2 = [2, acc$0, str],
         acc$0 = acc$2,
         fmt$0 = rest$10;
        break;
       case 12:
        var
         rest$11 = fmt$0[2],
         chr = fmt$0[1],
         acc$3 = [3, acc$0, chr],
         acc$0 = acc$3,
         fmt$0 = rest$11;
        break;
       case 13:
        var
         rest$12 = fmt$0[3],
         sub_fmtty = fmt$0[2],
         ty = string_of_fmtty(sub_fmtty);
        return function(str){
         return make_printf(k$0, [4, acc$0, ty], rest$12);};
       case 14:
        var rest$13 = fmt$0[3], fmtty = fmt$0[2];
        return function(param){
         var fmt = param[1], _cQ_ = recast(fmt, fmtty);
         return make_printf
                 (k$0,
                  acc$0,
                  caml_call2(CamlinternalFormatBasics[3], _cQ_, rest$13));};
       case 15:
        var rest$14 = fmt$0[1];
        return function(f, x){
         return make_printf
                 (k$0,
                  [6, acc$0, function(o){return caml_call2(f, o, x);}],
                  rest$14);};
       case 16:
        var rest$15 = fmt$0[1];
        return function(f){return make_printf(k$0, [6, acc$0, f], rest$15);};
       case 17:
        var
         rest$16 = fmt$0[2],
         fmting_lit = fmt$0[1],
         acc$4 = [0, acc$0, fmting_lit],
         acc$0 = acc$4,
         fmt$0 = rest$16;
        break;
       case 18:
        var _cO_ = fmt$0[1];
        if(0 === _cO_[0]){
         var rest$17 = fmt$0[2], fmt$1 = _cO_[1][1];
         let acc = acc$0, k = k$0, rest = rest$17;
         var
          k$1 =
            function(kacc){return make_printf(k, [1, acc, [0, kacc]], rest);},
          k$0 = k$1,
          acc$0 = 0,
          fmt$0 = fmt$1;
        }
        else{
         var rest$18 = fmt$0[2], fmt$2 = _cO_[1][1];
         let acc = acc$0, k = k$0, rest = rest$18;
         var
          k$2 =
            function(kacc){return make_printf(k, [1, acc, [1, kacc]], rest);},
          k$0 = k$2,
          acc$0 = 0,
          fmt$0 = fmt$2;
        }
        break;
       case 19:
        throw caml_maybe_attach_backtrace([0, Assert_failure, _s_], 1);
       case 20:
        var
         rest$19 = fmt$0[3],
         new_acc = [8, acc$0, cst_Printf_bad_conversion];
        return function(param){return make_printf(k$0, new_acc, rest$19);};
       case 21:
        var rest$20 = fmt$0[2];
        return function(n){
         var new_acc = [4, acc$0, caml_format_int(cst_u$0, n)];
         return make_printf(k$0, new_acc, rest$20);};
       case 22:
        var rest$21 = fmt$0[1];
        return function(c){
         var new_acc = [5, acc$0, c];
         return make_printf(k$0, new_acc, rest$21);};
       case 23:
        var rest$22 = fmt$0[2], ign = fmt$0[1];
        if(counter >= 50)
         return caml_trampoline_return
                 (make_ignored_param$0, [0, k$0, acc$0, ign, rest$22]);
        var counter$1 = counter + 1 | 0;
        return make_ignored_param$0(counter$1, k$0, acc$0, ign, rest$22);
       default:
        var
         rest$23 = fmt$0[3],
         f = fmt$0[2],
         arity = fmt$0[1],
         _cP_ = caml_call1(f, 0);
        if(counter >= 50)
         return caml_trampoline_return
                 (make_custom$0, [0, k$0, acc$0, rest$23, arity, _cP_]);
        var counter$0 = counter + 1 | 0;
        return make_custom$0(counter$0, k$0, acc$0, rest$23, arity, _cP_);
     }
    }
   }
   function make_printf(k, acc, fmt){
    return caml_trampoline(make_printf$0(0, k, acc, fmt));
   }
   function make_ignored_param$0(counter, k, acc, ign, fmt){
    if(typeof ign === "number")
     switch(ign){
       case 0:
        if(counter >= 50)
         return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
        var counter$0 = counter + 1 | 0;
        return make_invalid_arg(counter$0, k, acc, fmt);
       case 1:
        if(counter >= 50)
         return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
        var counter$1 = counter + 1 | 0;
        return make_invalid_arg(counter$1, k, acc, fmt);
       case 2:
        throw caml_maybe_attach_backtrace([0, Assert_failure, _t_], 1);
       default:
        if(counter >= 50)
         return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
        var counter$2 = counter + 1 | 0;
        return make_invalid_arg(counter$2, k, acc, fmt);
     }
    switch(ign[0]){
      case 0:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$3 = counter + 1 | 0;
       return make_invalid_arg(counter$3, k, acc, fmt);
      case 1:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$4 = counter + 1 | 0;
       return make_invalid_arg(counter$4, k, acc, fmt);
      case 2:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$5 = counter + 1 | 0;
       return make_invalid_arg(counter$5, k, acc, fmt);
      case 3:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$6 = counter + 1 | 0;
       return make_invalid_arg(counter$6, k, acc, fmt);
      case 4:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$7 = counter + 1 | 0;
       return make_invalid_arg(counter$7, k, acc, fmt);
      case 5:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$8 = counter + 1 | 0;
       return make_invalid_arg(counter$8, k, acc, fmt);
      case 6:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$9 = counter + 1 | 0;
       return make_invalid_arg(counter$9, k, acc, fmt);
      case 7:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$10 = counter + 1 | 0;
       return make_invalid_arg(counter$10, k, acc, fmt);
      case 8:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$11 = counter + 1 | 0;
       return make_invalid_arg(counter$11, k, acc, fmt);
      case 9:
       var fmtty = ign[2];
       if(counter >= 50)
        return caml_trampoline_return
                (make_from_fmtty$0, [0, k, acc, fmtty, fmt]);
       var counter$14 = counter + 1 | 0;
       return make_from_fmtty$0(counter$14, k, acc, fmtty, fmt);
      case 10:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$12 = counter + 1 | 0;
       return make_invalid_arg(counter$12, k, acc, fmt);
      default:
       if(counter >= 50)
        return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
       var counter$13 = counter + 1 | 0;
       return make_invalid_arg(counter$13, k, acc, fmt);
    }
   }
   function make_ignored_param(k, acc, ign, fmt){
    return caml_trampoline(make_ignored_param$0(0, k, acc, ign, fmt));
   }
   function make_from_fmtty$0(counter, k, acc, fmtty, fmt){
    if(typeof fmtty !== "number")
     switch(fmtty[0]){
       case 0:
        var rest = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest, fmt);};
       case 1:
        var rest$0 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$0, fmt);};
       case 2:
        var rest$1 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$1, fmt);};
       case 3:
        var rest$2 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$2, fmt);};
       case 4:
        var rest$3 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$3, fmt);};
       case 5:
        var rest$4 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$4, fmt);};
       case 6:
        var rest$5 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$5, fmt);};
       case 7:
        var rest$6 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$6, fmt);};
       case 8:
        var rest$7 = fmtty[2];
        return function(param){return make_from_fmtty(k, acc, rest$7, fmt);};
       case 9:
        var
         rest$8 = fmtty[3],
         ty2 = fmtty[2],
         ty1 = fmtty[1],
         ty = trans(symm(ty1), ty2);
        return function(param){
         return make_from_fmtty
                 (k,
                  acc,
                  caml_call2(CamlinternalFormatBasics[1], ty, rest$8),
                  fmt);};
       case 10:
        var rest$9 = fmtty[1];
        return function(param, _cN_){
         return make_from_fmtty(k, acc, rest$9, fmt);};
       case 11:
        var rest$10 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$10, fmt);};
       case 12:
        var rest$11 = fmtty[1];
        return function(param){return make_from_fmtty(k, acc, rest$11, fmt);};
       case 13:
        throw caml_maybe_attach_backtrace([0, Assert_failure, _u_], 1);
       default:
        throw caml_maybe_attach_backtrace([0, Assert_failure, _v_], 1);
     }
    if(counter >= 50)
     return caml_trampoline_return(make_invalid_arg, [0, k, acc, fmt]);
    var counter$0 = counter + 1 | 0;
    return make_invalid_arg(counter$0, k, acc, fmt);
   }
   function make_from_fmtty(k, acc, fmtty, fmt){
    return caml_trampoline(make_from_fmtty$0(0, k, acc, fmtty, fmt));
   }
   function make_invalid_arg(counter, k, acc, fmt){
    var _cM_ = [8, acc, cst_Printf_bad_conversion$0];
    if(counter >= 50)
     return caml_trampoline_return(make_printf$0, [0, k, _cM_, fmt]);
    var counter$0 = counter + 1 | 0;
    return make_printf$0(counter$0, k, _cM_, fmt);
   }
   function make_padding(k, acc, fmt, pad, trans){
    if(typeof pad === "number")
     return function(x){
      var new_acc = [4, acc, caml_call1(trans, x)];
      return make_printf(k, new_acc, fmt);};
    if(0 === pad[0]){
     var width = pad[2], padty = pad[1];
     return function(x){
      var new_acc = [4, acc, fix_padding(padty, width, caml_call1(trans, x))];
      return make_printf(k, new_acc, fmt);};
    }
    var padty$0 = pad[1];
    return function(w, x){
     var new_acc = [4, acc, fix_padding(padty$0, w, caml_call1(trans, x))];
     return make_printf(k, new_acc, fmt);};
   }
   function make_int_padding_precision(k, acc, fmt, pad, prec, trans, iconv){
    if(typeof pad === "number"){
     if(typeof prec === "number")
      return prec
              ? function
               (p, x){
                var str = fix_int_precision(p, caml_call2(trans, iconv, x));
                return make_printf(k, [4, acc, str], fmt);
               }
              : function
               (x){
                var str = caml_call2(trans, iconv, x);
                return make_printf(k, [4, acc, str], fmt);
               };
     var p = prec[1];
     return function(x){
      var str = fix_int_precision(p, caml_call2(trans, iconv, x));
      return make_printf(k, [4, acc, str], fmt);};
    }
    if(0 === pad[0]){
     var w = pad[2], padty = pad[1];
     if(typeof prec === "number")
      return prec
              ? function
               (p, x){
                var
                 str =
                   fix_padding
                    (padty,
                     w,
                     fix_int_precision(p, caml_call2(trans, iconv, x)));
                return make_printf(k, [4, acc, str], fmt);
               }
              : function
               (x){
                var str = fix_padding(padty, w, caml_call2(trans, iconv, x));
                return make_printf(k, [4, acc, str], fmt);
               };
     var p$0 = prec[1];
     return function(x){
      var
       str =
         fix_padding
          (padty, w, fix_int_precision(p$0, caml_call2(trans, iconv, x)));
      return make_printf(k, [4, acc, str], fmt);};
    }
    var padty$0 = pad[1];
    if(typeof prec === "number")
     return prec
             ? function
              (w, p, x){
               var
                str =
                  fix_padding
                   (padty$0,
                    w,
                    fix_int_precision(p, caml_call2(trans, iconv, x)));
               return make_printf(k, [4, acc, str], fmt);
              }
             : function
              (w, x){
               var str = fix_padding(padty$0, w, caml_call2(trans, iconv, x));
               return make_printf(k, [4, acc, str], fmt);
              };
    var p$1 = prec[1];
    return function(w, x){
     var
      str =
        fix_padding
         (padty$0, w, fix_int_precision(p$1, caml_call2(trans, iconv, x)));
     return make_printf(k, [4, acc, str], fmt);};
   }
   function make_custom$0(counter, k, acc, rest, arity, f){
    if(arity){
     var arity$0 = arity[1];
     return function(x){
      return make_custom(k, acc, rest, arity$0, caml_call1(f, x));};
    }
    var _cL_ = [4, acc, f];
    if(counter >= 50)
     return caml_trampoline_return(make_printf$0, [0, k, _cL_, rest]);
    var counter$0 = counter + 1 | 0;
    return make_printf$0(counter$0, k, _cL_, rest);
   }
   function make_custom(k, acc, rest, arity, f){
    return caml_trampoline(make_custom$0(0, k, acc, rest, arity, f));
   }
   function make_iprintf$0(counter, k, o, fmt){
    var k$0 = k, fmt$0 = fmt;
    for(;;){
     if(typeof fmt$0 === "number") return caml_call1(k$0, o);
     switch(fmt$0[0]){
       case 0:
        var rest = fmt$0[1], _b2_ = make_iprintf(k$0, o, rest);
        return function(_cK_){return _b2_;};
       case 1:
        var rest$0 = fmt$0[1], _b3_ = make_iprintf(k$0, o, rest$0);
        return function(_cJ_){return _b3_;};
       case 2:
        var _b4_ = fmt$0[1];
        if(typeof _b4_ === "number"){
         var rest$1 = fmt$0[2], _b5_ = make_iprintf(k$0, o, rest$1);
         return function(_cI_){return _b5_;};
        }
        if(0 === _b4_[0]){
         var rest$2 = fmt$0[2], _b6_ = make_iprintf(k$0, o, rest$2);
         return function(_cH_){return _b6_;};
        }
        var
         rest$3 = fmt$0[2],
         _b7_ = make_iprintf(k$0, o, rest$3),
         _b8_ = function(_cG_){return _b7_;};
        return function(_cF_){return _b8_;};
       case 3:
        var _b9_ = fmt$0[1];
        if(typeof _b9_ === "number"){
         var rest$4 = fmt$0[2], _b__ = make_iprintf(k$0, o, rest$4);
         return function(_cE_){return _b__;};
        }
        if(0 === _b9_[0]){
         var rest$5 = fmt$0[2], _b$_ = make_iprintf(k$0, o, rest$5);
         return function(_cD_){return _b$_;};
        }
        var
         rest$6 = fmt$0[2],
         _ca_ = make_iprintf(k$0, o, rest$6),
         _cb_ = function(_cC_){return _ca_;};
        return function(_cB_){return _cb_;};
       case 4:
        var rest$7 = fmt$0[4], prec = fmt$0[3], pad = fmt$0[2];
        return fn_of_padding_precision(k$0, o, rest$7, pad, prec);
       case 5:
        var rest$8 = fmt$0[4], prec$0 = fmt$0[3], pad$0 = fmt$0[2];
        return fn_of_padding_precision(k$0, o, rest$8, pad$0, prec$0);
       case 6:
        var rest$9 = fmt$0[4], prec$1 = fmt$0[3], pad$1 = fmt$0[2];
        return fn_of_padding_precision(k$0, o, rest$9, pad$1, prec$1);
       case 7:
        var rest$10 = fmt$0[4], prec$2 = fmt$0[3], pad$2 = fmt$0[2];
        return fn_of_padding_precision(k$0, o, rest$10, pad$2, prec$2);
       case 8:
        var rest$11 = fmt$0[4], prec$3 = fmt$0[3], pad$3 = fmt$0[2];
        return fn_of_padding_precision(k$0, o, rest$11, pad$3, prec$3);
       case 9:
        var _cc_ = fmt$0[1];
        if(typeof _cc_ === "number"){
         var rest$12 = fmt$0[2], _cd_ = make_iprintf(k$0, o, rest$12);
         return function(_cA_){return _cd_;};
        }
        if(0 === _cc_[0]){
         var rest$13 = fmt$0[2], _ce_ = make_iprintf(k$0, o, rest$13);
         return function(_cz_){return _ce_;};
        }
        var
         rest$14 = fmt$0[2],
         _cf_ = make_iprintf(k$0, o, rest$14),
         _cg_ = function(_cy_){return _cf_;};
        return function(_cx_){return _cg_;};
       case 10:
        var rest$15 = fmt$0[1], fmt$0 = rest$15; break;
       case 11:
        var rest$16 = fmt$0[2], fmt$0 = rest$16; break;
       case 12:
        var rest$17 = fmt$0[2], fmt$0 = rest$17; break;
       case 13:
        var rest$18 = fmt$0[3], _ch_ = make_iprintf(k$0, o, rest$18);
        return function(_cw_){return _ch_;};
       case 14:
        var rest$19 = fmt$0[3], fmtty = fmt$0[2];
        return function(param){
         var fmt = param[1], _cv_ = recast(fmt, fmtty);
         return make_iprintf
                 (k$0,
                  o,
                  caml_call2(CamlinternalFormatBasics[3], _cv_, rest$19));};
       case 15:
        var
         rest$20 = fmt$0[1],
         _ci_ = make_iprintf(k$0, o, rest$20),
         _cj_ = function(_cu_){return _ci_;};
        return function(_ct_){return _cj_;};
       case 16:
        var rest$21 = fmt$0[1], _ck_ = make_iprintf(k$0, o, rest$21);
        return function(_cs_){return _ck_;};
       case 17:
        var rest$22 = fmt$0[2], fmt$0 = rest$22; break;
       case 18:
        var _cl_ = fmt$0[1];
        if(0 === _cl_[0]){
         var rest$23 = fmt$0[2], fmt$1 = _cl_[1][1];
         let k = k$0, rest = rest$23;
         var
          k$1 = function(koc){return make_iprintf(k, koc, rest);},
          k$0 = k$1,
          fmt$0 = fmt$1;
        }
        else{
         var rest$24 = fmt$0[2], fmt$2 = _cl_[1][1];
         let k = k$0, rest = rest$24;
         var
          k$2 = function(koc){return make_iprintf(k, koc, rest);},
          k$0 = k$2,
          fmt$0 = fmt$2;
        }
        break;
       case 19:
        throw caml_maybe_attach_backtrace([0, Assert_failure, _w_], 1);
       case 20:
        var rest$25 = fmt$0[3], _cm_ = make_iprintf(k$0, o, rest$25);
        return function(_cr_){return _cm_;};
       case 21:
        var rest$26 = fmt$0[2], _cn_ = make_iprintf(k$0, o, rest$26);
        return function(_cq_){return _cn_;};
       case 22:
        var rest$27 = fmt$0[1], _co_ = make_iprintf(k$0, o, rest$27);
        return function(_cp_){return _co_;};
       case 23:
        var rest$28 = fmt$0[2], ign = fmt$0[1];
        return make_ignored_param
                (function(param){return caml_call1(k$0, o);}, 0, ign, rest$28);
       default:
        var rest$29 = fmt$0[3], arity = fmt$0[1];
        if(counter >= 50)
         return caml_trampoline_return
                 (fn_of_custom_arity$0, [0, k$0, o, rest$29, arity]);
        var counter$0 = counter + 1 | 0;
        return fn_of_custom_arity$0(counter$0, k$0, o, rest$29, arity);
     }
    }
   }
   function make_iprintf(k, o, fmt){
    return caml_trampoline(make_iprintf$0(0, k, o, fmt));
   }
   function fn_of_padding_precision(k, o, fmt, pad, prec){
    if(typeof pad === "number"){
     if(typeof prec !== "number"){
      var _bB_ = make_iprintf(k, o, fmt);
      return function(_b1_){return _bB_;};
     }
     if(prec){
      var _by_ = make_iprintf(k, o, fmt), _bz_ = function(_b0_){return _by_;};
      return function(_bZ_){return _bz_;};
     }
     var _bA_ = make_iprintf(k, o, fmt);
     return function(_bY_){return _bA_;};
    }
    if(0 === pad[0]){
     if(typeof prec !== "number"){
      var _bF_ = make_iprintf(k, o, fmt);
      return function(_bX_){return _bF_;};
     }
     if(prec){
      var _bC_ = make_iprintf(k, o, fmt), _bD_ = function(_bW_){return _bC_;};
      return function(_bV_){return _bD_;};
     }
     var _bE_ = make_iprintf(k, o, fmt);
     return function(_bU_){return _bE_;};
    }
    if(typeof prec !== "number"){
     var _bL_ = make_iprintf(k, o, fmt), _bM_ = function(_bT_){return _bL_;};
     return function(_bS_){return _bM_;};
    }
    if(prec){
     var
      _bG_ = make_iprintf(k, o, fmt),
      _bH_ = function(_bR_){return _bG_;},
      _bI_ = function(_bQ_){return _bH_;};
     return function(_bP_){return _bI_;};
    }
    var _bJ_ = make_iprintf(k, o, fmt);
    function _bK_(_bO_){return _bJ_;}
    return function(_bN_){return _bK_;};
   }
   function fn_of_custom_arity$0(counter, k, o, fmt, param){
    if(param){
     var arity = param[1], _bw_ = fn_of_custom_arity(k, o, fmt, arity);
     return function(_bx_){return _bw_;};
    }
    if(counter >= 50)
     return caml_trampoline_return(make_iprintf$0, [0, k, o, fmt]);
    var counter$0 = counter + 1 | 0;
    return make_iprintf$0(counter$0, k, o, fmt);
   }
   function fn_of_custom_arity(k, o, fmt, param){
    return caml_trampoline(fn_of_custom_arity$0(0, k, o, fmt, param));
   }
   function output_acc(o, acc){
    var acc$0 = acc;
    for(;;){
     if(typeof acc$0 === "number") return 0;
     switch(acc$0[0]){
       case 0:
        var
         fmting_lit = acc$0[2],
         p = acc$0[1],
         s = string_of_formatting_lit(fmting_lit);
        output_acc(o, p);
        return caml_call2(Stdlib[66], o, s);
       case 1:
        var match = acc$0[2], p$0 = acc$0[1];
        if(0 === match[0]){
         var acc$1 = match[1];
         output_acc(o, p$0);
         caml_call2(Stdlib[66], o, cst$18);
         var acc$0 = acc$1;
        }
        else{
         var acc$2 = match[1];
         output_acc(o, p$0);
         caml_call2(Stdlib[66], o, cst$19);
         var acc$0 = acc$2;
        }
        break;
       case 6:
        var f = acc$0[2], p$3 = acc$0[1];
        output_acc(o, p$3);
        return caml_call1(f, o);
       case 7:
        var p$4 = acc$0[1];
        output_acc(o, p$4);
        return caml_call1(Stdlib[63], o);
       case 8:
        var msg = acc$0[2], p$5 = acc$0[1];
        output_acc(o, p$5);
        return caml_call1(Stdlib[1], msg);
       case 2:
       case 4:
        var s$0 = acc$0[2], p$1 = acc$0[1];
        output_acc(o, p$1);
        return caml_call2(Stdlib[66], o, s$0);
       default:
        var c = acc$0[2], p$2 = acc$0[1];
        output_acc(o, p$2);
        return caml_call2(Stdlib[65], o, c);
     }
    }
   }
   function bufput_acc(b, acc){
    var acc$0 = acc;
    for(;;){
     if(typeof acc$0 === "number") return 0;
     switch(acc$0[0]){
       case 0:
        var
         fmting_lit = acc$0[2],
         p = acc$0[1],
         s = string_of_formatting_lit(fmting_lit);
        bufput_acc(b, p);
        return caml_call2(Stdlib_Buffer[16], b, s);
       case 1:
        var match = acc$0[2], p$0 = acc$0[1];
        if(0 === match[0]){
         var acc$1 = match[1];
         bufput_acc(b, p$0);
         caml_call2(Stdlib_Buffer[16], b, cst$20);
         var acc$0 = acc$1;
        }
        else{
         var acc$2 = match[1];
         bufput_acc(b, p$0);
         caml_call2(Stdlib_Buffer[16], b, cst$21);
         var acc$0 = acc$2;
        }
        break;
       case 6:
        var f = acc$0[2], p$3 = acc$0[1];
        bufput_acc(b, p$3);
        return caml_call1(f, b);
       case 7:
        var acc$3 = acc$0[1], acc$0 = acc$3; break;
       case 8:
        var msg = acc$0[2], p$4 = acc$0[1];
        bufput_acc(b, p$4);
        return caml_call1(Stdlib[1], msg);
       case 2:
       case 4:
        var s$0 = acc$0[2], p$1 = acc$0[1];
        bufput_acc(b, p$1);
        return caml_call2(Stdlib_Buffer[16], b, s$0);
       default:
        var c = acc$0[2], p$2 = acc$0[1];
        bufput_acc(b, p$2);
        return caml_call2(Stdlib_Buffer[12], b, c);
     }
    }
   }
   function strput_acc(b, acc){
    var acc$0 = acc;
    for(;;){
     if(typeof acc$0 === "number") return 0;
     switch(acc$0[0]){
       case 0:
        var
         fmting_lit = acc$0[2],
         p = acc$0[1],
         s = string_of_formatting_lit(fmting_lit);
        strput_acc(b, p);
        return caml_call2(Stdlib_Buffer[16], b, s);
       case 1:
        var match = acc$0[2], p$0 = acc$0[1];
        if(0 === match[0]){
         var acc$1 = match[1];
         strput_acc(b, p$0);
         caml_call2(Stdlib_Buffer[16], b, cst$22);
         var acc$0 = acc$1;
        }
        else{
         var acc$2 = match[1];
         strput_acc(b, p$0);
         caml_call2(Stdlib_Buffer[16], b, cst$23);
         var acc$0 = acc$2;
        }
        break;
       case 6:
        var f = acc$0[2], p$3 = acc$0[1];
        strput_acc(b, p$3);
        var _bv_ = caml_call1(f, 0);
        return caml_call2(Stdlib_Buffer[16], b, _bv_);
       case 7:
        var acc$3 = acc$0[1], acc$0 = acc$3; break;
       case 8:
        var msg = acc$0[2], p$4 = acc$0[1];
        strput_acc(b, p$4);
        return caml_call1(Stdlib[1], msg);
       case 2:
       case 4:
        var s$0 = acc$0[2], p$1 = acc$0[1];
        strput_acc(b, p$1);
        return caml_call2(Stdlib_Buffer[16], b, s$0);
       default:
        var c = acc$0[2], p$2 = acc$0[1];
        strput_acc(b, p$2);
        return caml_call2(Stdlib_Buffer[12], b, c);
     }
    }
   }
   function failwith_message(param){
    var fmt = param[1], buf = caml_call1(Stdlib_Buffer[1], 256);
    function k(acc){
     strput_acc(buf, acc);
     var _bu_ = caml_call1(Stdlib_Buffer[2], buf);
     return caml_call1(Stdlib[2], _bu_);
    }
    return make_printf(k, 0, fmt);
   }
   function open_box_of_string(str){
    if(runtime.caml_string_equal(str, cst$43)) return _x_;
    var len = caml_ml_string_length(str);
    function invalid_box(param){
     return caml_call1(failwith_message(_y_), str);
    }
    function parse_spaces(i){
     var i$0 = i;
     for(;;){
      if(i$0 === len) return i$0;
      var match = caml_string_get(str, i$0);
      if(9 !== match && 32 !== match) return i$0;
      var i$1 = i$0 + 1 | 0, i$0 = i$1;
     }
    }
    var wstart = parse_spaces(0);
    a:
    b:
    {
     var wend = wstart;
     for(;;){
      if(wend === len) break b;
      if(25 < caml_string_get(str, wend) - 97 >>> 0) break;
      var j = wend + 1 | 0, wend = j;
     }
     break a;
    }
    var
     box_name = caml_call3(Stdlib_String[16], str, wstart, wend - wstart | 0),
     nstart = parse_spaces(wend);
    a:
    b:
    {
     var nend = nstart;
     for(;;){
      if(nend === len) break b;
      var match = caml_string_get(str, nend);
      if(48 <= match){if(58 <= match) break;} else if(45 !== match) break;
      var j$0 = nend + 1 | 0, nend = j$0;
     }
     break a;
    }
    if(nstart === nend)
     var indent = 0;
    else
     try{
      var
       _bs_ =
         runtime.caml_int_of_string
          (caml_call3(Stdlib_String[16], str, nstart, nend - nstart | 0)),
       indent = _bs_;
     }
     catch(_bt_){
      var _br_ = caml_wrap_exception(_bt_);
      if(_br_[1] !== Stdlib[7]) throw caml_maybe_attach_backtrace(_br_, 0);
      var indent = invalid_box(0);
     }
    var exp_end = parse_spaces(nend);
    if(exp_end !== len) invalid_box(0);
    a:
    {
     if
      (caml_string_notequal(box_name, cst$43)
       && caml_string_notequal(box_name, "b")){
      if(! caml_string_notequal(box_name, "h")){var box_type = 0; break a;}
      if(! caml_string_notequal(box_name, "hov")){var box_type = 3; break a;}
      if(! caml_string_notequal(box_name, "hv")){var box_type = 2; break a;}
      if(caml_string_notequal(box_name, "v")){
       var box_type = invalid_box(0);
       break a;
      }
      var box_type = 1;
      break a;
     }
     var box_type = 4;
    }
    return [0, indent, box_type];
   }
   function make_padding_fmt_ebb(pad, fmt){
    if(typeof pad === "number") return [0, 0, fmt];
    if(0 === pad[0]){var w = pad[2], s = pad[1]; return [0, [0, s, w], fmt];}
    var s$0 = pad[1];
    return [0, [1, s$0], fmt];
   }
   function make_padprec_fmt_ebb(pad, prec, fmt){
    if(typeof prec === "number")
     var match = prec ? [0, 1] : [0, 0];
    else
     var p = prec[1], match = [0, [0, p]];
    var prec$0 = match[1];
    if(typeof pad === "number") return [0, 0, prec$0, fmt];
    if(0 === pad[0]){
     var w = pad[2], s = pad[1];
     return [0, [0, s, w], prec$0, fmt];
    }
    var s$0 = pad[1];
    return [0, [1, s$0], prec$0, fmt];
   }
   function fmt_ebb_of_string(legacy_behavior, str){
    if(legacy_behavior)
     var flag = legacy_behavior[1], legacy_behavior$0 = flag;
    else
     var legacy_behavior$0 = 1;
    function invalid_format_message(str_ind, msg){
     return caml_call3(failwith_message(_z_), str, str_ind, msg);
    }
    function unexpected_end_of_format(end_ind){
     return invalid_format_message(end_ind, cst_unexpected_end_of_format);
    }
    function invalid_format_without(str_ind, c, s){
     return caml_call4(failwith_message(_A_), str, str_ind, c, s);
    }
    function expected_character(str_ind, expected, read){
     return caml_call4(failwith_message(_B_), str, str_ind, expected, read);
    }
    function parse(lit_start, end_ind){
     a:
     {
      var str_ind = lit_start;
      for(;;){
       if(str_ind === end_ind) return add_literal(lit_start, str_ind, 0);
       var match = caml_string_get(str, str_ind);
       if(37 === match) break;
       if(64 === match) break a;
       var str_ind$1 = str_ind + 1 | 0, str_ind = str_ind$1;
      }
      var str_ind$2 = str_ind + 1 | 0;
      if(str_ind$2 === end_ind) unexpected_end_of_format(end_ind);
      var
       match$1 =
         95 === caml_string_get(str, str_ind$2)
          ? parse_flags(str_ind, str_ind$2 + 1 | 0, end_ind, 1)
          : parse_flags(str_ind, str_ind$2, end_ind, 0),
       fmt_rest = match$1[1];
      return add_literal(lit_start, str_ind, fmt_rest);
     }
     var str_ind$0 = str_ind + 1 | 0;
     a:
     if(str_ind$0 === end_ind)
      var match$0 = _N_;
     else{
      var c = caml_string_get(str, str_ind$0);
      if(65 <= c){
       if(94 <= c){
        var switcher = c - 123 | 0;
        if(2 >= switcher >>> 0)
         switch(switcher){
           case 0:
            var match$0 = parse_tag(1, str_ind$0 + 1 | 0, end_ind); break a;
           case 1: break;
           default:
            var
             fmt_rest$2 = parse(str_ind$0 + 1 | 0, end_ind)[1],
             match$0 = [0, [17, 1, fmt_rest$2]];
            break a;
         }
       }
       else if(91 <= c)
        switch(c - 91 | 0){
          case 0:
           var match$0 = parse_tag(0, str_ind$0 + 1 | 0, end_ind); break a;
          case 1: break;
          default:
           var
            fmt_rest$3 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 0, fmt_rest$3]];
           break a;
        }
      }
      else{
       if(10 === c){
        var
         fmt_rest$4 = parse(str_ind$0 + 1 | 0, end_ind)[1],
         match$0 = [0, [17, 3, fmt_rest$4]];
        break a;
       }
       if(32 <= c)
        switch(c - 32 | 0){
          case 0:
           var
            fmt_rest$5 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, _O_, fmt_rest$5]];
           break a;
          case 5:
           if
            ((str_ind$0 + 1 | 0) < end_ind
             && 37 === caml_string_get(str, str_ind$0 + 1 | 0)){
            var
             fmt_rest$6 = parse(str_ind$0 + 2 | 0, end_ind)[1],
             match$0 = [0, [17, 6, fmt_rest$6]];
            break a;
           }
           var
            fmt_rest$7 = parse(str_ind$0, end_ind)[1],
            match$0 = [0, [12, 64, fmt_rest$7]];
           break a;
          case 12:
           var
            fmt_rest$8 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, _P_, fmt_rest$8]];
           break a;
          case 14:
           var
            fmt_rest$9 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 4, fmt_rest$9]];
           break a;
          case 27:
           var str_ind$3 = str_ind$0 + 1 | 0;
           b:
           try{
            var
             _bg_ = str_ind$3 === end_ind ? 1 : 0,
             _bh_ = _bg_ || (60 !== caml_string_get(str, str_ind$3) ? 1 : 0);
            if(_bh_) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
            var
             str_ind_1 = parse_spaces(str_ind$3 + 1 | 0, end_ind),
             match$2 = caml_string_get(str, str_ind_1);
            c:
            {
             if(48 <= match$2){
              if(58 > match$2) break c;
             }
             else if(45 === match$2) break c;
             throw caml_maybe_attach_backtrace(Stdlib[8], 1);
            }
            var
             match$3 = parse_integer(str_ind_1, end_ind),
             width = match$3[2],
             str_ind_2 = match$3[1],
             str_ind_3 = parse_spaces(str_ind_2, end_ind),
             switcher$0 = caml_string_get(str, str_ind_3) - 45 | 0;
            if(12 < switcher$0 >>> 0){
             if(17 === switcher$0){
              var
               s =
                 caml_call3
                  (Stdlib_String[16],
                   str,
                   str_ind$3 - 2 | 0,
                   (str_ind_3 - str_ind$3 | 0) + 3 | 0),
               _bi_ = [0, s, width, 0],
               _bj_ = str_ind_3 + 1 | 0,
               formatting_lit$0 = _bi_,
               next_ind = _bj_;
              break b;
             }
            }
            else if(1 < switcher$0 - 1 >>> 0){
             var
              match$4 = parse_integer(str_ind_3, end_ind),
              offset = match$4[2],
              str_ind_4 = match$4[1],
              str_ind_5 = parse_spaces(str_ind_4, end_ind);
             if(62 !== caml_string_get(str, str_ind_5))
              throw caml_maybe_attach_backtrace(Stdlib[8], 1);
             var
              s$0 =
                caml_call3
                 (Stdlib_String[16],
                  str,
                  str_ind$3 - 2 | 0,
                  (str_ind_5 - str_ind$3 | 0) + 3 | 0),
              _bk_ = [0, s$0, width, offset],
              _bl_ = str_ind_5 + 1 | 0,
              formatting_lit$0 = _bk_,
              next_ind = _bl_;
             break b;
            }
            throw caml_maybe_attach_backtrace(Stdlib[8], 1);
           }
           catch(_bq_){
            var _bf_ = caml_wrap_exception(_bq_);
            if(_bf_ !== Stdlib[8] && _bf_[1] !== Stdlib[7])
             throw caml_maybe_attach_backtrace(_bf_, 0);
            var formatting_lit$0 = formatting_lit, next_ind = str_ind$3;
           }
           var
            fmt_rest$12 = parse(next_ind, end_ind)[1],
            match$0 = [0, [17, formatting_lit$0, fmt_rest$12]];
           break a;
          case 28:
           var str_ind$4 = str_ind$0 + 1 | 0;
           try{
            var
             str_ind_1$0 = parse_spaces(str_ind$4, end_ind),
             match$6 = caml_string_get(str, str_ind_1$0);
            b:
            {
             c:
             {
              if(48 <= match$6){
               if(58 > match$6) break c;
              }
              else if(45 === match$6) break c;
              var _bo_ = 0;
              break b;
             }
             var
              match$7 = parse_integer(str_ind_1$0, end_ind),
              size = match$7[2],
              str_ind_2$0 = match$7[1],
              str_ind_3$0 = parse_spaces(str_ind_2$0, end_ind);
             if(62 !== caml_string_get(str, str_ind_3$0))
              throw caml_maybe_attach_backtrace(Stdlib[8], 1);
             var
              s$1 =
                caml_call3
                 (Stdlib_String[16],
                  str,
                  str_ind$4 - 2 | 0,
                  (str_ind_3$0 - str_ind$4 | 0) + 3 | 0),
              _bo_ = [0, [0, str_ind_3$0 + 1 | 0, [1, s$1, size]]];
            }
            var _bn_ = _bo_;
           }
           catch(_bp_){
            var _bm_ = caml_wrap_exception(_bp_);
            if(_bm_ !== Stdlib[8] && _bm_[1] !== Stdlib[7])
             throw caml_maybe_attach_backtrace(_bm_, 0);
            var _bn_ = 0;
           }
           if(_bn_)
            var
             match$5 = _bn_[1],
             formatting_lit$1 = match$5[2],
             next_ind$0 = match$5[1],
             fmt_rest$13 = parse(next_ind$0, end_ind)[1],
             _be_ = [0, [17, formatting_lit$1, fmt_rest$13]];
           else
            var
             fmt_rest$14 = parse(str_ind$4, end_ind)[1],
             _be_ = [0, [17, _Q_, fmt_rest$14]];
           var match$0 = _be_;
           break a;
          case 31:
           var
            fmt_rest$10 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 2, fmt_rest$10]];
           break a;
          case 32:
           var
            fmt_rest$11 = parse(str_ind$0 + 1 | 0, end_ind)[1],
            match$0 = [0, [17, 5, fmt_rest$11]];
           break a;
        }
      }
      var
       fmt_rest$1 = parse(str_ind$0 + 1 | 0, end_ind)[1],
       match$0 = [0, [17, [2, c], fmt_rest$1]];
     }
     var fmt_rest$0 = match$0[1];
     return add_literal(lit_start, str_ind, fmt_rest$0);
    }
    function parse_flags(pct_ind, str_ind, end_ind, ign){
     var
      zero = [0, 0],
      minus = [0, 0],
      plus = [0, 0],
      space = [0, 0],
      hash = [0, 0];
     function set_flag(str_ind, flag){
      var _bb_ = flag[1], _bc_ = _bb_ ? 1 - legacy_behavior$0 : _bb_;
      if(_bc_){
       var _bd_ = caml_string_get(str, str_ind);
       caml_call3(failwith_message(_C_), str, str_ind, _bd_);
      }
      flag[1] = 1;
      return;
     }
     a:
     b:
     {
      var str_ind$0 = str_ind;
      c:
      for(;;){
       if(str_ind$0 === end_ind) unexpected_end_of_format(end_ind);
       var switcher = caml_string_get(str, str_ind$0) - 32 | 0;
       if(16 < switcher >>> 0) break b;
       switch(switcher){
         case 0:
          set_flag(str_ind$0, space);
          var str_ind$1 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$1;
          break;
         case 3:
          set_flag(str_ind$0, hash);
          var str_ind$2 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$2;
          break;
         case 11:
          set_flag(str_ind$0, plus);
          var str_ind$3 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$3;
          break;
         case 13:
          set_flag(str_ind$0, minus);
          var str_ind$4 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$4;
          break;
         case 16:
          set_flag(str_ind$0, zero);
          var str_ind$5 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$5;
          break;
         default: break c;
       }
      }
      break a;
     }
     var
      space$0 = space[1],
      hash$0 = hash[1],
      plus$0 = plus[1],
      minus$0 = minus[1],
      zero$0 = zero[1];
     if(str_ind$0 === end_ind) unexpected_end_of_format(end_ind);
     var
      padty =
        zero$0
         ? minus$0
           ? legacy_behavior$0
             ? 0
             : incompatible_flag(pct_ind, str_ind$0, 45, cst_0)
           : 2
         : minus$0 ? 0 : 1,
      match = caml_string_get(str, str_ind$0);
     if(48 <= match){
      if(58 > match){
       var
        match$0 = parse_positive(str_ind$0, end_ind, 0),
        width = match$0[2],
        new_ind = match$0[1];
       return parse_after_padding
               (pct_ind,
                new_ind,
                end_ind,
                minus$0,
                plus$0,
                hash$0,
                space$0,
                ign,
                [0, padty, width]);
      }
     }
     else if(42 === match)
      return parse_after_padding
              (pct_ind,
               str_ind$0 + 1 | 0,
               end_ind,
               minus$0,
               plus$0,
               hash$0,
               space$0,
               ign,
               [1, padty]);
     switch(padty){
       case 0:
        if(1 - legacy_behavior$0)
         invalid_format_without(str_ind$0 - 1 | 0, 45, cst_padding);
        return parse_after_padding
                (pct_ind,
                 str_ind$0,
                 end_ind,
                 minus$0,
                 plus$0,
                 hash$0,
                 space$0,
                 ign,
                 0);
       case 1:
        return parse_after_padding
                (pct_ind,
                 str_ind$0,
                 end_ind,
                 minus$0,
                 plus$0,
                 hash$0,
                 space$0,
                 ign,
                 0);
       default:
        return parse_after_padding
                (pct_ind,
                 str_ind$0,
                 end_ind,
                 minus$0,
                 plus$0,
                 hash$0,
                 space$0,
                 ign,
                 _D_);
     }
    }
    function parse_after_padding
    (pct_ind, str_ind, end_ind, minus, plus, hash, space, ign, pad){
     if(str_ind === end_ind) unexpected_end_of_format(end_ind);
     var symb = caml_string_get(str, str_ind);
     if(46 !== symb)
      return parse_conversion
              (pct_ind,
               str_ind + 1 | 0,
               end_ind,
               plus,
               hash,
               space,
               ign,
               pad,
               0,
               pad,
               symb);
     var str_ind$0 = str_ind + 1 | 0;
     if(str_ind$0 === end_ind) unexpected_end_of_format(end_ind);
     function parse_literal(minus, str_ind){
      var
       match = parse_positive(str_ind, end_ind, 0),
       prec = match[2],
       new_ind = match[1];
      return parse_after_precision
              (pct_ind,
               new_ind,
               end_ind,
               minus,
               plus,
               hash,
               space,
               ign,
               pad,
               [0, prec]);
     }
     var symb$0 = caml_string_get(str, str_ind$0);
     if(48 <= symb$0){
      if(58 > symb$0) return parse_literal(minus, str_ind$0);
     }
     else if(42 <= symb$0)
      switch(symb$0 - 42 | 0){
        case 0:
         return parse_after_precision
                 (pct_ind,
                  str_ind$0 + 1 | 0,
                  end_ind,
                  minus,
                  plus,
                  hash,
                  space,
                  ign,
                  pad,
                  1);
        case 1:
        case 3:
         if(legacy_behavior$0){
          var
           _ba_ = str_ind$0 + 1 | 0,
           minus$0 = minus || (45 === symb$0 ? 1 : 0);
          return parse_literal(minus$0, _ba_);
         }
         break;
      }
     return legacy_behavior$0
             ? parse_after_precision
               (pct_ind,
                str_ind$0,
                end_ind,
                minus,
                plus,
                hash,
                space,
                ign,
                pad,
                _E_)
             : invalid_format_without(str_ind$0 - 1 | 0, 46, cst_precision);
    }
    function parse_after_precision
    (pct_ind, str_ind, end_ind, minus, plus, hash, space, ign, pad, prec){
     if(str_ind === end_ind) unexpected_end_of_format(end_ind);
     function parse_conv(padprec){
      return parse_conversion
              (pct_ind,
               str_ind + 1 | 0,
               end_ind,
               plus,
               hash,
               space,
               ign,
               pad,
               prec,
               padprec,
               caml_string_get(str, str_ind));
     }
     if(typeof pad !== "number") return parse_conv(pad);
     if(typeof prec === "number" && ! prec) return parse_conv(0);
     if(minus){
      if(typeof prec === "number") return parse_conv(_F_);
      var n = prec[1];
      return parse_conv([0, 0, n]);
     }
     if(typeof prec === "number") return parse_conv(_G_);
     var n$0 = prec[1];
     return parse_conv([0, 1, n$0]);
    }
    function parse_conversion
    (pct_ind,
     str_ind,
     end_ind,
     plus,
     hash,
     space,
     ign,
     pad,
     prec,
     padprec,
     symb){
     var
      plus_used = [0, 0],
      hash_used = [0, 0],
      space_used = [0, 0],
      ign_used = [0, 0],
      pad_used = [0, 0],
      prec_used = [0, 0];
     function get_plus(param){plus_used[1] = 1; return plus;}
     function get_hash(param){hash_used[1] = 1; return hash;}
     function get_space(param){space_used[1] = 1; return space;}
     function get_ign(param){ign_used[1] = 1; return ign;}
     function get_pad(param){pad_used[1] = 1; return pad;}
     function get_prec(param){prec_used[1] = 1; return prec;}
     function get_padprec(param){pad_used[1] = 1; return padprec;}
     function get_int_pad(param){
      var pad = get_pad(0), match = get_prec(0);
      if(typeof match === "number" && ! match) return pad;
      if(typeof pad === "number") return 0;
      if(0 !== pad[0])
       return 2 <= pad[1]
               ? legacy_behavior$0
                 ? _H_
                 : incompatible_flag(pct_ind, str_ind, 48, cst_precision$1)
               : pad;
      if(2 > pad[1]) return pad;
      var n = pad[2];
      return legacy_behavior$0
              ? [0, 1, n]
              : incompatible_flag(pct_ind, str_ind, 48, cst_precision$0);
     }
     function check_no_0(symb, pad){
      if(typeof pad === "number") return pad;
      if(0 !== pad[0])
       return 2 <= pad[1]
               ? legacy_behavior$0
                 ? _I_
                 : incompatible_flag(pct_ind, str_ind, symb, cst_0$1)
               : pad;
      if(2 > pad[1]) return pad;
      var width = pad[2];
      return legacy_behavior$0
              ? [0, 1, width]
              : incompatible_flag(pct_ind, str_ind, symb, cst_0$0);
     }
     function opt_of_pad(c, pad){
      if(typeof pad === "number") return 0;
      if(0 === pad[0])
       switch(pad[1]){
         case 0:
          var width = pad[2];
          return legacy_behavior$0
                  ? [0, width]
                  : incompatible_flag(pct_ind, str_ind, c, cst$24);
         case 1:
          var width$0 = pad[2]; return [0, width$0];
         default:
          var width$1 = pad[2];
          return legacy_behavior$0
                  ? [0, width$1]
                  : incompatible_flag(pct_ind, str_ind, c, cst_0$2);
       }
      return incompatible_flag(pct_ind, str_ind, c, cst$25);
     }
     function get_pad_opt(c){return opt_of_pad(c, get_pad(0));}
     function get_padprec_opt(c){return opt_of_pad(c, get_padprec(0));}
     a:
     {
      if(124 > symb)
       switch(symb){
         case 33:
          var
           fmt_rest$5 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [10, fmt_rest$5]];
          break a;
         case 40:
          var
           sub_end = search_subformat_end(str_ind, end_ind, 41),
           fmt_rest$7 = parse(sub_end + 2 | 0, end_ind)[1],
           sub_fmt = parse(str_ind, sub_end)[1],
           sub_fmtty = fmtty_of_fmt(sub_fmt);
          if(get_ign(0))
           var
            ignored$2 = [9, get_pad_opt(95), sub_fmtty],
            _aJ_ = [0, [23, ignored$2, fmt_rest$7]];
          else
           var _aJ_ = [0, [14, get_pad_opt(40), sub_fmtty, fmt_rest$7]];
          var fmt_result = _aJ_;
          break a;
         case 44:
          var fmt_result = parse(str_ind, end_ind); break a;
         case 67:
          var
           fmt_rest$10 = parse(str_ind, end_ind)[1],
           _aL_ =
             get_ign(0) ? [0, [23, 1, fmt_rest$10]] : [0, [1, fmt_rest$10]],
           fmt_result = _aL_;
          break a;
         case 78:
          var fmt_rest$14 = parse(str_ind, end_ind)[1], counter$0 = 2;
          if(get_ign(0))
           var
            ignored$6 = [11, counter$0],
            _aR_ = [0, [23, ignored$6, fmt_rest$14]];
          else
           var _aR_ = [0, [21, counter$0, fmt_rest$14]];
          var fmt_result = _aR_;
          break a;
         case 83:
          var
           pad$6 = check_no_0(symb, get_padprec(0)),
           fmt_rest$15 = parse(str_ind, end_ind)[1];
          if(get_ign(0))
           var
            ignored$7 = [1, get_padprec_opt(95)],
            _aS_ = [0, [23, ignored$7, fmt_rest$15]];
          else
           var
            match$5 = make_padding_fmt_ebb(pad$6, fmt_rest$15),
            fmt_rest$16 = match$5[2],
            pad$7 = match$5[1],
            _aS_ = [0, [3, pad$7, fmt_rest$16]];
          var fmt_result = _aS_;
          break a;
         case 91:
          if(str_ind === end_ind) unexpected_end_of_format(end_ind);
          var
           char_set = create_char_set(0),
           add_char = function(c){return add_in_char_set(char_set, c);},
           add_range =
             function(c$0, c){
              if(c >= c$0){
               var i = c$0;
               for(;;){
                add_in_char_set(char_set, caml_call1(Stdlib[29], i));
                var _a$_ = i + 1 | 0;
                if(c === i) break;
                var i = _a$_;
               }
              }
              return;
             },
           fail_single_percent =
             function(str_ind){
              return caml_call2(failwith_message(_R_), str, str_ind);
             },
           parse_char_set_content =
             function(counter, str_ind, end_ind){
              var str_ind$0 = str_ind;
              for(;;){
               if(str_ind$0 === end_ind) unexpected_end_of_format(end_ind);
               var c = caml_string_get(str, str_ind$0);
               if(45 !== c){
                if(93 === c) return str_ind$0 + 1 | 0;
                var _a__ = str_ind$0 + 1 | 0;
                if(counter >= 50)
                 return caml_trampoline_return
                         (parse_char_set_after_char$0, [0, _a__, end_ind, c]);
                var counter$0 = counter + 1 | 0;
                return parse_char_set_after_char$0
                        (counter$0, _a__, end_ind, c);
               }
               add_char(45);
               var str_ind$1 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$1;
              }
             },
           parse_char_set_after_char$0 =
             function(counter, str_ind, end_ind, c){
              var str_ind$0 = str_ind, c$0 = c;
              for(;;){
               if(str_ind$0 === end_ind) unexpected_end_of_format(end_ind);
               var c$1 = caml_string_get(str, str_ind$0);
               a:
               {
                if(46 <= c$1){
                 if(64 !== c$1){
                  if(93 !== c$1) break a;
                  add_char(c$0);
                  return str_ind$0 + 1 | 0;
                 }
                }
                else if(37 !== c$1){
                 if(45 > c$1) break a;
                 var str_ind$2 = str_ind$0 + 1 | 0;
                 if(str_ind$2 === end_ind) unexpected_end_of_format(end_ind);
                 var c$2 = caml_string_get(str, str_ind$2);
                 if(37 === c$2){
                  if((str_ind$2 + 1 | 0) === end_ind)
                   unexpected_end_of_format(end_ind);
                  var c$3 = caml_string_get(str, str_ind$2 + 1 | 0);
                  if(37 !== c$3 && 64 !== c$3)
                   return fail_single_percent(str_ind$2);
                  add_range(c$0, c$3);
                  var _a8_ = str_ind$2 + 2 | 0;
                  if(counter >= 50)
                   return caml_trampoline_return
                           (parse_char_set_content, [0, _a8_, end_ind]);
                  var counter$2 = counter + 1 | 0;
                  return parse_char_set_content(counter$2, _a8_, end_ind);
                 }
                 if(93 === c$2){
                  add_char(c$0);
                  add_char(45);
                  return str_ind$2 + 1 | 0;
                 }
                 add_range(c$0, c$2);
                 var _a9_ = str_ind$2 + 1 | 0;
                 if(counter >= 50)
                  return caml_trampoline_return
                          (parse_char_set_content, [0, _a9_, end_ind]);
                 var counter$1 = counter + 1 | 0;
                 return parse_char_set_content(counter$1, _a9_, end_ind);
                }
                if(37 === c$0){
                 add_char(c$1);
                 var _a7_ = str_ind$0 + 1 | 0;
                 if(counter >= 50)
                  return caml_trampoline_return
                          (parse_char_set_content, [0, _a7_, end_ind]);
                 var counter$0 = counter + 1 | 0;
                 return parse_char_set_content(counter$0, _a7_, end_ind);
                }
               }
               if(37 === c$0) fail_single_percent(str_ind$0);
               add_char(c$0);
               var
                str_ind$1 = str_ind$0 + 1 | 0,
                str_ind$0 = str_ind$1,
                c$0 = c$1;
              }
             },
           parse_char_set_after_char =
             function(str_ind, end_ind, c){
              return caml_trampoline
                      (parse_char_set_after_char$0(0, str_ind, end_ind, c));
             };
          if(str_ind === end_ind) unexpected_end_of_format(end_ind);
          if(94 === caml_string_get(str, str_ind))
           var
            str_ind$0 = str_ind + 1 | 0,
            reverse = 1,
            str_ind$1 = str_ind$0;
          else
           var reverse = 0, str_ind$1 = str_ind;
          if(str_ind$1 === end_ind) unexpected_end_of_format(end_ind);
          var
           c = caml_string_get(str, str_ind$1),
           next_ind = parse_char_set_after_char(str_ind$1 + 1 | 0, end_ind, c),
           char_set$0 = freeze_char_set(char_set),
           char_set$1 = reverse ? rev_char_set(char_set$0) : char_set$0,
           fmt_rest$19 = parse(next_ind, end_ind)[1];
          if(get_ign(0))
           var
            ignored$9 = [10, get_pad_opt(95), char_set$1],
            _aX_ = [0, [23, ignored$9, fmt_rest$19]];
          else
           var _aX_ = [0, [20, get_pad_opt(91), char_set$1, fmt_rest$19]];
          var fmt_result = _aX_;
          break a;
         case 97:
          var
           fmt_rest$20 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [15, fmt_rest$20]];
          break a;
         case 99:
          var
           char_format =
             function(fmt_rest){
              return get_ign(0) ? [0, [23, 0, fmt_rest]] : [0, [0, fmt_rest]];
             },
           fmt_rest$21 = parse(str_ind, end_ind)[1],
           match$7 = get_pad_opt(99);
          if(match$7){
           if(0 === match$7[1])
            var
             _aY_ =
               get_ign(0) ? [0, [23, 3, fmt_rest$21]] : [0, [22, fmt_rest$21]],
             _aZ_ = _aY_;
           else
            var
             _aZ_ =
               legacy_behavior$0
                ? char_format(fmt_rest$21)
                : invalid_format_message
                  (str_ind, cst_non_zero_widths_are_unsupp);
           var _a0_ = _aZ_;
          }
          else
           var _a0_ = char_format(fmt_rest$21);
          var fmt_result = _a0_;
          break a;
         case 114:
          var
           fmt_rest$22 = parse(str_ind, end_ind)[1],
           _a1_ =
             get_ign(0) ? [0, [23, 2, fmt_rest$22]] : [0, [19, fmt_rest$22]],
           fmt_result = _a1_;
          break a;
         case 115:
          var
           pad$9 = check_no_0(symb, get_padprec(0)),
           fmt_rest$23 = parse(str_ind, end_ind)[1];
          if(get_ign(0))
           var
            ignored$10 = [0, get_padprec_opt(95)],
            _a2_ = [0, [23, ignored$10, fmt_rest$23]];
          else
           var
            match$8 = make_padding_fmt_ebb(pad$9, fmt_rest$23),
            fmt_rest$24 = match$8[2],
            pad$10 = match$8[1],
            _a2_ = [0, [2, pad$10, fmt_rest$24]];
          var fmt_result = _a2_;
          break a;
         case 116:
          var
           fmt_rest$25 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [16, fmt_rest$25]];
          break a;
         case 123:
          var
           sub_end$0 = search_subformat_end(str_ind, end_ind, 125),
           sub_fmt$0 = parse(str_ind, sub_end$0)[1],
           fmt_rest$26 = parse(sub_end$0 + 2 | 0, end_ind)[1],
           sub_fmtty$0 = fmtty_of_fmt(sub_fmt$0);
          if(get_ign(0))
           var
            ignored$11 = [8, get_pad_opt(95), sub_fmtty$0],
            _a3_ = [0, [23, ignored$11, fmt_rest$26]];
          else
           var _a3_ = [0, [13, get_pad_opt(123), sub_fmtty$0, fmt_rest$26]];
          var fmt_result = _a3_;
          break a;
         case 66:
         case 98:
          var
           pad$3 = check_no_0(symb, get_padprec(0)),
           fmt_rest$8 = parse(str_ind, end_ind)[1];
          if(get_ign(0))
           var
            ignored$3 = [7, get_padprec_opt(95)],
            _aK_ = [0, [23, ignored$3, fmt_rest$8]];
          else
           var
            match$3 = make_padding_fmt_ebb(pad$3, fmt_rest$8),
            fmt_rest$9 = match$3[2],
            pad$4 = match$3[1],
            _aK_ = [0, [9, pad$4, fmt_rest$9]];
          var fmt_result = _aK_;
          break a;
         case 37:
         case 64:
          var
           fmt_rest$6 = parse(str_ind, end_ind)[1],
           fmt_result = [0, [12, symb, fmt_rest$6]];
          break a;
         case 76:
         case 108:
         case 110:
          if(str_ind !== end_ind){
           var symb$0 = caml_string_get(str, str_ind), _a4_ = symb$0 - 88 | 0;
           b:
           {
            if(32 >= _a4_ >>> 0)
             switch(_a4_){
               case 0:
               case 12:
               case 17:
               case 23:
               case 29:
               case 32:
                var _aQ_ = 1; break b;
             }
            var _aQ_ = 0;
           }
           if(_aQ_) break;
          }
          var fmt_rest$13 = parse(str_ind, end_ind)[1];
          b:
          {
           if(108 <= symb){
            if(111 > symb)
             switch(symb - 108 | 0){
               case 0:
                var counter = 0; break b;
               case 1: break;
               default: var counter = 1; break b;
             }
           }
           else if(76 === symb){var counter = 2; break b;}
           throw caml_maybe_attach_backtrace([0, Assert_failure, _V_], 1);
          }
          if(get_ign(0))
           var
            ignored$5 = [11, counter],
            _aP_ = [0, [23, ignored$5, fmt_rest$13]];
          else
           var _aP_ = [0, [21, counter, fmt_rest$13]];
          var fmt_result = _aP_;
          break a;
         case 32:
         case 35:
         case 43:
         case 45:
         case 95:
          var
           fmt_result = caml_call3(failwith_message(_M_), str, pct_ind, symb);
          break a;
         case 88:
         case 100:
         case 105:
         case 111:
         case 117:
         case 120:
          var
           _aT_ = get_space(0),
           _aU_ = get_hash(0),
           iconv$2 =
             compute_int_conv(pct_ind, str_ind, get_plus(0), _aU_, _aT_, symb),
           fmt_rest$17 = parse(str_ind, end_ind)[1];
          if(get_ign(0))
           var
            ignored$8 = [2, iconv$2, get_pad_opt(95)],
            _aV_ = [0, [23, ignored$8, fmt_rest$17]];
          else
           var
            _aW_ = get_prec(0),
            match$6 = make_padprec_fmt_ebb(get_int_pad(0), _aW_, fmt_rest$17),
            fmt_rest$18 = match$6[3],
            prec$4 = match$6[2],
            pad$8 = match$6[1],
            _aV_ = [0, [4, iconv$2, pad$8, prec$4, fmt_rest$18]];
          var fmt_result = _aV_;
          break a;
         case 69:
         case 70:
         case 71:
         case 72:
         case 101:
         case 102:
         case 103:
         case 104:
          var
           space$1 = get_space(0),
           hash$1 = get_hash(0),
           plus$2 = get_plus(0),
           flag =
             plus$2
              ? space$1
                ? legacy_behavior$0
                  ? 1
                  : incompatible_flag(pct_ind, str_ind, 32, cst$36)
                : 1
              : space$1 ? 2 : 0;
          b:
          {
           c:
           if(73 <= symb){
            var switcher = symb - 101 | 0;
            if(3 >= switcher >>> 0){
             switch(switcher){
               case 0:
                var _a5_ = 1; break;
               case 1:
                var _a5_ = 0; break;
               case 2:
                var _a5_ = 3; break;
               default: var _a5_ = 6;
             }
             var kind = _a5_;
             break b;
            }
           }
           else if(69 <= symb){
            switch(symb - 69 | 0){
              case 0:
               var _a6_ = 2; break;
              case 1:
               break c;
              case 2:
               var _a6_ = 4; break;
              default: var _a6_ = 7;
            }
            var kind = _a6_;
            break b;
           }
           if(hash$1){
            if(70 === symb){var kind = 8; break b;}
           }
           else if(70 === symb){var kind = 5; break b;}
           throw caml_maybe_attach_backtrace([0, Assert_failure, _X_], 1);
          }
          var
           fconv = [0, flag, kind],
           fmt_rest$11 = parse(str_ind, end_ind)[1];
          if(get_ign(0)){
           var match = get_prec(0);
           if(typeof match === "number")
            var
             _aM_ =
               match ? incompatible_flag(pct_ind, str_ind, 95, cst$26) : 0;
           else
            var ndec = match[1], _aM_ = [0, ndec];
           var
            ignored$4 = [6, get_pad_opt(95), _aM_],
            _aN_ = [0, [23, ignored$4, fmt_rest$11]];
          }
          else
           var
            _aO_ = get_prec(0),
            match$4 = make_padprec_fmt_ebb(get_pad(0), _aO_, fmt_rest$11),
            fmt_rest$12 = match$4[3],
            prec$3 = match$4[2],
            pad$5 = match$4[1],
            _aN_ = [0, [8, fconv, pad$5, prec$3, fmt_rest$12]];
          var fmt_result = _aN_;
          break a;
       }
      b:
      if(108 <= symb){
       if(111 > symb){
        switch(symb - 108 | 0){
          case 0:
           var
            _at_ = caml_string_get(str, str_ind),
            _au_ = get_space(0),
            _av_ = get_hash(0),
            iconv =
              compute_int_conv
               (pct_ind, str_ind + 1 | 0, get_plus(0), _av_, _au_, _at_),
            fmt_rest = parse(str_ind + 1 | 0, end_ind)[1];
           if(get_ign(0))
            var
             ignored = [3, iconv, get_pad_opt(95)],
             _aw_ = [0, [23, ignored, fmt_rest]];
           else
            var
             _ay_ = get_prec(0),
             match$0 = make_padprec_fmt_ebb(get_int_pad(0), _ay_, fmt_rest),
             fmt_rest$0 = match$0[3],
             prec$0 = match$0[2],
             pad$0 = match$0[1],
             _aw_ = [0, [5, iconv, pad$0, prec$0, fmt_rest$0]];
           var _ax_ = _aw_;
           break;
          case 1:
           break b;
          default:
           var
            _az_ = caml_string_get(str, str_ind),
            _aA_ = get_space(0),
            _aB_ = get_hash(0),
            iconv$0 =
              compute_int_conv
               (pct_ind, str_ind + 1 | 0, get_plus(0), _aB_, _aA_, _az_),
            fmt_rest$1 = parse(str_ind + 1 | 0, end_ind)[1];
           if(get_ign(0))
            var
             ignored$0 = [4, iconv$0, get_pad_opt(95)],
             _aC_ = [0, [23, ignored$0, fmt_rest$1]];
           else
            var
             _aD_ = get_prec(0),
             match$1 = make_padprec_fmt_ebb(get_int_pad(0), _aD_, fmt_rest$1),
             fmt_rest$2 = match$1[3],
             prec$1 = match$1[2],
             pad$1 = match$1[1],
             _aC_ = [0, [6, iconv$0, pad$1, prec$1, fmt_rest$2]];
           var _ax_ = _aC_;
        }
        var fmt_result = _ax_;
        break a;
       }
      }
      else if(76 === symb){
       var
        _aE_ = caml_string_get(str, str_ind),
        _aF_ = get_space(0),
        _aG_ = get_hash(0),
        iconv$1 =
          compute_int_conv
           (pct_ind, str_ind + 1 | 0, get_plus(0), _aG_, _aF_, _aE_),
        fmt_rest$3 = parse(str_ind + 1 | 0, end_ind)[1];
       if(get_ign(0))
        var
         ignored$1 = [5, iconv$1, get_pad_opt(95)],
         _aH_ = [0, [23, ignored$1, fmt_rest$3]];
       else
        var
         _aI_ = get_prec(0),
         match$2 = make_padprec_fmt_ebb(get_int_pad(0), _aI_, fmt_rest$3),
         fmt_rest$4 = match$2[3],
         prec$2 = match$2[2],
         pad$2 = match$2[1],
         _aH_ = [0, [7, iconv$1, pad$2, prec$2, fmt_rest$4]];
       var fmt_result = _aH_;
       break a;
      }
      var
       fmt_result =
         caml_call3(failwith_message(_J_), str, str_ind - 1 | 0, symb);
     }
     if(1 - legacy_behavior$0){
      var _ak_ = 1 - plus_used[1], plus$0 = _ak_ ? plus : _ak_;
      if(plus$0) incompatible_flag(pct_ind, str_ind, symb, cst$27);
      var _al_ = 1 - hash_used[1], hash$0 = _al_ ? hash : _al_;
      if(hash$0) incompatible_flag(pct_ind, str_ind, symb, cst$28);
      var _am_ = 1 - space_used[1], space$0 = _am_ ? space : _am_;
      if(space$0) incompatible_flag(pct_ind, str_ind, symb, cst$29);
      var
       _an_ = 1 - pad_used[1],
       _ao_ = _an_ ? caml_notequal([0, pad], _K_) : _an_;
      if(_ao_) incompatible_flag(pct_ind, str_ind, symb, cst_padding$0);
      var
       _ap_ = 1 - prec_used[1],
       _aq_ = _ap_ ? caml_notequal([0, prec], _L_) : _ap_;
      if(_aq_){
       var _ar_ = ign ? 95 : symb;
       incompatible_flag(pct_ind, str_ind, _ar_, cst_precision$2);
      }
      var plus$1 = ign ? plus : ign;
      if(plus$1) incompatible_flag(pct_ind, str_ind, 95, cst$30);
     }
     var _as_ = 1 - ign_used[1], ign$0 = _as_ ? ign : _as_;
     a:
     if(ign$0){
      b:
      {
       if(38 <= symb){
        if(44 !== symb && 64 !== symb) break b;
       }
       else if(33 !== symb && 37 > symb) break b;
       if(legacy_behavior$0) break a;
      }
      incompatible_flag(pct_ind, str_ind, symb, cst$31);
     }
     return fmt_result;
    }
    function parse_tag(is_open_tag, str_ind, end_ind){
     try{
      if(str_ind === end_ind) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
      if(60 !== caml_string_get(str, str_ind))
       throw caml_maybe_attach_backtrace(Stdlib[8], 1);
      var ind = caml_call3(Stdlib_String[32], str, str_ind + 1 | 0, 62);
      if(end_ind <= ind) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
      var
       sub_str =
         caml_call3
          (Stdlib_String[16], str, str_ind, (ind - str_ind | 0) + 1 | 0),
       fmt_rest$0 = parse(ind + 1 | 0, end_ind)[1],
       sub_fmt = parse(str_ind, ind + 1 | 0)[1],
       sub_format$0 = [0, sub_fmt, sub_str],
       formatting$0 = is_open_tag ? [0, sub_format$0] : [1, sub_format$0],
       _ai_ = [0, [18, formatting$0, fmt_rest$0]];
      return _ai_;
     }
     catch(_aj_){
      var _ah_ = caml_wrap_exception(_aj_);
      if(_ah_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_ah_, 0);
      var
       fmt_rest = parse(str_ind, end_ind)[1],
       formatting = is_open_tag ? [0, sub_format] : [1, sub_format];
      return [0, [18, formatting, fmt_rest]];
     }
    }
    function parse_spaces(str_ind, end_ind){
     var str_ind$0 = str_ind;
     for(;;){
      if(str_ind$0 === end_ind) unexpected_end_of_format(end_ind);
      if(32 !== caml_string_get(str, str_ind$0)) return str_ind$0;
      var str_ind$1 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$1;
     }
    }
    function parse_positive(str_ind, end_ind, acc){
     var str_ind$0 = str_ind, acc$0 = acc;
     for(;;){
      if(str_ind$0 === end_ind) unexpected_end_of_format(end_ind);
      var c = caml_string_get(str, str_ind$0);
      if(9 < c - 48 >>> 0) return [0, str_ind$0, acc$0];
      var new_acc = (acc$0 * 10 | 0) + (c - 48 | 0) | 0;
      if(Stdlib_Sys[12] < new_acc){
       var _ag_ = Stdlib_Sys[12];
       return caml_call3(failwith_message(_S_), str, new_acc, _ag_);
      }
      var
       str_ind$1 = str_ind$0 + 1 | 0,
       str_ind$0 = str_ind$1,
       acc$0 = new_acc;
     }
    }
    function parse_integer(str_ind, end_ind){
     if(str_ind === end_ind) unexpected_end_of_format(end_ind);
     var match = caml_string_get(str, str_ind);
     if(48 <= match){
      if(58 > match) return parse_positive(str_ind, end_ind, 0);
     }
     else if(45 === match){
      if((str_ind + 1 | 0) === end_ind) unexpected_end_of_format(end_ind);
      var c = caml_string_get(str, str_ind + 1 | 0);
      if(9 < c - 48 >>> 0)
       return expected_character(str_ind + 1 | 0, cst_digit, c);
      var
       match$0 = parse_positive(str_ind + 1 | 0, end_ind, 0),
       n = match$0[2],
       next_ind = match$0[1];
      return [0, next_ind, - n | 0];
     }
     throw caml_maybe_attach_backtrace([0, Assert_failure, _T_], 1);
    }
    function add_literal(lit_start, str_ind, fmt){
     var size = str_ind - lit_start | 0;
     return 0 === size
             ? [0, fmt]
             : 1
               === size
               ? [0, [12, caml_string_get(str, lit_start), fmt]]
               : [0,
                 [11,
                  caml_call3(Stdlib_String[16], str, lit_start, size),
                  fmt]];
    }
    function search_subformat_end(str_ind, end_ind, c){
     var str_ind$0 = str_ind;
     for(;;){
      if(str_ind$0 === end_ind)
       caml_call3(failwith_message(_U_), str, c, end_ind);
      if(37 === caml_string_get(str, str_ind$0)){
       if((str_ind$0 + 1 | 0) === end_ind) unexpected_end_of_format(end_ind);
       if(caml_string_get(str, str_ind$0 + 1 | 0) === c) return str_ind$0;
       var match = caml_string_get(str, str_ind$0 + 1 | 0);
       if(95 <= match){
        if(123 <= match){
         if(126 > match)
          switch(match - 123 | 0){
            case 0:
             var
              sub_end = search_subformat_end(str_ind$0 + 2 | 0, end_ind, 125),
              str_ind$2 = sub_end + 2 | 0,
              str_ind$0 = str_ind$2;
             continue;
            case 1: break;
            default:
             return expected_character(str_ind$0 + 1 | 0, cst_character, 125);
          }
        }
        else if(96 > match){
         if((str_ind$0 + 2 | 0) === end_ind)
          unexpected_end_of_format(end_ind);
         var match$0 = caml_string_get(str, str_ind$0 + 2 | 0);
         if(40 === match$0){
          var
           sub_end$0 = search_subformat_end(str_ind$0 + 3 | 0, end_ind, 41),
           str_ind$3 = sub_end$0 + 2 | 0,
           str_ind$0 = str_ind$3;
          continue;
         }
         if(123 === match$0){
          var
           sub_end$1 = search_subformat_end(str_ind$0 + 3 | 0, end_ind, 125),
           str_ind$4 = sub_end$1 + 2 | 0,
           str_ind$0 = str_ind$4;
          continue;
         }
         var str_ind$5 = str_ind$0 + 3 | 0, str_ind$0 = str_ind$5;
         continue;
        }
       }
       else{
        if(40 === match){
         var
          sub_end$2 = search_subformat_end(str_ind$0 + 2 | 0, end_ind, 41),
          str_ind$6 = sub_end$2 + 2 | 0,
          str_ind$0 = str_ind$6;
         continue;
        }
        if(41 === match)
         return expected_character(str_ind$0 + 1 | 0, cst_character$0, 41);
       }
       var str_ind$1 = str_ind$0 + 2 | 0, str_ind$0 = str_ind$1;
      }
      else
       var str_ind$7 = str_ind$0 + 1 | 0, str_ind$0 = str_ind$7;
     }
    }
    function compute_int_conv(pct_ind, str_ind, plus, hash, space, symb){
     var plus$0 = plus, hash$0 = hash, space$0 = space;
     for(;;){
      a:
      {
       if(plus$0){
        if(! hash$0){
         if(space$0) break a;
         if(100 === symb) return 1;
         if(105 === symb) return 4;
         break a;
        }
       }
       else{
        if(! hash$0){
         if(space$0){
          if(100 === symb) return 2;
          if(105 === symb) return 5;
          break a;
         }
         var switcher$1 = symb - 88 | 0;
         if(32 < switcher$1 >>> 0) break a;
         switch(switcher$1){
           case 0:
            return 8;
           case 12:
            return 0;
           case 17:
            return 3;
           case 23:
            return 10;
           case 29:
            return 12;
           case 32:
            return 6;
           default: break a;
         }
        }
        if(! space$0){
         var switcher$0 = symb - 88 | 0;
         if(32 >= switcher$0 >>> 0)
          switch(switcher$0){
            case 0:
             return 9;
            case 12:
             return 13;
            case 17:
             return 14;
            case 23:
             return 11;
            case 29:
             return 15;
            case 32:
             return 7;
          }
        }
       }
       var switcher = symb - 88 | 0;
       if(32 >= switcher >>> 0)
        switch(switcher){
          case 0:
           if(legacy_behavior$0) return 9; break;
          case 23:
           if(legacy_behavior$0) return 11; break;
          case 32:
           if(legacy_behavior$0) return 7; break;
          case 12:
          case 17:
          case 29:
           if(! legacy_behavior$0)
            return incompatible_flag(pct_ind, str_ind, symb, cst$35);
           var hash$0 = 0;
           continue;
        }
      }
      if(plus$0)
       if(space$0){
        if(! legacy_behavior$0)
         return incompatible_flag(pct_ind, str_ind, 32, cst$32);
        var space$0 = 0;
       }
       else{
        if(! legacy_behavior$0)
         return incompatible_flag(pct_ind, str_ind, symb, cst$33);
        var plus$0 = 0;
       }
      else{
       if(! space$0)
        throw caml_maybe_attach_backtrace([0, Assert_failure, _W_], 1);
       if(! legacy_behavior$0)
        return incompatible_flag(pct_ind, str_ind, symb, cst$34);
       var space$0 = 0;
      }
     }
    }
    function incompatible_flag(pct_ind, str_ind, symb, option){
     var
      subfmt =
        caml_call3(Stdlib_String[16], str, pct_ind, str_ind - pct_ind | 0);
     return caml_call5
             (failwith_message(_Y_), str, pct_ind, option, symb, subfmt);
    }
    return parse(0, caml_ml_string_length(str));
   }
   function format_of_string_fmtty(str, fmtty){
    var fmt = fmt_ebb_of_string(0, str)[1];
    try{var _ae_ = [0, type_format(fmt, fmtty), str]; return _ae_;}
    catch(_af_){
     var _ac_ = caml_wrap_exception(_af_);
     if(_ac_ !== Type_mismatch) throw caml_maybe_attach_backtrace(_ac_, 0);
     var _ad_ = string_of_fmtty(fmtty);
     return caml_call2(failwith_message(_Z_), str, _ad_);
    }
   }
   function format_of_string_format(str, param){
    var
     str$0 = param[2],
     fmt = param[1],
     fmt$0 = fmt_ebb_of_string(0, str)[1];
    try{
     var _aa_ = [0, type_format(fmt$0, fmtty_of_fmt(fmt)), str];
     return _aa_;
    }
    catch(_ab_){
     var _$_ = caml_wrap_exception(_ab_);
     if(_$_ === Type_mismatch)
      return caml_call2(failwith_message(___), str, str$0);
     throw caml_maybe_attach_backtrace(_$_, 0);
    }
   }
   var
    CamlinternalFormat =
      [0,
       is_in_char_set,
       rev_char_set,
       create_char_set,
       add_in_char_set,
       freeze_char_set,
       param_format_of_ignored_format,
       make_printf,
       make_iprintf,
       output_acc,
       bufput_acc,
       strput_acc,
       type_format,
       fmt_ebb_of_string,
       format_of_string_fmtty,
       format_of_string_format,
       char_of_iconv,
       string_of_formatting_lit,
       string_of_fmtty,
       string_of_fmt,
       open_box_of_string,
       symm,
       trans,
       recast];
   runtime.caml_register_global(197, CamlinternalFormat, "CamlinternalFormat");
   return;
  }
  (globalThis));

//# 15981 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    CamlinternalFormat = global_data.CamlinternalFormat,
    Stdlib = global_data.Stdlib;
   function kfprintf(k, o, param){
    var fmt = param[1];
    return caml_call3
            (CamlinternalFormat[7],
             function(acc){
              caml_call2(CamlinternalFormat[9], o, acc);
              return caml_call1(k, o);
             },
             0,
             fmt);
   }
   function kbprintf(k, b, param){
    var fmt = param[1];
    return caml_call3
            (CamlinternalFormat[7],
             function(acc){
              caml_call2(CamlinternalFormat[10], b, acc);
              return caml_call1(k, b);
             },
             0,
             fmt);
   }
   function ikfprintf(k, oc, param){
    var fmt = param[1];
    return caml_call3(CamlinternalFormat[8], k, oc, fmt);
   }
   function fprintf(oc, fmt){
    return kfprintf(function(_d_){return 0;}, oc, fmt);
   }
   function bprintf(b, fmt){
    return kbprintf(function(_c_){return 0;}, b, fmt);
   }
   function ifprintf(oc, fmt){
    return ikfprintf(function(_b_){return 0;}, oc, fmt);
   }
   function ibprintf(b, fmt){
    return ikfprintf(function(_a_){return 0;}, b, fmt);
   }
   function printf(fmt){return fprintf(Stdlib[39], fmt);}
   function eprintf(fmt){return fprintf(Stdlib[40], fmt);}
   function ksprintf(k, param){
    var fmt = param[1];
    function k$0(acc){
     var buf = caml_call1(Stdlib_Buffer[1], 64);
     caml_call2(CamlinternalFormat[11], buf, acc);
     return caml_call1(k, caml_call1(Stdlib_Buffer[2], buf));
    }
    return caml_call3(CamlinternalFormat[7], k$0, 0, fmt);
   }
   function sprintf(fmt){return ksprintf(function(s){return s;}, fmt);}
   var
    Stdlib_Printf =
      [0,
       fprintf,
       printf,
       eprintf,
       sprintf,
       bprintf,
       ifprintf,
       ibprintf,
       kfprintf,
       ikfprintf,
       ksprintf,
       kbprintf,
       ikfprintf,
       ksprintf];
   runtime.caml_register_global(3, Stdlib_Printf, "Stdlib__Printf");
   return;
  }
  (globalThis));

//# 16790 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$4 = "",
    cst_s = "%s\n",
    cst_Program_not_linked_with_g_$0 =
      "(Program not linked with -g, cannot print stack backtrace)\n",
    cst_characters = ", characters ",
    cst_Fatal_error_exception = "Fatal error: exception ",
    cst_Fatal_error_exception_s = "Fatal error: exception %s\n",
    cst_Uncaught_exception = "Uncaught exception: ",
    cst_Uncaught_exception_s = "Uncaught exception: %s\n",
    caml_check_bound = runtime.caml_check_bound,
    caml_get_exception_raw_backtra = runtime.caml_get_exception_raw_backtrace,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_obj_tag = runtime.caml_obj_tag,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call6(f, a0, a1, a2, a3, a4, a5){
    return (f.l >= 0 ? f.l : f.l = f.length) == 6
            ? f(a0, a1, a2, a3, a4, a5)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4, a5]);
   }
   function caml_call8(f, a0, a1, a2, a3, a4, a5, a6, a7){
    return (f.l >= 0 ? f.l : f.l = f.length) == 8
            ? f(a0, a1, a2, a3, a4, a5, a6, a7)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4, a5, a6, a7]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    cst$0 = cst$4,
    cst$3 = cst$4,
    partial = [4, 0, 0, 0, [12, 45, [4, 0, 0, 0, 0]]],
    cst$1 = cst$4,
    cst$2 = cst$4,
    cst = "_",
    locfmt =
      [0,
       [11,
        'File "',
        [2,
         0,
         [11,
          '", line ',
          [4,
           0,
           0,
           0,
           [11,
            cst_characters,
            [4, 0, 0, 0, [12, 45, [4, 0, 0, 0, [11, ": ", [2, 0, 0]]]]]]]]]],
       'File "%s", line %d, characters %d-%d: %s'],
    Stdlib_Printf = global_data.Stdlib__Printf,
    Stdlib_Atomic = global_data.Stdlib__Atomic,
    Stdlib = global_data.Stdlib,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_Obj = global_data.Stdlib__Obj,
    printers = caml_call1(Stdlib_Atomic[1], 0),
    _a_ = [0, [3, 0, 0], "%S"],
    _b_ = [0, [4, 0, 0, 0, 0], "%d"],
    _c_ = [0, [11, ", ", [2, 0, [2, 0, 0]]], ", %s%s"],
    _d_ = [0, [12, 40, [2, 0, [2, 0, [12, 41, 0]]]], "(%s%s)"],
    _e_ = [0, [12, 40, [2, 0, [12, 41, 0]]], "(%s)"],
    cst_Out_of_memory = "Out of memory",
    cst_Stack_overflow = "Stack overflow",
    cst_Pattern_matching_failed = "Pattern matching failed",
    cst_Assertion_failed = "Assertion failed",
    cst_Undefined_recursive_module = "Undefined recursive module",
    _f_ =
      [0,
       [11, cst_Uncaught_exception, [2, 0, [12, 10, 0]]],
       cst_Uncaught_exception_s],
    _g_ =
      [0,
       [11, cst_Uncaught_exception, [2, 0, [12, 10, 0]]],
       cst_Uncaught_exception_s],
    cst_Raised_at = "Raised at",
    cst_Re_raised_at = "Re-raised at",
    cst_Raised_by_primitive_operat = "Raised by primitive operation at",
    cst_Called_from = "Called from",
    cst_inlined = " (inlined)",
    _h_ =
      [0,
       [2,
        0,
        [12,
         32,
         [2,
          0,
          [11,
           ' in file "',
           [2,
            0,
            [12,
             34,
             [2,
              0,
              [11, ", line ", [4, 0, 0, 0, [11, cst_characters, partial]]]]]]]]]],
       '%s %s in file "%s"%s, line %d, characters %d-%d'],
    _i_ = [0, [2, 0, [11, " unknown location", 0]], "%s unknown location"],
    _j_ = [0, [2, 0, [12, 10, 0]], cst_s],
    _k_ =
      [0,
       [11, cst_Program_not_linked_with_g_$0, 0],
       cst_Program_not_linked_with_g_$0],
    _l_ = [0, [2, 0, [12, 10, 0]], cst_s],
    cst_Program_not_linked_with_g_ = cst_Program_not_linked_with_g_$0;
   function field(x, i){
    var f = x[1 + i];
    if(! caml_call1(Stdlib_Obj[1], f))
     return caml_call2(Stdlib_Printf[4], _b_, f);
    var _ag_ = Stdlib_Obj[15];
    if(caml_obj_tag(f) === _ag_) return caml_call2(Stdlib_Printf[4], _a_, f);
    var _ah_ = Stdlib_Obj[16];
    return caml_obj_tag(f) === _ah_ ? caml_call1(Stdlib[35], f) : cst;
   }
   function other_fields(x, i){
    if(x.length - 1 <= i) return cst$0;
    var _ae_ = other_fields(x, i + 1 | 0), _af_ = field(x, i);
    return caml_call3(Stdlib_Printf[4], _c_, _af_, _ae_);
   }
   function use_printers(x){
    var param = caml_call1(Stdlib_Atomic[2], printers);
    for(;;){
     if(! param) return 0;
     var tl = param[2], hd = param[1];
     a:
     {
      try{var val = caml_call1(hd, x);}catch(_ad_){break a;}
      if(val){var s = val[1]; return [0, s];}
     }
     var param = tl;
    }
   }
   function string_of_extension_constructo(t){
    if(0 === caml_obj_tag(t)){
     var constructor = t[1][1], match = t.length - 1;
     if(2 < match >>> 0)
      var
       _$_ = other_fields(t, 2),
       _aa_ = field(t, 1),
       _ac_ = caml_call3(Stdlib_Printf[4], _d_, _aa_, _$_);
     else
      switch(match){
        case 0:
         var _ac_ = cst$1; break;
        case 1:
         var _ac_ = cst$2; break;
        default:
         var
          _ab_ = field(t, 1),
          _ac_ = caml_call2(Stdlib_Printf[4], _e_, _ab_);
      }
     var match$0 = [0, constructor, [0, _ac_]];
    }
    else
     var match$0 = [0, t[1], 0];
    var fields_opt = match$0[2], constructor$0 = match$0[1];
    if(! fields_opt) return constructor$0;
    var f = fields_opt[1];
    return caml_call2(Stdlib[28], constructor$0, f);
   }
   function to_string_default(x){
    if(x === Stdlib[9]) return cst_Out_of_memory;
    if(x === Stdlib[10]) return cst_Stack_overflow;
    if(x[1] === Stdlib[4]){
     var match = x[2], char$0 = match[3], line = match[2], file = match[1];
     return caml_call6
             (Stdlib_Printf[4],
              locfmt,
              file,
              line,
              char$0,
              char$0 + 5 | 0,
              cst_Pattern_matching_failed);
    }
    if(x[1] === Stdlib[5]){
     var
      match$0 = x[2],
      char$1 = match$0[3],
      line$0 = match$0[2],
      file$0 = match$0[1];
     return caml_call6
             (Stdlib_Printf[4],
              locfmt,
              file$0,
              line$0,
              char$1,
              char$1 + 6 | 0,
              cst_Assertion_failed);
    }
    if(x[1] !== Stdlib[15]) return string_of_extension_constructo(x);
    var
     match$1 = x[2],
     char$2 = match$1[3],
     line$1 = match$1[2],
     file$1 = match$1[1];
    return caml_call6
            (Stdlib_Printf[4],
             locfmt,
             file$1,
             line$1,
             char$2,
             char$2 + 6 | 0,
             cst_Undefined_recursive_module);
   }
   function to_string(e){
    var match = use_printers(e);
    if(! match) return to_string_default(e);
    var s = match[1];
    return s;
   }
   function print(fct, arg){
    try{var ___ = caml_call1(fct, arg); return ___;}
    catch(x$0){
     var x = caml_wrap_exception(x$0), _Z_ = to_string(x);
     caml_call2(Stdlib_Printf[3], _f_, _Z_);
     caml_call1(Stdlib[63], Stdlib[40]);
     throw caml_maybe_attach_backtrace(x, 0);
    }
   }
   function catch$0(fct, arg){
    try{var _Y_ = caml_call1(fct, arg); return _Y_;}
    catch(x$0){
     var x = caml_wrap_exception(x$0);
     caml_call1(Stdlib[63], Stdlib[39]);
     var _X_ = to_string(x);
     caml_call2(Stdlib_Printf[3], _g_, _X_);
     return caml_call1(Stdlib[99], 2);
    }
   }
   function raw_backtrace_entries(bt){return bt;}
   function convert_raw_backtrace(bt){
    return [0, runtime.caml_convert_raw_backtrace(bt)];
   }
   function format_backtrace_slot(pos, slot){
    function info(is_raise){
     return is_raise
             ? 0 === pos ? cst_Raised_at : cst_Re_raised_at
             : 0 === pos ? cst_Raised_by_primitive_operat : cst_Called_from;
    }
    if(0 === slot[0]){
     var
      _P_ = slot[5],
      _Q_ = slot[4],
      _R_ = slot[3],
      _S_ = slot[6] ? cst_inlined : cst$3,
      _T_ = slot[2],
      _U_ = slot[7],
      _V_ = info(slot[1]);
     return [0,
             caml_call8
              (Stdlib_Printf[4], _h_, _V_, _U_, _T_, _S_, _R_, _Q_, _P_)];
    }
    if(slot[1]) return 0;
    var _W_ = info(0);
    return [0, caml_call2(Stdlib_Printf[4], _i_, _W_)];
   }
   function print_raw_backtrace(outchan, raw_backtrace){
    var backtrace = convert_raw_backtrace(raw_backtrace);
    if(! backtrace) return caml_call2(Stdlib_Printf[1], outchan, _k_);
    var a = backtrace[1], _N_ = a.length - 1 - 1 | 0, _M_ = 0;
    if(_N_ >= 0){
     var i = _M_;
     for(;;){
      var match = format_backtrace_slot(i, caml_check_bound(a, i)[1 + i]);
      if(match){
       var str = match[1];
       caml_call3(Stdlib_Printf[1], outchan, _j_, str);
      }
      var _O_ = i + 1 | 0;
      if(_N_ === i) break;
      var i = _O_;
     }
    }
    return 0;
   }
   function print_backtrace(outchan){
    return print_raw_backtrace(outchan, caml_get_exception_raw_backtra(0));
   }
   function raw_backtrace_to_string(raw_backtrace){
    var backtrace = convert_raw_backtrace(raw_backtrace);
    if(! backtrace) return cst_Program_not_linked_with_g_;
    var
     a = backtrace[1],
     b = caml_call1(Stdlib_Buffer[1], 1024),
     _K_ = a.length - 1 - 1 | 0,
     _J_ = 0;
    if(_K_ >= 0){
     var i = _J_;
     for(;;){
      var match = format_backtrace_slot(i, caml_check_bound(a, i)[1 + i]);
      if(match){
       var str = match[1];
       caml_call3(Stdlib_Printf[5], b, _l_, str);
      }
      var _L_ = i + 1 | 0;
      if(_K_ === i) break;
      var i = _L_;
     }
    }
    return caml_call1(Stdlib_Buffer[2], b);
   }
   function backtrace_slot_is_raise(param){
    return 0 === param[0] ? param[1] : param[1];
   }
   function backtrace_slot_is_inline(param){return 0 === param[0] ? param[6] : 0;
   }
   function backtrace_slot_location(param){
    return 0 === param[0]
            ? [0, [0, param[2], param[3], param[4], param[5]]]
            : 0;
   }
   function backtrace_slot_defname(param){
    if(0 === param[0] && runtime.caml_string_notequal(param[7], cst$4))
     return [0, param[7]];
    return 0;
   }
   function backtrace_slots(raw_backtrace){
    var match = convert_raw_backtrace(raw_backtrace);
    if(! match) return 0;
    var backtrace = match[1], i$1 = backtrace.length - 1 - 1 | 0, i = i$1;
    for(;;){
     if(-1 === i)
      var _I_ = 0;
     else{
      var _H_ = 0 === caml_check_bound(backtrace, i)[1 + i][0] ? 1 : 0;
      if(! _H_){var i$0 = i - 1 | 0, i = i$0; continue;}
      var _I_ = _H_;
     }
     return _I_ ? [0, backtrace] : 0;
    }
   }
   function backtrace_slots_of_raw_entry(entry){return backtrace_slots([0, entry]);
   }
   function raw_backtrace_length(bt){return bt.length - 1;}
   function get_backtrace(param){
    return raw_backtrace_to_string(caml_get_exception_raw_backtra(0));
   }
   function register_printer(fn){
    for(;;){
     var
      old_printers = caml_call1(Stdlib_Atomic[2], printers),
      new_printers = [0, fn, old_printers],
      success =
        caml_call3(Stdlib_Atomic[5], printers, old_printers, new_printers),
      _G_ = 1 - success;
     if(! _G_) return _G_;
    }
   }
   function exn_slot(x){return 0 === caml_obj_tag(x) ? x[1] : x;}
   function exn_slot_id(x){var slot = exn_slot(x); return slot[2];}
   function exn_slot_name(x){var slot = exn_slot(x); return slot[1];}
   var
    errors =
      [0,
        cst$4,
        "(Cannot print locations:\n bytecode executable program file not found)",
        "(Cannot print locations:\n bytecode executable program file appears to be corrupt)",
        "(Cannot print locations:\n bytecode executable program file has wrong magic number)",
        "(Cannot print locations:\n bytecode executable program file cannot be opened;\n -- too many open files. Try running with OCAMLRUNPARAM=b=2)"].slice
       (),
    _m_ =
      [0,
       [11, cst_Fatal_error_exception, [2, 0, [12, 10, 0]]],
       cst_Fatal_error_exception_s];
   function default_uncaught_exception_han(exn, raw_backtrace){
    var _D_ = to_string(exn);
    caml_call2(Stdlib_Printf[3], _m_, _D_);
    print_raw_backtrace(Stdlib[40], raw_backtrace);
    var status = runtime.caml_ml_debug_info_status(0);
    if(status < 0){
     var
      _E_ = caml_call1(Stdlib[18], status),
      _F_ = caml_check_bound(errors, _E_)[1 + _E_];
     caml_call1(Stdlib[53], _F_);
    }
    return caml_call1(Stdlib[63], Stdlib[40]);
   }
   var uncaught_exception_handler = [0, default_uncaught_exception_han];
   function set_uncaught_exception_handler(fn){
    uncaught_exception_handler[1] = fn;
    return 0;
   }
   var
    empty_backtrace = [0],
    cst_Fatal_error_out_of_memory_ =
      "Fatal error: out of memory in uncaught exception handler",
    _n_ =
      [0,
       [11, cst_Fatal_error_exception, [2, 0, [12, 10, 0]]],
       cst_Fatal_error_exception_s],
    _o_ =
      [0,
       [11,
        "Fatal error in uncaught exception handler: exception ",
        [2, 0, [12, 10, 0]]],
       "Fatal error in uncaught exception handler: exception %s\n"];
   function handle_uncaught_exception(exn$0, debugger_in_use){
    try{
     try{
      var
       raw_backtrace =
         debugger_in_use ? empty_backtrace : caml_get_exception_raw_backtra(0);
      try{caml_call1(Stdlib[103], 0);}catch(_C_){}
      try{
       var
        _y_ = caml_call2(uncaught_exception_handler[1], exn$0, raw_backtrace),
        _x_ = _y_;
      }
      catch(exn$1){
       var
        exn = caml_wrap_exception(exn$1),
        raw_backtrace$0 = caml_get_exception_raw_backtra(0),
        _v_ = to_string(exn$0);
       caml_call2(Stdlib_Printf[3], _n_, _v_);
       print_raw_backtrace(Stdlib[40], raw_backtrace);
       var _w_ = to_string(exn);
       caml_call2(Stdlib_Printf[3], _o_, _w_);
       print_raw_backtrace(Stdlib[40], raw_backtrace$0);
       var _x_ = caml_call1(Stdlib[63], Stdlib[40]);
      }
      var _z_ = _x_;
     }
     catch(_B_){
      var _u_ = caml_wrap_exception(_B_);
      if(_u_ !== Stdlib[9]) throw caml_maybe_attach_backtrace(_u_, 0);
      var _z_ = caml_call1(Stdlib[53], cst_Fatal_error_out_of_memory_);
     }
     return _z_;
    }
    catch(_A_){return 0;}
   }
   runtime.caml_register_named_value
    ("Printexc.handle_uncaught_exception", handle_uncaught_exception);
   var
    Stdlib_Printexc =
      [0,
       to_string,
       to_string_default,
       print,
       catch$0,
       print_backtrace,
       get_backtrace,
       runtime.caml_record_backtrace,
       runtime.caml_backtrace_status,
       register_printer,
       use_printers,
       raw_backtrace_entries,
       function(_t_){return caml_get_exception_raw_backtra(_t_);},
       print_raw_backtrace,
       raw_backtrace_to_string,
       default_uncaught_exception_han,
       set_uncaught_exception_handler,
       backtrace_slots,
       backtrace_slots_of_raw_entry,
       [0,
        backtrace_slot_is_raise,
        backtrace_slot_is_inline,
        backtrace_slot_location,
        backtrace_slot_defname,
        format_backtrace_slot],
       raw_backtrace_length,
       function(_s_, _r_){return runtime.caml_raw_backtrace_slot(_s_, _r_);},
       function(_q_){return runtime.caml_convert_raw_backtrace_slot(_q_);},
       function(_p_){return runtime.caml_raw_backtrace_next_slot(_p_);},
       exn_slot_id,
       exn_slot_name,
       string_of_extension_constructo];
   runtime.caml_register_global(42, Stdlib_Printexc, "Stdlib__Printexc");
   return;
  }
  (globalThis));

//# 17282 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_restore_raw_backtrace = runtime.caml_restore_raw_backtrace,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Printexc = global_data.Stdlib__Printexc,
    Stdlib = global_data.Stdlib;
   function const$0(c, param){return c;}
   function flip(f, x, y){return caml_call2(f, y, x);}
   function negate(p, v){return 1 - caml_call1(p, v);}
   var
    Finally_raised =
      [248, "Stdlib.Fun.Finally_raised", runtime.caml_fresh_oo_id(0)],
    cst_Fun_Finally_raised = "Fun.Finally_raised: ";
   caml_call1
    (Stdlib_Printexc[9],
     function(param){
      if(param[1] !== Finally_raised) return 0;
      var exn = param[2], _a_ = caml_call1(Stdlib_Printexc[1], exn);
      return [0, caml_call2(Stdlib[28], cst_Fun_Finally_raised, _a_)];
     });
   function protect(finally$0, work){
    function finally_no_exn(param){
     try{caml_call1(finally$0, 0); return;}
     catch(e$0){
      var
       e = caml_wrap_exception(e$0),
       bt = caml_call1(Stdlib_Printexc[12], 0),
       exn = [0, Finally_raised, e];
      caml_restore_raw_backtrace(exn, bt);
      throw caml_maybe_attach_backtrace(exn, 0);
     }
    }
    try{var result = caml_call1(work, 0);}
    catch(work_exn$0){
     var
      work_exn = caml_wrap_exception(work_exn$0),
      work_bt = caml_call1(Stdlib_Printexc[12], 0);
     finally_no_exn(0);
     caml_restore_raw_backtrace(work_exn, work_bt);
     throw caml_maybe_attach_backtrace(work_exn, 0);
    }
    finally_no_exn(0);
    return result;
   }
   var Stdlib_Fun = [0, const$0, flip, negate, protect, Finally_raised];
   runtime.caml_register_global(4, Stdlib_Fun, "Stdlib__Fun");
   return;
  }
  (globalThis));

//# 17647 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Bigarray_Array3_of_array_n$1 =
      "Bigarray.Array3.of_array: non-cubic data",
    caml_ba_change_layout = runtime.caml_ba_change_layout,
    caml_ba_create = runtime.caml_ba_create,
    caml_ba_dim_1 = runtime.caml_ba_dim_1,
    caml_ba_dim_2 = runtime.caml_ba_dim_2,
    caml_ba_kind = runtime.caml_ba_kind,
    caml_ba_num_dims = runtime.caml_ba_num_dims,
    caml_ba_reshape = runtime.caml_ba_reshape,
    caml_ba_set_1 = runtime.caml_ba_set_1,
    caml_ba_set_2 = runtime.caml_ba_set_2,
    caml_ba_set_3 = runtime.caml_ba_set_3,
    caml_ba_set_generic = runtime.caml_ba_set_generic,
    caml_ba_slice = runtime.caml_ba_slice,
    caml_check_bound = runtime.caml_check_bound,
    caml_make_vect = runtime.caml_make_vect,
    caml_mul = runtime.caml_mul;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    Stdlib = global_data.Stdlib,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_Sys = global_data.Stdlib__Sys;
   function kind_size_in_bytes(param){
    switch(param){
      case 0:
       return 4;
      case 1:
       return 8;
      case 2:
       return 1;
      case 3:
       return 1;
      case 4:
       return 2;
      case 5:
       return 2;
      case 6:
       return 4;
      case 7:
       return 8;
      case 8:
       return Stdlib_Sys[9] / 8 | 0;
      case 9:
       return Stdlib_Sys[9] / 8 | 0;
      case 10:
       return 8;
      case 11:
       return 16;
      default: return 1;
    }
   }
   var
    cst_Bigarray_Array2_of_array_n =
      "Bigarray.Array2.of_array: non-rectangular data",
    cst_Bigarray_Array3_of_array_n = cst_Bigarray_Array3_of_array_n$1,
    cst_Bigarray_Array3_of_array_n$0 = cst_Bigarray_Array3_of_array_n$1,
    cst_Bigarray_array0_of_genarra = "Bigarray.array0_of_genarray",
    cst_Bigarray_array1_of_genarra = "Bigarray.array1_of_genarray",
    cst_Bigarray_array2_of_genarra = "Bigarray.array2_of_genarray",
    cst_Bigarray_array3_of_genarra = "Bigarray.array3_of_genarray";
   function cloop(arr, idx, f, col, max){
    if(col === idx.length - 1){
     caml_ba_set_generic(arr, idx, caml_call1(f, idx));
     return;
    }
    var _am_ = caml_check_bound(max, col)[1 + col] - 1 | 0, _al_ = 0;
    if(_am_ >= 0){
     var j = _al_;
     for(;;){
      caml_check_bound(idx, col)[1 + col] = j;
      cloop(arr, idx, f, col + 1 | 0, max);
      var _an_ = j + 1 | 0;
      if(_am_ === j) break;
      var j = _an_;
     }
    }
    return;
   }
   function floop(arr, idx, f, col, max){
    if(0 > col){caml_ba_set_generic(arr, idx, caml_call1(f, idx)); return;}
    var _aj_ = caml_check_bound(max, col)[1 + col], _ai_ = 1;
    if(_aj_ >= 1){
     var j = _ai_;
     for(;;){
      caml_check_bound(idx, col)[1 + col] = j;
      floop(arr, idx, f, col - 1 | 0, max);
      var _ak_ = j + 1 | 0;
      if(_aj_ === j) break;
      var j = _ak_;
     }
    }
    return;
   }
   function init(kind, layout, dims, f){
    var arr = caml_ba_create(kind, layout, dims), dlen = dims.length - 1;
    return layout
            ? (floop
               (arr, caml_make_vect(dlen, 1), f, dlen - 1 | 0, dims),
              arr)
            : (cloop(arr, caml_make_vect(dlen, 0), f, 0, dims), arr);
   }
   function dims(a){
    var
     n = caml_ba_num_dims(a),
     d = caml_make_vect(n, 0),
     _af_ = n - 1 | 0,
     _ae_ = 0;
    if(_af_ >= 0){
     var i = _ae_;
     for(;;){
      var _ag_ = runtime.caml_ba_dim(a, i);
      caml_check_bound(d, i)[1 + i] = _ag_;
      var _ah_ = i + 1 | 0;
      if(_af_ === i) break;
      var i = _ah_;
     }
    }
    return d;
   }
   function size_in_bytes(arr){
    var
     _ac_ = dims(arr),
     _ad_ = caml_call3(Stdlib_Array[17], caml_mul, 1, _ac_);
    return caml_mul(kind_size_in_bytes(caml_ba_kind(arr)), _ad_);
   }
   function create(kind, layout){return caml_ba_create(kind, layout, [0]);}
   function get(arr){return runtime.caml_ba_get_generic(arr, [0]);}
   function set(arr){
    var _aa_ = [0];
    return function(_ab_){return caml_ba_set_generic(arr, _aa_, _ab_);};
   }
   function size_in_bytes$0(arr){
    return kind_size_in_bytes(caml_ba_kind(arr));
   }
   function of_value(kind, layout, v){
    var a = create(kind, layout);
    set(a)(v);
    return a;
   }
   function create$0(kind, layout, dim){
    return caml_ba_create(kind, layout, [0, dim]);
   }
   function size_in_bytes$1(arr){
    var _$_ = caml_ba_dim_1(arr);
    return caml_mul(kind_size_in_bytes(caml_ba_kind(arr)), _$_);
   }
   function slice(a, n){
    return runtime.caml_ba_layout(a)
            ? caml_ba_slice(a, [0, n])
            : caml_ba_slice(a, [0, n]);
   }
   function init$0(kind, layout, dim, f){
    var arr = create$0(kind, layout, dim);
    if(layout){
     var _Z_ = 1;
     if(dim >= 1){
      var i$0 = _Z_;
      for(;;){
       caml_ba_set_1(arr, i$0, caml_call1(f, i$0));
       var ___ = i$0 + 1 | 0;
       if(dim === i$0) break;
       var i$0 = ___;
      }
     }
     return arr;
    }
    var _X_ = dim - 1 | 0, _W_ = 0;
    if(_X_ >= 0){
     var i = _W_;
     for(;;){
      caml_ba_set_1(arr, i, caml_call1(f, i));
      var _Y_ = i + 1 | 0;
      if(_X_ === i) break;
      var i = _Y_;
     }
    }
    return arr;
   }
   function of_array(kind, layout, data){
    var
     ba = create$0(kind, layout, data.length - 1),
     ofs = layout ? 1 : 0,
     _U_ = data.length - 1 - 1 | 0,
     _T_ = 0;
    if(_U_ >= 0){
     var i = _T_;
     for(;;){
      caml_ba_set_1(ba, i + ofs | 0, caml_check_bound(data, i)[1 + i]);
      var _V_ = i + 1 | 0;
      if(_U_ === i) break;
      var i = _V_;
     }
    }
    return ba;
   }
   function create$1(kind, layout, dim1, dim2){
    return caml_ba_create(kind, layout, [0, dim1, dim2]);
   }
   function size_in_bytes$2(arr){
    var _R_ = caml_ba_dim_2(arr), _S_ = caml_ba_dim_1(arr);
    return caml_mul(caml_mul(kind_size_in_bytes(caml_ba_kind(arr)), _S_), _R_);
   }
   function slice_left(a, n){return caml_ba_slice(a, [0, n]);}
   function slice_right(a, n){return caml_ba_slice(a, [0, n]);}
   function init$1(kind, layout, dim1, dim2, f){
    var arr = create$1(kind, layout, dim1, dim2);
    if(layout){
     var _N_ = 1;
     if(dim2 >= 1){
      var j$0 = _N_;
      for(;;){
       var _O_ = 1;
       if(dim1 >= 1){
        var i$0 = _O_;
        for(;;){
         caml_ba_set_2(arr, i$0, j$0, caml_call2(f, i$0, j$0));
         var _Q_ = i$0 + 1 | 0;
         if(dim1 === i$0) break;
         var i$0 = _Q_;
        }
       }
       var _P_ = j$0 + 1 | 0;
       if(dim2 === j$0) break;
       var j$0 = _P_;
      }
     }
     return arr;
    }
    var _I_ = dim1 - 1 | 0, _H_ = 0;
    if(_I_ >= 0){
     var i = _H_;
     for(;;){
      var _K_ = dim2 - 1 | 0, _J_ = 0;
      if(_K_ >= 0){
       var j = _J_;
       for(;;){
        caml_ba_set_2(arr, i, j, caml_call2(f, i, j));
        var _M_ = j + 1 | 0;
        if(_K_ === j) break;
        var j = _M_;
       }
      }
      var _L_ = i + 1 | 0;
      if(_I_ === i) break;
      var i = _L_;
     }
    }
    return arr;
   }
   function of_array$0(kind, layout, data){
    var
     dim1 = data.length - 1,
     dim2 = 0 === dim1 ? 0 : caml_check_bound(data, 0)[1].length - 1,
     ba = create$1(kind, layout, dim1, dim2),
     ofs = layout ? 1 : 0,
     _C_ = dim1 - 1 | 0,
     _B_ = 0;
    if(_C_ >= 0){
     var i = _B_;
     for(;;){
      var row = caml_check_bound(data, i)[1 + i];
      if(row.length - 1 !== dim2)
       caml_call1(Stdlib[1], cst_Bigarray_Array2_of_array_n);
      var _E_ = dim2 - 1 | 0, _D_ = 0;
      if(_E_ >= 0){
       var j = _D_;
       for(;;){
        caml_ba_set_2
         (ba, i + ofs | 0, j + ofs | 0, caml_check_bound(row, j)[1 + j]);
        var _G_ = j + 1 | 0;
        if(_E_ === j) break;
        var j = _G_;
       }
      }
      var _F_ = i + 1 | 0;
      if(_C_ === i) break;
      var i = _F_;
     }
    }
    return ba;
   }
   function create$2(kind, layout, dim1, dim2, dim3){
    return caml_ba_create(kind, layout, [0, dim1, dim2, dim3]);
   }
   function size_in_bytes$3(arr){
    var
     _y_ = runtime.caml_ba_dim_3(arr),
     _z_ = caml_ba_dim_2(arr),
     _A_ = caml_ba_dim_1(arr);
    return caml_mul
            (caml_mul
              (caml_mul(kind_size_in_bytes(caml_ba_kind(arr)), _A_), _z_),
             _y_);
   }
   function slice_left_1(a, n, m){return caml_ba_slice(a, [0, n, m]);}
   function slice_right_1(a, n, m){return caml_ba_slice(a, [0, n, m]);}
   function slice_left_2(a, n){return caml_ba_slice(a, [0, n]);}
   function slice_right_2(a, n){return caml_ba_slice(a, [0, n]);}
   function init$2(kind, layout, dim1, dim2, dim3, f){
    var arr = create$2(kind, layout, dim1, dim2, dim3);
    if(layout){
     var _s_ = 1;
     if(dim3 >= 1){
      var k$0 = _s_;
      for(;;){
       var _t_ = 1;
       if(dim2 >= 1){
        var j$0 = _t_;
        for(;;){
         var _v_ = 1;
         if(dim1 >= 1){
          var i$0 = _v_;
          for(;;){
           caml_ba_set_3(arr, i$0, j$0, k$0, caml_call3(f, i$0, j$0, k$0));
           var _x_ = i$0 + 1 | 0;
           if(dim1 === i$0) break;
           var i$0 = _x_;
          }
         }
         var _w_ = j$0 + 1 | 0;
         if(dim2 === j$0) break;
         var j$0 = _w_;
        }
       }
       var _u_ = k$0 + 1 | 0;
       if(dim3 === k$0) break;
       var k$0 = _u_;
      }
     }
     return arr;
    }
    var _k_ = dim1 - 1 | 0, _j_ = 0;
    if(_k_ >= 0){
     var i = _j_;
     for(;;){
      var _m_ = dim2 - 1 | 0, _l_ = 0;
      if(_m_ >= 0){
       var j = _l_;
       for(;;){
        var _p_ = dim3 - 1 | 0, _o_ = 0;
        if(_p_ >= 0){
         var k = _o_;
         for(;;){
          caml_ba_set_3(arr, i, j, k, caml_call3(f, i, j, k));
          var _r_ = k + 1 | 0;
          if(_p_ === k) break;
          var k = _r_;
         }
        }
        var _q_ = j + 1 | 0;
        if(_m_ === j) break;
        var j = _q_;
       }
      }
      var _n_ = i + 1 | 0;
      if(_k_ === i) break;
      var i = _n_;
     }
    }
    return arr;
   }
   function of_array$1(kind, layout, data){
    var
     dim1 = data.length - 1,
     dim2 = 0 === dim1 ? 0 : caml_check_bound(data, 0)[1].length - 1,
     dim3 =
       0 === dim2
        ? 0
        : caml_check_bound(caml_check_bound(data, 0)[1], 0)[1].length - 1,
     ba = create$2(kind, layout, dim1, dim2, dim3),
     ofs = layout ? 1 : 0,
     _b_ = dim1 - 1 | 0,
     _a_ = 0;
    if(_b_ >= 0){
     var i = _a_;
     for(;;){
      var row = caml_check_bound(data, i)[1 + i];
      if(row.length - 1 !== dim2)
       caml_call1(Stdlib[1], cst_Bigarray_Array3_of_array_n);
      var _d_ = dim2 - 1 | 0, _c_ = 0;
      if(_d_ >= 0){
       var j = _c_;
       for(;;){
        var col = caml_check_bound(row, j)[1 + j];
        if(col.length - 1 !== dim3)
         caml_call1(Stdlib[1], cst_Bigarray_Array3_of_array_n$0);
        var _g_ = dim3 - 1 | 0, _f_ = 0;
        if(_g_ >= 0){
         var k = _f_;
         for(;;){
          caml_ba_set_3
           (ba,
            i + ofs | 0,
            j + ofs | 0,
            k + ofs | 0,
            caml_check_bound(col, k)[1 + k]);
          var _i_ = k + 1 | 0;
          if(_g_ === k) break;
          var k = _i_;
         }
        }
        var _h_ = j + 1 | 0;
        if(_d_ === j) break;
        var j = _h_;
       }
      }
      var _e_ = i + 1 | 0;
      if(_b_ === i) break;
      var i = _e_;
     }
    }
    return ba;
   }
   function array0_of_genarray(a){
    return 0 === caml_ba_num_dims(a)
            ? a
            : caml_call1(Stdlib[1], cst_Bigarray_array0_of_genarra);
   }
   function array1_of_genarray(a){
    return 1 === caml_ba_num_dims(a)
            ? a
            : caml_call1(Stdlib[1], cst_Bigarray_array1_of_genarra);
   }
   function array2_of_genarray(a){
    return 2 === caml_ba_num_dims(a)
            ? a
            : caml_call1(Stdlib[1], cst_Bigarray_array2_of_genarra);
   }
   function array3_of_genarray(a){
    return 3 === caml_ba_num_dims(a)
            ? a
            : caml_call1(Stdlib[1], cst_Bigarray_array3_of_genarra);
   }
   function reshape_0(a){return caml_ba_reshape(a, [0]);}
   function reshape_1(a, dim1){return caml_ba_reshape(a, [0, dim1]);}
   function reshape_2(a, dim1, dim2){
    return caml_ba_reshape(a, [0, dim1, dim2]);
   }
   function reshape_3(a, dim1, dim2, dim3){
    return caml_ba_reshape(a, [0, dim1, dim2, dim3]);
   }
   var
    Stdlib_Bigarray =
      [0,
       0,
       1,
       10,
       11,
       2,
       3,
       4,
       5,
       8,
       6,
       7,
       9,
       12,
       kind_size_in_bytes,
       0,
       1,
       [0, init, dims, size_in_bytes],
       [0,
        create,
        of_value,
        caml_ba_change_layout,
        size_in_bytes$0,
        get,
        set,
        of_value],
       [0,
        create$0,
        init$0,
        caml_ba_change_layout,
        size_in_bytes$1,
        slice,
        of_array],
       [0,
        create$1,
        init$1,
        caml_ba_change_layout,
        size_in_bytes$2,
        slice_left,
        slice_right,
        of_array$0],
       [0,
        create$2,
        init$2,
        caml_ba_change_layout,
        size_in_bytes$3,
        slice_left_1,
        slice_right_1,
        slice_left_2,
        slice_right_2,
        of_array$1],
       array0_of_genarray,
       array1_of_genarray,
       array2_of_genarray,
       array3_of_genarray,
       caml_ba_reshape,
       reshape_0,
       reshape_1,
       reshape_2,
       reshape_3];
   runtime.caml_register_global(10, Stdlib_Bigarray, "Stdlib__Bigarray");
   return;
  }
  (globalThis));

//# 19794 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$16 = "",
    cst$15 = ">",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call4(f, a0, a1, a2, a3){
    return (f.l >= 0 ? f.l : f.l = f.length) == 4
            ? f(a0, a1, a2, a3)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    cst$14 = ".",
    cst$11 = cst$15,
    cst$12 = "<\/",
    cst$13 = cst$16,
    cst$8 = cst$15,
    cst$9 = "<",
    cst$10 = cst$16,
    cst$7 = "\n",
    cst$3 = cst$16,
    cst$4 = cst$16,
    cst$5 = cst$16,
    cst$6 = cst$16,
    cst = cst$16,
    cst$0 = cst$16,
    cst$1 = cst$16,
    cst$2 = cst$16,
    Stdlib_Queue = global_data.Stdlib__Queue,
    CamlinternalFormat = global_data.CamlinternalFormat,
    Stdlib = global_data.Stdlib,
    Stdlib_String = global_data.Stdlib__String,
    Stdlib_Domain = global_data.Stdlib__Domain,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_Seq = global_data.Stdlib__Seq,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_List = global_data.Stdlib__List,
    Stdlib_Stack = global_data.Stdlib__Stack,
    Stdlib_Int = global_data.Stdlib__Int,
    Stdlib_Bytes = global_data.Stdlib__Bytes;
   function id(x){return x;}
   var
    zero = 0,
    unknown = -1,
    String_tag =
      [248, "Stdlib.Format.String_tag", runtime.caml_fresh_oo_id(0)];
   function pp_enqueue(state, token){
    state[13] = state[13] + token[3] | 0;
    return caml_call2(Stdlib_Queue[3], token, state[28]);
   }
   var
    pp_infinity = 1000000010,
    _a_ = [0, cst$16, 0, cst$16],
    _b_ = [0, cst$16],
    _c_ = [1, "margin <= max_indent"],
    _d_ = [0, 0],
    _e_ = [1, "max_indent < 2"],
    cst_Format_pp_set_geometry = "Format.pp_set_geometry: ";
   function pp_output_string(state, s){
    return caml_call3(state[17], s, 0, caml_ml_string_length(s));
   }
   function pp_output_newline(state){return caml_call1(state[19], 0);}
   function format_pp_text(state, size, text){
    state[9] = state[9] - size | 0;
    pp_output_string(state, text);
    state[11] = 0;
    return;
   }
   function format_string(state, s){
    var _a9_ = runtime.caml_string_notequal(s, cst$16);
    return _a9_ ? format_pp_text(state, caml_ml_string_length(s), s) : _a9_;
   }
   function break_new_line(state, param, width){
    var after = param[3], offset = param[2], before = param[1];
    format_string(state, before);
    pp_output_newline(state);
    state[11] = 1;
    var
     indent = (state[6] - width | 0) + offset | 0,
     real_indent = caml_call2(Stdlib_Int[10], state[8], indent);
    state[10] = real_indent;
    state[9] = state[6] - state[10] | 0;
    var n = state[10];
    caml_call1(state[21], n);
    return format_string(state, after);
   }
   function break_line(state, width){
    return break_new_line(state, _a_, width);
   }
   function break_same_line(state, param){
    var after = param[3], width = param[2], before = param[1];
    format_string(state, before);
    state[9] = state[9] - width | 0;
    caml_call1(state[20], width);
    return format_string(state, after);
   }
   function format_pp_token(state, size$0, param){
    if(typeof param === "number")
     switch(param){
       case 0:
        var match$3 = caml_call1(Stdlib_Stack[8], state[3]);
        if(! match$3) return;
        var
         tabs = match$3[1][1],
         add_tab =
           function(n, ls){
            if(! ls) return [0, n, 0];
            var l = ls[2], x = ls[1];
            return runtime.caml_lessthan(n, x)
                    ? [0, n, ls]
                    : [0, x, add_tab(n, l)];
           };
        tabs[1] = add_tab(state[6] - state[9] | 0, tabs[1]);
        return;
       case 1:
        caml_call1(Stdlib_Stack[5], state[2]); return;
       case 2:
        caml_call1(Stdlib_Stack[5], state[3]); return;
       case 3:
        var match$4 = caml_call1(Stdlib_Stack[8], state[2]);
        if(! match$4) return pp_output_newline(state);
        var width$0 = match$4[1][2];
        return break_line(state, width$0);
       case 4:
        var _a7_ = state[10] !== (state[6] - state[9] | 0) ? 1 : 0;
        if(! _a7_) return _a7_;
        var match$1 = caml_call1(Stdlib_Queue[6], state[28]);
        if(! match$1) return;
        var match$2 = match$1[1], size = match$2[1], length = match$2[3];
        state[12] = state[12] - length | 0;
        state[9] = state[9] + size | 0;
        return;
       default:
        var match$5 = caml_call1(Stdlib_Stack[5], state[5]);
        if(! match$5) return;
        var tag_name = match$5[1], marker = caml_call1(state[25], tag_name);
        return pp_output_string(state, marker);
     }
    switch(param[0]){
      case 0:
       var s = param[1]; return format_pp_text(state, size$0, s);
      case 1:
       var
        breaks = param[2],
        fits = param[1],
        off = breaks[2],
        before = breaks[1],
        match$6 = caml_call1(Stdlib_Stack[8], state[2]);
       if(! match$6) return;
       var
        match$7 = match$6[1],
        width$1 = match$7[2],
        box_type$0 = match$7[1];
       switch(box_type$0){
         case 0:
          return break_same_line(state, fits);
         case 1:
          return break_new_line(state, breaks, width$1);
         case 2:
          return break_new_line(state, breaks, width$1);
         case 3:
          return state[9] < (size$0 + caml_ml_string_length(before) | 0)
                  ? break_new_line(state, breaks, width$1)
                  : break_same_line(state, fits);
         case 4:
          return state[11]
                  ? break_same_line(state, fits)
                  : state
                     [9]
                    < (size$0 + caml_ml_string_length(before) | 0)
                    ? break_new_line(state, breaks, width$1)
                    : ((state
                       [6]
                      - width$1
                      | 0)
                      + off
                      | 0)
                      < state[10]
                      ? break_new_line(state, breaks, width$1)
                      : break_same_line(state, fits);
         default: return break_same_line(state, fits);
       }
      case 2:
       var
        off$0 = param[2],
        n = param[1],
        insertion_point = state[6] - state[9] | 0,
        match$8 = caml_call1(Stdlib_Stack[8], state[3]);
       if(! match$8) return;
       var tabs$0 = match$8[1][1], match$9 = tabs$0[1];
       if(match$9){
        var first = match$9[1], param$0 = tabs$0[1];
        for(;;){
         if(param$0){
          var tail = param$0[2], head = param$0[1];
          if(insertion_point > head){var param$0 = tail; continue;}
          var _a8_ = head;
         }
         else
          var _a8_ = first;
         var tab = _a8_;
         break;
        }
       }
       else
        var tab = insertion_point;
       var offset = tab - insertion_point | 0;
       return 0 <= offset
               ? break_same_line(state, [0, cst$0, offset + n | 0, cst])
               : break_new_line
                 (state, [0, cst$2, tab + off$0 | 0, cst$1], state[6]);
      case 3:
       var
        ty = param[2],
        off$1 = param[1],
        insertion_point$0 = state[6] - state[9] | 0;
       if(state[8] < insertion_point$0){
        var match = caml_call1(Stdlib_Stack[8], state[2]);
        if(match){
         var match$0 = match[1], width = match$0[2], box_type = match$0[1];
         if(state[9] < width && 3 >= box_type - 1 >>> 0)
          break_line(state, width);
        }
        else
         pp_output_newline(state);
       }
       var
        width$2 = state[9] - off$1 | 0,
        box_type$1 = 1 === ty ? 1 : state[9] < size$0 ? ty : 5;
       return caml_call2(Stdlib_Stack[3], [0, box_type$1, width$2], state[2]);
      case 4:
       var tbox = param[1];
       return caml_call2(Stdlib_Stack[3], tbox, state[3]);
      default:
       var
        tag_name$0 = param[1],
        marker$0 = caml_call1(state[24], tag_name$0);
       pp_output_string(state, marker$0);
       return caml_call2(Stdlib_Stack[3], tag_name$0, state[5]);
    }
   }
   function advance_left(state){
    for(;;){
     var match = caml_call1(Stdlib_Queue[9], state[28]);
     if(! match) return 0;
     var
      match$0 = match[1],
      size = match$0[1],
      length = match$0[3],
      token = match$0[2],
      pending_count = state[13] - state[12] | 0,
      _a5_ = 0 <= size ? 1 : 0,
      _a6_ = _a5_ || (state[9] <= pending_count ? 1 : 0);
     if(! _a6_) return _a6_;
     caml_call1(Stdlib_Queue[5], state[28]);
     var size$0 = 0 <= size ? size : pp_infinity;
     format_pp_token(state, size$0, token);
     state[12] = length + state[12] | 0;
    }
   }
   function enqueue_advance(state, tok){
    pp_enqueue(state, tok);
    return advance_left(state);
   }
   function enqueue_string_as(state, size, s){
    return enqueue_advance(state, [0, size, [0, s], size]);
   }
   function initialize_scan_stack(stack){
    caml_call1(Stdlib_Stack[9], stack);
    var queue_elem = [0, unknown, _b_, 0];
    return caml_call2(Stdlib_Stack[3], [0, -1, queue_elem], stack);
   }
   function set_size(state, ty){
    var match = caml_call1(Stdlib_Stack[8], state[1]);
    if(! match) return;
    var
     match$0 = match[1],
     queue_elem = match$0[2],
     left_total = match$0[1],
     size = queue_elem[1];
    if(left_total < state[12]) return initialize_scan_stack(state[1]);
    var _a4_ = queue_elem[2];
    if(typeof _a4_ !== "number")
     switch(_a4_[0]){
       case 3:
        if(1 - ty){
         queue_elem[1] = state[13] + size | 0;
         caml_call1(Stdlib_Stack[5], state[1]);
        }
        return;
       case 1:
       case 2:
        if(ty){
         queue_elem[1] = state[13] + size | 0;
         caml_call1(Stdlib_Stack[5], state[1]);
        }
        return;
     }
    return;
   }
   function scan_push(state, b, token){
    pp_enqueue(state, token);
    if(b) set_size(state, 1);
    var elem = [0, state[13], token];
    return caml_call2(Stdlib_Stack[3], elem, state[1]);
   }
   function pp_open_box_gen(state, indent, br_ty){
    state[14] = state[14] + 1 | 0;
    if(state[14] < state[15]){
     var size = - state[13] | 0, elem = [0, size, [3, indent, br_ty], 0];
     return scan_push(state, 0, elem);
    }
    var _a3_ = state[14] === state[15] ? 1 : 0;
    if(! _a3_) return _a3_;
    var s = state[16];
    return enqueue_string_as(state, caml_ml_string_length(s), s);
   }
   function pp_close_box(state, param){
    var _a1_ = 1 < state[14] ? 1 : 0;
    if(_a1_){
     if(state[14] < state[15]){
      pp_enqueue(state, [0, zero, 1, 0]);
      set_size(state, 1);
      set_size(state, 0);
     }
     state[14] = state[14] - 1 | 0;
     var _a2_ = 0;
    }
    else
     var _a2_ = _a1_;
    return _a2_;
   }
   function pp_open_stag(state, tag_name){
    if(state[22]){
     caml_call2(Stdlib_Stack[3], tag_name, state[4]);
     caml_call1(state[26], tag_name);
    }
    var _a0_ = state[23];
    if(! _a0_) return _a0_;
    var token = [5, tag_name];
    return pp_enqueue(state, [0, zero, token, 0]);
   }
   function pp_close_stag(state, param){
    if(state[23]) pp_enqueue(state, [0, zero, 5, 0]);
    var _aY_ = state[22];
    if(_aY_){
     var match = caml_call1(Stdlib_Stack[5], state[4]);
     if(match){
      var tag_name = match[1];
      return caml_call1(state[27], tag_name);
     }
     var _aZ_ = 0;
    }
    else
     var _aZ_ = _aY_;
    return _aZ_;
   }
   function pp_set_print_tags(state, b){state[22] = b; return 0;}
   function pp_set_mark_tags(state, b){state[23] = b; return 0;}
   function pp_get_print_tags(state, param){return state[22];}
   function pp_get_mark_tags(state, param){return state[23];}
   function pp_set_tags(state, b){
    pp_set_print_tags(state, b);
    return pp_set_mark_tags(state, b);
   }
   function pp_get_formatter_stag_function(state, param){
    return [0, state[24], state[25], state[26], state[27]];
   }
   function pp_set_formatter_stag_function(state, param){
    var pct = param[4], pot = param[3], mct = param[2], mot = param[1];
    state[24] = mot;
    state[25] = mct;
    state[26] = pot;
    state[27] = pct;
    return 0;
   }
   function pp_rinit(state){
    state[12] = 1;
    state[13] = 1;
    caml_call1(Stdlib_Queue[11], state[28]);
    initialize_scan_stack(state[1]);
    caml_call1(Stdlib_Stack[9], state[2]);
    caml_call1(Stdlib_Stack[9], state[3]);
    caml_call1(Stdlib_Stack[9], state[4]);
    caml_call1(Stdlib_Stack[9], state[5]);
    state[10] = 0;
    state[14] = 0;
    state[9] = state[6];
    return pp_open_box_gen(state, 0, 3);
   }
   function pp_flush_queue(state, end_with_newline){
    caml_call2
     (Stdlib_Stack[13],
      function(param){return pp_close_stag(state, 0);},
      state[4]);
    for(;;){
     if(1 >= state[14]){
      state[13] = pp_infinity;
      advance_left(state);
      if(end_with_newline) pp_output_newline(state);
      return pp_rinit(state);
     }
     pp_close_box(state, 0);
    }
   }
   function pp_print_as_size(state, size, s){
    var _aX_ = state[14] < state[15] ? 1 : 0;
    return _aX_ ? enqueue_string_as(state, size, s) : _aX_;
   }
   function pp_print_as(state, isize, s){
    return pp_print_as_size(state, isize, s);
   }
   function pp_print_string(state, s){
    return pp_print_as(state, caml_ml_string_length(s), s);
   }
   function pp_print_bytes(state, s){
    return pp_print_as
            (state,
             runtime.caml_ml_bytes_length(s),
             caml_call1(Stdlib_Bytes[6], s));
   }
   function pp_print_int(state, i){
    return pp_print_string(state, caml_call1(Stdlib_Int[12], i));
   }
   function pp_print_float(state, f){
    return pp_print_string(state, caml_call1(Stdlib[35], f));
   }
   function pp_print_bool(state, b){
    return pp_print_string(state, caml_call1(Stdlib[30], b));
   }
   function pp_print_char(state, c){
    return pp_print_as(state, 1, caml_call2(Stdlib_String[1], 1, c));
   }
   function pp_open_hbox(state, param){return pp_open_box_gen(state, 0, 0);}
   function pp_open_vbox(state, indent){
    return pp_open_box_gen(state, indent, 1);
   }
   function pp_open_hvbox(state, indent){
    return pp_open_box_gen(state, indent, 2);
   }
   function pp_open_hovbox(state, indent){
    return pp_open_box_gen(state, indent, 3);
   }
   function pp_open_box(state, indent){
    return pp_open_box_gen(state, indent, 4);
   }
   function pp_print_newline(state, param){
    pp_flush_queue(state, 1);
    return caml_call1(state[18], 0);
   }
   function pp_print_flush(state, param){
    pp_flush_queue(state, 0);
    return caml_call1(state[18], 0);
   }
   function pp_force_newline(state, param){
    var _aW_ = state[14] < state[15] ? 1 : 0;
    return _aW_ ? enqueue_advance(state, [0, zero, 3, 0]) : _aW_;
   }
   function pp_print_if_newline(state, param){
    var _aV_ = state[14] < state[15] ? 1 : 0;
    return _aV_ ? enqueue_advance(state, [0, zero, 4, 0]) : _aV_;
   }
   function pp_print_custom_break(state, fits, breaks){
    var
     after = fits[3],
     width = fits[2],
     before = fits[1],
     _aU_ = state[14] < state[15] ? 1 : 0;
    if(! _aU_) return _aU_;
    var
     size = - state[13] | 0,
     token = [1, fits, breaks],
     length =
       (caml_ml_string_length(before) + width | 0)
       + caml_ml_string_length(after)
       | 0,
     elem = [0, size, token, length];
    return scan_push(state, 1, elem);
   }
   function pp_print_break(state, width, offset){
    return pp_print_custom_break
            (state, [0, cst$6, width, cst$5], [0, cst$4, offset, cst$3]);
   }
   function pp_print_space(state, param){return pp_print_break(state, 1, 0);}
   function pp_print_cut(state, param){return pp_print_break(state, 0, 0);}
   function pp_open_tbox(state, param){
    state[14] = state[14] + 1 | 0;
    var _aT_ = state[14] < state[15] ? 1 : 0;
    if(! _aT_) return _aT_;
    var elem = [0, zero, [4, [0, [0, 0]]], 0];
    return enqueue_advance(state, elem);
   }
   function pp_close_tbox(state, param){
    var _aQ_ = 1 < state[14] ? 1 : 0;
    if(_aQ_){
     var _aR_ = state[14] < state[15] ? 1 : 0;
     if(_aR_){
      var elem = [0, zero, 2, 0];
      enqueue_advance(state, elem);
      state[14] = state[14] - 1 | 0;
      var _aS_ = 0;
     }
     else
      var _aS_ = _aR_;
    }
    else
     var _aS_ = _aQ_;
    return _aS_;
   }
   function pp_print_tbreak(state, width, offset){
    var _aP_ = state[14] < state[15] ? 1 : 0;
    if(! _aP_) return _aP_;
    var size = - state[13] | 0, elem = [0, size, [2, width, offset], width];
    return scan_push(state, 1, elem);
   }
   function pp_print_tab(state, param){return pp_print_tbreak(state, 0, 0);}
   function pp_set_tab(state, param){
    var _aO_ = state[14] < state[15] ? 1 : 0;
    if(! _aO_) return _aO_;
    var elem = [0, zero, 0, 0];
    return enqueue_advance(state, elem);
   }
   function pp_set_max_boxes(state, n){
    var _aM_ = 1 < n ? 1 : 0, _aN_ = _aM_ ? (state[15] = n, 0) : _aM_;
    return _aN_;
   }
   function pp_get_max_boxes(state, param){return state[15];}
   function pp_over_max_boxes(state, param){return state[14] === state[15] ? 1 : 0;
   }
   function pp_set_ellipsis_text(state, s){state[16] = s; return 0;}
   function pp_get_ellipsis_text(state, param){return state[16];}
   function pp_limit(n){return n < 1000000010 ? n : 1000000009;}
   function pp_set_max_indent(state, n$0){
    var _aL_ = 1 < n$0 ? 1 : 0;
    if(! _aL_) return _aL_;
    var n$1 = state[6] - n$0 | 0, _aK_ = 1 <= n$1 ? 1 : 0;
    if(! _aK_) return _aK_;
    var n = pp_limit(n$1);
    state[7] = n;
    state[8] = state[6] - state[7] | 0;
    return pp_rinit(state);
   }
   function pp_get_max_indent(state, param){return state[8];}
   function pp_set_margin(state, n){
    var _aI_ = 1 <= n ? 1 : 0;
    if(! _aI_) return _aI_;
    var n$0 = pp_limit(n);
    state[6] = n$0;
    if(state[8] <= state[6])
     var new_max_indent = state[8];
    else
     var
      _aJ_ =
        caml_call2(Stdlib_Int[11], state[6] - state[7] | 0, state[6] / 2 | 0),
      new_max_indent = caml_call2(Stdlib_Int[11], _aJ_, 1);
    return pp_set_max_indent(state, new_max_indent);
   }
   function validate_geometry(param){
    var margin = param[2], max_indent = param[1];
    return 2 <= max_indent ? margin <= max_indent ? _c_ : _d_ : _e_;
   }
   function check_geometry(geometry){
    return 0 === validate_geometry(geometry)[0] ? 1 : 0;
   }
   function pp_get_margin(state, param){return state[6];}
   function pp_set_full_geometry(state, param){
    var margin = param[2], max_indent = param[1];
    pp_set_margin(state, margin);
    pp_set_max_indent(state, max_indent);
    return 0;
   }
   function pp_set_geometry(state, max_indent, margin){
    var
     geometry = [0, max_indent, margin],
     match = validate_geometry(geometry);
    if(0 === match[0]) return pp_set_full_geometry(state, geometry);
    var
     msg = match[1],
     _aH_ = caml_call2(Stdlib[28], cst_Format_pp_set_geometry, msg);
    throw caml_maybe_attach_backtrace([0, Stdlib[6], _aH_], 1);
   }
   function pp_safe_set_geometry(state, max_indent, margin){
    var geometry = [0, max_indent, margin];
    return 0 === validate_geometry(geometry)[0]
            ? pp_set_full_geometry(state, geometry)
            : 0;
   }
   function pp_get_geometry(state, param){return [0, state[8], state[6]];}
   function pp_update_geometry(state, update){
    var geometry = pp_get_geometry(state, 0);
    return pp_set_full_geometry(state, caml_call1(update, geometry));
   }
   function pp_set_formatter_out_functions(state, param){
    var j = param[5], i = param[4], h = param[3], g = param[2], f = param[1];
    state[17] = f;
    state[18] = g;
    state[19] = h;
    state[20] = i;
    state[21] = j;
    return 0;
   }
   function pp_get_formatter_out_functions(state, param){
    return [0, state[17], state[18], state[19], state[20], state[21]];
   }
   function pp_set_formatter_output_functi(state, f, g){state[17] = f; state[18] = g; return 0;
   }
   function pp_get_formatter_output_functi(state, param){return [0, state[17], state[18]];
   }
   function display_newline(state, param){
    return caml_call3(state[17], cst$7, 0, 1);
   }
   var blank_line = caml_call2(Stdlib_String[1], 80, 32), _f_ = [3, 0, 3];
   function display_blanks(state, n){
    var n$0 = n;
    for(;;){
     var _aG_ = 0 < n$0 ? 1 : 0;
     if(! _aG_) return _aG_;
     if(80 >= n$0) return caml_call3(state[17], blank_line, 0, n$0);
     caml_call3(state[17], blank_line, 0, 80);
     var n$1 = n$0 - 80 | 0, n$0 = n$1;
    }
   }
   function pp_set_formatter_out_channel(state, oc){
    state[17] = caml_call1(Stdlib[69], oc);
    state[18] = function(param){return caml_call1(Stdlib[63], oc);};
    state[19] = function(_aF_){return display_newline(state, _aF_);};
    state[20] = function(_aE_){return display_blanks(state, _aE_);};
    state[21] = function(_aD_){return display_blanks(state, _aD_);};
    return 0;
   }
   function default_pp_mark_open_tag(param){
    if(param[1] !== String_tag) return cst$10;
    var s = param[2], _aC_ = caml_call2(Stdlib[28], s, cst$8);
    return caml_call2(Stdlib[28], cst$9, _aC_);
   }
   function default_pp_mark_close_tag(param){
    if(param[1] !== String_tag) return cst$13;
    var s = param[2], _aB_ = caml_call2(Stdlib[28], s, cst$11);
    return caml_call2(Stdlib[28], cst$12, _aB_);
   }
   function default_pp_print_open_tag(_aA_){return 0;}
   function default_pp_print_close_tag(_az_){return 0;}
   function pp_make_formatter(f, g, h, i, j){
    var
     pp_queue = caml_call1(Stdlib_Queue[2], 0),
     sys_tok = [0, unknown, _f_, 0];
    caml_call2(Stdlib_Queue[3], sys_tok, pp_queue);
    var scan_stack = caml_call1(Stdlib_Stack[2], 0);
    initialize_scan_stack(scan_stack);
    caml_call2(Stdlib_Stack[3], [0, 1, sys_tok], scan_stack);
    var
     pp_margin = 78,
     _av_ = Stdlib[19],
     _aw_ = caml_call1(Stdlib_Stack[2], 0),
     _ax_ = caml_call1(Stdlib_Stack[2], 0),
     _ay_ = caml_call1(Stdlib_Stack[2], 0);
    return [0,
            scan_stack,
            caml_call1(Stdlib_Stack[2], 0),
            _ay_,
            _ax_,
            _aw_,
            pp_margin,
            10,
            68,
            pp_margin,
            0,
            1,
            1,
            1,
            1,
            _av_,
            cst$14,
            f,
            g,
            h,
            i,
            j,
            0,
            0,
            default_pp_mark_open_tag,
            default_pp_mark_close_tag,
            default_pp_print_open_tag,
            default_pp_print_close_tag,
            pp_queue];
   }
   function formatter_of_out_functions(out_funs){
    return pp_make_formatter
            (out_funs[1], out_funs[2], out_funs[3], out_funs[4], out_funs[5]);
   }
   function make_formatter(output, flush){
    var
     ppf =
       pp_make_formatter
        (output,
         flush,
         function(_au_){return 0;},
         function(_at_){return 0;},
         function(_as_){return 0;});
    ppf[19] = function(_ar_){return display_newline(ppf, _ar_);};
    ppf[20] = function(_aq_){return display_blanks(ppf, _aq_);};
    ppf[21] = function(_ap_){return display_blanks(ppf, _ap_);};
    return ppf;
   }
   function formatter_of_out_channel(oc){
    return make_formatter
            (caml_call1(Stdlib[69], oc),
             function(param){return caml_call1(Stdlib[63], oc);});
   }
   function formatter_of_buffer(b){
    return make_formatter
            (caml_call1(Stdlib_Buffer[18], b), function(_ao_){return 0;});
   }
   var pp_buffer_size = 512;
   function pp_make_buffer(param){
    return caml_call1(Stdlib_Buffer[1], pp_buffer_size);
   }
   var
    stdbuf = pp_make_buffer(0),
    std_formatter = formatter_of_out_channel(Stdlib[39]),
    err_formatter = formatter_of_out_channel(Stdlib[40]),
    str_formatter = formatter_of_buffer(stdbuf),
    stdbuf_key = caml_call2(Stdlib_Domain[10][1], 0, pp_make_buffer);
   caml_call2(Stdlib_Domain[10][3], stdbuf_key, stdbuf);
   var
    str_formatter_key =
      caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
         return formatter_of_buffer
                 (caml_call1(Stdlib_Domain[10][2], stdbuf_key));
        });
   caml_call2(Stdlib_Domain[10][3], str_formatter_key, str_formatter);
   function buffered_out_string(key, str, ofs, len){
    var _an_ = caml_call1(Stdlib_Domain[10][2], key);
    return caml_call4(Stdlib_Buffer[18], _an_, str, ofs, len);
   }
   function buffered_out_flush(oc, key, param){
    var
     buf = caml_call1(Stdlib_Domain[10][2], key),
     len = caml_call1(Stdlib_Buffer[7], buf),
     str = caml_call1(Stdlib_Buffer[2], buf);
    caml_call4(Stdlib[69], oc, str, 0, len);
    caml_call1(Stdlib[63], oc);
    return caml_call1(Stdlib_Buffer[8], buf);
   }
   var
    std_buf_key =
      caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){return caml_call1(Stdlib_Buffer[1], pp_buffer_size);}),
    err_buf_key =
      caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){return caml_call1(Stdlib_Buffer[1], pp_buffer_size);}),
    std_formatter_key =
      caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
         var
          _ab_ = Stdlib[39],
          ppf =
            pp_make_formatter
             (function(_ak_, _al_, _am_){
               return buffered_out_string(std_buf_key, _ak_, _al_, _am_);
              },
              function(_aj_){
               return buffered_out_flush(_ab_, std_buf_key, _aj_);
              },
              function(_ai_){return 0;},
              function(_ah_){return 0;},
              function(_ag_){return 0;});
         ppf[19] = function(_af_){return display_newline(ppf, _af_);};
         ppf[20] = function(_ae_){return display_blanks(ppf, _ae_);};
         ppf[21] = function(_ad_){return display_blanks(ppf, _ad_);};
         caml_call1
          (Stdlib_Domain[6],
           function(_ac_){return pp_print_flush(ppf, _ac_);});
         return ppf;
        });
   caml_call2(Stdlib_Domain[10][3], std_formatter_key, std_formatter);
   var
    err_formatter_key =
      caml_call2
       (Stdlib_Domain[10][1],
        0,
        function(param){
         var
          _R_ = Stdlib[40],
          ppf =
            pp_make_formatter
             (function(___, _$_, _aa_){
               return buffered_out_string(err_buf_key, ___, _$_, _aa_);
              },
              function(_Z_){return buffered_out_flush(_R_, err_buf_key, _Z_);},
              function(_Y_){return 0;},
              function(_X_){return 0;},
              function(_W_){return 0;});
         ppf[19] = function(_V_){return display_newline(ppf, _V_);};
         ppf[20] = function(_U_){return display_blanks(ppf, _U_);};
         ppf[21] = function(_T_){return display_blanks(ppf, _T_);};
         caml_call1
          (Stdlib_Domain[6], function(_S_){return pp_print_flush(ppf, _S_);});
         return ppf;
        });
   caml_call2(Stdlib_Domain[10][3], err_formatter_key, err_formatter);
   function get_std_formatter(param){
    return caml_call1(Stdlib_Domain[10][2], std_formatter_key);
   }
   function get_err_formatter(param){
    return caml_call1(Stdlib_Domain[10][2], err_formatter_key);
   }
   function get_str_formatter(param){
    return caml_call1(Stdlib_Domain[10][2], str_formatter_key);
   }
   function get_stdbuf(param){
    return caml_call1(Stdlib_Domain[10][2], stdbuf_key);
   }
   function flush_buffer_formatter(buf, ppf){
    pp_flush_queue(ppf, 0);
    var s = caml_call1(Stdlib_Buffer[2], buf);
    caml_call1(Stdlib_Buffer[9], buf);
    return s;
   }
   function flush_str_formatter(param){
    var
     stdbuf = caml_call1(Stdlib_Domain[10][2], stdbuf_key),
     str_formatter = caml_call1(Stdlib_Domain[10][2], str_formatter_key);
    return flush_buffer_formatter(stdbuf, str_formatter);
   }
   function make_synchronized_formatter(output, flush){
    return caml_call2
            (Stdlib_Domain[10][1],
             0,
             function(param){
              var
               buf = caml_call1(Stdlib_Buffer[1], pp_buffer_size),
               output$0 = caml_call1(Stdlib_Buffer[18], buf);
              function flush$0(param){
               var _Q_ = caml_call1(Stdlib_Buffer[7], buf);
               caml_call3(output, caml_call1(Stdlib_Buffer[2], buf), 0, _Q_);
               caml_call1(Stdlib_Buffer[8], buf);
               return caml_call1(flush, 0);
              }
              return make_formatter(output$0, flush$0);
             });
   }
   function synchronized_formatter_of_out_(oc){
    return make_synchronized_formatter
            (caml_call1(Stdlib[69], oc),
             function(param){return caml_call1(Stdlib[63], oc);});
   }
   function make_symbolic_output_buffer(param){return [0, 0];}
   function clear_symbolic_output_buffer(sob){sob[1] = 0; return 0;}
   function get_symbolic_output_buffer(sob){
    return caml_call1(Stdlib_List[10], sob[1]);
   }
   function flush_symbolic_output_buffer(sob){
    var items = get_symbolic_output_buffer(sob);
    clear_symbolic_output_buffer(sob);
    return items;
   }
   function add_symbolic_output_item(sob, item){sob[1] = [0, item, sob[1]]; return 0;
   }
   function formatter_of_symbolic_output_b(sob){
    function f(s, i, n){
     return add_symbolic_output_item
             (sob, [0, caml_call3(Stdlib_String[16], s, i, n)]);
    }
    function g(_P_){return add_symbolic_output_item(sob, 0);}
    function h(_O_){return add_symbolic_output_item(sob, 1);}
    function i(n){return add_symbolic_output_item(sob, [1, n]);}
    function j(n){return add_symbolic_output_item(sob, [2, n]);}
    return pp_make_formatter(f, g, h, i, j);
   }
   function open_hbox(v){
    return pp_open_hbox
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function open_vbox(v){
    return pp_open_vbox
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function open_hvbox(v){
    return pp_open_hvbox
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function open_hovbox(v){
    return pp_open_hovbox
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function open_box(v){
    return pp_open_box(caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function close_box(v){
    return pp_close_box
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function open_stag(v){
    return pp_open_stag
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function close_stag(v){
    return pp_close_stag
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_as(v, w){
    return pp_print_as
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v, w);
   }
   function print_string(v){
    return pp_print_string
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_bytes(v){
    return pp_print_bytes
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_int(v){
    return pp_print_int
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_float(v){
    return pp_print_float
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_char(v){
    return pp_print_char
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_bool(v){
    return pp_print_bool
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_break(v, w){
    return pp_print_break
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v, w);
   }
   function print_cut(v){
    return pp_print_cut
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_space(v){
    return pp_print_space
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function force_newline(v){
    return pp_force_newline
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_flush(v){
    return pp_print_flush
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_newline(v){
    return pp_print_newline
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_if_newline(v){
    return pp_print_if_newline
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function open_tbox(v){
    return pp_open_tbox
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function close_tbox(v){
    return pp_close_tbox
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_tbreak(v, w){
    return pp_print_tbreak
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v, w);
   }
   function set_tab(v){
    return pp_set_tab(caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function print_tab(v){
    return pp_print_tab
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function set_margin(v){
    return pp_set_margin
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_margin(v){
    return caml_call1(Stdlib_Domain[10][2], std_formatter_key)[6];
   }
   function set_max_indent(v){
    return pp_set_max_indent
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_max_indent(v){
    return caml_call1(Stdlib_Domain[10][2], std_formatter_key)[8];
   }
   function set_geometry(max_indent, margin){
    return pp_set_geometry
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key),
             max_indent,
             margin);
   }
   function safe_set_geometry(max_indent, margin){
    return pp_safe_set_geometry
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key),
             max_indent,
             margin);
   }
   function get_geometry(v){
    return pp_get_geometry
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function update_geometry(v){
    return pp_update_geometry
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function set_max_boxes(v){
    return pp_set_max_boxes
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_max_boxes(v){
    return caml_call1(Stdlib_Domain[10][2], std_formatter_key)[15];
   }
   function over_max_boxes(v){
    return pp_over_max_boxes
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function set_ellipsis_text(v){
    return pp_set_ellipsis_text
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_ellipsis_text(v){
    return caml_call1(Stdlib_Domain[10][2], std_formatter_key)[16];
   }
   function set_formatter_out_channel(v){
    return pp_set_formatter_out_channel
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function set_formatter_out_functions(v){
    return pp_set_formatter_out_functions
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_formatter_out_functions(v){
    return pp_get_formatter_out_functions
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function set_formatter_output_functions(v, w){
    return pp_set_formatter_output_functi
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v, w);
   }
   function get_formatter_output_functions(v){
    return pp_get_formatter_output_functi
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function set_formatter_stag_functions(v){
    return pp_set_formatter_stag_function
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_formatter_stag_functions(v){
    return pp_get_formatter_stag_function
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function set_print_tags(v){
    return pp_set_print_tags
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_print_tags(v){
    return caml_call1(Stdlib_Domain[10][2], std_formatter_key)[22];
   }
   function set_mark_tags(v){
    return pp_set_mark_tags
            (caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function get_mark_tags(v){
    return caml_call1(Stdlib_Domain[10][2], std_formatter_key)[23];
   }
   function set_tags(v){
    return pp_set_tags(caml_call1(Stdlib_Domain[10][2], std_formatter_key), v);
   }
   function pp_print_iter(opt, iter, pp_v, ppf, v){
    if(opt) var sth = opt[1], pp_sep = sth; else var pp_sep = pp_print_cut;
    var is_first = [0, 1];
    function pp_v$0(v){
     if(is_first[1]) is_first[1] = 0; else caml_call2(pp_sep, ppf, 0);
     return caml_call2(pp_v, ppf, v);
    }
    return caml_call2(iter, pp_v$0, v);
   }
   function pp_print_list(opt, pp_v, ppf, v){
    if(opt) var sth = opt[1], pp_sep = sth; else var pp_sep = pp_print_cut;
    return pp_print_iter([0, pp_sep], Stdlib_List[18], pp_v, ppf, v);
   }
   function pp_print_array(opt, pp_v, ppf, v){
    if(opt) var sth = opt[1], pp_sep = sth; else var pp_sep = pp_print_cut;
    return pp_print_iter([0, pp_sep], Stdlib_Array[11], pp_v, ppf, v);
   }
   function pp_print_seq(opt, pp_v, ppf, seq){
    if(opt) var sth = opt[1], pp_sep = sth; else var pp_sep = pp_print_cut;
    return pp_print_iter([0, pp_sep], Stdlib_Seq[4], pp_v, ppf, seq);
   }
   function pp_print_text(ppf, s){
    var len = caml_ml_string_length(s), left = [0, 0], right = [0, 0];
    function flush(param){
     pp_print_string
      (ppf, caml_call3(Stdlib_String[16], s, left[1], right[1] - left[1] | 0));
     right[1]++;
     left[1] = right[1];
     return 0;
    }
    for(;;){
     if(right[1] === len){
      var _N_ = left[1] !== len ? 1 : 0;
      return _N_ ? flush(0) : _N_;
     }
     var match = runtime.caml_string_get(s, right[1]);
     if(10 === match){
      flush(0);
      pp_force_newline(ppf, 0);
     }
     else if(32 === match){flush(0); pp_print_space(ppf, 0);} else right[1]++;
    }
   }
   function pp_print_option(opt, pp_v, ppf, param){
    if(opt)
     var sth = opt[1], none = sth;
    else
     var none = function(param, _M_){return 0;};
    if(! param) return caml_call2(none, ppf, 0);
    var v = param[1];
    return caml_call2(pp_v, ppf, v);
   }
   function pp_print_result(ok, error, ppf, param){
    if(0 === param[0]){var v = param[1]; return caml_call2(ok, ppf, v);}
    var e = param[1];
    return caml_call2(error, ppf, e);
   }
   function pp_print_either(left, right, ppf, param){
    if(0 === param[0]){var l = param[1]; return caml_call2(left, ppf, l);}
    var r = param[1];
    return caml_call2(right, ppf, r);
   }
   function compute_tag(output, tag_acc){
    var
     buf = caml_call1(Stdlib_Buffer[1], 16),
     ppf = formatter_of_buffer(buf);
    caml_call2(output, ppf, tag_acc);
    pp_print_flush(ppf, 0);
    var len = caml_call1(Stdlib_Buffer[7], buf);
    return 2 <= len
            ? caml_call3(Stdlib_Buffer[4], buf, 1, len - 2 | 0)
            : caml_call1(Stdlib_Buffer[2], buf);
   }
   function output_formatting_lit(ppf, fmting_lit){
    if(typeof fmting_lit === "number")
     switch(fmting_lit){
       case 0:
        return pp_close_box(ppf, 0);
       case 1:
        return pp_close_stag(ppf, 0);
       case 2:
        return pp_print_flush(ppf, 0);
       case 3:
        return pp_force_newline(ppf, 0);
       case 4:
        return pp_print_newline(ppf, 0);
       case 5:
        return pp_print_char(ppf, 64);
       default: return pp_print_char(ppf, 37);
     }
    switch(fmting_lit[0]){
      case 0:
       var offset = fmting_lit[3], width = fmting_lit[2];
       return pp_print_break(ppf, width, offset);
      case 1:
       return 0;
      default:
       var c = fmting_lit[1];
       pp_print_char(ppf, 64);
       return pp_print_char(ppf, c);
    }
   }
   function output_acc(ppf, acc){
    if(typeof acc === "number") return 0;
    a:
    {
     b:
     {
      c:
      {
       switch(acc[0]){
         case 0:
          var f = acc[2], p = acc[1];
          output_acc(ppf, p);
          return output_formatting_lit(ppf, f);
         case 1:
          var match = acc[2], p$0 = acc[1];
          if(0 === match[0]){
           var acc$0 = match[1];
           output_acc(ppf, p$0);
           return pp_open_stag
                   (ppf, [0, String_tag, compute_tag(output_acc, acc$0)]);
          }
          var acc$1 = match[1];
          output_acc(ppf, p$0);
          var
           _D_ = compute_tag(output_acc, acc$1),
           match$0 = caml_call1(CamlinternalFormat[20], _D_),
           bty = match$0[2],
           indent = match$0[1];
          return pp_open_box_gen(ppf, indent, bty);
         case 2:
          var _E_ = acc[1];
          if(typeof _E_ !== "number" && 0 === _E_[0]){
           var _F_ = _E_[2];
           if(typeof _F_ !== "number" && 1 === _F_[0]){
            var s$0 = acc[2], size = _F_[2], p$2 = _E_[1];
            break b;
           }
          }
          var s = acc[2], p$1 = _E_;
          break a;
         case 3:
          var _G_ = acc[1];
          if(typeof _G_ !== "number" && 0 === _G_[0]){
           var _H_ = _G_[2];
           if(typeof _H_ !== "number" && 1 === _H_[0]){
            var c$0 = acc[2], size$0 = _H_[2], p$4 = _G_[1];
            break;
           }
          }
          var c = acc[2], p$3 = _G_;
          break c;
         case 4:
          var _I_ = acc[1];
          if(typeof _I_ !== "number" && 0 === _I_[0]){
           var _J_ = _I_[2];
           if(typeof _J_ !== "number" && 1 === _J_[0]){
            var s$0 = acc[2], size = _J_[2], p$2 = _I_[1];
            break b;
           }
          }
          var s = acc[2], p$1 = _I_;
          break a;
         case 5:
          var _K_ = acc[1];
          if(typeof _K_ !== "number" && 0 === _K_[0]){
           var _L_ = _K_[2];
           if(typeof _L_ !== "number" && 1 === _L_[0]){
            var c$0 = acc[2], size$0 = _L_[2], p$4 = _K_[1];
            break;
           }
          }
          var c = acc[2], p$3 = _K_;
          break c;
         case 6:
          var f$0 = acc[2], p$5 = acc[1];
          output_acc(ppf, p$5);
          return caml_call1(f$0, ppf);
         case 7:
          var p$6 = acc[1];
          output_acc(ppf, p$6);
          return pp_print_flush(ppf, 0);
         default:
          var msg = acc[2], p$7 = acc[1];
          output_acc(ppf, p$7);
          return caml_call1(Stdlib[1], msg);
       }
       output_acc(ppf, p$4);
       return pp_print_as_size
               (ppf, size$0, caml_call2(Stdlib_String[1], 1, c$0));
      }
      output_acc(ppf, p$3);
      return pp_print_char(ppf, c);
     }
     output_acc(ppf, p$2);
     return pp_print_as_size(ppf, size, s$0);
    }
    output_acc(ppf, p$1);
    return pp_print_string(ppf, s);
   }
   function strput_acc(ppf, acc){
    if(typeof acc === "number") return 0;
    a:
    {
     b:
     {
      c:
      {
       switch(acc[0]){
         case 0:
          var f = acc[2], p = acc[1];
          strput_acc(ppf, p);
          return output_formatting_lit(ppf, f);
         case 1:
          var match = acc[2], p$0 = acc[1];
          if(0 === match[0]){
           var acc$0 = match[1];
           strput_acc(ppf, p$0);
           return pp_open_stag
                   (ppf, [0, String_tag, compute_tag(strput_acc, acc$0)]);
          }
          var acc$1 = match[1];
          strput_acc(ppf, p$0);
          var
           _u_ = compute_tag(strput_acc, acc$1),
           match$0 = caml_call1(CamlinternalFormat[20], _u_),
           bty = match$0[2],
           indent = match$0[1];
          return pp_open_box_gen(ppf, indent, bty);
         case 2:
          var _v_ = acc[1];
          if(typeof _v_ !== "number" && 0 === _v_[0]){
           var _w_ = _v_[2];
           if(typeof _w_ !== "number" && 1 === _w_[0]){
            var s$0 = acc[2], size = _w_[2], p$2 = _v_[1];
            break b;
           }
          }
          var s = acc[2], p$1 = _v_;
          break a;
         case 3:
          var _x_ = acc[1];
          if(typeof _x_ !== "number" && 0 === _x_[0]){
           var _y_ = _x_[2];
           if(typeof _y_ !== "number" && 1 === _y_[0]){
            var c$0 = acc[2], size$0 = _y_[2], p$4 = _x_[1];
            break;
           }
          }
          var c = acc[2], p$3 = _x_;
          break c;
         case 4:
          var _z_ = acc[1];
          if(typeof _z_ !== "number" && 0 === _z_[0]){
           var _A_ = _z_[2];
           if(typeof _A_ !== "number" && 1 === _A_[0]){
            var s$0 = acc[2], size = _A_[2], p$2 = _z_[1];
            break b;
           }
          }
          var s = acc[2], p$1 = _z_;
          break a;
         case 5:
          var _B_ = acc[1];
          if(typeof _B_ !== "number" && 0 === _B_[0]){
           var _C_ = _B_[2];
           if(typeof _C_ !== "number" && 1 === _C_[0]){
            var c$0 = acc[2], size$0 = _C_[2], p$4 = _B_[1];
            break;
           }
          }
          var c = acc[2], p$3 = _B_;
          break c;
         case 6:
          var p$5 = acc[1];
          if(typeof p$5 !== "number" && 0 === p$5[0]){
           var match$1 = p$5[2];
           if(typeof match$1 !== "number" && 1 === match$1[0]){
            var f$1 = acc[2], size$1 = match$1[2], p$6 = p$5[1];
            strput_acc(ppf, p$6);
            return pp_print_as_size(ppf, size$1, caml_call1(f$1, 0));
           }
          }
          var f$0 = acc[2];
          strput_acc(ppf, p$5);
          return pp_print_string(ppf, caml_call1(f$0, 0));
         case 7:
          var p$7 = acc[1];
          strput_acc(ppf, p$7);
          return pp_print_flush(ppf, 0);
         default:
          var msg = acc[2], p$8 = acc[1];
          strput_acc(ppf, p$8);
          return caml_call1(Stdlib[1], msg);
       }
       strput_acc(ppf, p$4);
       return pp_print_as_size
               (ppf, size$0, caml_call2(Stdlib_String[1], 1, c$0));
      }
      strput_acc(ppf, p$3);
      return pp_print_char(ppf, c);
     }
     strput_acc(ppf, p$2);
     return pp_print_as_size(ppf, size, s$0);
    }
    strput_acc(ppf, p$1);
    return pp_print_string(ppf, s);
   }
   function kfprintf(k, ppf, param){
    var fmt = param[1];
    return caml_call3
            (CamlinternalFormat[7],
             function(acc){output_acc(ppf, acc); return caml_call1(k, ppf);},
             0,
             fmt);
   }
   function ikfprintf(k, ppf, param){
    var fmt = param[1];
    return caml_call3(CamlinternalFormat[8], k, ppf, fmt);
   }
   function ifprintf(ppf, param){
    var fmt = param[1];
    return caml_call3(CamlinternalFormat[8], function(_t_){return 0;}, 0, fmt);
   }
   function fprintf(ppf){
    function _q_(_s_){return 0;}
    return function(_r_){return kfprintf(_q_, ppf, _r_);};
   }
   function printf(param){
    var fmt = param[1];
    return caml_call3
            (CamlinternalFormat[7],
             function(acc){
              return output_acc
                      (caml_call1(Stdlib_Domain[10][2], std_formatter_key), acc);
             },
             0,
             fmt);
   }
   function eprintf(param){
    var fmt = param[1];
    return caml_call3
            (CamlinternalFormat[7],
             function(acc){
              return output_acc
                      (caml_call1(Stdlib_Domain[10][2], err_formatter_key), acc);
             },
             0,
             fmt);
   }
   function kdprintf(k, param){
    var fmt = param[1];
    return caml_call3
            (CamlinternalFormat[7],
             function(acc){
              return caml_call1
                      (k, function(ppf){return output_acc(ppf, acc);});
             },
             0,
             fmt);
   }
   function dprintf(fmt){return kdprintf(function(i){return i;}, fmt);}
   function ksprintf(k, param){
    var fmt = param[1], b = pp_make_buffer(0), ppf = formatter_of_buffer(b);
    function k$0(acc){
     strput_acc(ppf, acc);
     return caml_call1(k, flush_buffer_formatter(b, ppf));
    }
    return caml_call3(CamlinternalFormat[7], k$0, 0, fmt);
   }
   function sprintf(fmt){return ksprintf(id, fmt);}
   function kasprintf(k, param){
    var fmt = param[1], b = pp_make_buffer(0), ppf = formatter_of_buffer(b);
    function k$0(acc){
     output_acc(ppf, acc);
     return caml_call1(k, flush_buffer_formatter(b, ppf));
    }
    return caml_call3(CamlinternalFormat[7], k$0, 0, fmt);
   }
   function asprintf(fmt){return kasprintf(id, fmt);}
   function flush_standard_formatters(param){
    pp_print_flush(caml_call1(Stdlib_Domain[10][2], std_formatter_key), 0);
    return pp_print_flush
            (caml_call1(Stdlib_Domain[10][2], err_formatter_key), 0);
   }
   caml_call1(Stdlib[100], flush_standard_formatters);
   caml_call1
    (Stdlib_Domain[5],
     function(param){
      flush_standard_formatters(0);
      var
       fs = pp_get_formatter_out_functions(std_formatter, 0),
       _g_ = Stdlib[39];
      pp_set_formatter_out_functions
       (std_formatter,
        [0,
         function(_n_, _o_, _p_){
          return buffered_out_string(std_buf_key, _n_, _o_, _p_);
         },
         function(_m_){return buffered_out_flush(_g_, std_buf_key, _m_);},
         fs[3],
         fs[4],
         fs[5]]);
      var
       fs$0 = pp_get_formatter_out_functions(err_formatter, 0),
       _h_ = Stdlib[40];
      return pp_set_formatter_out_functions
              (err_formatter,
               [0,
                function(_j_, _k_, _l_){
                 return buffered_out_string(err_buf_key, _j_, _k_, _l_);
                },
                function(_i_){
                 return buffered_out_flush(_h_, err_buf_key, _i_);
                },
                fs$0[3],
                fs$0[4],
                fs$0[5]]);
     });
   var
    Stdlib_Format =
      [0,
       pp_open_box,
       open_box,
       pp_close_box,
       close_box,
       pp_open_hbox,
       open_hbox,
       pp_open_vbox,
       open_vbox,
       pp_open_hvbox,
       open_hvbox,
       pp_open_hovbox,
       open_hovbox,
       pp_print_string,
       print_string,
       pp_print_bytes,
       print_bytes,
       pp_print_as,
       print_as,
       pp_print_int,
       print_int,
       pp_print_float,
       print_float,
       pp_print_char,
       print_char,
       pp_print_bool,
       print_bool,
       pp_print_space,
       print_space,
       pp_print_cut,
       print_cut,
       pp_print_break,
       print_break,
       pp_print_custom_break,
       pp_force_newline,
       force_newline,
       pp_print_if_newline,
       print_if_newline,
       pp_print_flush,
       print_flush,
       pp_print_newline,
       print_newline,
       pp_set_margin,
       set_margin,
       pp_get_margin,
       get_margin,
       pp_set_max_indent,
       set_max_indent,
       pp_get_max_indent,
       get_max_indent,
       check_geometry,
       pp_set_geometry,
       set_geometry,
       pp_safe_set_geometry,
       safe_set_geometry,
       pp_update_geometry,
       update_geometry,
       pp_get_geometry,
       get_geometry,
       pp_set_max_boxes,
       set_max_boxes,
       pp_get_max_boxes,
       get_max_boxes,
       pp_over_max_boxes,
       over_max_boxes,
       pp_open_tbox,
       open_tbox,
       pp_close_tbox,
       close_tbox,
       pp_set_tab,
       set_tab,
       pp_print_tab,
       print_tab,
       pp_print_tbreak,
       print_tbreak,
       pp_set_ellipsis_text,
       set_ellipsis_text,
       pp_get_ellipsis_text,
       get_ellipsis_text,
       String_tag,
       pp_open_stag,
       open_stag,
       pp_close_stag,
       close_stag,
       pp_set_tags,
       set_tags,
       pp_set_print_tags,
       set_print_tags,
       pp_set_mark_tags,
       set_mark_tags,
       pp_get_print_tags,
       get_print_tags,
       pp_get_mark_tags,
       get_mark_tags,
       pp_set_formatter_out_channel,
       set_formatter_out_channel,
       pp_set_formatter_output_functi,
       set_formatter_output_functions,
       pp_get_formatter_output_functi,
       get_formatter_output_functions,
       pp_set_formatter_out_functions,
       set_formatter_out_functions,
       pp_get_formatter_out_functions,
       get_formatter_out_functions,
       pp_set_formatter_stag_function,
       set_formatter_stag_functions,
       pp_get_formatter_stag_function,
       get_formatter_stag_functions,
       formatter_of_out_channel,
       synchronized_formatter_of_out_,
       std_formatter,
       get_std_formatter,
       err_formatter,
       get_err_formatter,
       formatter_of_buffer,
       stdbuf,
       get_stdbuf,
       str_formatter,
       get_str_formatter,
       flush_str_formatter,
       make_formatter,
       make_synchronized_formatter,
       formatter_of_out_functions,
       make_symbolic_output_buffer,
       clear_symbolic_output_buffer,
       get_symbolic_output_buffer,
       flush_symbolic_output_buffer,
       add_symbolic_output_item,
       formatter_of_symbolic_output_b,
       pp_print_iter,
       pp_print_list,
       pp_print_array,
       pp_print_seq,
       pp_print_text,
       pp_print_option,
       pp_print_result,
       pp_print_either,
       fprintf,
       printf,
       eprintf,
       sprintf,
       asprintf,
       dprintf,
       ifprintf,
       kfprintf,
       kdprintf,
       ikfprintf,
       ksprintf,
       kasprintf];
   runtime.caml_register_global(37, Stdlib_Format, "Stdlib__Format");
   return;
  }
  (globalThis));

//# 23222 ".js/default/stdlib/stdlib.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    caml_register_named_value = runtime.caml_register_named_value,
    global_data = runtime.caml_get_global_data(),
    Stdlib_Obj = global_data.Stdlib__Obj,
    register = caml_register_named_value;
   function register_exception(name, exn){
    var
     _a_ = Stdlib_Obj[10],
     slot = runtime.caml_obj_tag(exn) === _a_ ? exn : exn[1];
    return caml_register_named_value(name, slot);
   }
   var Stdlib_Callback = [0, register, register_exception];
   runtime.caml_register_global(1, Stdlib_Callback, "Stdlib__Callback");
   return;
  }
  (globalThis));


//# 1 ".js/default/js_of_ocaml-compiler.runtime/jsoo_runtime.cma.js"
// Generated by js_of_ocaml
//# 3 ".js/default/js_of_ocaml-compiler.runtime/jsoo_runtime.cma.js"

//# 18 ".js/default/js_of_ocaml-compiler.runtime/jsoo_runtime.cma.js"
(function(globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    s = "5.7.2",
    git_version = "",
    Jsoo_runtime_Runtime_version = [0, s, git_version];
   runtime.caml_register_global
    (2, Jsoo_runtime_Runtime_version, "Jsoo_runtime__Runtime_version");
   return;
  }
  (globalThis));

//# 33 ".js/default/js_of_ocaml-compiler.runtime/jsoo_runtime.cma.js"
(function
  (globalThis){
   "use strict";
   var runtime = globalThis.jsoo_runtime;
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Jsoo_runtime_Runtime_version = global_data.Jsoo_runtime__Runtime_version,
    Stdlib_Callback = global_data.Stdlib__Callback,
    Js = [0],
    Config = [0],
    version = Jsoo_runtime_Runtime_version[1],
    git_version = Jsoo_runtime_Runtime_version[2],
    Sys = [0, Config, version, git_version],
    Exn = [248, "Jsoo_runtime.Error.Exn", runtime.caml_fresh_oo_id(0)];
   caml_call2(Stdlib_Callback[2], "jsError", [0, Exn, [0]]);
   function raise(exn){throw exn;}
   var
    Error =
      [0,
       raise,
       runtime.caml_exn_with_js_backtrace,
       runtime.caml_js_error_option_of_exception,
       Exn],
    For_compatibility_only = [0],
    Bigstring = [0],
    Typed_array = [0, Bigstring],
    Int64 = [0],
    Jsoo_runtime =
      [0, Js, Sys, Error, For_compatibility_only, Typed_array, Int64];
   runtime.caml_register_global(5, Jsoo_runtime, "Jsoo_runtime");
   return;
  }
  (globalThis));


//# 1 ".js/default/brr/brr.cma.js"
// Generated by js_of_ocaml
//# 3 ".js/default/brr/brr.cma.js"

//# 6 ".js/default/brr/brr.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst = " ",
    cst_length = "length",
    caml_equal = runtime.caml_equal,
    caml_js_meth_call = runtime.caml_js_meth_call,
    caml_list_of_js_array = runtime.caml_list_of_js_array;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Uchar = global_data.Stdlib__Uchar,
    Stdlib = global_data.Stdlib,
    jv_global = globalThis;
   function length(s){return s[cst_length];}
   function jstr_of_int(opt, i){
    if(opt) var sth = opt[1], base = sth; else var base = 10;
    return i.toString(base);
   }
   function get(s, i){
    if(s[cst_length] <= i){
     var
      len = s[cst_length],
      _b_ = jstr_of_int(0, len - 1 | 0),
      _c_ =
        runtime.caml_string_of_jsstring
         ("index ".concat(jstr_of_int(0, i)).concat(" not in bounds [0;").concat
            (_b_).concat
           ("]"));
     return caml_call1(Stdlib[1], _c_);
    }
    var u = s.codePointAt(i);
    a:
    {if(55296 <= u && 57343 >= u){var u$0 = 65533; break a;} var u$0 = u;}
    return caml_call1(Stdlib_Uchar[9], u$0);
   }
   function jstr_of_uchar_int(i){return jv_global["String"].fromCodePoint(i);}
   function get_jstr(s, i){
    var _a_ = get(s, i);
    return jstr_of_uchar_int(caml_call1(Stdlib_Uchar[10], _a_));
   }
   var empty = "", sp = cst, nl = "\n";
   function append(s0, s1){return s0.concat(s1);}
   function concat(opt, ss){
    if(opt) var sth = opt[1], sep = sth; else var sep = empty;
    return runtime.caml_list_to_js_array(ss).join(sep);
   }
   function pad_start(opt, len, s){return s.padStart(len, cst);}
   function pad_end(opt, len, s){return s.padEnd(len, cst);}
   function repeat(n, s){return s.repeat(n);}
   function find_sub(opt, sub, s){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    var i = s.indexOf(sub, start);
    return -1 === i ? 0 : [0, i];
   }
   function find_last_sub(before, sub, s){
    if(before)
     var b = before[1], before$0 = b;
    else
     var before$0 = s[cst_length];
    var pos = before$0 - sub[cst_length] | 0;
    if(0 > pos) return 0;
    var i = s.lastIndexOf(sub, pos);
    return -1 === i ? 0 : [0, i];
   }
   function slice(opt, stop, s){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(stop)
     var stop$0 = stop[1], args = [0, start, stop$0];
    else
     var args = [0, start];
    return caml_js_meth_call(s, "slice", args);
   }
   function sub(opt, len, s){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(len)
     var len$0 = len[1], args = [0, start, len$0];
    else
     var args = [0, start];
    return caml_js_meth_call(s, "substr", args);
   }
   function cuts(sep, s){return caml_list_of_js_array(s.split(sep));}
   var iterator = Symbol.iterator;
   function fold_uchars(f, s, acc){
    var it = s[iterator](), acc$0 = acc;
    for(;;){
     var r = it.next();
     if(r["done"] | 0) return acc$0;
     var u = r["value"].codePointAt(0);
     a:
     {if(55296 <= u && 57343 >= u){var u$0 = 65533; break a;} var u$0 = u;}
     var
      acc$1 = caml_call2(f, caml_call1(Stdlib_Uchar[9], u$0), acc$0),
      acc$0 = acc$1;
    }
   }
   function fold_jstr_uchars(f, s, acc){
    function f$0(u, acc){
     return caml_call2
             (f, jstr_of_uchar_int(caml_call1(Stdlib_Uchar[10], u)), acc);
    }
    return fold_uchars(f$0, s, acc);
   }
   function trim(s){return s.trim();}
   function normalized(nf, s){
    var
     nf$0 =
       868484048 <= nf
        ? 868484049 <= nf ? "NFKD" : "NFKC"
        : 3894540 <= nf ? "NFD" : "NFC";
    return s.normalize(nf$0);
   }
   function lowercased(s){return s.toLowerCase();}
   function uppercased(s){return s.toUpperCase();}
   function is_empty(s){return 0 === s[cst_length] ? 1 : 0;}
   function starts_with(prefix, s){return s.startsWith(prefix) | 0;}
   function includes(affix, s){return s.includes(affix) | 0;}
   function ends_with(suffix, s){return s.endsWith(suffix) | 0;}
   var equal = caml_equal, compare = runtime.caml_compare;
   function of_uchar(u){
    return jstr_of_uchar_int(caml_call1(Stdlib_Uchar[10], u));
   }
   function of_char(c){return jstr_of_uchar_int(c);}
   var number = jv_global["Number"];
   function to_int(base, s){
    if(base) var b = base[1], args = [0, s, b]; else var args = [0, s];
    var n = caml_js_meth_call(number, "parseInt", args);
    return caml_equal(n, n) ? [0, n] : 0;
   }
   function to_float(s){return number.parseFloat(s);}
   function of_float(frac, n){
    if(! frac) return n.toString();
    var frac$0 = frac[1];
    return n.toFixed(frac$0);
   }
   var
    Jstr =
      [0,
       length,
       get,
       get_jstr,
       empty,
       sp,
       nl,
       append,
       append,
       concat,
       pad_start,
       pad_end,
       repeat,
       find_sub,
       find_last_sub,
       slice,
       sub,
       cuts,
       fold_uchars,
       fold_jstr_uchars,
       trim,
       normalized,
       lowercased,
       uppercased,
       is_empty,
       starts_with,
       includes,
       ends_with,
       equal,
       compare,
       of_uchar,
       of_char,
       to_int,
       jstr_of_int,
       to_float,
       of_float];
   runtime.caml_register_global(46, Jstr, "Jstr");
   return;
  }
  (globalThis));

//# 197 ".js/default/brr/brr.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_name = "name",
    cst_value = "value",
    caml_js_get = runtime.caml_js_get,
    caml_js_set = runtime.caml_js_set,
    caml_js_to_bool = runtime.caml_js_to_bool,
    caml_js_wrap_callback_strict = runtime.caml_js_wrap_callback_strict,
    caml_string_compare = runtime.caml_string_compare,
    caml_string_notequal = runtime.caml_string_notequal,
    caml_string_of_jsstring = runtime.caml_string_of_jsstring;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_List = global_data.Stdlib__List,
    Jsoo_runtime = global_data.Jsoo_runtime;
   function strict_equal(_i_, _h_){return _i_ === _h_ ? 1 : 0;}
   var null$0 = null, undefined$0 = undefined;
   function is_null(v){return v === null$0 ? 1 : 0;}
   function is_undefined(v){return v === undefined$0 ? 1 : 0;}
   function is_none(v){
    var _g_ = is_null(v);
    return _g_ ? _g_ : is_undefined(v);
   }
   function is_some(v){return 1 - is_none(v);}
   function to_option(conv, v){
    return is_none(v) ? 0 : [0, caml_call1(conv, v)];
   }
   function of_option(none, conv, param){
    if(! param) return none;
    var v = param[1];
    return caml_call1(conv, v);
   }
   var global = globalThis;
   function set_if_some(o, p, param){
    if(! param) return 0;
    var v = param[1];
    return o[p] = v;
   }
   function find(o, p){var v = o[p]; return is_none(v) ? 0 : [0, v];}
   function find_map(f, o, p){
    var v = o[p];
    return is_none(v) ? 0 : [0, caml_call1(f, v)];
   }
   function find_path(o, param){
    var o$0 = o, param$0 = param;
    for(;;){
     if(! param$0) return [0, o$0];
     var ps = param$0[2], p = param$0[1], match = find(o$0, p);
     if(! match) return 0;
     var o$1 = match[1], o$0 = o$1, param$0 = ps;
    }
   }
   var true$0 = true, false$0 = false;
   function find$0(o, p){var b = o[p]; return is_none(b) ? 0 : [0, b | 0];}
   function get(o, p){return o[p] | 0;}
   function set(o, p, b){return o[p] = ! ! b;}
   function set_if_some$0(o, p, param){
    if(! param) return 0;
    var b = param[1];
    return set(o, p, b);
   }
   var Bool = [0, find$0, get, set, set_if_some$0];
   function find$1(o, p){var i = o[p]; return is_none(i) ? 0 : [0, i];}
   var get$0 = caml_js_get, set$0 = caml_js_set;
   function set_if_some$1(o, p, param){
    if(! param) return 0;
    var i = param[1];
    return o[p] = i;
   }
   var Int = [0, find$1, get$0, set$0, set_if_some$1];
   function find$2(o, p){var f = o[p]; return is_none(f) ? 0 : [0, f];}
   var get$1 = caml_js_get, set$1 = caml_js_set;
   function set_if_some$2(o, p, param){
    if(! param) return 0;
    var f = param[1];
    return o[p] = f;
   }
   var Float = [0, find$2, get$1, set$1, set_if_some$2];
   function find$3(o, p){var s = o[p]; return is_none(s) ? 0 : [0, s];}
   var get$2 = caml_js_get, set$2 = caml_js_set;
   function set_if_some$3(o, p, param){
    if(! param) return 0;
    var f = param[1];
    return o[p] = f;
   }
   function create(n){return new global["Array"](n);}
   function length(a){return a["length"];}
   var Jarray = [0, create, length];
   function to_array(conv, v){
    var len = caml_call1(Jarray[2], v);
    return caml_call2
            (Stdlib_Array[1],
             len,
             function(i){return caml_call1(conv, v[i]);});
   }
   function of_array(conv, a){
    var
     len = a.length - 1,
     ja = caml_call1(Jarray[1], len),
     _e_ = len - 1 | 0,
     _d_ = 0;
    if(_e_ >= 0){
     var i = _d_;
     for(;;){
      ja[i] = caml_call1(conv, runtime.caml_check_bound(a, i)[1 + i]);
      var _f_ = i + 1 | 0;
      if(_e_ === i) break;
      var i = _f_;
     }
    }
    return ja;
   }
   function to_list(conv, v){
    var len = caml_call1(Jarray[2], v);
    return caml_call2
            (Stdlib_List[11],
             len,
             function(i){return caml_call1(conv, v[i]);});
   }
   function of_list(conv, l){
    var ja = caml_call1(Jarray[1], 0), i = 0, param = l;
    for(;;){
     if(! param) return ja;
     var vs = param[2], v = param[1];
     ja[i] = caml_call1(conv, v);
     var i$0 = i + 1 | 0, i = i$0, param = vs;
    }
   }
   function v(name, msg){
    var e = new global["Error"](msg);
    if(! name) return e;
    var n = name[1];
    e[cst_name] = n;
    return e;
   }
   function name(e){return e[cst_name];}
   function enum$0(e){
    var
     match = caml_string_of_jsstring(e[cst_name]),
     switch$0 = caml_string_compare(match, "NotAllowedError");
    if(0 <= switch$0){
     if(0 >= switch$0) return 971339429;
     var switch$1 = caml_string_compare(match, "SyntaxError");
     if(0 <= switch$1){
      if(0 >= switch$1) return 148000204;
      if(! caml_string_notequal(match, "TimeoutError")) return -129520566;
      if(! caml_string_notequal(match, "TransactionInactiveError"))
       return -28376747;
      if(! caml_string_notequal(match, "TypeMismatchError"))
       return -823442212;
      if(! caml_string_notequal(match, "URLMismatchError")) return 147573767;
      if(! caml_string_notequal(match, "UnknownError")) return -1064646157;
      if(! caml_string_notequal(match, "VersionError")) return -1025659903;
      if(! caml_string_notequal(match, "WrongDocumentError"))
       return -937074026;
     }
     else{
      if(! caml_string_notequal(match, "NotFoundError")) return 829592127;
      if(! caml_string_notequal(match, "NotReadableError")) return -119831547;
      if(! caml_string_notequal(match, "NotSupportedError"))
       return -935732949;
      if(! caml_string_notequal(match, "OperationError")) return 115193424;
      if(! caml_string_notequal(match, "QuotaExceededError"))
       return 246360739;
      if(! caml_string_notequal(match, "ReadOnlyError")) return 842968798;
      if(! caml_string_notequal(match, "SecurityError")) return 496062953;
     }
    }
    else{
     var switch$2 = caml_string_compare(match, "InvalidAccessError");
     if(0 <= switch$2){
      if(0 >= switch$2) return 753062229;
      if(! caml_string_notequal(match, "InvalidCharacterError"))
       return 197539530;
      if(! caml_string_notequal(match, "InvalidModificationError"))
       return 943132429;
      if(! caml_string_notequal(match, "InvalidNodeTypeError"))
       return -94613768;
      if(! caml_string_notequal(match, "InvalidStateError")) return 986514226;
      if(! caml_string_notequal(match, "NamespaceError")) return 861236164;
      if(! caml_string_notequal(match, "NetworkError")) return 943709719;
      if(! caml_string_notequal(match, "NoModificationAllowedError"))
       return 320841004;
     }
     else{
      if(! caml_string_notequal(match, "AbortError")) return 183065241;
      if(! caml_string_notequal(match, "ConstraintError")) return 539235142;
      if(! caml_string_notequal(match, "DataCloneError")) return 1031143793;
      if(! caml_string_notequal(match, "DataError")) return 483354835;
      if(! caml_string_notequal(match, "EncodingError")) return 518067260;
      if(! caml_string_notequal(match, "HierarchyRequestError"))
       return 227342318;
      if(! caml_string_notequal(match, "IndexSizeError")) return 89185783;
     }
    }
    return -912009552;
   }
   function message(e){return e["message"];}
   function stack(e){return e["stack"];}
   function throw$0(name, msg){
    var e = v(name, msg);
    return caml_call1(function(exn){throw exn;}, e);
   }
   var Error = Jsoo_runtime[3][4], symbol = Symbol.iterator;
   function iterable(o){
    var match = to_option(function(_c_){return _c_;}, o[symbol]);
    if(! match) return 0;
    var func = match[1];
    return func();
   }
   function iterator(o){return o[symbol]();}
   function next(it){return it.next();}
   function result_done(o){
    var match = to_option(caml_js_to_bool, o["done"]);
    if(! match) return 0;
    var d = match[1];
    return d;
   }
   function result_value(o){
    return to_option(function(_b_){return _b_;}, o[cst_value]);
   }
   function get_result_value(o){return o[cst_value];}
   function fold(of_jv, f, it, acc){
    var acc$0 = acc;
    for(;;){
     var r = it.next();
     if(result_done(r)) return acc$0;
     var
      acc$1 = caml_call2(f, caml_call1(of_jv, r[cst_value]), acc$0),
      acc$0 = acc$1;
    }
   }
   function fold_bindings(key, value, f, it, acc){
    var acc$0 = acc;
    for(;;){
     var r = it.next();
     if(result_done(r)) return acc$0;
     var
      arr = r[cst_value],
      _a_ = caml_call1(value, arr[1]),
      acc$1 = caml_call3(f, caml_call1(key, arr[0]), _a_, acc$0),
      acc$0 = acc$1;
    }
   }
   var promise = global["Promise"];
   function create$0(f){
    function g(res, rej){
     return caml_call2
             (f, function(x){return res(x);}, function(x){return rej(x);});
    }
    return new promise(caml_js_wrap_callback_strict(2, g));
   }
   function resolve(v){return promise.resolve(v);}
   function reject(v){return promise.reject(v);}
   function await$0(p, k){
    p.then(caml_js_wrap_callback_strict(1, k));
    return 0;
   }
   function bind(p, res){return p.then(caml_js_wrap_callback_strict(1, res));}
   function then(p, res, rej){
    return p.then
            (caml_js_wrap_callback_strict(1, res),
             caml_js_wrap_callback_strict(1, rej));
   }
   function all(arr){return promise.all(arr);}
   function find$4(o, p){var v = o[p]; return is_none(v) ? 0 : [0, v];}
   function find_map$0(f, o, p){
    var v = o[p];
    return is_none(v) ? 0 : [0, caml_call1(f, v)];
   }
   function obj(props){
    return runtime.caml_js_object
            (caml_call2
              (Stdlib_Array[13],
               function(param){
                var v = param[2], p = param[1];
                return [0, caml_string_of_jsstring(p), v];
               },
               props));
   }
   function call(o, m, args){
    return runtime.caml_js_meth_call(o, caml_string_of_jsstring(m), args);
   }
   function has(p, v){return is_some(v[p]);}
   function defined(v){return is_some(v);}
   var
    Id = [0],
    Jv =
      [0,
       strict_equal,
       runtime.caml_js_typeof,
       runtime.caml_js_instanceof,
       null$0,
       undefined$0,
       is_null,
       is_undefined,
       is_none,
       is_some,
       to_option,
       of_option,
       global,
       find,
       find_map,
       find_path,
       set_if_some,
       true$0,
       false$0,
       Bool,
       Int,
       Float,
       [0, find$3, get$2, set$2, set_if_some$3],
       runtime.caml_jsstring_of_string,
       caml_string_of_jsstring,
       to_array,
       of_array,
       to_list,
       of_list,
       Jarray,
       [0, v, name, enum$0, message, stack],
       Error,
       throw$0,
       [0,
        result_done,
        result_value,
        get_result_value,
        iterable,
        iterator,
        next,
        fold,
        fold_bindings],
       [0, create$0, resolve, reject, await$0, bind, then, all],
       find$4,
       find_map$0,
       obj,
       call,
       has,
       defined,
       Id];
   runtime.caml_register_global(60, Jv, "Jv");
   return;
  }
  (globalThis));

//# 561 ".js/default/brr/brr.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_fut = "fut",
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Stdlib_Result = global_data.Stdlib__Result,
    Jv = global_data.Jv,
    Assert_failure = global_data.Assert_failure,
    _a_ = [0, "src/fut.ml", 34, 25];
   function promise(f){return f[cst_fut];}
   function create(param){
    function not_set(param){
     throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
    }
    function is_set(param){
     return caml_call2(Jv[32], 0, "The future is already set");
    }
    var setter = [0, not_set];
    function set_setter(resolve, reject){setter[1] = resolve; return 0;}
    var p = caml_call1(Jv[34][1], set_setter);
    function set(v){caml_call1(setter[1], v); setter[1] = is_set; return 0;}
    return [0, {fut: p}, set];
   }
   function await$0(f, k){
    var _k_ = f[cst_fut];
    return caml_call2(Jv[34][4], _k_, k);
   }
   function return$0(v){return {fut: caml_call1(Jv[34][2], v)};}
   function bind(f, fn){
    var _j_ = f[cst_fut];
    return {fut:
            caml_call2
             (Jv[34][5], _j_, function(v){return caml_call1(fn, v)[cst_fut];})};
   }
   function map(fn, f){
    return bind(f, function(v){return return$0(caml_call1(fn, v));});
   }
   function pair(f0, f1){
    var _h_ = f0[cst_fut];
    return {fut:
            caml_call1
             (caml_call1(Jv[34][5], _h_),
              function(v0){
               var _i_ = f1[cst_fut];
               return caml_call1
                       (caml_call1(Jv[34][5], _i_),
                        function(v1){return caml_call1(Jv[34][2], [0, v0, v1]);});
              })};
   }
   function of_list(fs){
    var
     arr = caml_call2(Jv[28], promise, fs),
     all = caml_call1(Jv[34][7], arr);
    function to_list(l){
     var _f_ = caml_call2(Jv[27], function(_g_){return _g_;}, l);
     return caml_call1(Jv[34][2], _f_);
    }
    return {fut: caml_call2(Jv[34][5], all, to_list)};
   }
   function tick(ms){
    return {fut:
            caml_call1
             (Jv[34][1],
              function(res, rej){Jv[12]["setTimeout"](res, ms); return 0;})};
   }
   function ok(v){return return$0([0, v]);}
   function error(e){return return$0([1, e]);}
   function of_promise(ok, error, p){
    function ok$0(v){
     var _e_ = [0, caml_call1(ok, v)];
     return caml_call1(Jv[34][2], _e_);
    }
    function error$0(e){
     var _d_ = [1, caml_call1(error, e)];
     return caml_call1(Jv[34][2], _d_);
    }
    return {fut: caml_call3(Jv[34][6], p, ok$0, error$0)};
   }
   function to_promise(ok, error, f){
    return caml_call1
            (Jv[34][1],
             function(res, rej){
              return await$0
                      (f,
                       function(param){
                        if(0 === param[0]){
                         var v = param[1];
                         return caml_call1(res, caml_call1(ok, v));
                        }
                        var e = param[1];
                        return caml_call1(rej, caml_call1(error, e));
                       });
             });
   }
   function of_promise$0(ok, v){
    return of_promise(ok, function(_c_){return _c_;}, v);
   }
   function to_promise$0(ok, v){
    return to_promise(ok, function(_b_){return _b_;}, v);
   }
   function let$0(f, fn){return map(fn, f);}
   var Syntax = [0, bind, pair, let$0, pair];
   function result_pair(r0, r1){
    if(0 === r0[0]){
     var v0 = r0[1];
     if(0 === r1[0]){var v1 = r1[1]; return [0, [0, v0, v1]];}
     var r = r1;
    }
    else
     var r = r0;
    return r;
   }
   function let$1(f, fn){
    return bind
            (f,
             function(e){
              if(0 !== e[0]) return return$0(e);
              var v = e[1];
              return caml_call1(fn, v);
             });
   }
   function and(f0, f1){return map(result_pair, pair(f0, f1));}
   function let$2(f, fn){return map(caml_call1(Stdlib_Result[8], fn), f);}
   var
    Fut =
      [0,
       create,
       await$0,
       return$0,
       map,
       bind,
       pair,
       of_list,
       tick,
       ok,
       error,
       of_promise$0,
       to_promise$0,
       of_promise,
       to_promise,
       Syntax,
       [0, let$1, and, let$2, and]];
   runtime.caml_register_global(9, Fut, "Fut");
   return;
  }
  (globalThis));

//# 729 ".js/default/brr/brr.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst_Float32Array = "Float32Array",
    cst_Float64Array = "Float64Array",
    cst_Int16Array = "Int16Array",
    cst_Int32Array = "Int32Array",
    cst_Int8Array = "Int8Array",
    cst_Uint16Array = "Uint16Array",
    cst_Uint32Array = "Uint32Array",
    cst_Uint8Array = "Uint8Array",
    cst_Uint8ClampedArray = "Uint8ClampedArray",
    cst_abort = "abort",
    cst_activeElement = "activeElement",
    cst_altKey$1 = "altKey",
    cst_append = "append",
    cst_auto = "auto",
    cst_blur = "blur",
    cst_body = "body",
    cst_bubbles$1 = "bubbles",
    cst_buffer = "buffer",
    cst_button$0 = "button",
    cst_byteLength$1 = "byteLength",
    cst_cancelable$1 = "cancelable",
    cst_checked = "checked",
    cst_classList = "classList",
    cst_clear$0 = "clear",
    cst_click = "click",
    cst_close = "close",
    cst_code$0 = "code",
    cst_composed$1 = "composed",
    cst_console = "console",
    cst_copy = "copy",
    cst_ctrlKey$1 = "ctrlKey",
    cst_data$1 = "data",
    cst_dataTransfer$1 = "dataTransfer",
    cst_dblclick = "dblclick",
    cst_dir$0 = "dir",
    cst_documentElement = "documentElement",
    cst_dropEffect$1 = "dropEffect",
    cst_effectAllowed$1 = "effectAllowed",
    cst_error$0 = "error",
    cst_firstChild = "firstChild",
    cst_focus = "focus",
    cst_hash$2 = "hash",
    cst_head = "head",
    cst_height$1 = "height",
    cst_hidden = "hidden",
    cst_hostname$1 = "hostname",
    cst_id = "id",
    cst_input = "input",
    cst_isComposing$1 = "isComposing",
    cst_lastModified$1 = "lastModified",
    cst_length$4 = "length",
    cst_link = "link",
    cst_location$0 = "location",
    cst_map = "map",
    cst_mark = "mark",
    cst_measure = "measure",
    cst_metaKey$1 = "metaKey",
    cst_name$2 = "name",
    cst_nodeType$1 = "nodeType",
    cst_open = "open",
    cst_ownerDocument = "ownerDocument",
    cst_pathname$1 = "pathname",
    cst_pointerLockElement = "pointerLockElement",
    cst_port$1 = "port",
    cst_progress = "progress",
    cst_protocol$1 = "protocol",
    cst_relatedTarget$1 = "relatedTarget",
    cst_reload = "reload",
    cst_scrollRestoration$1 = "scrollRestoration",
    cst_search$2 = "search",
    cst_select = "select",
    cst_shiftKey$1 = "shiftKey",
    cst_state = "state",
    cst_style = "style",
    cst_table$0 = "table",
    cst_time$0 = "time",
    cst_timeStamp$1 = "timeStamp",
    cst_title$1 = "title",
    cst_type$4 = "type",
    cst_value = "value",
    cst_width$1 = "width",
    cst_window = "window",
    caml_js_from_bool = runtime.caml_js_from_bool,
    caml_js_get = runtime.caml_js_get,
    caml_js_meth_call = runtime.caml_js_meth_call,
    caml_js_wrap_callback_strict = runtime.caml_js_wrap_callback_strict,
    caml_list_of_js_array = runtime.caml_list_of_js_array,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_string_notequal = runtime.caml_string_notequal,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    global_data = runtime.caml_get_global_data(),
    Jv = global_data.Jv,
    Jstr = global_data.Jstr,
    Fut = global_data.Fut,
    Stdlib_List = global_data.Stdlib__List,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_Option = global_data.Stdlib__Option,
    Stdlib_Bigarray = global_data.Stdlib__Bigarray,
    Type = [0],
    cst_bubbles = cst_bubbles$1,
    cst_cancelable = cst_cancelable$1,
    cst_composed = cst_composed$1;
   function init(bubbles, cancelable, composed, param){
    var o = {};
    caml_call3(Jv[19][4], o, cst_bubbles, bubbles);
    caml_call3(Jv[19][4], o, cst_cancelable, cancelable);
    caml_call3(Jv[19][4], o, cst_composed, composed);
    return o;
   }
   var
    event = Jv[12]["Event"],
    cst_type = cst_type$4,
    cst_eventPhase = "eventPhase",
    cst_bubbles$0 = cst_bubbles$1,
    cst_cancelable$0 = cst_cancelable$1,
    cst_defaultPrevented = "defaultPrevented",
    cst_composed$0 = cst_composed$1,
    cst_isTrusted = "isTrusted",
    cst_timeStamp = cst_timeStamp$1,
    cst_capture = "capture",
    cst_once = "once",
    cst_passive = "passive",
    _a_ = [0, 1];
   function create(opt, t){
    if(opt) var sth = opt[1], init = sth; else var init = {};
    return new event(t, init);
   }
   function type(e){return caml_call2(Jv[22][2], e, cst_type);}
   function target(e){return e["target"];}
   function current_target(e){return e["currentTarget"];}
   function composed_path(e){
    var _iP_ = e.composedPath();
    return caml_call2(Jv[27], function(_iQ_){return _iQ_;}, _iP_);
   }
   function event_phase(e){
    var switcher = caml_call2(Jv[20][2], e, cst_eventPhase) - 1 | 0;
    if(2 < switcher >>> 0) return 870530776;
    switch(switcher){
      case 0:
       return 497141539;
      case 1:
       return -276077507;
      default: return 608305129;
    }
   }
   function bubbles(e){return caml_call2(Jv[19][2], e, cst_bubbles$0);}
   function stop_propagation(e){e.stopPropagation(); return 0;}
   function stop_immediate_propagation(e){
    e.stopImmediatePropagation();
    return 0;
   }
   function cancelable(e){return caml_call2(Jv[19][2], e, cst_cancelable$0);}
   function prevent_default(e){e.preventDefault(); return 0;}
   function default_prevented(e){
    return caml_call2(Jv[19][2], e, cst_defaultPrevented);
   }
   function composed(e){return caml_call2(Jv[19][2], e, cst_composed$0);}
   function is_trusted(e){return caml_call2(Jv[19][2], e, cst_isTrusted);}
   function timestamp_ms(e){return caml_call2(Jv[21][2], e, cst_timeStamp);}
   function dispatch(e, t){return t.dispatchEvent(e) | 0;}
   function listen_opts(capture, once, passive, param){
    var o = {};
    caml_call3(Jv[19][4], o, cst_capture, capture);
    caml_call3(Jv[19][4], o, cst_once, once);
    caml_call3(Jv[19][4], o, cst_passive, passive);
    return o;
   }
   function listen(opt, type, f, t){
    if(opt) var sth = opt[1], opts = sth; else var opts = {};
    var f$0 = caml_js_wrap_callback_strict(1, f);
    function unlisten(param){
     t.removeEventListener(type, f$0, opts);
     return 0;
    }
    t.addEventListener(type, f$0, opts);
    return unlisten;
   }
   function unlisten(unlisten){return caml_call1(unlisten, 0);}
   function next(capture, type, t){
    var
     match = caml_call1(Fut[1], 0),
     set = match[2],
     fut = match[1],
     opts = listen_opts(capture, _a_, 0, 0);
    listen([0, opts], type, set, t);
    return fut;
   }
   var
    none = "none",
    copy = cst_copy,
    copy_link = "copyLink",
    copy_move = "copyMove",
    link = cst_link,
    link_move = "linkMove",
    move = "move",
    all = "all",
    uninitialized = "uninitialized",
    Effect =
      [0,
       none,
       copy,
       copy_link,
       copy_move,
       link,
       link_move,
       move,
       all,
       uninitialized],
    file = "file",
    string = "string",
    Kind = [0, file, string],
    cst_kind = "kind",
    cst_type$0 = cst_type$4;
   function kind(i){return caml_call2(Jv[22][2], i, cst_kind);}
   function type$0(i){return caml_call2(Jv[22][2], i, cst_type$0);}
   function get_file(i){
    var _iN_ = i.getAsFile();
    return caml_call2(Jv[10], function(_iO_){return _iO_;}, _iN_);
   }
   function get_jstr(i){
    var
     match = caml_call1(Fut[1], 0),
     set_str = match[2],
     str = match[1],
     set_str$0 = caml_js_wrap_callback_strict(1, set_str);
    i.getAsString(set_str$0);
    return str;
   }
   var
    Item = [0, Kind, kind, type$0, get_file, get_jstr],
    cst_length = cst_length$4,
    cst_dropEffect = cst_dropEffect$1,
    cst_dropEffect$0 = cst_dropEffect$1,
    cst_effectAllowed = cst_effectAllowed$1,
    cst_effectAllowed$0 = cst_effectAllowed$1,
    cst_clipboardData = "clipboardData";
   function length(l){return caml_call2(Jv[20][2], l, cst_length);}
   function add_jstr(l, type, str){
    var _iL_ = l.add(str, type);
    return caml_call1(caml_call1(Jv[10], function(_iM_){return _iM_;}), _iL_);
   }
   function add_file(t, file){
    var _iJ_ = t.add(file);
    return caml_call1(caml_call1(Jv[10], function(_iK_){return _iK_;}), _iJ_);
   }
   function remove(l, i){l.remove(i); return 0;}
   function clear(l){l.clear(); return 0;}
   function items(l){
    var acc = [0, 0], _iG_ = length(l) - 1 | 0;
    if(_iG_ >= 0){
     var i = _iG_;
     for(;;){
      var _iH_ = acc[1];
      acc[1] = [0, l[i], _iH_];
      var _iI_ = i - 1 | 0;
      if(0 === i) break;
      var i = _iI_;
     }
    }
    return acc[1];
   }
   function drop_effect(d){return caml_call2(Jv[22][2], d, cst_dropEffect);}
   function set_drop_effect(d, e){
    return caml_call3(Jv[22][3], d, cst_dropEffect$0, e);
   }
   function effect_allowed(d){
    return caml_call2(Jv[22][2], d, cst_effectAllowed);
   }
   function set_effect_allowed(d, e){
    return caml_call3(Jv[22][3], d, cst_effectAllowed$0, e);
   }
   function items$0(d){return d["items"];}
   function data(c){
    return caml_call3
            (Jv[14], function(_iF_){return _iF_;}, c, cst_clipboardData);
   }
   var Clipboard = [0, data], cst_data = cst_data$1;
   function data$0(i){return caml_call2(Jv[22][2], i, cst_data);}
   var
    Composition = [0, data$0],
    cst_message = "message",
    cst_filename = "filename",
    cst_lineno = "lineno",
    cst_colno = "colno";
   function message(e){return caml_call2(Jv[22][2], e, cst_message);}
   function filename(e){return caml_call2(Jv[22][2], e, cst_filename);}
   function lineno(e){return caml_call2(Jv[20][2], e, cst_lineno);}
   function colno(e){return caml_call2(Jv[20][2], e, cst_colno);}
   function error(e){return e[cst_error$0];}
   var Error = [0, message, filename, lineno, colno, error];
   function wait_until(e, fut){
    e.waitUntil(caml_call2(Fut[12], function(_iE_){return _iE_;}, fut));
    return 0;
   }
   var Extendable = [0, wait_until], cst_relatedTarget = cst_relatedTarget$1;
   function related_target(m){
    return caml_call3
            (Jv[14], function(_iD_){return _iD_;}, m, cst_relatedTarget);
   }
   var
    Focus = [0, related_target],
    cst_oldURL = "oldURL",
    cst_newURL = "newURL";
   function old_url(e){return caml_call2(Jv[22][2], e, cst_oldURL);}
   function new_url(e){return caml_call2(Jv[22][2], e, cst_newURL);}
   var
    Hash_change = [0, old_url, new_url],
    cst_data$0 = cst_data$1,
    cst_dataTransfer = cst_dataTransfer$1,
    cst_inputType = "inputType",
    cst_isComposing = cst_isComposing$1;
   function data$1(i){return caml_call2(Jv[22][2], i, cst_data$0);}
   function data_transfer(i){return caml_call2(Jv[13], i, cst_dataTransfer);}
   function input_type(i){return caml_call2(Jv[22][2], i, cst_inputType);}
   function is_composing(i){return caml_call2(Jv[19][2], i, cst_isComposing);}
   var
    Input = [0, data$1, data_transfer, input_type, is_composing],
    Location = [0, 0, 1, 2, 3],
    cst_key = "key",
    cst_code = cst_code$0,
    cst_location = cst_location$0,
    cst_repeat = "repeat",
    cst_isComposing$0 = cst_isComposing$1,
    cst_altKey = cst_altKey$1,
    cst_ctrlKey = cst_ctrlKey$1,
    cst_shiftKey = cst_shiftKey$1,
    cst_metaKey = cst_metaKey$1;
   function key(k){return caml_call2(Jv[22][2], k, cst_key);}
   function code(k){return caml_call2(Jv[22][2], k, cst_code);}
   function location(k){return caml_call2(Jv[20][2], k, cst_location);}
   function repeat(k){return caml_call2(Jv[19][2], k, cst_repeat);}
   function is_composing$0(k){
    return caml_call2(Jv[19][2], k, cst_isComposing$0);
   }
   function alt_key(k){return caml_call2(Jv[19][2], k, cst_altKey);}
   function ctrl_key(k){return caml_call2(Jv[19][2], k, cst_ctrlKey);}
   function shift_key(k){return caml_call2(Jv[19][2], k, cst_shiftKey);}
   function meta_key(k){return caml_call2(Jv[19][2], k, cst_metaKey);}
   function get_modifier_state(k, key){return k.getModifierState(key) | 0;}
   var
    Keyboard =
      [0,
       Location,
       key,
       code,
       location,
       repeat,
       is_composing$0,
       alt_key,
       ctrl_key,
       shift_key,
       meta_key,
       get_modifier_state],
    cst_relatedTarget$0 = cst_relatedTarget$1,
    cst_offsetX = "offsetX",
    cst_offsetY = "offsetY",
    cst_clientX = "clientX",
    cst_clientY = "clientY",
    cst_pageX = "pageX",
    cst_pageY = "pageY",
    cst_screenX = "screenX",
    cst_screenY = "screenY",
    cst_movementX = "movementX",
    cst_movementY = "movementY",
    cst_button = cst_button$0,
    cst_buttons = "buttons",
    cst_altKey$0 = cst_altKey$1,
    cst_ctrlKey$0 = cst_ctrlKey$1,
    cst_shiftKey$0 = cst_shiftKey$1,
    cst_metaKey$0 = cst_metaKey$1;
   function related_target$0(m){
    return caml_call3
            (Jv[14], function(_iC_){return _iC_;}, m, cst_relatedTarget$0);
   }
   function offset_x(m){return caml_call2(Jv[21][2], m, cst_offsetX);}
   function offset_y(m){return caml_call2(Jv[21][2], m, cst_offsetY);}
   function client_x(m){return caml_call2(Jv[21][2], m, cst_clientX);}
   function client_y(m){return caml_call2(Jv[21][2], m, cst_clientY);}
   function page_x(m){return caml_call2(Jv[21][2], m, cst_pageX);}
   function page_y(m){return caml_call2(Jv[21][2], m, cst_pageY);}
   function screen_x(m){return caml_call2(Jv[21][2], m, cst_screenX);}
   function screen_y(m){return caml_call2(Jv[21][2], m, cst_screenY);}
   function movement_x(m){return caml_call2(Jv[21][2], m, cst_movementX);}
   function movement_y(m){return caml_call2(Jv[21][2], m, cst_movementY);}
   function button(m){return caml_call2(Jv[20][2], m, cst_button);}
   function buttons(m){return caml_call2(Jv[20][2], m, cst_buttons);}
   function alt_key$0(m){return caml_call2(Jv[19][2], m, cst_altKey$0);}
   function ctrl_key$0(m){return caml_call2(Jv[19][2], m, cst_ctrlKey$0);}
   function shift_key$0(m){return caml_call2(Jv[19][2], m, cst_shiftKey$0);}
   function meta_key$0(m){return caml_call2(Jv[19][2], m, cst_metaKey$0);}
   function get_modifier_state$0(m, key){return m.getModifierState(key) | 0;}
   var
    Mouse =
      [0,
       related_target$0,
       offset_x,
       offset_y,
       client_x,
       client_y,
       page_x,
       page_y,
       screen_x,
       screen_y,
       movement_x,
       movement_y,
       button,
       buttons,
       alt_key$0,
       ctrl_key$0,
       shift_key$0,
       meta_key$0,
       get_modifier_state$0],
    cst_dataTransfer$0 = cst_dataTransfer$1;
   function data_transfer$0(d){
    return caml_call3
            (Jv[14], function(_iB_){return _iB_;}, d, cst_dataTransfer$0);
   }
   var
    Drag = [0, data_transfer$0],
    cst_pointerId = "pointerId",
    cst_width = cst_width$1,
    cst_height = cst_height$1,
    cst_pressure = "pressure",
    cst_tangentialPressure = "tangentialPressure",
    cst_tiltX = "tiltX",
    cst_tiltY = "tiltY",
    cst_twist = "twist",
    cst_altitudeAngle = "altitudeAngle",
    cst_azimuthAngle = "azimuthAngle",
    cst_pointerType = "pointerType",
    cst_isPrimary = "isPrimary";
   function id(p){return caml_call2(Jv[20][2], p, cst_pointerId);}
   function width(p){return caml_call2(Jv[21][2], p, cst_width);}
   function height(p){return caml_call2(Jv[21][2], p, cst_height);}
   function pressure(p){return caml_call2(Jv[21][2], p, cst_pressure);}
   function tangential_pressure(p){
    return caml_call2(Jv[21][2], p, cst_tangentialPressure);
   }
   function tilt_x(p){return caml_call2(Jv[20][2], p, cst_tiltX);}
   function tilt_y(p){return caml_call2(Jv[20][2], p, cst_tiltY);}
   function twist(p){return caml_call2(Jv[20][2], p, cst_twist);}
   function altitude_angle(p){
    return caml_call2(Jv[21][2], p, cst_altitudeAngle);
   }
   function azimuth_angle(p){
    return caml_call2(Jv[21][2], p, cst_azimuthAngle);
   }
   function type$1(p){return caml_call2(Jv[22][2], p, cst_pointerType);}
   function is_primary(p){return caml_call2(Jv[19][2], p, cst_isPrimary);}
   function get_coalesced_events(p){
    var _iz_ = p.getCoalescedEvents();
    return caml_call2(Jv[27], function(_iA_){return _iA_;}, _iz_);
   }
   function get_predicted_events(p){
    var _ix_ = p.getPredictedEvents();
    return caml_call2(Jv[27], function(_iy_){return _iy_;}, _ix_);
   }
   var
    Pointer =
      [0,
       id,
       width,
       height,
       pressure,
       tangential_pressure,
       tilt_x,
       tilt_y,
       twist,
       altitude_angle,
       azimuth_angle,
       type$1,
       is_primary,
       get_coalesced_events,
       get_predicted_events],
    Delta_mode = [0, 0, 1, 2],
    cst_deltaX = "deltaX",
    cst_deltaY = "deltaY",
    cst_deltaZ = "deltaZ",
    cst_deltaMode = "deltaMode";
   function delta_x(w){return caml_call2(Jv[21][2], w, cst_deltaX);}
   function delta_y(w){return caml_call2(Jv[21][2], w, cst_deltaY);}
   function delta_z(w){return caml_call2(Jv[21][2], w, cst_deltaZ);}
   function delta_mode(w){return caml_call2(Jv[20][2], w, cst_deltaMode);}
   var
    Wheel = [0, Delta_mode, delta_x, delta_y, delta_z, delta_mode],
    abort = cst_abort,
    activate = "activate",
    auxclick = cst_dblclick,
    beforeinput = "beforeinput",
    beforeunload = "beforeunload",
    blur = cst_blur,
    canplay = "canplay",
    canplaythrough = "canplaythrough",
    change = "change",
    click = cst_click,
    clipboardchange = "clipboardchange",
    close = cst_close,
    compositionend = "compositionend",
    compositionstart = "compositionstart",
    compositionudpate = "compositionupdate",
    controllerchange = "controllerchange",
    copy$0 = cst_copy,
    cut = "cut",
    dblclick = cst_dblclick,
    dom_content_loaded = "DOMContentLoaded",
    drag = "drag",
    dragend = "dragend",
    dragenter = "dragenter",
    dragexit = "dragexit",
    dragleave = "dragleave",
    dragover = "dragover",
    dragstart = "dragstart",
    drop = "drop",
    durationchange = "durationchange",
    emptied = "emptied",
    ended = "ended",
    error$0 = cst_error$0,
    focus = cst_focus,
    focusin = "focusin",
    focusout = "focusout",
    fullscreenchange = "fullscreenchange",
    fullscreenerror = "fullscreenerror",
    gotpointercapture = "gotpointercapture",
    hashchange = "hashchange",
    input = cst_input,
    install = "install",
    keydown = "keydown",
    keyup = "keyup",
    languagechange = "languagechange",
    load = "load",
    loadeddata = "loadeddata",
    loadedmetadata = "loadedmetadata",
    loadstart = "loadstart",
    lostpointercapture = "lostpointercapture",
    mousedown = "mousedown",
    mouseenter = "mouseenter",
    mouseleave = "mouseleave",
    mousemove = "mousemove",
    mouseout = "mouseout",
    mouseover = "mouseover",
    mouseup = "mouseup",
    open = cst_open,
    paste = "paste",
    pause = "pause",
    play = "play",
    playing = "playing",
    pointercancel = "pointercancel",
    pointerdown = "pointerdown",
    pointerenter = "pointerenter",
    pointerleave = "pointerleave",
    pointerlockchange = "pointerlockchange",
    pointerlockerror = "pointerlockerror",
    pointermove = "pointermove",
    pointerout = "pointerout",
    pointerover = "pointerover",
    pointerrawupdate = "pointerrawupdate",
    pointerup = "pointerup",
    progress = cst_progress,
    ratechange = "ratechange",
    reset = "reset",
    resize = "resize",
    scroll = "scroll",
    seeked = "seeked",
    seeking = "seeking",
    select = cst_select,
    stalled = "stalled",
    statechange = "statechange",
    suspend = "suspend",
    timeupdate = "timeupdate",
    unload = "unload",
    updatefound = "updatefound",
    visibilitychange = "visibilitychange",
    volumechange = "volumechange",
    waiting = "waiting",
    wheel = "wheel",
    array_buffer = Jv[12]["ArrayBuffer"],
    cst_byteLength = cst_byteLength$1,
    cst_byteOffset = "byteOffset",
    cst_byteLength$0 = cst_byteLength$1;
   function create$0(n){return new array_buffer(n);}
   function byte_length(a){return caml_call2(Jv[20][2], a, cst_byteLength);}
   function slice(opt, stop, a){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(stop)
     var stop$0 = stop[1], stop$1 = stop$0;
    else
     var stop$1 = byte_length(a);
    return a.slice(start, stop$1);
   }
   function buffer(o){return o[cst_buffer];}
   function byte_offset(o){return caml_call2(Jv[20][2], o, cst_byteOffset);}
   function byte_length$0(o){
    return caml_call2(Jv[20][2], o, cst_byteLength$0);
   }
   var
    dataview = Jv[12]["DataView"],
    cst_length$0 = cst_length$4,
    cst_name = cst_name$2,
    cst_utf_8 = "utf-8",
    _b_ = [0, 7],
    _c_ = [0, 8],
    _d_ = [0, 0],
    _e_ = [0, 3],
    _f_ = [0, 1],
    _g_ = [0, 5],
    _h_ = [0, 2];
   function of_buffer(opt, byte_length$0, b){
    if(opt) var sth = opt[1], byte_offset = sth; else var byte_offset = 0;
    if(byte_length$0)
     var l = byte_length$0[1], byte_length$1 = l;
    else
     var byte_length$1 = byte_length(b);
    return new dataview(b, byte_offset, byte_length$1);
   }
   function get_int8(b, i){return b.getInt8(i);}
   function get_int16_be(b, i){return b.getInt16(i);}
   function get_int16_le(b, i){return b.getInt16(i, Jv[17]);}
   function get_int32_be(b, i){return b.getInt32(i);}
   function get_int32_le(b, i){return b.getInt32(i, Jv[17]);}
   function get_uint8(b, i){return b.getUint8(i);}
   function get_uint16_be(b, i){return b.getUint16(i);}
   function get_uint16_le(b, i){return b.getUint16(i, Jv[17]);}
   function get_uint32_be(b, i){return b.getUint32(i);}
   function get_uint32_le(b, i){return b.getUint32(i, Jv[17]);}
   function get_float32_be(b, i){return b.getFloat32(i);}
   function get_float32_le(b, i){return b.getFloat32(i, Jv[17]);}
   function get_float64_be(b, i){return b.getFloat64(i);}
   function get_float64_le(b, i){return b.getFloat64(i, Jv[17]);}
   function set_int8(b, i, v){b.setInt8(i, v); return 0;}
   function set_int16_be(b, i, v){b.setInt16(i, v); return 0;}
   function set_int16_le(b, i, v){b.setInt16(i, v, Jv[17]); return 0;}
   function set_int32_be(b, i, v){b.setInt32(i, v); return 0;}
   function set_int32_le(b, i, v){b.setInt32(i, v, Jv[17]); return 0;}
   function set_uint8(b, i, v){b.setUint8(i, v); return 0;}
   function set_uint16_be(b, i, v){b.setUint16(i, v); return 0;}
   function set_uint16_le(b, i, v){b.setUint16(i, v, Jv[17]); return 0;}
   function set_uint32_be(b, i, v){b.setUint32(i, v); return 0;}
   function set_uint32_le(b, i, v){b.setUint32(i, v, Jv[17]); return 0;}
   function set_float32_be(b, i, v){b.setFloat32(i, v); return 0;}
   function set_float32_le(b, i, v){b.setFloat32(i, v, Jv[17]); return 0;}
   function set_float64_be(b, i, v){b.setFloat64(i, v); return 0;}
   function set_float64_le(b, i, v){b.setFloat64(i, v, Jv[17]); return 0;}
   function type_size_in_bytes(param){
    switch(param){
      case 8:
       return 8;
      case 1:
      case 5:
       return 2;
      case 0:
      case 3:
      case 4:
       return 1;
      default: return 4;
    }
   }
   function cons_of_type(param){
    switch(param){
      case 0:
       return Jv[12][cst_Int8Array];
      case 1:
       return Jv[12][cst_Int16Array];
      case 2:
       return Jv[12][cst_Int32Array];
      case 3:
       return Jv[12][cst_Uint8Array];
      case 4:
       return Jv[12][cst_Uint8ClampedArray];
      case 5:
       return Jv[12][cst_Uint16Array];
      case 6:
       return Jv[12][cst_Uint32Array];
      case 7:
       return Jv[12][cst_Float32Array];
      default: return Jv[12][cst_Float64Array];
    }
   }
   function create$1(t, n){return new (cons_of_type(t))(n);}
   function of_buffer$0(t, opt, length, b){
    if(opt) var sth = opt[1], byte_offset = sth; else var byte_offset = 0;
    if(length)
     var l = length[1], args = [0, b, byte_offset, l];
    else
     var args = [0, b, byte_offset];
    return runtime.caml_js_new(cons_of_type(t), args);
   }
   function length$0(a){return caml_call2(Jv[20][2], a, cst_length$0);}
   function type$2(a){
    var
     _iv_ = a["constructor"],
     s =
       runtime.caml_string_of_jsstring(caml_call2(Jv[22][2], _iv_, cst_name));
    if(! caml_string_notequal(s, cst_Float32Array)) return 7;
    if(! caml_string_notequal(s, cst_Float64Array)) return 8;
    if(! caml_string_notequal(s, cst_Int16Array)) return 1;
    if(! caml_string_notequal(s, cst_Int32Array)) return 2;
    if(! caml_string_notequal(s, cst_Int8Array)) return 0;
    if(! caml_string_notequal(s, cst_Uint16Array)) return 5;
    if(! caml_string_notequal(s, cst_Uint32Array)) return 6;
    if(! caml_string_notequal(s, cst_Uint8Array)) return 3;
    if(! caml_string_notequal(s, cst_Uint8ClampedArray)) return 4;
    var
     t = runtime.caml_jsstring_of_string(s),
     _iw_ = caml_call2(Jstr[7], "Unknown typed array: ", t);
    return caml_call2(Jv[32], 0, _iw_);
   }
   function set_tarray(a, dst, b){a.set(b, dst); return 0;}
   function fill(opt, stop, v, a){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(stop)
     var stop$0 = stop[1], stop$1 = stop$0;
    else
     var stop$1 = length$0(a);
    a.fill(v, start, stop$1);
    return 0;
   }
   function copy_within(opt, stop, dst, a){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(stop)
     var stop$0 = stop[1], stop$1 = stop$0;
    else
     var stop$1 = length$0(a);
    a.copyWithin(dst, start, stop$1);
    return 0;
   }
   function slice$0(opt, stop, a){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(stop)
     var stop$0 = stop[1], stop$1 = stop$0;
    else
     var stop$1 = byte_length$0(a);
    return a.slice(start, stop$1);
   }
   function sub(opt, stop, a){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(stop)
     var stop$0 = stop[1], stop$1 = stop$0;
    else
     var stop$1 = byte_length$0(a);
    return a.subArray(start, stop$1);
   }
   function find(sat, a){
    function sat$0(v, i){return ! ! caml_call2(sat, i, v);}
    var _it_ = a.find(caml_js_wrap_callback_strict(2, sat$0));
    return caml_call2(Jv[10], function(_iu_){return _iu_;}, _it_);
   }
   function find_index(sat, a){
    function sat$0(v, i){return ! ! caml_call2(sat, i, v);}
    var i = a.findIndex(caml_js_wrap_callback_strict(2, sat$0));
    return -1 === i ? 0 : [0, i];
   }
   function for_all(sat, a){
    function sat$0(v, i){return ! ! caml_call2(sat, i, v);}
    return a.every(caml_js_wrap_callback_strict(2, sat$0)) | 0;
   }
   function exists(sat, a){
    function sat$0(v, i){return ! ! caml_call2(sat, i, v);}
    return a.every(caml_js_wrap_callback_strict(2, sat$0)) | 0;
   }
   function filter(sat, a){
    function sat$0(v, i){return ! ! caml_call2(sat, i, v);}
    return a.filter(caml_js_wrap_callback_strict(2, sat$0));
   }
   function iter(f, a){
    function f$0(v, i){return caml_call2(f, i, v);}
    a.forEach(caml_js_wrap_callback_strict(2, f$0));
    return 0;
   }
   function map(f, a){return a.map(caml_js_wrap_callback_strict(1, f));}
   function fold_left(f, acc, a){
    return a.reduce(caml_js_wrap_callback_strict(2, f), acc);
   }
   function fold_right(f, a, acc){
    function f$0(acc, v){return caml_call2(f, v, acc);}
    return a.reduceRight(caml_js_wrap_callback_strict(2, f$0), acc);
   }
   function reverse(a){return a.reverse();}
   function of_tarray(t, a){return new (cons_of_type(t))(a);}
   function of_int_array(t, a){
    var _ir_ = caml_call2(Jv[26], function(_is_){return _is_;}, a);
    return new (cons_of_type(t))(_ir_);
   }
   function of_float_array(t, a){
    var _ip_ = caml_call2(Jv[26], function(_iq_){return _iq_;}, a);
    return new (cons_of_type(t))(_ip_);
   }
   function to_int_jstr(opt, b){
    if(opt) var sth = opt[1], sep = sth; else var sep = Jstr[5];
    return b.join(sep);
   }
   function to_hex_jstr(opt, a){
    if(opt) var sth = opt[1], sep = sth; else var sep = Jstr[4];
    var
     hex = "0123456789abcdef",
     d = of_buffer(0, 0, a[cst_buffer]),
     s = [0, Jstr[4]],
     _ij_ = byte_length$0(d) - 1 | 0,
     _ii_ = 0;
    if(_ij_ >= 0){
     var i = _ii_;
     for(;;){
      var
       b = d.getUint8(i),
       sep$0 = 0 === i ? Jstr[4] : sep,
       _ik_ = caml_call2(Jstr[3], hex, b & 15),
       _il_ = caml_call2(Jstr[3], hex, b >>> 4 | 0),
       _im_ = caml_call2(Jstr[8], s[1], sep$0),
       _in_ = caml_call2(Jstr[8], _im_, _il_);
      s[1] = caml_call2(Jstr[8], _in_, _ik_);
      var _io_ = i + 1 | 0;
      if(_ij_ === i) break;
      var i = _io_;
     }
    }
    return s[1];
   }
   function uint8_of_buffer(b){return of_buffer$0(3, 0, 0, b);}
   function of_jstr(s){
    var enc = new Jv[12]["TextEncoder"];
    return enc.encode(s);
   }
   function to_jstr(a){
    var
     _ig_ = {fatal: Jv[17]},
     _ih_ = caml_call1(Jv[23], cst_utf_8),
     dec = new Jv[12]["TextDecoder"](_ih_, _ig_);
    try{var s = dec.decode(a);}
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
    return [0, s];
   }
   function of_binary_jstr(s){
    try{
     var
      b = create$0(caml_call1(Jstr[1], s)),
      d = of_buffer(0, 0, b),
      _ic_ = caml_call1(Jstr[1], s) - 1 | 0,
      _ib_ = 0;
     if(_ic_ >= 0){
      var i = _ib_;
      for(;;){
       var c = s.charCodeAt(i);
       if(255 < c)
        var
         _h8_ = caml_call2(Jstr[33], 0, c),
         _h9_ = caml_call2(Jstr[33], 0, i),
         _h__ = caml_call2(Jstr[8], _h9_, ": char code "),
         _h$_ = caml_call2(Jstr[8], _h__, _h8_),
         _ia_ = caml_call2(Jstr[8], _h$_, "exceeds 255"),
         _ie_ = caml_call2(Jv[32], 0, _ia_);
       else
        var _ie_ = c;
       set_int8(d, i, _ie_);
       var _if_ = i + 1 | 0;
       if(_ic_ === i) break;
       var i = _if_;
      }
     }
     var _id_ = [0, of_buffer$0(0, 0, 0, b)];
     return _id_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
   }
   function to_binary_jstr(a){
    var
     d = of_buffer(0, 0, a[cst_buffer]),
     s = [0, Jstr[4]],
     _h6_ = byte_length$0(d) - 1 | 0,
     _h5_ = 0;
    if(_h6_ >= 0){
     var i = _h5_;
     for(;;){
      var b = d.getUint8(i), _h4_ = Jv[12]["String"].fromCharCode(b);
      s[1] = caml_call2(Jstr[8], s[1], _h4_);
      var _h7_ = i + 1 | 0;
      if(_h6_ === i) break;
      var i = _h7_;
     }
    }
    return s[1];
   }
   function type_to_bigarray_kind(param){
    switch(param){
      case 0:
       return Stdlib_Bigarray[5];
      case 1:
       return Stdlib_Bigarray[7];
      case 2:
       return Stdlib_Bigarray[10];
      case 3:
       return Stdlib_Bigarray[6];
      case 4:
       return Stdlib_Bigarray[6];
      case 5:
       return Stdlib_Bigarray[8];
      case 6:
       return Stdlib_Bigarray[10];
      case 7:
       return Stdlib_Bigarray[1];
      default: return Stdlib_Bigarray[2];
    }
   }
   function type_of_bigarray_kind(param){
    switch(param){
      case 0:
       return _b_;
      case 1:
       return _c_;
      case 2:
       return _d_;
      case 3:
       return _e_;
      case 4:
       return _f_;
      case 5:
       return _g_;
      case 6:
       return _h_;
      default: return 0;
    }
   }
   var
    transparent = "transparent",
    native$0 = "native",
    Ending_type = [0, transparent, native$0],
    cst_type$1 = cst_type$4,
    cst_endings = "endings";
   function init$0(type, endings, param){
    var o = {};
    caml_call3(Jv[22][4], o, cst_type$1, type);
    caml_call3(Jv[22][4], o, cst_endings, endings);
    return o;
   }
   var
    blob = Jv[12]["Blob"],
    cst_size = "size",
    cst_type$2 = cst_type$4,
    cst_lengthComputable = "lengthComputable",
    cst_loaded = "loaded",
    cst_total = "total",
    _i_ = [0, 1],
    cst_lastModified = cst_lastModified$1;
   function of_jstr$0(opt, s){
    if(opt) var sth = opt[1], init = sth; else var init = Jv[5];
    var a = caml_call1(Jv[29][1], 1);
    a[0] = s;
    return new blob(a, init);
   }
   function of_array_buffer(opt, b){
    if(opt) var sth = opt[1], init = sth; else var init = Jv[5];
    return new blob(runtime.caml_js_from_array([0, b]), init);
   }
   function byte_length$1(b){return caml_call2(Jv[20][2], b, cst_size);}
   function type$3(b){return caml_call2(Jv[22][2], b, cst_type$2);}
   function slice$1(opt, stop, _h3_, b){
    if(opt) var sth = opt[1], start = sth; else var start = 0;
    if(_h3_) var sth$0 = _h3_[1], type = sth$0; else var type = Jstr[4];
    if(stop)
     var stop$0 = stop[1], stop$1 = stop$0;
    else
     var stop$1 = byte_length$1(b);
    return b.slice(start, stop$1, type);
   }
   function stream(b){return b["stream"];}
   function file_reader(progress$0, conv){
    function progress_data(e){
     if(! caml_call2(Jv[19][2], e, cst_lengthComputable)) return 0;
     var
      loaded = caml_call2(Jv[21][2], e, cst_loaded),
      total = caml_call2(Jv[21][2], e, cst_total);
     return [0, [0, loaded, total]];
    }
    var
     reader = new Jv[12]["FileReader"],
     match = caml_call1(Fut[1], 0),
     set_fut = match[2],
     fut = match[1];
    function ok(e){
     if(progress$0){
      var progress = progress$0[1];
      caml_call1(progress, progress_data(e));
     }
     return caml_call1(set_fut, [0, caml_call1(conv, reader["result"])]);
    }
    function error(e){return caml_call1(set_fut, [1, reader[cst_error$0]]);}
    var opts = listen_opts(0, _i_, 0, 0);
    listen([0, opts], load, ok, reader);
    listen([0, opts], error$0, error, reader);
    if(progress$0){
     var
      progress$1 = progress$0[1],
      progress$2 =
        function(e){return caml_call1(progress$1, progress_data(e));};
     listen(0, progress, progress$2, reader);
    }
    return [0, fut, reader];
   }
   function array_buffer$0(progress, b){
    if(progress){
     var
      match = file_reader(progress, function(_h2_){return _h2_;}),
      reader = match[2],
      fut = match[1];
     reader.readAsArrayBuffer(b);
     return fut;
    }
    var _h0_ = b.arrayBuffer();
    return caml_call2(Fut[11], function(_h1_){return _h1_;}, _h0_);
   }
   function text(progress, b){
    if(progress){
     var
      match = file_reader(progress, function(_hZ_){return _hZ_;}),
      reader = match[2],
      fut = match[1];
     reader.readAsText(b);
     return fut;
    }
    var _hX_ = b.text();
    return caml_call2(Fut[11], function(_hY_){return _hY_;}, _hX_);
   }
   function data_uri(progress, b){
    var
     match = file_reader(progress, function(_hW_){return _hW_;}),
     reader = match[2],
     fut = match[1];
    reader.readAsDataURL(b);
    return fut;
   }
   function init$1(blob_init, last_modified_ms, param){
    if(blob_init) var b = blob_init[1], o = b; else var o = {};
    caml_call3(Jv[20][4], o, cst_lastModified, last_modified_ms);
    return o;
   }
   var
    file$0 = Jv[12]["File"],
    cst_name$0 = cst_name$2,
    cst_webkitRelativePath = "webkitRelativePath",
    cst_lastModified$0 = cst_lastModified$1;
   function of_blob(opt, name, b){
    if(opt) var sth = opt[1], init = sth; else var init = {};
    return new file$0(b, name, init);
   }
   function name(f){return caml_call2(Jv[22][2], f, cst_name$0);}
   function relative_path(f){
    var
     p =
       caml_call3
        (Jv[14], function(_hV_){return _hV_;}, f, cst_webkitRelativePath);
    return caml_call2(Stdlib_Option[3], p, Jstr[4]);
   }
   function last_modified_ms(f){
    return caml_call2(Jv[20][2], f, cst_lastModified$0);
   }
   function data_utf_8_of_jstr(s){return to_binary_jstr(of_jstr(s));}
   function data_utf_8_to_jstr(d){
    var e = of_binary_jstr(d);
    if(0 !== e[0]) return e;
    var t = e[1];
    return to_jstr(t);
   }
   function data_of_binary_jstr(_hU_){return _hU_;}
   function data_to_binary_jstr(_hT_){return _hT_;}
   function encode(bs){
    try{var v = Jv[12]["btoa"](bs);}
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
    return [0, v];
   }
   function decode(s){
    try{var v = Jv[12]["atob"](s);}
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
    return [0, v];
   }
   var
    Base64 =
      [0,
       data_utf_8_of_jstr,
       data_utf_8_to_jstr,
       data_of_binary_jstr,
       data_to_binary_jstr,
       encode,
       decode],
    json = Jv[12]["JSON"];
   function encode$0(v){return json.stringify(v);}
   function decode$0(s){
    try{var v = json.parse(s);}
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
    return [0, v];
   }
   var
    encode$1 = Jv[12]["encodeURI"],
    decode$1 = Jv[12]["decodeURI"],
    encode_component = Jv[12]["encodeURIComponent"],
    decode_component = Jv[12]["decodeURIComponent"],
    url = Jv[12]["URL"],
    cst_protocol = cst_protocol$1,
    cst_hostname = cst_hostname$1,
    cst_port = cst_port$1,
    cst_pathname = cst_pathname$1,
    cst_search = cst_search$2,
    cst_hash = cst_hash$2,
    cst_protocol$0 = cst_protocol$1,
    _j_ = [0, -1],
    cst_hostname$0 = cst_hostname$1,
    cst_port$0 = cst_port$1;
   function v(base, s){
    if(! base) return new url(s);
    var b = base[1];
    return new url(s, b);
   }
   function with_uri(scheme, host, port, path, query, fragment, u){
    var u$0 = new url(u);
    try{
     caml_call3(Jv[22][4], u$0, cst_protocol, scheme);
     caml_call3(Jv[22][4], u$0, cst_hostname, host);
     if(port){
      var
       p = port[1],
       arg = Jstr[33],
       _hR_ =
         caml_call2
          (Stdlib_Option[7],
           function(eta){return caml_call2(arg, 0, eta);},
           p);
      caml_call3(Jv[22][4], u$0, cst_port, _hR_);
     }
     caml_call3(Jv[22][4], u$0, cst_pathname, path);
     caml_call3(Jv[22][4], u$0, cst_search, query);
     caml_call3(Jv[22][4], u$0, cst_hash, fragment);
     var _hS_ = [0, u$0];
     return _hS_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
   }
   function scheme(u){
    var p = caml_call2(Jv[22][2], u, cst_protocol$0);
    return 0 === caml_call1(Jstr[1], p) ? p : caml_call3(Jstr[15], 0, _j_, p);
   }
   function host(u){return caml_call2(Jv[22][2], u, cst_hostname$0);}
   function port(u){
    var p = caml_call2(Jv[22][2], u, cst_port$0);
    return caml_call1(Jstr[24], p) ? 0 : caml_call2(Jstr[32], 0, p);
   }
   var
    prefix = "/",
    cst_pathname$0 = cst_pathname$1,
    cst_search$0 = cst_search$2,
    _k_ = [0, 1],
    cst_hash$0 = cst_hash$2,
    _l_ = [0, 1],
    _m_ = [0, 1];
   function path(u){return caml_call2(Jv[22][2], u, cst_pathname$0);}
   function query(u){
    var q = caml_call2(Jv[22][2], u, cst_search$0);
    return caml_call1(Jstr[24], q) ? q : caml_call3(Jstr[15], _k_, 0, q);
   }
   function fragment(u){
    var f = caml_call2(Jv[22][2], u, cst_hash$0);
    return caml_call1(Jstr[24], f) ? f : caml_call3(Jstr[15], _l_, 0, f);
   }
   function path_segments(u){
    function decode_seg(s){return decode_component(s);}
    try{
     var
      p = path(u),
      p$0 =
        caml_call2(Jstr[25], prefix, p) ? caml_call3(Jstr[15], _m_, 0, p) : p,
      _hP_ = caml_call2(Jstr[17], prefix, p$0),
      _hQ_ = [0, caml_call2(Stdlib_List[20], decode_seg, _hP_)];
     return _hQ_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
   }
   function with_path_segments(u, segs){
    function encode_seg(s){
     var _hO_ = encode_component(s);
     return caml_call2(Jstr[7], prefix, _hO_);
    }
    try{
     var
      u$0 = new url(u),
      _hM_ = caml_call2(Stdlib_List[20], encode_seg, segs),
      path = caml_call2(Jstr[9], 0, _hM_);
     u$0[cst_pathname$1] = path;
     var _hN_ = [0, u$0];
     return _hN_;
    }
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
   }
   var
    usp = Jv[12]["URLSearchParams"],
    cst_search$1 = cst_search$2,
    cst_hash$1 = cst_hash$2;
   function is_empty(p){
    var _hK_ = p.entries(), _hL_ = caml_call1(Jv[33][6], _hK_);
    return caml_call1(Jv[33][1], _hL_);
   }
   function mem(k, p){return p.has(k) | 0;}
   function find$0(k, p){
    var _hI_ = p.get(k);
    return caml_call2(Jv[10], function(_hJ_){return _hJ_;}, _hI_);
   }
   function find_all(k, p){return caml_list_of_js_array(p.getAll(k));}
   function fold(f, p, acc){
    function key(_hH_){return _hH_;}
    function value(_hG_){return _hG_;}
    var _hF_ = p.entries();
    return caml_call5(Jv[33][8], key, value, f, _hF_, acc);
   }
   function of_jstr$1(s){return new usp(s);}
   function to_jstr$0(p){return p.toString();}
   function of_assoc(l){
    var p = of_jstr$1(Jstr[4]);
    caml_call2
     (Stdlib_List[18],
      function(param){
       var v = param[2], k = param[1];
       p.append(k, v);
       return 0;
      },
      l);
    return p;
   }
   function to_assoc(p){
    var _hE_ = fold(function(k, v, acc){return [0, [0, k, v], acc];}, p, 0);
    return caml_call1(Stdlib_List[10], _hE_);
   }
   function of_obj(o){return new usp(o);}
   function query_params(u){return of_jstr$1(query(u));}
   function with_query_params(u, ps){
    var u$0 = new url(u), _hD_ = ps.toString();
    caml_call3(Jv[22][3], u$0, cst_search$1, _hD_);
    return u$0;
   }
   function fragment_params(u){return of_jstr$1(fragment(u));}
   function with_fragment_params(u, ps){
    var u$0 = new url(u), _hC_ = ps.toString();
    caml_call3(Jv[22][3], u$0, cst_hash$1, _hC_);
    return u$0;
   }
   function to_jstr$1(u){return u.toString();}
   function of_jstr$2(base, s){
    try{var v$0 = v(base, s);}
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
    return [0, v$0];
   }
   function code$0(f, s){
    try{var v = f(s);}
    catch(exn$0){
     var exn = caml_wrap_exception(exn$0);
     if(exn[1] !== Jv[31]) throw caml_maybe_attach_backtrace(exn, 0);
     var e = exn[2];
     return [1, e];
    }
    return [0, v];
   }
   function encode$2(s){return code$0(encode$1, s);}
   function decode$2(s){return code$0(decode$1, s);}
   function encode_component$0(s){return code$0(encode_component, s);}
   function decode_component$0(s){return code$0(decode_component, s);}
   function v$0(n, v){return [0, n, v];}
   var void$0 = [0, Jstr[4], Jstr[4]];
   function is_void(param){
    var v = param[2], n = param[1], _hB_ = caml_call1(Jstr[24], n);
    return _hB_ ? caml_call1(Jstr[24], v) : _hB_;
   }
   function if$0(b, at){return b ? at : void$0;}
   function if_some(param){
    if(! param) return void$0;
    var at = param[1];
    return at;
   }
   function true$0(n){return [0, n, Jstr[4]];}
   function int$0(n, i){return [0, n, caml_call2(Jstr[33], 0, i)];}
   function float$0(n, f){return [0, n, caml_call2(Jstr[35], 0, f)];}
   function to_pair(_hA_){return _hA_;}
   function add_if(b, at, l){return b ? [0, at, l] : l;}
   function add_if_some(name, o, l){
    if(! o) return l;
    var a = o[1];
    return [0, [0, name, a], l];
   }
   var
    accesskey = "accesskey",
    action = "action",
    autocomplete = "autocomplete",
    autofocus = "autofocus",
    charset = "charset",
    checked = cst_checked,
    class$0 = "class",
    cols = "cols",
    content = "content",
    contenteditable = "contenteditable",
    defer = "defer",
    dir = cst_dir$0,
    disabled = "disabled",
    draggable = "draggable",
    for$0 = "for",
    height$0 = cst_height$1,
    hidden = cst_hidden,
    href = "href",
    id$0 = cst_id,
    lang = "lang",
    list = "list",
    media = "media",
    method = "method",
    name$0 = cst_name$2,
    placeholder = "placeholder",
    rel = "rel",
    required = "required",
    rows = "rows",
    selected = "selected",
    spellcheck = "spellcheck",
    src = "src",
    style = cst_style,
    tabindex = "tabindex",
    title = cst_title$1,
    type$4 = cst_type$4,
    value = cst_value,
    width$0 = cst_width$1,
    wrap = "wrap",
    Name =
      [0,
       accesskey,
       action,
       autocomplete,
       autofocus,
       charset,
       checked,
       class$0,
       cols,
       content,
       contenteditable,
       defer,
       dir,
       disabled,
       draggable,
       for$0,
       height$0,
       hidden,
       href,
       id$0,
       lang,
       list,
       media,
       method,
       name$0,
       placeholder,
       rel,
       required,
       rows,
       selected,
       spellcheck,
       src,
       style,
       tabindex,
       title,
       type$4,
       value,
       width$0,
       wrap];
   function accesskey$0(s){return [0, Name[1], s];}
   function action$0(s){return [0, Name[2], s];}
   function autocomplete$0(s){return [0, Name[3], s];}
   var autofocus$0 = true$0(Name[4]), _n_ = Name[5];
   function charset$0(_hz_){return [0, _n_, _hz_];}
   var checked$0 = true$0(Name[6]);
   function class$1(s){return [0, Name[7], s];}
   function cols$0(i){return int$0(Name[8], i);}
   function content$0(s){return [0, Name[9], s];}
   function contenteditable$0(s){return true$0(Name[10]);}
   var defer$0 = true$0(Name[11]);
   function dir$0(s){return [0, Name[12], s];}
   var disabled$0 = true$0(Name[13]);
   function draggable$0(s){return true$0(Name[14]);}
   function for$1(s){return [0, Name[15], s];}
   function height$1(i){return int$0(Name[16], i);}
   var hidden$0 = true$0(Name[17]);
   function href$0(s){return [0, Name[18], s];}
   function id$1(s){return [0, Name[19], s];}
   function lang$0(s){return [0, Name[20], s];}
   function list$0(s){return [0, Name[21], s];}
   function media$0(s){return [0, Name[22], s];}
   function method$0(s){return [0, Name[23], s];}
   function name$1(s){return [0, Name[24], s];}
   function placeholder$0(s){return [0, Name[25], s];}
   function rel$0(s){return [0, Name[26], s];}
   var required$0 = true$0(Name[27]);
   function rows$0(i){return int$0(Name[28], i);}
   var selected$0 = true$0(Name[29]), _o_ = Name[30];
   function spellcheck$0(_hy_){return [0, _o_, _hy_];}
   function src$0(s){return [0, Name[31], s];}
   function style$0(s){return [0, Name[32], s];}
   function tabindex$0(i){return int$0(Name[33], i);}
   function title$0(s){return [0, Name[34], s];}
   function type$5(s){return [0, Name[35], s];}
   function value$0(s){return [0, Name[36], s];}
   function width$1(i){return int$0(Name[37], i);}
   function wrap$0(s){return [0, Name[36], s];}
   var global_document = Jv[12]["document"];
   function document(e){return e[cst_ownerDocument];}
   var
    cst_timeOrigin = "timeOrigin",
    cst_redirectCount = "redirectCount",
    cst_type$3 = "type'",
    cst_loadEventEnd = "loadEventEnd",
    cst_loadEventStart = "loadEventStart",
    cst_domComplete = "domComplete",
    cst_domContentLoadedEventEnd = "domContentLoadedEventEnd",
    cst_domContentLoadedEventStart = "domContentLoadedEventStart",
    cst_domInteractive = "domInteractive",
    cst_unloadEventEnd = "unloadEventEnd",
    cst_unloadEventStart = "unloadEventStart",
    cst_decodedBodySize = "decodedBodySize",
    cst_encodedBodySize = "encodedBodySize",
    cst_transferSize = "transferSize",
    cst_responseEnd = "responseEnd",
    cst_responseStart = "responseStart",
    cst_requestStart = "requestStart",
    cst_secureConnectionStart = "secureConnectionStart",
    cst_connectEnd = "connectEnd",
    cst_connectStart = "connectStart",
    cst_domainLookupEnd = "domainLookupEnd",
    cst_domainLookupStart = "domainLookupStart",
    cst_fetchStart = "fetchStart",
    cst_redirectEnd = "redirectEnd",
    cst_redirectStart = "redirectStart",
    cst_workerStart = "workerStart",
    cst_nextHopProtocol = "nextHopProtocol",
    cst_initiatorType = "initiatorType",
    cst_duration = "duration",
    cst_endTime = "endTime",
    cst_startTime = "startTime",
    cst_entryType = "entryType",
    cst_name$1 = cst_name$2,
    cst_onLine = "onLine",
    cst_languages = "languages",
    cst_language = "language",
    cst_scrollRestoration$0 = cst_scrollRestoration$1,
    cst_scrollRestoration = cst_scrollRestoration$1,
    cst_length$3 = cst_length$4,
    cst_matches = "matches",
    cst_devicePixelRatio = "devicePixelRatio",
    cst_scrollY = "scrollY",
    cst_scrollX = "scrollX",
    cst_closed = "closed",
    cst_timeStamp$0 = cst_timeStamp$1,
    cst_profileEnd = "profileEnd",
    cst_profile = "profile",
    cst_timeEnd = "timeEnd",
    cst_timeLog = "timeLog",
    cst_time = cst_time$0,
    cst_countReset = "countReset",
    cst_count = "count",
    cst_groupCollapsed = "groupCollapsed",
    cst_group = "group",
    cst_groupEnd = "groupEnd",
    cst_table = cst_table$0,
    cst_dir = cst_dir$0,
    cst_assert = "assert",
    cst_debug = "debug",
    cst_info = "info",
    cst_warn = "warn",
    cst_error = cst_error$0,
    cst_trace = "trace",
    cst_log = "log",
    cst_clear = cst_clear$0,
    cst_aborted = "aborted",
    cst_fullscreenEnabled = "fullscreenEnabled",
    cst_visibilityState = "visibilityState",
    cst_title$0 = cst_title$1,
    cst_title = cst_title$1,
    cst_referrer = "referrer",
    cst_files = "files",
    cst_navigationUI = "navigationUI",
    _r_ = [0, 0],
    _q_ = [0, 1],
    cst_scrollHeight = "scrollHeight",
    cst_scrollWidth = "scrollWidth",
    cst_scrollTop = "scrollTop",
    cst_scrollLeft = "scrollLeft",
    cst_height$0 = cst_height$1,
    cst_width$0 = cst_width$1,
    cst_y = "y",
    cst_x = "x",
    cst_clientHeight = "clientHeight",
    cst_clientWidth = "clientWidth",
    cst_clientTop = "clientTop",
    cst_clientLeft = "clientLeft",
    cst_nextElementSibling = "nextElementSibling",
    cst_previousElementSibling = "previousElementSibling",
    cst_parentNode = "parentNode",
    cst_length$2 = cst_length$4,
    cst_nodeValue = "nodeValue",
    cst_nodeName = "nodeName",
    cst_nodeType$0 = cst_nodeType$1,
    cst_nodeType = cst_nodeType$1,
    cst_length$1 = cst_length$4,
    cst_isSecureContext = "isSecureContext",
    global_root =
      caml_call1(Jv[8], global_document)
       ? Jv[5]
       : global_document[cst_documentElement];
   function el_list_of_node_list(nl){
    var
     acc = [0, 0],
     len = caml_call2(Jv[20][2], nl, cst_length$1),
     _hv_ = len - 1 | 0;
    if(_hv_ >= 0){
     var i = _hv_;
     for(;;){
      var _hw_ = acc[1];
      acc[1] = [0, nl[i], _hw_];
      var _hx_ = i - 1 | 0;
      if(0 === i) break;
      var i = _hx_;
     }
    }
    return acc[1];
   }
   function _p_(e, n){e.appendChild(n); return 0;}
   function v$1(opt, _ht_, name, cs){
    if(opt) var sth = opt[1], d = sth; else var d = global_document;
    if(_ht_) var sth$0 = _ht_[1], at$0 = sth$0; else var at$0 = 0;
    var e = d.createElement(name), ss = 0, param = at$0;
    for(;;){
     if(! param) break;
     var at = param[2], match = param[1], v = match[2], a = match[1];
     if(caml_call1(Jstr[24], a))
      var param = at;
     else if(caml_call2(Jstr[28], a, Name[32]))
      var ss$0 = [0, v, ss], ss = ss$0, param = at;
     else if(caml_call2(Jstr[28], a, Name[7])){
      if(1 - caml_call1(Jstr[24], v)) e[cst_classList].add(v);
      var param = at;
     }
     else{e.setAttribute(a, v); var param = at;}
    }
    if(0 !== ss){
     var
      a$0 = Name[32],
      _hs_ = caml_call1(Stdlib_List[10], ss),
      v$0 = caml_call2(Jstr[9], [0, ";"], _hs_);
     e.setAttribute(a$0, v$0);
    }
    caml_call2(Stdlib_List[18], function(_hu_){return _p_(e, _hu_);}, cs);
    return e;
   }
   function txt(opt, s){
    if(opt) var sth = opt[1], d = sth; else var d = global_document;
    return d.createTextNode(s);
   }
   function txt$0(opt, s){
    if(opt) var sth = opt[1], d = sth; else var d = global_document;
    return d.createTextNode(caml_call1(Jv[23], s));
   }
   function sp(opt, param){return txt(0, " ");}
   function nbsp(opt, param){return txt(0, " ");}
   function is_txt(e){
    return 3 === caml_call2(Jv[20][2], e, cst_nodeType) ? 1 : 0;
   }
   function is_el(e){
    return 1 === caml_call2(Jv[20][2], e, cst_nodeType$0) ? 1 : 0;
   }
   function tag_name(e){
    var _hr_ = caml_call2(Jv[22][2], e, cst_nodeName);
    return caml_call1(Jstr[22], _hr_);
   }
   function has_tag_name(n, e){
    var _hq_ = tag_name(e);
    return caml_call2(Jstr[28], n, _hq_);
   }
   function txt_text(txt){
    return is_txt(txt) ? caml_call2(Jv[22][2], txt, cst_nodeValue) : Jstr[4];
   }
   function find_by_class(opt, c){
    if(opt) var sth = opt[1], root = sth; else var root = global_root;
    return el_list_of_node_list(root.getElementsByClassName(c));
   }
   function find_by_tag_name(opt, n){
    if(opt) var sth = opt[1], root = sth; else var root = global_root;
    return el_list_of_node_list(root.getElementsByTagName(n));
   }
   function find_first_by_selector(opt, sel){
    if(opt) var sth = opt[1], root = sth; else var root = global_root;
    var _ho_ = root.querySelector(sel);
    return caml_call1(caml_call1(Jv[10], function(_hp_){return _hp_;}), _ho_);
   }
   function fold_find_by_selector(opt, f, sel, acc){
    if(opt) var sth = opt[1], root = sth; else var root = global_root;
    var
     nl = root.querySelectorAll(sel),
     acc$0 = [0, acc],
     _hl_ = caml_call2(Jv[20][2], nl, cst_length$2) - 1 | 0,
     _hk_ = 0;
    if(_hl_ >= 0){
     var i = _hk_;
     for(;;){
      var _hm_ = acc$0[1];
      acc$0[1] = caml_call2(f, nl[i], _hm_);
      var _hn_ = i + 1 | 0;
      if(_hl_ === i) break;
      var i = _hn_;
     }
    }
    return acc$0[1];
   }
   function parent(e){
    var match = caml_call2(Jv[13], e, cst_parentNode);
    if(match){var e$0 = match[1]; if(is_el(e$0)) return [0, e$0];}
    return 0;
   }
   function children(opt, e){
    if(opt) var sth = opt[1], only_els = sth; else var only_els = 0;
    return only_els
            ? el_list_of_node_list(e["children"])
            : el_list_of_node_list(e["childNodes"]);
   }
   function set_children(e, l){
    for(;;){
     var _hi_ = e[cst_firstChild];
     if(caml_call1(Jv[6], _hi_)) break;
     e.removeChild(e[cst_firstChild]);
    }
    return caml_call2
            (Stdlib_List[18], function(_hj_){return _p_(e, _hj_);}, l);
   }
   function prepend_children(e, l){
    caml_js_meth_call(e, "prepend", caml_call1(Stdlib_Array[10], l));
    return 0;
   }
   function append_children(e, l){
    caml_js_meth_call(e, cst_append, caml_call1(Stdlib_Array[10], l));
    return 0;
   }
   function previous_sibling(e){
    return caml_call2(Jv[13], e, cst_previousElementSibling);
   }
   function next_sibling(e){
    return caml_call2(Jv[13], e, cst_nextElementSibling);
   }
   function insert_siblings(loc, e, l){
    if(-126259180 === loc)
     caml_js_meth_call(e, "replaceWith", caml_call1(Stdlib_Array[10], l));
    else if(818927100 <= loc)
     caml_js_meth_call(e, "after", caml_call1(Stdlib_Array[10], l));
    else
     caml_js_meth_call(e, "before", caml_call1(Stdlib_Array[10], l));
    return 0;
   }
   function remove$0(e){e.remove(e); return 0;}
   function at(a, e){
    var _hg_ = e.getAttribute(a);
    return caml_call2(Jv[10], function(_hh_){return _hh_;}, _hg_);
   }
   function set_at(a, v, e){
    if(caml_call1(Jstr[24], a)) return 0;
    if(v){var v$0 = v[1]; e.setAttribute(a, v$0); return 0;}
    e.removeAttribute(a);
    return 0;
   }
   function jv_to_bool(b){return caml_call1(Jv[7], b) ? 0 : b | 0;}
   function jv_to_int(i){return caml_call1(Jv[7], i) ? 0 : i;}
   function jv_to_float(f){return caml_call1(Jv[7], f) ? 0. : f;}
   function jv_to_jstr(s){return caml_call1(Jv[7], s) ? Jstr[4] : s;}
   function bool(n){return [0, n, jv_to_bool, caml_js_from_bool];}
   function int$1(n){return [0, n, jv_to_int, function(_hf_){return _hf_;}];}
   function float$1(n){
    return [0, n, jv_to_float, function(_he_){return _he_;}];
   }
   function jstr(n){return [0, n, jv_to_jstr, function(_hd_){return _hd_;}];}
   var
    checked$1 = bool(cst_checked),
    height$2 = int$1(cst_height$1),
    id$2 = jstr(cst_id),
    name$2 = jstr(cst_name$2),
    title$1 = jstr(cst_title$1),
    value$1 = jstr(cst_value),
    width$2 = int$1(cst_width$1);
   function prop(p, e){var _hc_ = e[p[1]]; return caml_call1(p[2], _hc_);}
   function set_prop(p, v, e){
    var _hb_ = caml_call1(p[3], v);
    e[p[1]] = _hb_;
    return 0;
   }
   function class$2(c, e){return e[cst_classList].contains(c) | 0;}
   function set_class(c, b, e){
    return b ? (e[cst_classList].add(c), 0) : (e[cst_classList].remove(c), 0);
   }
   var
    background_color = "background-color",
    bottom = "bottom",
    color = "color",
    cursor = "cursor",
    display = "display",
    height$3 = cst_height$1,
    left = "left",
    position = "position",
    right = "right",
    top = "top",
    visibility = "visibility",
    width$3 = cst_width$1,
    z_index = "z-index",
    Style =
      [0,
       background_color,
       bottom,
       color,
       cursor,
       display,
       height$3,
       left,
       position,
       right,
       top,
       visibility,
       width$3,
       z_index];
   function computed_style(opt, p, e){
    if(opt) var sth = opt[1], w = sth; else var w = Jv[12][cst_window];
    var style = w.getComputedStyle(e), v = style[p];
    return caml_call1(Jv[8], v) ? Jstr[4] : v;
   }
   function inline_style(p, e){
    var style = e[cst_style];
    if(caml_call1(Jv[8], style)) return Jstr[4];
    var v = style[p];
    return caml_call1(Jv[8], v) ? Jstr[4] : v;
   }
   function set_inline_style(opt, p, v, e){
    if(opt) var sth = opt[1], important = sth; else var important = 0;
    var priority = important ? "important" : Jstr[4], style = e[cst_style];
    return caml_call1(Jv[8], style)
            ? 0
            : (style.setProperty(p, v, priority), 0);
   }
   function remove_inline_style(p, e){
    var style = e[cst_style];
    return caml_call1(Jv[8], style) ? 0 : (style.removeProperty(p), 0);
   }
   function inner_x(e){return caml_call2(Jv[21][2], e, cst_clientLeft);}
   function inner_y(e){return caml_call2(Jv[21][2], e, cst_clientTop);}
   function inner_w(e){return caml_call2(Jv[21][2], e, cst_clientWidth);}
   function inner_h(e){return caml_call2(Jv[21][2], e, cst_clientHeight);}
   function bound_x(e){
    var _ha_ = e.getBoundingClientRect();
    return caml_call2(Jv[21][2], _ha_, cst_x);
   }
   function bound_y(e){
    var _g$_ = e.getBoundingClientRect();
    return caml_call2(Jv[21][2], _g$_, cst_y);
   }
   function bound_w(e){
    var _g__ = e.getBoundingClientRect();
    return caml_call2(Jv[21][2], _g__, cst_width$0);
   }
   function bound_h(e){
    var _g9_ = e.getBoundingClientRect();
    return caml_call2(Jv[21][2], _g9_, cst_height$0);
   }
   function scroll_x(e){return caml_call2(Jv[21][2], e, cst_scrollLeft);}
   function scroll_y(e){return caml_call2(Jv[21][2], e, cst_scrollTop);}
   function scroll_w(e){return caml_call2(Jv[21][2], e, cst_scrollWidth);}
   function scroll_h(e){return caml_call2(Jv[21][2], e, cst_scrollHeight);}
   function scroll_into_view(opt, e){
    if(opt) var sth = opt[1], align_v = sth; else var align_v = 389604418;
    var align = 389604418 <= align_v ? 1 : 0;
    e.scrollIntoView(! ! align);
    return 0;
   }
   function has_focus(e){
    var
     _g7_ = e[cst_ownerDocument][cst_activeElement],
     match = caml_call2(Jv[10], function(_g8_){return _g8_;}, _g7_);
    if(! match) return 0;
    var e$0 = match[1];
    return e === e$0 ? 1 : 0;
   }
   function set_has_focus(b, e){if(b) e.focus(); else e.blur(); return 0;}
   function is_locking_pointer(e){
    var
     _g5_ = e[cst_ownerDocument][cst_pointerLockElement],
     match = caml_call2(Jv[10], function(_g6_){return _g6_;}, _g5_);
    if(! match) return 0;
    var e$0 = match[1];
    return e === e$0 ? 1 : 0;
   }
   function request_pointer_lock(e){
    var
     match = caml_call1(Fut[1], 0),
     set = match[2],
     fut = match[1],
     d = e[cst_ownerDocument],
     opts = listen_opts(0, _q_, 0, 0),
     unlisten$0 = [0, function(param){return 0;}];
    function locked(ev){
     caml_call1(set, _r_);
     return caml_call1(unlisten$0[1], 0);
    }
    function error(ev){
     var err = caml_call2(Jv[30][1], 0, "Could not lock pointer");
     caml_call1(set, [1, err]);
     return caml_call1(unlisten$0[1], 0);
    }
    var
     k = listen([0, opts], pointerlockchange, locked, d),
     k$0 = listen([0, opts], pointerlockerror, error, d);
    unlisten$0[1] = function(param){unlisten(k); return unlisten(k$0);};
    e.requestPointerLock();
    return fut;
   }
   function click$0(e){e.click(); return 0;}
   function select_text(e){e.select(); return 0;}
   var
    auto = cst_auto,
    hide = "hide",
    show = "show",
    Navigation_ui = [0, auto, hide, show];
   function fullscreen_opts(navigation_ui, param){
    var o = {};
    caml_call3(Jv[22][4], o, cst_navigationUI, navigation_ui);
    return o;
   }
   function request_fullscreen(opt, e){
    if(opt) var sth = opt[1], opts = sth; else var opts = {};
    var _g3_ = e.requestFullscreen(opts);
    return caml_call1(caml_call1(Fut[11], function(_g4_){return 0;}), _g3_);
   }
   function files(e){
    var match = caml_call2(Jv[13], e, cst_files);
    if(! match) return 0;
    var files = match[1];
    return caml_call2(Jv[27], function(_g2_){return _g2_;}, files);
   }
   var
    Input$0 = [0, files],
    a = "a",
    abbr = "abbr",
    address = "address",
    area = "area",
    article = "article",
    aside = "aside",
    audio = "audio",
    b = "b",
    base = "base",
    bdi = "bdi",
    bdo = "bdo",
    blockquote = "blockquote",
    body = cst_body,
    br = "br",
    button$0 = cst_button$0,
    canvas = "canvas",
    caption = "caption",
    cite = "cite",
    code$1 = cst_code$0,
    col = "col",
    colgroup = "colgroup",
    command = "command",
    datalist = "datalist",
    dd = "dd",
    del = "del",
    details = "details",
    dfn = "dfn",
    div = "div",
    dl = "dl",
    dt = "dt",
    em = "em",
    embed = "embed",
    fieldset = "fieldset",
    figcaption = "figcaption",
    figure = "figure",
    footer = "footer",
    form = "form",
    h1 = "h1",
    h2 = "h2",
    h3 = "h3",
    h4 = "h4",
    h5 = "h5",
    h6 = "h6",
    head = cst_head,
    header = "header",
    hgroup = "hgroup",
    hr = "hr",
    html = "html",
    i = "i",
    iframe = "iframe",
    img = "img",
    input$0 = cst_input,
    ins = "ins",
    kbd = "kbd",
    keygen = "keygen",
    label = "label",
    legend = "legend",
    li = "li",
    link$0 = cst_link,
    map$0 = cst_map,
    mark = cst_mark,
    menu = "menu",
    meta = "meta",
    meter = "meter",
    nav = "nav",
    noscript = "noscript",
    object = "object",
    ol = "ol",
    optgroup = "optgroup",
    option = "option",
    output = "output",
    p = "p",
    pre = "pre",
    progress$0 = cst_progress,
    q = "q",
    rp = "rp",
    rt = "rt",
    ruby = "ruby",
    s = "s",
    samp = "samp",
    script = "script",
    section = "section",
    select$0 = cst_select,
    small = "small",
    source = "source",
    span = "span",
    strong = "strong",
    style$1 = cst_style,
    sub$0 = "sub",
    summary = "summary",
    sup = "sup",
    table = cst_table$0,
    tbody = "tbody",
    td = "td",
    textarea = "textarea",
    tfoot = "tfoot",
    th = "th",
    thead = "thead",
    time = cst_time$0,
    title$2 = cst_title$1,
    tr = "tr",
    track = "track",
    u = "u",
    ul = "ul",
    var$0 = "var",
    video = "video",
    wbr = "wbr",
    Name$0 =
      [0,
       a,
       abbr,
       address,
       area,
       article,
       aside,
       audio,
       b,
       base,
       bdi,
       bdo,
       blockquote,
       body,
       br,
       button$0,
       canvas,
       caption,
       cite,
       code$1,
       col,
       colgroup,
       command,
       datalist,
       dd,
       del,
       details,
       dfn,
       div,
       dl,
       dt,
       em,
       embed,
       fieldset,
       figcaption,
       figure,
       footer,
       form,
       h1,
       h2,
       h3,
       h4,
       h5,
       h6,
       head,
       header,
       hgroup,
       hr,
       html,
       i,
       iframe,
       img,
       input$0,
       ins,
       kbd,
       keygen,
       label,
       legend,
       li,
       link$0,
       map$0,
       mark,
       menu,
       meta,
       meter,
       nav,
       noscript,
       object,
       ol,
       optgroup,
       option,
       output,
       p,
       "param",
       pre,
       progress$0,
       q,
       rp,
       rt,
       ruby,
       s,
       samp,
       script,
       section,
       select$0,
       small,
       source,
       span,
       strong,
       style$1,
       sub$0,
       summary,
       sup,
       table,
       tbody,
       td,
       textarea,
       tfoot,
       th,
       thead,
       time,
       title$2,
       tr,
       track,
       u,
       ul,
       var$0,
       video,
       wbr];
   function cons(name, d, at, cs){return v$1(d, at, name, cs);}
   function void_cons(name, d, at, param){return v$1(d, at, name, 0);}
   var _s_ = Name$0[1];
   function a$0(_gZ_, _g0_, _g1_){return cons(_s_, _gZ_, _g0_, _g1_);}
   var _t_ = Name$0[2];
   function abbr$0(_gW_, _gX_, _gY_){return cons(_t_, _gW_, _gX_, _gY_);}
   var _u_ = Name$0[3];
   function address$0(_gT_, _gU_, _gV_){return cons(_u_, _gT_, _gU_, _gV_);}
   var _v_ = Name$0[4];
   function area$0(_gQ_, _gR_, _gS_){return void_cons(_v_, _gQ_, _gR_, _gS_);}
   var _w_ = Name$0[5];
   function article$0(_gN_, _gO_, _gP_){return cons(_w_, _gN_, _gO_, _gP_);}
   var _x_ = Name$0[6];
   function aside$0(_gK_, _gL_, _gM_){return cons(_x_, _gK_, _gL_, _gM_);}
   var _y_ = Name$0[7];
   function audio$0(_gH_, _gI_, _gJ_){return cons(_y_, _gH_, _gI_, _gJ_);}
   var _z_ = Name$0[8];
   function b$0(_gE_, _gF_, _gG_){return cons(_z_, _gE_, _gF_, _gG_);}
   var _A_ = Name$0[9];
   function base$0(_gB_, _gC_, _gD_){return void_cons(_A_, _gB_, _gC_, _gD_);}
   var _B_ = Name$0[10];
   function bdi$0(_gy_, _gz_, _gA_){return cons(_B_, _gy_, _gz_, _gA_);}
   var _C_ = Name$0[11];
   function bdo$0(_gv_, _gw_, _gx_){return cons(_C_, _gv_, _gw_, _gx_);}
   var _D_ = Name$0[12];
   function blockquote$0(_gs_, _gt_, _gu_){return cons(_D_, _gs_, _gt_, _gu_);
   }
   var _E_ = Name$0[13];
   function body$0(_gp_, _gq_, _gr_){return cons(_E_, _gp_, _gq_, _gr_);}
   var _F_ = Name$0[14];
   function br$0(_gm_, _gn_, _go_){return void_cons(_F_, _gm_, _gn_, _go_);}
   var _G_ = Name$0[15];
   function button$1(_gj_, _gk_, _gl_){return cons(_G_, _gj_, _gk_, _gl_);}
   var _H_ = Name$0[16];
   function canvas$0(_gg_, _gh_, _gi_){return cons(_H_, _gg_, _gh_, _gi_);}
   var _I_ = Name$0[17];
   function caption$0(_gd_, _ge_, _gf_){return cons(_I_, _gd_, _ge_, _gf_);}
   var _J_ = Name$0[18];
   function cite$0(_ga_, _gb_, _gc_){return cons(_J_, _ga_, _gb_, _gc_);}
   var _K_ = Name$0[19];
   function code$2(_f9_, _f__, _f$_){return cons(_K_, _f9_, _f__, _f$_);}
   var _L_ = Name$0[20];
   function col$0(_f6_, _f7_, _f8_){return void_cons(_L_, _f6_, _f7_, _f8_);}
   var _M_ = Name$0[21];
   function colgroup$0(_f3_, _f4_, _f5_){return cons(_M_, _f3_, _f4_, _f5_);}
   var _N_ = Name$0[22];
   function command$0(_f0_, _f1_, _f2_){return cons(_N_, _f0_, _f1_, _f2_);}
   var _O_ = Name$0[23];
   function datalist$0(_fX_, _fY_, _fZ_){return cons(_O_, _fX_, _fY_, _fZ_);}
   var _P_ = Name$0[24];
   function dd$0(_fU_, _fV_, _fW_){return cons(_P_, _fU_, _fV_, _fW_);}
   var _Q_ = Name$0[25];
   function del$0(_fR_, _fS_, _fT_){return cons(_Q_, _fR_, _fS_, _fT_);}
   var _R_ = Name$0[26];
   function details$0(_fO_, _fP_, _fQ_){return cons(_R_, _fO_, _fP_, _fQ_);}
   var _S_ = Name$0[27];
   function dfn$0(_fL_, _fM_, _fN_){return cons(_S_, _fL_, _fM_, _fN_);}
   var _T_ = Name$0[28];
   function div$0(_fI_, _fJ_, _fK_){return cons(_T_, _fI_, _fJ_, _fK_);}
   var _U_ = Name$0[29];
   function dl$0(_fF_, _fG_, _fH_){return cons(_U_, _fF_, _fG_, _fH_);}
   var _V_ = Name$0[30];
   function dt$0(_fC_, _fD_, _fE_){return cons(_V_, _fC_, _fD_, _fE_);}
   var _W_ = Name$0[31];
   function em$0(_fz_, _fA_, _fB_){return cons(_W_, _fz_, _fA_, _fB_);}
   var _X_ = Name$0[32];
   function embed$0(_fw_, _fx_, _fy_){
    return void_cons(_X_, _fw_, _fx_, _fy_);
   }
   var _Y_ = Name$0[33];
   function fieldset$0(_ft_, _fu_, _fv_){return cons(_Y_, _ft_, _fu_, _fv_);}
   var _Z_ = Name$0[34];
   function figcaption$0(_fq_, _fr_, _fs_){return cons(_Z_, _fq_, _fr_, _fs_);
   }
   var ___ = Name$0[35];
   function figure$0(_fn_, _fo_, _fp_){return cons(___, _fn_, _fo_, _fp_);}
   var _$_ = Name$0[36];
   function footer$0(_fk_, _fl_, _fm_){return cons(_$_, _fk_, _fl_, _fm_);}
   var _aa_ = Name$0[37];
   function form$0(_fh_, _fi_, _fj_){return cons(_aa_, _fh_, _fi_, _fj_);}
   var _ab_ = Name$0[38];
   function h1$0(_fe_, _ff_, _fg_){return cons(_ab_, _fe_, _ff_, _fg_);}
   var _ac_ = Name$0[39];
   function h2$0(_fb_, _fc_, _fd_){return cons(_ac_, _fb_, _fc_, _fd_);}
   var _ad_ = Name$0[40];
   function h3$0(_e__, _e$_, _fa_){return cons(_ad_, _e__, _e$_, _fa_);}
   var _ae_ = Name$0[41];
   function h4$0(_e7_, _e8_, _e9_){return cons(_ae_, _e7_, _e8_, _e9_);}
   var _af_ = Name$0[42];
   function h5$0(_e4_, _e5_, _e6_){return cons(_af_, _e4_, _e5_, _e6_);}
   var _ag_ = Name$0[43];
   function h6$0(_e1_, _e2_, _e3_){return cons(_ag_, _e1_, _e2_, _e3_);}
   var _ah_ = Name$0[44];
   function head$0(_eY_, _eZ_, _e0_){return cons(_ah_, _eY_, _eZ_, _e0_);}
   var _ai_ = Name$0[45];
   function header$0(_eV_, _eW_, _eX_){return cons(_ai_, _eV_, _eW_, _eX_);}
   var _aj_ = Name$0[46];
   function hgroup$0(_eS_, _eT_, _eU_){return cons(_aj_, _eS_, _eT_, _eU_);}
   var _ak_ = Name$0[47];
   function hr$0(_eP_, _eQ_, _eR_){return void_cons(_ak_, _eP_, _eQ_, _eR_);}
   var _al_ = Name$0[48];
   function html$0(_eM_, _eN_, _eO_){return cons(_al_, _eM_, _eN_, _eO_);}
   var _am_ = Name$0[49];
   function i$0(_eJ_, _eK_, _eL_){return cons(_am_, _eJ_, _eK_, _eL_);}
   var _an_ = Name$0[50];
   function iframe$0(_eG_, _eH_, _eI_){return cons(_an_, _eG_, _eH_, _eI_);}
   var _ao_ = Name$0[51];
   function img$0(_eD_, _eE_, _eF_){return void_cons(_ao_, _eD_, _eE_, _eF_);}
   var _ap_ = Name$0[52];
   function input$1(_eA_, _eB_, _eC_){
    return void_cons(_ap_, _eA_, _eB_, _eC_);
   }
   var _aq_ = Name$0[53];
   function ins$0(_ex_, _ey_, _ez_){return cons(_aq_, _ex_, _ey_, _ez_);}
   var _ar_ = Name$0[54];
   function kbd$0(_eu_, _ev_, _ew_){return cons(_ar_, _eu_, _ev_, _ew_);}
   var _as_ = Name$0[55];
   function keygen$0(_er_, _es_, _et_){return cons(_as_, _er_, _es_, _et_);}
   var _at_ = Name$0[56];
   function label$0(_eo_, _ep_, _eq_){return cons(_at_, _eo_, _ep_, _eq_);}
   var _au_ = Name$0[57];
   function legend$0(_el_, _em_, _en_){return cons(_au_, _el_, _em_, _en_);}
   var _av_ = Name$0[58];
   function li$0(_ei_, _ej_, _ek_){return cons(_av_, _ei_, _ej_, _ek_);}
   var _aw_ = Name$0[59];
   function link$1(_ef_, _eg_, _eh_){
    return void_cons(_aw_, _ef_, _eg_, _eh_);
   }
   var _ax_ = Name$0[60];
   function map$1(_ec_, _ed_, _ee_){return cons(_ax_, _ec_, _ed_, _ee_);}
   var _ay_ = Name$0[61];
   function mark$0(_d$_, _ea_, _eb_){return cons(_ay_, _d$_, _ea_, _eb_);}
   var _az_ = Name$0[62];
   function menu$0(_d8_, _d9_, _d__){return cons(_az_, _d8_, _d9_, _d__);}
   var _aA_ = Name$0[63];
   function meta$0(_d5_, _d6_, _d7_){
    return void_cons(_aA_, _d5_, _d6_, _d7_);
   }
   var _aB_ = Name$0[64];
   function meter$0(_d2_, _d3_, _d4_){return cons(_aB_, _d2_, _d3_, _d4_);}
   var _aC_ = Name$0[65];
   function nav$0(_dZ_, _d0_, _d1_){return cons(_aC_, _dZ_, _d0_, _d1_);}
   var _aD_ = Name$0[66];
   function noscript$0(_dW_, _dX_, _dY_){return cons(_aD_, _dW_, _dX_, _dY_);}
   var _aE_ = Name$0[67];
   function object$0(_dT_, _dU_, _dV_){return cons(_aE_, _dT_, _dU_, _dV_);}
   var _aF_ = Name$0[68];
   function ol$0(_dQ_, _dR_, _dS_){return cons(_aF_, _dQ_, _dR_, _dS_);}
   var _aG_ = Name$0[69];
   function optgroup$0(_dN_, _dO_, _dP_){return cons(_aG_, _dN_, _dO_, _dP_);}
   var _aH_ = Name$0[70];
   function option$0(_dK_, _dL_, _dM_){return cons(_aH_, _dK_, _dL_, _dM_);}
   var _aI_ = Name$0[71];
   function output$0(_dH_, _dI_, _dJ_){return cons(_aI_, _dH_, _dI_, _dJ_);}
   var _aJ_ = Name$0[72];
   function p$0(_dE_, _dF_, _dG_){return cons(_aJ_, _dE_, _dF_, _dG_);}
   var _aK_ = Name$0[73], _aL_ = Name$0[74];
   function pre$0(_dB_, _dC_, _dD_){return cons(_aL_, _dB_, _dC_, _dD_);}
   var _aM_ = Name$0[75];
   function progress$1(_dy_, _dz_, _dA_){return cons(_aM_, _dy_, _dz_, _dA_);}
   var _aN_ = Name$0[76];
   function q$0(_dv_, _dw_, _dx_){return cons(_aN_, _dv_, _dw_, _dx_);}
   var _aO_ = Name$0[77];
   function rp$0(_ds_, _dt_, _du_){return cons(_aO_, _ds_, _dt_, _du_);}
   var _aP_ = Name$0[78];
   function rt$0(_dp_, _dq_, _dr_){return cons(_aP_, _dp_, _dq_, _dr_);}
   var _aQ_ = Name$0[79];
   function ruby$0(_dm_, _dn_, _do_){return cons(_aQ_, _dm_, _dn_, _do_);}
   var _aR_ = Name$0[80];
   function s$0(_dj_, _dk_, _dl_){return cons(_aR_, _dj_, _dk_, _dl_);}
   var _aS_ = Name$0[81];
   function samp$0(_dg_, _dh_, _di_){return cons(_aS_, _dg_, _dh_, _di_);}
   var _aT_ = Name$0[82];
   function script$0(_dd_, _de_, _df_){return cons(_aT_, _dd_, _de_, _df_);}
   var _aU_ = Name$0[83];
   function section$0(_da_, _db_, _dc_){return cons(_aU_, _da_, _db_, _dc_);}
   var _aV_ = Name$0[84];
   function select$1(_c9_, _c__, _c$_){return cons(_aV_, _c9_, _c__, _c$_);}
   var _aW_ = Name$0[85];
   function small$0(_c6_, _c7_, _c8_){return cons(_aW_, _c6_, _c7_, _c8_);}
   var _aX_ = Name$0[86];
   function source$0(_c3_, _c4_, _c5_){
    return void_cons(_aX_, _c3_, _c4_, _c5_);
   }
   var _aY_ = Name$0[87];
   function span$0(_c0_, _c1_, _c2_){return cons(_aY_, _c0_, _c1_, _c2_);}
   var _aZ_ = Name$0[88];
   function strong$0(_cX_, _cY_, _cZ_){return cons(_aZ_, _cX_, _cY_, _cZ_);}
   var _a0_ = Name$0[89];
   function style$2(_cU_, _cV_, _cW_){return cons(_a0_, _cU_, _cV_, _cW_);}
   var _a1_ = Name$0[90];
   function sub$1(_cR_, _cS_, _cT_){return cons(_a1_, _cR_, _cS_, _cT_);}
   var _a2_ = Name$0[91];
   function summary$0(_cO_, _cP_, _cQ_){return cons(_a2_, _cO_, _cP_, _cQ_);}
   var _a3_ = Name$0[92];
   function sup$0(_cL_, _cM_, _cN_){return cons(_a3_, _cL_, _cM_, _cN_);}
   var _a4_ = Name$0[93];
   function table$0(_cI_, _cJ_, _cK_){return cons(_a4_, _cI_, _cJ_, _cK_);}
   var _a5_ = Name$0[94];
   function tbody$0(_cF_, _cG_, _cH_){return cons(_a5_, _cF_, _cG_, _cH_);}
   var _a6_ = Name$0[95];
   function td$0(_cC_, _cD_, _cE_){return cons(_a6_, _cC_, _cD_, _cE_);}
   var _a7_ = Name$0[96];
   function textarea$0(_cz_, _cA_, _cB_){return cons(_a7_, _cz_, _cA_, _cB_);}
   var _a8_ = Name$0[97];
   function tfoot$0(_cw_, _cx_, _cy_){return cons(_a8_, _cw_, _cx_, _cy_);}
   var _a9_ = Name$0[98];
   function th$0(_ct_, _cu_, _cv_){return cons(_a9_, _ct_, _cu_, _cv_);}
   var _a__ = Name$0[99];
   function thead$0(_cq_, _cr_, _cs_){return cons(_a__, _cq_, _cr_, _cs_);}
   var _a$_ = Name$0[100];
   function time$0(_cn_, _co_, _cp_){return cons(_a$_, _cn_, _co_, _cp_);}
   var _ba_ = Name$0[101];
   function title$3(_ck_, _cl_, _cm_){return cons(_ba_, _ck_, _cl_, _cm_);}
   var _bb_ = Name$0[102];
   function tr$0(_ch_, _ci_, _cj_){return cons(_bb_, _ch_, _ci_, _cj_);}
   var _bc_ = Name$0[103];
   function track$0(_ce_, _cf_, _cg_){
    return void_cons(_bc_, _ce_, _cf_, _cg_);
   }
   var _bd_ = Name$0[104];
   function u$0(_cb_, _cc_, _cd_){return cons(_bd_, _cb_, _cc_, _cd_);}
   var _be_ = Name$0[105];
   function ul$0(_b__, _b$_, _ca_){return cons(_be_, _b__, _b$_, _ca_);}
   var _bf_ = Name$0[106];
   function var$1(_b7_, _b8_, _b9_){return cons(_bf_, _b7_, _b8_, _b9_);}
   var _bg_ = Name$0[107];
   function video$0(_b4_, _b5_, _b6_){return cons(_bg_, _b4_, _b5_, _b6_);}
   var _bh_ = Name$0[108];
   function wbr$0(_b1_, _b2_, _b3_){return void_cons(_bh_, _b1_, _b2_, _b3_);}
   function as_target(d){return d;}
   function root(d){return d[cst_documentElement];}
   function body$1(d){
    var b = d[cst_body];
    return caml_call1(Jv[9], b)
            ? b
            : caml_call2
              (Jv[32],
               0,
               "Document body is null. Try to defer your script execution.");
   }
   function head$1(d){return d[cst_head];}
   function active_el(d){
    var _bZ_ = d[cst_activeElement];
    return caml_call2(Jv[10], function(_b0_){return _b0_;}, _bZ_);
   }
   function find_el_by_id(d, id){
    var _bX_ = d.getElementById(id);
    return caml_call2(Jv[10], function(_bY_){return _bY_;}, _bX_);
   }
   function find_els_by_name(d, n){
    return el_list_of_node_list(d.getElementsByName(n));
   }
   function referrer(d){return caml_call2(Jv[22][2], d, cst_referrer);}
   function title$4(d){return caml_call2(Jv[22][2], d, cst_title);}
   function set_title(d, t){return caml_call3(Jv[22][3], d, cst_title$0, t);}
   var
    hidden$1 = cst_hidden,
    visible = "visible",
    Visibility_state = [0, hidden$1, visible];
   function visibility_state(d){
    return caml_call2(Jv[22][2], d, cst_visibilityState);
   }
   function pointer_lock_element(d){
    var _bV_ = d[cst_pointerLockElement];
    return caml_call1(caml_call1(Jv[10], function(_bW_){return _bW_;}), _bV_);
   }
   function exit_pointer_lock(d){
    var fut = next(0, pointerlockchange, d);
    d.exitPointerLock();
    return fut;
   }
   function fullscreen_available(d){
    return caml_call2(Jv[19][2], d, cst_fullscreenEnabled);
   }
   function fullscreen_element(d){
    var _bT_ = d["fullscreenElement"];
    return caml_call1(caml_call1(Jv[10], function(_bU_){return _bU_;}), _bT_);
   }
   function exit_fullscreen(d){
    var _bR_ = d.exitFullscreen();
    return caml_call1(caml_call1(Fut[11], function(_bS_){return 0;}), _bR_);
   }
   function aborted(s){return caml_call2(Jv[19][2], s, cst_aborted);}
   var abort$0 = cst_abort, Signal = [0, aborted, abort$0];
   function controller(param){return new Jv[12]["AbortController"];}
   function signal(c){return c["signal"];}
   function abort$1(c){c.abort(); return 0;}
   var Abort = [0, Signal, controller, signal, abort$1];
   function call(c, meth, args){caml_js_meth_call(c, meth, args); return 0;}
   var c = [0, Jv[12][cst_console]];
   function get(param){return c[1];}
   function set(n){c[1] = n; return 0;}
   function clear$0(param){return call(c[1], cst_clear, [0]);}
   function msg(v){return [0, v, 0];}
   function str(v){
    return caml_call1(Jv[6], v)
            ? "null"
            : caml_call1(Jv[7], v) ? "undefined" : v.toString();
   }
   function msg_to_jv_array(msg){
    var a = caml_call1(Jv[29][1], 0), i = 0, param = msg;
    for(;;){
     if(! param) return runtime.caml_js_to_array(a);
     var vs = param[2], v = param[1];
     a[i] = v;
     var i$0 = i + 1 | 0, i = i$0, param = vs;
    }
   }
   function log(msg){
    var _bQ_ = msg_to_jv_array(msg);
    return call(c[1], cst_log, _bQ_);
   }
   function trace(msg){
    var _bP_ = msg_to_jv_array(msg);
    return call(c[1], cst_trace, _bP_);
   }
   function error$1(msg){
    var _bO_ = msg_to_jv_array(msg);
    return call(c[1], cst_error, _bO_);
   }
   function warn(msg){
    var _bN_ = msg_to_jv_array(msg);
    return call(c[1], cst_warn, _bN_);
   }
   function info(msg){
    var _bM_ = msg_to_jv_array(msg);
    return call(c[1], cst_info, _bM_);
   }
   function debug(msg){
    var _bL_ = msg_to_jv_array(msg);
    return call(c[1], cst_debug, _bL_);
   }
   function assert(b, msg){
    var _bK_ = msg_to_jv_array([0, ! ! b, msg]);
    return call(c[1], cst_assert, _bK_);
   }
   function dir$1(o){return call(c[1], cst_dir, [0, o]);}
   function table$1(cols, v){
    if(cols)
     var l = cols[1], msg = [0, v, runtime.caml_list_to_js_array(l)];
    else
     var msg = [0, v];
    return call(c[1], cst_table, msg);
   }
   function group_end(param){return call(c[1], cst_groupEnd, [0]);}
   function group(opt, msg){
    if(opt) var sth = opt[1], closed = sth; else var closed = 0;
    if(closed){
     var _bI_ = msg_to_jv_array(msg);
     return call(c[1], cst_groupCollapsed, _bI_);
    }
    var _bJ_ = msg_to_jv_array(msg);
    return call(c[1], cst_group, _bJ_);
   }
   function count(label){return call(c[1], cst_count, [0, label]);}
   function count_reset(label){return call(c[1], cst_countReset, [0, label]);}
   function time$1(label){return call(c[1], cst_time, [0, label]);}
   function time_log(label, msg){
    var _bH_ = msg_to_jv_array([0, label, msg]);
    return call(c[1], cst_timeLog, _bH_);
   }
   function time_end(label){return call(c[1], cst_timeEnd, [0, label]);}
   function profile(label){return call(c[1], cst_profile, [0, label]);}
   function profile_end(label){return call(c[1], cst_profileEnd, [0, label]);}
   function time_stamp(label){return call(c[1], cst_timeStamp$0, [0, label]);}
   function log_result(opt, _bG_, r){
    if(opt)
     var sth = opt[1], ok = sth;
    else
     var ok = function(v){return [0, v, 0];};
    if(_bG_)
     var sth$0 = _bG_[1], err = sth$0;
    else
     var err = function(e){return [0, str(e), 0];};
    if(0 === r[0]){
     var v = r[1];
     log(caml_call1(ok, v));
    }
    else{var e = r[1]; error$1(caml_call1(err, e));}
    return r;
   }
   function log_if_error(opt, _bF_, use, param){
    if(opt) var sth = opt[1], l = sth; else var l = error$1;
    if(_bF_)
     var sth$0 = _bF_[1], error_msg = sth$0;
    else
     var error_msg = function(e){return [0, str(e), 0];};
    if(0 === param[0]){var v = param[1]; return v;}
    var e = param[1];
    caml_call1(l, caml_call1(error_msg, e));
    return use;
   }
   function log_if_error$0(l, error_msg, use, r){
    return [0, log_if_error(l, error_msg, use, r)];
   }
   function as_target$0(w){return w;}
   function closed(w){return caml_call2(Jv[19][2], w, cst_closed);}
   function scroll_x$0(w){return caml_call2(Jv[21][2], w, cst_scrollX);}
   function scroll_y$0(w){return caml_call2(Jv[21][2], w, cst_scrollY);}
   function device_pixel_ratio(w){
    return caml_call2(Jv[21][2], w, cst_devicePixelRatio);
   }
   function matches_media(w, s){
    var o = w.matchMedia(s);
    return caml_call2(Jv[19][2], o, cst_matches);
   }
   function prefers_dark_color_scheme(w){
    return matches_media(w, "(prefers-color-scheme: dark)");
   }
   function open$0(opt, _bC_, w, u){
    if(opt) var sth = opt[1], features = sth; else var features = Jstr[4];
    if(_bC_) var sth$0 = _bC_[1], name = sth$0; else var name = Jstr[4];
    var _bD_ = w.open(u, name, features);
    return caml_call1(caml_call1(Jv[10], function(_bE_){return _bE_;}), _bD_);
   }
   function close$0(w){w.close(); return 0;}
   function print(w){w.print(); return 0;}
   function reload(w){w[cst_location$0].reload(); return 0;}
   function location$0(w){return new url(w[cst_location$0]);}
   function set_location(w, u){return w[cst_location$0] = u;}
   var
    auto$0 = cst_auto,
    manual = "manual",
    Scroll_restoration = [0, auto$0, manual];
   function length$1(h){return caml_call2(Jv[20][2], h, cst_length$3);}
   function scroll_restoration(h){
    return caml_call2(Jv[22][2], h, cst_scrollRestoration);
   }
   function set_scroll_restoration(h, r){
    return caml_call3(Jv[22][3], h, cst_scrollRestoration$0, r);
   }
   function back(h){h.back(); return 0;}
   function forward(h){h.forward(); return 0;}
   function go(h, d){h.go(d); return 0;}
   function state(h){return h[cst_state];}
   function push_state(opt, _bB_, _bA_, h){
    if(opt) var sth = opt[1], state = sth; else var state = Jv[4];
    if(_bB_) var sth$0 = _bB_[1], title = sth$0; else var title = Jstr[4];
    if(_bA_) var sth$1 = _bA_[1], uri = sth$1; else var uri = Jv[4];
    h.pushState(state, title, uri);
    return 0;
   }
   function replace_state(opt, _bz_, _by_, h){
    if(opt) var sth = opt[1], state = sth; else var state = Jv[4];
    if(_bz_) var sth$0 = _bz_[1], title = sth$0; else var title = Jstr[4];
    if(_by_) var sth$1 = _by_[1], uri = sth$1; else var uri = Jv[4];
    h.replaceState(state, title, uri);
    return 0;
   }
   function state$0(e){return e[cst_state];}
   var
    Popstate = [0, state$0],
    popstate = "popstate",
    Ev = [0, Popstate, popstate],
    History =
      [0,
       Scroll_restoration,
       length$1,
       scroll_restoration,
       set_scroll_restoration,
       back,
       forward,
       go,
       state,
       push_state,
       replace_state,
       Ev];
   function history(w){return w["history"];}
   var
    Window =
      [0,
       as_target$0,
       closed,
       scroll_x$0,
       scroll_y$0,
       device_pixel_ratio,
       matches_media,
       prefers_dark_color_scheme,
       open$0,
       close$0,
       print,
       reload,
       location$0,
       set_location,
       History,
       history];
   function languages(n){
    var match = caml_call2(Jv[13], n, cst_languages);
    if(match){var a = match[1]; return caml_list_of_js_array(a);}
    var match$0 = caml_call2(Jv[22][1], n, cst_language);
    if(! match$0) return 0;
    var v = match$0[1];
    return [0, v, 0];
   }
   function max_touch_points(n){
    var t = n["maxTouchPoints"];
    return caml_call1(Jv[8], t) ? 0 : t;
   }
   function online(n){return caml_call2(Jv[19][2], n, cst_onLine);}
   var
    Navigator = [0, languages, max_touch_points, online],
    frame = "frame",
    navigation = "navigation",
    resource = "resource",
    mark$1 = cst_mark,
    measure = cst_measure,
    paint = "paint",
    longtask = "longtask",
    Type$0 =
      [0, frame, navigation, resource, mark$1, measure, paint, longtask];
   function name$3(e){return caml_call2(Jv[22][2], e, cst_name$1);}
   function type$6(e){return caml_call2(Jv[22][2], e, cst_entryType);}
   function start_time(e){return caml_call2(Jv[21][2], e, cst_startTime);}
   function end_time(e){return caml_call2(Jv[21][2], e, cst_endTime);}
   function duration(e){return caml_call2(Jv[21][2], e, cst_duration);}
   function to_json(e){return e.toJSON();}
   function as_entry(_bx_){return _bx_;}
   function initiator_type(e){
    return caml_call2(Jv[22][2], e, cst_initiatorType);
   }
   function next_hop_protocol(e){
    return caml_call2(Jv[22][2], e, cst_nextHopProtocol);
   }
   function worker_start(e){return caml_call2(Jv[21][2], e, cst_workerStart);}
   function redirect_start(e){
    return caml_call2(Jv[21][2], e, cst_redirectStart);
   }
   function redirect_end(e){return caml_call2(Jv[21][2], e, cst_redirectEnd);}
   function fetch_start(e){return caml_call2(Jv[21][2], e, cst_fetchStart);}
   function domain_lookup_start(e){
    return caml_call2(Jv[21][2], e, cst_domainLookupStart);
   }
   function domain_lookup_end(e){
    return caml_call2(Jv[21][2], e, cst_domainLookupEnd);
   }
   function connect_start(e){
    return caml_call2(Jv[21][2], e, cst_connectStart);
   }
   function connect_end(e){return caml_call2(Jv[21][2], e, cst_connectEnd);}
   function secure_connection_start(e){
    return caml_call2(Jv[21][2], e, cst_secureConnectionStart);
   }
   function request_start(e){
    return caml_call2(Jv[21][2], e, cst_requestStart);
   }
   function response_start(e){
    return caml_call2(Jv[21][2], e, cst_responseStart);
   }
   function response_end(e){return caml_call2(Jv[21][2], e, cst_responseEnd);}
   function transfer_size(e){
    return caml_call2(Jv[20][2], e, cst_transferSize);
   }
   function encoded_body_size(e){
    return caml_call2(Jv[20][2], e, cst_encodedBodySize);
   }
   function decoded_body_size(e){
    return caml_call2(Jv[20][2], e, cst_decodedBodySize);
   }
   var
    Resource_timing =
      [0,
       as_entry,
       initiator_type,
       next_hop_protocol,
       worker_start,
       redirect_start,
       redirect_end,
       fetch_start,
       domain_lookup_start,
       domain_lookup_end,
       connect_start,
       connect_end,
       secure_connection_start,
       request_start,
       response_start,
       response_end,
       transfer_size,
       encoded_body_size,
       decoded_body_size],
    navigate = "navigate",
    reload$0 = cst_reload,
    back_forward = "back_forward",
    prerender = "prerender",
    Type$1 = [0, navigate, reload$0, back_forward, prerender];
   function as_resource_timing(_bw_){return _bw_;}
   function as_entry$0(_bv_){return _bv_;}
   function unload_event_start(e){
    return caml_call2(Jv[21][2], e, cst_unloadEventStart);
   }
   function unload_event_end(e){
    return caml_call2(Jv[21][2], e, cst_unloadEventEnd);
   }
   function dom_interactive(e){
    return caml_call2(Jv[21][2], e, cst_domInteractive);
   }
   function dom_content_loaded_event_start(e){
    return caml_call2(Jv[21][2], e, cst_domContentLoadedEventStart);
   }
   function dom_content_loaded_event_end(e){
    return caml_call2(Jv[21][2], e, cst_domContentLoadedEventEnd);
   }
   function dom_complete(e){return caml_call2(Jv[21][2], e, cst_domComplete);}
   function load_event_start(e){
    return caml_call2(Jv[21][2], e, cst_loadEventStart);
   }
   function load_event_end(e){
    return caml_call2(Jv[21][2], e, cst_loadEventEnd);
   }
   function type$7(e){return caml_call2(Jv[22][2], e, cst_type$3);}
   function redirect_count(e){
    return caml_call2(Jv[20][2], e, cst_redirectCount);
   }
   function as_resource_timing$0(_bu_){return _bu_;}
   function as_navigation_timing(_bt_){return _bt_;}
   function time_origin_ms(p){
    return caml_call2(Jv[21][2], p, cst_timeOrigin);
   }
   function clear_marks(p, n){
    if(n) var n$0 = n[1], args = [0, n$0]; else var args = [0];
    caml_js_meth_call(p, "clearMarks", args);
    return 0;
   }
   function clear_measures(p, n){
    if(n) var n$0 = n[1], args = [0, n$0]; else var args = [0];
    caml_js_meth_call(p, "clearMeasures", args);
    return 0;
   }
   function clear_resource_timings(p){p.clearResourceTimings(); return 0;}
   function get_entries(type, name, p){
    if(name){
     var n = name[1];
     if(type){
      var t = type[1], _bl_ = p.getEntriesByName(n, t);
      return caml_call1
              (caml_call1(Jv[27], function(_bs_){return _bs_;}), _bl_);
     }
     var _bm_ = p.getEntriesByName(n);
     return caml_call1(caml_call1(Jv[27], function(_br_){return _br_;}), _bm_);
    }
    if(type){
     var t$0 = type[1], _bn_ = p.getEntriesByType(t$0);
     return caml_call1(caml_call1(Jv[27], function(_bq_){return _bq_;}), _bn_);
    }
    var _bo_ = p.getEntries();
    return caml_call1(caml_call1(Jv[27], function(_bp_){return _bp_;}), _bo_);
   }
   function mark$2(p, n){p.mark(n); return 0;}
   function measure$0(start, stop, p, n){
    if(start){
     var s = start[1];
     if(stop){var e = stop[1]; p.measure(s, e); return 0;}
     p.measure(s);
     return 0;
    }
    if(stop){var e$0 = stop[1]; p.measure(Jv[5], e$0); return 0;}
    p.measure();
    return 0;
   }
   function now_ms(p){return p.now();}
   function to_json$0(p){return p.toJSON();}
   var
    console = Jv[12][cst_console],
    navigator = Jv[12]["navigator"],
    performance = Jv[12]["performance"],
    window = Jv[12][cst_window],
    is_secure_context = caml_call2(Jv[19][2], Jv[12], cst_isSecureContext),
    target$0 = Jv[12];
   function set_timeout(ms, f){
    return Jv[12].setTimeout(caml_js_wrap_callback_strict(1, f), ms);
   }
   function set_interval(ms, f){
    return Jv[12].setInterval(caml_js_wrap_callback_strict(1, f), ms);
   }
   function stop_timer(tid){Jv[12].clearTimeout(tid); return 0;}
   function request_animation_frame(f){
    return Jv[12].requestAnimationFrame(caml_js_wrap_callback_strict(1, f));
   }
   function cancel_animation_frame(fid){
    Jv[12].cancelAnimationFrame(fid);
    return 0;
   }
   var
    Brr =
      [0,
       [0,
        [0, create$0, byte_length, slice],
        [0,
         of_buffer,
         buffer,
         byte_offset,
         byte_length$0,
         get_int8,
         get_int16_be,
         get_int16_le,
         get_int32_be,
         get_int32_le,
         get_uint8,
         get_uint16_be,
         get_uint16_le,
         get_uint32_be,
         get_uint32_le,
         get_float32_be,
         get_float32_le,
         get_float64_be,
         get_float64_le,
         set_int8,
         set_int16_be,
         set_int16_le,
         set_int32_be,
         set_int32_le,
         set_uint8,
         set_uint16_be,
         set_uint16_le,
         set_uint32_be,
         set_uint32_le,
         set_float32_be,
         set_float32_le,
         set_float64_be,
         set_float64_le],
        type_size_in_bytes,
        create$1,
        of_buffer$0,
        buffer,
        byte_offset,
        byte_length$0,
        length$0,
        type$2,
        set_tarray,
        fill,
        copy_within,
        slice$0,
        sub,
        find,
        find_index,
        for_all,
        exists,
        filter,
        iter,
        map,
        fold_left,
        fold_right,
        reverse,
        of_tarray,
        uint8_of_buffer,
        of_int_array,
        of_float_array,
        of_jstr,
        to_jstr,
        of_binary_jstr,
        to_binary_jstr,
        to_int_jstr,
        to_hex_jstr,
        type_to_bigarray_kind,
        type_of_bigarray_kind],
       [0,
        Ending_type,
        init$0,
        of_jstr$0,
        of_array_buffer,
        byte_length$1,
        type$3,
        slice$1,
        array_buffer$0,
        stream,
        text,
        data_uri],
       [0, init$1, of_blob, name, relative_path, last_modified_ms],
       Base64,
       [0, encode$0, decode$0],
       [0,
        v,
        scheme,
        host,
        port,
        path,
        query,
        fragment,
        with_uri,
        path_segments,
        with_path_segments,
        [0,
         is_empty,
         mem,
         find$0,
         find_all,
         fold,
         of_obj,
         of_jstr$1,
         to_jstr$0,
         of_assoc,
         to_assoc],
        query_params,
        with_query_params,
        fragment_params,
        with_fragment_params,
        of_jstr$2,
        to_jstr$1,
        encode$2,
        decode$2,
        encode_component$0,
        decode_component$0],
       [0,
        Type,
        init,
        create,
        type,
        target,
        current_target,
        composed_path,
        event_phase,
        bubbles,
        stop_propagation,
        stop_immediate_propagation,
        cancelable,
        prevent_default,
        default_prevented,
        composed,
        is_trusted,
        timestamp_ms,
        dispatch,
        listen_opts,
        listen,
        unlisten,
        next,
        [0,
         Effect,
         Item,
         [0, length, add_jstr, add_file, remove, clear, caml_js_get, items],
         drop_effect,
         set_drop_effect,
         effect_allowed,
         set_effect_allowed,
         items$0],
        Clipboard,
        Composition,
        Error,
        Extendable,
        Focus,
        Hash_change,
        Input,
        Keyboard,
        Mouse,
        Drag,
        Pointer,
        Wheel,
        abort,
        activate,
        auxclick,
        beforeinput,
        beforeunload,
        blur,
        canplay,
        canplaythrough,
        change,
        click,
        clipboardchange,
        close,
        compositionend,
        compositionstart,
        compositionudpate,
        controllerchange,
        copy$0,
        cut,
        dblclick,
        dom_content_loaded,
        drag,
        dragend,
        dragenter,
        dragexit,
        dragleave,
        dragover,
        dragstart,
        drop,
        durationchange,
        emptied,
        ended,
        error$0,
        focus,
        focusin,
        focusout,
        fullscreenchange,
        fullscreenerror,
        gotpointercapture,
        hashchange,
        input,
        install,
        keydown,
        keyup,
        languagechange,
        load,
        loadeddata,
        loadedmetadata,
        loadstart,
        lostpointercapture,
        mousedown,
        mouseenter,
        mouseleave,
        mousemove,
        mouseout,
        mouseover,
        mouseup,
        open,
        paste,
        pause,
        play,
        playing,
        pointercancel,
        pointerdown,
        pointerenter,
        pointerleave,
        pointerlockchange,
        pointerlockerror,
        pointermove,
        pointerout,
        pointerover,
        pointerrawupdate,
        pointerup,
        progress,
        ratechange,
        reset,
        resize,
        scroll,
        seeked,
        seeking,
        select,
        statechange,
        stalled,
        suspend,
        timeupdate,
        unload,
        updatefound,
        visibilitychange,
        volumechange,
        waiting,
        wheel],
       [0,
        v$0,
        void$0,
        is_void,
        true$0,
        int$0,
        float$0,
        if$0,
        if_some,
        to_pair,
        add_if,
        add_if_some,
        Name,
        accesskey$0,
        action$0,
        autocomplete$0,
        autofocus$0,
        charset$0,
        checked$0,
        class$1,
        cols$0,
        content$0,
        contenteditable$0,
        defer$0,
        dir$0,
        disabled$0,
        draggable$0,
        for$1,
        height$1,
        hidden$0,
        href$0,
        id$1,
        lang$0,
        list$0,
        media$0,
        method$0,
        name$1,
        placeholder$0,
        rel$0,
        required$0,
        rows$0,
        selected$0,
        spellcheck$0,
        src$0,
        style$0,
        tabindex$0,
        title$0,
        type$5,
        value$0,
        wrap$0,
        width$1],
       [0,
        v$1,
        txt,
        txt$0,
        sp,
        nbsp,
        is_txt,
        is_el,
        tag_name,
        has_tag_name,
        txt_text,
        document,
        find_by_class,
        find_by_tag_name,
        find_first_by_selector,
        fold_find_by_selector,
        parent,
        children,
        set_children,
        prepend_children,
        append_children,
        previous_sibling,
        next_sibling,
        insert_siblings,
        remove$0,
        at,
        set_at,
        [0,
         bool,
         int$1,
         float$1,
         jstr,
         checked$1,
         height$2,
         id$2,
         name$2,
         title$1,
         value$1,
         width$2],
        prop,
        set_prop,
        class$2,
        set_class,
        Style,
        computed_style,
        inline_style,
        set_inline_style,
        remove_inline_style,
        inner_x,
        inner_y,
        inner_w,
        inner_h,
        bound_x,
        bound_y,
        bound_w,
        bound_h,
        scroll_x,
        scroll_y,
        scroll_w,
        scroll_h,
        scroll_into_view,
        has_focus,
        set_has_focus,
        is_locking_pointer,
        request_pointer_lock,
        Navigation_ui,
        fullscreen_opts,
        request_fullscreen,
        click$0,
        select_text,
        Input$0,
        Name$0,
        a$0,
        abbr$0,
        address$0,
        area$0,
        article$0,
        aside$0,
        audio$0,
        b$0,
        base$0,
        bdi$0,
        bdo$0,
        blockquote$0,
        body$0,
        br$0,
        button$1,
        canvas$0,
        caption$0,
        cite$0,
        code$2,
        col$0,
        colgroup$0,
        command$0,
        datalist$0,
        dd$0,
        del$0,
        details$0,
        dfn$0,
        div$0,
        dl$0,
        dt$0,
        em$0,
        embed$0,
        fieldset$0,
        figcaption$0,
        figure$0,
        footer$0,
        form$0,
        h1$0,
        h2$0,
        h3$0,
        h4$0,
        h5$0,
        h6$0,
        head$0,
        header$0,
        hgroup$0,
        hr$0,
        html$0,
        i$0,
        iframe$0,
        img$0,
        input$1,
        ins$0,
        kbd$0,
        keygen$0,
        label$0,
        legend$0,
        li$0,
        link$1,
        map$1,
        mark$0,
        menu$0,
        meta$0,
        meter$0,
        nav$0,
        noscript$0,
        object$0,
        ol$0,
        optgroup$0,
        option$0,
        output$0,
        p$0,
        function(_bi_, _bj_, _bk_){return void_cons(_aK_, _bi_, _bj_, _bk_);},
        pre$0,
        progress$1,
        q$0,
        rp$0,
        rt$0,
        ruby$0,
        s$0,
        samp$0,
        script$0,
        section$0,
        select$1,
        small$0,
        source$0,
        span$0,
        strong$0,
        style$2,
        sub$1,
        summary$0,
        sup$0,
        table$0,
        tbody$0,
        td$0,
        textarea$0,
        tfoot$0,
        th$0,
        thead$0,
        time$0,
        title$3,
        tr$0,
        track$0,
        u$0,
        ul$0,
        var$1,
        video$0,
        wbr$0],
       [0,
        as_target,
        find_el_by_id,
        find_els_by_name,
        root,
        body$1,
        head$1,
        active_el,
        referrer,
        title$4,
        set_title,
        Visibility_state,
        visibility_state,
        pointer_lock_element,
        exit_pointer_lock,
        fullscreen_available,
        fullscreen_element,
        exit_fullscreen],
       Abort,
       [0,
        get,
        set,
        clear$0,
        msg,
        str,
        log_result,
        log_if_error,
        log_if_error$0,
        log,
        trace,
        error$1,
        warn,
        info,
        debug,
        assert,
        dir$1,
        table$1,
        group,
        group_end,
        count,
        count_reset,
        time$1,
        time_log,
        time_end,
        profile,
        profile_end,
        time_stamp],
       Window,
       Navigator,
       [0,
        [0,
         Type$0,
         name$3,
         type$6,
         start_time,
         end_time,
         duration,
         to_json,
         Resource_timing,
         [0,
          Type$1,
          as_entry$0,
          as_resource_timing,
          unload_event_start,
          unload_event_end,
          dom_interactive,
          dom_content_loaded_event_start,
          dom_content_loaded_event_end,
          dom_complete,
          load_event_start,
          load_event_end,
          type$7,
          redirect_count],
         as_resource_timing$0,
         as_navigation_timing],
        time_origin_ms,
        clear_marks,
        clear_measures,
        clear_resource_timings,
        get_entries,
        mark$2,
        measure$0,
        now_ms,
        to_json$0],
       [0,
        console,
        global_document,
        navigator,
        performance,
        window,
        target$0,
        is_secure_context,
        set_timeout,
        set_interval,
        stop_timer,
        request_animation_frame,
        cancel_animation_frame]];
   runtime.caml_register_global(771, Brr, "Brr");
   return;
  }
  (globalThis));


//# 1 ".js/default/str/str.cma.js"
// Generated by js_of_ocaml
//# 3 ".js/default/str/str.cma.js"

//# 7 ".js/default/str/str.cma.js"
(function
  (globalThis){
   "use strict";
   var
    runtime = globalThis.jsoo_runtime,
    cst$2 = "",
    cst_str_ml = "str.ml",
    caml_bytes_get = runtime.caml_bytes_get,
    caml_bytes_set = runtime.caml_bytes_set,
    caml_check_bound = runtime.caml_check_bound,
    caml_create_bytes = runtime.caml_create_bytes,
    caml_make_vect = runtime.caml_make_vect,
    caml_maybe_attach_backtrace = runtime.caml_maybe_attach_backtrace,
    caml_ml_string_length = runtime.caml_ml_string_length,
    caml_string_equal = runtime.caml_string_equal,
    caml_string_get = runtime.caml_string_get,
    caml_trampoline = runtime.caml_trampoline,
    caml_trampoline_return = runtime.caml_trampoline_return,
    caml_wrap_exception = runtime.caml_wrap_exception;
   function caml_call1(f, a0){
    return (f.l >= 0 ? f.l : f.l = f.length) == 1
            ? f(a0)
            : runtime.caml_call_gen(f, [a0]);
   }
   function caml_call2(f, a0, a1){
    return (f.l >= 0 ? f.l : f.l = f.length) == 2
            ? f(a0, a1)
            : runtime.caml_call_gen(f, [a0, a1]);
   }
   function caml_call3(f, a0, a1, a2){
    return (f.l >= 0 ? f.l : f.l = f.length) == 3
            ? f(a0, a1, a2)
            : runtime.caml_call_gen(f, [a0, a1, a2]);
   }
   function caml_call5(f, a0, a1, a2, a3, a4){
    return (f.l >= 0 ? f.l : f.l = f.length) == 5
            ? f(a0, a1, a2, a3, a4)
            : runtime.caml_call_gen(f, [a0, a1, a2, a3, a4]);
   }
   var
    undef = undefined,
    global_data = runtime.caml_get_global_data(),
    cst$1 = cst$2,
    cst$0 = cst$2,
    cst = cst$2,
    Stdlib_List = global_data.Stdlib__List,
    Stdlib_String = global_data.Stdlib__String,
    Stdlib = global_data.Stdlib,
    Stdlib_Domain = global_data.Stdlib__Domain,
    Stdlib_Bytes = global_data.Stdlib__Bytes,
    Assert_failure = global_data.Assert_failure,
    Stdlib_Buffer = global_data.Stdlib__Buffer,
    Stdlib_Int = global_data.Stdlib__Int,
    Stdlib_Array = global_data.Stdlib__Array,
    Stdlib_Char = global_data.Stdlib__Char,
    Stdlib_Map = global_data.Stdlib__Map;
   function string_before(s, n){
    return caml_call3(Stdlib_String[16], s, 0, n);
   }
   function string_after(s, n){
    return caml_call3
            (Stdlib_String[16], s, n, caml_ml_string_length(s) - n | 0);
   }
   function first_chars(s, n){return caml_call3(Stdlib_String[16], s, 0, n);}
   function last_chars(s, n){
    return caml_call3
            (Stdlib_String[16], s, caml_ml_string_length(s) - n | 0, n);
   }
   function lowercase_latin1(c){
    var _am_ = c - 192 | 0;
    a:
    {
     if(30 < _am_ >>> 0){
      if(25 < _am_ + 127 >>> 0) break a;
     }
     else if(23 === _am_) break a;
     return c + 32 | 0;
    }
    return c;
   }
   var full = caml_call2(Stdlib_Bytes[1], 32, 255);
   function make_empty(param){return caml_call2(Stdlib_Bytes[1], 32, 0);}
   function add(s, c){
    var _al_ = caml_bytes_get(s, c >>> 3 | 0) | 1 << (c & 7);
    return caml_bytes_set(s, c >>> 3 | 0, caml_call1(Stdlib_Char[1], _al_));
   }
   function singleton(c){var s = make_empty(0); add(s, c); return s;}
   function complement(s){
    var r = caml_create_bytes(32), i = 0;
    for(;;){
     var _aj_ = caml_bytes_get(s, i) ^ 255;
     caml_bytes_set(r, i, caml_call1(Stdlib_Char[1], _aj_));
     var _ak_ = i + 1 | 0;
     if(31 === i) return r;
     var i = _ak_;
    }
   }
   function union(s1, s2){
    var r = caml_create_bytes(32), i = 0;
    for(;;){
     var _ag_ = caml_bytes_get(s2, i), _ah_ = caml_bytes_get(s1, i) | _ag_;
     caml_bytes_set(r, i, caml_call1(Stdlib_Char[1], _ah_));
     var _ai_ = i + 1 | 0;
     if(31 === i) return r;
     var i = _ai_;
    }
   }
   function disjoint(s1, s2){
    try{
     var i = 0;
     for(;;){
      var _ad_ = caml_bytes_get(s2, i);
      if(0 !== (caml_bytes_get(s1, i) & _ad_))
       throw caml_maybe_attach_backtrace(Stdlib[3], 1);
      var _ae_ = i + 1 | 0;
      if(31 === i){var _ac_ = 1; return _ac_;}
      var i = _ae_;
     }
    }
    catch(_af_){
     var _ab_ = caml_wrap_exception(_af_);
     if(_ab_ === Stdlib[3]) return 0;
     throw caml_maybe_attach_backtrace(_ab_, 0);
    }
   }
   function iter(fn, s){
    var i = 0;
    for(;;){
     var c = caml_bytes_get(s, i);
     if(0 !== c){
      var j = 0;
      for(;;){
       if(0 !== (c & 1 << j))
        caml_call1(fn, caml_call1(Stdlib_Char[1], (i << 3) + j | 0));
       var _aa_ = j + 1 | 0;
       if(7 === j) break;
       var j = _aa_;
      }
     }
     var _$_ = i + 1 | 0;
     if(31 === i) return;
     var i = _$_;
    }
   }
   function fold_case(s){
    var r = make_empty(0);
    iter
     (function(c){
       add(r, lowercase_latin1(c));
       var _Z_ = c - 224 | 0;
       a:
       {
        b:
        {
         if(30 < _Z_ >>> 0){
          if(25 < _Z_ + 127 >>> 0) break b;
         }
         else if(23 === _Z_) break b;
         var ___ = c - 32 | 0;
         break a;
        }
        var ___ = c;
       }
       return add(r, ___);
      },
      s);
    return r;
   }
   var
    op_CHAR = 0,
    op_CHARNORM = 1,
    op_GOTO = 15,
    op_PUSHBACK = 16,
    op_SETMARK = 17,
    op_CHECKPROGRESS = 18,
    _a_ = [0, cst_str_ml, 228, 11];
   function instr(opc, arg){return opc | arg << 8;}
   function displ(dest, from){return (dest - from | 0) - 1 | 0;}
   function is_nullable(param){
    var param$0 = param;
    for(;;){
     if(typeof param$0 === "number")
      switch(param$0){case 0: return 1;case 1: return 1;default: return 1;}
     switch(param$0[0]){
       case 0:
        return 0;
       case 1:
        var s = param$0[1]; return caml_string_equal(s, cst$2);
       case 2:
        return 0;
       case 3:
        var rl = param$0[1];
        return caml_call2(Stdlib_List[33], is_nullable, rl);
       case 4:
        var r2 = param$0[2], r1 = param$0[1], _Y_ = is_nullable(r1);
        if(_Y_) return _Y_;
        var param$0 = r2;
        break;
       case 5:
        return 1;
       case 6:
        var r = param$0[1], param$0 = r; break;
       case 7:
        return 1;
       case 8:
        var r$0 = param$0[2], param$0 = r$0; break;
       default: return 1;
     }
    }
   }
   function first$0(counter, param){
    var param$0 = param;
    for(;;){
     if(typeof param$0 === "number")
      switch(param$0){
        case 0:
         return full;
        case 1:
         return full;
        default: return full;
      }
     switch(param$0[0]){
       case 0:
        var c = param$0[1]; return singleton(c);
       case 1:
        var s = param$0[1];
        return caml_string_equal(s, cst$2)
                ? full
                : singleton(caml_string_get(s, 0));
       case 2:
        var cmpl = param$0[2], cl = param$0[1];
        return cmpl ? complement(cl) : cl;
       case 3:
        var rl = param$0[1];
        if(counter >= 50) return caml_trampoline_return(first_seq$0, [0, rl]);
        var counter$0 = counter + 1 | 0;
        return first_seq$0(counter$0, rl);
       case 4:
        var r2 = param$0[2], r1 = param$0[1], _X_ = first(r2);
        return union(first(r1), _X_);
       case 5:
        return full;
       case 6:
        var r = param$0[1], param$0 = r; break;
       case 7:
        return full;
       case 8:
        var r$0 = param$0[2], param$0 = r$0; break;
       default: return full;
     }
    }
   }
   function first(param){return caml_trampoline(first$0(0, param));}
   function first_seq$0(counter, param){
    var param$0 = param;
    for(;;){
     if(! param$0) return full;
     var r = param$0[1];
     if(typeof r !== "number")
      switch(r[0]){
        case 5:
         var rl$0 = param$0[2], r$0 = r[1], _V_ = first_seq(rl$0);
         return union(first(r$0), _V_);
        case 7:
         var rl$1 = param$0[2], r$1 = r[1], _W_ = first_seq(rl$1);
         return union(first(r$1), _W_);
        default:
         if(counter >= 50) return caml_trampoline_return(first$0, [0, r]);
         var counter$0 = counter + 1 | 0;
         return first$0(counter$0, r);
      }
     var rl = param$0[2], param$0 = rl;
    }
   }
   function first_seq(param){return caml_trampoline(first_seq$0(0, param));}
   function charclass_of_regexp(fold_case$0, re){
    a:
    if(typeof re !== "number"){
     switch(re[0]){
       case 0:
        var c = re[1], compl = 0, cl1 = singleton(c); break;
       case 2:
        var compl$0 = re[2], cl = re[1], compl = compl$0, cl1 = cl; break;
       default: break a;
     }
     var
      cl2 = fold_case$0 ? fold_case(cl1) : cl1,
      _U_ = compl ? complement(cl2) : cl2;
     return caml_call1(Stdlib_Bytes[6], _U_);
    }
    throw caml_maybe_attach_backtrace([0, Assert_failure, _a_], 1);
   }
   var
    t = caml_create_bytes(256),
    i = 0,
    cst_Str_matched_group = "Str.matched_group",
    cst_Str_group_end = "Str.group_end",
    cst_Str_group_beginning = "Str.group_beginning",
    _b_ = [0, 92],
    cst_group_not_closed_by = "\\( group not closed by \\)",
    _c_ = [0, cst_str_ml, 533, 10],
    cst_class_not_closed_by = "[ class not closed by ]",
    cst_spurious_in_regular_expres = "spurious \\) in regular expression",
    cst_too_many_r_or_r_where_r_is = "too many r* or r+ where r is nullable",
    op_STRING = 2,
    op_STRINGNORM = 3,
    op_CHARCLASS = 4,
    op_BOL = 5,
    op_EOL = 6,
    op_WORDBOUNDARY = 7,
    op_BEGGROUP = 8,
    op_ENDGROUP = 9,
    op_REFGROUP = 10,
    op_ACCEPT = 11,
    op_SIMPLEOPT = 12,
    op_SIMPLESTAR = 13,
    op_SIMPLEPLUS = 14;
   for(;;){
    caml_bytes_set(t, i, lowercase_latin1(caml_call1(Stdlib_Char[1], i)));
    var _d_ = i + 1 | 0;
    if(255 === i) break;
    var i = _d_;
   }
   var
    fold_case_table = caml_call1(Stdlib_Bytes[6], t),
    compare = runtime.caml_string_compare,
    StringMap = caml_call1(Stdlib_Map[1], [0, compare]);
   function compile(fold_case$0, re){
    var
     prog = [0, caml_make_vect(32, 0)],
     progpos = [0, 0],
     cpool = [0, StringMap[1]],
     cpoolpos = [0, 0],
     numgroups = [0, 1],
     numregs = [0, 0];
    function emit_instr(opc, arg){
     if(prog[1].length - 1 <= progpos[1]){
      var newlen = [0, prog[1].length - 1];
      for(;;){
       if(newlen[1] > progpos[1]){
        var nprog = caml_make_vect(newlen[1], 0);
        caml_call5(Stdlib_Array[8], prog[1], 0, nprog, 0, prog[1].length - 1);
        prog[1] = nprog;
        break;
       }
       newlen[1] = newlen[1] * 2 | 0;
      }
     }
     var _S_ = instr(opc, arg), _T_ = progpos[1];
     caml_check_bound(prog[1], _T_)[1 + _T_] = _S_;
     progpos[1]++;
     return;
    }
    function emit_hole(param){
     var p = progpos[1];
     emit_instr(op_CHAR, 0);
     return p;
    }
    function patch_instr(pos, opc, dest){
     var _R_ = instr(opc, displ(dest, pos));
     caml_check_bound(prog[1], pos)[1 + pos] = _R_;
     return;
    }
    function cpool_index(s){
     try{var _P_ = caml_call2(StringMap[17], s, cpool[1]); return _P_;}
     catch(_Q_){
      var _O_ = caml_wrap_exception(_Q_);
      if(_O_ !== Stdlib[8]) throw caml_maybe_attach_backtrace(_O_, 0);
      var p = cpoolpos[1];
      cpool[1] = caml_call3(StringMap[2], s, p, cpool[1]);
      cpoolpos[1]++;
      return p;
     }
    }
    function allocate_register_if_nullable(r){
     if(! is_nullable(r)) return -1;
     var n = numregs[1];
     if(64 <= n) caml_call1(Stdlib[2], cst_too_many_r_or_r_where_r_is);
     numregs[1]++;
     return n;
    }
    function emit_code(param){
     if(typeof param === "number")
      switch(param){
        case 0:
         return emit_instr(op_BOL, 0);
        case 1:
         return emit_instr(op_EOL, 0);
        default: return emit_instr(op_WORDBOUNDARY, 0);
      }
     switch(param[0]){
       case 0:
        var c = param[1];
        return fold_case$0
                ? emit_instr(op_CHARNORM, lowercase_latin1(c))
                : emit_instr(op_CHAR, c);
       case 1:
        var s = param[1], match = caml_ml_string_length(s);
        if(0 === match) return;
        if(1 === match)
         return fold_case$0
                 ? emit_instr
                   (op_CHARNORM, lowercase_latin1(caml_string_get(s, 0)))
                 : emit_instr(op_CHAR, caml_string_get(s, 0));
        try{
         var i = caml_call2(Stdlib_String[36], s, 0);
         emit_code([1, string_before(s, i)]);
         emit_instr(op_CHAR, 0);
         emit_code([1, string_after(s, i + 1 | 0)]);
         return;
        }
        catch(_N_){
         var _J_ = caml_wrap_exception(_N_);
         if(_J_ === Stdlib[8])
          return fold_case$0
                  ? emit_instr
                    (op_STRINGNORM,
                     cpool_index
                      (caml_call2(Stdlib_String[18], lowercase_latin1, s)))
                  : emit_instr(op_STRING, cpool_index(s));
         throw caml_maybe_attach_backtrace(_J_, 0);
        }
       case 2:
        var
         compl = param[2],
         cl = param[1],
         cl1 = fold_case$0 ? fold_case(cl) : cl,
         cl2 = compl ? complement(cl1) : cl1;
        return emit_instr
                (op_CHARCLASS, cpool_index(caml_call1(Stdlib_Bytes[6], cl2)));
       case 3:
        var rl = param[1], param$0 = rl;
        for(;;){
         if(! param$0) return;
         var r$3 = param$0[1];
         if(typeof r$3 !== "number")
          a:
          switch(r$3[0]){
            case 5:
             var r$4 = r$3[1];
             if(typeof r$4 !== "number")
              switch(r$4[0]){
                case 0:
                case 2:
                 var rl$1 = param$0[2], _K_ = first_seq(rl$1);
                 if(! disjoint_modulo_case(first(r$4), _K_)) break a;
                 emit_instr
                  (op_SIMPLESTAR,
                   cpool_index(charclass_of_regexp(fold_case$0, r$4)));
                 var param$0 = rl$1;
                 continue;
              }
             break;
            case 6:
             var r$5 = r$3[1];
             if(typeof r$5 !== "number")
              switch(r$5[0]){
                case 0:
                case 2:
                 var rl$2 = param$0[2], _L_ = first_seq(rl$2);
                 if(! disjoint_modulo_case(first(r$5), _L_)) break a;
                 emit_instr
                  (op_SIMPLEPLUS,
                   cpool_index(charclass_of_regexp(fold_case$0, r$5)));
                 var param$0 = rl$2;
                 continue;
              }
             break;
            case 7:
             var r$6 = r$3[1];
             if(typeof r$6 !== "number")
              switch(r$6[0]){
                case 0:
                case 2:
                 var rl$3 = param$0[2], _M_ = first_seq(rl$3);
                 if(! disjoint_modulo_case(first(r$6), _M_)) break a;
                 emit_instr
                  (op_SIMPLEOPT,
                   cpool_index(charclass_of_regexp(fold_case$0, r$6)));
                 var param$0 = rl$3;
                 continue;
              }
             break;
          }
         var rl$0 = param$0[2];
         emit_code(r$3);
         var param$0 = rl$0;
        }
        break;
       case 4:
        var r2 = param[2], r1 = param[1], pos_pushback = emit_hole(0);
        emit_code(r1);
        var pos_goto_end = emit_hole(0), lbl1 = progpos[1];
        emit_code(r2);
        var lbl2 = progpos[1];
        patch_instr(pos_pushback, op_PUSHBACK, lbl1);
        return patch_instr(pos_goto_end, op_GOTO, lbl2);
       case 5:
        var
         r = param[1],
         regno = allocate_register_if_nullable(r),
         lbl1$0 = emit_hole(0);
        if(0 <= regno) emit_instr(op_SETMARK, regno);
        emit_code(r);
        if(0 <= regno) emit_instr(op_CHECKPROGRESS, regno);
        emit_instr(op_GOTO, displ(lbl1$0, progpos[1]));
        var lbl2$0 = progpos[1];
        return patch_instr(lbl1$0, op_PUSHBACK, lbl2$0);
       case 6:
        var
         r$0 = param[1],
         regno$0 = allocate_register_if_nullable(r$0),
         lbl1$1 = progpos[1];
        emit_code(r$0);
        if(0 <= regno$0) emit_instr(op_CHECKPROGRESS, regno$0);
        var pos_pushback$0 = emit_hole(0);
        if(0 <= regno$0) emit_instr(op_SETMARK, regno$0);
        emit_instr(op_GOTO, displ(lbl1$1, progpos[1]));
        var lbl2$1 = progpos[1];
        return patch_instr(pos_pushback$0, op_PUSHBACK, lbl2$1);
       case 7:
        var r$1 = param[1], pos_pushback$1 = emit_hole(0);
        emit_code(r$1);
        var lbl = progpos[1];
        return patch_instr(pos_pushback$1, op_PUSHBACK, lbl);
       case 8:
        var r$2 = param[2], n = param[1];
        emit_instr(op_BEGGROUP, n);
        emit_code(r$2);
        emit_instr(op_ENDGROUP, n);
        numgroups[1] = caml_call2(Stdlib_Int[11], numgroups[1], n + 1 | 0);
        return;
       default:
        var n$0 = param[1];
        emit_instr(op_REFGROUP, n$0);
        numgroups[1] = caml_call2(Stdlib_Int[11], numgroups[1], n$0 + 1 | 0);
        return;
     }
    }
    function disjoint_modulo_case(c1, c2){
     if(! fold_case$0) return disjoint(c1, c2);
     var _I_ = fold_case(c2);
     return disjoint(fold_case(c1), _I_);
    }
    emit_code(re);
    emit_instr(op_ACCEPT, 0);
    var start = first(re), start$0 = fold_case$0 ? fold_case(start) : start;
    if(runtime.caml_bytes_equal(start, full))
     var start_pos = -1;
    else{
     var r = caml_call2(Stdlib_Bytes[1], 256, 0);
     iter(function(c){return caml_bytes_set(r, c, 1);}, start$0);
     var start_pos = cpool_index(caml_call1(Stdlib_Bytes[6], r));
    }
    var constantpool = caml_make_vect(cpoolpos[1], cst$2);
    caml_call2
     (StringMap[23],
      function(str, idx){
       caml_check_bound(constantpool, idx)[1 + idx] = str;
       return 0;
      },
      cpool[1]);
    var
     _G_ = numregs[1],
     _H_ = numgroups[1],
     fold_case_table$0 = fold_case$0 ? fold_case_table : cst;
    return [0,
            caml_call3(Stdlib_Array[5], prog[1], 0, progpos[1]),
            constantpool,
            fold_case_table$0,
            _H_,
            _G_,
            start_pos];
   }
   function flush(buf){
    var s = caml_call1(Stdlib_Buffer[2], buf[1]);
    caml_call1(Stdlib_Buffer[8], buf[1]);
    var match = caml_ml_string_length(s);
    if(0 === match) return;
    if(1 === match){
     var _F_ = buf[2];
     buf[2] = [0, [0, caml_string_get(s, 0)], _F_];
     return;
    }
    buf[2] = [0, [1, s], buf[2]];
    return;
   }
   var dotclass = complement(singleton(10));
   function parse(s){
    var len = caml_ml_string_length(s), group_counter = [0, 1];
    function regexp0(i){
     var match = regexp1(i), j = match[2], r1 = match[1], r1$0 = r1, i$0 = j;
     for(;;){
      if
       ((i$0 + 2 | 0) <= len
        &&
         92 === caml_string_get(s, i$0)
         && 124 === caml_string_get(s, i$0 + 1 | 0)){
       var
        match$0 = regexp1(i$0 + 2 | 0),
        j$0 = match$0[2],
        r2 = match$0[1],
        r1$1 = [4, r1$0, r2],
        r1$0 = r1$1,
        i$0 = j$0;
       continue;
      }
      return [0, r1$0, i$0];
     }
    }
    function regexp1(i){
     var buf = [0, caml_call1(Stdlib_Buffer[1], 16), 0], i$0 = i;
     for(;;){
      a:
      if(len > i$0){
       if((i$0 + 2 | 0) <= len && 92 === caml_string_get(s, i$0)){
        var
         c$0 = caml_string_get(s, i$0 + 1 | 0),
         _C_ = 124 === c$0 ? 1 : 0,
         _D_ = _C_ || (41 === c$0 ? 1 : 0);
        if(_D_) break a;
       }
       var c$1 = caml_string_get(s, i$0);
       b:
       if(36 === c$1)
        var match = [0, 1, i$0 + 1 | 0];
       else{
        if(91 <= c$1){
         if(95 > c$1)
          switch(c$1 - 91 | 0){
            case 0:
             var i$5 = i$0 + 1 | 0;
             c:
             {
              if(i$5 < len && 94 === caml_string_get(s, i$5)){
               var
                match$2 = regexpclass1(i$5 + 1 | 0),
                j$2 = match$2[2],
                c$4 = match$2[1],
                match$0 = [0, c$4, 1, j$2];
               break c;
              }
              var
               match$3 = regexpclass1(i$5),
               j$3 = match$3[2],
               c$5 = match$3[1],
               match$0 = [0, c$5, 0, j$3];
             }
             var
              j$0 = match$0[3],
              compl = match$0[2],
              c$2 = match$0[1],
              match = [0, [2, c$2, compl], j$0];
             break b;
            case 1:
             var i$6 = i$0 + 1 | 0;
             c:
             if(len <= i$6)
              var _E_ = [0, _b_, i$6];
             else{
              var c$3 = caml_string_get(s, i$6);
              d:
              {
               if(58 <= c$3){
                if(98 === c$3){var _E_ = [0, 2, i$6 + 1 | 0]; break c;}
                if(124 !== c$3) break d;
               }
               else{
                var switcher$0 = c$3 - 40 | 0;
                if(1 < switcher$0 >>> 0){
                 if(9 > switcher$0) break d;
                 var _E_ = [0, [9, c$3 - 48 | 0], i$6 + 1 | 0];
                 break c;
                }
                if(! switcher$0){
                 var group_no = group_counter[1];
                 group_counter[1]++;
                 var
                  match$1 = regexp0(i$6 + 1 | 0),
                  j$1 = match$1[2],
                  r$3 = match$1[1];
                 if
                  ((j$1 + 1 | 0) < len
                   &&
                    92 === caml_string_get(s, j$1)
                    && 41 === caml_string_get(s, j$1 + 1 | 0)){
                  var _E_ = [0, [8, group_no, r$3], j$1 + 2 | 0];
                  break c;
                 }
                 var _E_ = caml_call1(Stdlib[2], cst_group_not_closed_by);
                 break c;
                }
               }
               throw caml_maybe_attach_backtrace([0, Assert_failure, _c_], 1);
              }
              var _E_ = [0, [0, c$3], i$6 + 1 | 0];
             }
             var match = _E_;
             break b;
            case 2: break;
            default: var match = [0, 0, i$0 + 1 | 0]; break b;
          }
        }
        else if(46 === c$1){
         var match = [0, [2, dotclass, 0], i$0 + 1 | 0];
         break b;
        }
        var match = [0, [0, c$1], i$0 + 1 | 0];
       }
       var j = match[2], r = match[1];
       b:
       c:
       {
        var re = r, i$1 = j;
        for(;;){
         if(len <= i$1) break c;
         var switcher = caml_string_get(s, i$1) - 42 | 0;
         if(1 < switcher >>> 0){
          if(21 !== switcher) break;
          var i$2 = i$1 + 1 | 0, r$0 = [7, re], re = r$0, i$1 = i$2;
         }
         else if(switcher)
          var i$3 = i$1 + 1 | 0, r$1 = [6, re], re = r$1, i$1 = i$3;
         else
          var i$4 = i$1 + 1 | 0, r$2 = [5, re], re = r$2, i$1 = i$4;
        }
        break b;
       }
       b:
       {
        if(typeof re !== "number" && 0 === re[0]){
         var c = re[1];
         caml_call2(Stdlib_Buffer[12], buf[1], c);
         break b;
        }
        flush(buf);
        buf[2] = [0, re, buf[2]];
       }
       var i$0 = i$1;
       continue;
      }
      flush(buf);
      return [0, [3, caml_call1(Stdlib_List[10], buf[2])], i$0];
     }
    }
    function regexpclass1(start){
     var c = make_empty(0), i$0 = start;
     for(;;){
      if(len <= i$0) caml_call1(Stdlib[2], cst_class_not_closed_by);
      if(93 === caml_string_get(s, i$0) && start < i$0){var j = i$0 + 1 | 0; return [0, c, j];}
      var c1 = caml_string_get(s, i$0);
      if
       ((i$0 + 2 | 0) < len
        &&
         45 === caml_string_get(s, i$0 + 1 | 0)
         && 93 !== caml_string_get(s, i$0 + 2 | 0)){
       var c2 = caml_string_get(s, i$0 + 2 | 0);
       if(c2 >= c1){
        var i = c1;
        for(;;){
         add(c, caml_call1(Stdlib_Char[1], i));
         var _B_ = i + 1 | 0;
         if(c2 === i) break;
         var i = _B_;
        }
       }
       var i$2 = i$0 + 3 | 0, i$0 = i$2;
       continue;
      }
      add(c, c1);
      var i$1 = i$0 + 1 | 0, i$0 = i$1;
     }
    }
    var match = regexp0(0), j = match[2], r = match[1];
    return j === len
            ? r
            : caml_call1(Stdlib[2], cst_spurious_in_regular_expres);
   }
   function regexp(e){return compile(0, parse(e));}
   function regexp_case_fold(e){return compile(1, parse(e));}
   function quote(s){
    var
     len = caml_ml_string_length(s),
     buf = caml_create_bytes(2 * len | 0),
     pos = [0, 0],
     _x_ = len - 1 | 0,
     _w_ = 0;
    if(_x_ >= 0){
     var i = _w_;
     for(;;){
      var c = caml_string_get(s, i), _y_ = c - 63 | 0;
      a:
      {
       b:
       {
        if(31 < _y_ >>> 0){
         var _z_ = _y_ + 27 | 0;
         if(10 < _z_ >>> 0) break b;
         switch(_z_){case 0:case 6:case 7:case 10: break;default: break b;
         }
        }
        else if(26 >= _y_ - 1 >>> 0) break b;
        caml_bytes_set(buf, pos[1], 92);
        caml_bytes_set(buf, pos[1] + 1 | 0, c);
        pos[1] = pos[1] + 2 | 0;
        break a;
       }
       caml_bytes_set(buf, pos[1], c);
       pos[1] = pos[1] + 1 | 0;
      }
      var _A_ = i + 1 | 0;
      if(_x_ === i) break;
      var i = _A_;
     }
    }
    return caml_call3(Stdlib_Bytes[8], buf, 0, pos[1]);
   }
   function regexp_string(s){return compile(0, [1, s]);}
   function regexp_string_case_fold(s){return compile(1, [1, s]);}
   var
    last_search_result_key =
      caml_call2(Stdlib_Domain[10][1], 0, function(param){return [0];});
   function string_match(re, s, pos){
    var res = runtime.re_string_match(re, s, pos);
    caml_call2(Stdlib_Domain[10][3], last_search_result_key, res);
    return 0 < res.length - 1 ? 1 : 0;
   }
   function string_partial_match(re, s, pos){
    var res = runtime.re_partial_match(re, s, pos);
    caml_call2(Stdlib_Domain[10][3], last_search_result_key, res);
    return 0 < res.length - 1 ? 1 : 0;
   }
   function search_forward(re, s, pos){
    var res = runtime.re_search_forward(re, s, pos);
    caml_call2(Stdlib_Domain[10][3], last_search_result_key, res);
    if(0 === res.length - 1) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
    return caml_check_bound(res, 0)[1];
   }
   function search_backward(re, s, pos){
    var res = runtime.re_search_backward(re, s, pos);
    caml_call2(Stdlib_Domain[10][3], last_search_result_key, res);
    if(0 === res.length - 1) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
    return caml_check_bound(res, 0)[1];
   }
   function group_beginning(n){
    var
     last_search_result =
       caml_call1(Stdlib_Domain[10][2], last_search_result_key),
     n2 = n + n | 0;
    if(0 <= n && last_search_result.length - 1 > n2){
     var pos = caml_check_bound(last_search_result, n2)[1 + n2];
     if(-1 === pos) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     return pos;
    }
    return caml_call1(Stdlib[1], cst_Str_group_beginning);
   }
   function group_end(n){
    var
     last_search_result =
       caml_call1(Stdlib_Domain[10][2], last_search_result_key),
     n2 = n + n | 0;
    if(0 <= n && last_search_result.length - 1 > n2){
     var
      _v_ = n2 + 1 | 0,
      pos = caml_check_bound(last_search_result, _v_)[1 + _v_];
     if(-1 === pos) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     return pos;
    }
    return caml_call1(Stdlib[1], cst_Str_group_end);
   }
   function matched_group(n, txt){
    var
     last_search_result =
       caml_call1(Stdlib_Domain[10][2], last_search_result_key),
     n2 = n + n | 0;
    if(0 <= n && last_search_result.length - 1 > n2){
     var
      b = caml_check_bound(last_search_result, n2)[1 + n2],
      _u_ = n2 + 1 | 0,
      e = caml_check_bound(last_search_result, _u_)[1 + _u_];
     if(-1 === b) throw caml_maybe_attach_backtrace(Stdlib[8], 1);
     return caml_call3(Stdlib_String[16], txt, b, e - b | 0);
    }
    return caml_call1(Stdlib[1], cst_Str_matched_group);
   }
   function match_beginning(param){return group_beginning(0);}
   function match_end(param){return group_end(0);}
   function matched_string(txt){return matched_group(0, txt);}
   function replace_matched(repl, matched){
    var
     last_search_result =
       caml_call1(Stdlib_Domain[10][2], last_search_result_key);
    return runtime.re_replacement_text(repl, last_search_result, matched);
   }
   function substitute_first(expr, repl_fun, text){
    try{
     var
      pos = search_forward(expr, text, 0),
      _p_ = [0, string_after(text, match_end(0)), 0],
      _q_ = [0, caml_call1(repl_fun, text), _p_],
      _r_ = [0, string_before(text, pos), _q_],
      _s_ = caml_call2(Stdlib_String[7], cst$0, _r_);
     return _s_;
    }
    catch(_t_){
     var _o_ = caml_wrap_exception(_t_);
     if(_o_ === Stdlib[8]) return text;
     throw caml_maybe_attach_backtrace(_o_, 0);
    }
   }
   function opt_search_forward(re, s, pos){
    try{var _m_ = [0, search_forward(re, s, pos)]; return _m_;}
    catch(_n_){
     var _l_ = caml_wrap_exception(_n_);
     if(_l_ === Stdlib[8]) return 0;
     throw caml_maybe_attach_backtrace(_l_, 0);
    }
   }
   function global_substitute(expr, repl_fun, text){
    var accu = 0, start = 0, last_was_empty = 0;
    for(;;){
     var startpos = last_was_empty ? start + 1 | 0 : start;
     if(caml_ml_string_length(text) < startpos)
      var _j_ = [0, string_after(text, start), accu];
     else{
      var match = opt_search_forward(expr, text, startpos);
      if(match){
       var
        pos = match[1],
        end_pos = match_end(0),
        repl_text = caml_call1(repl_fun, text),
        last_was_empty$0 = end_pos === pos ? 1 : 0,
        accu$0 =
          [0,
           repl_text,
           [0,
            caml_call3(Stdlib_String[16], text, start, pos - start | 0),
            accu]],
        accu = accu$0,
        start = end_pos,
        last_was_empty = last_was_empty$0;
       continue;
      }
      var _j_ = [0, string_after(text, start), accu];
     }
     var _k_ = caml_call1(Stdlib_List[10], _j_);
     return caml_call2(Stdlib_String[7], cst$1, _k_);
    }
   }
   function global_replace(expr, repl, text){
    return global_substitute
            (expr, function(_i_){return replace_matched(repl, _i_);}, text);
   }
   function replace_first(expr, repl, text){
    return substitute_first
            (expr, function(_h_){return replace_matched(repl, _h_);}, text);
   }
   function opt_search_forward_progress(expr, text, start){
    var match = opt_search_forward(expr, text, start);
    if(! match) return 0;
    var pos = match[1];
    return start < match_end(0)
            ? [0, pos]
            : start
              < caml_ml_string_length(text)
              ? opt_search_forward(expr, text, start + 1 | 0)
              : 0;
   }
   function bounded_split(expr, text, num){
    var
     start = string_match(expr, text, 0) ? match_end(0) : 0,
     accu = 0,
     start$0 = start,
     n = num;
    for(;;){
     if(caml_ml_string_length(text) <= start$0)
      var _g_ = accu;
     else if(1 === n)
      var _g_ = [0, string_after(text, start$0), accu];
     else{
      var match = opt_search_forward_progress(expr, text, start$0);
      if(match){
       var
        pos = match[1],
        n$0 = n - 1 | 0,
        start$1 = match_end(0),
        accu$0 =
          [0,
           caml_call3(Stdlib_String[16], text, start$0, pos - start$0 | 0),
           accu],
        accu = accu$0,
        start$0 = start$1,
        n = n$0;
       continue;
      }
      var _g_ = [0, string_after(text, start$0), accu];
     }
     return caml_call1(Stdlib_List[10], _g_);
    }
   }
   function split(expr, text){return bounded_split(expr, text, 0);}
   function bounded_split_delim(expr, text, num){
    if(caml_string_equal(text, cst$2)) return 0;
    var accu = 0, start = 0, n = num;
    for(;;){
     if(caml_ml_string_length(text) < start)
      var _f_ = accu;
     else if(1 === n)
      var _f_ = [0, string_after(text, start), accu];
     else{
      var match = opt_search_forward_progress(expr, text, start);
      if(match){
       var
        pos = match[1],
        n$0 = n - 1 | 0,
        start$0 = match_end(0),
        accu$0 =
          [0,
           caml_call3(Stdlib_String[16], text, start, pos - start | 0),
           accu],
        accu = accu$0,
        start = start$0,
        n = n$0;
       continue;
      }
      var _f_ = [0, string_after(text, start), accu];
     }
     return caml_call1(Stdlib_List[10], _f_);
    }
   }
   function split_delim(expr, text){
    return bounded_split_delim(expr, text, 0);
   }
   function bounded_full_split(expr, text, num){
    var accu = 0, start = 0, n = num;
    for(;;){
     if(caml_ml_string_length(text) <= start)
      var _e_ = accu;
     else if(1 === n)
      var _e_ = [0, [0, string_after(text, start)], accu];
     else{
 