const JOINER_LEFT_BOT = "}";
const JOINER_LEFT_TOP = "]";
const JOINER_RIGHT_BOT = "{";
const JOINER_RIGHT_TOP = "[";

const MID_LEAF = "MID_LEAF";
const MID_DRAGON = "MID_DRAGON";
const MID_CHICKEN = "MID_CHICKEN";
const MID_SHARK_FIN = "MID_SHARK_FIN";
const MID_CENTIPEDE = "MID_CENTIPEDE";
const MID_LEGS = "MID_LEGS";
const MID_DRAGON_WINGS = "MID_DRAGON_WINGS";
const MID_FEATHERED_WINGS = "MID_FEATHERED_WINGS";
const MID_SERPENT = "MID_SERPENT";

const mid_segments = [
  MID_LEAF,
  MID_DRAGON,
  MID_CHICKEN,
  MID_SHARK_FIN,
  MID_CENTIPEDE,
  MID_LEGS,
  MID_DRAGON_WINGS,
  MID_FEATHERED_WINGS,
  MID_SERPENT,
];

const HEAD_ORCA = "HEAD_ORCA";
const HEAD_LEAVES = "HEAD_LEAVES";
const HEAD_DRAGON = "HEAD_DRAGON";
const HEAD_CHICKEN = "HEAD_CHICKEN";
const HEAD_SHARK = "HEAD_SHARK";
const HEAD_CENTIPEDE = "HEAD_CENTIPEDE";
const HEAD_MAN = "HEAD_MAN";
const HEAD_SNAKE = "HEAD_SNAKE";
const HEAD_BIRD = "HEAD_BIRD";

const head_segments = [
  HEAD_ORCA,
  HEAD_LEAVES,
  HEAD_DRAGON,
  HEAD_CHICKEN,
  HEAD_SHARK,
  HEAD_CENTIPEDE,
  HEAD_MAN,
  HEAD_SNAKE,
  HEAD_BIRD,
];

const TAIL_ORCA = "TAIL_ORCA";
const TAIL_LEAVES = "TAIL_LEAVES";
const TAIL_DRAGON = "TAIL_DRAGON";
const TAIL_CHICKEN = "TAIL_CHICKEN";
const TAIL_SHARK = "TAIL_SHARK";
const TAIL_CENTIPEDE = "TAIL_CENTIPEDE";
const TAIL_CURLY = "TAIL_CURLY";
const TAIL_SNAKE = "TAIL_SNAKE";
const TAIL_BIRD = "TAIL_BIRD";

const tail_segments = [
  TAIL_ORCA,
  TAIL_LEAVES,
  TAIL_DRAGON,
  TAIL_CHICKEN,
  TAIL_SHARK,
  TAIL_CENTIPEDE,
  TAIL_CURLY,
  TAIL_SNAKE,
  TAIL_BIRD,
];

const NONE = null;

const right = {
  [NONE]: "",
  [HEAD_ORCA]: "B",
  [HEAD_LEAVES]: "E",
  [HEAD_DRAGON]: "H",
  [HEAD_CHICKEN]: "K",
  [HEAD_SHARK]: "N",
  [HEAD_CENTIPEDE]: "R",
  [HEAD_MAN]: "V",
  [HEAD_SNAKE]: "Z",
  [HEAD_BIRD]: "Ż",
  [TAIL_ORCA]: "A",
  [TAIL_LEAVES]: "C",
  [TAIL_DRAGON]: "F",
  [TAIL_CHICKEN]: "I",
  [TAIL_SHARK]: "L",
  [TAIL_CENTIPEDE]: "O",
  [TAIL_CURLY]: "S",
  [TAIL_SNAKE]: "W",
  [TAIL_BIRD]: "Ź",
  [MID_LEAF]: "D",
  [MID_DRAGON]: "G",
  [MID_CHICKEN]: "J",
  [MID_SHARK_FIN]: "M",
  [MID_CENTIPEDE]: "P",
  [MID_LEGS]: "T",
  [MID_DRAGON_WINGS]: "U",
  [MID_FEATHERED_WINGS]: "Ž",
  [MID_SERPENT]: "X",
};

const left = {
  [NONE]: "",
  [HEAD_ORCA]: "y",
  [HEAD_LEAVES]: "v",
  [HEAD_DRAGON]: "s",
  [HEAD_CHICKEN]: "p",
  [HEAD_SHARK]: "m",
  [HEAD_CENTIPEDE]: "i",
  [HEAD_MAN]: "e",
  [HEAD_SNAKE]: "a",
  [HEAD_BIRD]: "ź",
  [TAIL_ORCA]: "z",
  [TAIL_LEAVES]: "x",
  [TAIL_DRAGON]: "u",
  [TAIL_CHICKEN]: "r",
  [TAIL_SHARK]: "o",
  [TAIL_CENTIPEDE]: "l",
  [TAIL_CURLY]: "h",
  [TAIL_SNAKE]: "d",
  [TAIL_BIRD]: "ż",
  [MID_LEAF]: "w",
  [MID_DRAGON]: "t",
  [MID_CHICKEN]: "q",
  [MID_SHARK_FIN]: "n",
  [MID_CENTIPEDE]: "j",
  [MID_LEGS]: "g",
  [MID_DRAGON_WINGS]: "f",
  [MID_FEATHERED_WINGS]: "ž",
  [MID_SERPENT]: "c",
};

function mirror(thing) {
  for (const key in left) {
    if (left[key] === thing) {
      return right[key];
    }
  }
  for (const key in right) {
    if (right[key] === thing) {
      return left[key];
    }
  }

  console.assert(false);
}

const player = {
  head: HEAD_MAN,
  tail: randomFrom(tail_segments),
  segments: [],
};

let opponent = {
  head: null,
  tail: null,
  segments: [],
};

const possibleSegments = mid_segments;

const example = `  {Z
p\xAB]
F]`;

function padLeftIfLessThan(str, n) {
  let res = [];
  for (let i = 0; i < n - str.length; i++) {
    res.push(" ");
  }
  res.push(str);
  return res.join("");
}

function padRightIfLessThan(str, n) {
  let res = [];
  res.push(str);
  for (let i = 0; i < n - str.length; i++) {
    res.push(" ");
  }
  return res.join("");
}

function drawCreature(creature, options) {
  const facingRight = options.facing === "right";
  function singleLine() {
    return `${right[creature.tail]}${creature.segments
      .map((s) => right[s])
      .join("")}${right[creature.head]}`;
  }
  // alternative approach: pad left, mirror each char and reverse
  function wrap() {
    const seg_length = 3; // depends on font size, mobile/desktop
    let rows = [];
    if (!creature.segments.length) {
      // TODO is this just singleLine?
      if (facingRight) {
        return `${right[creature.tail]}${right[creature.head]}`; //,
      } else {
        return `${left[creature.head]}${left[creature.tail]}`; //,
      }
    }
    let facing = facingRight ? right : left;
    let other = facingRight ? left : right;
    for (let i = 0; i < creature.segments.length; i += seg_length) {
      let line = ~~(i / seg_length);
      let hd = i === 0 ? facing[creature.head] : "";
      let segs = creature.segments.slice(i, i + seg_length);
      if (line % 2 === 0) {
        let ss = segs
          .reverse()
          .map((s) => facing[s])
          .join("");
        if (facingRight) {
          let joinNext =
            i + seg_length < creature.segments.length ? JOINER_RIGHT_BOT : "";
          let joinPrev = i === 0 ? "" : JOINER_LEFT_TOP;
          rows.push(`${joinNext}${ss}${hd}${joinPrev}`);
        } else {
          let joinNext =
            i + seg_length < creature.segments.length ? JOINER_LEFT_BOT : "";
          let joinPrev = i === 0 ? "" : JOINER_RIGHT_TOP;
          rows.push(`${joinPrev}${hd}${ss}${joinNext}`);
        }
      } else {
        let ss = segs.map((s) => other[s]).join("");
        if (facingRight) {
          let joinPrev = JOINER_RIGHT_TOP;
          let joinNext =
            i + seg_length < creature.segments.length ? JOINER_LEFT_BOT : "";
          rows.push(`${joinPrev}${hd}${ss}${joinNext}`);
        } else {
          let joinPrev = JOINER_LEFT_TOP;
          let joinNext =
            i + seg_length < creature.segments.length ? JOINER_RIGHT_BOT : "";
          rows.push(`${joinNext}${ss}${hd}${joinPrev}`);
        }
      }
    }

    let endedOnEven = ~~((creature.segments.length - 1) / seg_length) % 2 === 0;

    if (facingRight) {
      rows[rows.length - 1] = endedOnEven
        ? rows.length > 1
          ? padLeftIfLessThan(
              right[creature.tail] + rows[rows.length - 1],
              seg_length + 2
            )
          : right[creature.tail] + rows[rows.length - 1]
        : rows[rows.length - 1] + left[creature.tail];
    } else {
      rows[rows.length - 1] = endedOnEven
        ? rows.length > 1
          ? padRightIfLessThan(
              rows[rows.length - 1] + left[creature.tail],
              seg_length + 2
            )
          : rows[rows.length - 1] + left[creature.tail]
        : right[creature.tail] + rows[rows.length - 1];
    }

    return rows.join("<br>");
  }
  // return singleLine();
  return wrap();
}

function capitalize(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
}

function randomIncl(x, y) {
  return x + Math.round(Math.random() * (y - x));
}

function randomFrom(xs) {
  return xs[Math.floor(Math.random() * xs.length)];
}

function coin() {
  return !!randomIncl(0, 1);
}

function jump(label) {
  return `\`->${label}\``;
}

function tunnel(label) {
  return `\`>->${label}\``;
}

function has(seg) {
  return player.segments.indexOf(seg) > -1;
}

function count(seg) {
  return player.segments.filter((s) => s === seg).length;
}

function shuffleDurstenfeld(array) {
  for (var i = array.length - 1; i > 0; i--) {
    var j = Math.floor(Math.random() * (i + 1));
    var temp = array[i];
    array[i] = array[j];
    array[j] = temp;
  }
}

function randomSegment() {
  return randomFrom(possibleSegments);
}

// function between(xs, e) {
//   let res = [];
//   for (let i = 0; i < xs.length; i++) {
//     res.push(xs[i]);
//     if (i < xs.length - 1) {
//       res.push(e());
//     }
//   }
//   return res;
// }

function generate() {
  // let rows = 10;
  // let cols = 10;
  // const empty = ".";
  const empty = " ";
  let rows = 5;
  let cols = 5;
  let grid = [];
  for (let i = 0; i < rows; i++) {
    let row = new Array(cols).fill(empty);
    grid.push(row);
  }
  grid[2][3] = "w"; // x=3, y=2
  let q = [
    { at: [3 - 1, 2], from: "r" }, // access using [y][x]
    { at: [3 + 1, 2], from: "l" },
  ];
  const leftOpen = [
    { kind: "x", open: ["l"] },
    { kind: "w", open: ["l", "r"] },
  ];
  const rightOpen = [
    { kind: "v", open: ["r"] },
    { kind: "w", open: ["l", "r"] },
  ];
  // const topOpen = ["\u2018"];
  // const botOpen = ["\u2019"];
  while (q.length) {
    let e = q.pop();
    let [x, y] = e.at;
    console.log("generate", x, y);
    // debugger;
    if (x < 0 || x > rows || y < 0 || y > cols || grid[y][x] !== empty) {
      continue;
    }
    switch (e.from) {
      case "l": {
        let one = randomFrom(leftOpen);
        grid[y][x] = one.kind;
        // if we came from the left, we are no longer open on the left
        for (const n of one.open.filter((o) => o !== "l")) {
          if (n === "r") {
            console.log("picked", one);
            q.push({ at: [x + 1, y], from: "l" });
          }
        }
        break;
      }
      case "r": {
        let one = randomFrom(rightOpen);
        grid[y][x] = one.kind;
        for (const n of one.open.filter((o) => o !== "r")) {
          if (n === "l") {
            console.log("picked", one);
            q.push({ at: [x - 1, y], from: "r" });
          }
        }
        break;
      }
      // case "t":
      //   grid[x][y] = randomFrom(topOpen);
      // case "b":
      //   grid[x][y] = randomFrom(botOpen);
      default:
        console.log(e);
        console.assert(false);
    }
  }
  // debugger;
  return grid
    .map((r) => r.join(""))
    .filter((r) => r.trim().length)
    .join("<br>");
}

// let isFacingRight = false;
// function test(root) {
//   const p = document.createElement("p");
//   p.classList.add("monstrous");
//   // p.innerHTML = generate();
//   // p.textContent = player();
//   // let right = Math.random() > 0.5;
//   if (!isFacingRight) {
//     p.classList.add("facingLeft");
//   }
//   p.innerHTML = player(isFacingRight);
//   isFacingRight = !isFacingRight;

//   // p.textContent = example;
//   // .map((t) => {
//   // let e = document.createElement("span");
//   // e.textContent = t;
//   // return e;
//   // return `<span>${t}</span>`;
//   // })
//   // for (const e of between(example.split("\n"), () =>
//   //   document.createElement("br")
//   // )) {
//   //   p.appendChild(e);
//   // }

//   // .join(document.createElement("br"))
//   // .forEach((e) => p.appendChild(e));
//   root.appendChild(p);
//   player.segments.push(randomSegment());
// }

function showCreature(creature, options) {
  const div = document.createElement("div");
  div.classList.add("monstrous");
  if (options.center) {
    div.classList.add("center");
  } else if (options.facing === "left") {
    div.classList.add("facingLeft");
  }
  div.innerHTML = drawCreature(creature, options);
  const root = document.querySelector("#content");
  root.appendChild(div);
  return div;
}

function showPlayer() {
  showCreature(player, { facing: "left" });
}

function showPlayerOnly() {
  showCreature(player, { facing: "left", center: true });
}

function showPredator() {
  let p = showCreature(
    { head: HEAD_BIRD, tail: TAIL_BIRD, segments: [] },
    { facing: "right", center: true }
  );
  let head =
    right[
      randomFrom(
        head_segments.filter((h) => h !== HEAD_MAN && h !== HEAD_LEAVES)
      )
    ];
  let tail = right[randomFrom(tail_segments)];
  p.innerHTML = `[${head}[]${tail}]`;
}

function showCombatants() {
  let size = 2;
  let p = showCreature(
    { head: HEAD_BIRD, tail: TAIL_BIRD, segments: [] },
    { facing: "right" }
  );
  let head =
    right[
      randomFrom(
        head_segments.filter((h) => h !== HEAD_MAN && h !== HEAD_LEAVES)
      )
    ];
  let tail = right[randomFrom(tail_segments)];
  let segs = "";
  for (let i = 0; i < size; i++) {
    segs += right[randomFrom(mid_segments)];
  }
  p.innerHTML = `${tail}${segs}${head}`;

  // now the other

  p = showCreature(
    { head: HEAD_BIRD, tail: TAIL_BIRD, segments: [] },
    { facing: "left" }
  );
  head =
    left[
      randomFrom(
        head_segments.filter((h) => h !== HEAD_MAN && h !== HEAD_LEAVES)
      )
    ];
  segs = "";
  for (let i = 0; i < size; i++) {
    segs += left[randomFrom(mid_segments)];
  }
  tail = left[randomFrom(tail_segments)];
  p.innerHTML = `${head}${segs}${tail}`;
}

function growPlayer(seg) {
  seg ||= randomSegment();
  // player.segments.push(seg);
  player.segments.splice(randomIncl(0, player.segments.length - 1), 0, seg);
}

function spawnOpponent() {
  opponent.head = randomFrom(head_segments.filter((s) => s !== HEAD_MAN));
  opponent.segments = [];
  for (let i = 0; i < player.segments.length + randomIncl(-2, 2); i++) {
    opponent.segments.push(randomSegment());
  }
  opponent.tail = randomFrom(tail_segments);
}

function showOpponent() {
  showCreature(opponent, { facing: "right" });
}

function showOpponentDead() {
  showCreature(opponent, { facing: "right" });
}
