// Generated by CoffeeScript 1.7.1
var HashMap, Map, altar, biomeGrid, braintree, chapel, city, compass, courtyard, deltas, desert, dungeon, entranceHall, fallenIdol, fellwood, flour, garbagePit, generate, graffiti, hall, house, hovel, iceShelf, idolState, inn, ironSpikes, junk, keep, kitchen, lantern, layout, majorBuildings, map, mill, minorBuildings, mire, monolith, mountain, mystery, noise, oubliette, overgrowth, overworld, overworldRoom, petrifiedForest, prison, rainforest, rope, ruin, sacrificalChamber, sahvanna, seed, shaft, shrine, skeleton, steppe, store, supplies, temple, templePlan, title, trait, treasureRoom, treasures, vestry, warehouse;

HashMap = Map;

Map = (function() {
  function Map(size, generator) {
    this.map = {};
    this.size = size || 3;
    this.generator = generator || overworld;
  }

  Map.prototype.set = function(x, y, z, room) {
    var id;
    id = x + y * 1000 + z * 1000000;
    this.map[id] = room;
    return room.location = {
      x: x,
      y: y,
      z: z,
      map: this
    };
  };

  Map.prototype.get = function(x, y, z) {
    var id;
    id = x + y * 1000 + z * 1000000;
    if (!this.map[id]) {
      this.generator(x, y, z, this);
    }
    return this.map[id];
  };

  Map.prototype.poke = function(x, y, z) {
    var id;
    id = x + y * 1000 + z * 1000000;
    return this.map[id];
  };

  return Map;

})();

seed = Math.random() * 1000000;

noise = new SimplexNoise();

map = void 0;

generate = function() {
  return map = new Map(3, overworld);
};

overworld = function(x, y, z, map) {
  var px, py, room, _i, _ref, _results;
  px = Math.floor(x / 3) * 3;
  py = Math.floor(y / 3) * 3;
  _results = [];
  for (y = _i = py, _ref = py + map.size - 1; py <= _ref ? _i <= _ref : _i >= _ref; y = py <= _ref ? ++_i : --_i) {
    _results.push((function() {
      var _j, _ref1, _results1;
      _results1 = [];
      for (x = _j = px, _ref1 = px + map.size - 1; px <= _ref1 ? _j <= _ref1 : _j >= _ref1; x = px <= _ref1 ? ++_j : --_j) {
        room = overworldRoom(x, y);
        _results1.push(map.set(x, y, z, room));
      }
      return _results1;
    })());
  }
  return _results;
};

overworldRoom = function(x, y) {
  var ix, iy, room;
  room = new Room();
  room.temperature = noise.noise3D(x / 10, y / 10, 100);
  room.rainfall = noise.noise3D(x / 10, y / 10, 10000);
  room.altitude = noise.noise3D(x / 10, y / 10, 1000000);
  room.outdoors = true;
  ix = parseInt(room.temperature * 1.5 + 1.49);
  iy = parseInt(room.rainfall * 1.5 + 1.49);
  biomeGrid[iy][ix](room);
  if (oneIn(60)) {
    city(room);
  }
  if (oneIn(10)) {
    graffiti(room);
  }
  if (oneIn(6)) {
    animals(room);
  }
  if (oneIn(1000)) {
    mystery(room);
  }
  if (oneIn(100)) {
    braintree(room);
  }
  if (ix === 2 && iy === 2) {
    overgrowth(room);
  }
  return room;
};

mystery = function(room) {
  switch (between(0, 3)) {
    case 0:
      return get(room, new Thing({
        name: "" + (oneOf(["white", "shining", "dark", "ruined", "infinitely tall", "twisted", "living", "crystal"])) + " tower",
        size: 5000,
        enter: function() {
          return Say("A mysterious force prevents your entry.");
        }
      }));
    case 1:
      return get(room, new Thing({
        name: capitalize("" + (oneOf(getWords(ADJECTIVE))) + " Mountain"),
        size: 4000,
        singular: true,
        enter: function() {
          return Say("You cannot climb the mountain unaided.");
        }
      }));
    case 2:
      return get(room, new Thing({
        name: "the Colossus of Rhodes",
        size: 3000,
        singular: true
      }));
  }
};

graffiti = function(thing) {
  var message, target;
  if (thing.contents) {
    target = oneOf(thing.contents);
    switch (magnitude(4)) {
      case 0:
        message = oneOf(rumours);
        break;
      case 1:
        message = proverb();
        break;
      case 2:
        message = "" + (vulgarity()) + ", I'm " + (oneOf(getWords(ADJECTIVE))) + "!";
        break;
      case 3:
        message = oneOf(getWords(0)).toUpperCase() + "!";
        break;
      default:
        message = "The magic word is " + oneOf(Object.keys(magicWords));
    }
    return get(target, new Writing({
      hand: "scratched",
      message: message
    }));
  }
};

city = function(room) {
  var b, building, i, _i, _j, _ref, _ref1, _results;
  b = oneOf(majorBuildings);
  building = b();
  get(room, building);
  layout(building, building.layout(), void 0, 1, 1, 0);
  for (i = _i = 0, _ref = between(2, 4); 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
    b = oneOf(minorBuildings);
    building = b();
    get(room, building);
    layout(building, building.layout(), void 0, 1, 1, 0);
  }
  switch (between(0, 10)) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      _results = [];
      for (i = _j = 0, _ref1 = between(2, 5); 0 <= _ref1 ? _j < _ref1 : _j > _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
        _results.push(get(room, new Villager()));
      }
      return _results;
      break;
    case 7:
    case 8:
      return get(room, skeleton());
    case 9:
      return get(room, new Thing({
        name: "strange dust",
        relation: relation.stained
      }));
  }
};

chapel = function() {
  return new Building({
    name: "chapel",
    contents: [
      new Thing({
        name: "steeple",
        relation: relation.on
      }), new Thing({
        name: "stained-glass window",
        material: glass,
        relation: relation.decorated,
        quantity: 10
      })
    ],
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [entranceHall];
      l[entranceHall] = [altar, vestry];
      return l;
    }
  });
};

keep = function() {
  return new Building({
    name: "keep",
    contents: [
      new Thing({
        name: "battlements"
      })
    ],
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [courtyard];
      l[courtyard] = [oubliette, hall, kitchen];
      l[oubliette] = [dungeon];
      l[dungeon] = [[dungeon, null], [dungeon, null], [treasureRoom, null, null, null, null, null]];
      l[kitchen] = [store];
      return l;
    }
  });
};

mill = function() {
  return new Building({
    name: "mill",
    contents: [
      new Thing({
        name: "vanes"
      })
    ],
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [shaft];
      return l;
    }
  });
};

house = function() {
  return new Building({
    name: "house",
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [[kitchen, kitchen, kitchen, oubliette, vestry, store]];
      l[oubliette] = [dungeon];
      l[dungeon] = [[dungeon, null], [dungeon, null], [treasureRoom, null, null, null, null, null]];
      l[kitchen] = [store];
      return l;
    }
  });
};

inn = function() {
  return new Building({
    name: "inn",
    contents: [
      new Thing({
        name: "quaint sign",
        relation: relation.decorated,
        contents: [
          new Writing({
            message: "The " + (capitalize(oneOf(getWords(ADJECTIVE)))) + " " + (capitalize(oneOf(getWords(NOUN)))),
            hand: "printed"
          })
        ]
      })
    ],
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [hall];
      l[hall] = [kitchen];
      return l;
    }
  });
};

warehouse = function() {
  return new Building({
    name: "warehouse",
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [store];
      return l;
    }
  });
};

hovel = function() {
  return new Building({
    name: "hovel",
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [ruin];
      return l;
    },
    flavour: "rot"
  });
};

garbagePit = function() {
  return new Building({
    name: "garbage pit",
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [ruin];
      return l;
    },
    flavour: "filth"
  });
};

prison = function() {
  return new Building({
    name: "prison",
    layout: function() {
      var l;
      l = new HashMap();
      l["start"] = [ruin];
      return l;
    }
  });
};

majorBuildings = [chapel, keep, mill];

minorBuildings = [house, house, house, inn, warehouse, hovel, garbagePit, prison];

altar = function() {
  return new Room({
    name: 'Altar',
    contents: [
      new Thing({
        name: 'altar',
        size: 50,
        contents: [
          new Thing({
            name: 'chalice',
            relation: relation.on,
            contents: [
              new Thing({
                name: 'holy water',
                pluralNoun: true,
                material: water
              })
            ]
          }), new Thing({
            name: 'brocaded cloth',
            relation: relation.on
          })
        ]
      })
    ]
  });
};

vestry = function() {
  return new Room({
    name: 'Vestry',
    contents: [
      new Thing({
        name: 'robe',
        quantity: between(1, 4)
      }), oneOf(supplies)()
    ]
  });
};

courtyard = function() {
  return new Room({
    name: 'Courtyard'
  });
};

hall = function() {
  return new Room({
    name: 'Great Hall',
    contents: [
      new Thing({
        name: 'table',
        quantity: 10,
        size: 50,
        contents: [
          new Thing({
            name: "plate",
            quantity: 10,
            relation: relation.on,
            contents: [
              new Thing({
                name: "steaming food",
                quantity: 10,
                nutrition: 10,
                relation: relation.of
              })
            ]
          })
        ]
      }), new Thing({
        name: 'burning torch',
        quantity: 8
      })
    ]
  });
};

kitchen = function() {
  return new Room({
    name: 'Kitchen',
    contents: [
      new Thing({
        name: 'hook',
        quantity: 10,
        size: 50,
        contents: [
          new Thing({
            name: "raw meat",
            quantity: 10,
            nutrition: 10,
            relation: relation.hanging
          }), new Thing({
            name: oneOf(["onion", "garlic", "herb", "potato", "celery", "radish"]),
            quantity: 10,
            nutrition: 10,
            relation: relation.hanging
          })
        ]
      })
    ]
  });
};

shaft = function() {
  var r;
  r = new Room({
    name: 'Shaft',
    contents: [
      new Thing({
        name: 'rotating shaft'
      })
    ]
  });
  get(r, flour());
  return r;
};

store = function() {
  var i, r, s, _i;
  r = new Room({
    name: 'Storeroom'
  });
  get(r, oneOf(supplies)());
  s = new Thing({
    name: 'shelf'
  });
  for (i = _i = 0; _i < 3; i = ++_i) {
    get(s, oneOf(supplies)());
  }
  get(r, s);
  return r;
};

ruin = function() {
  var i, r, _i;
  r = new Room({
    name: 'Ruins'
  });
  for (i = _i = 0; _i < 3; i = ++_i) {
    get(r, new Thing({
      name: oneOf(junk),
      quantity: 20
    }));
  }
  return r;
};

flour = function() {
  return new Thing({
    name: oneOf(["bag", "box", "crate", "sack", "vase"]),
    contents: [
      new Thing({
        name: "flour",
        pluralNoun: true,
        nutrition: 10,
        flavour: 'gritty dust'
      })
    ]
  });
};

lantern = function() {
  return new Thing({
    name: "brass lantern",
    lightsource: true
  });
};

compass = function() {
  return new Thing({
    name: "compass",
    readby: function(thing) {
      return see("The needle flickers unpredictably. Fortunately, you have a always had an innate sense of orientation.");
    }
  });
};

rope = function() {
  return new Thing({
    name: "rope"
  });
};

ironSpikes = function() {
  return new Thing({
    name: "iron spike",
    quantity: between(3, 10)
  });
};

petrifiedForest = function(room) {
  room.name = title(ARCHAIC);
  room.preface = "Half-hidden by stark shadows you see ";
  return get(room, new Thing({
    name: 'fossilised tree',
    quantity: 20,
    size: 50,
    material: wood
  }));
};

steppe = function(room) {
  room.name = title(WILD);
  room.preface = "In this vast expanse is ";
  get(room, new Thing({
    name: 'rolling grasslands',
    pluralNoun: true
  }));
  if (oneIn(10)) {
    get(room, new Thing({
      name: 'ridge of stone',
      size: 100
    }));
  }
  if (oneIn(10)) {
    get(room, new Thing({
      name: 'sinkhole',
      enterby: function(thing) {
        see("#1 fall#s to their death.", thing);
        return thing.hp = 0;
      }
    }));
  }
  if (oneIn(10)) {
    return get(room, new Thing({
      name: 'stand of oaks',
      size: 100
    }));
  }
};

iceShelf = function(room) {
  room.name = title(COLD);
  room.preface = "Glittering with frost you see ";
  get(room, new Thing({
    name: 'sheets of ice',
    pluralNoun: true
  }));
  if (oneIn(5)) {
    oneOf([temple, fallenIdol, shrine, monolith])(room);
  }
  if (oneIn(15)) {
    get(room, new Thing({
      name: 'iceberg',
      size: 100
    }));
  }
  if (oneIn(150)) {
    return get(room, new Thing({
      name: 'frozen mammoth',
      size: 100
    }));
  }
};

mountain = function(room) {
  room.name = title(oneOf([WILD, ELEVATED]));
  room.preface = "On this precipice with you is ";
  if (oneIn(2)) {
    get(room, new Thing({
      name: 'stunted vegetation',
      pluralNoun: true
    }));
  }
  if (oneIn(10)) {
    get(room, new Thing({
      name: 'bolt of saffron cloth'
    }));
  }
  if (oneIn(15)) {
    return get(room, new Thing({
      name: 'cairn of giant boulders with eerie lights dancing over it',
      size: 100
    }));
  }
};

fellwood = function(room) {
  var h, w;
  room.name = title(oneOf([NATURAL, EVIL]));
  room.preface = "Among the gloaming shadows is ";
  get(room, new Thing({
    name: 'twisted tree',
    quantity: 20,
    size: 50,
    material: wood
  }));
  if (oneIn(50)) {
    get(room, new Thing({
      name: 'a ring of standing stone',
      quantity: 20,
      size: 150,
      unsteady: true,
      enterby: function() {
        see("There is a flash of light--");
        get(world.get(between(-10, 10), between(-10, 10), 0), player);
        return look(player.inside);
      }
    }));
  }
  if (oneIn(20)) {
    h = hovel();
    get(room, h);
    layout(h, h.layout(), void 0, 1, 1, 0);
  }
  if (oneIn(20)) {
    h = house();
    h.name = "witch's cottage";
    h.synonyms.push("cottage");
    get(room, h);
    layout(h, h.layout(), void 0, 1, 1, 0);
    w = new Villager;
    w.name = "witch";
    w.synonyms.push("witch");
    h.synonyms.push("her");
    return get(h.contents[0], w);
  }
};

mire = function(room) {
  room.name = title(EVIL);
  room.preface = "Suffering the stench of evil is ";
  get(room, new Thing({
    name: "" + (oneOf(getWords(EVIL | ADJECTIVE))) + " tree",
    quantity: 10,
    flavour: 'menace'
  }));
  if (oneIn(2)) {
    get(room, new Thing({
      name: 'reed',
      quantity: 20
    }));
  }
  if (oneIn(5)) {
    get(room, new Thing({
      name: "poison mushroom",
      quantity: between(1, 4),
      flavour: "death"
    }));
  }
  if (oneIn(50)) {
    return get(room, skeleton());
  }
};

desert = function(room) {
  var p;
  room.name = title(oneOf([GRAND, HOT]));
  room.preface = "Half-buried in sand you see ";
  if (oneIn(20)) {
    p = new Building({
      name: "pyramid",
      size: 2000
    });
    get(room, p);
    layout(p, templePlan, void 0, 1, 1, 0);
  }
  if (oneIn(2)) {
    get(room, new Thing({
      name: 'crumbled masonry',
      size: 50,
      flavour: 'acrid dust',
      pluralNoun: true
    }));
  }
  if (oneIn(5)) {
    return get(room, new Thing({
      name: 'cacti',
      pluralNoun: true,
      nutrition: 5
    }));
  }
};

sahvanna = function(room) {
  room.name = title(WILD);
  room.preface = "Scattered around this vast expanse you discover ";
  if (oneIn(2)) {
    get(room, new Thing({
      name: 'shattered stone',
      quantity: 20,
      size: 50,
      flavour: 'acrid dust'
    }));
  }
  if (oneIn(5)) {
    get(room, new Thing({
      name: 'waterhole',
      size: 50,
      nutrition: 10,
      material: water
    }));
  }
  if (oneIn(5)) {
    return get(room, new Thing({
      name: "" + (oneOf(getWords(WILD | ADJECTIVE))) + " banyan tree",
      size: 50,
      quantity: between(1, 4)
    }));
  }
};

rainforest = function(room) {
  room.name = title(NATURAL);
  room.preface = "Pressing close around are ";
  get(room, new Thing({
    name: 'colossal tree',
    quantity: 20,
    size: 250,
    material: wood,
    contents: [
      new Thing({
        name: 'liana',
        quantity: 20,
        size: 50,
        material: vegetable,
        relation: relation.hanging
      })
    ]
  }));
  if (oneIn(5)) {
    return oneOf([temple, fallenIdol, shrine, monolith])(room);
  }
};

overgrowth = function(room) {
  var thing, _i, _len, _ref, _results;
  _ref = room.contents;
  _results = [];
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    thing = _ref[_i];
    if (thing.material === stone) {
      _results.push(get(thing, new Thing({
        name: oneOf(['moss', 'ivy', 'fern', 'unnatural fungus', 'kudzu', 'lurid flower', 'lily', 'rose', 'rush']),
        relation: relation.overgrown,
        quantity: 10,
        flavour: 'dizzying sensations'
      })));
    } else {
      _results.push(void 0);
    }
  }
  return _results;
};

temple = function(room) {
  var b;
  b = new Building({
    name: 'ancient temple',
    size: 100,
    material: stone,
    postfix: ", its shattered doors breathing forth a fetid breath of evil"
  });
  get(room, b);
  return layout(b, templePlan, void 0, 1, 1, 0);
};

deltas = [[0, -1], [1, -1], [1, 0], [1, 1], [0, 1], [-1, 1], [-1, 0], [-1, -1]];

layout = function(building, plan, room, x, y, z) {
  var dir, entry, n, next, nextRoom, r, _i, _len, _ref;
  if (!plan) {
    return;
  }
  if (!room) {
    room = oneOf(plan["start"]);
    if (typeof room === 'object') {
      room = oneOf(room);
    }
    entry = true;
  }
  if (!building.map) {
    building.map = new Map();
  }
  r = room(building);
  get(building, r);
  try {
    building.map.set(x, y, z, r);
  } catch (_error) {
    debugger;
  }
  if (entry) {
    r.exits[4] = building.inside;
  }
  if (!plan[room]) {
    return r;
  }
  _ref = plan[room];
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    next = _ref[_i];
    if (typeof next === 'object') {
      nextRoom = oneOf(next);
    } else {
      nextRoom = next;
    }
    if (nextRoom) {
      dir = between(0, 4) * 2;
      if (!r.exits[dir]) {
        if (!building.map.poke(x + deltas[dir][0], y + deltas[dir][1], z)) {
          x += deltas[dir][0];
          y += deltas[dir][1];
          n = layout(building, plan, nextRoom, x, y, z);
          n.exits[(dir + 4) % 8] = r;
          r.exits[dir] = n;
        }
      }
    }
  }
  return r;
};

entranceHall = function(building) {
  return new Room({
    name: 'Entrance Hall',
    contents: [
      new Thing({
        name: 'rows of basalt pillars',
        pluralNoun: true,
        size: 50
      })
    ]
  });
};

sacrificalChamber = function() {
  return new Room({
    name: 'Sacrificial Chamber',
    contents: [
      new Thing({
        name: 'grim slab',
        contents: [
          new Thing({
            name: 'blood',
            relation: relation.stained,
            pluralNoun: true
          })
        ],
        size: 50
      })
    ]
  });
};

oubliette = function() {
  return new Room({
    name: 'Oubliette'
  });
};

dungeon = function() {
  var r;
  r = new Room({
    name: title(CTHONIC)
  });
  if (oneIn(10)) {
    get(r, skeleton());
  }
  if (oneIn(10)) {
    get(r, new Thing({
      name: "locked hatch in the floor"
    }));
  }
  return r;
};

skeleton = function() {
  var s, t;
  s = new Thing({
    name: "skeleton"
  });
  t = oneOf(supplies)();
  t.relation = relation.holding;
  get(s, t);
  return s;
};

treasureRoom = function() {
  var t, treasure;
  t = oneOf(treasures);
  treasure = new t();
  treasure.relation = relation.on;
  return new Room({
    name: 'Treasure Room',
    contents: [
      new Thing({
        name: 'jewlled dais',
        contents: [treasure],
        size: 50
      })
    ]
  });
};

templePlan = new HashMap();

templePlan["start"] = [entranceHall];

templePlan[entranceHall] = [sacrificalChamber, oubliette];

templePlan[oubliette] = [dungeon];

templePlan[dungeon] = [[dungeon, null], [dungeon, null], [treasureRoom, null, null, null, null, null]];

fallenIdol = function(room) {
  return get(room, new Thing({
    name: "" + (oneOf(idolState)) + " idol of a " + (oneOf(trait)) + " god",
    material: stone,
    size: 50,
    unsteady: true
  }));
};

idolState = ['fallen', 'shattered', 'toppled', 'unsanctified', 'forgotten', 'nameless', 'unhallowed', 'fearsome'];

trait = ['one-eyed', 'cruel', 'fanged', 'alien', 'three-eyed', 'blind', 'unknown'];

shrine = function(room) {
  return get(room, new Thing({
    name: "shrine to a " + (oneOf(trait)) + " god",
    material: stone,
    size: 50
  }));
};

monolith = function(room) {
  return get(room, new Thing({
    name: 'monolith',
    material: stone,
    size: 50
  }));
};

braintree = function(room) {
  return get(room, new Animal({
    name: "braintree",
    act: function() {
      if (oneIn(2)) {
        switch (magnitude(10)) {
          case 0:
            return hear("#1 announces '" + (oneOf(getWords(FUN))) + ".'", this);
          case 1:
            return hear("#1 hisses '" + (oneOf(getWords(0))) + ".'", this);
          case 2:
            return hear("#1 whispers '" + (oneOf(heroes).name) + ".'", this);
          case 3:
            return hear("#1 announces '" + (oneOf(Object.keys(magicWords))) + ".'", this);
          default:
            return hear("#1 whispers '" + (oneOf(["Aras...", "Plotkin...", "Gjisbers..."])) + "'", this);
        }
      }
    }
  }));
};

title = function(mask, reject) {
  switch (between(0, 6)) {
    case 0:
      return "the " + (oneOf(getWords(mask))) + " " + (oneOf(getWords(NOUN))) + " " + (oneOf(getWords(PLACE)));
    case 1:
      return "the " + (oneOf(getWords(mask | NOUN))) + " of " + (oneOf(getWords(mask, ADJECTIVE)));
    case 2:
      return "the " + (oneOf(getWords(mask | ADJECTIVE))) + " " + (oneOf(getWords(NOUN)));
    case 3:
      return "the " + (oneOf(getWords(VERB))) + (oneOf(['ing', 'ed'])) + " " + (oneOf(getWords(mask | PLACE)));
    case 4:
      return "" + (oneOf(getWords(mask | NOUN))) + " " + (oneOf(getWords(mask | PLACE)));
    case 5:
      return "" + (oneOf(getWords(mask | NAME))) + "'s " + (oneOf(getWords(mask | oneOf([PLACE, NOUN, VERB, ADJECTIVE]))));
  }
};

biomeGrid = [[petrifiedForest, steppe, iceShelf], [mountain, fellwood, mire], [desert, sahvanna, rainforest]];

treasures = [Aleph, Diamond, CrystalSkull];

junk = ['wood scrap', 'tinder', 'broken brick', 'rusted iron', 'broken chain', 'bone', 'leaf', 'rope'];

supplies = [flour, lantern, compass, rope, ironSpikes];
