import "story/recess"

function trial()
	clearText()
	image("courtroom", "cover")

	text [[You are brought into a circular room with rows of stands facing a barred central dock. It reminds you of a state-of-the-art surgery theatre, the kind they have in cities like Aquae-Equae or Urbslanding. At the desk facing the door sits Milpreve, surrounded by papers and books.]]

	text [[Between his finger and thumb, he holds a small folio that appears to be dripping; he mumbles something about the dratted canal before setting it on the floor under his seat with a squelch.]]

	text [[The vultures are perched on a railing close by, and on the left-hand side of the room, Hobson is tucked into a seat.]]

	text [[Behind you through the open door comes Scowles, carrying the marble statue of Queen Gwenhaela as if it was made of plaster. He places it carefully at the far end of the room and takes up position beside it.]]

	image "milpreve"
	text [[Milpreve speaks first. "I call to order the trial of $(playerTitle) $(playerFirstName) $(playerLastName), aspirant, on charges of –"]]

	choice([["Wait!"]], "trial_wait")
end

function trial_wait()
	text [[Milpreve stops. "Wait? For what?"]]

	choice([["I don't understand. Am I on trial for something I've done, or is this a hearing to decide whether I'm to become a True Citizen?"]], "trial_purpose")
end

function trial_purpose()
	text [["The latter question will depend upon the former," says Leofric. "You must answer for your criminal conduct before the question of True Citizenship can be decided."]]

	text [[Milpreve sets his paper down. "You were apprehended in the Outer City. Sleeping," he glances down, "without due care and attention. How do you plead?"]]

	jump "trial_plea"
end

function trial_plea()
	choiceOnce([["This is absurd! There must be some kind of mistake."]], "trial_pleaMistake")
	choice([["Well…not guilty?"]], "trial_notGuilty")
end

function trial_pleaMistake()
	text [["I must ask you again how you plead."]]

	jump "trial_plea"
end

function trial_notGuilty()
	text [["Very well. Leofric?"]]

	image "vultures"

	text [[The left-head lawyer clears his throat. "I call Scowles to the witness-stand.]]

	text [["Er. In a manner of speaking, by which I mean that Scowles should remain in his current position. I'm not sure the witness stand is capacious enough. Now."]]

	text [[He turns to address the dendritic servitor.]]

	text [["You encountered the defendant in the Outer City and brought her inside, correct?"]]

	image("scowles", "cover")

	text [["THAT IS CORRECT."]]

	text [["And what condition would you say she was in, at this time?"]]

	text [["I BELIEVE SHE WAS ASLEEP."]]

	text [["Thank you, Scowles. That will be all."]]

	image("courtroom", "cover")

	choice([["Hold on. Don't I get to ask anything?"]], "trial_questionScowles")
end

function trial_questionScowles()
	text [[You turn to Leofwine, who blinks. "Oh. Yes! The defence has some questions for the witness." He stops and thinks for a few seconds, then turns to look at you expectantly.]]

	jump "trial_scowlesHub"
end

function trial_scowlesHub()
	image("scowles", "cover")

	choiceOnce([["I've never been to the Outer City!"]], "trial_notAQuestion")
	choiceOnce([["Where is the Outer City, exactly?"]], "trial_outerCity")
end

function trial_notAQuestion()
	image "vultures"

	text [["Objection!" cries Leofric. "That is a *statement* and not a *question*."]]

	image "milpreve"

	text [["Sustained," says Milpreve. "The defendant will refrain from making any further claims, assertions, propositions, or declarations."]]

	jump "trial_scowlesHub"
end

function trial_outerCity()
	text [["IT IS THE OUTER PART OF GALLOS. IT IS BEYOND THE WALLS."]]

	text [["So where does it begin and end? Gallos doesn't cover the whole world!"]]

	image "vultures"

	text [[Leofric interjects. "The boundaries of the Outer City have never been fixed in statute. We may only say that it encompasses that which lies outside the city proper."]]

	jump "trial_outerCityHub"
end

function trial_outerCityHub()
	text [["But if that's the case, then…"]]

	choiceOnce([["…anyone could leave at any time!"]], "trial_anyoneLeave")
	choiceOnce([["…how can you prove we're in Gallos now?"]], "trial_proveGallos")
	choice([["…you'd have to put everyone in the world on trial."]], "trial_worldTrial")
end

function trial_anyoneLeave()
	image "vultures"

	text [["The rights of True Citizens and other denizens of Gallos, vis-à-vis their movements around the City and passage through its various gates, are firmly established in extant law. No part of this requires that the Outer City have a *fixed* or even *defined* boundary, and therefore no extraneous effort has been expended to establish one."]]
	jump "trial_outerCityHub"
end

function trial_proveGallos()
	image "vultures"

	text [["A fatuous question. The City proper is circumscribed by its great stone wall, which we are now within, denoted by the statue of Her Serenity, in the presence of which we now stand, and bound by its laws, to which we are all of us subject. And you, $(playerTitle) $(playerLastName), are no exception!"]]
	jump "trial_outerCityHub"
end

function trial_worldTrial()
	image "vultures"

	text [[When the birds look at each other, you continue.]]

	text [["There are only three of you! Think of the effort involved! If you established that precedent you'd cause all kinds of trouble for yourselves!"]]

	text [["Actually," Leofwine interjects hurriedly, "although *legislatively* there is indeed no document which fixes the extents of the Outer City, by *convention* the jurisdiction of the city authorities stops at the gatefold, which marks the border of the Undermarch."]]

	choice([["So, Scowles, when you found me, was I in the Undermarch or overward?"]], "trial_sleepingLocation")
end

function trial_sleepingLocation()
	image("scowles", "cover")

	text [["Because," you continue, "when we spoke earlier, you said that both Undermarch and overward were open to you. And the places between."]]

	text [["YES," Scowles's voice is thunder echoing through the trunks of a forest. "THE PLACES BETWEEN."]]

	text [["So, do you remember which it was? Because I've never been to the Undermarch before. I'd never even heard of it! I'd never in a thousand years know how to get here by myself."]]

	text [[Scowles is silent for a moment.]]

	image "vultures"

	text [[Leofric cuts in: "This line of questioning is-"]]

	text [["Material to the facts of the case, yes," says Leofwine. "We must firmly establish whether or not $(playerTitle) $(playerLastName) was *corporeally* in the Undermarch at the time of the alleged sleeping incident."]]

	text [[Leofric snaps his beak shut audibly and stares at Leofwine., who continues. "In order to establish that a crime has taken place, it must be *proved beyond doubt* that the defendant was in the environs of Gallos itself, that being the Outer City, and not overward."]]

	image "hobson"

	text [[Hobson, watching from the corner, makes a rather theatrical waggle of the brim of his hat, and continues to make celebratory gestures with his thumbs until Milpreve's glare subdues him into a state of sombre fascination with his feet.]]

	image("scowles", "cover")

	text [["I CANNOT SAY FOR CERTAIN."]]

	text [[There is a brief silence.]]

	image "milpreve"

	text [["If the facts of the crime cannot be firmly established," Milpreve says, "then it must be considered *unsolvable*."]]

	text [[Leofwine, seeming invigorated, squawks, "Unsolvable? The crime cannot be proved to have actually happened! Without evidence to substantiate, I must insist that–"]]

	text [[Milpreve cuts him off. "If a crime was committed, but the court does not possess the facts pertaining to it, then it cannot be solved. It is an unsolvable crime.]]

	text [["If a crime did *not* take place, then nothing can be known about it, and therefore that, too, is an unsolvable crime.]]

	text [["Simple logic. Even $(playerTitle) $(playerLastName) would have to agree."]]

	choice([["Oh. Yes, that makes sense."]], "trial_nonsense")
	choice([["All of this is complete nonsense!"]], "trial_nonsense")
end

function trial_nonsense()
	image "milpreve"

	text [["Exactly. Now, under certain circumstances the court can be persuaded to remain incurious about irrelevant facts pertaining to True Citizens."]]

	text [[Milpreve's tongue flicks out, once, like a riding whip.]]

	text [["But, for having wasted the court's time, an *aspirant* might be held in contempt, carrying a sentence of imprisonment.]]

	text [["This distinction, then, brings us to the initial purpose of this hearing."]]

	text [[Milpreve turns a few pages on his ledger book.]]

	clearText()
	image("courtroom", "cover")

	text [["And so we move on to the next item to be determined: whether or not $(playerTitle) $(playerLastName) deserves to be made a True Citizen."]]

	jump "trial_testStart"
end

function trial_testStart()
	image("courtroom", "cover")
	choiceOnce([["What makes you think I want to become a True Citizen? I never even asked to be considered!"]], "trial_neverAsked")
	choice([["I'm ready. What are the requirements?"]], "trial_requirements")
end

function trial_neverAsked()
	image "milpreve"
	text [["And yet: here you are.]]

	text [["Furthermore: the question of your criminal conduct has yet to be dispensed with. The outcome of *that* will depend upon *this*."]]
	jump "trial_testStart"
end

function trial_requirements()
	image "milpreve"

	text [[Milpreve straightens his lapels with his horned thumbs.]]

	text [["Your candidacy for True Citizenship will rest upon three pillars.]]

	text [["The first: We must ascertain that you are of good character.]]

	text [["The second: You must prove your allegiance to Her Serenity Queen Gwenhaela.]]

	text [["The third: You must prove a thorough knowledge and command of Philosophy, which shall form the bedrock of your works and thereby your worth as a Citizen.]]

	text [["Where do you wish to start?"]]

	jump "trial_impassableHub"
end

function trial_impassableHub()
	image("courtroom", "cover")
	if visited("trial_character", "trial_allegiance", "trial_philosophy") then
		jump "trial_impassableEnd"
	end
	choice([["I would like to affirm that I am of good character."]], "trial_character")
	if not trialDoneAllegiance then
		choice([["I would like to prove allegiance to Queen Gwenhaela."]], "trial_allegiance")
	end
	choice([["I would like to prove my knowledge of Philosophy."]], "trial_philosophy")
end

function trial_character()
	image "vultures"

	if not visited "trial_character" then

		text [["That will be no simple matter!" barks Leofric. "Remembrancer, ever since her arrival here the defendant has conducted herself in a manner unbecoming of even the most benighted drudge."]]

		text [[You open your mouth to protest; Leofric ploughs on heedlessly.]]

		text [["Leaving the matter of her felonious somnolence to one side – a matter which is *not* settled, might I add – she *escaped* her *cell!*]]

		text [["Furthermore, she effected her abscondence by maliciously befuddling a designated officer of the court – I refer of course to m' learned colleague Leofwine, whose judgement, as you know, is characteristically unreliable – and embarked upon a campaign of deceptive and meddlesome interference!]]

		text [["And listen to the way she communicates! She traps her victims in repetitive conversations until she hears the answer she wants."]]

		text [["Nevertheless," ventures Leofwine, "the defendant has the right to present her case. $(playerTitle) $(playerLastName), is there anyone that you would like to call as a witness? Someone who could vouch for your character?"]]
	else
		text [[Leofwine nods. "Very well. Who do you wish to summon to speak on your behalf?"]]
	end

	jump "trial_vouchHub"
end

function trial_vouchHub()
	image("courtroom", "cover")

	choiceOnce([["Couldn't you vouch for me, Leofwine?"]], "trial_callLeofwine")
	choiceOnce([["I would like to call Scowles."]], "trial_callScowles")
	choiceOnce([["I would like to call the $(gargoyleName)."]], "trial_callGargoyle")
	choiceOnce([["I would like to call Hobson."]], "trial_callHobson")
	if visited("trial_hobsonDoomed") then
		choice([["I should like to hear from Hobson again."]], "trial_callHobsonAgain")
	end
end

function trial_callLeofwine()
	image "vultures"

	text [[The double-bird double-takes. Just as Leofwine opens his beak to respond, Leofric's forehead butts into his cheek:]]

	text [["Do you recall the number of times you deceived him? And how you slipped out of confinement? All you have done here is confound people and distract them, and – " here, Leofric pauses to give the cowering Leofwine a withering stare – "cause them to express malformed ideas in need of factual correction."]]

	text [[Leofwine aims a peck towards Leofric, causing him to retreat to his hemisphere of their joint body.]]

	text [["For the sake of your case, I would urge you to choose someone else," he says.]]

	jump "trial_vouchHub"
end

function trial_callScowles()
	image "milpreve"

	text [["Out of the question," says Milpreve without hesitating. "Scowles is not suitable as a character witness."]]

	text [["Why not?"]]

	text [["Scowles is *a fact of which there is no record*. Only a True Citizen or City official recognised by the court may act as character witness."]]

	text [["So, even though he works for you, you won't let him speak?"]]

	image "vultures"

	text [[Leofwine interjects. "If I may, Remembrancer. Scowles, as neither reasonable, nor a person, could never be considered a hypothetical 'reasonable person', but as an *articulate being* his words may well be considered, just like any other object of evidence. In fact, the precedent of *Flynnhodder v Pershing's Distinctive & Exceptional Galatronick Talking Teakettle Co.* implies –"]]

	image "milpreve"

	text [[Milpreve glowers.]]

	text [["I will not allow Scowles to be called."]]

	jump "trial_vouchHub"
end

function trial_callGargoyle()
	text [[Leofwine shoots a look of desperation towards Milpreve.]]

	image "milpreve"

	text [["Understood," Milpreve says. "First we shall gather ten stonehusbands to disassemble the bricks, keeping careful notes of how they connect. Piece by piece, the door will be removed from the wall, then brought here to be reassembled using a new batch of mortar.]]

	text [[After the door is rebuilt, the $(gargoyleName) will be suitable for interrogation. Following, it then must be dismantled and reinstalled at the original site. Are you satisfied with that choice?"]]

	choice([["Yes!"]], "trial_nitwit")
	choice([["No!"]], "trial_noGargoyle")
end

function trial_nitwit()
	text [["Then you are thinking like a nitwit," Milpreve tells you, "intent on wasting time and labour. The $(gargoyleName) has too many current professional responsibilities. Under no circumstances will the door be relocated, and that is my final ruling on the matter."]]

	jump "trial_vouchHub"
end

function trial_noGargoyle()
	text [["Good. Who, then, do you intend to call?"]]

	jump "trial_vouchHub"
end

function trial_callHobson()
	image "hobson"

	text [[Hobson springs bolt upright and glances around himself, then scurries over to the podium with the humble excitement of someone who'd just won the Spring festival cake.]]

	text [["You trust me?" he squeaks, looking over at you with approval-hungry sockets. "But I have so many things I want to say, I – I should have prepared!"]]

	choice([[Give him an encouraging smile.]], "trial_hobsonSmile")
	choice([[Get Hobson to rise to the dignity of the occasion.]], "trial_hobsonDignity")
end

function trial_hobsonSmile()
	text [[As you do so, you hear Milpreve's chair creak as he shifts into position. Hobson seems to notice, because he freezes, with his hand halfway through scratching his forehead. Then, he slowly lowers it onto the podium.]]

	text [["Aha!" he begins. "Right… right!"]]

	jump "trial_hobsonDoomed"
end

function trial_hobsonDignity()
	text [[You squeeze your lips tight between your teeth and give Hobson a stare, trying to communicate to him that this is no time for mumming. He nods at you, then catches Milpreve's glower boring into him from the side and nearly slips over at the podium.]]

	text [[After regaining balance, he begins, soberly.]]

	text [["I am Mr. Edmund Hobson, the stablemaster of Gallos…" he recounts. "I am male… I'm some sort of age… my prior convictions have all been accounted for… and although I may presently lack a brain, I assure you that I am fully cognisiant!"]]

	jump "trial_hobsonDoomed"
end

function trial_hobsonDoomed()
	image "hobson"

	text [[The lawyers settle their body into place beside Hobson, who regards them with the confidence of a man with nothing left for a vulture to pick at.]]

	text [[Leofric asks, "Mr. Hobson, what is your overall impression of $(playerTitle) $(playerLastName)?"]]

	text [["I would consider her a highly intelligent and curious young woman. And an excellent listener."]]

	text [[Hobson grabs the side of the podium with his fists, looking out at the others with sudden confidence.]]

	text [["In fact, I could see it from the moment she entered my stables! She came exploring because she was interested in the sound of…"]]

	text [[Hobson stops.]]

	text [[You hear the sound of the lawyers adjusting their talons on their perch. Scowles's limbs emit a faint creak.]]

	text [[Milpreve, evidently tired of waiting, leans forward and asks, "the sound of what?"]]

	text [["The sound of my…" Hobson mumbles, then stops again.]]

	text [[He turns to the lawyers.]]

	text [["Excuse me. Which one of you do I have to talk to find out if I'm allowed to admit to a crime?"]]

	text [[Milpreve raises his voice. "If you have committed a crime, you will be punished appropriately, Hobson."]]

	text [["Well!" announces Hobson, raising a finger in the air. "Fortunately, I should never admit to any criminal activity! I would like to withdraw my testimony! Good-bye!"]]

	text [[He makes a panicked giggle, turns to step away from the podium, gets a full face of Milpreve's harrowing stare, and ducks down to hide behind the backs of the seats.]]

	text [[The lawyers, with reticence, look at one another.]]

	text [["Hobson said he withdraws his testimony," Milpreve says. His tongue flickers in and out. "The court must accept this."]]

	text [[Hobson gallops back to his original seat.]]

	trialDoneCharacter = true

	jump "trial_impassableHub"
end

function trial_callHobsonAgain()
	image "hobson"

	text [[Hobson makes his way to the podium, avoiding eyesocket contact.]]

	text [["I'm fit and veritic to exposit a bit on the witty little $(playerTitle)…" he tweedles, before falling so silent that all that can be heard is his body rattling.]]

	text [[After an awful length of time, he announces, "…but it'd indict!" and hurtles back into his original seat.]]

	text [[It is clear to you that Hobson will never be able to speak up on your behalf while Milpreve has such power over every aspect of his life. If only there was something you could do that could make him feel safe from Milpreve's legal retribution…]]

	jump "trial_impassableHub"
end

function trial_allegiance()
	image "vultures"

	text [["On this point, Remembrancer," says Leofric, "I would like to call Scowles to the witness-stand."]]

	text [[Milpreve gestures. "As before, please take the stand only in a figurative sense." Leofric turns to face him.]]

	text [["Scowles, you recently saw the defendant in the Queen's Shrine, correct?"]]

	image("scowles", "cover")

	text [["YES," creaks Scowles vegetatively.]]

	text [["And did you observe her displaying the appropriate reverence before the image of Her Serenity?"]]

	text [[Scowles is silent for a moment.]]

	text [["I SAW HER WALKING AROUND. I SAW HER LOOKING AT THINGS."]]

	text [["Oh no," says Leofwine quietly.]]

	image "vultures"

	text [["A most intriguing evasion!" Leofric sounds delighted. "Miss Treffrey, would you agree with this creature's appraisal? Were you, indeed… looking at things?"]]

	choice([["I have sometimes been known to look at things."]], "trial_lookAtThings")
	choice([["Yes, Scowles is right."]], "trial_shrineHub")
	choice([["Stop making fun of Scowles. He doesn't deserve it."]], "trial_stopMakingFun")
end

function trial_lookAtThings()
	image "vultures"
	text [["Fascinating!" crows the vulture. "And did you –"]]

	image "milpreve"
	text [[Milpreve interrupts. "The defendant will adopt the appropriate tone when addressing the court!" Leofric looks subdued.]]

	jump "trial_shrineHub"
end

function trial_stopMakingFun()
	image "vultures"
	text [["Your concern is…*admirable*." You've never seen a bird smirk before. "But, I'm afraid to say, entirely misplaced. A True Citizen should *not* concern herself with unbecoming trivialities."]]

	text [["Look," says Leofwine to you in a hushed tone, "I understand, but please, don't make this any more difficult for yourself." ]]

	text [[You look over at Scowles, who creaks slightly but remains otherwise impassive.]]

	jump "trial_shrineHub"
end

function trial_shrineHub()
	image "vultures"
	if not trialShrineIntro then
		text [["And so, may I ask, what *was* it that you saw? What did you concern yourself with, in that hallowed sanctum?"]]
		trialShrineIntro = true
	end
	choice([["I looked reverentially at the shrine room."]], "trial_shrineRoom")
	choiceOnce([["I looked reverentially at the Queen's statue."]], "trial_shrineStatue")
	choiceOnce([["I looked reverentially at Scowles."]], "trial_shrineScowles")
end

function trial_shrineRoom()
	image "vultures"
	text [["Of course you did! And did you deem it *adequate*, hmm?" He bobs agitatedly. "Did the work of those master architects and stonemasons *meet with your approval?*"]]

	choiceOnce([["Yes, er… a magnificent surroundings for Her Serenity."]], "trial_shrineOkay")
	choice([["I don't understand why you're calling it a sacred place! It's in ruins!"]], "trial_shrineRuins")
end

function trial_shrineOkay()
	image "vultures"
	text [["Very good. It is of course vital for a True Citizen to have a keen aesthetic sense. Now: what else did you see?"]]

	jump "trial_shrineHub"
end

function trial_shrineRuins()
	image "vultures"

	text [[Leofric stares at you open-beaked. Leofwine starts flapping his wing at you frantically.]]

	choice([["It's empty! It's full of rubble! There isn't even a roof! What a horrible place for the statue. Whoever's job it is to take care of the place should be ashamed!"]], "trial_rubble")
end

function trial_rubble()
	image "milpreve"

	text [["Order!" bellows Milpreve. "The manner of the statue's keeping is not an aspirant's place to judge!"]]

	choice([["The statue must have been exposed to the elements for all this time. How do you know it hasn't been damaged? I think someone should inspect it carefully to ensure that nothing–"]], "trial_elements")
end

function trial_elements()
	image "milpreve"

	text [[Milpreve's head rears up out of his collars. "Order! On no account is anyone to approach the statue of Her Serenity! The defendant will cease these outbursts immediately or be ruled in contempt!" He motions as if to stand up behind the lectern, then thinks better of it and remains seated.]]

	text [["This show of concern for the condition of Her Serenity's statue is adequate proof of allegiance for the purpose of this hearing. That will be my final decision on the matter. Let us move on."]]

	trialDoneAllegiance = true

	jump "trial_impassableHub"
end

function trial_shrineStatue()
	image "vultures"

	text [["Of course. Perhaps you'd like to share with the court what your observations were?]]

	text [["For example: what was inscribed on the brass plaque mounted on the plinth?"]]

	if shrineExaminedPlaque then
		choice([["Euphoria of Purpose."]], "trial_statueWrong")
	end
	choice([["Her Serenity Queen Gwenhaela I."]], "trial_statueWrong")
	choice([["I'm sorry, I didn't look at the plaque."]], "trial_statueWrong")
end

function trial_statueWrong()
	text [["Ah-*ha!* Ahaha-*ha!*" The sound isn't a laugh so much as an aspiration – the open-mouthed hiss of an adder preparing to bite. "And here your entire case begins to unravel! For if you had, in point of fact, examined the statue with the appropriate reverence, you would know that it has inscribed: 'Ars et Scientia'!"]]

	text [["NO," says Scowles. Both lawyers turn to look at him.]]

	text [["THAT IS NOT RIGHT," he continues. "THE PLAQUE SAYS 'EUPHORIA OF PURPOSE'.]]

	text [["I HAVE SEEN IT MANY TIMES."]]

	text [[Leofric coughs. "Well. The statue aside. What else in the shrine room piqued your curiosity, hmm?"]]

	jump "trial_shrineHub"
end

function trial_shrineScowles()
	text [["But what is so reverent about Scowles?" Leofric says, barely able to hold back a giggle.]]

	text [[You look over at Scowles again; unmoving, dark and solid. He does not seem particularly reverent, or, for that matter, irreverent – more… inevitable.]]

	text [["Nevertheless, I will accept it as testimony," Leofric says. "I ask again, what else did you look at?"]]

	jump "trial_shrineHub"
end

function trial_philosophy()
	text [[Leofwine coughs. "Er- Are you quite sure…"]]

	text [["Philosophy!" cries Milpreve, and rearranges his many documents. "A True Citizen must be inquiring and knowledgeable in all the academic arts. I will now ask you several questions concerning the fields of which you will be required to show mastery. Is that understood?]]

	text [["Good!" he says, without waiting for you to answer. "As is stipulated in the form of the proceedings, I will permit you to answer the questions in the order that you wish. The subjects are Galatology, Therianology, and Astronomy."]]

	jump "trial_philosophyHub"
end

function trial_philosophyHub()
	image("courtroom", "cover")

	if visited("trial_galatology", "trial_therianology", "trial_astronomy") then
		jump "trial_philosophyEnd"
	end

	choiceOnce([["I'm actually quite skilled at the Apothecary's art. Is that permissible?"]], "trial_noApothecary")
	choiceOnce([["Galatology."]], "trial_galatology")
	choiceOnce([["Therianology."]], "trial_therianology")
	choiceOnce([["Astronomy."]], "trial_astronomy")
	if (visited "trial_galatology" or visited "trial_therianology" or visited "trial_astronomy") and not visited "trial_challenge" then
		choice([["This is ridiculous! How can anyone who's just arrived be expected to know all this?"]], "trial_ridiculous")
	end
end

function trial_noApothecary()
	image "milpreve"

	text [[Milpreve stares at you. His tongue flickers in front of his eyes.]]

	text [[Finally, he responds: "The defendant must not try to misdirect the proceedings. The subjects are Galatology, Therianology, and Astronomy."]]

	jump "trial_philosophyHub"
end

function trial_galatology()
	image "milpreve"

	text [["On the subject of Galatology…" Milpreve ostentatiously leaves through one of the enormous tomes on the desk, then stares at it very hard for a moment.]]

	text [["The *Opus* of Izinth describes a procedure by which the sage may impart *animus* to an imago having no more than sixteen points of articulation, using the thaumatic instruments devised at Mestra. What are the three signa that must be inscribed at the fulcrum before the iteria is inset into the naos?"]]

	choice([["How…how could I possibly know that?"]], "trial_failGalatology")
end

function trial_failGalatology()
	text [["Answer not given. Let us continue."]]
	jump "trial_philosophyHub"
end

function trial_therianology()
	image "milpreve"

	text [["Therianology, then." Milpreve consults his papers. "The vital processes of disjoint genera may be made congruent by the use of certain invigorated unguents, described in detail by Vala of Ithiu, whose application must be performed under what type of theriogenic field?"]]

	choice([["I'm sorry, I simply don't know that."]], "trial_failTherianology")
end

function trial_failTherianology()
	text [["Answer not given. Very well."]]

	jump "trial_philosophyHub"
end

function trial_astronomy()
	image "milpreve"

	text [["At the twentieth hour of Midsummer, from the Grand Observatory of Gallos, the visible constellations, in accordance with the celestial schemata of the Chyrian school, are the Huntress, the Vizier, the Ox-Cart, and what other?"]]

	text [[Something sparks in your mind. You remember standing in the Queen's shrine…looking up at the sky…]]

	choice([["No stars are visible in Gallos."]], "trial_noStars")
end

function trial_noStars()
	text [[Milpreve looks down at his documents. "Incorrect. Moving on–"]]

	choice([["I've seen the sky! There's nothing! No clouds, moon, sun, stars, nothing at all!"]], "trial_noStars2")
end

function trial_noStars2()
	text [[There is silence in the courtroom.]]

	text [["Because…this is the Undermarch. You couldn't possibly do any kind of astronomy here. The stars are all somewhere else." Your plaintive tone does not appear to be inspiring any sympathy.]]

	text [["The matter of Astronomy is concluded," announces Milpreve.]]

	jump "trial_philosophyHub"
end

function trial_ridiculous()
	text [["Do you wish to formally challenge the legal basis of the test of Philosophy?"]]

	text [[Leofwine stage-whispers to you "I must sternly advise against unnecessary disputation at this juncture."]]

	choice([["Yes."]], "trial_challenge")
	choice([["No."]], "trial_philosophyHub")
end

function trial_challenge()
	text [["As the officer designate of the law, I must now take your challenge into consideration.]]

	text [["Your challenge is overruled. Once again, the subjects are Galatology, Therianology, and Astronomy."]]

	jump "trial_philosophyHub"
end

function trial_philosophyEnd()
	text [["This ends the test of Philosophy." Milpreve closes his book with a thud.]]
	jump "trial_impassableHub"
end

function trial_impassableEnd()
	text [["As all required elements of the hearing are now complete, I shall render judgement. $(playerName), your character has been found wanting, your allegiance to the city is questionable, and your knowledge of philosophy is–"]]

	image "vultures"

	text [["Objection!"]]

	image "milpreve"

	text [[Milpreve slams his notes back down and glares at Leofwine. "*What possible objection* could the defence *presume* to raise *at this juncture?*" Flecks of possibly-venomous saliva are congregating at the side of his mouth. He is visibly shaking.]]

	image "vultures"

	text [[Leofwine attempts to shrink into his shoulders. "Wait, wait, wait!" He looks at his sibling, as if hoping for him to suggest an idea.]]

	text [["*Tregaskis v Penhaligon!* The precedent – urk." He splutters. "The ruling found that an aspirant True Citizen *must* be apprised of the questions in the Test of Philosophy in advance, in order to allow them to bring explanatory notes…charts… things of that nature…"]]

	text [["What?" Leofric squawks. "Penhaligon's *Diagrámmata* were not permitted –"]]

	text [["No! But the court ruled that he was allowed to prepare them. Remembrancer, please confirm what I am saying. You have Tregaskis's trial transcribed in triplicate!"]]

	image("courtroom", "cover")

	text [[Milpreve rises from his seat with alarming speed. "The court is now in recess while I retrieve the record! When I return, the defence will withdraw unconditionally or else be held in contempt!"]]

	text [[As Milpreve disappears, Leofwine lowers his head to scream at Scowles:]]

	image "statue"

	text [["Turn the Queen! It is Her oversight that renders the court's proceedings legally binding, so what must we do now that we are in recess? Block Her eyes! Revolve the sovereign!"]]

	image("courtroom", "cover")

	text [[Without visible complaint, Scowles creaks up and, in a tender motion, turns the statue of the Queen around to face the wall.]]

	jump "recess"
end
