/*
 * Decompiled with CFR 0.152.
 */
package estancia;

import Universo.Mundo;
import Universo.Universo;
import auxiliares.Debug;
import entidad.Entidad;
import estancia.Caminos;
import estancia.EstanciaIF;
import estancia.InventarioEstancia;
import objeto.Objeto;
import objeto.ObjetoContenedor;
import parser.Orden;
import propiedades.Accion;
import puertas.Puerta;

public class Estancia
extends Universo
implements EstanciaIF {
    private String nombreUnico;
    private Caminos caminos;
    private String descripcion;
    private InventarioEstancia inventario;
    private static Estancia HABITACIONaCTUAL;
    private static Estancia HABITACIONaNTERIOR;
    private static Estancia HABITACIONsIGUIENTE;

    public Estancia(String nombre) {
        this.nombreUnico = nombre;
        this.descripcion = "";
        this.caminos = new Caminos();
        this.inventario = new InventarioEstancia(this);
        Mundo.nuevaEstancia(this);
    }

    public void init() {
        this.descripciones();
        this.salidas();
    }

    public void nuevaSalida(String exit, Estancia estancia) {
        this.caminos.crearSalida(exit, estancia);
    }

    public String getNombreUnico() {
        return this.nombreUnico;
    }

    public void setNombreUnico(String nombre) {
        this.nombreUnico = nombre;
    }

    public Caminos getCaminos() {
        return this.caminos;
    }

    public void setCaminos(Caminos camino) {
        this.caminos = camino;
    }

    public String getDescripcion() {
        return this.descripcion;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public void setInventario(InventarioEstancia inventario) {
        this.inventario = inventario;
    }

    public InventarioEstancia getInventario() {
        if (this.inventario == null) {
            System.out.println("No hay inventorio creado para " + this.getNombreUnico());
        }
        return this.inventario;
    }

    public void anadirObjetoInventario(Entidad entidad) {
        Debug.writeDebug(this, "A\u00f1adiendo a inventario de la romm: " + entidad.getNombre());
        entidad.setEstancia(this);
        if (((Objeto)entidad).getPersona() != null) {
            ((Objeto)entidad).setPersona(null);
        }
        if (entidad instanceof ObjetoContenedor) {
            ((ObjetoContenedor)entidad).setObjeto(null);
        }
    }

    public void eliminarObjetoDeInventario(Entidad entidad) {
        entidad.setEstancia(null);
    }

    public void mostrarInventario() {
        this.inventario.mostrar();
    }

    public boolean tieneAlaVista(Entidad entidad) {
        return this.inventario.getInventario().contains(entidad);
    }

    public boolean buscarObjetoDentroDe(Entidad entidad) {
        boolean out = false;
        for (Entidad unItem : this.inventario.getInventario()) {
            if (!(unItem instanceof ObjetoContenedor)) continue;
            out = ((ObjetoContenedor)unItem).estaDentro(entidad);
        }
        return out;
    }

    public boolean tiene(Entidad entidad) {
        return this.tieneAlaVista(entidad) || this.buscarObjetoDentroDe(entidad);
    }

    public boolean cambiarEstancia(Estancia nuevaEstancia) {
        if (!nuevaEstancia.antesDeEntrar()) {
            return false;
        }
        if (nuevaEstancia instanceof Puerta && !((Puerta)nuevaEstancia).getPuerta().estaAbierto()) {
            Mundo.writeln(Accion.printCondition(Accion.DOOR_CLOSED, new Entidad[0]));
            return false;
        }
        return true;
    }

    public void cambiaDeEstancia(Estancia nuevaEstancia) {
        HABITACIONsIGUIENTE = nuevaEstancia;
        if (HABITACIONaCTUAL.antesDeSalir()) {
            HABITACIONaNTERIOR = HABITACIONaCTUAL;
            HABITACIONaCTUAL = nuevaEstancia;
            HABITACIONaCTUAL.entrar();
            HABITACIONsIGUIENTE = null;
        }
    }

    public boolean antesDeSalir() {
        return true;
    }

    public boolean antesDeEntrar() {
        return true;
    }

    public void entrar() {
        this.mostrarEstancia();
    }

    public void mostrarEstancia() {
        this.descripciones();
        Mundo.writeln(HABITACIONaCTUAL.getDescripcion());
        HABITACIONaCTUAL.mostrarInventario();
        this.post_descripcion();
    }

    public void post_descripcion() {
    }

    public static void setHabitacionActual(Estancia estancia) {
        HABITACIONaCTUAL = estancia;
    }

    public static void setHabitacionAnterior(Estancia estancia) {
        HABITACIONaNTERIOR = estancia;
    }

    public static Estancia getHabitacionActual() {
        return HABITACIONaCTUAL;
    }

    public static Estancia getHabitacionAnterior() {
        return HABITACIONaNTERIOR;
    }

    public static Estancia getHabitacionSiguiente() {
        return HABITACIONsIGUIENTE;
    }

    public static void setHabitacionSiguiente(Estancia estancia) {
        HABITACIONsIGUIENTE = estancia;
    }

    public Accion parseCommand(Orden orden) {
        return Accion.NEXT;
    }

    @Override
    public void descripciones() {
    }

    @Override
    public void salidas() {
    }

    public String toString() {
        return "Room: " + this.nombreUnico + " " + this.descripcion;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

