/*
 * Decompiled with CFR 0.152.
 */
package auxiliares;

import Universo.Mundo;
import auxiliares.Debug;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import parser.Orden;
import parser.Palabra;

public class CargaLog {
    private String FILE_NAME;
    private ArrayList<Orden> carga;

    public CargaLog(String file_name) {
        this.FILE_NAME = file_name;
    }

    public void escribirFichero(ArrayList<Orden> historico) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.FILE_NAME));
            for (Orden unaOrden : historico) {
                out.write(String.valueOf(unaOrden.toString()) + "\n");
            }
            out.close();
        }
        catch (Exception e) {
            Mundo.writeln("-- Error al escribir en fichero -- ");
        }
    }

    public ArrayList<Orden> leerFichero() {
        Mundo.writeln("Leyendo fichero.");
        BufferedReader in = null;
        this.carga = new ArrayList();
        try {
            in = new BufferedReader(new FileReader(this.FILE_NAME));
            String line = in.readLine();
            while (line != null) {
                this.crearOrden(line);
                line = in.readLine();
            }
        }
        catch (Exception e) {
            Mundo.writeln("-- Error al leer fichero -- ");
        }
        return this.carga;
    }

    private void crearOrden(String in) {
        Debug.writeDebug(this, "Creando Orden de: " + in);
        Orden orden = new Orden();
        String[] words = in.split("%");
        String[] _words = null;
        String[] _argsWords = null;
        String aux = null;
        int pos = -1;
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() != 0) {
                Debug.writeDebug(this, "Analizando... " + word);
                if (word.startsWith("v=")) {
                    _words = word.split(" ");
                    aux = _words[0].substring(2, _words[0].length());
                    pos = Integer.parseInt(_words[1].trim());
                    orden.setVerbo(new Palabra(aux, pos));
                    Debug.writeDebug(this, "- Verbo encontrado: " + aux + " pos:" + pos);
                }
                if (word.startsWith("d=")) {
                    _words = word.split(" ");
                    aux = _words[0].substring(2, _words[0].length());
                    pos = Integer.parseInt(_words[1].trim());
                    orden.setcDirecto(new Palabra(aux, pos));
                    Debug.writeDebug(this, "- Cdirecto encontrado " + aux + " pos:" + pos);
                }
                if (word.startsWith("i=")) {
                    _words = word.split(" ");
                    aux = _words[0].substring(2, _words[0].length());
                    pos = Integer.parseInt(_words[1].trim());
                    orden.setcIndirecto(new Palabra(aux, pos));
                }
                if (word.startsWith("l=")) {
                    _words = word.split(" ");
                    aux = _words[0].substring(2, _words[0].length());
                    pos = Integer.parseInt(_words[1].trim());
                    orden.setcLugar(new Palabra(aux, pos));
                }
                if (word.startsWith("h=")) {
                    _words = word.split(" ");
                    aux = _words[0].substring(2, _words[0].length());
                    pos = Integer.parseInt(_words[1].trim());
                    orden.setcInstrumento(new Palabra(aux, pos));
                }
                if (word.startsWith("args=")) {
                    ArrayList<Palabra> args = new ArrayList<Palabra>();
                    String[] stringArray2 = _words = word.substring(5, word.length()).split("&");
                    int n3 = _words.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String otherWord = stringArray2[n4];
                        if (otherWord.length() != 0) {
                            Debug.writeDebug(this, " - Creando args de:" + otherWord);
                            if (!otherWord.equals("null")) {
                                _argsWords = otherWord.split(" ");
                                args.add(new Palabra(_argsWords[0], Integer.parseInt(_argsWords[1].trim())));
                            }
                        }
                        ++n4;
                    }
                    orden.setArgs(args);
                }
                if (word.startsWith("il=")) {
                    orden.setInputLine(word.substring(3, word.length()));
                    Debug.writeDebug(this, " - Input line: " + word.substring(3, word.length()));
                }
            }
            ++n2;
        }
        Debug.writeDebug(this, "Orden creada: " + orden.toString());
        this.carga.add(orden);
    }
}

