/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Habitaciones.Salon;
import Universo.Jugador;
import Universo.Mundo;
import Universo.Universo;
import auxiliares.Func;
import entidad.Entidad;
import estancia.Estancia;
import java.awt.Color;
import java.util.ArrayList;
import parser.Orden;
import propiedades.Accion;
import propiedades.Temporizador;

public class Player
extends Jugador {
    public static boolean FIN_PARTIDA = false;

    public Player(String name) {
        super(name);
    }

    @Override
    public void init() {
        this.set("aux1", 0);
        this.set("herido", false);
    }

    @Override
    public void descripcion() {
        String s = "Mi nombre Arica. Ciego de nacimiento, pero eso no me impide para nada llevar una vida normal.";
        String s1 = "\nTengo media oreja destrozada, despu\u00e9s del disparo.";
        if (this.getPropiedadBoolean("herido")) {
            s = String.valueOf(s) + s1;
        }
        this.setDescripcion(s);
        super.descripcion();
    }

    @Override
    public Accion parseCommand(Orden orden) {
        if (orden.verbo().equals("examinar") && orden.cDirecto() != null) {
            return this.redescripcion(orden);
        }
        if (orden.verbo().equals("oir") && Mundo.entidad("telefono").getPropiedadBoolean("sonando")) {
            Mundo.writeln("Escuchas el continuo sonido del tel\u00e9fono del sal\u00f3n... ring ring ring...");
            if (Estancia.getHabitacionActual().getPropiedadBoolean("haySonido")) {
                return Accion.NEXT;
            }
            return Accion.END;
        }
        return super.parseCommand(orden);
    }

    public void escenaFinal(boolean rslt) {
        if (rslt) {
            Universo.setItalic(true);
            Mundo.writelnColor("\nPasan las dos horas y recibes una llamada de tel\u00e9fono. Pero eso ya, es otra historia...", Color.blue);
            Universo.setItalic(false);
        } else {
            Mundo.writeln("No te da tiempo a escuchar el \u00faltimo CLACK... solo el zumbido de la explosion que te hace volar en pedazos.\nEst\u00e1s muerto.");
        }
        Estancia.getHabitacionActual().cambiaDeEstancia(Mundo.habitacion("limbo"));
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entidades) {
        if (orden.verbo().equals("examinar") && !entidades.contains(this) && orden.cDirecto() != null) {
            return this.redescripcion(orden);
        }
        if (orden.verbo().equals("oler") && entidades.contains(this)) {
            Mundo.writeln("No est\u00e1 mal.");
            return this.end();
        }
        return super.parseCommand(orden, entidades);
    }

    private Accion redescripcion(Orden orden) {
        String wc = "wc ba\u00f1o lavabo";
        String dormitorio = "dormitorio";
        String salon = "sal\u00f3n salon";
        String cocina = "cocina";
        String pasillo = "pasillo";
        if (Func.textosExactos(wc, orden.cDirecto()) && Estancia.getHabitacionActual().equals(Mundo.habitacion("Wc"))) {
            Estancia.getHabitacionActual().mostrarEstancia();
        } else if (Func.textosExactos(dormitorio, orden.cDirecto()) && (Estancia.getHabitacionActual().equals(Mundo.habitacion("Dormitorio")) || Estancia.getHabitacionActual().equals(Mundo.habitacion("Compi")))) {
            Estancia.getHabitacionActual().mostrarEstancia();
        } else if (Func.textosExactos(salon, orden.cDirecto()) && Estancia.getHabitacionActual().equals(Mundo.habitacion("Salon"))) {
            Estancia.getHabitacionActual().mostrarEstancia();
        } else if (Func.textosExactos(cocina, orden.cDirecto()) && Estancia.getHabitacionActual().equals(Mundo.habitacion("Cocina"))) {
            Estancia.getHabitacionActual().mostrarEstancia();
        } else if (Func.textosExactos(pasillo, orden.cDirecto()) && Estancia.getHabitacionActual().equals(Mundo.habitacion("Pasillo"))) {
            Estancia.getHabitacionActual().mostrarEstancia();
        } else {
            return Accion.NEXT;
        }
        return Accion.END;
    }

    @Override
    public void update(Temporizador temp) {
        if (Mundo.entidad("telefono").getPropiedadBoolean("sonando") && !Estancia.getHabitacionActual().equals(Mundo.habitacion("Salon"))) {
            Universo.setItalic(true);
            Mundo.writeColor("\nEl tel\u00e9fono del sal\u00f3n no para de sonar.\n", Color.ORANGE);
            Universo.setItalic(false);
        }
        if (Mundo.entidad("telefono").getPropiedadBoolean("responde_primera_llamada") && !Mundo.entidad("telefono").getPropiedadBoolean("responde_segunda_llamada")) {
            this.incrementarPropiedad("aux1");
            if (this.getPropiedadInt("aux1") == 4) {
                ((Salon)Mundo.habitacion("Salon")).disparo();
            }
        }
    }
}

