/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.ObjetoAbrible;
import parser.Orden;
import propiedades.Accion;

public class VentanaBico
extends ObjetoAbrible {
    public VentanaBico(String name) {
        super(name);
        this.setEstancia(Mundo.habitacion("Compi"));
        this.setVisible(false);
        this.setAbierto(false);
        this.setEstatico(true);
    }

    @Override
    public void init() {
        this.set("primera_descripcion", true);
        this.set("aux1", false);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("ventana", 5);
        this.nuevoNombreDeReferencia("ventanas", 6);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%ventana}", 5);
    }

    @Override
    public void descripcion() {
        String s = "Todas las ventanas del piso son de doble vidrio, el ruido que viene de la calle desde primeras horas de la ma\u00f1ana hasta bien entrada la noche es horrible. Justo en frente est\u00e1 la comisar\u00eda de polic\u00eda, sirenas van y vienen todo el d\u00eda como un compa\u00f1ero de piso m\u00e1s.\n";
        String s1 = "";
        if (this.estaAbierto()) {
            s1 = "A trav\u00e9s de la ventana entra el sonido de los coches de la calle.";
            if (this.getPropiedadBoolean("primera_descripcion")) {
                s1 = String.valueOf(s) + s1;
            }
            this.setDescripcion(s1);
        } else {
            s1 = "Por su tacto sabes que es madera a la que le hace falta una nueva capa de barniz. En los cristales se nota el fr\u00edo del invierno.";
            if (this.getPropiedadBoolean("primera_descripcion")) {
                s1 = String.valueOf(s) + s1;
            }
            this.setDescripcion(s1);
        }
    }

    @Override
    public void post_descripcion() {
        if (this.getPropiedadBoolean("primera_descripcion")) {
            this.set("primera_descripcion", false);
        }
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        if (command.verbo().equals("abrir") && !this.estaAbierto()) {
            Mundo.writeln("Abres la ventana y la temperatura de la habitaci\u00f3n empieza a descender en la misma medida en que sube el volumen del molesto ru\u00eddo de los coches y sirenas.");
            this.setAbierto(true);
            return this.end();
        }
        if (command.verbo().equals("cerrar") && this.estaAbierto()) {
            Mundo.writeln("La ventana cerrada est\u00e1 mejor, que descanso.");
            this.setAbierto(true);
            return this.end();
        }
        if (command.verbo().equals("ir") && this.estaAbierto()) {
            Mundo.writeln("Demasiado arriesgado.");
            return this.end();
        }
        if (command.verbo().equals("ir") && !this.estaAbierto()) {
            Mundo.writeln("La ventana est\u00e1 cerrada.");
            return this.end();
        }
        if (command.verbo().equals("tocar")) {
            Mundo.writeln("Notas el fr\u00edo exterior.");
            return this.end();
        }
        return super.parseCommand(command, entitys);
    }
}

