/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import entidad.Entidad;
import estancia.Estancia;
import java.util.ArrayList;
import objeto.Objeto;
import objeto.ObjetoContenedor;
import parser.Orden;
import propiedades.Accion;

public class Papelera
extends ObjetoContenedor {
    public Papelera(String nombre) {
        super(nombre);
        this.setVisible(false);
        this.setAbrible(false);
        this.setAbierto(true);
    }

    @Override
    public void init() {
        this.set("visible", false);
    }

    public void aparece() {
        if (!this.getPropiedadBoolean("visible")) {
            this.setEstancia(Mundo.habitacion("Compi"));
            this.set("visible", true);
        }
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("papelera", 5);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%papelera}", 5);
    }

    @Override
    public void descripcion() {
        String s = "Una papelera com\u00fan.";
        this.setDescripcion(s);
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entitys) {
        if (orden.verbo().equals("vaciar")) {
            if (this.vacio()) {
                Mundo.writeln("Dentro de la papelera no hay nada.");
                return this.end();
            }
            for (Entidad unItem : this.getInventario().getInventario()) {
                unItem.moverA(Estancia.getHabitacionActual());
                Mundo.writeln("Sacas de la papelera " + ((Objeto)unItem).elNombre());
            }
            return this.end();
        }
        if (orden.verbo().equals("coger")) {
            Mundo.writeln("No hace falta est\u00e1r cargando con la papelera.");
            return this.end();
        }
        if (orden.verbo().equals("mover")) {
            Mundo.writeln("Mueves la papelera y no pasa nada.");
            return this.end();
        }
        return super.parseCommand(orden, entitys);
    }
}

