/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import Universo.Universo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Orden;
import propiedades.Accion;

public class Lapiz
extends Objeto {
    public Lapiz(String nombre) {
        super(nombre);
        this.setVisible(false);
        this.setEstancia(Mundo.habitacion("Compi"));
    }

    @Override
    public void init() {
        this.set("enElEscritorio", true);
        this.set("enElSuelo", false);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("lapiz", 1);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%l\u00e1piz}", 1);
    }

    @Override
    public void descripcion() {
        this.setDescripcion("Un l\u00e1piz convencional.");
    }

    @Override
    public Accion parseCommand(Orden command, ArrayList<Entidad> entitys) {
        if (command.verbo().equals("coger")) {
            this.set("enElEscritorio", false);
            this.set("enElSuelo", true);
        }
        if (command.verbo().equals("tocar")) {
            Universo.getMundo().forceCommand("examinar lapiz");
            return this.end();
        }
        if (command.verbo().equals("dejar") && entitys.contains(Mundo.entidad("escritorio")) && !this.getPropiedadBoolean("enElEscritorio") && Mundo.getJugador().tiene(this)) {
            this.set("enElEscritorio", true);
            this.set("enElSuelo", false);
            this.moverA(Mundo.habitacion("Compi"));
            Mundo.writeln("Dejas el l\u00e1piz sobre el escritorio.");
            return Accion.STOP;
        }
        if (command.verbo().equals("mover")) {
            Mundo.writeln("Lo mueves en el aire como una varita m\u00e1gica... no pasa nada.");
            return this.end();
        }
        return super.parseCommand(command, entitys);
    }
}

