/*
 * Decompiled with CFR 0.152.
 */
package Universo;

import Universo.Mundo;
import Universo.ProcesarTag;
import gui.LecturaComando;
import gui.MyTextField;
import gui.VentanaGrafica;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import parser.Parser;
import propiedades.Accion;
import propiedades.Propiedades;
import propiedades.Temporizador;

public abstract class Universo {
    public static final int MS = 1;
    public static final int MP = 2;
    public static final int IMS = 3;
    public static final int IMP = 4;
    public static final int FS = 5;
    public static final int FP = 6;
    public static final int IFS = 7;
    public static final int IFP = 8;
    public static final int NO = 9;
    public static final String version = " -- 260120161005 -- ";
    private static String creditos;
    private Parser parser;
    private static Mundo mundo;
    private static VentanaGrafica ventanaGrafica;
    private static Color colorTag;
    private LecturaComando lecturaComando;
    private ProcesarTag tags;
    private Propiedades<Boolean> propBool = new Propiedades();
    private Propiedades<Integer> propInt = new Propiedades();
    private Propiedades<String> propString = new Propiedades();
    private Propiedades<Object> propGenerica = new Propiedades();
    private static Map<String, Temporizador> temporizadores;

    static {
        temporizadores = new HashMap<String, Temporizador>();
    }

    public Universo() {
        temporizadores = new HashMap<String, Temporizador>();
    }

    public void crearUniverso(Mundo mundo) {
        this.parser = new Parser();
        Universo.mundo = mundo;
        ventanaGrafica = new VentanaGrafica();
        this.lecturaComando = new LecturaComando(mundo);
        Universo.atributosTexto(Color.WHITE, 14, "serif");
        this.tags = new ProcesarTag();
        Accion.makeResponseTable();
    }

    public void set(String nombre, Object valor) {
        if (valor instanceof Boolean) {
            this.propBool.set(nombre, (boolean)((Boolean)valor));
        } else if (valor instanceof Integer) {
            this.propInt.set(nombre, (Integer)valor);
        } else if (valor instanceof String) {
            this.propString.set(nombre, (String)valor);
        } else {
            this.propGenerica.set(nombre, valor);
        }
    }

    public void setTiempo(String nombre, Long val) {
    }

    public void pararTiempo(String nombre) {
    }

    public static void pararTodosLosTiempos() {
        for (Temporizador temp : temporizadores.values()) {
            temp.stop();
        }
    }

    public Object get(String nombre) {
        if (this.propGenerica.get(nombre) == null) {
            return null;
        }
        return this.propGenerica.get(nombre);
    }

    public boolean getPropiedadBoolean(String nombre) {
        if (this.propBool.get(nombre) == null) {
            return false;
        }
        return this.propBool.get(nombre);
    }

    public String getPropiedadString(String nombre) {
        if (this.propString.get(nombre) == null) {
            return "";
        }
        return this.propString.get(nombre);
    }

    public Integer getPropiedadInt(String nombre) {
        return this.propInt.get(nombre);
    }

    public void incrementarPropiedad(String nombre) {
        this.propInt.set(nombre, this.propInt.get(nombre) + 1);
    }

    public void decrementarPropiedad(String nombre) {
        this.propInt.set(nombre, this.propInt.get(nombre) - 1);
    }

    public static VentanaGrafica getVentanaGrafica() {
        return ventanaGrafica;
    }

    public Parser getParser() {
        return this.parser;
    }

    public LecturaComando getLecturaComando() {
        return this.lecturaComando;
    }

    public static Mundo getMundo() {
        return mundo;
    }

    public static void setTitulo(String titulo) {
        Universo.getVentanaGrafica().setTitle(titulo);
    }

    public static void atributosTexto(Color color, int tam, String fuente) {
        ventanaGrafica.getPanel().getTextArea().atributosTexto(color, tam, fuente);
    }

    public static void setColorFuente(Color color) {
        ventanaGrafica.getPanel().getTextArea().setColorTexto(color);
    }

    public static Color getColorFuente() {
        return ventanaGrafica.getPanel().getTextArea().getColorTexto();
    }

    public static void setTamFuente(int t) {
        ventanaGrafica.getPanel().getTextArea().setFontSize(t);
    }

    public static int getTamFuente() {
        return ventanaGrafica.getPanel().getTextArea().getFontSize();
    }

    public static void setColorFondo(Color color) {
        ventanaGrafica.getPanel().getTextArea().setColorFondo(color);
    }

    public static void setUnderlineText(boolean und) {
        ventanaGrafica.getPanel().getTextArea().setUnderline(und);
    }

    public static void setItalic(boolean itl) {
        ventanaGrafica.getPanel().getTextArea().setItalic(itl);
    }

    public static void cls() {
        ventanaGrafica.getPanel().getTextArea().cls();
    }

    public static MyTextField getInput() {
        return ventanaGrafica.getPanel().getInput();
    }

    public static void setColorTagAccion(Color color) {
        colorTag = color;
    }

    public static Color getColorTagAccion() {
        if (colorTag == null) {
            return ventanaGrafica.getPanel().getTextArea().getColorTexto();
        }
        return colorTag;
    }

    public static void setCreditos(String credit) {
        creditos = credit;
    }

    public static String getCreditos() {
        return creditos;
    }

    public Accion end() {
        return Accion.END;
    }
}

