/*
 * Decompiled with CFR 0.152.
 */
package Universo;

import java.util.ArrayList;
import parser.Orden;

public class HistoricoDeOrdenes {
    private ArrayList<Orden> historico = new ArrayList();
    private int navegador = -1;

    public void setNuevaOrden(Orden orden) {
        if (this.historico != null) {
            this.historico.add(orden);
            this.reiniciarNavegador();
        }
    }

    public int getNumeroOrdenes() {
        if (this.historico != null) {
            return this.historico.size();
        }
        return 0;
    }

    public Orden getOrden(int i) {
        if (this.historico == null) {
            return null;
        }
        if (i < 0 || i > this.historico.size()) {
            return null;
        }
        return this.historico.get(i);
    }

    public ArrayList<Orden> getHistorico() {
        return this.historico;
    }

    private void reiniciarNavegador() {
        this.navegador = this.getNumeroOrdenes();
    }

    public Orden ordenAnterior() {
        Orden aux = null;
        this.retrocederNavegador();
        if (this.navegador != -1) {
            aux = this.getOrden(this.navegador);
        }
        return aux;
    }

    public Orden ordenSiguiente() {
        Orden aux = null;
        this.avanzarNavegador();
        if (this.navegador != this.getNumeroOrdenes()) {
            aux = this.getOrden(this.navegador);
        }
        return aux;
    }

    private int avanzarNavegador() {
        if (this.navegador >= 0 && this.navegador < this.getNumeroOrdenes()) {
            ++this.navegador;
        }
        if (this.navegador == this.getNumeroOrdenes()) {
            this.reiniciarNavegador();
        }
        return this.navegador;
    }

    private int retrocederNavegador() {
        if (this.navegador > 0) {
            --this.navegador;
        }
        return this.navegador;
    }
}

