/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Game.Player;
import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import objeto.ObjetoAbrible;
import parser.Orden;
import propiedades.Accion;

public class Puerta
extends ObjetoAbrible {
    public Puerta(String nombre) {
        super(nombre);
        this.setVisible(false);
        this.setEstatico(true);
        this.setAbierto(false);
        this.setNecesarioLlave(true);
        this.setCerradoConLlave(true);
        this.setEstancia(Mundo.habitacion("Pasillo"));
        this.setEstancia(Mundo.habitacion("Compi"));
    }

    @Override
    public void init() {
        this.setLlave((Objeto)Mundo.entidad("llave de bico"));
        this.set("intentos", 0);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("puerta", 5);
        this.nuevoAdjetivo("de Bico");
        this.nuevoAdjetivo("bico");
        this.nuevoAdjetivo("dormitorio");
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%puerta del dormitorio}", 5);
    }

    @Override
    public void descripcion() {
        String s1 = "Es la puerta del dormitorio de Bico.";
        this.setDescripcion(s1);
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entidades) {
        if (orden.verbo().equals("abrir")) {
            if (this.estaAbierto()) {
                Mundo.writeln("Ya est\u00e1 abierta.");
                return Accion.STOP;
            }
            if (!entidades.contains(Mundo.entidad("llave de bico")) && !entidades.contains(Mundo.entidad("llaves")) && this.cerradoConLlave()) {
                Mundo.writeln("\u00bfC\u00f3mo? \u00bfcon qu\u00e9 llave?");
                return this.end();
            }
            if (entidades.contains(Mundo.entidad("llaves")) && Mundo.entidad("llaves").presenteYvisible()) {
                if (!Mundo.habitacion("Salon").getPropiedadBoolean("disparo")) {
                    Mundo.writeln("No creo que sea correcto intentar entrar en la habitaci\u00f3n de Bico si su permiso.");
                    return this.end();
                }
                this.intentosAbrir();
                return this.end();
            }
        }
        if (orden.verbo().equals("romper")) {
            Mundo.writeln("Eso no servir\u00e1 de nada, hay que buscar la forma de abrirla.");
            return this.end();
        }
        if (orden.verbo().equals("llamar")) {
            Mundo.writeln("Toc toc toc... nadie responde.");
            return this.end();
        }
        if (orden.verbo().equals("cerrar") && this.estaAbierto()) {
            Mundo.writeln("Mejor dejarla abierta.");
            return this.end();
        }
        return super.parseCommand(orden, entidades);
    }

    private void intentosAbrir() {
        if (this.getPropiedadInt("intentos") == 2) {
            Mundo.writeln("{color%red%EST\u00c1S MUERTO}");
            Player.FIN_PARTIDA = true;
            ((Player)Mundo.getJugador()).escenaFinal(false);
            return;
        }
        if (this.getPropiedadInt("intentos") == 0) {
            Mundo.writeln("Tienes tres llaves en tu llavero.");
            Mundo.writeln("Pruebas con una de tus llaves. La llave entra correctamente pero no llega a girar.");
            Mundo.writeln("Escuchas un {color%red%\u00a1CLACK!} detr\u00e1s de la puerta... pero esta no se abre.");
        }
        if (this.getPropiedadInt("intentos") == 1) {
            Mundo.writeln("Haces la prueba con una segunda llave de tu llavero. Igualmente la llave entra en la cerradura pero no llega a girar.");
            Mundo.writeln("Escuchas otro {color%red%\u00a1CLACK!} detr\u00e1s de la puerta, este m\u00e1s largo que el primero, parece que alg\u00fan mecanismo en la puerta se est\u00e1 activando.\nLa puerta no se abre.");
        }
        this.incrementarPropiedad("intentos");
    }
}

