/*
 * Decompiled with CFR 0.152.
 */
package Game.Objetos;

import Universo.Mundo;
import entidad.Entidad;
import java.util.ArrayList;
import objeto.Objeto;
import parser.Orden;
import propiedades.Accion;

public class Libreta
extends Objeto {
    public Libreta(String nombre) {
        super(nombre);
        this.setVisible(false);
    }

    @Override
    public void init() {
        this.set("pintado", false);
        this.set("examiando", false);
        this.set("girado", false);
    }

    @Override
    public void nombreReferencia() {
        this.nuevoNombreDeReferencia("libreta", 5);
        this.nuevoNombreDeReferencia("cuaderno", 1);
        this.nuevoNombreDeReferencia("hoja", 5);
        this.nuevoNombreDeReferencia("hojas", 6);
        this.nuevoNombreDeReferencia("anotador", 1);
        this.nuevoNombreDeReferencia("bloc", 1);
    }

    @Override
    public void nombreParaMostrar() {
        this.setNombreParaMostrar("{accion%examinar%libreta}", 5);
    }

    @Override
    public void descripcion() {
        String s = "Una libreta peque\u00f1a para tomar notas, tiene pocas hojas.";
        this.setDescripcion(s);
    }

    @Override
    public void post_descripcion() {
    }

    @Override
    public Accion parseCommand(Orden orden, ArrayList<Entidad> entidades) {
        if (orden.verbo().equals("escribir")) {
            if (!entidades.contains(Mundo.entidad("lapiz"))) {
                Mundo.writeln("\u00bfC\u00f3mo? \u00bfcon qu\u00e9?");
                return this.end();
            }
            if (!Mundo.getJugador().tiene(Mundo.entidad("lapiz"))) {
                Mundo.writeln("No tienes el l\u00e1piz.");
                return Accion.STOP;
            }
            if (this.getPropiedadBoolean("examinado")) {
                Mundo.writeln("Pasas la punta de l\u00e1piz suavemente sobre la hoja de la libreta que est\u00e1 marcada.");
                this.set("pintado", true);
            } else {
                Mundo.writeln("Pasas el l\u00e1piz por una de las p\u00e1ginas de la libreta.");
            }
            return Accion.STOP;
        }
        if (orden.verbo().equals("leer") || orden.verbo().equals("apuntar") || orden.verbo().equals("se\u00f1alar")) {
            if (!entidades.contains(Mundo.entidad("movil"))) {
                Mundo.writeln("Soy ciego.");
                return this.end();
            }
            if (!Mundo.getJugador().tiene(Mundo.entidad("movil"))) {
                Mundo.writeln("No tienes el m\u00f3vil.");
                return Accion.STOP;
            }
            Mundo.writeln("Apuntas la c\u00e1mara de tu m\u00f3vil hacia la libreta y arrancas la aplicaci\u00f3n para leer textos....");
            if (this.getPropiedadBoolean("pintado") && !this.getPropiedadBoolean("girado")) {
                Mundo.writeln("El m\u00f3vil te canta {color%yellow%691918}");
                Mundo.entidad("caja fuerte").set("clave", true);
            } else if (this.getPropiedadBoolean("pintado") && this.getPropiedadBoolean("girado")) {
                Mundo.writeln("El m\u00f3vil te canta {color%yellow%816169}");
                Mundo.entidad("caja fuerte").set("clave", true);
            } else {
                Mundo.writeln("El m\u00f3vil te indica que no ha captado ninguna lectura. P\u00e1gina en blanco.");
            }
            return Accion.STOP;
        }
        if (orden.verbo().equals("tocar") || orden.verbo().equals("abrir")) {
            Mundo.writeln("Pasas la yema de los dedos por cada una de las hojas de la libreta. S\u00f3lo notas la marca de algo escrito en una de ellas. Pero s\u00f3lo palpando la hoja es imposible saber lo que hay escrito.");
            this.set("examinado", true);
            return this.end();
        }
        if (orden.verbo().equals("girar")) {
            this.set("girado", !this.getPropiedadBoolean("girado"));
            Mundo.writeln("Giras la libreta.");
            return this.end();
        }
        if (orden.verbo().equals("mover")) {
            Mundo.writeln("Mueves la libreta y no pasa nada.");
            return this.end();
        }
        return super.parseCommand(orden, entidades);
    }
}

