/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Module;
import micromod.Sequence;
import micromod.Synthesizer;

public class Sequencer {
    public static final int SEQFX_POSJUMP = 11;
    public static final int SEQFX_PATBREAK = 13;
    public static final int SEQFX_SETSPEED = 15;
    public static final int SEQFX_PATLOOP = 230;
    public static final int SEQFX_PATDELAY = 238;
    protected Sequence sequence;
    protected Synthesizer synthesizer;
    protected int[] sequenceCounter = new int[128];
    protected int sequencePosition;
    protected int currentRow;
    protected int tempo;
    protected int tempoCounter;
    protected int patternBreak;
    protected int positionJump;
    protected int rowJump;
    protected int[] patternLoopRow;
    protected int patternLoopChannel;
    protected int patternLoopCounter;
    protected boolean patternLoopEngaged;

    public Sequencer(Module module, Synthesizer synthesizer) {
        this.synthesizer = synthesizer;
        this.setModule(module);
    }

    public void setModule(Module module) {
        this.sequence = module.getSequence();
        this.patternLoopRow = new int[this.sequence.numberOfChannels];
        this.reset();
    }

    public void reset() {
        this.resetSequenceCounter();
        this.synthesizer.reset();
        this.synthesizer.setBPM(this.sequence.defaultBPM);
        this.tempo = this.tempoCounter = this.sequence.defaultTempo;
        this.sequencePosition = 0;
        this.currentRow = 0;
        this.resetPatternLoop();
        this.initializeRowFX();
    }

    public void update() {
        --this.tempoCounter;
        if (this.tempoCounter == 0) {
            this.nextRow();
            this.tempoCounter = this.tempo;
            this.initializeRowFX();
        } else {
            this.synthesizer.updateFX();
        }
    }

    public int getSequenceCounter() {
        return this.sequenceCounter[this.sequencePosition];
    }

    public void setSequencePosition(int pos) {
        this.resetSequenceCounter();
        this.updateSequencePosition(pos);
        this.updateRow(0);
        this.tempoCounter = this.tempo;
        this.initializeRowFX();
    }

    public int getSongLengthPatterns() {
        return this.sequence.songLengthPatterns;
    }

    public int getSequencePosition() {
        return this.sequencePosition;
    }

    protected void resetSequenceCounter() {
        for (int n = 0; n < 128; ++n) {
            this.sequenceCounter[n] = 0;
        }
    }

    protected void nextRow() {
        if (this.patternBreak != -1) {
            this.nextSequencePosition();
            this.updateRow(this.patternBreak);
            return;
        }
        if (this.positionJump != -1) {
            this.updateSequencePosition(this.positionJump);
            this.updateRow(0);
            return;
        }
        if (this.rowJump != -1) {
            this.updateRow(this.rowJump);
            return;
        }
        if (this.currentRow < 63) {
            this.updateRow(this.currentRow + 1);
        } else {
            this.nextSequencePosition();
            this.updateRow(0);
        }
    }

    protected void nextSequencePosition() {
        int seqpos = this.sequencePosition + 1;
        if (seqpos == this.sequence.songLengthPatterns) {
            seqpos = this.sequence.restartPosition == 127 || this.sequence.restartPosition >= this.sequence.songLengthPatterns ? 0 : this.sequence.restartPosition;
        }
        this.updateSequencePosition(seqpos);
    }

    protected void initializeRowFX() {
        int n;
        Sequence.Pattern currentPattern = this.sequence.patterns[this.sequence.patternOrder[this.sequencePosition]];
        this.patternBreak = -1;
        this.positionJump = -1;
        this.rowJump = -1;
        for (n = 0; n < this.sequence.numberOfChannels; ++n) {
            this.synthesizer.initialiseFX(n, currentPattern.period[this.currentRow][n], currentPattern.instrument[this.currentRow][n], currentPattern.effectCommand[this.currentRow][n], currentPattern.effectValue[this.currentRow][n]);
        }
        block8: for (n = 0; n < this.sequence.numberOfChannels; ++n) {
            int fxCmd = currentPattern.effectCommand[this.currentRow][n];
            int fxVal = currentPattern.effectValue[this.currentRow][n];
            switch (fxCmd) {
                case 11: {
                    if (fxVal >= this.sequence.songLengthPatterns) continue block8;
                    this.positionJump = fxVal;
                    continue block8;
                }
                case 13: {
                    this.patternBreak = fxVal;
                    continue block8;
                }
                case 15: {
                    if (fxVal == 0) continue block8;
                    if (fxVal < 32) {
                        this.tempo = fxVal;
                        this.tempoCounter = fxVal;
                        continue block8;
                    }
                    this.synthesizer.setBPM(fxVal);
                    continue block8;
                }
                case 230: {
                    if (!this.handlePatternLoop(n, fxVal)) continue block8;
                    this.rowJump = this.patternLoopRow[n];
                    continue block8;
                }
                case 238: {
                    this.tempoCounter = this.tempo + this.tempo * fxVal;
                }
            }
        }
    }

    protected void updateSequencePosition(int pos) {
        if (pos < 0 || pos >= this.sequence.songLengthPatterns) {
            pos = 0;
        }
        int n = this.sequencePosition;
        this.sequenceCounter[n] = this.sequenceCounter[n] + 1;
        this.sequencePosition = pos;
        this.resetPatternLoop();
    }

    protected void updateRow(int row) {
        if (row < 0 || row > 63) {
            row = 0;
        }
        this.currentRow = row;
        if (!this.patternLoopEngaged) {
            this.patternLoopChannel = -1;
        }
    }

    protected boolean handlePatternLoop(int channel, int parameter) {
        if (parameter == 0) {
            this.patternLoopRow[channel] = this.currentRow;
            return false;
        }
        if (this.patternLoopEngaged) {
            if (this.patternLoopChannel == channel) {
                --this.patternLoopCounter;
                if (this.patternLoopCounter > 0) {
                    return true;
                }
                this.patternLoopEngaged = false;
                return false;
            }
        } else if (channel > this.patternLoopChannel) {
            this.patternLoopEngaged = true;
            this.patternLoopChannel = channel;
            this.patternLoopCounter = parameter;
            return true;
        }
        return false;
    }

    protected void resetPatternLoop() {
        this.patternLoopEngaged = false;
        this.patternLoopChannel = -1;
        this.patternLoopCounter = 0;
        for (int n = 0; n < this.sequence.numberOfChannels; ++n) {
            this.patternLoopRow[n] = 0;
        }
    }
}

