/*
 * Decompiled with CFR 0.152.
 */
package micromod;

public class ProTrackerLFO {
    public static final int WF_SINUS = 1;
    public static final int WF_SAWDN = 3;
    public static final int WF_SQUARE = 4;
    public static final int WF_RANDOM = 5;
    protected static int[] sinTable = new int[]{0, 24, 49, 74, 97, 120, 141, 161, 180, 197, 212, 224, 235, 244, 250, 253, 255, 253, 250, 244, 235, 224, 212, 197, 180, 161, 141, 120, 97, 74, 49, 24};
    protected int waveform;
    protected int position;
    protected int value;
    protected boolean retrig;

    public ProTrackerLFO() {
        this.reset();
    }

    public void reset() {
        this.retrig = true;
        this.setWaveform(1, true);
    }

    public void setWaveform(int wave, boolean retrig) {
        this.waveform = wave;
        this.retrig = retrig;
    }

    public int update(int speed, boolean newNote) {
        if (newNote && this.retrig) {
            this.position = 0;
        }
        switch (this.waveform) {
            case 1: {
                this.value = sinTable[this.position & 0x1F];
                if (this.position <= 31) break;
                this.value = -this.value;
                break;
            }
            case 3: {
                this.value = -8 * this.position + 255;
                break;
            }
            case 4: {
                this.value = (this.position & 0x20) == 0 ? -255 : 255;
                break;
            }
            case 5: {
                this.value = (int)(Math.random() * 511.0 - 255.0);
            }
        }
        this.position = this.position + speed & 0x3F;
        return this.value;
    }
}

