/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Traits
implements Cloneable {
    private Hashtable habilidades;

    public Object clone() {
        Traits t = null;
        try {
            t = (Traits)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
        }
        t.habilidades = (Hashtable)this.habilidades.clone();
        return t;
    }

    public long getStat(String s) {
        if (s.equalsIgnoreCase("FUE") || s.equalsIgnoreCase("STR")) {
            return this.getStat("fuerza");
        }
        if (s.equalsIgnoreCase("CON")) {
            return this.getStat("constitucion");
        }
        if (s.equalsIgnoreCase("INT")) {
            return this.getStat("inteligencia");
        }
        if (s.equalsIgnoreCase("SAB") || s.equalsIgnoreCase("WIS")) {
            return this.getStat("sabiduria");
        }
        if (s.equalsIgnoreCase("DES") || s.equalsIgnoreCase("DEX")) {
            return this.getStat("destreza");
        }
        if (s.equalsIgnoreCase("CHA") || s.equalsIgnoreCase("CAR")) {
            return this.getStat("carisma");
        }
        if (s.equalsIgnoreCase("POD") || s.equalsIgnoreCase("POW")) {
            return this.getStat("poder");
        }
        return this.getSkill(s);
    }

    public void setStat(String s, long l) {
        if (s.equalsIgnoreCase("FUE") || s.equalsIgnoreCase("STR")) {
            this.setStat("fuerza", l);
        } else if (s.equalsIgnoreCase("CON")) {
            this.setStat("constitucion", l);
        } else if (s.equalsIgnoreCase("INT")) {
            this.setStat("inteligencia", l);
        } else if (s.equalsIgnoreCase("SAB") || s.equalsIgnoreCase("WIS")) {
            this.setStat("sabiduria", l);
        } else if (s.equalsIgnoreCase("DES") || s.equalsIgnoreCase("DEX")) {
            this.setStat("destreza", l);
        } else if (s.equalsIgnoreCase("CHA") || s.equalsIgnoreCase("CAR")) {
            this.setStat("carisma", l);
        } else if (s.equalsIgnoreCase("POD") || s.equalsIgnoreCase("POW")) {
            this.setStat("poder", l);
        }
        this.setSkill(s, l);
    }

    public long getSkill(String s) {
        try {
            Long l = (Long)this.habilidades.get(s);
            if (l != null) {
                return l;
            }
            return 0L;
        }
        catch (ClassCastException cce) {
            return 0L;
        }
    }

    public void setSkill(String name, long value) {
        this.habilidades.put(name, new Long(value));
    }

    public void incSkill(String name) {
        this.setSkill(name, this.getSkill(name) + 1L);
    }

    public Traits() {
        this.habilidades = new Hashtable();
        this.setStat("fuerza", 12L);
        this.setStat("inteligencia", 12L);
        this.setStat("sabiduria", 12L);
        this.setStat("destreza", 12L);
        this.setStat("velocidad", 12L);
        this.setStat("carisma", 12L);
    }

    public Traits(int skillHashtableInitSize) {
        this.habilidades = new Hashtable(skillHashtableInitSize);
        this.setStat("fuerza", 12L);
        this.setStat("inteligencia", 12L);
        this.setStat("sabiduria", 12L);
        this.setStat("destreza", 12L);
        this.setStat("velocidad", 12L);
        this.setStat("carisma", 12L);
    }

    public Node getXMLRepresentation(Document doc) {
        Element traitsElt = doc.createElement("Traits");
        if (this.habilidades != null) {
            Element skillsElt = doc.createElement("SkillList");
            Enumeration nombres = this.habilidades.keys();
            while (nombres.hasMoreElements()) {
                String nombre = (String)nombres.nextElement();
                long valor = (Long)this.habilidades.get(nombre);
                Element skillElt = doc.createElement("Skill");
                skillElt.setAttribute("name", nombre);
                skillElt.setAttribute("value", String.valueOf(valor));
                skillsElt.appendChild(skillElt);
            }
            traitsElt.appendChild(skillsElt);
        }
        return traitsElt;
    }

    public Traits(World mundo, Node traitsNode) throws XMLtoWorldException {
        if (!(traitsNode instanceof Element)) {
            throw new XMLtoWorldException("Traits node not Element");
        }
        Element e = (Element)traitsNode;
        NodeList skillsElts = e.getElementsByTagName("SkillList");
        if (skillsElts.getLength() > 0) {
            NodeList skillElts = ((Element)skillsElts.item(0)).getElementsByTagName("Skill");
            this.habilidades = new Hashtable((int)((double)skillElts.getLength() / 0.75) + 1, 0.75f);
            for (int i = 0; i < skillElts.getLength(); ++i) {
                long val;
                Element skillElt = (Element)skillElts.item(i);
                if (!skillElt.hasAttribute("name")) {
                    throw new XMLtoWorldException("Skill element lacking name attribute");
                }
                if (!skillElt.hasAttribute("value")) {
                    throw new XMLtoWorldException("Skill element lacking value attribute");
                }
                try {
                    val = Long.valueOf(skillElt.getAttribute("value"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Bad number format for Skill element's value attribute");
                }
                this.habilidades.put(skillElt.getAttribute("name"), new Long(val));
            }
        } else {
            this.habilidades = new Hashtable();
        }
    }
}

