/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.ColoredSwingClient;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

class SwingEditBoxListener
implements ActionListener,
KeyListener {
    JTextField elCampoJTexto;
    ColoredSwingClient cl;
    Vector gameLog;
    boolean press_any_key = false;
    int ncommands = 0;

    public void countCommand() {
        ++this.ncommands;
    }

    public SwingEditBoxListener(JTextField nCampoJTexto, Vector gameLog, ColoredSwingClient cl) {
        this.elCampoJTexto = nCampoJTexto;
        this.gameLog = gameLog;
        this.cl = cl;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.press_any_key) {
            if (this.cl.isMemoryEnabled()) {
                this.cl.addToBackStack(this.elCampoJTexto.getText().trim());
                this.cl.forwardStackIntoBackStack();
                this.cl.addToBackStack(this.elCampoJTexto.getText().trim());
            }
            this.cl.write("\n");
            this.countCommand();
            this.cl.write(this.cl.getColorCode("input") + "[COMANDO] " + this.elCampoJTexto.getText().trim() + this.cl.getColorCode("reset") + "\n");
            this.cl.writeTitle(this.ncommands + " comando" + (this.ncommands == 1 ? "" : "s"), 2);
            this.cl.setInputString(this.elCampoJTexto.getText());
            this.gameLog.addElement(this.elCampoJTexto.getText());
            this.elCampoJTexto.setText("");
        } else {
            this.setPressAnyKeyState(false);
            this.cl.setInputString(null);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.press_any_key) {
            if (e.getKeyCode() != 10) {
                this.setPressAnyKeyState(false);
                this.cl.setInputString(null);
            }
        } else if (this.cl.isMemoryEnabled()) {
            if (e.getKeyCode() == 38) {
                this.cl.goBack();
            } else if (e.getKeyCode() == 40) {
                this.cl.goForward();
            }
        }
    }

    public void setPressAnyKeyState(final boolean value) {
        System.out.println("In PAK, Thread is " + Thread.currentThread());
        System.out.println("And it's " + SwingUtilities.isEventDispatchThread());
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetPressAnyKeyState(value);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingEditBoxListener.this.doSetPressAnyKeyState(value);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doSetPressAnyKeyState(boolean value) {
        this.press_any_key = value;
        if (value) {
            System.out.println("Setting PAK");
            this.elCampoJTexto.setForeground(Color.black);
            System.out.println("Setting PAK 1");
            this.elCampoJTexto.setText("Pulsa cualquier tecla...");
            System.out.println("Setting PAK 2");
            this.elCampoJTexto.setEditable(false);
            System.out.println("Setting PAK 3");
            this.elCampoJTexto.grabFocus();
            System.out.println("Set PAK");
        } else {
            System.out.println("Setting UNPAK 1");
            this.elCampoJTexto.setText("");
            System.out.println("Setting UNPAK 2");
            this.elCampoJTexto.setEditable(true);
            System.out.println("Setting UNPAK 3");
        }
    }
}

