/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.ColoredSwingClient;
import eu.irreality.age.FiltroFicheroEstado;
import eu.irreality.age.FiltroFicheroLog;
import eu.irreality.age.GameEngineThread;
import eu.irreality.age.Informador;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.UpdatingRun;
import eu.irreality.age.Utility;
import eu.irreality.age.World;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class SwingAetheriaGameLoader
extends JInternalFrame
implements Informador {
    protected static final String maindir = "";
    protected static long timeCount;
    protected static boolean exitFlag;
    protected InputOutputClient io;
    protected Vector gameLog;
    protected World mundo;
    private JPanel mainPanel;
    private JFrame fullScreenFrame;
    private boolean fullScreenMode;
    private JMenuBar barraMenu;
    private GameEngineThread maquinaEstados;
    protected SwingAetheriaGameLoader esto = this;
    protected Runnable updateCode = new UpdatingRun(this);
    private Object mundoSemaphore = new Object();
    private Thread loaderThread = null;
    private String moduledir;
    private JDesktopPane gui;
    private boolean usarLog;
    private String logFile;
    private String stateFile;
    private boolean noSerCliente;

    public World getMundo() {
        return this.mundo;
    }

    public static String getVersion() {
        return "Swing-based MDI interface with colored text output, 0.2.1";
    }

    public void updateNow() {
        Thread c = new Thread(this.updateCode);
        c.setPriority(10);
        c.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized World waitForMundoToLoad() throws InterruptedException {
        Object object = this.mundoSemaphore;
        synchronized (object) {
            if (this.mundo != null) {
                return this.mundo;
            }
            while (this.mundo == null) {
                this.mundoSemaphore.wait();
            }
        }
        System.out.println("Semaphore return.");
        return this.mundo;
    }

    public void repaint() {
        super.repaint();
        if (this.fullScreenMode) {
            this.fullScreenFrame.repaint();
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    private void setMainPanel(JPanel p) {
        if (this.mainPanel != null) {
            this.getContentPane().remove(this.mainPanel);
        }
        this.mainPanel = p;
        this.getContentPane().add(p);
    }

    public JMenuBar getTheJMenuBar() {
        if (this.barraMenu != null) {
            return this.barraMenu;
        }
        this.barraMenu = this.getJMenuBar();
        return this.barraMenu;
    }

    public void setTheJMenuBar(JMenuBar jmb) {
        this.barraMenu = jmb;
        if (!this.fullScreenMode) {
            this.setJMenuBar(jmb);
        } else {
            this.fullScreenFrame.setJMenuBar(jmb);
        }
    }

    public InputOutputClient getClient() {
        return this.io;
    }

    public SwingAetheriaGameLoader(String title, JDesktopPane gui) {
        super(title, true, true, true);
        Image iconito = this.getToolkit().getImage("images" + File.separatorChar + "intficon.gif");
        this.setFrameIcon(new ImageIcon(iconito));
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                System.out.println("Frame closed.");
                SwingAetheriaGameLoader.this.exitNow();
            }
        });
        gui.add(this);
        this.setVisible(true);
        this.mainPanel = new JPanel();
        this.setMainPanel(this.mainPanel);
        this.io = new ColoredSwingClient(this, new Vector());
        this.setSize(500, 400);
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public SwingAetheriaGameLoader(String moduledir, JDesktopPane gui, boolean usarLog, String logFile, String stateFile, boolean noSerCliente) {
        super(moduledir, true, true, true, true);
        this.moduledir = moduledir;
        this.gui = gui;
        this.usarLog = usarLog;
        this.logFile = logFile;
        this.stateFile = stateFile;
        this.noSerCliente = noSerCliente;
        Image iconito = this.getToolkit().getImage("images" + File.separatorChar + "intficon.gif");
        this.setFrameIcon(new ImageIcon(iconito));
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                System.out.println("Frame closed.");
                SwingAetheriaGameLoader.this.exitNow();
            }
        });
        Thread.currentThread().setPriority(10);
        this.setSize(500, 400);
        if (moduledir.equalsIgnoreCase(maindir)) {
            this.setTitle("Aetheria Game Engine. M\u00f3dulo: aetherworld");
        } else {
            this.setTitle("Aetheria Game Engine. M\u00f3dulo: " + moduledir);
        }
        gui.add(this);
        this.setVisible(true);
        SwingAetheriaGameLoader esto = this;
        this.loaderThread = new LoaderThread();
        this.loaderThread.start();
    }

    public void reinit() {
        if (this.loaderThread != null) {
            final boolean fsm = this.fullScreenMode;
            this.setFullScreenMode(false);
            this.maquinaEstados.uninitServerMenu(this);
            this.maquinaEstados.exitForReinit();
            ((ColoredSwingClient)this.io).uninitClientMenu(this);
            Thread thr = new Thread(){

                public void run() {
                    SwingAetheriaGameLoader.this.loaderThread = new LoaderThread();
                    SwingAetheriaGameLoader.this.loaderThread.start();
                    try {
                        SwingAetheriaGameLoader.this.loaderThread.join();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                    SwingAetheriaGameLoader.this.setFullScreenMode(fsm);
                }
            };
            thr.start();
        }
    }

    public void setFullScreenMode(boolean onOrOff) {
        if (this.fullScreenFrame == null) {
            this.fullScreenFrame = new JFrame();
        }
        if (onOrOff) {
            System.out.println("Setting full-screen dedicated mode ON");
            if (this.fullScreenMode) {
                return;
            }
            this.fullScreenMode = true;
            this.remove(this.getMainPanel());
            this.fullScreenFrame.getContentPane().add(this.getMainPanel());
            this.setJMenuBar(new JMenuBar());
            this.fullScreenFrame.setJMenuBar(this.barraMenu);
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            if (!this.fullScreenFrame.isDisplayable()) {
                this.fullScreenFrame.setUndecorated(true);
            }
            this.fullScreenFrame.setResizable(false);
            devices[0].setFullScreenWindow(this.fullScreenFrame);
            DisplayMode dm = devices[0].getDisplayMode();
            this.fullScreenFrame.setSize(new Dimension(dm.getWidth(), dm.getHeight()));
            this.fullScreenFrame.validate();
            this.fullScreenFrame.paintAll(this.fullScreenFrame.getGraphics());
            this.fullScreenFrame.requestFocus();
            UpdatingRun updateCode = new UpdatingRun(this.fullScreenFrame);
            Thread c = new Thread(updateCode);
            c.setPriority(10);
            c.start();
            this.fullScreenFrame.setVisible(true);
            this.setVisible(false);
            this.fullScreenFrame.requestFocus();
            if (this.io instanceof ColoredSwingClient) {
                ((ColoredSwingClient)this.io).refreshFocus();
            }
        } else {
            System.out.println("Setting full-screen dedicated mode OFF");
            if (!this.fullScreenMode) {
                return;
            }
            this.fullScreenMode = false;
            this.fullScreenFrame.setJMenuBar(new JMenuBar());
            this.fullScreenFrame.remove(this.mainPanel);
            this.setMainPanel(this.mainPanel);
            this.setTheJMenuBar(this.barraMenu);
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = env.getScreenDevices();
            devices[0].setFullScreenWindow(null);
            DisplayMode dm = devices[0].getDisplayMode();
            this.fullScreenFrame.setVisible(false);
            this.setVisible(true);
        }
    }

    public void exit() {
        exitFlag = true;
    }

    public void exitNow() {
        if (this.maquinaEstados != null) {
            this.maquinaEstados.exitNow();
        } else {
            this.saveAndFreeResources();
        }
    }

    public void saveAndFreeResources() {
        this.io.write("Guardando la partida...\n");
        try {
            this.guardarLog(new File("autosave.alf"));
        }
        catch (Exception exc) {
            this.io.write("\u00a1No se ha podido guardar la partida!\n");
        }
        this.io.write("Tiempo del juego: " + timeCount + "\n");
        this.io.write("\u00a1Hasta la pr\u00f3xima!\n");
        if (this.fullScreenMode) {
            this.setFullScreenMode(false);
        }
        this.dispose();
        if (this.fullScreenFrame != null) {
            this.fullScreenFrame.dispose();
        }
        this.maquinaEstados = null;
        Runtime.getRuntime().gc();
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
        this.io.write(s);
    }

    public void setIO(InputOutputClient es) {
        this.io = es;
    }

    public void guardarLog(File f) throws IOException, FileNotFoundException {
        FileOutputStream fin = new FileOutputStream(f);
        PrintWriter fwrite = new PrintWriter(new BufferedWriter(Utility.getBestOutputStreamWriter(fin)));
        for (int i = 0; i < this.gameLog.size(); ++i) {
            System.out.println("Savin': " + (String)this.gameLog.elementAt(i));
            fwrite.println((String)this.gameLog.elementAt(i));
        }
        fwrite.flush();
    }

    public void guardarEstado(File f) throws IOException, FileNotFoundException {
        FileOutputStream fin = new FileOutputStream(f);
        PrintWriter frwite = new PrintWriter(new BufferedWriter(Utility.getBestOutputStreamWriter(fin)));
        Document d = null;
        try {
            d = this.mundo.getXMLRepresentation();
            System.out.println("D=null?" + (d == null));
        }
        catch (ParserConfigurationException exc) {
            System.out.println(exc);
        }
        StreamResult sr = null;
        sr = new StreamResult(new FileOutputStream(f));
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("encoding", "UTF-8");
            DOMSource s = new DOMSource(d);
            System.out.println("Nodo:" + s.getNode());
            tr.transform(s, sr);
        }
        catch (TransformerConfigurationException tfe) {
            System.out.println(tfe);
        }
        catch (TransformerException te) {
            System.out.println(te);
        }
    }

    public void guardarLog() {
        File elFichero = null;
        JFileChooser selectorFichero = new JFileChooser("saves");
        selectorFichero.setFileSelectionMode(0);
        FiltroFicheroLog filtro = new FiltroFicheroLog();
        selectorFichero.setFileFilter(filtro);
        int returnVal = selectorFichero.showSaveDialog(this);
        if (returnVal == 0) {
            elFichero = selectorFichero.getSelectedFile();
            try {
                if (!elFichero.toString().toLowerCase().endsWith(".alf")) {
                    elFichero = new File(elFichero.toString() + ".alf");
                }
                this.guardarLog(elFichero);
            }
            catch (Exception exc) {
                this.write("No se ha podido guardar la partida...");
                this.write(exc.toString());
            }
        }
    }

    public void guardarEstado() {
        File elFichero = null;
        JFileChooser selectorFichero = new JFileChooser("saves");
        selectorFichero.setFileSelectionMode(0);
        FiltroFicheroEstado filtro = new FiltroFicheroEstado();
        selectorFichero.setFileFilter(filtro);
        int returnVal = selectorFichero.showSaveDialog(this);
        if (returnVal == 0) {
            elFichero = selectorFichero.getSelectedFile();
            try {
                if (!elFichero.toString().toLowerCase().endsWith(".asf")) {
                    elFichero = new File(elFichero.toString() + ".asf");
                }
                this.guardarEstado(elFichero);
            }
            catch (Exception exc) {
                this.write("No se ha podido guardar la partida...");
                this.write(exc.toString());
            }
        }
    }

    class LoaderThread
    extends Thread {
        LoaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            World theWorld;
            SwingAetheriaGameLoader.this.gameLog = new Vector();
            System.out.println("1");
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingAetheriaGameLoader.this.getContentPane().removeAll();
                        SwingAetheriaGameLoader.this.mainPanel = new JPanel();
                        SwingAetheriaGameLoader.this.setMainPanel(SwingAetheriaGameLoader.this.mainPanel);
                        ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io = new ColoredSwingClient(((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.esto, ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.gameLog);
                        SwingAetheriaGameLoader.this.write("Aetheria Game Engine v 0.4.7c Beta Distribution\n");
                        SwingAetheriaGameLoader.this.write("\u00a9 1999-2003 Carlos G\u00f3mez (solrac888@yahoo.com)\n");
                        SwingAetheriaGameLoader.this.write("Biblioteca BeanShell creada por Pat Niemeyer (pat@pat.net) y bajo licencia LGPL (ver docs/LGPL.txt, c\u00f3digo fuente en www.beanshell.org)\n");
                        SwingAetheriaGameLoader.this.write("\n=============================================================");
                        SwingAetheriaGameLoader.this.write("\n" + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("information") + "Engine-related Version Info:");
                        SwingAetheriaGameLoader.this.write("\n" + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("information") + "[OS Layer]           " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("reset"));
                        SwingAetheriaGameLoader.this.write("\n" + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("information") + "[Java Layer]         " + System.getProperty("java.version") + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("reset"));
                        SwingAetheriaGameLoader.this.write("\n" + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("information") + "[Simulation Layer]   " + GameEngineThread.getVersion() + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("reset"));
                        SwingAetheriaGameLoader.this.write("\n" + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("information") + "[Object Code Layer]  " + ObjectCode.getInterpreterVersion() + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("reset"));
                        SwingAetheriaGameLoader.this.write("\n" + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("information") + "[UI Layer]           " + SwingAetheriaGameLoader.getVersion() + ((LoaderThread)LoaderThread.this).SwingAetheriaGameLoader.this.io.getColorCode("reset"));
                        SwingAetheriaGameLoader.this.write("\n=============================================================\n");
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("2");
            if (SwingAetheriaGameLoader.this.moduledir == null || SwingAetheriaGameLoader.this.moduledir.length() == 0) {
                SwingAetheriaGameLoader.this.moduledir = "aetherworld";
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingAetheriaGameLoader.this.repaint();
                        SwingAetheriaGameLoader.this.updateNow();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("3");
            File inputAsFile = new File(SwingAetheriaGameLoader.this.moduledir);
            if (inputAsFile.isFile()) {
                System.out.println("Attempting world location: " + inputAsFile);
                try {
                    SwingAetheriaGameLoader.this.mundo = theWorld = new World(SwingAetheriaGameLoader.maindir + SwingAetheriaGameLoader.this.moduledir, SwingAetheriaGameLoader.this.io, SwingAetheriaGameLoader.this.noSerCliente);
                    System.out.println("World generated.\n");
                    Object object = SwingAetheriaGameLoader.this.mundoSemaphore;
                    synchronized (object) {
                        SwingAetheriaGameLoader.this.mundoSemaphore.notifyAll();
                    }
                    SwingAetheriaGameLoader.this.gameLog.addElement(inputAsFile.getAbsolutePath());
                }
                catch (IOException ioe) {
                    SwingAetheriaGameLoader.this.write("No puedo leer el fichero del mundo: " + inputAsFile + "\n");
                    ioe.printStackTrace();
                    return;
                }
            }
            try {
                System.out.println("Attempting world location: " + SwingAetheriaGameLoader.this.moduledir + "/world.xml");
                SwingAetheriaGameLoader.this.mundo = theWorld = new World(SwingAetheriaGameLoader.maindir + SwingAetheriaGameLoader.this.moduledir + "/world.xml", SwingAetheriaGameLoader.this.io, SwingAetheriaGameLoader.this.noSerCliente);
                System.out.println("World generated.\n");
                Object ioe = SwingAetheriaGameLoader.this.mundoSemaphore;
                synchronized (ioe) {
                    SwingAetheriaGameLoader.this.mundoSemaphore.notifyAll();
                }
                SwingAetheriaGameLoader.this.gameLog.addElement(SwingAetheriaGameLoader.maindir + SwingAetheriaGameLoader.this.moduledir + "/world.xml");
            }
            catch (IOException e) {
                System.out.println(e);
                try {
                    System.out.println("Attempting world location: " + SwingAetheriaGameLoader.this.moduledir + "/world.dat");
                    SwingAetheriaGameLoader.this.mundo = theWorld = new World(SwingAetheriaGameLoader.maindir + SwingAetheriaGameLoader.this.moduledir + "/world.dat", SwingAetheriaGameLoader.this.io, SwingAetheriaGameLoader.this.noSerCliente);
                    Object object = SwingAetheriaGameLoader.this.mundoSemaphore;
                    synchronized (object) {
                        SwingAetheriaGameLoader.this.mundoSemaphore.notifyAll();
                    }
                    SwingAetheriaGameLoader.this.gameLog.addElement(SwingAetheriaGameLoader.maindir + SwingAetheriaGameLoader.this.moduledir + "/world.dat");
                }
                catch (FileNotFoundException loadworldfileioerror) {
                    SwingAetheriaGameLoader.this.write("No encontrado el fichero del mundo. Tal vez el directorio seleccionado no sea un directorio de mundo AGE v\u00e1lido.\n");
                    return;
                }
                catch (IOException loadworldfileioerror2) {
                    SwingAetheriaGameLoader.this.write("No puedo leer el fichero del mundo. Tal vez el directorio seleccionado no sea un directorio de mundo AGE v\u00e1lido.\n");
                    return;
                }
            }
            final World theFinalWorld = theWorld;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingAetheriaGameLoader.this.updateNow();
                        if (theFinalWorld.getModuleName() != null && theFinalWorld.getModuleName().length() > 0) {
                            SwingAetheriaGameLoader.this.setTitle(theFinalWorld.getModuleName());
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Document d = null;
            try {
                d = theWorld.getXMLRepresentation();
                System.out.println("D=null?" + (d == null));
            }
            catch (ParserConfigurationException exc) {
                System.out.println(exc);
            }
            StreamResult sr = null;
            try {
                sr = new StreamResult(new FileOutputStream("theworld.xml"));
            }
            catch (FileNotFoundException fnfe) {
                System.out.println(fnfe);
            }
            try {
                Transformer tr = TransformerFactory.newInstance().newTransformer();
                tr.setOutputProperty("encoding", "ISO-8859-1");
                DOMSource s = new DOMSource(d);
                System.out.println("Nodo:" + s.getNode());
                tr.transform(s, sr);
            }
            catch (TransformerConfigurationException tfe) {
                System.out.println(tfe);
            }
            catch (TransformerException te) {
                System.out.println(te);
            }
            if (SwingAetheriaGameLoader.this.stateFile != null) {
                try {
                    theWorld.loadState(SwingAetheriaGameLoader.this.stateFile);
                }
                catch (Exception exc) {
                    SwingAetheriaGameLoader.this.write("\u00a1No se ha podido cargar el estado!\n");
                    SwingAetheriaGameLoader.this.write(exc.toString());
                    exc.printStackTrace();
                }
            }
            if (SwingAetheriaGameLoader.this.usarLog) {
                try {
                    System.out.println("RLTLTL");
                    System.out.println("Player list is " + theWorld.getPlayerList());
                    System.out.println("PECADORL");
                    theWorld.prepareLog(SwingAetheriaGameLoader.this.logFile);
                    theWorld.setRandomNumberSeed(SwingAetheriaGameLoader.this.logFile);
                }
                catch (Exception exc) {
                    SwingAetheriaGameLoader.this.write("Excepci\u00f3n al leer el fichero de log: " + exc + "\n");
                    exc.printStackTrace();
                    return;
                }
            } else {
                theWorld.setRandomNumberSeed();
            }
            SwingAetheriaGameLoader.this.gameLog.addElement(String.valueOf(theWorld.getRandomNumberSeed()));
            SwingAetheriaGameLoader.this.setVisible(true);
            timeCount = 0L;
            SwingAetheriaGameLoader.this.mundo = theWorld;
            Object exc = SwingAetheriaGameLoader.this.mundoSemaphore;
            synchronized (exc) {
                SwingAetheriaGameLoader.this.mundoSemaphore.notifyAll();
            }
            SwingAetheriaGameLoader.this.maquinaEstados = new GameEngineThread(theWorld, SwingAetheriaGameLoader.this.esto, false);
            System.out.println("STARTING ENGINE THREAD");
            SwingAetheriaGameLoader.this.maquinaEstados.start();
            System.out.println("ENGINE THREAD STARTED");
            System.out.println("noSerCliente = " + SwingAetheriaGameLoader.this.noSerCliente);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        SwingAetheriaGameLoader.this.repaint();
                        SwingAetheriaGameLoader.this.updateNow();
                        if (!SwingAetheriaGameLoader.this.fullScreenMode) {
                            SwingAetheriaGameLoader.this.setVisible(false);
                            SwingAetheriaGameLoader.this.setVisible(true);
                        } else {
                            SwingAetheriaGameLoader.this.fullScreenFrame.setVisible(false);
                            SwingAetheriaGameLoader.this.fullScreenFrame.setVisible(true);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (SwingAetheriaGameLoader.this.io instanceof ColoredSwingClient) {
                ((ColoredSwingClient)SwingAetheriaGameLoader.this.io).refreshFocus();
            }
        }
    }
}

