/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.GameChoosingInternalFrame;
import eu.irreality.age.MDIMenuBar;
import eu.irreality.age.ServerConfigurationWindow;
import eu.irreality.age.ServerHandler;
import eu.irreality.age.StringMethods;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.SwingImageDrawingThread;
import eu.irreality.age.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalIconFactory;

class SwingAetheriaGUI
extends JFrame {
    JDesktopPane panel;
    JMenuBar menuBar;
    Vector padre1;
    Vector padre2;
    int i = 0;
    int j = 0;
    private static SwingAetheriaGUI instance;

    public static SwingAetheriaGUI getInstance() {
        return instance;
    }

    public static void createLocalGameFromFile(String file) {
        new SwingAetheriaGameLoader(file, SwingAetheriaGUI.getInstance().panel, false, null, null, false);
    }

    public void setStandalone(boolean standalone) {
        if (standalone) {
            this.setDefaultCloseOperation(3);
        } else {
            this.setDefaultCloseOperation(2);
        }
    }

    public SwingAetheriaGUI() {
        super("Aetheria Game Engine, Beta 0.4.7b");
        instance = this;
        this.setDefaultCloseOperation(3);
        Image iconito = this.getToolkit().getImage("images" + File.separatorChar + "intficon.gif");
        this.setIconImage(iconito);
        Dimension tamanoVentana = this.getToolkit().getScreenSize();
        this.setSize(tamanoVentana.width - 50, tamanoVentana.height - 50);
        this.setLocation(25, 25);
        SwingImageDrawingThread imthread = new SwingImageDrawingThread("images" + File.separatorChar + "agelogo.jpg", 4000L, this);
        imthread.start();
        ServerConfigurationWindow.setMadre(this);
        Image logo = this.getToolkit().createImage("agelogo.jpg");
        this.panel = new JDesktopPane();
        this.panel.setBackground(Color.black);
        JPanel general = new JPanel();
        general.setLayout(new BorderLayout());
        general.add((Component)this.panel, "Center");
        JPanel botones = new JPanel();
        botones.setLayout(new GridLayout(1, 7));
        JButton botonNuevo = new JButton("Nuevo");
        botones.add(botonNuevo);
        botones.add(new JButton(MetalIconFactory.getFileChooserNewFolderIcon()));
        botones.add(new JButton(MetalIconFactory.getFileChooserNewFolderIcon()));
        this.panel.setVisible(true);
        this.setContentPane(general);
        this.setJMenuBar(new MDIMenuBar(this.panel));
        this.setVisible(true);
        String fontName = "Courier New";
        int fontSize = 12;
        try {
            BufferedReader iniReader = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream("age.cfg")));
            for (int line = 1; line < 100; ++line) {
                String linea = iniReader.readLine();
                if (linea == null) continue;
                System.out.println("Linea " + linea);
                String codigo = StringMethods.getTok(linea, 1, '=').trim().toLowerCase();
                if (codigo.equals("font name")) {
                    System.out.println("Nombre: " + StringMethods.getTok(linea, 2, '=').trim());
                    fontName = StringMethods.getTok(linea, 2, '=').trim();
                    continue;
                }
                if (!codigo.equals("font size")) continue;
                fontSize = Integer.parseInt(StringMethods.getTok(linea, 2, '=').trim());
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (NumberFormatException nfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Font[] fuentes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int f = 0; f < fuentes.length; ++f) {
            if (!fuentes[f].getFontName().equalsIgnoreCase(fontName)) continue;
            SwingAetheriaGameLoaderInterface.font = fuentes[f].deriveFont((float)fontSize);
            break;
        }
        this.panel.add(new GameChoosingInternalFrame(this.panel));
        ServerHandler sh = ServerHandler.getInstance(this.panel);
        if (sh.getServerConfigurationOptions().initOnStartup()) {
            sh.initPartidasDedicadas(this.panel);
        }
    }
}

