/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.AGEClientHandler;
import eu.irreality.age.GameEngineThread;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.IrcAgeBot;
import eu.irreality.age.IrcServerEntry;
import eu.irreality.age.PartidaEnCurso;
import eu.irreality.age.PartidaEntry;
import eu.irreality.age.ServerConfigurationOptions;
import eu.irreality.age.ServerConfigurationWindow;
import eu.irreality.age.ServerLogWindow;
import eu.irreality.age.SimpleTelnetClientHandler;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.World;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public class ServerHandler {
    private SimpleTelnetClientHandler elServidorTelnet;
    private AGEClientHandler elServidorAge;
    private List losBotsIrc = new Vector();
    private List partidasIrc = new Vector();
    private static ServerHandler theInstance;
    private ServerConfigurationOptions opcionesServidor;
    private ServerLogWindow logWin;

    private ServerHandler(JDesktopPane toAddLogWin) {
        this(ServerConfigurationWindow.getInstance().getEntrada(), toAddLogWin);
    }

    private ServerHandler() {
        this(ServerConfigurationWindow.getInstance().getEntrada());
    }

    private ServerHandler(ServerConfigurationOptions sco) {
        this(sco, null);
    }

    public ServerLogWindow getLogWindow() {
        return this.logWin;
    }

    private ServerHandler(ServerConfigurationOptions sco, JDesktopPane toAddLogWin) {
        this.opcionesServidor = sco;
        if (this.logWin == null && toAddLogWin != null) {
            this.logWin = new ServerLogWindow();
            toAddLogWin.add(this.logWin);
        }
        if (this.opcionesServidor.sirveTelnet() && this.elServidorTelnet == null) {
            this.elServidorTelnet = new SimpleTelnetClientHandler((short)this.opcionesServidor.getPuertoTelnet());
        }
        if (this.opcionesServidor.sirveAge() && this.elServidorAge == null) {
            this.elServidorAge = new AGEClientHandler((short)this.opcionesServidor.getPuertoAge());
        }
        if (this.opcionesServidor.sirveIrc()) {
            List ircServerEntryList = this.opcionesServidor.getListaServidoresIrc();
            for (int i = 0; i < ircServerEntryList.size(); ++i) {
                final IrcServerEntry ise = (IrcServerEntry)ircServerEntryList.get(i);
                Thread th = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block5: {
                            try {
                                IrcAgeBot iab = new IrcAgeBot(ise.getServer(), ise.getPort(), ise.getNick());
                                ServerHandler serverHandler = theInstance;
                                synchronized (serverHandler) {
                                    ServerHandler.this.losBotsIrc.add(iab);
                                }
                            }
                            catch (Exception e) {
                                if (ServerHandler.this.logWin == null) break block5;
                                ServerHandler.this.logWin.writeGeneral("Exception found when trying to connect bot to server " + ise.getServer() + "\n");
                                ServerHandler.this.logWin.writeGeneral(e + ":" + e.getMessage());
                                e.printStackTrace();
                                System.out.println("HALCYON\nAND ON\nAND ON\n");
                            }
                        }
                    }
                };
                th.setPriority(1);
                th.start();
            }
        }
    }

    public ServerConfigurationOptions getServerConfigurationOptions() {
        return this.opcionesServidor;
    }

    public void setServerConfigurationOptions(ServerConfigurationOptions sco) {
        this.opcionesServidor = sco;
    }

    public static ServerHandler getInstance() {
        if (theInstance == null) {
            theInstance = new ServerHandler();
        }
        return theInstance;
    }

    public static ServerHandler getInstance(JDesktopPane toAddLogWin) {
        if (theInstance == null) {
            theInstance = new ServerHandler(toAddLogWin);
        }
        return theInstance;
    }

    public void addToCorrespondingServers(PartidaEnCurso pec, PartidaEntry pe) {
        if (this.opcionesServidor.sirveTelnet() && pe.sirveTelnet()) {
            this.addPartidaToTelnetServer(pec);
        }
        if (this.opcionesServidor.sirveAge() && pe.sirveAge()) {
            this.addPartidaToAgeServer(pec);
        }
        if (this.opcionesServidor.sirveIrc() && pe.sirveIrc()) {
            this.addPartidaToIrcServers(pec);
        }
    }

    public void initPartidasDedicadas(JDesktopPane toAddLogWin) {
        if (this.logWin == null) {
            this.logWin = new ServerLogWindow();
            toAddLogWin.add(this.logWin);
        }
        List dedicadas = this.opcionesServidor.getListaPartidasDedicadas();
        for (int i = 0; i < dedicadas.size(); ++i) {
            System.out.println("GONNA ADD PARTIDA");
            PartidaEnCurso pec = this.initPartidaDedicada((PartidaEntry)dedicadas.get(i), this.logWin, null, null);
            if (this.opcionesServidor.sirveTelnet() && ((PartidaEntry)dedicadas.get(i)).sirveTelnet()) {
                this.addPartidaToTelnetServer(pec);
            }
            if (this.opcionesServidor.sirveAge() && ((PartidaEntry)dedicadas.get(i)).sirveAge()) {
                this.addPartidaToAgeServer(pec);
            }
            if (!this.opcionesServidor.sirveIrc() || !((PartidaEntry)dedicadas.get(i)).sirveIrc()) continue;
            this.addPartidaToIrcServers(pec);
        }
        JMenuBar jmb = this.logWin.getJMenuBar();
        if (jmb != null) {
            int nmenus = jmb.getMenuCount();
            int npartida = 1;
            for (int i = 0; i < nmenus; ++i) {
                JMenu cur = jmb.getMenu(i);
                if (!cur.getText().equalsIgnoreCase("Servidor")) continue;
                cur.setText("Partida " + npartida);
                ++npartida;
            }
        }
    }

    public void addPartidaToTelnetServer(PartidaEnCurso pec) {
        if (this.elServidorTelnet != null) {
            this.elServidorTelnet.addPartida(pec);
        }
    }

    public void addPartidaToAgeServer(PartidaEnCurso pec) {
        if (this.elServidorAge != null) {
            this.elServidorAge.addPartida(pec);
        }
    }

    public synchronized void addPartidaToIrcServers(PartidaEnCurso pec) {
        this.partidasIrc.add(pec);
    }

    public synchronized List getPartidasIrc() {
        return this.partidasIrc;
    }

    public PartidaEnCurso initPartidaLocal(PartidaEntry pe, ServerLogWindow slw, String stateFile, String logFile, JDesktopPane thePanel) {
        World mundo;
        File ficheroMundo = pe.getGameInfo().getFile();
        System.out.println("The world file: " + ficheroMundo);
        SwingAetheriaGameLoader sagl = new SwingAetheriaGameLoader(ficheroMundo.toString(), thePanel, logFile != null, logFile, stateFile, stateFile != null);
        System.out.println("SAGL loaded. " + SwingUtilities.isEventDispatchThread());
        try {
            mundo = sagl.waitForMundoToLoad();
        }
        catch (InterruptedException intex) {
            return null;
        }
        return new PartidaEnCurso(mundo, pe.getMaxPlayers(), pe.getName(), pe.getPassword());
    }

    public PartidaEnCurso initPartidaDedicada(PartidaEntry pe, ServerLogWindow slw, String stateFile, String logFile) {
        World theWorld;
        System.out.println(pe);
        System.out.println(pe.getGameInfo());
        System.out.println(pe.getGameInfo().getFile());
        File ficheroMundo = pe.getGameInfo().getFile();
        InputOutputClient worldIO = slw.addTab();
        Vector<Object> gameLog = new Vector<Object>();
        try {
            theWorld = new World(ficheroMundo.toString(), worldIO, true);
            gameLog.addElement(ficheroMundo);
        }
        catch (Exception e) {
            worldIO.write("Excepci\u00f3n al crear el mundo: " + e + "\n");
            e.printStackTrace();
            return null;
        }
        if (stateFile != null) {
            try {
                theWorld.loadState(stateFile);
            }
            catch (Exception exc) {
                worldIO.write("\u00a1No se ha podido cargar el estado!\n");
                worldIO.write(exc.toString());
                exc.printStackTrace();
            }
        }
        if (logFile != null) {
            try {
                System.out.println("SHPL");
                System.out.println("Player list is " + theWorld.getPlayerList());
                theWorld.prepareLog(logFile);
                theWorld.setRandomNumberSeed(logFile);
            }
            catch (Exception exc) {
                worldIO.write("Excepci\u00f3n al leer el fichero de log (ServerHandler).\n");
                return null;
            }
        } else {
            theWorld.setRandomNumberSeed();
        }
        gameLog.addElement(String.valueOf(theWorld.getRandomNumberSeed()));
        GameEngineThread maquinaEstados = new GameEngineThread(theWorld, slw, false);
        maquinaEstados.start();
        return new PartidaEnCurso(theWorld, pe.getMaxPlayers(), pe.getName(), pe.getPassword());
    }
}

