/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.GameInfo;
import eu.irreality.age.filemanagement.Paths;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Vector;

class SaveInfo {
    File fichSalv;
    Date fecha;
    String name;
    GameInfo infoJuego;

    public SaveInfo() {
    }

    public SaveInfo(File fichSalv, Date fecha, File fichJuego) {
        this.fichSalv = fichSalv;
        this.fecha = fecha;
        this.name = fichSalv.getName();
        this.infoJuego = GameInfo.getGameInfoFromFile(fichJuego);
    }

    public File getFile() {
        return this.fichSalv;
    }

    public File getGameFile() {
        if (this.infoJuego == null) {
            return null;
        }
        return this.infoJuego.getFile();
    }

    public GameInfo getGameInfo() {
        return this.infoJuego;
    }

    public String getName() {
        return this.name;
    }

    public Date getDate() {
        return this.fecha;
    }

    public String toString() {
        return this.getName();
    }

    public String toLongString() {
        if (this.infoJuego == null) {
            return "Nombre: " + this.getName() + "\nFecha: " + this.getDate();
        }
        return "Nombre: " + this.getName() + "\nFecha: " + this.getDate() + "\nJuego: " + this.infoJuego.toString();
    }

    public static SaveInfo getSaveInfo(File savefile) throws FileNotFoundException, IOException {
        FileInputStream fp = new FileInputStream(savefile);
        BufferedReader filein = new BufferedReader(new InputStreamReader(fp));
        String fichJuego = filein.readLine();
        Date fecha = new Date(savefile.lastModified());
        System.out.println(savefile);
        System.out.println(fichJuego);
        try {
            return new SaveInfo(savefile, fecha, new File(fichJuego));
        }
        catch (Exception fnfe) {
            return null;
        }
    }

    public static SaveInfo[] getListOfSaves() {
        File f = new File(Paths.getWorkingDirectory() + File.separatorChar + "saves");
        if (!f.exists()) {
            if (f.mkdir()) {
                System.out.println("Saves directory didn't exist, created at saves");
            } else {
                System.err.println("Could not create saves directory at saves");
            }
        }
        File[] fl = f.listFiles();
        Vector<SaveInfo> result = new Vector<SaveInfo>();
        for (int i = 0; i < fl.length; ++i) {
            if (fl[i].isDirectory()) {
                File[] fl2 = fl[i].listFiles();
                for (int j = 0; j < fl2.length; ++j) {
                    if (!fl2[j].getName().toLowerCase().endsWith(".alf")) continue;
                    try {
                        result.addElement(SaveInfo.getSaveInfo(fl2[j]));
                        continue;
                    }
                    catch (IOException ioe) {
                        System.out.println(ioe);
                        ioe.printStackTrace();
                    }
                }
                continue;
            }
            if (!fl[i].getName().toLowerCase().endsWith(".alf")) continue;
            try {
                result.addElement(SaveInfo.getSaveInfo(fl[i]));
                continue;
            }
            catch (IOException ioe) {
                System.out.println(ioe);
                ioe.printStackTrace();
            }
        }
        Object[] objetos = result.toArray();
        SaveInfo[] ficheros = new SaveInfo[objetos.length];
        for (int i = 0; i < objetos.length; ++i) {
            ficheros[i] = (SaveInfo)objetos[i];
        }
        return ficheros;
    }
}

