/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Description;
import eu.irreality.age.EVASemanticException;
import eu.irreality.age.Entity;
import eu.irreality.age.EntityList;
import eu.irreality.age.GameEngineThread;
import eu.irreality.age.Informador;
import eu.irreality.age.InputOutputClient;
import eu.irreality.age.Inventory;
import eu.irreality.age.Item;
import eu.irreality.age.Mobile;
import eu.irreality.age.MobileList;
import eu.irreality.age.ParserMethods;
import eu.irreality.age.Path;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.Room;
import eu.irreality.age.Spell;
import eu.irreality.age.SpellList;
import eu.irreality.age.StringMethods;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.Utility;
import eu.irreality.age.VolumeLimitExceededException;
import eu.irreality.age.Weapon;
import eu.irreality.age.WeightLimitExceededException;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.w3c.dom.Node;

public class Player
extends Mobile
implements Informador {
    protected String commandstring;
    protected String command;
    protected String arguments;
    protected Vector commandQueue = new Vector();
    protected String ZR_verbo = "mirar";
    protected String ZR_objeto_masculino_singular = "";
    protected String ZR_objeto_femenino_singular = "";
    protected String ZR_objeto_singular = "";
    protected String ZR_objeto_masculino_plural = "";
    protected String ZR_objeto_femenino_plural = "";
    protected String ZR_objeto_plural = "";
    protected String ZR_persona_masculino;
    protected String ZR_persona_femenino;
    protected String ZR_persona;
    protected boolean from_log;
    protected Vector logfile;
    protected boolean forced;
    protected String force_string;
    protected boolean secondChance;
    protected boolean nextCommandSecondChance;
    BufferedReader logReader;
    Vector finalExecutedCommandLog = new Vector();
    Weapon lastAttackWeapon = null;
    Mobile lastAttackedEnemy = null;
    Weapon lastBlockWeapon = null;
    Mobile lastBlockedEnemy = null;
    private EntityList mobilesCache;

    public void setPlayerName(String nombre) {
        this.title = nombre;
        this.properName = true;
        this.respondToSing = nombre + "$" + this.respondToSing;
        this.respondToPlur = nombre + "$" + this.respondToPlur;
        this.singNames = new Description[1];
        this.singNames[0] = new Description(nombre, 0L, 0L);
        this.plurNames = new Description[1];
        this.plurNames[0] = new Description(nombre, 0L, 0L);
    }

    public Player(World mundo, InputOutputClient io, Node n) throws XMLtoWorldException {
        super(mundo, n);
        this.io = io;
        this.setNewState(1, 1L);
    }

    public Player(World mundo, InputOutputClient io) throws IOException {
        super(mundo, Utility.playerFile(mundo));
        this.io = io;
        this.setRoom(mundo.getRoom(1));
        this.setRoom(mundo.getRoom(1));
        this.setNewState(1, 1L);
    }

    public void prepareLog(BufferedReader br) {
        System.out.println("Preparing log input on " + this);
        this.logReader = br;
        this.from_log = true;
    }

    public void endOfLog() {
        this.from_log = false;
    }

    public void forceCommand(String s) {
        this.forced = true;
        this.force_string = s;
    }

    public void setCommandString(String s) {
        this.commandstring = s;
    }

    public synchronized void resumeExecution() {
        this.notify();
    }

    private void escribirErrorNoEntiendo() {
        this.write(this.io.getColorCode("denial") + "No entiendo...\n" + this.io.getColorCode("reset"));
    }

    private void escribirDenegacionComando(String s) {
        if (this.secondChance) {
            this.escribirErrorNoEntiendo();
        } else {
            this.write(s);
        }
    }

    public boolean update(PropertyEntry pe, World mundo) {
        String theProp = pe.getName();
        if (theProp.equals("custom_parsing")) {
            boolean value = pe.getValueAsBoolean();
            if (value) {
                try {
                    return this.customParse();
                }
                catch (IOException ioe) {
                    this.write(this.io.getColorCode("error") + "Excepci\u00f3n E/S en update() para propiedad custom_parsing" + this.io.getColorCode("reset"));
                    return false;
                }
            }
            return true;
        }
        if (theProp.equals("state") && pe.getTimeLeft() < 0L) {
            pe.setTime(0L);
        }
        return super.update(pe, mundo);
    }

    public void setParseRoutine(Entity holdingTheRoutine, String routineName) {
        this.setProperty("custom_parsing", true, 0L);
        this.pushPropertyToFront("custom_parsing");
        this.setRelationshipProperty(holdingTheRoutine, "custom_parser", routineName);
    }

    public synchronized boolean customParse() throws IOException {
        String theCommand;
        if (this.from_log) {
            String newCommand = this.logReader.readLine();
            if (newCommand == null) {
                this.from_log = false;
                this.mundo.endOfLog();
                return this.customParse();
            }
            this.io.forceInput(newCommand, true);
            theCommand = newCommand;
        } else {
            GameEngineThread gte = (GameEngineThread)Thread.currentThread();
            if (gte.isRealTimeEnabled()) {
                theCommand = this.io.getRealTimeInput(this);
                if (theCommand == null) {
                    this.setPropertyTimeLeft("custom_parsing", 1L);
                    return false;
                }
            } else {
                theCommand = this.io.getInput(this);
                if (theCommand == null && this.io.isDisconnected()) {
                    this.disconnect();
                    return true;
                }
            }
        }
        List ofEntities = this.getRelatedEntities("custom_parser");
        if (ofEntities.size() < 1) {
            this.write(this.io.getColorCode("error") + "Error: llamada a customParse() sin entidades con parsers activos para \u00e9sta." + this.io.getColorCode("reset"));
            return false;
        }
        Entity ourEntity = null;
        String routineName = null;
        for (int i = 0; i < ofEntities.size() && (routineName = this.getRelationshipPropertyValueAsString(ourEntity = (Entity)ofEntities.get(i), "custom_parser")) == null; ++i) {
        }
        if (ourEntity instanceof SupportingCode) {
            ReturnValue retVal = new ReturnValue(null);
            try {
                ((SupportingCode)((Object)ourEntity)).execCode(routineName, new Object[]{this, theCommand}, retVal);
            }
            catch (TargetError bshte) {
                this.write(this.io.getColorCode("error") + "bsh.TargetError found at customParse(), execcing from ID " + this.getID() + " the routine " + routineName + " of " + ourEntity.getID());
                bshte.printStackTrace();
            }
            if (retVal.getRetVal() == null || !(retVal.getRetVal() instanceof Boolean)) {
                this.setProperty("custom_parsing", false, 0L);
                this.setRelationshipProperty(ourEntity, "custom_parser", null);
                return false;
            }
            Boolean ret = (Boolean)retVal.getRetVal();
            if (!ret.booleanValue()) {
                return this.customParse();
            }
            this.setProperty("custom_parsing", false, 0L);
            this.setRelationshipProperty(ourEntity, "custom_parser", null);
            return ret;
        }
        this.write(this.io.getColorCode("error") + "Error: llamada a customParse() para clase que no lo soporta: " + ourEntity.getClass());
        return false;
    }

    private EntityList getAllWorldMobiles() {
        if (this.mobilesCache == null) {
            this.mobilesCache = this.mundo.getAllMobiles();
        }
        return this.mobilesCache;
    }

    public synchronized boolean execCommand(World mundo) throws IOException {
        this.secondChance = false;
        String originalTrimmedCommandString = null;
        if (!this.commandQueue.isEmpty()) {
            if (this.nextCommandSecondChance) {
                this.secondChance = true;
                this.nextCommandSecondChance = false;
            }
            for (int i = 0; i < this.commandQueue.size(); ++i) {
            }
            originalTrimmedCommandString = this.commandstring = ((String)this.commandQueue.elementAt(0)).trim();
            this.commandQueue.removeElementAt(0);
            if (!this.separateSentences()) {
                return false;
            }
        } else {
            if (this.forced) {
                this.forced = false;
                this.io.forceInput(this.force_string, false);
                this.commandstring = this.force_string;
            } else if (this.from_log) {
                String newCommand = this.logReader.readLine();
                if (newCommand == null) {
                    this.from_log = false;
                    mundo.endOfLog();
                    return this.execCommand(mundo);
                }
                this.io.forceInput(newCommand, true);
                this.commandstring = newCommand;
            } else {
                GameEngineThread gte = (GameEngineThread)Thread.currentThread();
                if (gte.isRealTimeEnabled()) {
                    this.commandstring = this.io.getRealTimeInput(this);
                    if (this.commandstring == null) {
                        this.commandstring = "";
                        if (this.io.isDisconnected()) {
                            this.disconnect();
                            return true;
                        }
                    }
                } else {
                    this.commandstring = this.io.getInput(this);
                    if (this.commandstring == null && this.io.isDisconnected()) {
                        this.disconnect();
                        return true;
                    }
                }
            }
            if (this.commandstring != null) {
                this.commandstring = this.commandstring.trim();
            }
            if (this.commandstring == null || this.commandstring.equals("")) {
                return false;
            }
            originalTrimmedCommandString = this.commandstring;
            if (!this.separateSentences()) {
                return false;
            }
        }
        return this.execCommand(this.commandstring);
    }

    public boolean execCommand(String commandstring) {
        Item ourItem;
        int i;
        Entity objetivo;
        ReturnValue retval;
        String originalTrimmedCommandString = commandstring;
        commandstring = this.substitutePronounsInSentence(commandstring);
        commandstring = commandstring.trim();
        commandstring = this.lenguaje.sustituirVerbo(commandstring);
        commandstring = this.lenguaje.sustituirSinonimos(commandstring);
        commandstring = this.lenguaje.sustituirAlias(commandstring);
        commandstring = commandstring.trim();
        this.command = StringMethods.getTok(commandstring, 1, ' ').trim();
        if ("decir".equalsIgnoreCase(this.command)) {
            commandstring = originalTrimmedCommandString;
        }
        this.arguments = StringMethods.getToks(commandstring, 2, StringMethods.numToks(commandstring, ' '), ' ').trim();
        this.finalExecutedCommandLog.addElement(commandstring);
        String actionName = "";
        Object[] actionArgs = null;
        boolean ejecutado = false;
        try {
            retval = new ReturnValue(null);
            boolean bl = ejecutado = ejecutado || this.execCode("parseCommand", new Object[]{this.command, this.arguments}, retval);
            if (retval.getRetVal() != null) {
                commandstring = (String)retval.getRetVal();
                this.command = StringMethods.getTok(commandstring, 1, ' ').trim();
                this.arguments = StringMethods.getToks(commandstring, 2, StringMethods.numToks(commandstring, ' '), ' ').trim();
            }
        }
        catch (TargetError te) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at player's parseCommand, command was " + this.command + this.arguments + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
        }
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        try {
            retval = new ReturnValue(null);
            boolean bl = ejecutado = ejecutado || this.mundo.execCode("parseCommand", new Object[]{this, this.command, this.arguments}, retval);
            if (retval.getRetVal() != null) {
                commandstring = (String)retval.getRetVal();
                this.command = StringMethods.getTok(commandstring, 1, ' ').trim();
                this.arguments = StringMethods.getToks(commandstring, 2, StringMethods.numToks(commandstring, ' '), ' ').trim();
            }
        }
        catch (TargetError te) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at world's parseCommand, command was " + this.command + this.arguments + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
        }
        if (ejecutado) {
            this.setNewState(1, 1L);
            this.ZR_verbo = this.command;
            return true;
        }
        ejecutado = false;
        EntityList posiblesObjetivos = this.getReachableEntities();
        Vector[] objetivos_ss = ParserMethods.refersToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, false, false);
        Vector[] objetivos_sp = ParserMethods.refersToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, false, true);
        Vector[] objetivos_ps = ParserMethods.refersToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, true, false);
        Vector[] objetivos_pp = ParserMethods.refersToEntitiesIn(this.arguments, posiblesObjetivos, posiblesObjetivos, true, true);
        Vector objetivos_s = ParserMethods.refersToEntityIn(this.arguments, posiblesObjetivos, false);
        Vector objetivos_p = ParserMethods.refersToEntityIn(this.arguments, posiblesObjetivos, true);
        if (objetivos_s.size() > 0) {
            objetivo = (Entity)objetivos_s.get(0);
            if (objetivo instanceof Item) {
                this.meterObjetoEnZRSingular((Item)objetivo);
            }
            for (i = 0; i <= StringMethods.numToks(this.arguments, ' ') && !ejecutado; ++i) {
                if (!(objetivo instanceof Item)) continue;
                Item ourItem2 = (Item)objetivo;
                try {
                    if (i == 0) {
                        ejecutado = ejecutado || ourItem2.execCode("command_" + this.command, "this: " + ourItem2.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                        continue;
                    }
                    ejecutado = ejecutado || ourItem2.execCode(("command_" + this.command + "_" + StringMethods.getToks(this.arguments, 1, i, ' ')).replace(' ', '_'), "this: " + ourItem2.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                    continue;
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at command " + (this.command + StringMethods.getToks(this.arguments, 1, i, ' ')).replace(' ', '_') + ", item number " + ourItem2.getID() + this.io.getColorCode("reset"));
                }
            }
            if (objetivo instanceof SupportingCode) {
                try {
                    ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommand", new Object[]{this, this.command, this.arguments});
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + this.arguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                }
            }
            if (ejecutado) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
        } else if (objetivos_p.size() > 0) {
            this.resetZRPlural();
            for (i = 0; i < objetivos_p.size(); ++i) {
                objetivo = (Entity)objetivos_p.get(i);
                if (objetivo instanceof Item) {
                    this.meterObjetoEnZRPlural((Item)objetivo);
                }
                for (int j = 0; j <= StringMethods.numToks(this.arguments, ' ') && !ejecutado; ++j) {
                    if (!(objetivo instanceof Item)) continue;
                    ourItem = (Item)objetivo;
                    try {
                        if (j == 0) {
                            ejecutado = ejecutado || ourItem.execCode("command_" + this.command, "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                            continue;
                        }
                        ejecutado = ejecutado || ourItem.execCode(("command_" + this.command + "_" + StringMethods.getToks(this.arguments, 1, i, ' ')).replace(' ', '_'), "this: " + ourItem.getID() + "\n" + "room: " + this.habitacionActual.getID() + "\n" + "location: inventory" + "\n" + "player: " + this.getID());
                        continue;
                    }
                    catch (EVASemanticException exc) {
                        this.write(this.io.getColorCode("error") + "EVASemanticException found at command " + (this.command + StringMethods.getToks(this.arguments, 1, i, ' ')).replace(' ', '_') + ", item number " + ourItem.getID() + this.io.getColorCode("reset"));
                    }
                }
                if (!(objetivo instanceof SupportingCode)) continue;
                try {
                    ejecutado = ejecutado || ((SupportingCode)((Object)objetivo)).execCode("parseCommand", new Object[]{this, this.command, this.arguments});
                    continue;
                }
                catch (TargetError te) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + this.arguments + ", item number " + objetivo.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
                }
            }
            if (ejecutado) {
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
        }
        Vector patternMatchVectorSing = objetivos_s;
        Vector patternMatchVectorPlur = objetivos_p;
        ejecutado = false;
        try {
            ejecutado = this.habitacionActual.execCode("command_" + this.command + "_" + this.arguments.replace(' ', '_'), "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID());
            if (!ejecutado) {
                if (this.arguments != null) {
                    ejecutado = this.habitacionActual.execCode("command_" + this.command, "this: " + this.habitacionActual.getID() + "\nargs: " + this.arguments + "\n" + "player: " + this.getID());
                } else if (this.arguments == null) {
                    ejecutado = this.habitacionActual.execCode("command_" + this.command, "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID());
                }
            }
        }
        catch (EVASemanticException exc) {
            this.write(this.io.getColorCode("error") + "EVASemanticException found at room command , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
        }
        try {
            ejecutado = ejecutado || this.habitacionActual.execCode("parseCommand", new Object[]{this, this.command, this.arguments});
        }
        catch (TargetError te) {
            te.printStackTrace();
            this.write(this.io.getColorCode("error") + "bsh.TargetError found at parseCommand(), command was " + this.command + this.arguments + ", room number " + this.habitacionActual.getID() + ", error was " + (Object)((Object)te) + this.io.getColorCode("reset"));
        }
        if (ejecutado) {
            this.ZR_verbo = this.command;
            return true;
        }
        if (this.command.equalsIgnoreCase("ir")) {
            actionName = "go";
            actionArgs = new Object[1];
            if (StringMethods.numToks(commandstring, ' ') < 2) {
                this.write(this.io.getColorCode("denial") + "\u00bfIr a d\u00f3nde?\n" + this.io.getColorCode("reset"));
                this.ZR_verbo = this.command;
                this.commandQueue.removeAllElements();
                return false;
            }
            if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("norte") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("n")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 0);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("sur") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("s")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 1);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("oeste") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("e")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 2);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("este") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("o")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 3);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("arriba") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("ar")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 8);
            } else if (StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("abajo") || StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' ').equalsIgnoreCase("ab")) {
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, 9);
            } else {
                for (int i2 = 0; i2 < this.habitacionActual.otherExits.length; ++i2) {
                    if (!this.habitacionActual.isValidExit(false, i2) || !this.habitacionActual.getExit(false, i2).matchExitCommand(StringMethods.getTok(this.arguments, StringMethods.numToks(this.arguments, ' '), ' '))) continue;
                    this.ZR_verbo = this.command;
                    actionArgs[0] = this.habitacionActual.getExit(false, i2);
                }
                if (actionArgs[0] == null) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfC\u00f3mo? \u00bfHacia d\u00f3nde quieres ir?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
            }
        } else if (this.command.equalsIgnoreCase("volver")) {
            int i3;
            actionName = "go";
            actionArgs = new Object[1];
            for (i3 = 0; i3 < this.habitacionActual.standardExits.length; ++i3) {
                if (!this.habitacionActual.isValidExit(true, i3) || this.mundo.getRoom(this.habitacionActual.getExit(true, i3).getDestinationID()) != this.habitacionAnterior) continue;
                this.ZR_verbo = this.command;
                actionArgs[0] = this.habitacionActual.getExit(true, i3);
                break;
            }
            if (actionArgs[0] == null) {
                for (i3 = 0; i3 < this.habitacionActual.otherExits.length; ++i3) {
                    if (!this.habitacionActual.isValidExit(false, i3) || this.mundo.getRoom(this.habitacionActual.getExit(false, i3).getDestinationID()) != this.habitacionAnterior) continue;
                    this.ZR_verbo = this.command;
                    actionArgs[0] = this.habitacionActual.getExit(false, i3);
                    break;
                }
            }
            if (actionArgs[0] == null) {
                this.escribirDenegacionComando(this.io.getColorCode("denial") + "No ves el modo de volver...\n" + this.io.getColorCode("reset"));
                this.ZR_verbo = this.command;
                this.commandQueue.removeAllElements();
                return false;
            }
        } else {
            Vector[] patternMatchVectorSingSing;
            if (this.command.equalsIgnoreCase("mirar")) {
                if (StringMethods.numToks(commandstring, ' ') < 2) {
                    this.show_room(this.mundo);
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                String s = this.habitacionActual.getExtraDescription(this.arguments, this);
                if (s != null) {
                    this.write(this.io.getColorCode("description") + s + this.io.getColorCode("reset") + "\n");
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                boolean mirado = false;
                System.out.println("Mirado init");
                if (!mirado) {
                    mirado = this.mirarExtrasItems(this.arguments, this.habitacionActual.itemsInRoom);
                }
                System.out.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarExtrasItems(this.arguments, this.inventory);
                }
                System.out.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarItem(this.arguments, this.habitacionActual.itemsInRoom);
                }
                System.out.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarContenido(this.arguments, this.habitacionActual.itemsInRoom);
                }
                System.out.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarItem(this.arguments, this.inventory);
                }
                System.out.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarContenido(this.arguments, this.inventory);
                }
                System.out.println("Mirado=" + mirado);
                if (!mirado) {
                    mirado = this.mirarBicho(this.arguments, this.habitacionActual.mobsInRoom);
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 pretendes mirar?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
                this.ZR_verbo = this.command;
                this.setNewState(1, 1L);
                return true;
            }
            if (this.command.equalsIgnoreCase("atacar")) {
                boolean mirado = false;
                mirado = this.atacarBichoConArma(this.habitacionActual.mobsInRoom, this.getUsableWeapons());
                if (!mirado) {
                    if (this.inventory.patternMatch(this.arguments, false) != null && this.inventory.patternMatch(this.arguments, false).size() > 0) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + "Para atacar con un arma, primero has de blandirla.\n" + this.io.getColorCode("reset"));
                    }
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfC\u00f3mo? \u00bfAtacar a qui\u00e9n?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("bloquear") || this.command.equalsIgnoreCase("defender")) {
                boolean mirado = false;
                mirado = this.bloquearBichoConArma(this.habitacionActual.mobsInRoom, this.getUsableWeapons());
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfC\u00f3mo? \u00bfDefenderse de qui\u00e9n?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("esquivar")) {
                boolean mirado = false;
                mirado = this.esquivar();
                if (!mirado) {
                    this.escribirDenegacionComando("\nNo te atacan. \u00bfEsquivar qu\u00e9?\n");
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("abrir")) {
                boolean mirado = false;
                patternMatchVectorSingSing = null;
                Object patternMatchVectorSingPlur = null;
                Object patternMatchVectorPlurSing = null;
                Object patternMatchVectorPlurPlur = null;
                mirado = this.abrirPuertaConLlave(this.habitacionActual.itemsInRoom, this.inventory);
                if (!mirado) {
                    mirado = this.abrirPuertaConLlave(this.inventory, this.inventory);
                }
                if (!mirado) {
                    int i4;
                    Item ourItem3;
                    if (this.habitacionActual.itemsInRoom != null && !this.habitacionActual.itemsInRoom.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.habitacionActual.itemsInRoom != null) {
                            patternMatchVectorSing = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0) {
                            ourItem3 = (Item)patternMatchVectorSing.elementAt(0);
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).abrir() + this.io.getColorCode("reset") + "\n");
                            this.habitacionActual.informAction(this, ourItem3, null, "$1 intenta abrir $2.\n", "$1 intenta abrirte.\n", "Intentas abrir $2.\n", false);
                            mirado = true;
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (i4 = 0; i4 < patternMatchVectorPlur.size(); ++i4) {
                                ourItem3 = (Item)patternMatchVectorPlur.elementAt(i4);
                                this.write("Intentas abrir " + ourItem3.constructName2True(1, this) + ": ");
                                this.habitacionActual.informAction(this, ourItem3, null, "$1 intenta abrir $2.\n", "$1 intenta abrirte.\n", "Intentas abrir $2.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem3.abrir() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                    if (this.inventory != null && !this.inventory.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.inventory != null) {
                            patternMatchVectorSing = this.inventory.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.inventory.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0) {
                            ourItem3 = (Item)patternMatchVectorSing.elementAt(0);
                            mirado = true;
                            this.habitacionActual.informAction(this, ourItem3, null, "$1 intenta abrir $2.\n", "$1 intenta abrirte.\n", "Intentas abrir $2.\n", false);
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).abrir() + this.io.getColorCode("reset") + "\n");
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (i4 = 0; i4 < patternMatchVectorPlur.size(); ++i4) {
                                ourItem3 = (Item)patternMatchVectorPlur.elementAt(i4);
                                this.write("Tratas de abrir " + ourItem3.constructName2True(1, this) + " que llevas: ");
                                this.habitacionActual.informAction(this, ourItem3, null, "$1 intenta abrir $2 que lleva.\n", "$1 intenta abrirte.\n", "Intentas abrir $2 que llevas.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem3.abrir() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 pretendes abrir?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
                this.ZR_verbo = this.command;
                this.setNewState(1, 1L);
                return true;
            }
            if (this.command.equalsIgnoreCase("cerrar")) {
                boolean mirado = false;
                mirado = this.cerrarPuertaConLlave(this.habitacionActual.itemsInRoom, this.inventory);
                if (!mirado) {
                    mirado = this.cerrarPuertaConLlave(this.inventory, this.inventory);
                }
                if (!mirado) {
                    if (this.habitacionActual.itemsInRoom != null && !this.habitacionActual.itemsInRoom.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.habitacionActual.itemsInRoom != null) {
                            patternMatchVectorSing = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.habitacionActual.itemsInRoom.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0 && !((Item)patternMatchVectorSing.elementAt(0)).getDescription(this).equals("")) {
                            ourItem = (Item)patternMatchVectorSing.elementAt(0);
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).cerrar() + this.io.getColorCode("reset") + "\n");
                            this.habitacionActual.informAction(this, ourItem, null, "$1 intenta cerrar $2.\n", "$1 intenta cerrarte.\n", "Intentas cerrar $2.\n", false);
                            mirado = true;
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (int i5 = 0; i5 < patternMatchVectorPlur.size(); ++i5) {
                                ourItem = (Item)patternMatchVectorPlur.elementAt(i5);
                                if (ourItem.getDescription(this).equals("")) continue;
                                this.write("Intentas cerrar " + ourItem.constructName2True(1, this) + ": ");
                                this.habitacionActual.informAction(this, ourItem, null, "$1 intenta cerrar $2.\n", "$1 intenta cerrarte.\n", "Intentas cerrar $2.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem.cerrar() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                    if (this.inventory != null && !this.inventory.isEmpty()) {
                        patternMatchVectorSing = new Vector();
                        patternMatchVectorPlur = new Vector();
                        if (this.inventory != null) {
                            patternMatchVectorSing = this.inventory.patternMatch(this.arguments, false);
                            patternMatchVectorPlur = this.inventory.patternMatch(this.arguments, true);
                        }
                        if (patternMatchVectorSing.size() > 0 && !((Item)patternMatchVectorSing.elementAt(0)).getDescription(this).equals("")) {
                            mirado = true;
                            this.write(this.io.getColorCode("action") + ((Item)patternMatchVectorSing.elementAt(0)).cerrar() + this.io.getColorCode("reset") + "\n");
                        } else if (patternMatchVectorPlur.size() > 0) {
                            mirado = true;
                            for (int i6 = 0; i6 < patternMatchVectorPlur.size(); ++i6) {
                                ourItem = (Item)patternMatchVectorPlur.elementAt(i6);
                                if (ourItem.constructName2(1, this).equals("")) continue;
                                this.write("Tratas de cerrar " + ourItem.constructName2True(1, this) + " que llevas: ");
                                this.habitacionActual.informAction(this, ourItem, null, "$1 intenta cerrar $2 que lleva.\n", "$1 intenta cerrarte.\n", "Intentas cerrar $2 que llevas.\n", false);
                                this.write(this.io.getColorCode("action") + ourItem.cerrar() + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    }
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 pretendes cerrar?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
                this.ZR_verbo = this.command;
                this.setNewState(1, 1L);
                return true;
            }
            if (this.command.equalsIgnoreCase("poner") || this.command.equalsIgnoreCase("meter")) {
                Item ourItem4;
                Item ourContainer;
                Vector[] theVectors;
                boolean mirado = false;
                patternMatchVectorSingSing = null;
                Vector[] patternMatchVectorPlurSing = null;
                if (this.habitacionActual.itemsInRoom != null && !this.habitacionActual.itemsInRoom.isEmpty() && this.inventory != null && !this.inventory.isEmpty()) {
                    patternMatchVectorSingSing = this.inventory.patternMatchTwo(this.habitacionActual.itemsInRoom, this.arguments, false, false);
                    patternMatchVectorPlurSing = this.inventory.patternMatchTwo(this.habitacionActual.itemsInRoom, this.arguments, true, false);
                    if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
                        mirado = true;
                        theVectors = patternMatchVectorSingSing;
                        ourContainer = (Item)theVectors[1].elementAt(0);
                        Item ourItem5 = (Item)theVectors[0].elementAt(0);
                        if (!ourContainer.isContainer()) {
                            this.write(this.io.getColorCode("denial") + "No parece muy \u00fatil poner cosas en " + ourContainer.constructName2True(1, this) + "." + this.io.getColorCode("reset") + "\n");
                        } else if (ourContainer.isCloseable() && !ourContainer.isOpen()) {
                            this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " est\u00e1 cerrad" + (ourContainer.getGender() ? "o." : "a.") + this.io.getColorCode("reset") + "\n");
                        } else {
                            try {
                                ourContainer.getContents().addItem(ourItem5);
                                this.removeItem(ourItem5);
                                this.write(this.io.getColorCode("action") + "Pones " + ourItem5.constructName2True(1, this) + " en " + ourContainer.constructName2True(1, this) + "." + this.io.getColorCode("reset") + "\n");
                            }
                            catch (WeightLimitExceededException wle) {
                                this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " no puede soportar tanto peso." + this.io.getColorCode("reset") + "\n");
                            }
                            catch (VolumeLimitExceededException vle) {
                                this.write(this.io.getColorCode("denial") + ourItem5.constructName2True(1, this) + " no cabe en " + ourContainer.constructName2True(1, this) + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    } else if (patternMatchVectorPlurSing != null && patternMatchVectorPlurSing[0].size() > 0) {
                        mirado = true;
                        theVectors = patternMatchVectorPlurSing;
                        ourContainer = (Item)theVectors[1].elementAt(0);
                        if (!ourContainer.isContainer()) {
                            this.write(this.io.getColorCode("denial") + "No parece muy \u00fatil poner cosas en " + ourContainer.constructName2True(1, this) + "." + this.io.getColorCode("reset") + "\n");
                        } else if (ourContainer.isCloseable() && !ourContainer.isOpen()) {
                            this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " est\u00e1 cerrad" + (ourContainer.getGender() ? "o." : "a.") + this.io.getColorCode("reset") + "\n");
                        } else {
                            for (int i7 = 0; i7 < theVectors[0].size(); ++i7) {
                                ourItem4 = (Item)theVectors[0].elementAt(i7);
                                try {
                                    ourContainer.getContents().addItem(ourItem4);
                                    this.removeItem(ourItem4);
                                    this.write(this.io.getColorCode("action") + "Pones " + ourItem4.constructName2True(1, this) + " en " + ourContainer.constructName2True(1, this) + "." + this.io.getColorCode("reset") + "\n");
                                    continue;
                                }
                                catch (WeightLimitExceededException wle) {
                                    this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " no puede soportar tanto peso." + this.io.getColorCode("reset") + "\n");
                                    continue;
                                }
                                catch (VolumeLimitExceededException vle) {
                                    this.write(this.io.getColorCode("denial") + ourItem4.constructName2True(1, this) + " no cabe en " + ourContainer.constructName2True(1, this) + this.io.getColorCode("reset") + "\n");
                                }
                            }
                        }
                    }
                }
                if (!mirado && this.inventory != null && !this.inventory.isEmpty()) {
                    patternMatchVectorSingSing = this.inventory.patternMatchTwo(this.arguments, false, false);
                    patternMatchVectorPlurSing = this.inventory.patternMatchTwo(this.arguments, true, false);
                    if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
                        mirado = true;
                        theVectors = patternMatchVectorSingSing;
                        ourContainer = (Item)theVectors[1].elementAt(0);
                        Item ourItem6 = (Item)theVectors[0].elementAt(0);
                        if (!ourContainer.isContainer()) {
                            this.write(this.io.getColorCode("denial") + "No parece muy \u00fatil poner cosas en " + ourContainer.constructName2True(1, this) + "..." + this.io.getColorCode("reset") + "\n");
                        } else if (ourContainer.isCloseable() && !ourContainer.isOpen()) {
                            this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " est\u00e1 cerrad" + (ourContainer.getGender() ? "o." : "a.") + this.io.getColorCode("reset") + "\n");
                        } else {
                            try {
                                ourContainer.getContents().addItem(ourItem6);
                                this.removeItem(ourItem6);
                                this.write(this.io.getColorCode("action") + "Pones " + ourItem6.constructName2True(1, this) + " en " + ourContainer.constructName2True(1, this) + "." + this.io.getColorCode("reset") + "\n");
                            }
                            catch (WeightLimitExceededException wle) {
                                this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " no puede soportar tanto peso." + this.io.getColorCode("reset") + "\n");
                            }
                            catch (VolumeLimitExceededException vle) {
                                this.write(this.io.getColorCode("denial") + ourItem6.constructName2True(1, this) + " no cabe en " + ourContainer.constructName2True(1, this) + this.io.getColorCode("reset") + "\n");
                            }
                        }
                    } else if (patternMatchVectorPlurSing != null && patternMatchVectorPlurSing[0].size() > 0) {
                        mirado = true;
                        theVectors = patternMatchVectorPlurSing;
                        ourContainer = (Item)theVectors[1].elementAt(0);
                        if (!ourContainer.isContainer()) {
                            this.write(this.io.getColorCode("denial") + "No parece muy \u00fatil poner cosas en " + ourContainer.constructName2True(1, this) + "..." + this.io.getColorCode("reset") + "\n");
                        } else if (ourContainer.isCloseable() && !ourContainer.isOpen()) {
                            this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " est\u00e1 cerrad" + (ourContainer.getGender() ? "o." : "a.") + this.io.getColorCode("reset") + "\n");
                        } else {
                            for (int i8 = 0; i8 < theVectors[0].size(); ++i8) {
                                ourItem4 = (Item)theVectors[0].elementAt(i8);
                                try {
                                    ourContainer.getContents().addItem(ourItem4);
                                    this.removeItem(ourItem4);
                                    this.write(this.io.getColorCode("action") + "Pones " + ourItem4.constructName2True(1, this) + " en " + ourContainer.constructName2True(1, this) + "." + this.io.getColorCode("reset") + "\n");
                                    continue;
                                }
                                catch (WeightLimitExceededException wle) {
                                    this.write(this.io.getColorCode("denial") + ourContainer.constructName2True(1, this) + " no puede soportar tanto peso." + this.io.getColorCode("reset") + "\n");
                                    continue;
                                }
                                catch (VolumeLimitExceededException vle) {
                                    this.write(this.io.getColorCode("denial") + ourItem4.constructName2True(1, this) + " no cabe en " + ourContainer.constructName2True(1, this) + this.io.getColorCode("reset") + "\n");
                                }
                            }
                        }
                    }
                }
                if (!mirado) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfC\u00f3mo? \u00bfPoner qu\u00e9 d\u00f3nde?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("coger")) {
                boolean mirado = false;
                if (!mirado) {
                    mirado = this.cogerContenidoEspecificandoContenedor(this.arguments, this.habitacionActual.itemsInRoom, "");
                }
                if (!mirado) {
                    mirado = this.cogerItem(this.habitacionActual.itemsInRoom, null);
                }
                if (!mirado) {
                    mirado = this.cogerContenido(this.habitacionActual.itemsInRoom, "");
                }
                if (!mirado) {
                    mirado = this.cogerContenidoEspecificandoContenedor(this.arguments, this.inventory, "");
                }
                if (!mirado) {
                    mirado = this.cogerContenido(this.inventory, "");
                }
                if (mirado) {
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 pretendes coger?\n" + this.io.getColorCode("reset"));
                this.ZR_verbo = this.command;
                this.commandQueue.removeAllElements();
                return false;
            }
            if (this.command.equalsIgnoreCase("dejar")) {
                patternMatchVectorSing = new Vector();
                patternMatchVectorPlur = new Vector();
                if (this.inventory != null) {
                    patternMatchVectorSing = this.inventory.patternMatch(this.arguments, false);
                    patternMatchVectorPlur = this.inventory.patternMatch(this.arguments, true);
                }
                if (patternMatchVectorSing.size() > 0) {
                    Item ourItem7 = (Item)patternMatchVectorSing.elementAt(0);
                    try {
                        this.habitacionActual.addItem(ourItem7);
                        this.removeItem(ourItem7);
                        this.habitacionActual.informActionAuto(this, null, "$1 deja " + ourItem7.constructName2OneItem() + ".\n", false);
                        if (this.wieldedWeapons != null && this.wieldedWeapons.contains(ourItem7)) {
                            this.guardarArma(ourItem7);
                        }
                        if (this.wornItems != null && this.wornItems.contains(ourItem7)) {
                            this.desvestir(ourItem7);
                        }
                        this.write(this.io.getColorCode("action") + "Dejas " + ourItem7.constructName2True(1, this) + ".\n" + this.io.getColorCode("reset"));
                    }
                    catch (WeightLimitExceededException wle) {
                        this.write(this.io.getColorCode("denial") + "No puedes dejar aqu\u00ed " + ourItem7.constructName2True(1, this) + ", hay demasiado peso.\n" + this.io.getColorCode("reset"));
                    }
                    catch (VolumeLimitExceededException vle) {
                        this.write(this.io.getColorCode("denial") + "No puedes dejar aqu\u00ed " + ourItem7.constructName2True(1, this) + ", no hay espacio suficiente.\n" + this.io.getColorCode("reset"));
                    }
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                if (patternMatchVectorPlur.size() > 0) {
                    for (int i9 = 0; i9 < patternMatchVectorPlur.size(); ++i9) {
                        Item ourItem8 = (Item)patternMatchVectorPlur.elementAt(i9);
                        try {
                            this.habitacionActual.addItem(ourItem8);
                            this.removeItem(ourItem8);
                            this.habitacionActual.informActionAuto(this, null, "$1 deja " + ourItem8.constructName2OneItem() + ".\n", false);
                            if (this.wieldedWeapons != null && this.wieldedWeapons.contains(ourItem8)) {
                                this.guardarArma(ourItem8);
                            }
                            if (this.wornItems != null && this.wornItems.contains(ourItem8)) {
                                this.desvestir(ourItem8);
                            }
                            this.write(this.io.getColorCode("action") + "Dejas " + ourItem8.constructName2True(1, this) + ".\n" + this.io.getColorCode("reset"));
                            continue;
                        }
                        catch (WeightLimitExceededException wle) {
                            if (i9 == 0) {
                                this.write(this.io.getColorCode("denial") + "No puedes dejar aqu\u00ed " + ourItem8.constructName2True(1, this) + ", hay demasiado peso.\n" + this.io.getColorCode("reset"));
                                continue;
                            }
                            this.write(this.io.getColorCode("denial") + "No puedes dejar aqu\u00ed m\u00e1s cosas, hay demasiado peso.\n" + this.io.getColorCode("reset"));
                            continue;
                        }
                        catch (VolumeLimitExceededException vle) {
                            if (i9 == 0) {
                                this.write(this.io.getColorCode("denial") + "No puedes dejar aqu\u00ed " + ourItem8.constructName2True(1, this) + ", no hay espacio suficiente.\n" + this.io.getColorCode("reset"));
                                continue;
                            }
                            this.write(this.io.getColorCode("denial") + "No puedes dejar aqu\u00ed m\u00e1s cosas, no hay espacio suficiente.\n" + this.io.getColorCode("reset"));
                        }
                    }
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 pretendes dejar?\n" + this.io.getColorCode("reset"));
                this.ZR_verbo = this.command;
                this.commandQueue.removeAllElements();
                return false;
            }
            if (this.command.equalsIgnoreCase("inventario") && this.arguments.trim().length() < 1) {
                if (this.inventory != null) {
                    String str = this.inventory.toString(this);
                    if (str.equalsIgnoreCase("nada.")) {
                        this.write(this.io.getColorCode("information") + "No tienes nada.\n" + this.io.getColorCode("reset"));
                    } else {
                        Inventory wornItems;
                        this.write(this.io.getColorCode("information") + "Tienes " + str + "\n" + this.io.getColorCode("reset"));
                        Inventory limbs = this.getFlattenedPartsInventory();
                        if (this.wieldedWeapons != null) {
                            for (int i10 = 0; i10 < this.wieldedWeapons.size(); ++i10) {
                                if (this.wieldedWeapons.elementAt(i10) == null) continue;
                                Item arma = this.wieldedWeapons.elementAt(i10);
                                for (int j = 0; j < limbs.size(); ++j) {
                                    Item miembro = limbs.elementAt(j);
                                    if (!miembro.getRelationshipPropertyValueAsBoolean(arma, "wields")) continue;
                                    this.write(this.io.getColorCode("information") + "Blandes " + arma.constructName2OneItem(this) + " en " + miembro.constructName2OneItem(this) + ".\n" + this.io.getColorCode("reset"));
                                }
                            }
                        }
                        if ((wornItems = this.getWornItems()) != null) {
                            for (int i11 = 0; i11 < wornItems.size(); ++i11) {
                                if (wornItems.elementAt(i11) == null) continue;
                                Item vestido = wornItems.elementAt(i11);
                                Vector<Item> miembrosOcupados = new Vector<Item>();
                                for (int j = 0; j < limbs.size(); ++j) {
                                    Item miembro = limbs.elementAt(j);
                                    if (!miembro.getRelationshipPropertyValueAsBoolean(vestido, "wears")) continue;
                                    miembrosOcupados.add(miembro);
                                }
                                String toOutput = "";
                                for (int j = 0; j < miembrosOcupados.size(); ++j) {
                                    Item limb = (Item)miembrosOcupados.get(j);
                                    toOutput = j == 0 ? toOutput + limb.constructName2OneItem(this) : (j > 0 && j == miembrosOcupados.size() - 1 ? toOutput + " y " + limb.constructName2OneItem(this) : toOutput + ", " + limb.constructName2OneItem(this));
                                }
                                this.write(this.io.getColorCode("information") + "Llevas " + vestido.constructName2OneItem(this) + " en " + toOutput + ".\n" + this.io.getColorCode("reset"));
                            }
                        }
                    }
                } else {
                    this.write(this.io.getColorCode("information") + "No tienes nada.\n" + this.io.getColorCode("reset"));
                }
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("hechizos") && this.arguments.trim().length() < 1) {
                if (this.spellRefs != null) {
                    this.write(this.io.getColorCode("information") + "Hechizos conocidos:\n" + this.io.getColorCode("reset"));
                    for (int i12 = 0; i12 < this.spellRefs.size(); ++i12) {
                        Spell current = (Spell)this.spellRefs.get(i12);
                        this.write(this.io.getColorCode("information") + current.getTitle() + this.io.getColorCode("reset") + "\n");
                    }
                } else {
                    this.write(this.io.getColorCode("information") + "No sabes hacer magia.\n");
                }
                this.setNewState(1, 1L);
                this.ZR_verbo = this.command;
                return true;
            }
            if (this.command.equalsIgnoreCase("suicidar") || this.command.equalsIgnoreCase("suicidarse")) {
                this.suicide();
                return true;
            }
            if (this.command.equalsIgnoreCase("desvestir")) {
                if (!this.oneTargetAction("unwear", this.arguments, this.getWornItems())) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 pretendes quitarte?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
            } else if (this.command.equalsIgnoreCase("vestir")) {
                if (!this.oneTargetAction("wear", this.arguments, this.inventory)) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 pretendes vestir?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
            } else if (this.command.equalsIgnoreCase("blandir")) {
                if (!this.oneTargetAction("wield", this.arguments, this.inventory)) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 arma pretendes blandir?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
            } else if (this.command.equalsIgnoreCase("enfundar")) {
                if (!this.oneTargetAction("unwield", this.arguments, this.wieldedWeapons)) {
                    this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfQu\u00e9 arma pretendes enfundar?\n" + this.io.getColorCode("reset"));
                    this.ZR_verbo = this.command;
                    this.commandQueue.removeAllElements();
                    return false;
                }
            } else {
                if (this.command.equalsIgnoreCase("decir")) {
                    this.comandoDecir(this.arguments);
                    this.setNewState(1, 1L);
                    this.ZR_verbo = this.command;
                    return true;
                }
                if (this.command.equalsIgnoreCase("salir")) {
                    System.exit(0);
                } else {
                    if (this.command.equalsIgnoreCase("debug")) {
                        this.write("\nDebug Output:");
                        this.write("\nInventory:\n");
                        if (this.inventory != null) {
                            for (int i13 = 0; i13 < this.inventory.size(); ++i13) {
                                this.write(this.inventory.elementAt(i13).getID() + "");
                            }
                        }
                        return true;
                    }
                    if (this.command.equalsIgnoreCase("esperar")) {
                        if (StringMethods.numToks(commandstring, ' ') < 2) {
                            this.setNewState(1, 1L);
                            this.ZR_verbo = this.command;
                            return true;
                        }
                        int nsecs = 1;
                        try {
                            nsecs = Integer.valueOf(this.arguments);
                        }
                        catch (NumberFormatException nfe) {
                            // empty catch block
                        }
                        this.setNewState(1, nsecs);
                        this.ZR_verbo = this.command;
                        return true;
                    }
                    if (this.command.equalsIgnoreCase("hablar")) {
                        this.escribirDenegacionComando(this.io.getColorCode("denial") + "La mejor forma de hablar es decir algo.\n" + this.io.getColorCode("reset"));
                        this.ZR_verbo = this.command;
                        this.commandQueue.removeAllElements();
                        return false;
                    }
                    if (this.command.equalsIgnoreCase("salvar") || this.command.equalsIgnoreCase("save") || this.command.equalsIgnoreCase("cargar") || this.command.equalsIgnoreCase("load") || this.command.equalsIgnoreCase("grabar") || this.command.equalsIgnoreCase("restaurar")) {
                        this.escribirDenegacionComando(this.io.getColorCode("error") + "De momento, las opciones de salvar y cargar no est\u00e1n disponibles por texto en este interfaz. Puedes usar los men\u00fas para ello.\n" + this.io.getColorCode("reset"));
                        this.commandQueue.removeAllElements();
                        return false;
                    }
                    if (this.command.equalsIgnoreCase("invocar") || this.command.equalsIgnoreCase("convocar") || this.command.equalsIgnoreCase("hacer") || this.command.equalsIgnoreCase("realizar") || this.command.equalsIgnoreCase("usar") || this.command.equalsIgnoreCase("utilizar") || this.command.equalsIgnoreCase("crear") || this.command.equalsIgnoreCase("ejecutar") || this.command.equalsIgnoreCase("pronunciar") || this.command.equalsIgnoreCase("conjurar")) {
                        int i14;
                        boolean mirado = false;
                        EntityList possibleSpellTargets = new EntityList();
                        for (i14 = 0; i14 < this.habitacionActual.mobsInRoom.size(); ++i14) {
                            possibleSpellTargets.addEntity(this.habitacionActual.mobsInRoom.elementAt(i14));
                        }
                        for (i14 = 0; i14 < this.inventory.size(); ++i14) {
                            possibleSpellTargets.addEntity(this.inventory.elementAt(i14));
                        }
                        for (i14 = 0; i14 < this.habitacionActual.getInventory().size(); ++i14) {
                            possibleSpellTargets.addEntity(this.habitacionActual.getInventory().elementAt(i14));
                        }
                        mirado = this.hacerHechizo(possibleSpellTargets, this.getSpells());
                        if (!mirado) {
                            this.escribirDenegacionComando(this.io.getColorCode("denial") + "No conoces tal hechizo.\n" + this.io.getColorCode("reset"));
                            this.ZR_verbo = this.command;
                            this.commandQueue.removeAllElements();
                            return false;
                        }
                        this.ZR_verbo = this.command;
                        return true;
                    }
                    if (this.lenguaje.esVerboComando(this.command)) {
                        String origCommand = "";
                        if (originalTrimmedCommandString != null) {
                            origCommand = StringMethods.getTok(originalTrimmedCommandString, 1, ' ').trim();
                        }
                        if (!origCommand.endsWith("me") && !origCommand.endsWith("te")) {
                            this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfC\u00f3mo? \u00bf" + commandstring + "?\n" + this.io.getColorCode("reset"));
                        } else {
                            this.escribirDenegacionComando(this.io.getColorCode("denial") + "\u00bfC\u00f3mo? \u00bf" + originalTrimmedCommandString + "?\n" + this.io.getColorCode("reset"));
                        }
                        this.ZR_verbo = this.command;
                        this.commandQueue.removeAllElements();
                        return false;
                    }
                    if (!this.commandQueue.isEmpty() && ParserMethods.refersToEntityIn(this.command, this.getAllWorldMobiles(), false).size() > 0) {
                        String whatToSay = ((String)this.commandQueue.elementAt(0)).trim();
                        this.commandQueue.removeElementAt(0);
                        Mobile whomToSayItTo = (Mobile)ParserMethods.refersToEntityIn(this.command, this.getAllWorldMobiles(), false).get(0);
                        return this.execCommand("decir a " + whomToSayItTo.getBestReferenceName(false) + "\"" + whatToSay + "\"");
                    }
                    if (!this.ZR_verbo.equalsIgnoreCase(this.command)) {
                        this.secondChance = true;
                        return this.execCommand(this.ZR_verbo + " " + commandstring);
                    }
                    this.escribirErrorNoEntiendo();
                }
            }
        }
        if (!actionName.equals("")) {
            return this.executeAction(actionName, actionArgs);
        }
        return false;
    }

    public void die() {
        super.die();
        this.setRoom(this.mundo.getLimbo());
    }

    public void changeState(World mundo) {
        System.out.println("Player state " + this.getState() + ", target " + this.getTarget() + ", tu's " + this.getPropertyTimeLeft("state"));
        try {
            this.characterChangeState(mundo);
        }
        catch (IOException nopuidorl) {
            this.write(this.io.getColorCode("error") + "Excepci\u00f3n E/S en characterChangeState()" + this.io.getColorCode("reset"));
        }
    }

    public void characterChangeState(World mundo) throws IOException {
        switch (this.getState()) {
            case 1: {
                break;
            }
            case 2: {
                if (this.movingState_Path != null) {
                    this.write(this.io.getColorCode("action") + this.movingState_Path.getDescription(this) + "\n" + this.io.getColorCode("reset"));
                }
                try {
                    this.habitacionActual.execCode("event_exitroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "dest: " + this.getTarget());
                    this.habitacionActual.execCode("onExitRoom", new Object[]{this});
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at event_exitroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
                }
                catch (TargetError bshte) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found onExitRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
                }
                this.habitacionActual.informAction(this, null, "$1 se va hacia " + this.exitname + ".\n", null, null, false);
                this.setRoom(mundo.getRoom(this.getTarget()));
                this.habitacionActual.informAction(this, null, "$1 llega desde " + Path.invert(this.exitname) + ".\n", null, null, false);
                try {
                    this.habitacionActual.execCode("event_enterroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "orig: " + this.habitacionAnterior);
                    this.habitacionActual.execCode("onEnterRoom", new Object[]{this});
                }
                catch (EVASemanticException exc) {
                    this.write(this.io.getColorCode("error") + "EVASemanticException found at event_enterroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
                }
                catch (TargetError bshte) {
                    this.write(this.io.getColorCode("error") + "bsh.TargetError found onEnterRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
                }
                MobileList ml = this.habitacionActual.getMobiles();
                if (ml != null) {
                    for (int i = 0; i < ml.size(); ++i) {
                        Mobile bichoActual = ml.elementAt(i);
                        try {
                            bichoActual.execCode("onEnterRoom", new Object[]{this});
                            continue;
                        }
                        catch (TargetError bshte) {
                            this.write(this.io.getColorCode("error") + "bsh.TargetError found onEnterRoom , mobile number " + bichoActual.getID() + ": " + (Object)((Object)bshte) + "\n" + bshte.getMessage() + this.io.getColorCode("reset"));
                            bshte.printStackTrace();
                        }
                    }
                }
                this.show_room(mundo);
                this.setNewState(1, 0L);
                break;
            }
            case 3: {
                this.manageEndOfAttackState();
                return;
            }
            case 16: {
                this.manageEndOfCastState();
                return;
            }
            case 8: {
                this.write("Te recuperas de tu movimiento de ataque.\n");
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 10: {
                this.write("Te recuperas del golpe recibido.\n");
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 9: {
                this.write("Te recuperas de tu movimiento defensivo.\n");
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 14: {
                this.setNewState(1, 0L);
                this.showCombatReport();
                break;
            }
            case 4: {
                this.write("Est\u00e1s preparado para bloquear...\n");
                this.setNewState(5, 0L);
                return;
            }
            case 6: {
                this.setNewState(7, 0L);
                return;
            }
            case 5: {
                this.setNewState(5, 0L);
                return;
            }
            case 7: {
                this.setNewState(7, 0L);
                return;
            }
            case 12: {
                this.die();
                break;
            }
            case 13: {
                this.setNewState(1, 1L);
                return;
            }
            case 15: {
                this.setNewState(15, 1L);
                return;
            }
        }
        if (!this.execCommand(mundo)) {
            this.setNewState(1, 1L);
        }
    }

    public void showCombatReport() {
        if (this.combatRefs == null) {
            return;
        }
        for (int i = 0; i < this.combatRefs.size(); ++i) {
            Mobile enemigo = this.combatRefs.elementAt(i);
            if (enemigo.getState() != 3 || enemigo.getTarget() != this.getID()) continue;
            long tiempo = enemigo.getPropertyTimeLeft("state");
            int nSimulations = this.getStat("INT");
            for (int j = 0; j < this.wieldedWeapons.size(); ++j) {
                Weapon w = (Weapon)this.wieldedWeapons.elementAt(j);
                if (w == null) continue;
                int blocksInTime = 0;
                for (int s = 0; s < nSimulations; ++s) {
                    int t = this.generateBlockTime(w);
                    if ((long)t > tiempo) continue;
                    ++blocksInTime;
                }
                double inTimeProb = (double)blocksInTime / (double)nSimulations;
                if (inTimeProb >= 0.9) {
                    String string = "Seguramente te dar\u00eda tiempo a bloquear el golpe de $2 con " + w.constructName2OneItem(this) + ".";
                }
                String toInform = inTimeProb >= 0.7 ? "Crees que te dar\u00eda tiempo a bloquear el golpe de $2 con " + w.constructName2OneItem(this) + "." : (inTimeProb >= 0.5 ? "Es posible que te d\u00e9 tiempo a bloquear el golpe de $2 con " + w.constructName2OneItem(this) + "." : (inTimeProb >= 0.3 ? "Ser\u00e1 bastante dif\u00edcil bloquear a tiempo el golpe de $2 con " + w.constructName2OneItem(this) + "." : (inTimeProb >= 0.1 ? "Ser\u00e1 muy dif\u00edcil bloquear a tiempo el golpe de $2 con " + w.constructName2OneItem(this) + "." : "No crees que puedas bloquear a tiempo el golpe de $2 con " + w.constructName2OneItem(this) + ".")));
                this.habitacionActual.informAction(this, enemigo, null, null, toInform + "\n", true);
            }
            int dodgesInTime = 0;
            for (int s = 0; s < nSimulations; ++s) {
                int t = this.generateDodgeTime();
                if ((long)t > tiempo) continue;
                ++dodgesInTime;
            }
            double dodgeInTimeProb = (double)dodgesInTime / (double)nSimulations;
            String toInform = dodgeInTimeProb >= 0.8 ? "Seguramente podr\u00edas esquivar el ataque de $2 a tiempo." : (dodgeInTimeProb >= 0.6 ? "Probablemente podr\u00edas esquivar a tiempo el ataque de $2." : (dodgeInTimeProb >= 0.4 ? enemigo.getCurrentWeapon().constructName2OneItem(this) + " de $2 est\u00e1 cerca, ser\u00e1 dif\u00edcil esquivar su ataque." : (dodgeInTimeProb >= 0.2 ? enemigo.getCurrentWeapon().constructName2OneItem(this) + " de $2 est\u00e1 casi encima , ser\u00e1 muy dif\u00edcil esquivar su ataque." : enemigo.getCurrentWeapon().constructName2OneItem(this) + " de $2 est\u00e1 encima, no crees que puedas esquivar el ataque.")));
            this.habitacionActual.informAction(this, enemigo, null, null, toInform + "\n", true);
        }
    }

    public void show_room(World mundo) {
        long comparand = (long)this.getRelationshipState(this.habitacionActual) * (long)Math.pow(2.0, 32.0) + (long)this.habitacionActual.getState();
        this.write(this.io.getColorCode("description") + this.habitacionActual.getDescription(this) + this.io.getColorCode("reset") + "\n");
        try {
            this.habitacionActual.execCode("event_showroom", "this: " + this.habitacionActual.getID() + "\n" + "player: " + this.getID() + "\n" + "orig: " + this.habitacionAnterior);
            this.habitacionActual.execCode("onShowRoom", new Object[]{this});
        }
        catch (EVASemanticException exc) {
            this.write(this.io.getColorCode("error") + "EVASemanticException found at event_showroom , room number " + this.habitacionActual.getID() + this.io.getColorCode("reset"));
        }
        catch (TargetError bshte) {
            this.write(this.io.getColorCode("error") + "bsh.TargetError found onShowRoom , room number " + this.habitacionActual.getID() + ": " + (Object)((Object)bshte) + this.io.getColorCode("reset"));
        }
    }

    public synchronized void waitKeyPress() {
        if (!this.from_log) {
            GameEngineThread gte;
            Thread th = Thread.currentThread();
            System.out.println("WKP Thread: " + th + "( " + SwingUtilities.isEventDispatchThread() + " )");
            if (th instanceof GameEngineThread && (gte = (GameEngineThread)th).isRealTimeEnabled() && this.mundo.getPlayerList().size() > 1) {
                this.io.write("--\n");
                return;
            }
            System.out.println("WKP Call: " + this.io.getClass());
            this.io.waitKeyPress();
        }
    }

    public void borrarPantalla() {
        this.io.borrarPantalla();
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
        this.io.write(s);
    }

    public void setIO(InputOutputClient es) {
        this.io = es;
    }

    public void escribirAccion(String s) {
        this.writeAction(s);
    }

    public void writeAction(String s) {
        this.write(this.io.getColorCode("action") + s + this.io.getColorCode("reset"));
    }

    public void escribirDescripcion(String s) {
        this.writeDescription(s);
    }

    public void writeDescription(String s) {
        this.write(this.io.getColorCode("description") + s + this.io.getColorCode("reset"));
    }

    public void escribirNegacion(String s) {
        this.writeDenial(s);
    }

    public void writeDenial(String s) {
        this.write(this.io.getColorCode("denial") + s + this.io.getColorCode("reset"));
    }

    public void meterObjetoEnZRSingular(Item obj) {
        if (obj.getGender()) {
            this.ZR_objeto_masculino_singular = obj.getBestReferenceName(false);
        } else {
            this.ZR_objeto_femenino_singular = obj.getBestReferenceName(false);
        }
        this.ZR_objeto_singular = obj.getBestReferenceName(false);
    }

    public void resetZRPlural() {
        this.ZR_objeto_masculino_plural = "";
        this.ZR_objeto_femenino_plural = "";
        this.ZR_objeto_plural = "";
    }

    public void meterObjetoEnZRPlural(Item obj) {
        if (obj.getGender()) {
            if (!this.ZR_objeto_masculino_plural.equals("")) {
                this.ZR_objeto_masculino_plural = this.ZR_objeto_masculino_plural + ", ";
            }
            this.ZR_objeto_masculino_plural = this.ZR_objeto_masculino_plural + obj.getBestReferenceName(false);
        } else {
            if (!this.ZR_objeto_femenino_plural.equals("")) {
                this.ZR_objeto_femenino_plural = this.ZR_objeto_femenino_plural + ", ";
            }
            this.ZR_objeto_femenino_plural = this.ZR_objeto_femenino_plural + obj.getBestReferenceName(false);
        }
        if (!this.ZR_objeto_plural.equals("")) {
            this.ZR_objeto_plural = this.ZR_objeto_plural + ", ";
        }
        this.ZR_objeto_plural = this.ZR_objeto_plural + obj.getBestReferenceName(false);
    }

    public String substitutePronouns(String command) {
        String thestring = command;
        if (thestring.toLowerCase().endsWith("las") && thestring.length() > 3) {
            thestring = thestring.substring(0, thestring.length() - 3);
            thestring = thestring + " " + this.ZR_objeto_femenino_plural;
        }
        if (thestring.toLowerCase().endsWith("los") && thestring.length() > 3) {
            thestring = thestring.substring(0, thestring.length() - 3);
            thestring = thestring + " " + this.ZR_objeto_plural;
        }
        if (thestring.toLowerCase().endsWith("lo") && thestring.length() > 2) {
            thestring = thestring.substring(0, thestring.length() - 2);
            thestring = thestring + " " + this.ZR_objeto_masculino_singular;
        }
        if (thestring.toLowerCase().endsWith("la") && thestring.length() > 2) {
            thestring = thestring.substring(0, thestring.length() - 2);
            thestring = thestring + " " + this.ZR_objeto_femenino_singular;
        }
        if ((thestring.toLowerCase().endsWith("me") || thestring.toLowerCase().endsWith("te")) && !thestring.toLowerCase().endsWith("este") && !thestring.toLowerCase().endsWith("norte") && this.lenguaje.esVerboComando(thestring.substring(0, thestring.length() - 2))) {
            thestring = thestring.substring(0, thestring.length() - 2);
            thestring = thestring + " " + this.getBestReferenceName(false);
        }
        return thestring;
    }

    public boolean separateSentences() {
        Vector tokensYSeparadores = StringMethods.tokenizeWithComplexSeparators(this.commandstring, StringMethods.STANDARD_SENTENCE_SEPARATORS(), true);
        Vector<String> tempCommandQueue = new Vector<String>();
        int nComillas = 0;
        String acum = "";
        for (int i = 0; i < tokensYSeparadores.size(); ++i) {
            String cur = (String)tokensYSeparadores.elementAt(i);
            acum = acum + cur;
            for (int k = 0; k < cur.length(); ++k) {
                if (cur.charAt(k) != '\"') continue;
                ++nComillas;
            }
            if (!StringMethods.STANDARD_SENTENCE_SEPARATORS().contains(cur)) {
                if (nComillas % 2 != 0 && i != tokensYSeparadores.size() - 1) continue;
                tempCommandQueue.add(acum);
                System.out.println("ADDED: " + acum);
                acum = "";
                continue;
            }
            if (nComillas % 2 != 0) continue;
            acum = "";
        }
        tempCommandQueue.addAll(this.commandQueue);
        this.commandQueue = (Vector)tempCommandQueue.clone();
        if (this.commandQueue.isEmpty()) {
            return false;
        }
        this.commandstring = (String)this.commandQueue.elementAt(0);
        this.commandQueue.removeElementAt(0);
        return true;
    }

    public String substitutePronounsInSentence(String commandstring) {
        String subs_command = this.substitutePronouns(StringMethods.getTok(commandstring, 1, ' '));
        commandstring = subs_command + " " + StringMethods.getToks(commandstring, 2, StringMethods.numToks(commandstring, ' '), ' ');
        return commandstring;
    }

    private boolean abrirPuertaConLlave(Inventory i1, Inventory i2) {
        boolean mirado = false;
        List[] pairsVector = this.patternMatchPairs(i1, i2, this.arguments);
        List puertas = pairsVector[0];
        List llaves = pairsVector[1];
        if (puertas.size() == 0) {
            return false;
        }
        for (int i = 0; i < puertas.size(); ++i) {
            Item ourDoor = (Item)puertas.get(i);
            Item ourKey = (Item)llaves.get(i);
            this.habitacionActual.informAction(this, ourDoor, new Entity[]{ourKey}, "$1 intenta abrir $2 con $3.\n", "$1 intenta abrirte con $3.\n", "Intentas abrir $2 con $3.\n", false);
            this.write(this.io.getColorCode("action") + ourDoor.unlock(ourKey) + this.io.getColorCode("reset") + "\n");
        }
        return true;
    }

    private boolean esquivar() {
        List l = this.getAttackingEnemies();
        if (l == null || l.size() == 0) {
            return false;
        }
        Mobile objetivo = (Mobile)l.get(0);
        this.dodge(objetivo);
        return true;
    }

    private boolean bloquearBichoConArma(MobileList ml, Inventory i) {
        if (i == null || i.isEmpty() || ml == null || ml.isEmpty()) {
            return false;
        }
        boolean mirado = false;
        Vector[] patternMatchVectorSingSing = ml.patternMatchTwo(i, this.arguments, false, false);
        Vector[] patternMatchVectorSingPlur = ml.patternMatchTwo(i, this.arguments, false, true);
        Vector[] patternMatchVectorPlurSing = ml.patternMatchTwo(i, this.arguments, true, false);
        Vector[] patternMatchVectorPlurPlur = ml.patternMatchTwo(i, this.arguments, true, true);
        if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
            mirado = true;
            Vector[] theVectors = patternMatchVectorSingSing;
            Mobile objetivo = (Mobile)theVectors[0].elementAt(0);
            if (!this.hasEnemy(objetivo)) {
                return false;
            }
            this.lastBlockWeapon = (Weapon)theVectors[1].elementAt(0);
            this.lastBlockedEnemy = objetivo;
            this.block(objetivo, (Weapon)theVectors[1].elementAt(0));
        } else {
            Vector patternMatchVectorSingBicho = ml.patternMatch(this.arguments, false);
            Vector patternMatchVectorSingArma = i.patternMatch(this.arguments, false);
            if (patternMatchVectorSingBicho != null && patternMatchVectorSingBicho.size() > 0) {
                Mobile objetivo = (Mobile)patternMatchVectorSingBicho.elementAt(0);
                Weapon usada = null;
                if (this.lastAttackWeapon != null && this.wieldedWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (this.wieldedWeapons != null && this.wieldedWeapons.size() > 0) {
                    usada = (Weapon)this.wieldedWeapons.elementAt(0);
                }
                if (usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        return false;
                    }
                    this.lastBlockWeapon = usada;
                    this.lastBlockedEnemy = objetivo;
                    this.block(objetivo, usada);
                }
            } else if (patternMatchVectorSingArma != null && patternMatchVectorSingArma.size() > 0) {
                Mobile objetivo = null;
                Weapon usada = (Weapon)patternMatchVectorSingArma.elementAt(0);
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                }
                if (objetivo == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        return false;
                    }
                    this.lastBlockWeapon = usada;
                    this.lastBlockedEnemy = objetivo;
                    this.block(objetivo, usada);
                }
            } else {
                Mobile objetivo = null;
                Weapon usada = null;
                if (this.lastAttackWeapon != null && this.wieldedWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (this.wieldedWeapons != null && this.wieldedWeapons.size() > 0) {
                    usada = (Weapon)this.wieldedWeapons.elementAt(0);
                }
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                }
                if (objetivo == null || usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        return false;
                    }
                    this.lastBlockWeapon = usada;
                    this.lastBlockedEnemy = objetivo;
                    this.block(objetivo, usada);
                }
            }
        }
        return mirado;
    }

    private boolean atacarBichoConArma(MobileList ml, Inventory i) {
        if (i == null || i.isEmpty() || ml == null || ml.isEmpty()) {
            return false;
        }
        boolean mirado = false;
        Vector[] patternMatchVectorSingSing = ml.patternMatchTwo(i, this.arguments, false, false);
        Vector[] patternMatchVectorSingPlur = ml.patternMatchTwo(i, this.arguments, false, true);
        Vector[] patternMatchVectorPlurSing = ml.patternMatchTwo(i, this.arguments, true, false);
        Vector[] patternMatchVectorPlurPlur = ml.patternMatchTwo(i, this.arguments, true, true);
        if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
            mirado = true;
            Vector[] theVectors = patternMatchVectorSingSing;
            Mobile objetivo = (Mobile)theVectors[0].elementAt(0);
            if (!this.hasEnemy(objetivo)) {
                this.addEnemy(objetivo);
            }
            if (!objetivo.hasEnemy(this)) {
                objetivo.addEnemy(this);
            }
            this.lastAttackWeapon = (Weapon)theVectors[1].elementAt(0);
            this.lastAttackedEnemy = objetivo;
            this.attack(objetivo, (Weapon)theVectors[1].elementAt(0));
        } else {
            Vector patternMatchVectorSingBicho = ml.patternMatch(this.arguments, false);
            Vector patternMatchVectorSingArma = i.patternMatch(this.arguments, false);
            if (patternMatchVectorSingBicho != null && patternMatchVectorSingBicho.size() > 0) {
                Mobile objetivo = (Mobile)patternMatchVectorSingBicho.elementAt(0);
                Weapon usada = null;
                System.out.println("Wielded Weapons Size " + this.wieldedWeapons.size());
                Inventory usableWeapons = this.getUsableWeapons();
                if (this.lastAttackWeapon != null && usableWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (usableWeapons != null && usableWeapons.size() > 0) {
                    System.out.println("Setting first weapon as used");
                    for (int k = usableWeapons.size() - 1; k >= 0; --k) {
                        if (usableWeapons.elementAt(k) == null) continue;
                        usada = (Weapon)usableWeapons.elementAt(k);
                    }
                }
                if (usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        this.addEnemy(objetivo);
                    }
                    if (!objetivo.hasEnemy(this)) {
                        objetivo.addEnemy(this);
                    }
                    this.lastAttackWeapon = usada;
                    this.lastAttackedEnemy = objetivo;
                    this.attack(objetivo, usada);
                }
            } else if (patternMatchVectorSingArma != null && patternMatchVectorSingArma.size() > 0) {
                Mobile objetivo = null;
                Weapon usada = (Weapon)patternMatchVectorSingArma.elementAt(0);
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                } else if (this.getEnemies() != null && this.getEnemies().size() > 0 && this.habitacionActual.hasMobile(this.getEnemies().elementAt(0))) {
                    objetivo = this.getEnemies().elementAt(0);
                }
                if (objetivo == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        this.addEnemy(objetivo);
                    }
                    if (!objetivo.hasEnemy(this)) {
                        objetivo.addEnemy(this);
                    }
                    this.lastAttackWeapon = usada;
                    this.lastAttackedEnemy = objetivo;
                    this.attack(objetivo, usada);
                }
            } else {
                Mobile objetivo = null;
                Weapon usada = null;
                Inventory usableWeapons = this.getUsableWeapons();
                if (this.lastAttackWeapon != null && usableWeapons.contains(this.lastAttackWeapon)) {
                    usada = this.lastAttackWeapon;
                } else if (usableWeapons != null && usableWeapons.size() > 0) {
                    for (int k = usableWeapons.size() - 1; k >= 0; --k) {
                        if (usableWeapons.elementAt(k) == null) continue;
                        usada = (Weapon)usableWeapons.elementAt(k);
                    }
                }
                if (this.lastAttackedEnemy != null && this.habitacionActual.hasMobile(this.lastAttackedEnemy)) {
                    objetivo = this.lastAttackedEnemy;
                } else if (this.getEnemies() != null && this.getEnemies().size() > 0 && this.habitacionActual.hasMobile(this.getEnemies().elementAt(0))) {
                    objetivo = this.getEnemies().elementAt(0);
                }
                if (objetivo == null || usada == null) {
                    mirado = false;
                } else {
                    mirado = true;
                    if (!this.hasEnemy(objetivo)) {
                        this.addEnemy(objetivo);
                    }
                    if (!objetivo.hasEnemy(this)) {
                        objetivo.addEnemy(this);
                    }
                    this.lastAttackWeapon = usada;
                    this.lastAttackedEnemy = objetivo;
                    this.attack(objetivo, usada);
                }
            }
        }
        return mirado;
    }

    private boolean cerrarPuertaConLlave(Inventory i1, Inventory i2) {
        boolean mirado = false;
        List[] pairsVector = this.patternMatchPairs(i1, i2, this.arguments);
        List puertas = pairsVector[0];
        List llaves = pairsVector[1];
        if (puertas.size() == 0) {
            return false;
        }
        for (int i = 0; i < puertas.size(); ++i) {
            Item ourDoor = (Item)puertas.get(i);
            Item ourKey = (Item)llaves.get(i);
            this.habitacionActual.informAction(this, ourDoor, new Entity[]{ourKey}, "$1 intenta cerrar $2 con $3.\n", "$1 intenta cerrarte con $3.\n", "Intentas cerrar $2 con $3.\n", false);
            this.write(this.io.getColorCode("action") + ourDoor.lock(ourKey) + this.io.getColorCode("reset") + "\n");
        }
        return true;
    }

    private boolean cogerContenidoEspecificandoContenedor(String args, Inventory inv, String infoString) {
        boolean mirado = false;
        Vector patternMatchVectorSing = null;
        if (inv != null && !inv.isEmpty() && (patternMatchVectorSing = inv.patternMatch(args, false)) != null && patternMatchVectorSing.size() > 0) {
            for (int i = 0; i < patternMatchVectorSing.size(); ++i) {
                Item ourContainer = (Item)patternMatchVectorSing.elementAt(i);
                if (!ourContainer.isContainer() || ourContainer.isCloseable() && !ourContainer.isOpen()) continue;
                int ntokens = StringMethods.numToks(args, ' ');
                for (int punto_division = ntokens - 1; punto_division >= 1; --punto_division) {
                    boolean bl = mirado = mirado || this.cogerItem(StringMethods.getToks(args, 1, punto_division, ' '), ourContainer.getContents(), " de " + ourContainer.constructName2True(1, this) + infoString);
                    if (mirado) break;
                }
                if (mirado) break;
            }
        }
        return mirado;
    }

    private boolean cogerContenido(String args, Inventory inv, String infoString) {
        String tempstring;
        int i;
        boolean mirado = false;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        for (i = 0; i < inv.size(); ++i) {
            if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
            tempstring = infoString;
            infoString = infoString + " en ";
            infoString = infoString + inv.elementAt(i).constructName2True(1, this);
            mirado = this.cogerItem(args, inv.elementAt(i).getContents(), infoString);
            if (mirado) break;
            infoString = tempstring;
        }
        if (!mirado) {
            for (i = 0; i < inv.size(); ++i) {
                if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
                tempstring = infoString;
                infoString = infoString + " en ";
                infoString = infoString + inv.elementAt(i).constructName2True(1, this);
                mirado = this.cogerContenido(args, inv.elementAt(i).getContents(), infoString);
                if (mirado) break;
                infoString = tempstring;
            }
        }
        return mirado;
    }

    private boolean cogerContenido(Inventory inv, String infoString) {
        String tempstring;
        int i;
        boolean mirado = false;
        if (inv == null || inv.isEmpty()) {
            return false;
        }
        for (i = 0; i < inv.size(); ++i) {
            if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
            tempstring = infoString;
            infoString = infoString + " en ";
            infoString = infoString + inv.elementAt(i).constructName2True(1, this);
            mirado = this.cogerItem(inv.elementAt(i).getContents(), infoString);
            if (mirado) break;
            infoString = tempstring;
        }
        if (!mirado) {
            for (i = 0; i < inv.size(); ++i) {
                if (!inv.elementAt(i).isContainer() || inv.elementAt(i).isCloseable() && !inv.elementAt(i).isOpen()) continue;
                tempstring = infoString;
                infoString = infoString + " en ";
                infoString = infoString + inv.elementAt(i).constructName2True(1, this);
                mirado = this.cogerContenido(inv.elementAt(i).getContents(), infoString);
                if (mirado) break;
                infoString = tempstring;
            }
        }
        return mirado;
    }

    private boolean cogerItem(Inventory inv, String extraInfo) {
        return this.cogerItem(this.arguments, inv, extraInfo);
    }

    public InputOutputClient getIO() {
        return this.io;
    }

    public Vector getFinalCommandLog() {
        return this.finalExecutedCommandLog;
    }

    public void disconnect() {
        this.setProperty("disconnected", true);
        this.setNewState(15, 1L);
        this.setProperty("room", this.habitacionActual.getID());
        this.habitacionActual.removeMob(this);
        this.habitacionActual.informActionAuto(this, null, "$1 desaparece en un mar de irrealidad.\n", true);
    }

    public void reconnect(InputOutputClient io) {
        if (!this.getPropertyValueAsBoolean("disconnected")) {
            this.write("Hmm. \u00bfNo est\u00e1s conectado ya?\n");
            return;
        }
        this.setProperty("disconnected", false);
        this.setNewState(1, 1L);
        Room enQueEstaba = this.mundo.getRoom(this.getPropertyValueAsInteger("room"));
        enQueEstaba.addMob(this);
        this.getIO().write("Has sido a\u00f1adido al mundo.\n");
        this.getRoom().informActionAuto(this, null, "De repente, $1 aparece de la nada.\n", false);
        this.write("Old player rejoined the game.\n");
        this.setIO(io);
    }

    private boolean hacerHechizo(EntityList possibleTargets, SpellList possibleSpells) {
        if (possibleTargets == null || possibleTargets.isEmpty()) {
            return false;
        }
        boolean mirado = false;
        Vector[] patternMatchVectorSingSing = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, false, false);
        Vector[] patternMatchVectorSingPlur = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, false, true);
        Vector[] patternMatchVectorPlurSing = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, true, false);
        Vector[] patternMatchVectorPlurPlur = possibleSpells.patternMatchTwo(possibleTargets, this.arguments, true, true);
        if (patternMatchVectorSingSing != null && patternMatchVectorSingSing[0].size() > 0) {
            mirado = true;
            Vector[] theVectors = patternMatchVectorSingSing;
            Entity objetivo = (Entity)theVectors[1].elementAt(0);
            this.cast((Spell)theVectors[0].elementAt(0), objetivo);
        } else {
            Vector patternMatchSpellOnly = possibleSpells.patternMatch(this.arguments, false);
            if (patternMatchSpellOnly != null && patternMatchSpellOnly.size() > 0) {
                mirado = true;
                this.cast((Spell)patternMatchSpellOnly.elementAt(0), null);
            }
        }
        return mirado;
    }

    public boolean oneTargetAction(String action, String arguments, EntityList posiblesObjetivos) {
        Vector patternMatchVectorSing = new Vector();
        Vector patternMatchVectorPlur = new Vector();
        if (posiblesObjetivos != null) {
            patternMatchVectorSing = posiblesObjetivos.patternMatch(arguments, false);
            patternMatchVectorPlur = posiblesObjetivos.patternMatch(arguments, true);
        }
        if (patternMatchVectorSing.size() > 0) {
            Entity ourEntity = (Entity)patternMatchVectorSing.elementAt(0);
            boolean hecho = this.executeAction(action, new Object[]{ourEntity});
            if (!hecho) {
                this.ZR_verbo = this.command;
                this.commandQueue.removeAllElements();
                return true;
            }
            this.ZR_verbo = this.command;
            return true;
        }
        if (patternMatchVectorPlur.size() > 0) {
            for (int i = 0; i < patternMatchVectorPlur.size(); ++i) {
                Entity ourEntity = (Entity)patternMatchVectorPlur.elementAt(i);
                boolean hecho = this.executeAction(action, new Object[]{ourEntity});
                if (hecho) continue;
                this.ZR_verbo = this.command;
                this.commandQueue.removeAllElements();
                return true;
            }
            this.ZR_verbo = this.command;
            return true;
        }
        this.ZR_verbo = this.command;
        this.commandQueue.removeAllElements();
        return false;
    }
}

