/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.StringMethods;
import eu.irreality.age.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class NaturalLanguage {
    public static File ficheroVerbos = new File("lang" + File.separatorChar + "verbos.lan");
    public static File ficheroSinonimos = new File("lang" + File.separatorChar + "sinon.lan");
    public static File ficheroAlias = new File("lang" + File.separatorChar + "alias.lan");
    public static File ficheroVerbos32 = new File("lang" + File.separatorChar + "verbos32.lan");
    private Hashtable imperativoAInfinitivo;
    private Hashtable infinitivoAImperativo;
    private Hashtable sinonimos;
    private Hashtable alias;
    private Hashtable terceraASegunda;

    private Hashtable loadTableFromFile(File f, char separator) throws IOException, FileNotFoundException {
        return this.loadTableFromFile(f, separator, true);
    }

    private Hashtable loadInvertedTableFromFile(File f, char separator) throws IOException, FileNotFoundException {
        return this.loadInvertedTableFromFile(f, separator, true);
    }

    private Hashtable loadTableFromFile(File f, char separator, boolean dejarRepeticiones) throws IOException, FileNotFoundException {
        String linea;
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(f)));
        int nlineas = 0;
        while (filein.readLine() != null) {
            ++nlineas;
        }
        Hashtable<String, String> tabla = new Hashtable<String, String>((int)Math.round((double)nlineas * 1.5));
        filein = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(f)));
        while ((linea = filein.readLine()) != null) {
            String laClave = StringMethods.getTok(linea, 1, separator);
            String elValor = StringMethods.getTok(linea, 2, separator);
            if (dejarRepeticiones && tabla.get(laClave) != null) continue;
            tabla.put(laClave, elValor);
        }
        return tabla;
    }

    private Hashtable loadInvertedTableFromFile(File f, char separator, boolean dejarRepeticiones) throws IOException, FileNotFoundException {
        String linea;
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(f)));
        int nlineas = 0;
        while (filein.readLine() != null) {
            ++nlineas;
        }
        Hashtable<String, String> tabla = new Hashtable<String, String>((int)Math.round((double)nlineas * 1.5));
        filein = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(f)));
        while ((linea = filein.readLine()) != null) {
            String laClave = StringMethods.getTok(linea, 2, separator);
            String elValor = StringMethods.getTok(linea, 1, separator);
            if (dejarRepeticiones && tabla.get(laClave) != null) continue;
            tabla.put(laClave, elValor);
        }
        return tabla;
    }

    public NaturalLanguage() {
        try {
            this.imperativoAInfinitivo = this.loadTableFromFile(ficheroVerbos, '=');
            this.infinitivoAImperativo = this.loadInvertedTableFromFile(ficheroVerbos, '=', false);
        }
        catch (Exception exc) {
            System.out.println("Aviso: no se ha encontrado fichero de verbos, la tabla de verbos estar\u00e1 vac\u00eda.");
            this.imperativoAInfinitivo = new Hashtable(1);
        }
        try {
            this.sinonimos = this.loadTableFromFile(ficheroSinonimos, '=');
        }
        catch (Exception exc) {
            System.out.println("Aviso: no se ha encontrado fichero de sin\u00f3nimos, la tabla de sin\u00f3nimos estar\u00e1 vac\u00eda.");
            this.sinonimos = new Hashtable(1);
        }
        try {
            this.alias = this.loadTableFromFile(ficheroAlias, '=');
        }
        catch (Exception exc) {
            System.out.println("Aviso: no se ha encontrado fichero de alias, la tabla de alias estar\u00e1 vac\u00eda.");
            this.alias = new Hashtable(1);
        }
        try {
            this.terceraASegunda = this.loadTableFromFile(ficheroVerbos32, ' ');
        }
        catch (Exception exc) {
            System.out.println("Aviso: no se ha encontrado fichero de conjugaci\u00f3n en 2\u00aa persona, la tabla estar\u00e1 vac\u00eda.");
            this.terceraASegunda = new Hashtable(1);
        }
    }

    public String imperativoAInfinitivo(String presente) {
        return (String)this.imperativoAInfinitivo.get(presente.toLowerCase());
    }

    public String obtenerSinonimo(String palabra) {
        return (String)this.sinonimos.get(palabra.toLowerCase());
    }

    public String obtenerAlias(String palabra) {
        return (String)this.alias.get(palabra.toLowerCase());
    }

    public String sustituirSinonimos(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        String nueva = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String sin = this.obtenerSinonimo(tok);
            if (sin == null) {
                nueva = nueva + tok;
                continue;
            }
            nueva = nueva + sin;
        }
        return nueva;
    }

    public String sustituirVerbos(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        String nueva = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String sin = this.imperativoAInfinitivo(tok);
            if (sin == null) {
                nueva = nueva + tok;
                continue;
            }
            nueva = nueva + sin;
        }
        return nueva;
    }

    public String sustituirVerbo(String s) {
        StringTokenizer st = new StringTokenizer(s, " ", true);
        String nueva = "";
        int tokcnt = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            String sin = this.imperativoAInfinitivo(tok);
            nueva = sin == null || tokcnt > 0 ? nueva + tok : nueva + sin;
            ++tokcnt;
        }
        return nueva;
    }

    public boolean esVerboComando(String s) {
        return this.infinitivoAImperativo.get(s.toLowerCase().trim()) != null || this.imperativoAInfinitivo.get(s.toLowerCase().trim()) != null;
    }

    public String sustituirAlias(String s) {
        String al = this.obtenerAlias(s);
        if (al == null) {
            return s;
        }
        return al;
    }

    public String terceraASegunda(String verbo) {
        return (String)this.terceraASegunda.get(verbo.toLowerCase());
    }

    public String gramaticalizar(String s) {
        if (s == null) {
            return null;
        }
        String temp = StringMethods.textualSubstitution(StringMethods.textualSubstitution(s, " a el", " al"), " de el", " del");
        temp = temp.trim();
        if ((temp = Character.toUpperCase(temp.charAt(0)) + temp.substring(1)).charAt(temp.length() - 1) != '.') {
            temp = temp + ".";
        }
        return temp;
    }

    public String gramaticalizarSinTrimear(String s) {
        if (s == null) {
            return null;
        }
        String temp = StringMethods.textualSubstitution(StringMethods.textualSubstitution(s, " a el", " al"), " de el", " del");
        if ((temp = Character.toUpperCase(temp.charAt(0)) + temp.substring(1)).charAt(temp.length() - 1) != '\n' && temp.charAt(temp.length() - 1) != '.') {
            temp = temp + ".";
        }
        return temp;
    }
}

